package org.pdb.ormapping.util;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

import org.hibernate.HibernateException;
import org.hibernate.Session;

import org.pdb.derived.MetadataCategory;
import org.pdb.derived.MetadataItem;
;

/**
 * @author wayne
 */
public class RetrieverBuilder
{
	public static void main(String[] args)
	{
		if (args.length > 0)
		{
			generateRetrievers(args[0]);
		}
		else
		{
			String outputDir = "../webs/pdb/debug/retrievers/";
			generateRetrievers(outputDir);
			//System.err.println("Usage - output location not provided -
			// specify full path to retrievers folder.");
		}
	}


	public static void generateRetrievers(String outputDir)
	{
		StringBuffer sb = new StringBuffer();
		String aDef = null;
		Session s = null;
		try
		{
			s = HibernateUtils.getTestSession();
			List allMdcs = org.pdb.ormapping.util.Utils.getMetadataCategories();
			Iterator foo = allMdcs.iterator();
			while (foo.hasNext())
			{
				MetadataCategory mdc = (MetadataCategory) foo.next();
				if (!mdc.getClassName().startsWith("org.pdb.derived"))
				{
					sb.setLength(0);
					List items = mdc.getMetadataItems();
					aDef = mdc.getDescription().replace('\'', '`');
					aDef = aDef.replace('\"', '`');
					aDef = Utils.removeCrLf(aDef, "<BR>");
					sb.append("<b><a href=\"#\" title=\""	+ aDef + "\">" + mdc.getDisplayName() + "</a></b>\n");
					sb.append(
						"<display:table name=\"sessionScope."
							+ mdc.getDisplayName()
							+ "List\" sort=\"list\" pagesize=\"20\" export=\"true\">\n");
					ListIterator bar = items.listIterator();
					while (bar.hasNext())
					{
						MetadataItem mdi = (MetadataItem) bar.next();
						if (mdi.getDescription() != null)
						{
							aDef = mdi.getDescription().replace('\'', '`');
							aDef = aDef.replace('\"', '`');
							aDef = Utils.removeCrLf(aDef, "<BR>");
						}
						else
						{
							aDef = "";
						}
						sb.append(
							"\t<display:column property=\""
								+ mdi.getJavaName()
								+ "\" sortable=\"true\" headerClass=\"sortable\"/>\n");
					}
					sb.append("</display:table>\n");
					File of = new File(outputDir + mdc.getDisplayName() + ".jsp");
					System.err.println(of.getCanonicalFile());
					Writer wtr = new BufferedWriter(new FileWriter(of));
					wtr.write(sb.toString());
					wtr.flush();
					wtr.close();
				}
			}
		}
		catch (IOException e)
		{
			e.printStackTrace();
		}
		finally
		{
			try
			{
				s.close();
			}
			catch (HibernateException e1)
			{
				e1.printStackTrace();
			}
		}
	}

}
