package org.pdb.ormapping.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

/**
 * @author wayne
 */
public class StringFieldInfo
{

   public SingleFieldInfo getFieldInfo(String tableName, String fieldName)
   {
      return (SingleFieldInfo) lookupMap.get(tableName.toLowerCase() + "\t" + fieldName.toLowerCase());
   }

   public static class SingleFieldInfo
   {
      private String tableName;

      private String fieldName;

      private String fieldType;

      private int fieldLength;

      /**
       * @return
       */
      public int getFieldLength()
      {
         return fieldLength;
      }

      /**
       * @return
       */
      public String getFieldName()
      {
         return fieldName;
      }

      /**
       * @return
       */
      public String getFieldType()
      {
         return fieldType;
      }

      /**
       * @return
       */
      public String getTableName()
      {
         return tableName;
      }

      public SingleFieldInfo(String tableName, String fieldName, String fieldType, int fieldLength)
      {
         this.tableName = tableName;
         this.fieldName = fieldName;
         this.fieldType = fieldType;
         this.fieldLength = fieldLength;
      }

   }


   private static void addStringField(String tableName, String fieldName, String fieldType, int fieldLength)
   {
      // if (!fieldType.equalsIgnoreCase("char")) System.err.println(fieldType);
      SingleFieldInfo sfi = new SingleFieldInfo(tableName, fieldName, fieldType, fieldLength);
      lookupMap.put(tableName.toLowerCase() + "\t" + fieldName.toLowerCase(), sfi);
   }

   public static void main(String[] args)
   {
      StringFieldInfo me = new StringFieldInfo();
   }

   private static Map lookupMap = null;
   
   static
   {
      lookupMap = new HashMap();
      addStringField("atom_site", "auth_asym_id", "char", 10);
      addStringField("atom_site", "auth_atom_id", "char", 6);
      addStringField("atom_site", "auth_comp_id", "char", 10);
      addStringField("atom_site", "auth_seq_id", "char", 10);
      addStringField("atom_site", "group_PDB", "char", 10);
      addStringField("atom_site", "id", "char", 10);
      addStringField("atom_site", "label_alt_id", "char", 10);
      addStringField("atom_site", "label_asym_id", "char", 10);
      addStringField("atom_site", "label_atom_id", "char", 6);
      addStringField("atom_site", "label_comp_id", "char", 10);
      addStringField("atom_site", "label_entity_id", "char", 10);
      addStringField("atom_site", "pdbx_PDB_ins_code", "char", 10);
      addStringField("atom_site", "Structure_ID", "char", 10);
      addStringField("atom_site", "type_symbol", "char", 10);
      addStringField("atom_site_anisotrop", "id", "char", 10);
      addStringField("atom_site_anisotrop", "pdbx_auth_asym_id", "char", 10);
      addStringField("atom_site_anisotrop", "pdbx_auth_atom_id", "char", 6);
      addStringField("atom_site_anisotrop", "pdbx_auth_comp_id", "char", 10);
      addStringField("atom_site_anisotrop", "pdbx_auth_seq_id", "char", 10);
      addStringField("atom_site_anisotrop", "pdbx_label_alt_id", "char", 10);
      addStringField("atom_site_anisotrop", "pdbx_label_asym_id", "char", 10);
      addStringField("atom_site_anisotrop", "pdbx_label_atom_id", "char", 6);
      addStringField("atom_site_anisotrop", "pdbx_label_comp_id", "char", 10);
      addStringField("atom_site_anisotrop", "Structure_ID", "char", 10);
      addStringField("atom_site_anisotrop", "type_symbol", "char", 10);
      addStringField("atom_sites", "Cartn_transform_axes", "char", 200);
      addStringField("atom_sites", "entry_id", "char", 10);
      addStringField("atom_sites", "Structure_ID", "char", 10);
      addStringField("atom_sites_alt", "details", "char", 200);
      addStringField("atom_sites_alt", "id", "char", 10);
      addStringField("atom_sites_alt", "Structure_ID", "char", 10);
      addStringField("atom_sites_footnote", "id", "char", 10);
      addStringField("atom_sites_footnote", "Structure_ID", "char", 10);
      addStringField("atom_sites_footnote", "text", "text", 0);
      addStringField("atom_type", "Structure_ID", "char", 10);
      addStringField("atom_type", "symbol", "char", 10);
      addStringField("atom_type", "description", "char", 5000);
      addStringField("audit", "revision_id", "char", 10);
      addStringField("audit", "Structure_ID", "char", 10);
      addStringField("audit", "update_record", "char", 2000);
      addStringField("audit_author", "name", "char", 80);
      addStringField("audit_author", "Structure_ID", "char", 10);
      addStringField("audit_conform", "dict_location", "char", 200);
      addStringField("audit_conform", "dict_name", "char", 200);
      addStringField("audit_conform", "dict_version", "char", 200);
      addStringField("audit_conform", "Structure_ID", "char", 10);
      addStringField("cell", "entry_id", "char", 10);
      addStringField("cell", "pdbx_unique_axis", "char", 200);
      addStringField("cell", "Structure_ID", "char", 10);
      addStringField("chem_comp", "formula", "char", 200);
      addStringField("chem_comp", "id", "char", 10);
      addStringField("chem_comp", "name", "char", 500);
      addStringField("chem_comp", "pdbx_synonyms", "char", 512);
      addStringField("chem_comp", "pdbx_type", "char", 20);
      addStringField("chem_comp", "Structure_ID", "char", 10);
      addStringField("chem_comp", "type", "char", 80);
      addStringField("citation", "book_publisher", "char", 200);
      addStringField("citation", "country", "char", 80);
      addStringField("citation", "country_abbreviation_type_id", "char", 255);
      addStringField("citation", "id", "char", 10);
      addStringField("citation", "journal_abbrev", "char", 500);
      addStringField("citation", "journal_id_ASTM", "char", 80);
      addStringField("citation", "journal_id_CSD", "char", 80);
      addStringField("citation", "journal_id_ISSN", "char", 80);
      addStringField("citation", "journal_volume", "char", 80);
      addStringField("citation", "page_first", "char", 80);
      addStringField("citation", "page_last", "char", 80);
      addStringField("citation", "pdbx_author_list", "char", 500);
      addStringField("citation", "rcsb_database_id_PubMed", "char", 10);
      addStringField("citation", "Structure_ID", "char", 10);
      addStringField("citation", "title", "char", 2000);
      addStringField("citation_author", "citation_id", "char", 200);
      addStringField("citation_author", "name", "char", 80);
      addStringField("citation_author", "Structure_ID", "char", 10);
      addStringField("citation_editor", "citation_id", "char", 10);
      addStringField("citation_editor", "name", "char", 80);
      addStringField("citation_editor", "Structure_ID", "char", 10);
      addStringField("computing", "data_collection", "char", 500);
      addStringField("computing", "data_reduction", "char", 200);
      addStringField("computing", "entry_id", "char", 10);
      addStringField("computing", "pdbx_structure_refinement_method", "char", 200);
      addStringField("computing", "Structure_ID", "char", 10);
      addStringField("computing", "structure_refinement", "char", 1000);
      addStringField("computing", "structure_solution", "char", 200);
      addStringField("database", "code_CSD", "char", 80);
      addStringField("database", "entry_id", "char", 10);
      addStringField("database", "Structure_ID", "char", 10);
      addStringField("database_2", "database_code", "char", 80);
      addStringField("database_2", "database_id", "char", 10);
      addStringField("database_2", "Structure_ID", "char", 10);
      addStringField("database_PDB_caveat", "Structure_ID", "char", 10);
      addStringField("database_PDB_caveat", "text", "char", 200);
      addStringField("database_PDB_matrix", "entry_id", "char", 10);
      addStringField("database_PDB_matrix", "Structure_ID", "char", 10);
      addStringField("database_PDB_remark", "Structure_ID", "char", 10);
      addStringField("database_PDB_remark", "text", "text", 1000000);
      addStringField("database_PDB_rev", "replaces", "char", 80);
      addStringField("database_PDB_rev", "status", "char", 80);
      addStringField("database_PDB_rev", "Structure_ID", "char", 10);
      addStringField("database_PDB_rev_record", "details", "char", 200);
      addStringField("database_PDB_rev_record", "Structure_ID", "char", 10);
      addStringField("database_PDB_rev_record", "type", "char", 80);
      addStringField("database_PDB_tvect", "details", "char", 200);
      addStringField("database_PDB_tvect", "id", "char", 10);
      addStringField("database_PDB_tvect", "Structure_ID", "char", 10);
      addStringField("details", "details", "text", 0);
      addStringField("diffrn", "ambient_temp_details", "char", 200);
      addStringField("diffrn", "crystal_id", "char", 10);
      addStringField("diffrn", "id", "char", 10);
      addStringField("diffrn", "Structure_ID", "char", 10);
      addStringField("diffrn_detector", "details", "text", 0);
      addStringField("diffrn_detector", "detector", "char", 200);
      addStringField("diffrn_detector", "diffrn_id", "char", 10);
      addStringField("diffrn_detector", "Structure_ID", "char", 10);
      addStringField("diffrn_detector", "type", "text", 0);
      addStringField("diffrn_detector", "monochromator", "text", 0);
      addStringField("diffrn_radiation", "diffrn_id", "char", 10);
      addStringField("diffrn_radiation", "monochromator", "text", 0);
      addStringField("diffrn_radiation", "pdbx_diffrn_protocol", "char", 500);
      addStringField("diffrn_radiation", "pdbx_monochromatic_or_laue_m_l", "char", 10);
      addStringField("diffrn_radiation", "Structure_ID", "char", 10);
      addStringField("diffrn_radiation", "wavelength_id", "char", 10);
      addStringField("diffrn_radiation_wavelength", "id", "char", 10);
      addStringField("diffrn_radiation_wavelength", "Structure_ID", "char", 10);
      addStringField("diffrn_reflns_class", "description", "char", 5000);
      addStringField("diffrn_source", "diffrn_id", "char", 10);
      addStringField("diffrn_source", "pdbx_synchrotron_beamline", "char", 80);
      addStringField("diffrn_source", "pdbx_synchrotron_site", "text", 0);
      addStringField("diffrn_source", "pdbx_wavelength", "char", 80);
      addStringField("diffrn_source", "pdbx_wavelength_list", "char", 80);
      addStringField("diffrn_source", "source", "char", 200);
      addStringField("diffrn_source", "Structure_ID", "char", 10);
      addStringField("diffrn_source", "type", "char", 200);
      addStringField("em_2d_crystal_grow", "details", "text", 0);
      addStringField("em_3d_fitting", "details", "text", 0);
      addStringField("em_3d_fitting", "method", "text", 0);
      addStringField("em_3d_fitting", "ref_protocol", "text", 0);
      addStringField("em_3d_fitting", "target_criteria", "text", 0);
      addStringField("em_3d_reconstruction", "ctf_correction_method", "text", 0);
      addStringField("em_3d_reconstruction", "details", "text", 0);
      addStringField("em_3d_reconstruction", "magnification_calibration", "text", 0);
      addStringField("em_3d_reconstruction", "method", "text", 0);
      addStringField("em_3d_reconstruction", "resolution_method", "text", 0);
      addStringField("em_assembly", "details", "text", 0);
      addStringField("em_entity_assembly", "details", "text", 0);
      addStringField("em_imaging", "details", "text", 0);
      addStringField("em_vitrification", "details", "text", 0);
      addStringField("entity", "details", "text", 0);
      addStringField("entity", "id", "char", 10);
      addStringField("entity", "pdbx_description", "text", 0);
      addStringField("entity", "pdbx_ec", "char", 250);
      addStringField("entity", "pdbx_nonpoly_type", "char", 20);
      addStringField("entity", "src_method", "char", 10);
      addStringField("entity", "Structure_ID", "char", 10);
      addStringField("entity", "type", "char", 20);
      addStringField("entity_keywords", "entity_id", "char", 10);
      addStringField("entity_keywords", "pdbx_ec", "char", 80);
      addStringField("entity_keywords", "pdbx_fragment", "char", 200);
      addStringField("entity_keywords", "pdbx_mutation", "char", 80);
      addStringField("entity_keywords", "Structure_ID", "char", 10);
      addStringField("entity_keywords", "text", "char", 200);
      addStringField("entity_link", "details", "char", 200);
      addStringField("entity_link", "entity_id_1", "char", 10);
      addStringField("entity_link", "entity_id_2", "char", 10);
      addStringField("entity_link", "link_id", "char", 10);
      addStringField("entity_link", "Structure_ID", "char", 10);
      addStringField("entity_name_com", "entity_id", "char", 10);
      addStringField("entity_name_com", "name", "char", 1000);
      addStringField("entity_name_com", "Structure_ID", "char", 10);
      addStringField("entity_name_sys", "entity_id", "char", 10);
      addStringField("entity_name_sys", "name", "char", 200);
      addStringField("entity_name_sys", "Structure_ID", "char", 10);
      addStringField("entity_nonpoly", "comp_id", "char", 10);
      addStringField("entity_nonpoly", "entity_id", "char", 10);
      addStringField("entity_nonpoly", "name", "char", 512);
      addStringField("entity_nonpoly", "ndb_type", "char", 10);
      addStringField("entity_nonpoly", "Structure_ID", "char", 10);
      addStringField("entity_poly", "entity_id", "char", 10);
      addStringField("entity_poly", "pdbx_description", "char", 500);
      addStringField("entity_poly", "pdbx_PDB_chain_ids", "char", 200);
      addStringField("entity_poly", "pdbx_seq_one_letter_code", "text", 0);
      addStringField("entity_poly", "pdbx_seq_one_letter_code_can", "text", 0);
      addStringField("entity_poly", "Structure_ID", "char", 10);
      addStringField("entity_poly", "type", "char", 200);
      addStringField("entity_poly_seq", "entity_id", "char", 10);
      addStringField("entity_poly_seq", "mon_id", "char", 10);
      addStringField("entity_poly_seq", "Structure_ID", "char", 10);
      addStringField("entity_src_gen", "entity_id", "char", 10);
      addStringField("entity_src_gen", "gene_src_common_name", "char", 200);
      addStringField("entity_src_gen", "gene_src_genus", "char", 200);
      addStringField("entity_src_gen", "gene_src_species", "char", 200);
      addStringField("entity_src_gen", "gene_src_strain", "char", 4000);
      addStringField("entity_src_gen", "gene_src_tissue", "char", 200);
      addStringField("entity_src_gen", "gene_src_tissue_fraction", "char", 200);
      addStringField("entity_src_gen", "host_org_common_name", "char", 200);
      addStringField("entity_src_gen", "host_org_genus", "char", 200);
      addStringField("entity_src_gen", "host_org_species", "char", 200);
      addStringField("entity_src_gen", "pdbx_description", "char", 5000);
      addStringField("entity_src_gen", "pdbx_gene_src_atcc", "char", 200);
      addStringField("entity_src_gen", "pdbx_gene_src_cell", "char", 200);
      addStringField("entity_src_gen", "pdbx_gene_src_cell_line", "char", 200);
      addStringField("entity_src_gen", "pdbx_gene_src_cellular_location", "char", 200);
      addStringField("entity_src_gen", "pdbx_gene_src_fragment", "char", 200);
      addStringField("entity_src_gen", "pdbx_gene_src_gene", "char", 4000);
      addStringField("entity_src_gen", "pdbx_gene_src_organ", "char", 200);
      addStringField("entity_src_gen", "pdbx_gene_src_organelle", "char", 200);
      addStringField("entity_src_gen", "pdbx_gene_src_scientific_name", "char", 200);
      addStringField("entity_src_gen", "pdbx_gene_src_variant", "char", 200);
      addStringField("entity_src_gen", "pdbx_host_org_atcc", "char", 200);
      addStringField("entity_src_gen", "pdbx_host_org_cell", "char", 200);
      addStringField("entity_src_gen", "pdbx_host_org_cell_line", "char", 200);
      addStringField("entity_src_gen", "pdbx_host_org_cellular_location", "char", 200);
      addStringField("entity_src_gen", "pdbx_host_org_culture_collection", "char", 200);
      addStringField("entity_src_gen", "pdbx_host_org_gene", "char", 500);
      addStringField("entity_src_gen", "pdbx_host_org_organ", "char", 200);
      addStringField("entity_src_gen", "pdbx_host_org_organelle", "char", 200);
      addStringField("entity_src_gen", "pdbx_host_org_scientific_name", "char", 200);
      addStringField("entity_src_gen", "pdbx_host_org_strain", "char", 4000);
      addStringField("entity_src_gen", "pdbx_host_org_tissue", "char", 200);
      addStringField("entity_src_gen", "pdbx_host_org_tissue_fraction", "char", 200);
      addStringField("entity_src_gen", "pdbx_host_org_variant", "char", 200);
      addStringField("entity_src_gen", "pdbx_host_org_vector", "char", 500);
      addStringField("entity_src_gen", "pdbx_host_org_vector_type", "char", 200);
      addStringField("entity_src_gen", "plasmid_details", "char", 4000);
      addStringField("entity_src_gen", "plasmid_name", "char", 200);
      addStringField("entity_src_gen", "Structure_ID", "char", 10);
      addStringField("entity_src_nat", "common_name", "char", 200);
      addStringField("entity_src_nat", "details", "text", 0);
      addStringField("entity_src_nat", "entity_id", "char", 10);
      addStringField("entity_src_nat", "genus", "char", 200);
      addStringField("entity_src_nat", "pdbx_atcc", "char", 200);
      addStringField("entity_src_nat", "pdbx_cell", "char", 200);
      addStringField("entity_src_nat", "pdbx_cell_line", "char", 200);
      addStringField("entity_src_nat", "pdbx_cellular_location", "char", 200);
      addStringField("entity_src_nat", "pdbx_fragment", "char", 200);
      addStringField("entity_src_nat", "pdbx_organ", "char", 200);
      addStringField("entity_src_nat", "pdbx_organelle", "char", 200);
      addStringField("entity_src_nat", "pdbx_organism_scientific", "char", 200);
      addStringField("entity_src_nat", "pdbx_plasmid_details", "char", 200);
      addStringField("entity_src_nat", "pdbx_plasmid_name", "char", 200);
      addStringField("entity_src_nat", "pdbx_secretion", "char", 200);
      addStringField("entity_src_nat", "pdbx_variant", "char", 200);
      addStringField("entity_src_nat", "species", "char", 200);
      addStringField("entity_src_nat", "strain", "char", 4000);
      addStringField("entity_src_nat", "Structure_ID", "char", 10);
      addStringField("entity_src_nat", "tissue", "char", 200);
      addStringField("entity_src_nat", "tissue_fraction", "char", 200);
      addStringField("entry", "id", "char", 10);
      addStringField("entry", "Structure_ID", "char", 10);
      addStringField("exptl", "entry_id", "char", 10);
      addStringField("exptl", "method", "char", 80);
      addStringField("exptl", "Structure_ID", "char", 10);
      addStringField("exptl_crystal", "description", "char", 5000);
      addStringField("exptl_crystal", "id", "char", 10);
      addStringField("exptl_crystal", "Structure_ID", "char", 10);
      addStringField("exptl_crystal_grow", "crystal_id", "char", 10);
      addStringField("exptl_crystal_grow", "method", "char", 200);
      addStringField("exptl_crystal_grow", "pdbx_details", "text", 0);
      addStringField("exptl_crystal_grow", "pdbx_pH_range", "char", 80);
      addStringField("exptl_crystal_grow", "Structure_ID", "char", 10);
      addStringField("exptl_crystal_grow", "temp_details", "char", 200);
      addStringField("exptl_crystal_grow_comp", "conc", "char", 80);
      addStringField("exptl_crystal_grow_comp", "crystal_id", "char", 10);
      addStringField("exptl_crystal_grow_comp", "details", "char", 200);
      addStringField("exptl_crystal_grow_comp", "id", "char", 80);
      addStringField("exptl_crystal_grow_comp", "name", "char", 200);
      addStringField("exptl_crystal_grow_comp", "sol_id", "char", 80);
      addStringField("exptl_crystal_grow_comp", "Structure_ID", "char", 10);
      addStringField("exptl_crystal_grow_comp", "volume", "char", 80);
      addStringField("geom_angle", "atom_site_auth_asym_id_1", "char", 10);
      addStringField("geom_angle", "atom_site_auth_asym_id_2", "char", 10);
      addStringField("geom_angle", "atom_site_auth_asym_id_3", "char", 10);
      addStringField("geom_angle", "atom_site_auth_atom_id_1", "char", 6);
      addStringField("geom_angle", "atom_site_auth_atom_id_2", "char", 6);
      addStringField("geom_angle", "atom_site_auth_atom_id_3", "char", 6);
      addStringField("geom_angle", "atom_site_auth_comp_id_1", "char", 10);
      addStringField("geom_angle", "atom_site_auth_comp_id_2", "char", 10);
      addStringField("geom_angle", "atom_site_auth_comp_id_3", "char", 10);
      addStringField("geom_angle", "atom_site_auth_seq_id_1", "char", 10);
      addStringField("geom_angle", "atom_site_auth_seq_id_2", "char", 10);
      addStringField("geom_angle", "atom_site_auth_seq_id_3", "char", 10);
      addStringField("geom_angle", "atom_site_id_1", "char", 10);
      addStringField("geom_angle", "atom_site_id_2", "char", 10);
      addStringField("geom_angle", "atom_site_id_3", "char", 10);
      addStringField("geom_angle", "atom_site_label_alt_id_1", "char", 10);
      addStringField("geom_angle", "atom_site_label_alt_id_2", "char", 10);
      addStringField("geom_angle", "atom_site_label_alt_id_3", "char", 10);
      addStringField("geom_angle", "atom_site_label_asym_id_1", "char", 10);
      addStringField("geom_angle", "atom_site_label_asym_id_2", "char", 10);
      addStringField("geom_angle", "atom_site_label_asym_id_3", "char", 10);
      addStringField("geom_angle", "atom_site_label_atom_id_1", "char", 6);
      addStringField("geom_angle", "atom_site_label_atom_id_2", "char", 6);
      addStringField("geom_angle", "atom_site_label_atom_id_3", "char", 6);
      addStringField("geom_angle", "atom_site_label_comp_id_1", "char", 10);
      addStringField("geom_angle", "atom_site_label_comp_id_2", "char", 10);
      addStringField("geom_angle", "atom_site_label_comp_id_3", "char", 10);
      addStringField("geom_angle", "pdbx_atom_site_PDB_ins_code_1", "char", 10);
      addStringField("geom_angle", "pdbx_atom_site_PDB_ins_code_2", "char", 10);
      addStringField("geom_angle", "pdbx_atom_site_PDB_ins_code_3", "char", 10);
      addStringField("geom_angle", "site_symmetry_1", "char", 10);
      addStringField("geom_angle", "site_symmetry_2", "char", 10);
      addStringField("geom_angle", "site_symmetry_3", "char", 10);
      addStringField("geom_angle", "Structure_ID", "char", 10);
      addStringField("geom_bond", "atom_site_auth_asym_id_1", "char", 10);
      addStringField("geom_bond", "atom_site_auth_asym_id_2", "char", 10);
      addStringField("geom_bond", "atom_site_auth_atom_id_1", "char", 6);
      addStringField("geom_bond", "atom_site_auth_atom_id_2", "char", 6);
      addStringField("geom_bond", "atom_site_auth_comp_id_1", "char", 10);
      addStringField("geom_bond", "atom_site_auth_comp_id_2", "char", 10);
      addStringField("geom_bond", "atom_site_auth_seq_id_1", "char", 10);
      addStringField("geom_bond", "atom_site_auth_seq_id_2", "char", 10);
      addStringField("geom_bond", "atom_site_id_1", "char", 10);
      addStringField("geom_bond", "atom_site_id_2", "char", 10);
      addStringField("geom_bond", "atom_site_label_alt_id_1", "char", 10);
      addStringField("geom_bond", "atom_site_label_alt_id_2", "char", 10);
      addStringField("geom_bond", "atom_site_label_asym_id_1", "char", 10);
      addStringField("geom_bond", "atom_site_label_asym_id_2", "char", 10);
      addStringField("geom_bond", "atom_site_label_atom_id_1", "char", 6);
      addStringField("geom_bond", "atom_site_label_atom_id_2", "char", 6);
      addStringField("geom_bond", "atom_site_label_comp_id_1", "char", 10);
      addStringField("geom_bond", "atom_site_label_comp_id_2", "char", 10);
      addStringField("geom_bond", "pdbx_atom_site_PDB_ins_code_1", "char", 10);
      addStringField("geom_bond", "pdbx_atom_site_PDB_ins_code_2", "char", 10);
      addStringField("geom_bond", "site_symmetry_1", "char", 10);
      addStringField("geom_bond", "site_symmetry_2", "char", 10);
      addStringField("geom_bond", "Structure_ID", "char", 10);
      addStringField("geom_contact", "atom_site_auth_asym_id_1", "char", 10);
      addStringField("geom_contact", "atom_site_auth_asym_id_2", "char", 10);
      addStringField("geom_contact", "atom_site_auth_atom_id_1", "char", 6);
      addStringField("geom_contact", "atom_site_auth_atom_id_2", "char", 6);
      addStringField("geom_contact", "atom_site_auth_comp_id_1", "char", 10);
      addStringField("geom_contact", "atom_site_auth_comp_id_2", "char", 10);
      addStringField("geom_contact", "atom_site_auth_seq_id_1", "char", 10);
      addStringField("geom_contact", "atom_site_auth_seq_id_2", "char", 10);
      addStringField("geom_contact", "atom_site_id_1", "char", 10);
      addStringField("geom_contact", "atom_site_id_2", "char", 10);
      addStringField("geom_contact", "atom_site_label_alt_id_1", "char", 10);
      addStringField("geom_contact", "atom_site_label_alt_id_2", "char", 10);
      addStringField("geom_contact", "atom_site_label_asym_id_1", "char", 10);
      addStringField("geom_contact", "atom_site_label_asym_id_2", "char", 10);
      addStringField("geom_contact", "atom_site_label_atom_id_1", "char", 6);
      addStringField("geom_contact", "atom_site_label_atom_id_2", "char", 6);
      addStringField("geom_contact", "atom_site_label_comp_id_1", "char", 10);
      addStringField("geom_contact", "atom_site_label_comp_id_2", "char", 10);
      addStringField("geom_contact", "pdbx_atom_site_PDB_ins_code_1", "char", 10);
      addStringField("geom_contact", "pdbx_atom_site_PDB_ins_code_2", "char", 10);
      addStringField("geom_contact", "site_symmetry_1", "char", 10);
      addStringField("geom_contact", "site_symmetry_2", "char", 10);
      addStringField("geom_contact", "Structure_ID", "char", 10);
      addStringField("geom_torsion", "atom_site_auth_asym_id_1", "char", 10);
      addStringField("geom_torsion", "atom_site_auth_asym_id_2", "char", 10);
      addStringField("geom_torsion", "atom_site_auth_asym_id_3", "char", 10);
      addStringField("geom_torsion", "atom_site_auth_asym_id_4", "char", 10);
      addStringField("geom_torsion", "atom_site_auth_atom_id_1", "char", 6);
      addStringField("geom_torsion", "atom_site_auth_atom_id_2", "char", 6);
      addStringField("geom_torsion", "atom_site_auth_atom_id_3", "char", 6);
      addStringField("geom_torsion", "atom_site_auth_atom_id_4", "char", 6);
      addStringField("geom_torsion", "atom_site_auth_comp_id_1", "char", 10);
      addStringField("geom_torsion", "atom_site_auth_comp_id_2", "char", 10);
      addStringField("geom_torsion", "atom_site_auth_comp_id_3", "char", 10);
      addStringField("geom_torsion", "atom_site_auth_comp_id_4", "char", 10);
      addStringField("geom_torsion", "atom_site_auth_seq_id_1", "char", 10);
      addStringField("geom_torsion", "atom_site_auth_seq_id_2", "char", 10);
      addStringField("geom_torsion", "atom_site_auth_seq_id_3", "char", 10);
      addStringField("geom_torsion", "atom_site_auth_seq_id_4", "char", 10);
      addStringField("geom_torsion", "atom_site_id_1", "char", 10);
      addStringField("geom_torsion", "atom_site_id_2", "char", 10);
      addStringField("geom_torsion", "atom_site_id_3", "char", 10);
      addStringField("geom_torsion", "atom_site_id_4", "char", 10);
      addStringField("geom_torsion", "atom_site_label_alt_id_1", "char", 10);
      addStringField("geom_torsion", "atom_site_label_alt_id_2", "char", 10);
      addStringField("geom_torsion", "atom_site_label_alt_id_3", "char", 10);
      addStringField("geom_torsion", "atom_site_label_alt_id_4", "char", 10);
      addStringField("geom_torsion", "atom_site_label_asym_id_1", "char", 10);
      addStringField("geom_torsion", "atom_site_label_asym_id_2", "char", 10);
      addStringField("geom_torsion", "atom_site_label_asym_id_3", "char", 10);
      addStringField("geom_torsion", "atom_site_label_asym_id_4", "char", 10);
      addStringField("geom_torsion", "atom_site_label_atom_id_1", "char", 6);
      addStringField("geom_torsion", "atom_site_label_atom_id_2", "char", 6);
      addStringField("geom_torsion", "atom_site_label_atom_id_3", "char", 6);
      addStringField("geom_torsion", "atom_site_label_atom_id_4", "char", 6);
      addStringField("geom_torsion", "atom_site_label_comp_id_1", "char", 10);
      addStringField("geom_torsion", "atom_site_label_comp_id_2", "char", 10);
      addStringField("geom_torsion", "atom_site_label_comp_id_3", "char", 10);
      addStringField("geom_torsion", "atom_site_label_comp_id_4", "char", 10);
      addStringField("geom_torsion", "pdbx_atom_site_PDB_ins_code_1", "char", 10);
      addStringField("geom_torsion", "pdbx_atom_site_PDB_ins_code_2", "char", 10);
      addStringField("geom_torsion", "pdbx_atom_site_PDB_ins_code_3", "char", 10);
      addStringField("geom_torsion", "pdbx_atom_site_PDB_ins_code_4", "char", 10);
      addStringField("geom_torsion", "site_symmetry_1", "char", 10);
      addStringField("geom_torsion", "site_symmetry_2", "char", 10);
      addStringField("geom_torsion", "site_symmetry_3", "char", 10);
      addStringField("geom_torsion", "site_symmetry_4", "char", 10);
      addStringField("geom_torsion", "Structure_ID", "char", 10);
      addStringField("ndb_atlas", "entry_id", "char", 10);
      addStringField("ndb_atlas", "page_name", "char", 200);
      addStringField("ndb_atlas", "Structure_ID", "char", 10);
      addStringField("ndb_entity_func_bind_mode", "domain_id", "char", 80);
      addStringField("ndb_entity_func_bind_mode", "entity_id", "char", 10);
      addStringField("ndb_entity_func_bind_mode", "id", "char", 10);
      addStringField("ndb_entity_func_bind_mode", "protein_binds_to", "char", 10);
      addStringField("ndb_entity_func_bind_mode", "Structure_ID", "char", 10);
      addStringField("ndb_entity_func_bind_mode", "type", "char", 10);
      addStringField("ndb_entity_func_enzyme", "bind_mode_id", "char", 10);
      addStringField("ndb_entity_func_enzyme", "Structure_ID", "char", 10);
      addStringField("ndb_entity_func_enzyme", "type", "char", 80);
      addStringField("ndb_entity_func_other", "bind_mode_id", "char", 10);
      addStringField("ndb_entity_func_other", "Structure_ID", "char", 10);
      addStringField("ndb_entity_func_other", "type", "char", 80);
      addStringField("ndb_entity_func_regulatory", "bind_mode_id", "char", 10);
      addStringField("ndb_entity_func_regulatory", "Structure_ID", "char", 10);
      addStringField("ndb_entity_func_regulatory", "type", "char", 80);
      addStringField("ndb_entity_func_structural", "bind_mode_id", "char", 10);
      addStringField("ndb_entity_func_structural", "Structure_ID", "char", 10);
      addStringField("ndb_entity_func_structural", "type", "char", 80);
      addStringField("ndb_entity_poly_domain", "begin_mon_id", "char", 10);
      addStringField("ndb_entity_poly_domain", "end_mon_id", "char", 10);
      addStringField("ndb_entity_poly_domain", "entity_id", "char", 10);
      addStringField("ndb_entity_poly_domain", "id", "char", 80);
      addStringField("ndb_entity_poly_domain", "Structure_ID", "char", 10);
      addStringField("ndb_entity_poly_na_nonstandard", "entity_id", "char", 10);
      addStringField("ndb_entity_poly_na_nonstandard", "feature", "char", 80);
      addStringField("ndb_entity_poly_na_nonstandard", "Structure_ID", "char", 10);
      addStringField("ndb_entity_poly_na_type", "entity_id", "char", 10);
      addStringField("ndb_entity_poly_na_type", "Structure_ID", "char", 10);
      addStringField("ndb_entity_poly_na_type", "type", "char", 80);
      addStringField("ndb_na_struct_keywds", "conformation_type", "char", 200);
      addStringField("ndb_na_struct_keywds", "entry_id", "char", 10);
      addStringField("ndb_na_struct_keywds", "special_feature", "char", 200);
      addStringField("ndb_na_struct_keywds", "strand_description", "char", 200);
      addStringField("ndb_na_struct_keywds", "Structure_ID", "char", 10);
      addStringField("ndb_rms_devs_cov_by_monomer", "auth_asym_id", "char", 10);
      addStringField("ndb_rms_devs_cov_by_monomer", "auth_seq_id", "char", 10);
      addStringField("ndb_rms_devs_cov_by_monomer", "label_asym_id", "char", 10);
      addStringField("ndb_rms_devs_cov_by_monomer", "label_comp_id", "char", 10);
      addStringField("ndb_rms_devs_cov_by_monomer", "label_seq_id", "char", 10);
      addStringField("ndb_rms_devs_cov_by_monomer", "Structure_ID", "char", 10);
      addStringField("ndb_rms_devs_covalent", "entry_id", "char", 10);
      addStringField("ndb_rms_devs_covalent", "Structure_ID", "char", 10);
      addStringField("ndb_sequence_pattern", "auth_asym_id", "char", 10);
      addStringField("ndb_sequence_pattern", "label_asym_id", "char", 10);
      addStringField("ndb_sequence_pattern", "sequence_pattern", "char", 10);
      addStringField("ndb_sequence_pattern", "Structure_ID", "char", 10);
      addStringField("ndb_stereochemistry", "auth_asym_id", "char", 10);
      addStringField("ndb_stereochemistry", "auth_seq_id", "char", 10);
      addStringField("ndb_stereochemistry", "label_alt_id", "char", 10);
      addStringField("ndb_stereochemistry", "label_alt_id_u", "char", 10);
      addStringField("ndb_stereochemistry", "label_alt_id_v", "char", 10);
      addStringField("ndb_stereochemistry", "label_alt_id_w", "char", 10);
      addStringField("ndb_stereochemistry", "label_asym_id", "char", 10);
      addStringField("ndb_stereochemistry", "label_atom_id", "char", 10);
      addStringField("ndb_stereochemistry", "label_atom_id_u", "char", 10);
      addStringField("ndb_stereochemistry", "label_atom_id_v", "char", 10);
      addStringField("ndb_stereochemistry", "label_atom_id_w", "char", 10);
      addStringField("ndb_stereochemistry", "label_comp_id", "char", 10);
      addStringField("ndb_stereochemistry", "label_seq_id", "char", 10);
      addStringField("ndb_stereochemistry", "Structure_ID", "char", 10);
      addStringField("ndb_struct_conf_na", "entry_id", "char", 10);
      addStringField("ndb_struct_conf_na", "feature", "char", 80);
      addStringField("ndb_struct_conf_na", "Structure_ID", "char", 10);
      addStringField("ndb_struct_feature_na", "entry_id", "char", 10);
      addStringField("ndb_struct_feature_na", "feature", "char", 80);
      addStringField("ndb_struct_feature_na", "Structure_ID", "char", 10);
      addStringField("ndb_struct_na_base_pair", "i_auth_asym_id", "char", 10);
      addStringField("ndb_struct_na_base_pair", "i_auth_seq_id", "char", 10);
      addStringField("ndb_struct_na_base_pair", "i_label_asym_id", "char", 10);
      addStringField("ndb_struct_na_base_pair", "i_label_comp_id", "char", 10);
      addStringField("ndb_struct_na_base_pair", "i_PDB_ins_code", "char", 10);
      addStringField("ndb_struct_na_base_pair", "i_symmetry", "char", 10);
      addStringField("ndb_struct_na_base_pair", "j_auth_asym_id", "char", 10);
      addStringField("ndb_struct_na_base_pair", "j_auth_seq_id", "char", 10);
      addStringField("ndb_struct_na_base_pair", "j_label_asym_id", "char", 10);
      addStringField("ndb_struct_na_base_pair", "j_label_comp_id", "char", 10);
      addStringField("ndb_struct_na_base_pair", "j_PDB_ins_code", "char", 10);
      addStringField("ndb_struct_na_base_pair", "j_symmetry", "char", 10);
      addStringField("ndb_struct_na_base_pair", "pair_name", "char", 80);
      addStringField("ndb_struct_na_base_pair", "Structure_ID", "char", 10);
      addStringField("ndb_struct_na_base_pair_step", "i_auth_asym_id_1", "char", 10);
      addStringField("ndb_struct_na_base_pair_step", "i_auth_asym_id_2", "char", 10);
      addStringField("ndb_struct_na_base_pair_step", "i_auth_seq_id_1", "char", 10);
      addStringField("ndb_struct_na_base_pair_step", "i_auth_seq_id_2", "char", 10);
      addStringField("ndb_struct_na_base_pair_step", "i_label_asym_id_1", "char", 10);
      addStringField("ndb_struct_na_base_pair_step", "i_label_asym_id_2", "char", 10);
      addStringField("ndb_struct_na_base_pair_step", "i_label_comp_id_1", "char", 10);
      addStringField("ndb_struct_na_base_pair_step", "i_label_comp_id_2", "char", 10);
      addStringField("ndb_struct_na_base_pair_step", "i_PDB_ins_code_1", "char", 10);
      addStringField("ndb_struct_na_base_pair_step", "i_PDB_ins_code_2", "char", 10);
      addStringField("ndb_struct_na_base_pair_step", "i_symmetry_1", "char", 10);
      addStringField("ndb_struct_na_base_pair_step", "i_symmetry_2", "char", 10);
      addStringField("ndb_struct_na_base_pair_step", "j_auth_asym_id_1", "char", 10);
      addStringField("ndb_struct_na_base_pair_step", "j_auth_asym_id_2", "char", 10);
      addStringField("ndb_struct_na_base_pair_step", "j_auth_seq_id_1", "char", 10);
      addStringField("ndb_struct_na_base_pair_step", "j_auth_seq_id_2", "char", 10);
      addStringField("ndb_struct_na_base_pair_step", "j_label_asym_id_1", "char", 10);
      addStringField("ndb_struct_na_base_pair_step", "j_label_asym_id_2", "char", 10);
      addStringField("ndb_struct_na_base_pair_step", "j_label_comp_id_1", "char", 10);
      addStringField("ndb_struct_na_base_pair_step", "j_label_comp_id_2", "char", 10);
      addStringField("ndb_struct_na_base_pair_step", "j_PDB_ins_code_1", "char", 10);
      addStringField("ndb_struct_na_base_pair_step", "j_PDB_ins_code_2", "char", 10);
      addStringField("ndb_struct_na_base_pair_step", "j_symmetry_1", "char", 10);
      addStringField("ndb_struct_na_base_pair_step", "j_symmetry_2", "char", 10);
      addStringField("ndb_struct_na_base_pair_step", "step_name", "char", 80);
      addStringField("ndb_struct_na_base_pair_step", "Structure_ID", "char", 10);
      addStringField("ndb_sugar_phosphate_geometry", "auth_asym_id", "char", 10);
      addStringField("ndb_sugar_phosphate_geometry", "auth_seq_id", "char", 10);
      addStringField("ndb_sugar_phosphate_geometry", "label_asym_id", "char", 10);
      addStringField("ndb_sugar_phosphate_geometry", "label_comp_id", "char", 10);
      addStringField("ndb_sugar_phosphate_geometry", "label_seq_id", "char", 10);
      addStringField("ndb_sugar_phosphate_geometry", "next_label_comp_id", "char", 10);
      addStringField("ndb_sugar_phosphate_geometry", "next_label_seq_id", "char", 10);
      addStringField("ndb_sugar_phosphate_geometry", "Structure_ID", "char", 10);
      addStringField("ndb_summary_flags", "entry_id", "char", 10);
      addStringField("ndb_summary_flags", "flag_id", "char", 80);
      addStringField("ndb_summary_flags", "flag_value", "char", 10);
      addStringField("ndb_summary_flags", "Structure_ID", "char", 10);
      addStringField("ndb_virtual_angle", "atom_site_auth_asym_id_1", "char", 10);
      addStringField("ndb_virtual_angle", "atom_site_auth_asym_id_2", "char", 10);
      addStringField("ndb_virtual_angle", "atom_site_auth_asym_id_3", "char", 10);
      addStringField("ndb_virtual_angle", "atom_site_auth_atom_id_1", "char", 10);
      addStringField("ndb_virtual_angle", "atom_site_auth_atom_id_2", "char", 10);
      addStringField("ndb_virtual_angle", "atom_site_auth_atom_id_3", "char", 10);
      addStringField("ndb_virtual_angle", "atom_site_auth_comp_id_1", "char", 10);
      addStringField("ndb_virtual_angle", "atom_site_auth_comp_id_2", "char", 10);
      addStringField("ndb_virtual_angle", "atom_site_auth_comp_id_3", "char", 10);
      addStringField("ndb_virtual_angle", "atom_site_auth_seq_id_1", "char", 10);
      addStringField("ndb_virtual_angle", "atom_site_auth_seq_id_2", "char", 10);
      addStringField("ndb_virtual_angle", "atom_site_auth_seq_id_3", "char", 10);
      addStringField("ndb_virtual_angle", "atom_site_id_1", "char", 10);
      addStringField("ndb_virtual_angle", "atom_site_id_2", "char", 10);
      addStringField("ndb_virtual_angle", "atom_site_id_3", "char", 10);
      addStringField("ndb_virtual_angle", "atom_site_label_alt_id_1", "char", 10);
      addStringField("ndb_virtual_angle", "atom_site_label_alt_id_2", "char", 10);
      addStringField("ndb_virtual_angle", "atom_site_label_alt_id_3", "char", 10);
      addStringField("ndb_virtual_angle", "atom_site_label_asym_id_1", "char", 10);
      addStringField("ndb_virtual_angle", "atom_site_label_asym_id_2", "char", 10);
      addStringField("ndb_virtual_angle", "atom_site_label_asym_id_3", "char", 10);
      addStringField("ndb_virtual_angle", "atom_site_label_atom_id_1", "char", 10);
      addStringField("ndb_virtual_angle", "atom_site_label_atom_id_2", "char", 10);
      addStringField("ndb_virtual_angle", "atom_site_label_atom_id_3", "char", 10);
      addStringField("ndb_virtual_angle", "atom_site_label_comp_id_1", "char", 10);
      addStringField("ndb_virtual_angle", "atom_site_label_comp_id_2", "char", 10);
      addStringField("ndb_virtual_angle", "atom_site_label_comp_id_3", "char", 10);
      addStringField("ndb_virtual_angle", "atom_site_label_seq_id_1", "char", 10);
      addStringField("ndb_virtual_angle", "atom_site_label_seq_id_2", "char", 10);
      addStringField("ndb_virtual_angle", "atom_site_label_seq_id_3", "char", 10);
      addStringField("ndb_virtual_angle", "site_symmetry_1", "char", 10);
      addStringField("ndb_virtual_angle", "site_symmetry_2", "char", 10);
      addStringField("ndb_virtual_angle", "site_symmetry_3", "char", 10);
      addStringField("ndb_virtual_angle", "Structure_ID", "char", 10);
      addStringField("ndb_virtual_bond", "atom_site_auth_asym_id_1", "char", 10);
      addStringField("ndb_virtual_bond", "atom_site_auth_asym_id_2", "char", 10);
      addStringField("ndb_virtual_bond", "atom_site_auth_atom_id_1", "char", 10);
      addStringField("ndb_virtual_bond", "atom_site_auth_atom_id_2", "char", 10);
      addStringField("ndb_virtual_bond", "atom_site_auth_comp_id_1", "char", 10);
      addStringField("ndb_virtual_bond", "atom_site_auth_comp_id_2", "char", 10);
      addStringField("ndb_virtual_bond", "atom_site_auth_seq_id_1", "char", 10);
      addStringField("ndb_virtual_bond", "atom_site_auth_seq_id_2", "char", 10);
      addStringField("ndb_virtual_bond", "atom_site_id_1", "char", 10);
      addStringField("ndb_virtual_bond", "atom_site_id_2", "char", 10);
      addStringField("ndb_virtual_bond", "atom_site_label_alt_id_1", "char", 10);
      addStringField("ndb_virtual_bond", "atom_site_label_alt_id_2", "char", 10);
      addStringField("ndb_virtual_bond", "atom_site_label_asym_id_1", "char", 10);
      addStringField("ndb_virtual_bond", "atom_site_label_asym_id_2", "char", 10);
      addStringField("ndb_virtual_bond", "atom_site_label_atom_id_1", "char", 10);
      addStringField("ndb_virtual_bond", "atom_site_label_atom_id_2", "char", 10);
      addStringField("ndb_virtual_bond", "atom_site_label_comp_id_1", "char", 10);
      addStringField("ndb_virtual_bond", "atom_site_label_comp_id_2", "char", 10);
      addStringField("ndb_virtual_bond", "atom_site_label_seq_id_1", "char", 10);
      addStringField("ndb_virtual_bond", "atom_site_label_seq_id_2", "char", 10);
      addStringField("ndb_virtual_bond", "site_symmetry_1", "char", 10);
      addStringField("ndb_virtual_bond", "site_symmetry_2", "char", 10);
      addStringField("ndb_virtual_bond", "Structure_ID", "char", 10);
      addStringField("ndb_virtual_torsion", "atom_site_auth_asym_id_1", "char", 10);
      addStringField("ndb_virtual_torsion", "atom_site_auth_asym_id_2", "char", 10);
      addStringField("ndb_virtual_torsion", "atom_site_auth_asym_id_3", "char", 10);
      addStringField("ndb_virtual_torsion", "atom_site_auth_asym_id_4", "char", 10);
      addStringField("ndb_virtual_torsion", "atom_site_auth_atom_id_1", "char", 10);
      addStringField("ndb_virtual_torsion", "atom_site_auth_atom_id_2", "char", 10);
      addStringField("ndb_virtual_torsion", "atom_site_auth_atom_id_3", "char", 10);
      addStringField("ndb_virtual_torsion", "atom_site_auth_atom_id_4", "char", 10);
      addStringField("ndb_virtual_torsion", "atom_site_auth_comp_id_1", "char", 10);
      addStringField("ndb_virtual_torsion", "atom_site_auth_comp_id_2", "char", 10);
      addStringField("ndb_virtual_torsion", "atom_site_auth_comp_id_3", "char", 10);
      addStringField("ndb_virtual_torsion", "atom_site_auth_comp_id_4", "char", 10);
      addStringField("ndb_virtual_torsion", "atom_site_auth_seq_id_1", "char", 10);
      addStringField("ndb_virtual_torsion", "atom_site_auth_seq_id_2", "char", 10);
      addStringField("ndb_virtual_torsion", "atom_site_auth_seq_id_3", "char", 10);
      addStringField("ndb_virtual_torsion", "atom_site_auth_seq_id_4", "char", 10);
      addStringField("ndb_virtual_torsion", "atom_site_id_1", "char", 10);
      addStringField("ndb_virtual_torsion", "atom_site_id_2", "char", 10);
      addStringField("ndb_virtual_torsion", "atom_site_id_3", "char", 10);
      addStringField("ndb_virtual_torsion", "atom_site_id_4", "char", 10);
      addStringField("ndb_virtual_torsion", "atom_site_label_alt_id_1", "char", 10);
      addStringField("ndb_virtual_torsion", "atom_site_label_alt_id_2", "char", 10);
      addStringField("ndb_virtual_torsion", "atom_site_label_alt_id_3", "char", 10);
      addStringField("ndb_virtual_torsion", "atom_site_label_alt_id_4", "char", 10);
      addStringField("ndb_virtual_torsion", "atom_site_label_asym_id_1", "char", 10);
      addStringField("ndb_virtual_torsion", "atom_site_label_asym_id_2", "char", 10);
      addStringField("ndb_virtual_torsion", "atom_site_label_asym_id_3", "char", 10);
      addStringField("ndb_virtual_torsion", "atom_site_label_asym_id_4", "char", 10);
      addStringField("ndb_virtual_torsion", "atom_site_label_atom_id_1", "char", 10);
      addStringField("ndb_virtual_torsion", "atom_site_label_atom_id_2", "char", 10);
      addStringField("ndb_virtual_torsion", "atom_site_label_atom_id_3", "char", 10);
      addStringField("ndb_virtual_torsion", "atom_site_label_atom_id_4", "char", 10);
      addStringField("ndb_virtual_torsion", "atom_site_label_comp_id_1", "char", 10);
      addStringField("ndb_virtual_torsion", "atom_site_label_comp_id_2", "char", 10);
      addStringField("ndb_virtual_torsion", "atom_site_label_comp_id_3", "char", 10);
      addStringField("ndb_virtual_torsion", "atom_site_label_comp_id_4", "char", 10);
      addStringField("ndb_virtual_torsion", "atom_site_label_seq_id_1", "char", 10);
      addStringField("ndb_virtual_torsion", "atom_site_label_seq_id_2", "char", 10);
      addStringField("ndb_virtual_torsion", "atom_site_label_seq_id_3", "char", 10);
      addStringField("ndb_virtual_torsion", "atom_site_label_seq_id_4", "char", 10);
      addStringField("ndb_virtual_torsion", "site_symmetry_1", "char", 10);
      addStringField("ndb_virtual_torsion", "site_symmetry_2", "char", 10);
      addStringField("ndb_virtual_torsion", "site_symmetry_3", "char", 10);
      addStringField("ndb_virtual_torsion", "site_symmetry_4", "char", 10);
      addStringField("ndb_virtual_torsion", "Structure_ID", "char", 10);
      addStringField("pdbx_chem_comp_descriptor", "descriptor", "char", 3000);
      addStringField("pdbx_chem_comp_identifier", "identifier", "char", 3000);
      addStringField("pdbx_database_PDB_obs_spr", "id", "char", 10);
      addStringField("pdbx_database_PDB_obs_spr", "pdb_id", "char", 200);
      addStringField("pdbx_database_PDB_obs_spr", "replace_pdb_id", "char", 200);
      addStringField("pdbx_database_PDB_obs_spr", "Structure_ID", "char", 10);
      addStringField("pdbx_database_related", "db_id", "char", 80);
      addStringField("pdbx_database_related", "db_name", "char", 10);
      addStringField("pdbx_database_related", "details", "text", 0);
      addStringField("pdbx_database_related", "Structure_ID", "char", 10);
      addStringField("pdbx_database_remark", "text", "text", 0);
      addStringField("pdbx_database_status", "author_approval_type", "char", 10);
      addStringField("pdbx_database_status", "author_release_status_code", "char", 10);
      addStringField("pdbx_database_status", "dep_release_code_coordinates", "char", 80);
      addStringField("pdbx_database_status", "dep_release_code_nmr_constraints", "char", 80);
      addStringField("pdbx_database_status", "dep_release_code_sequence", "char", 80);
      addStringField("pdbx_database_status", "dep_release_code_struct_fact", "char", 80);
      addStringField("pdbx_database_status", "deposit_site", "char", 10);
      addStringField("pdbx_database_status", "entry_id", "char", 10);
      addStringField("pdbx_database_status", "hold_for_publication", "char", 2);
      addStringField("pdbx_database_status", "name_depositor", "char", 200);
      addStringField("pdbx_database_status", "process_site", "char", 10);
      addStringField("pdbx_database_status", "rcsb_annotator", "char", 10);
      addStringField("pdbx_database_status", "recvd_author_approval", "char", 2);
      addStringField("pdbx_database_status", "recvd_coordinates", "char", 2);
      addStringField("pdbx_database_status", "recvd_deposit_form", "char", 2);
      addStringField("pdbx_database_status", "recvd_internal_approval", "char", 2);
      addStringField("pdbx_database_status", "recvd_manuscript", "char", 2);
      addStringField("pdbx_database_status", "recvd_nmr_constraints", "char", 2);
      addStringField("pdbx_database_status", "recvd_struct_fact", "char", 2);
      addStringField("pdbx_database_status", "status_code", "char", 10);
      addStringField("pdbx_database_status", "Structure_ID", "char", 10);
      addStringField("pdbx_entity_name", "entity_id", "char", 10);
      addStringField("pdbx_entity_name", "name", "text", 0);
      addStringField("pdbx_entity_name", "name_type", "char", 80);
      addStringField("pdbx_entity_name", "Structure_ID", "char", 10);
      addStringField("pdbx_entity_nonpoly", "name", "text", 0);
      addStringField("pdbx_entity_src_syn", "details", "text", 0);
      addStringField("pdbx_entity_src_syn", "entity_id", "char", 10);
      addStringField("pdbx_entity_src_syn", "Structure_ID", "char", 10);
      addStringField("pdbx_nmr_constraints", "entry_id", "char", 10);
      addStringField("pdbx_nmr_constraints", "NOE_interproton_distance_evaluation", "char", 200);
      addStringField("pdbx_nmr_constraints", "NOE_motional_averaging_correction", "char", 200);
      addStringField("pdbx_nmr_constraints", "NOE_pseudoatom_corrections", "char", 200);
      addStringField("pdbx_nmr_constraints", "Structure_ID", "char", 10);
      addStringField("pdbx_nmr_details", "entry_id", "char", 10);
      addStringField("pdbx_nmr_details", "Structure_ID", "char", 10);
      addStringField("pdbx_nmr_details", "text", "text", 0);
      addStringField("pdbx_nmr_ensemble", "conformer_selection_criteria", "text", 0);
      addStringField("pdbx_nmr_ensemble", "distance_constraint_violation_method", "text", 0);
      addStringField("pdbx_nmr_ensemble", "entry_id", "char", 10);
      addStringField("pdbx_nmr_ensemble", "Structure_ID", "char", 10);
      addStringField("pdbx_nmr_ensemble", "torsion_angle_constraint_violation_method", "char", 200);
      addStringField("pdbx_nmr_ensemble_rms", "atom_type", "char", 80);
      addStringField("pdbx_nmr_ensemble_rms", "chain_range_begin", "char", 10);
      addStringField("pdbx_nmr_ensemble_rms", "chain_range_end", "char", 10);
      addStringField("pdbx_nmr_ensemble_rms", "coord_average_rmsd_method", "char", 200);
      addStringField("pdbx_nmr_ensemble_rms", "entry_id", "char", 10);
      addStringField("pdbx_nmr_ensemble_rms", "Structure_ID", "char", 10);
      addStringField("pdbx_nmr_exptl", "conditions_id", "char", 10);
      addStringField("pdbx_nmr_exptl", "experiment_id", "char", 10);
      addStringField("pdbx_nmr_exptl", "solution_id", "char", 10);
      addStringField("pdbx_nmr_exptl", "Structure_ID", "char", 10);
      addStringField("pdbx_nmr_exptl", "type", "char", 1000);
      addStringField("pdbx_nmr_exptl_sample", "component", "char", 80);
      addStringField("pdbx_nmr_exptl_sample", "concentration_units", "char", 10);
      addStringField("pdbx_nmr_exptl_sample", "isotopic_labeling", "char", 80);
      addStringField("pdbx_nmr_exptl_sample", "solution_id", "char", 10);
      addStringField("pdbx_nmr_exptl_sample", "Structure_ID", "char", 10);
      addStringField("pdbx_nmr_exptl_sample_conditions", "conditions_id", "char", 10);
      addStringField("pdbx_nmr_exptl_sample_conditions", "ionic_strength", "char", 200);
      addStringField("pdbx_nmr_exptl_sample_conditions", "pH", "char", 80);
      addStringField("pdbx_nmr_exptl_sample_conditions", "pressure", "char", 80);
      addStringField("pdbx_nmr_exptl_sample_conditions", "pressure_units", "char", 200);
      addStringField("pdbx_nmr_exptl_sample_conditions", "Structure_ID", "char", 10);
      addStringField("pdbx_nmr_exptl_sample_conditions", "temperature", "char", 80);
      addStringField("pdbx_nmr_force_constants", "covalent_geom_angles_term_units", "char", 10);
      addStringField("pdbx_nmr_force_constants", "covalent_geom_bond_term_units", "char", 10);
      addStringField("pdbx_nmr_force_constants", "covalent_geom_impropers_term_units", "char", 10);
      addStringField("pdbx_nmr_force_constants", "entry_id", "char", 10);
      addStringField("pdbx_nmr_force_constants", "exptl_13C_shift_term_units", "char", 10);
      addStringField("pdbx_nmr_force_constants", "exptl_1H_shift_term_units", "char", 10);
      addStringField("pdbx_nmr_force_constants", "exptl_D_isotope_shift_term_units", "char", 10);
      addStringField("pdbx_nmr_force_constants", "exptl_dipolar_coupling_term_units", "char", 10);
      addStringField("pdbx_nmr_force_constants", "exptl_distance_term_units", "char", 10);
      addStringField("pdbx_nmr_force_constants", "exptl_J_coupling_term_units", "char", 10);
      addStringField("pdbx_nmr_force_constants", "exptl_torsion_angles_term_units", "char", 10);
      addStringField("pdbx_nmr_force_constants", "non-bonded_inter_radius_of_gyration_term_units", "char", 10);
      addStringField("pdbx_nmr_force_constants", "non-bonded_inter_van_der_Waals_term_type", "char", 200);
      addStringField("pdbx_nmr_force_constants", "non-bonded_inter_van_der_Waals_term_units", "char", 10);
      addStringField("pdbx_nmr_force_constants", "Structure_ID", "char", 10);
      addStringField("pdbx_nmr_refine", "details", "text", 0);
      addStringField("pdbx_nmr_refine", "entry_id", "char", 10);
      addStringField("pdbx_nmr_refine", "method", "char", 2000);
      addStringField("pdbx_nmr_refine", "Structure_ID", "char", 10);
      addStringField("pdbx_nmr_representative", "entry_id", "char", 10);
      addStringField("pdbx_nmr_representative", "selection_criteria", "text", 0);
      addStringField("pdbx_nmr_representative", "Structure_ID", "char", 10);
      addStringField("pdbx_nmr_sample_details", "contents", "text", 0);
      addStringField("pdbx_nmr_sample_details", "solution_id", "char", 10);
      addStringField("pdbx_nmr_sample_details", "solvent_system", "text", 0);
      addStringField("pdbx_nmr_sample_details", "Structure_ID", "char", 10);
      addStringField("pdbx_nmr_software", "authors", "char", 512);
      addStringField("pdbx_nmr_software", "classification", "char", 80);
      addStringField("pdbx_nmr_software", "name", "char", 2000);
      addStringField("pdbx_nmr_software", "Structure_ID", "char", 10);
      addStringField("pdbx_nmr_software", "version", "char", 200);
      addStringField("pdbx_nmr_spectrometer", "manufacturer", "char", 80);
      addStringField("pdbx_nmr_spectrometer", "model", "char", 80);
      addStringField("pdbx_nmr_spectrometer", "spectrometer_id", "char", 10);
      addStringField("pdbx_nmr_spectrometer", "Structure_ID", "char", 10);
      addStringField("pdbx_nmr_spectrometer", "type", "char", 80);
      addStringField("pdbx_poly_seq_scheme", "asym_id", "char", 10);
      addStringField("pdbx_poly_seq_scheme", "auth_mon_id", "char", 10);
      addStringField("pdbx_poly_seq_scheme", "auth_seq_num", "char", 10);
      addStringField("pdbx_poly_seq_scheme", "entity_id", "char", 10);
      addStringField("pdbx_poly_seq_scheme", "mon_id", "char", 10);
      addStringField("pdbx_poly_seq_scheme", "pdb_mon_id", "char", 10);
      addStringField("pdbx_poly_seq_scheme", "pdb_seq_num", "char", 10);
      addStringField("pdbx_poly_seq_scheme", "pdb_strand_id", "char", 10);
      addStringField("pdbx_poly_seq_scheme", "Structure_ID", "char", 10);
      addStringField("pdbx_prerelease_seq", "entity_id", "char", 10);
      addStringField("pdbx_prerelease_seq", "seq_one_letter_code", "text", 0);
      addStringField("pdbx_prerelease_seq", "Structure_ID", "char", 10);
      addStringField("pdbx_refine", "entry_id", "char", 10);
      addStringField("pdbx_refine", "Structure_ID", "char", 10);
      addStringField("pdbx_refine_tls", "details", "char", 200);
      addStringField("pdbx_refine_tls", "id", "char", 10);
      addStringField("pdbx_refine_tls", "method", "char", 10);
      addStringField("pdbx_refine_tls", "Structure_ID", "char", 10);
      addStringField("pdbx_refine_tls_group", "beg_label_asym_id", "char", 10);
      addStringField("pdbx_refine_tls_group", "end_auth_seq_id", "char", 10);
      addStringField("pdbx_refine_tls_group", "end_label_asym_id", "char", 10);
      addStringField("pdbx_refine_tls_group", "id", "char", 10);
      addStringField("pdbx_refine_tls_group", "refine_tls_id", "char", 10);
      addStringField("pdbx_refine_tls_group", "selection", "char", 10);
      addStringField("pdbx_refine_tls_group", "Structure_ID", "char", 10);
      addStringField("pdbx_struct_sheet_hbond", "range_1_auth_asym_id", "char", 10);
      addStringField("pdbx_struct_sheet_hbond", "range_1_auth_atom_id", "char", 6);
      addStringField("pdbx_struct_sheet_hbond", "range_1_auth_comp_id", "char", 10);
      addStringField("pdbx_struct_sheet_hbond", "range_1_auth_seq_id", "char", 10);
      addStringField("pdbx_struct_sheet_hbond", "range_1_label_asym_id", "char", 10);
      addStringField("pdbx_struct_sheet_hbond", "range_1_label_atom_id", "char", 6);
      addStringField("pdbx_struct_sheet_hbond", "range_1_label_comp_id", "char", 10);
      addStringField("pdbx_struct_sheet_hbond", "range_1_PDB_ins_code", "char", 10);
      addStringField("pdbx_struct_sheet_hbond", "range_2_auth_asym_id", "char", 10);
      addStringField("pdbx_struct_sheet_hbond", "range_2_auth_atom_id", "char", 6);
      addStringField("pdbx_struct_sheet_hbond", "range_2_auth_comp_id", "char", 10);
      addStringField("pdbx_struct_sheet_hbond", "range_2_auth_seq_id", "char", 10);
      addStringField("pdbx_struct_sheet_hbond", "range_2_label_asym_id", "char", 10);
      addStringField("pdbx_struct_sheet_hbond", "range_2_label_atom_id", "char", 6);
      addStringField("pdbx_struct_sheet_hbond", "range_2_label_comp_id", "char", 10);
      addStringField("pdbx_struct_sheet_hbond", "range_2_PDB_ins_code", "char", 10);
      addStringField("pdbx_struct_sheet_hbond", "range_id_1", "char", 10);
      addStringField("pdbx_struct_sheet_hbond", "range_id_2", "char", 10);
      addStringField("pdbx_struct_sheet_hbond", "sheet_id", "char", 10);
      addStringField("pdbx_struct_sheet_hbond", "Structure_ID", "char", 10);
      addStringField("pdbx_xplor_file", "param_file", "char", 80);
      addStringField("pdbx_xplor_file", "serial_no", "char", 100);
      addStringField("pdbx_xplor_file", "Structure_ID", "char", 10);
      addStringField("pdbx_xplor_file", "topol_file", "char", 80);
      addStringField("rcsb_columninfo", "description", "char", 5000);
      addStringField("rcsb_tableinfo", "description", "char", 5000);
      addStringField("refine", "details", "text", 0);
      addStringField("refine", "entry_id", "char", 10);
      addStringField("refine", "ls_R_factor_R_free_error_details", "char", 200);
      addStringField("refine", "pdbx_isotropic_thermal_model", "char", 200);
      addStringField("refine", "pdbx_ls_cross_valid_method", "char", 500);
      addStringField("refine", "pdbx_method_to_determine_struct", "char", 500);
      addStringField("refine", "pdbx_R_Free_selection_details", "char", 500);
      addStringField("refine", "pdbx_starting_model", "char", 1000);
      addStringField("refine", "pdbx_stereochem_target_val_spec_case", "char", 500);
      addStringField("refine", "pdbx_stereochemistry_target_values", "char", 500);
      addStringField("refine", "solvent_model_details", "text", 0);
      addStringField("refine", "Structure_ID", "char", 10);
      addStringField("refine_analyze", "entry_id", "char", 10);
      addStringField("refine_analyze", "Structure_ID", "char", 10);
      addStringField("refine_B_iso", "class", "char", 150);
      addStringField("refine_B_iso", "details", "char", 200);
      addStringField("refine_B_iso", "Structure_ID", "char", 10);
      addStringField("refine_B_iso", "treatment", "char", 80);
      addStringField("refine_hist", "cycle_id", "char", 10);
      addStringField("refine_hist", "Structure_ID", "char", 10);
      addStringField("refine_ls_restr", "Structure_ID", "char", 10);
      addStringField("refine_ls_restr", "type", "char", 80);
      addStringField("refine_ls_restr_ncs", "dom_id", "char", 20);
      addStringField("refine_ls_restr_ncs", "ncs_model_details", "char", 1000);
      addStringField("refine_ls_restr_ncs", "Structure_ID", "char", 10);
      addStringField("refine_ls_shell", "Structure_ID", "char", 10);
      addStringField("refine_occupancy", "class", "char", 200);
      addStringField("refine_occupancy", "Structure_ID", "char", 10);
      addStringField("refine_occupancy", "treatment", "char", 10);
      addStringField("reflns", "entry_id", "char", 10);
      addStringField("reflns", "R_free_details", "char", 200);
      addStringField("reflns", "Structure_ID", "char", 10);
      addStringField("reflns_class", "description", "char", 5000);
      addStringField("reflns_shell", "Structure_ID", "char", 10);
      addStringField("software", "citation_id", "char", 200);
      addStringField("software", "classification", "char", 80);
      addStringField("software", "contact_author", "char", 80);
      addStringField("software", "contact_author_email", "char", 80);
      addStringField("software", "date", "char", 80);
      addStringField("software", "description", "char", 5000);
      addStringField("software", "language", "char", 80);
      addStringField("software", "location", "char", 80);
      addStringField("software", "name", "char", 200);
      addStringField("software", "Structure_ID", "char", 10);
      addStringField("software", "type", "char", 80);
      addStringField("software", "version", "char", 500);
      addStringField("struct", "entry_id", "char", 10);
      addStringField("struct", "pdbx_descriptor", "char", 1000);
      addStringField("struct", "pdbx_model_details", "text", 0);
      addStringField("struct", "Structure_ID", "char", 10);
      addStringField("struct", "title", "char", 500);
      addStringField("struct_asym", "details", "char", 200);
      addStringField("struct_asym", "entity_id", "char", 10);
      addStringField("struct_asym", "id", "char", 10);
      addStringField("struct_asym", "pdbx_modified", "char", 200);
      addStringField("struct_asym", "pdbx_pdb_chain_id", "char", 10);
      addStringField("struct_asym", "Structure_ID", "char", 10);
      addStringField("struct_biol", "details", "text", 0);
      addStringField("struct_biol", "id", "char", 80);
      addStringField("struct_biol", "pdbx_parent_biol_id", "char", 10);
      addStringField("struct_biol", "Structure_ID", "char", 10);
      addStringField("struct_biol_gen", "asym_id", "char", 10);
      addStringField("struct_biol_gen", "biol_id", "char", 80);
      addStringField("struct_biol_gen", "details", "char", 200);
      addStringField("struct_biol_gen", "pdbx_full_symmetry_operation", "char", 30);
      addStringField("struct_biol_gen", "Structure_ID", "char", 10);
      addStringField("struct_biol_gen", "symmetry", "char", 10);
      addStringField("struct_biol_keywords", "text", "text", 0);
      addStringField("struct_conf", "beg_auth_asym_id", "char", 10);
      addStringField("struct_conf", "beg_auth_comp_id", "char", 10);
      addStringField("struct_conf", "beg_auth_seq_id", "char", 10);
      addStringField("struct_conf", "beg_label_asym_id", "char", 10);
      addStringField("struct_conf", "beg_label_comp_id", "char", 10);
      addStringField("struct_conf", "conf_type_id", "char", 10);
      addStringField("struct_conf", "details", "char", 200);
      addStringField("struct_conf", "end_auth_asym_id", "char", 10);
      addStringField("struct_conf", "end_auth_comp_id", "char", 10);
      addStringField("struct_conf", "end_auth_seq_id", "char", 10);
      addStringField("struct_conf", "end_label_asym_id", "char", 10);
      addStringField("struct_conf", "end_label_comp_id", "char", 10);
      addStringField("struct_conf", "id", "char", 10);
      addStringField("struct_conf", "pdbx_beg_PDB_ins_code", "char", 10);
      addStringField("struct_conf", "pdbx_end_PDB_ins_code", "char", 10);
      addStringField("struct_conf", "pdbx_PDB_helix_class", "char", 10);
      addStringField("struct_conf", "pdbx_PDB_helix_id", "char", 10);
      addStringField("struct_conf", "Structure_ID", "char", 10);
      addStringField("struct_conf_type", "criteria", "char", 200);
      addStringField("struct_conf_type", "id", "char", 10);
      addStringField("struct_conf_type", "reference", "char", 200);
      addStringField("struct_conf_type", "Structure_ID", "char", 10);
      addStringField("struct_conn", "conn_type_id", "char", 80);
      addStringField("struct_conn", "details", "char", 200);
      addStringField("struct_conn", "id", "char", 30);
      addStringField("struct_conn", "pdbx_PDB_id", "char", 10);
      addStringField("struct_conn", "pdbx_ptnr1_label_alt_id", "char", 10);
      addStringField("struct_conn", "pdbx_ptnr1_PDB_ins_code", "char", 10);
      addStringField("struct_conn", "pdbx_ptnr1_standard_comp_id", "char", 200);
      addStringField("struct_conn", "pdbx_ptnr2_label_alt_id", "char", 10);
      addStringField("struct_conn", "pdbx_ptnr2_PDB_ins_code", "char", 10);
      addStringField("struct_conn", "pdbx_ptnr3_label_alt_id", "char", 10);
      addStringField("struct_conn", "pdbx_ptnr3_label_asym_id", "char", 10);
      addStringField("struct_conn", "pdbx_ptnr3_label_atom_id", "char", 6);
      addStringField("struct_conn", "pdbx_ptnr3_label_comp_id", "char", 10);
      addStringField("struct_conn", "pdbx_ptnr3_PDB_ins_code", "char", 10);
      addStringField("struct_conn", "ptnr1_auth_asym_id", "char", 10);
      addStringField("struct_conn", "ptnr1_auth_comp_id", "char", 10);
      addStringField("struct_conn", "ptnr1_auth_seq_id", "char", 10);
      addStringField("struct_conn", "ptnr1_label_asym_id", "char", 10);
      addStringField("struct_conn", "ptnr1_label_atom_id", "char", 6);
      addStringField("struct_conn", "ptnr1_label_comp_id", "char", 10);
      addStringField("struct_conn", "ptnr1_symmetry", "char", 10);
      addStringField("struct_conn", "ptnr2_auth_asym_id", "char", 10);
      addStringField("struct_conn", "ptnr2_auth_comp_id", "char", 10);
      addStringField("struct_conn", "ptnr2_auth_seq_id", "char", 10);
      addStringField("struct_conn", "ptnr2_label_asym_id", "char", 10);
      addStringField("struct_conn", "ptnr2_label_atom_id", "char", 6);
      addStringField("struct_conn", "ptnr2_label_comp_id", "char", 10);
      addStringField("struct_conn", "ptnr2_symmetry", "char", 10);
      addStringField("struct_conn", "Structure_ID", "char", 10);
      addStringField("struct_conn_type", "criteria", "char", 200);
      addStringField("struct_conn_type", "id", "char", 80);
      addStringField("struct_conn_type", "reference", "char", 200);
      addStringField("struct_conn_type", "Structure_ID", "char", 10);
      addStringField("struct_keywords", "entry_id", "char", 10);
      addStringField("struct_keywords", "pdbx_keywords", "char", 80);
      addStringField("struct_keywords", "Structure_ID", "char", 10);
      addStringField("struct_keywords", "text", "char", 4000);
      addStringField("struct_mon_prot_cis", "auth_asym_id", "char", 10);
      addStringField("struct_mon_prot_cis", "auth_comp_id", "char", 10);
      addStringField("struct_mon_prot_cis", "auth_seq_id", "char", 10);
      addStringField("struct_mon_prot_cis", "label_alt_id", "char", 10);
      addStringField("struct_mon_prot_cis", "label_asym_id", "char", 10);
      addStringField("struct_mon_prot_cis", "label_comp_id", "char", 10);
      addStringField("struct_mon_prot_cis", "pdbx_auth_asym_id_2", "char", 10);
      addStringField("struct_mon_prot_cis", "pdbx_auth_comp_id_2", "char", 10);
      addStringField("struct_mon_prot_cis", "pdbx_auth_seq_id_2", "char", 10);
      addStringField("struct_mon_prot_cis", "pdbx_id", "char", 10);
      addStringField("struct_mon_prot_cis", "pdbx_label_asym_id_2", "char", 10);
      addStringField("struct_mon_prot_cis", "pdbx_label_comp_id_2", "char", 10);
      addStringField("struct_mon_prot_cis", "pdbx_omega_angle", "char", 10);
      addStringField("struct_mon_prot_cis", "pdbx_PDB_ins_code", "char", 10);
      addStringField("struct_mon_prot_cis", "pdbx_PDB_ins_code_2", "char", 10);
      addStringField("struct_mon_prot_cis", "Structure_ID", "char", 10);
      addStringField("struct_ncs_dom", "details", "char", 200);
      addStringField("struct_ncs_dom", "id", "char", 10);
      addStringField("struct_ncs_dom", "Structure_ID", "char", 10);
      addStringField("struct_ncs_dom_lim", "beg_auth_asym_id", "char", 10);
      addStringField("struct_ncs_dom_lim", "beg_auth_comp_id", "char", 10);
      addStringField("struct_ncs_dom_lim", "beg_auth_seq_id", "char", 10);
      addStringField("struct_ncs_dom_lim", "beg_label_alt_id", "char", 10);
      addStringField("struct_ncs_dom_lim", "beg_label_asym_id", "char", 10);
      addStringField("struct_ncs_dom_lim", "beg_label_comp_id", "char", 10);
      addStringField("struct_ncs_dom_lim", "dom_id", "char", 10);
      addStringField("struct_ncs_dom_lim", "end_auth_asym_id", "char", 10);
      addStringField("struct_ncs_dom_lim", "end_auth_comp_id", "char", 10);
      addStringField("struct_ncs_dom_lim", "end_auth_seq_id", "char", 10);
      addStringField("struct_ncs_dom_lim", "end_label_alt_id", "char", 10);
      addStringField("struct_ncs_dom_lim", "end_label_asym_id", "char", 10);
      addStringField("struct_ncs_dom_lim", "end_label_comp_id", "char", 10);
      addStringField("struct_ncs_dom_lim", "Structure_ID", "char", 10);
      addStringField("struct_ncs_ens_gen", "dom_id_1", "char", 10);
      addStringField("struct_ncs_ens_gen", "dom_id_2", "char", 10);
      addStringField("struct_ncs_ens_gen", "ens_id", "char", 10);
      addStringField("struct_ncs_ens_gen", "oper_id", "char", 10);
      addStringField("struct_ncs_ens_gen", "Structure_ID", "char", 10);
      addStringField("struct_ncs_oper", "code", "char", 10);
      addStringField("struct_ncs_oper", "details", "char", 200);
      addStringField("struct_ncs_oper", "id", "char", 10);
      addStringField("struct_ncs_oper", "Structure_ID", "char", 10);
      addStringField("struct_ref", "biol_id", "char", 80);
      addStringField("struct_ref", "db_code", "char", 80);
      addStringField("struct_ref", "db_name", "char", 80);
      addStringField("struct_ref", "entity_id", "char", 10);
      addStringField("struct_ref", "id", "char", 10);
      addStringField("struct_ref", "pdbx_align_begin", "char", 10);
      addStringField("struct_ref", "pdbx_db_accession", "char", 80);
      addStringField("struct_ref", "pdbx_seq_one_letter_code", "text", 100000);
      addStringField("struct_ref", "Structure_ID", "char", 10);
      addStringField("struct_ref_seq", "align_id", "char", 10);
      addStringField("struct_ref_seq", "pdbx_auth_seq_align_beg", "char", 10);
      addStringField("struct_ref_seq", "pdbx_auth_seq_align_end", "char", 10);
      addStringField("struct_ref_seq", "pdbx_db_accession", "char", 10);
      addStringField("struct_ref_seq", "pdbx_db_align_beg_ins_code", "char", 10);
      addStringField("struct_ref_seq", "pdbx_db_align_end_ins_code", "char", 10);
      addStringField("struct_ref_seq", "pdbx_PDB_id_code", "char", 10);
      addStringField("struct_ref_seq", "pdbx_seq_align_beg_ins_code", "char", 10);
      addStringField("struct_ref_seq", "pdbx_seq_align_end_ins_code", "char", 10);
      addStringField("struct_ref_seq", "pdbx_strand_id", "char", 10);
      addStringField("struct_ref_seq", "ref_id", "char", 10);
      addStringField("struct_ref_seq", "Structure_ID", "char", 10);
      addStringField("struct_ref_seq_dif", "align_id", "char", 10);
      addStringField("struct_ref_seq_dif", "db_mon_id", "char", 10);
      addStringField("struct_ref_seq_dif", "details", "char", 200);
      addStringField("struct_ref_seq_dif", "mon_id", "char", 10);
      addStringField("struct_ref_seq_dif", "pdbx_auth_seq_num", "char", 10);
      addStringField("struct_ref_seq_dif", "pdbx_pdb_id_code", "char", 10);
      addStringField("struct_ref_seq_dif", "pdbx_pdb_ins_code", "char", 10);
      addStringField("struct_ref_seq_dif", "pdbx_pdb_strand_id", "char", 10);
      addStringField("struct_ref_seq_dif", "pdbx_seq_db_accession_code", "char", 10);
      addStringField("struct_ref_seq_dif", "pdbx_seq_db_name", "char", 10);
      addStringField("struct_ref_seq_dif", "pdbx_seq_db_seq_num", "char", 10);
      addStringField("struct_ref_seq_dif", "Structure_ID", "char", 10);
      addStringField("struct_sheet", "details", "char", 200);
      addStringField("struct_sheet", "id", "char", 10);
      addStringField("struct_sheet", "Structure_ID", "char", 10);
      addStringField("struct_sheet", "type", "char", 200);
      addStringField("struct_sheet_order", "range_id_1", "char", 10);
      addStringField("struct_sheet_order", "range_id_2", "char", 10);
      addStringField("struct_sheet_order", "sense", "char", 20);
      addStringField("struct_sheet_order", "sheet_id", "char", 10);
      addStringField("struct_sheet_order", "Structure_ID", "char", 10);
      addStringField("struct_sheet_range", "beg_auth_asym_id", "char", 10);
      addStringField("struct_sheet_range", "beg_auth_comp_id", "char", 10);
      addStringField("struct_sheet_range", "beg_auth_seq_id", "char", 10);
      addStringField("struct_sheet_range", "beg_label_asym_id", "char", 10);
      addStringField("struct_sheet_range", "beg_label_comp_id", "char", 10);
      addStringField("struct_sheet_range", "end_auth_asym_id", "char", 10);
      addStringField("struct_sheet_range", "end_auth_comp_id", "char", 10);
      addStringField("struct_sheet_range", "end_auth_seq_id", "char", 10);
      addStringField("struct_sheet_range", "end_label_asym_id", "char", 10);
      addStringField("struct_sheet_range", "end_label_comp_id", "char", 10);
      addStringField("struct_sheet_range", "id", "char", 10);
      addStringField("struct_sheet_range", "pdbx_beg_PDB_ins_code", "char", 10);
      addStringField("struct_sheet_range", "pdbx_end_PDB_ins_code", "char", 10);
      addStringField("struct_sheet_range", "sheet_id", "char", 10);
      addStringField("struct_sheet_range", "Structure_ID", "char", 10);
      addStringField("struct_sheet_range", "symmetry", "char", 10);
      addStringField("struct_site", "details", "text", 0);
      addStringField("struct_site", "id", "char", 80);
      addStringField("struct_site", "Structure_ID", "char", 10);
      addStringField("struct_site_gen", "auth_asym_id", "char", 10);
      addStringField("struct_site_gen", "auth_comp_id", "char", 10);
      addStringField("struct_site_gen", "auth_seq_id", "char", 10);
      addStringField("struct_site_gen", "details", "char", 200);
      addStringField("struct_site_gen", "id", "char", 80);
      addStringField("struct_site_gen", "label_alt_id", "char", 10);
      addStringField("struct_site_gen", "label_asym_id", "char", 10);
      addStringField("struct_site_gen", "label_atom_id", "char", 6);
      addStringField("struct_site_gen", "label_comp_id", "char", 10);
      addStringField("struct_site_gen", "site_id", "char", 80);
      addStringField("struct_site_gen", "Structure_ID", "char", 10);
      addStringField("struct_site_gen", "symmetry", "char", 10);
      addStringField("struct_site_keywords", "site_id", "char", 80);
      addStringField("struct_site_keywords", "Structure_ID", "char", 10);
      addStringField("struct_site_keywords", "text", "char", 200);
      addStringField("symmetry", "cell_setting", "char", 80);
      addStringField("symmetry", "entry_id", "char", 10);
      addStringField("symmetry", "pdbx_full_space_group_name_H-M", "char", 80);
      addStringField("symmetry", "space_group_name_H-M", "char", 80);
      addStringField("symmetry", "Structure_ID", "char", 10);
      addStringField("v_nmr_refine", "details", "text", 0);
      addStringField("v_structure_details", "seq_one_letter_code", "text", 0);
      
      lookupMap = Collections.unmodifiableMap(lookupMap);
   }

}
