package org.pdb.ormapping.util;

import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;

public class Table implements Comparable
{
	private Table parent = null;

	private String name = null;

	private String description = null;

	private SortedSet fields = null;

	private SortedSet childTables = null;
	
	private String keyField = null;


	/**
	 * @return
	 */
	public String getKeyField()
	{
		return keyField;
	}

	/**
	 * @param keyField
	 */
	public void setKeyField(String keyField)
	{
		if (keyField != null)
		{
			this.keyField = keyField;
		}
	}

	/* (non-Javadoc)
	 * @see java.lang.Comparable#compareTo(java.lang.Object)
	 */
	public int compareTo(Object obj) {
		if (!(obj instanceof Table)) return -1;
		Table other = (Table)obj;
		return this.name.compareTo(other.name);
	}



	public String toString()
	{
		return toStringIndent("");
	}
	public String toStringIndent(String indent)
	{
		Field f = null;
		Table t = null;
		StringBuffer sb = new StringBuffer();
		sb.append('\n');
		sb.append(indent);
		sb.append("Table Name: ");
		sb.append(this.name);
		if (parent != null)
		{
			sb.append("  (Parent Table = ");
			sb.append(parent.name);
			sb.append(")");
		}
		sb.append('\n');
		sb.append(indent);
		sb.append("Key Field: ");
		sb.append(this.keyField);
		if (description != null)
		{
			sb.append('\n');
			sb.append(indent);
			sb.append("Description:");
			sb.append('\n');
			sb.append(indent);
			sb.append("------------------------------------------------------------------------------------");
			sb.append('\n');
			sb.append(indent);
			sb.append(this.description);
			sb.append('\n');
			sb.append(indent);
			sb.append("------------------------------------------------------------------------------------");
		}
		Iterator it = fields.iterator();
		while (it.hasNext())
		{
			f = (Field) it.next();
			sb.append(f.toStringIndent(indent + "  "));
		}
		it = childTables.iterator();
		while (it.hasNext())
		{
			t = (Table) it.next();
			sb.append(t.toStringIndent(indent + "  "));
		}
		return sb.toString();
	}

	/**
	 * @return
	 */
	public String getName()
	{
		return name;
	}

	/**
	 * @param name
	 */
	public void setName(String name)
	{
		this.name = name;
	}

	/**
	 * @return
	 */
	public String getDescription()
	{
		return description;
	}

	/**
	 * @param description
	 */
	public void setDescription(String description)
	{
		this.description = description;
	}

	public void addTable(Table t)
	{
		childTables.add(t);
	}

	/**
	 * @return
	 */
	public SortedSet getTables()
	{
		return childTables;
	}

	public void addField(Field f)
	{
		fields.add(f);
	}

	/**
	 * @return
	 */
	public SortedSet getFields()
	{
		return fields;
	}

	/**
	 * 
	 */
	public Table(Table parent)
	{
		super();
		this.parent = parent;
		fields = new TreeSet();
		childTables = new TreeSet();
		keyField = "obj_id";
	}

}
