package org.pdb.ormapping.util;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;

import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.pdb.derived.MetadataCategory;
import org.pdb.derived.MetadataItem;
import org.pdb.ormapping.Citation;
import org.pdb.ormapping.Datablock;

/**
 * @author wayne
 */
public class Utils
{

   public static void setXmlParserClasses()
   {
      System.setProperty("javax.xml.parsers.DocumentBuilderFactory", "org.apache.xerces.jaxp.DocumentBuilderFactoryImpl");
      System.setProperty("javax.xml.parsers.SAXParserFactory", "org.apache.xerces.jaxp.SAXParserFactoryImpl");
      System.setProperty("org.xml.sax.driver", "org.apache.xerces.parsers.SAXParser");
   }

   public static String getPlatformIndependentFileName(String s)
   {
      String ans = s.replace('/', File.separatorChar);
      return ans.replace('\\', File.separatorChar);
   }

   /**
    * @param id
    *           PDB Structure ID
    * @param sess
    *           A Hibernate Session
    * @return Datablock Top level PDB Structure JavaBean
    */
   public static Datablock getDatablock(String id, Session sess)
   {
      Datablock ans = null;

      try
      {
         Query q = sess.createQuery("from org.pdb.ormapping.Datablock as datablock where datablock.datablockName = :structureId");
         q.setString("structureId", id.toUpperCase());
         List structs = q.list();
         if (structs.size() > 0)
         {
            ListIterator iter = structs.listIterator();
            if (iter.hasNext())
            {
               ans = (Datablock) iter.next();
            }
            if (structs.size() > 1)
            {
               System.err.println("SEVERE ERROR: Duplicate records in database for ID: " + id);
            }

         }
      }
      catch (HibernateException e)
      {
         e.printStackTrace();
      }
      return ans;
   }

   public static Calendar getCalendar(String dateIn)
   {
      Calendar utilCal = java.util.GregorianCalendar.getInstance();
      SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
      try
      {
         utilCal.setTime(sdf.parse(dateIn));
      }
      catch (java.text.ParseException e)
      {
         utilCal = null;
         e.printStackTrace();
      }
      return utilCal;
   }

   private static List allMetadataCategories = new ArrayList();

   private static SortedMap metadataCategoryMap = null;

   private static SortedMap metadataCategoryClassMap = null;

   public static void reInitMetadata()
   {
      initMetadataCategories();
   }

   /**
    * @return List collection of all metadata categories
    */
   public static List getMetadataCategories()
   {
      checkMetadataCats();
      return allMetadataCategories;
   }

   protected static void checkMetadataCats()
   {
      boolean needInit = false;
      synchronized (allMetadataCategories)
      {
         needInit = (allMetadataCategories.size() == 0);
      }
      if (needInit)
      {
         initMetadataCategories();
      }
   }

   /**
    * @return initialize all metadata categories
    */
   public static void initMetadataCategories()
   {
      synchronized (allMetadataCategories)
      {
         Session sess = null;
         try
         {
            sess = HibernateUtils.getSession();
            allMetadataCategories = sess.createQuery("from org.pdb.derived.MetadataCategory as mdc left join fetch mdc.metadataItems")
                  .list();
            if (allMetadataCategories == null || allMetadataCategories.size() == 0)
            {
               saveMetadataToDb();
               // try again
               allMetadataCategories = sess.createQuery("from org.pdb.derived.MetadataCategory as mdc left join fetch mdc.metadataItems")
                     .list();
            }
            metadataCategoryMap = new TreeMap();
            metadataCategoryClassMap = new TreeMap();
            ListIterator iter = allMetadataCategories.listIterator();
            MetadataCategory aCat = null;
            while (iter.hasNext())
            {
               aCat = (MetadataCategory) iter.next();
               metadataCategoryMap.put(aCat.getCategoryName(), aCat);
               metadataCategoryClassMap.put(aCat.getClassName(), aCat);
               // System.err.println("added class " + aCat.getClassName());
            }
            sess.close();
            sess = null;
         }
         catch (Exception e)
         {
            e.printStackTrace();
            if (sess != null)
            {
               try
               {
                  sess.close();
               }
               catch (HibernateException he)
               {
                  he.printStackTrace();
               }
            }
         }

         // need to reduce the list in case the sql above returns the cross product of cats and items
         allMetadataCategories = new ArrayList();
         Iterator it = metadataCategoryMap.keySet().iterator();
         while (it.hasNext())
         {
            String aCatName = (String) it.next();
            allMetadataCategories.add(metadataCategoryMap.get(aCatName));
         }

         allMetadataCategories = Collections.unmodifiableList(allMetadataCategories);
         metadataCategoryMap = Collections.unmodifiableSortedMap(metadataCategoryMap);
         metadataCategoryClassMap = Collections.unmodifiableSortedMap(metadataCategoryClassMap);
      }
   }

   /**
    * @param id
    *           cif category name
    * @param sess
    *           A Hibernate Session
    * @return MetadataCategory a metadata category
    */
   public static MetadataItem getMetadataItem(String id, MetadataCategory mdcat)
   {
      MetadataItem ans = null;
      ListIterator li = mdcat.getMetadataItems().listIterator();
      while (li.hasNext())
      {
         MetadataItem anitem = (MetadataItem) li.next();
         if (anitem.getItemName().equals(id))
         {
            ans = anitem;
            break;
         }
      }
      return ans;
   }

   /*
    * getMetadataItemDescription
    * 
    * This takes in a string with the category and item dotted together. (i.e. struct.entry_id) It returns the mmCIF
    * description of that id
    */
   public static String getMetadataItemDescription(String categoryDotItem)
   {
      String retVal = "";
      String cat = categoryDotItem.substring(0, categoryDotItem.indexOf('.'));
      String item = categoryDotItem.substring(categoryDotItem.indexOf('.') + 1, categoryDotItem.length());
      MetadataCategory m1 = getMetadataCategory(cat);
      MetadataItem m2 = getMetadataItem(item, m1);
      if (m2 != null)
      {
         retVal = m2.getDescription();
      }
      else
      {
         System.err.println("getMetadataItemDescription ERROR : MetadataItem is null! [" + categoryDotItem + "]");
      }
      return retVal;
   }

   /**
    * @param cn
    *           class name
    * @return MetadataCategory a metadata category
    */
   public static String getTableNameForMappedClass(String cn)
   {
      System.err.println("looking for class " + cn);
      checkMetadataCats();
      String ans = null;
      MetadataCategory mc = (MetadataCategory) metadataCategoryClassMap.get(cn);
      if (mc != null)
      {
         ans = mc.getTableName();
      }
      return ans;
   }

   /**
    * @param cn
    *           class name
    * @param sess
    *           A Hibernate Session
    * @return MetadataCategory a metadata category
    */
   public static MetadataCategory getMetadataCategoryByClassName(String cn)
   {
      checkMetadataCats();
      return (MetadataCategory) metadataCategoryClassMap.get(cn);
   }

   /**
    * @param id
    *           cif category name
    * @param sess
    *           A Hibernate Session
    * @return MetadataCategory a metadata category
    */
   public static MetadataCategory getMetadataCategory(String id)
   {
      checkMetadataCats();
      return (MetadataCategory) metadataCategoryMap.get(id);
   }

   public static void clearTable(String tableName)
   {
      Session sess = null;
      Statement s = null;
      Transaction tx = null;
      try
      {
         sess = HibernateUtils.getSession();
         tx = sess.beginTransaction();
         s = sess.connection().createStatement();
         s.executeUpdate("delete from " + tableName);
         tx.commit();
         s.close();
         s = null;
         sess.close();
         sess = null;
         System.out.println("deleted all rows from " + tableName);
      }
      catch (SQLException e)
      {

         try
         {
            if (tx != null) tx.rollback(); // at least try to roll back
         }
         catch (HibernateException e1)
         {
            e1.printStackTrace();
         }
         if (s != null) // close statement first
         {
            try
            {
               s.close();
            }
            catch (SQLException e2)
            {
               e2.printStackTrace();
            }
         }
         if (sess != null)
         {
            try
            {
               sess.close();
            }
            catch (Exception e3)
            {
               e3.printStackTrace();
            }
         }
         String errTxt = "\nError in SQL query [msg=" + e.getMessage() + "] [code=" + e.getErrorCode() + "] [lmsg="
               + e.getLocalizedMessage() + "]";
         System.err.println(errTxt);
      }
   }

   public static boolean saveMetadataToDb()
   {
      // first make sure tables are empty
      clearTable("metadata_enumeration");
      clearTable("metadata_item");
      clearTable("metadata_category");
      boolean ans = false;
      System.err.println("In saveMetadataToDb");
      Session s = null;
      Transaction tx = null;
      ObjectInputStream ois = null;
      try
      {
         ois = new ObjectInputStream(
               new BufferedInputStream(HibernateUtils.class.getResourceAsStream("/org/pdb/ormapping/metadata.serobj")));
         List cats = (List) ois.readObject();
         ois.close();
         System.err.println("loading Metadata into Database!");
         s = HibernateUtils.getSession();
         System.err.println("got session");
         tx = s.beginTransaction();
         Iterator it = cats.iterator();
         System.err.println("got Iterator");
         while (it.hasNext())
         {
            MetadataCategory aCat = (MetadataCategory) it.next();
            System.err.print("Saving MetadataCategory: " + aCat.getCategoryName() + "...        ");
            s.save(aCat);
            System.err.println("Saved MetadataCategory: " + aCat.getCategoryName());
         }
         tx.commit();
         System.err.println("Tx committed.");
         s.close();
         System.err.println("session closed");
         ans = true;
      }
      catch (Exception e)
      {
         System.err.println("In catch - " + e.getMessage());
         if (tx != null) tx.rollback();
         HibernateUtils.HandleHibernateException(s, e);
         if (ois != null)
         {
            try
            {
               ois.close();
            }
            catch (Exception anye)
            {
               anye.printStackTrace();
            }
         }
      }
      System.out.println("Finished saving metadata to Database.");
      return ans;
   }

   /**
    * remove cr and lf
    */
   public static String removeCrLf(String s, String replaceValue)
   {
      if (s == null || s.trim().length() == 0)
      {
         return "";
      }
      char[] a = s.toCharArray();
      char[] rv = null;
      if (replaceValue == null)
      {
         rv = new char[0];
      }
      else
      {
         rv = replaceValue.toCharArray();
      }
      char[] b = new char[a.length * (rv.length + 1)];
      int outpos = 0;
      int curpos = 0;
      int rvp = 0;
      while (curpos < a.length)
      {
         if (a[curpos] == '\n' || a[curpos] == '\r')
         {
            curpos++;
            for (rvp = 0; rvp < rv.length; rvp++)
            {
               b[outpos++] = rv[rvp];
            }
            continue;
         }
         b[outpos++] = a[curpos++];
      }
      if (outpos > 0)
      {
         return new String(b, 0, outpos);
      }
      else
      {
         return "";
      }
   }

   public static List getUsedItems()
   {
      List ans = new ArrayList();
      Map tblFieldAndCatItemMap = new HashMap();
      Map tblFieldMap = new HashMap();
      Map catItemMap = new HashMap();
      Session sess = null;
      try
      {
         sess = HibernateUtils.getTestSession();
         List mdcList = getMetadataCategories();
         Iterator iter = mdcList.iterator();
         while (iter.hasNext())
         {
            MetadataCategory mdc = (MetadataCategory) iter.next();
            Iterator iit = mdc.getMetadataItems().iterator();
            while (iit.hasNext())
            {
               MetadataItem mdi = (MetadataItem) iit.next();
               catItemMap.put(mdc.getCategoryName().toLowerCase() + "." + mdi.getItemName().toLowerCase(), mdi);
               tblFieldMap.put(mdc.getTableName().toLowerCase() + "." + mdi.getFieldName().toLowerCase(), mdi);
               tblFieldAndCatItemMap.put(mdc.getCategoryName().toLowerCase() + "." + mdi.getItemName().toLowerCase(), mdi);
               tblFieldAndCatItemMap.put(mdc.getTableName().toLowerCase() + "." + mdi.getFieldName().toLowerCase(), mdi);
            }
         }
      }
      catch (Exception e)
      {
         e.printStackTrace();
      }
      finally
      {
         if (sess != null)
         {
            try
            {
               sess.close();
            }
            catch (HibernateException e1)
            {
               e1.printStackTrace();
            }
         }
      }
      BufferedReader br = null;
      try
      {
         br = new BufferedReader(new FileReader("usedFields.txt"));
         while (br.ready())
         {
            String s = br.readLine();
            if (s == null) break;
            if (s.startsWith("#")) continue;
            Object anItem = tblFieldAndCatItemMap.get(s.trim().toLowerCase());
            if (anItem != null)
            {
               ans.add(anItem);
            }
         }
         br.close();
      }
      catch (Exception e)
      {
         try
         {
            br.close();
         }
         catch (IOException e1)
         {
            e1.printStackTrace();
         }
         e.printStackTrace();
      }
      return ans;
   }

   public static void main(String[] args)
   {
      System.err.println("Saved? --> " + Utils.saveMetadataToDb());
   }

   public static void main2(String[] args)
   {
      // List used = getUsedItems();
      // ListIterator li = used.listIterator();
      // while (li.hasNext())
      // {
      // MetadataItem anItem = (MetadataItem) li.next();
      // System.err.println(anItem.toString() + "\n");
      // }
      // System.exit(0);
      Session sess;
      // TreeSet datatypes = new TreeSet();

      try
      {
         // OutputStreamWriter osw = new OutputStreamWriter(System.err);
         System.err.println("before getSession\n\n\n\n------------\n\n\n");
         sess = HibernateUtils.getTestSession();
         System.err.println("after getSession\n\n\n\n------------\n\n\n");
         // String tbltag = "<table cellpadding=\"2\" cellspacing=\"2\"
         // border=\"1\" style=\"width: 100%;
         // text-align: center;\">";
         // getMetadataTable(tbltag, osw, "struct", "4hhb", sess);

         MetadataCategory mc = getMetadataCategory("mvStructure");
         System.err.println(mc.getJoinClause());

         // MetadataCategory mas = getMetadataCategory("atom_site", sess);
         // //System.err.println(mas.toString());
         // List allMdcs = getMetadataCategories(sess);
         // Iterator foo = allMdcs.iterator();
         // while (foo.hasNext())
         // {
         // MetadataCategory mdcat = (MetadataCategory) foo.next();
         // System.err.println(mdcat.getDisplayName());
         // ListIterator li = mdcat.getMetadataItems().listIterator();
         // while (li.hasNext())
         // {
         // MetadataItem anitem = (MetadataItem) li.next();
         // datatypes.add(anitem.getDataType());
         // }
         // }
         // System.err.println("\n\n\n");
         // Iterator dt = datatypes.iterator();
         // while (dt.hasNext())
         // {
         // System.err.println(dt.next());
         // }

         // Entities
         /*
          * java.util.List pes = sess.find("select distinct ps.pdb_strand_id, ent.pdbx_description, ent.pdbx_fragment,
          * ent.pdbx_mutation, ent.id_, ps.entity_id from org.pdb.ormapping.Datablock as db inner join db.entitys as ent
          * left outer join db.pdbx_poly_seq_schemes as ps where db.datablockName = '4HHB' and ent.type = 'polymer' and
          * ent.id_ = ps.entity_id");
          * 
          * String chainID="", polyName="", fragment="", mutation=""; if (pes.size() > 0) { java.util.ListIterator iter =
          * pes.listIterator(); while (iter.hasNext()) { Object[] palffy = (Object[])iter.next();
          * 
          * if (!palffy[1].toString().equalsIgnoreCase("water")) { if (palffy[0] != null) chainID =
          * palffy[0].toString(); if (palffy[1] != null) polyName = palffy[1].toString(); if (palffy[2] != null)
          * fragment = palffy[2].toString(); if (palffy[3] != null) mutation = palffy[3].toString();
          * 
          * System.err.println(chainID + ", " + polyName + ", " + fragment + ", " + mutation); } } }
          */

         if (false)
         {
            java.util.List pes = sess.createQuery(
                  "select c from org.pdb.ormapping.Datablock as db inner join db.citations as c where db.datablockName='103M'").list();
            String journalVolume = "";
            String journalPage = "";
            String journalYear = "";

            if (pes.size() > 0)
            {
               java.util.ListIterator iter = pes.listIterator();
               while (iter.hasNext())
               {
                  Citation cit = (Citation) iter.next();

                  if (cit.getId_().equalsIgnoreCase("primary"))
                  // For some reason, I couldnt join the query to use
                  // c.id = 'primary' so I had to resort to this
                  // method
                  {
                     if (cit.getJournal_volume() != null) journalVolume = cit.getJournal_volume();
                     if (cit.getPage_first() != null) journalPage = cit.getPage_first();
                     if (cit.getYear() != null) journalYear = cit.getYear().toString();
                  }
               }
            }
         }

         // MvStructure mvStructureData = new MvStructure("100D");
         // s.load(mvStructureData, "100D");
         // System.err.println(mvStructureData.getStructId());
         // CitationAuthorMaster citationAuthorMaster =
         // (CitationAuthorMaster) s.load( CitationAuthorMaster.class,
         // mvStructureData.getCitationId(), org.hibernate.LockMode.NONE
         // );
         System.err.println("Closing Session");
         sess.close();
      }
      catch (HibernateException e)
      {
         e.printStackTrace();
      }
      // catch (NamingException e)
      // {
      // e.printStackTrace();
      // }
   }

   public static Runtime r = Runtime.getRuntime();

   public static void mygc(String caller)
   {
      long fm = r.freeMemory();
      long tm = r.totalMemory();
      long um = tm - fm;
      long mm = r.maxMemory();
      System.err.println("Memory - begin with: used = " + Long.toString(um) + "\tfree = " + Long.toString(fm) + "\ttotal = "
            + Long.toString(tm));
      int gcTimes = 5;
      try
      {
         for (int i = 0; i < gcTimes; i++)
         {
            r.gc();
            r.runFinalization();
            // System.err.println("mygc - pass " +Integer.toString(i) + " with
            // free = " +
            // Long.toString(r.freeMemory()));
         }
         long endfm = r.freeMemory();
         long endtm = r.totalMemory();
         long endum = endtm - endfm;
         // System.err.println("mygc - collection of " + Long.toString(endfm -
         // fm));
         System.err.println("Memory - begin with: used = " + Long.toString(endum) + "\tfree = " + Long.toString(endfm) + "\ttotal = "
               + Long.toString(endtm) + "\tmax = " + Long.toString(mm));
      }
      catch (Exception ex)
      {
         System.err.println(caller + "  problem with mygc!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
         ex.printStackTrace();
         System.err.println("end -problem with mygc!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!\n");
         System.err.println(caller + "  problem with mygc!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
         System.err.println(ex.getMessage());
         System.err.println("end - problem with mygc!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!\n");
      }
   }

}