/***************************************************************************
* Title:          ConversionTables.h
* Author:         Ari Frank
* Copyright (c) 2009 The Regents of the University of California
* All Rights Reserved
* See file LICENSE for details.
***************************************************************************/

/******************************************************************************
Copyright 2008, The Regents of the University of California
All Rights Reserved

Permission to use, copy, modify and distribute any part of this
program for educational, research and non-profit purposes, without fee,
and without a written agreement is hereby granted, provided that the
above copyright notice, this paragraph and the following three paragraphs
appear in all copies.

Those desiring to incorporate this work into commercial
products or use for commercial purposes should contact the Technology
Transfer & Intellectual Property Services, University of California,
San Diego, 9500 Gilman Drive, Mail Code 0910, La Jolla, CA 92093-0910,
Ph: (858) 534-5815, FAX: (858) 534-7345, E-MAIL:invent@ucsd.edu.

IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY
FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE, EVEN
IF THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY
OF SUCH DAMAGE.

THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND THE UNIVERSITY
OF CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES,
ENHANCEMENTS, OR MODIFICATIONS.  THE UNIVERSITY OF CALIFORNIA MAKES NO
REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER IMPLIED OR
EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE, OR THAT THE USE OF
THE SOFTWARE WILL NOT INFRINGE ANY PATENT, TRADEMARK OR OTHER RIGHTS.

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
*******************************************************************************/


#ifndef __CONVERSIONTABLES_H__
#define __CONVERSIONTABLES_H__

#include "includes.h"

class ConversionTables {
public:
	void init_for_standard_aas();

	void add_optional_PTM_aa(int aa, string label, double delta)
	{
		org_aa.push_back(aa);
		aa2mass.push_back(aa2mass[aa]+delta);
		aa2label.push_back(label);
	}

	void make_fixed_mod(int aa, double delta)
	{
		aa2mass[aa]+=delta;
		if (aa>0 && aa<=Val)
			char2mass[aa2char[aa]] += delta;
	}




	// access to 
	int	   get_char2aa(char c) const { return char2aa[c]; }
	mass_t get_char2mass(char c) const { return char2mass[c]; }
	mass_t get_aa2mass(int a) const { return aa2mass[a]; }
	char   get_aa2char(int a) const { return aa2char[a]; }
	string get_aa2label(int a) const { return aa2label[a]; }
	int    get_org_aa(int a) const { return org_aa[a]; }

	const vector<int>& get_char2aa() const { return char2aa; }
	const vector<mass_t>& get_char2mass() const { return char2mass; }
	const vector<mass_t>& get_aa2mass() const { return aa2mass; }
	const vector<char>& get_aa2char() const { return aa2char; }
	const vector<string>& get_aa2label() const { return aa2label; }
	const vector<int>& get_org_aa() const { return org_aa; }

private:
	vector<int>       char2aa;
	vector<mass_t> char2mass;
	vector<mass_t> aa2mass;
	vector<char>      aa2char;
	vector<string>    aa2label;
	vector<int>       org_aa;

};


#endif




