/***************************************************************************
* Title:          MonoFragments.cpp
* Author:         Ari Frank
* Copyright (c) 2009 The Regents of the University of California
* All Rights Reserved
* See file LICENSE for details.
***************************************************************************/

/******************************************************************************
Copyright 2008, The Regents of the University of California
All Rights Reserved

Permission to use, copy, modify and distribute any part of this
program for educational, research and non-profit purposes, without fee,
and without a written agreement is hereby granted, provided that the
above copyright notice, this paragraph and the following three paragraphs
appear in all copies.

Those desiring to incorporate this work into commercial
products or use for commercial purposes should contact the Technology
Transfer & Intellectual Property Services, University of California,
San Diego, 9500 Gilman Drive, Mail Code 0910, La Jolla, CA 92093-0910,
Ph: (858) 534-5815, FAX: (858) 534-7345, E-MAIL:invent@ucsd.edu.

IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY
FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE, EVEN
IF THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY
OF SUCH DAMAGE.

THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND THE UNIVERSITY
OF CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES,
ENHANCEMENTS, OR MODIFICATIONS.  THE UNIVERSITY OF CALIFORNIA MAKES NO
REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER IMPLIED OR
EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE, OR THAT THE USE OF
THE SOFTWARE WILL NOT INFRINGE ANY PATENT, TRADEMARK OR OTHER RIGHTS.

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
*******************************************************************************/




#include "MonoFragments.h"




void FragmentSet::initECD()
{
	strongFragmentIdxs.clear();
	strongFragmentIdxs.push_back(0);
	strongFragmentIdxs.push_back(1);
	fragments.push_back(MonoFragment("c",PREFIX,STRONG,17.02635));
	fragments.push_back(MonoFragment("z",SUFFIX,STRONG,  -16.01872)); // includes 18 Da terminal

	fragments.push_back(MonoFragment("c-H2O",PREFIX, WEAK, -1.07928));
	fragments.push_back(MonoFragment("c-NH3",PREFIX, WEAK, -0.000197));
	fragments.push_back(MonoFragment("z-H2O",SUFFIX, WEAK,  -34.029283)); // includes 18 Da terminal
	fragments.push_back(MonoFragment("z-NH3",SUFFIX, WEAK,  -33.045267)); // includes 18 Da terminal

//	fragments.push_back(MonoFragment("b",PREFIX,WEAK,    0));
//	fragments.push_back(MonoFragment("y",SUFFIX,WEAK,    0)); // includes 18 Da terminal
//	fragments.push_back(MonoFragment("c-2H2O",PREFIX,WEAK, -19.089843));
//	fragments.push_back(MonoFragment("z-2H2O",SUFFIX,WEAK,  -52.039846)); // includes 18 Da terminal
//	
}



void FragmentSet::calcFragmentSetMonoMasses(mass_t cutMass, mass_t totalMonoMass, 
											vector<mass_t>& fragMasses) const
{
	fragMasses.clear();
	vector<MonoFragment>::const_iterator it;
	for (it = fragments.begin(); it != fragments.end(); it++)
		fragMasses.push_back(it->calcExpFragMass(cutMass,totalMonoMass));

}



void FragmentSet::printFragmentNames(ostream& os) const
{
	unsigned int i;
	for (i=0; i<fragments.size()-1; i++)
		os << fragments[i].label << "\t";
	os << fragments[i].label << endl;
}
