/***************************************************************************
* Title:          MonoFragments.h
* Author:         Ari Frank
* Copyright (c) 2009 The Regents of the University of California
* All Rights Reserved
* See file LICENSE for details.
***************************************************************************/

/******************************************************************************
Copyright 2008, The Regents of the University of California
All Rights Reserved

Permission to use, copy, modify and distribute any part of this
program for educational, research and non-profit purposes, without fee,
and without a written agreement is hereby granted, provided that the
above copyright notice, this paragraph and the following three paragraphs
appear in all copies.

Those desiring to incorporate this work into commercial
products or use for commercial purposes should contact the Technology
Transfer & Intellectual Property Services, University of California,
San Diego, 9500 Gilman Drive, Mail Code 0910, La Jolla, CA 92093-0910,
Ph: (858) 534-5815, FAX: (858) 534-7345, E-MAIL:invent@ucsd.edu.

IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY
FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE, EVEN
IF THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY
OF SUCH DAMAGE.

THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND THE UNIVERSITY
OF CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES,
ENHANCEMENTS, OR MODIFICATIONS.  THE UNIVERSITY OF CALIFORNIA MAKES NO
REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER IMPLIED OR
EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE, OR THAT THE USE OF
THE SOFTWARE WILL NOT INFRINGE ANY PATENT, TRADEMARK OR OTHER RIGHTS.

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
*******************************************************************************/


#ifndef __MONOFRAGMENTS_H__
#define __MONOFRAGMENTS_H__

#include "includes.h"

typedef enum FragmentDir  { PREFIX, SUFFIX } FragmentDir;
typedef enum FragmentType { STRONG, WEAK   } FragmentType;

class MonoFragment {
	friend class FragmentSet;
public:
	MonoFragment() : label(""), direction(PREFIX), type(STRONG), offset(0) {};
	MonoFragment(string _label,FragmentDir _direction, FragmentType _type, mass_t _offset) :
				label(_label), direction(_direction), type(_type), offset(_offset) {};

	// totalMonoMassWith18
	mass_t calcExpFragMass(mass_t cutMass, mass_t totalMonoMassWith18) const
	{
		mass_t actualCutMass = (direction == PREFIX) ? cutMass : totalMonoMassWith18 - cutMass;
		return actualCutMass + offset;
	}

	mass_t calcExpCutMass(mass_t fragMass, mass_t totalMonoMassWith18) const
	{
		if (direction == PREFIX)
			return fragMass - offset;

		return (totalMonoMassWith18 - fragMass) + offset;
	}

	FragmentDir getDirection() const { return direction; }

	void print(ostream& os = cout);

	string getLabel() const { return label; }

private:
	string		 label;
	FragmentDir  direction;
	FragmentType type; 
	mass_t		 offset;
	
};


class FragmentSet {
public:
	void calcFragmentSetMonoMasses(mass_t cuttMass, mass_t totalMonoMass, vector<mass_t>& masses) const;

	void initECD();

	int	getNumFragments() const { return fragments.size(); }

	const MonoFragment& getFragment(int idx) const { return fragments[idx]; }

	void printFragments() const;

	void printFragmentNames(ostream& os = cout) const;

	const vector<int>& getStrongFragmentIdxs() const { return strongFragmentIdxs; }

private:
	vector<MonoFragment> fragments;

	vector<int>	strongFragmentIdxs; // idxs of fragments to be used to extrapolate prefix masses

};





#endif

