/***************************************************************************
* Title:          MonoSpectrum.h
* Author:         Ari Frank
* Copyright (c) 2009 The Regents of the University of California
* All Rights Reserved
* See file LICENSE for details.
***************************************************************************/

/******************************************************************************
Copyright 2008, The Regents of the University of California
All Rights Reserved

Permission to use, copy, modify and distribute any part of this
program for educational, research and non-profit purposes, without fee,
and without a written agreement is hereby granted, provided that the
above copyright notice, this paragraph and the following three paragraphs
appear in all copies.

Those desiring to incorporate this work into commercial
products or use for commercial purposes should contact the Technology
Transfer & Intellectual Property Services, University of California,
San Diego, 9500 Gilman Drive, Mail Code 0910, La Jolla, CA 92093-0910,
Ph: (858) 534-5815, FAX: (858) 534-7345, E-MAIL:invent@ucsd.edu.

IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY
FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE, EVEN
IF THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY
OF SUCH DAMAGE.

THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND THE UNIVERSITY
OF CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES,
ENHANCEMENTS, OR MODIFICATIONS.  THE UNIVERSITY OF CALIFORNIA MAKES NO
REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER IMPLIED OR
EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE, OR THAT THE USE OF
THE SOFTWARE WILL NOT INFRINGE ANY PATENT, TRADEMARK OR OTHER RIGHTS.

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
*******************************************************************************/



#ifndef __MSMSSPECTRUM_H__
#define __MSMSSPECTRUM_H__

#include "includes.h"
#include "ProteinSequence.h"
#include "BasicDataStructs.h"
#include "MonoFragments.h"



typedef enum AlignmentDir { ALIGN_DIR1, ALIGN_DIR2, ALIGN_BOTH } AlignmentDir; 

class Spectrum;


static int runningSpectrumIdx = 0;



// A peak that is read from the spectrum file
struct MonoPeak {
	MonoPeak() : monoMass(0), minMass(0), maxMass(0), orgMz(0), charge(0), intensity(0) {};

	bool operator< (const MonoPeak& other) const
	{
		return (monoMass < other.monoMass);
	}
	
	mass_t monoMass;
	mass_t minMass; // lower boundry according to fragmentPeakPPM
	mass_t maxMass; // upper boundry according to fragmentPeakPPM

	mass_t orgMz;
	int    charge;
	
	intensity_t intensity;
	
};





// A spectrum that is read from the spectrum files
// Same class for all MS levels
class MonoSpectrum {
	friend class SpectrumForest;
public:
	MonoSpectrum() : spectrumPath(NULL), depth(-1), spectrumIdx(-1), parentSpectrumIdx(-1), 
						 parentPeakIdx(-1),  parentPeakPPM(-1), fragmentPeakPPM(-1),
						 parentMonoMass(-1), minParentMonoMass(-1), maxParentMonoMass(-1),
						 totalIntensity(0) {};

	char	*getSpectrumPath() const { return spectrumPath; }

	int		getDepth() const { return depth; }
	void	setDepth(int _depth) { depth = _depth; }

	int		getSpectrumIdx() const { return spectrumIdx; }
	int		getParentSpectrumIdx() const { return parentSpectrumIdx; }

	mass_t  getParentMonoMass() const { return parentMonoMass; }
	void	setParentMonoMass(mass_t pm) { parentMonoMass = pm; }
	mass_t	getParentPeakPPM() const { return parentPeakPPM; }
	void	setParentPeakPPM(mass_t _parentPPM) { parentPeakPPM = _parentPPM; }

	mass_t  getFragmentPeakPPM() const { return fragmentPeakPPM; }
	void	setFragmentPeakPPM(mass_t _fragmentPPM) { fragmentPeakPPM = _fragmentPPM; }

	score_t getTotalIntensity() const { return totalIntensity; }

	int		getNumMonoPeaks() const { return monoPeaks.size(); }
	const vector<MonoPeak>& getMonoPeaks() const { return monoPeaks; }

	int		getNumDaughterSpectra() const { return daughterSpectraIdxs.size(); }
	const vector<int>& getDaughterSpectra() const { return daughterSpectraIdxs; }

	int		readMonoMassPeakList(char *_spectrumPath, mass_t _precursorPeakPPM, 
								 mass_t _fragmentPeakPPM = -1);

	int		readAllPeakList(char *_spectrumPath, mass_t _precursorPeakPPM, 
								 mass_t _fragmentPeakPPM = -1);

	int		getNumMonoPeaksInRange(mass_t minMass, mass_t maxMass, int *firstIdx) const;

	void	findFragmentPeaks(const ProteinSequence& ps, const FragmentSet& fs,
							  vector< vector<int> >& peakIdxs) const;

	intensity_t	scoreSpectrumMatch(const ProteinSequence& ps, const FragmentSet& fs,
								   int& numMatchedPeaks) const;

	void	convertToCutPeaks(const FragmentSet& fs, vector<CutPeak>& cutPeaks) const;

	void	printMatchedFragPositions(const FragmentSet& fs, const ProteinSequence& ps, 
								vector< vector<int> >& peakIdxs) const;

	void	print(ostream& os = cout) const;

private:

	char * spectrumPath;

	int	   depth;				// depth in the tree MS1/MS2/MS3...
	int	   spectrumIdx;
	int	   parentSpectrumIdx;
	int	   parentPeakIdx;

	mass_t parentPeakPPM;
	mass_t fragmentPeakPPM;

	mass_t parentMonoMass;
	mass_t minParentMonoMass;
	mass_t maxParentMonoMass;

	score_t totalIntensity;
	
	vector<MonoPeak> monoPeaks;
	vector<int>      daughterSpectraIdxs;

	vector<mass_t> monoPeaksMap;
};





#endif

