/***************************************************************************
* Title:          SpectrumAlignment.h
* Author:         Ari Frank
* Copyright (c) 2009 The Regents of the University of California
* All Rights Reserved
* See file LICENSE for details.
***************************************************************************/

#ifndef __SPECTRUMALIGNMENT_H__
#define __SPECTRUMALIGNMENT_H__


struct PeakIdxPair {
	PeakIdxPair() : idx1(-1), idx2(-1) {};

	int idx1,idx2;
};


struct RegularPeakAlignment {

	int		spectrumIdx1;
	int		spectrumIdx2;

	mass_t	shiftSize;			// the delta in mass M(spectrum 1) - M(spectrum 2)
	int		numAlignedPeaks;	// number of shift and noshift peaks
	score_t	alignmentScore;	    // score of the shift and no shift peaks
	int		maxAlignedPeaks;
	score_t	maxAlignedScore;

	score_t alignmentQualityScore; // facors the number of peaks and scores in some magic way

	vector<PeakIdxPair> noShiftPairs;
	vector<PeakIdxPair> shiftPairs;
};


struct InternalPeakAlignment {

};





#endif