/***************************************************************************
* Title:          SpectrumTree.h
* Author:         Ari Frank
* Copyright (c) 2009 The Regents of the University of California
* All Rights Reserved
* See file LICENSE for details.
***************************************************************************/

#ifndef __SPECTRUMTREE_H__
#define __SPECTRUMTREE_H__

#include "MassSpectrum.h"

// Manages the tree structure for a single protein variants spectra
// Assumes all spectra are already linked to their precursorSpectra
class SpectrumTree {
public:

	void initTree(int _topLevelIdx = 0);

	int readSpectrumFile(char *fileName)

	void printTreeStructure(ostream& os = cout) const;

private:

	vector<char *> spectraFiles;

	int topLevelIdx;	// ususally 0 unless different proteins/variants are involved

	mass_t monoPrecursorMass;
	mass_t precursorPPM;
	mass_t fragmentPPM;


	vector<MergedSpectrum> spectra;

	int recursivePrintStruct(TandemSpectrum   *spectrum, ostream& os) const;

	void recursiveMergeSpectra(int idx);
};


#endif