/*
 * Decompiled with CFR 0.152.
 */
package basicUtils;

import basicUtils.InspectAnnotation;
import basicUtils.Utils;
import errorUtils.ErrorThrower;
import java.awt.Color;
import java.awt.Paint;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import javax.imageio.ImageIO;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.jfree.ui.ApplicationFrame;
import trieUtils.TrieDB;

public class ChooseProteins {
    public static String UsageInfo = "basicUtils.ChooseProteins version 1.31.2011\nCounts peptides and reports protein counts in one of several ways:\n 0. Parsimony : Greedily chooses proteins based on peptide count, each peptide only counts towards one protein\n 1. Maximony : Chooses all proteins with more than 2 peptides, each peptide counts towards all proteins\n 2. Score : Computes a probability of the protein being selected using lFDR\n 3. Unique : Only reports proteins which have at least one unique peptide\n[REQUIRED]:\n -r [FILE/DIR] File or directory containing files of Inspect results\n -t [NUM] this specifies the proteome trie file\n -c [NUM] 0: Parsimony, 1: Maximony, 2: Score, 3: Unique\n -m [NUM] if Maximony is used, this specifies the min number of peptides per protein\n -s [NUM] if Score is used, this specificies the min probability of the protein\n[OPTIONAL]:\n -w [FILE] File to write tabulated results to\n -f [FILE] Write selected proteins to FASTA file \n -p [FILE] Draw the discovery curve of peptides and proteins\n -d Run in debug mode\n -g Report number of genes also\n";
    private int Scheme = -1;
    private String[] InputFiles = null;
    private TrieDB Proteome = null;
    private String OutputFile = null;
    private int MinPep = -1;
    private double MinProb = -1.0;
    private boolean Debug = false;
    private String PlotFile = null;
    private Hashtable Protein2Peptide;
    private Hashtable Protein2Name;
    private Hashtable Peptide2Protein;
    private Hashtable Peptide2Type;
    private ArrayList FinalProteinList;
    private Hashtable FinalPeptide2Protein;
    private Hashtable FinalCoverage;
    private Hashtable Peptide2BestLFDR;
    private Hashtable FinalProtein2Peptides;
    private int[] DiscoveryCurveCounts;
    private int[] specCounts;
    private int[] ProteinCounts;
    private boolean reportGenes = false;
    private String fastaFileName = null;

    public ChooseProteins(String[] InputFiles, TrieDB Proteome) {
        this.InputFiles = InputFiles;
        this.Proteome = Proteome;
    }

    public ChooseProteins(String InputDir, String OutputFile, int Scheme, String PlotFile, String Proteome, int MinPep, double MinProb, boolean reportGenes, String fastaFile) {
        if (Utils.IsDir(InputDir)) {
            this.InputFiles = Utils.ListDir(InputDir);
            this.OutputFile = OutputFile;
        } else {
            this.InputFiles = new String[1];
            this.InputFiles[0] = InputDir;
            this.OutputFile = OutputFile;
        }
        this.Scheme = Scheme;
        this.Proteome = new TrieDB(Proteome);
        this.PlotFile = PlotFile;
        this.reportGenes = reportGenes;
        if (this.Scheme == 1) {
            this.MinPep = MinPep;
        } else if (this.Scheme == 2) {
            this.MinProb = MinProb;
        }
        this.fastaFileName = fastaFile;
    }

    public void ChooseWisely() {
        this.PopulateHashes();
        System.out.println("Total Peptides loaded: " + this.Peptide2Protein.size());
        System.out.println("Total Proteins to consider: " + this.Protein2Name.size());
        if (this.Scheme == 0) {
            this.ChooseProteinsParsimony();
        } else if (this.Scheme == 1) {
            this.ChooseProteinsMaximony();
        } else if (this.Scheme == 2) {
            this.ChooseProteinsScore();
        } else if (this.Scheme == 3) {
            this.ChooseProteinsUniquely();
        }
        System.out.println("Total proteins accepted: " + this.FinalProteinList.size());
        if (this.OutputFile != null) {
            System.out.println("Writing final protein list to " + this.OutputFile);
            this.WriteOutput();
        }
        if (this.PlotFile != null) {
            this.PlotDiscoveryCurve();
        }
        if (this.fastaFileName != null) {
            this.writeFASTAFile();
        }
    }

    private void writeFASTAFile() {
        System.out.println("Writing protein sequences to " + this.fastaFileName);
        FileWriter f = null;
        try {
            f = new FileWriter(this.fastaFileName);
        }
        catch (IOException E) {
            E.printStackTrace();
            return;
        }
        int i = 0;
        while (i < this.FinalProteinList.size()) {
            int currProt = (Integer)this.FinalProteinList.get(i);
            String protName = this.Proteome.getProteinName(currProt);
            String protSeq = this.Proteome.getProteinSequence(currProt);
            try {
                f.write(">" + protName + "\n" + protSeq + "\n");
            }
            catch (IOException E) {
                E.printStackTrace();
                return;
            }
            ++i;
        }
        try {
            f.close();
        }
        catch (IOException E) {
            E.printStackTrace();
            return;
        }
    }

    private void ChooseProteinsUniquely() {
        this.FinalProteinList = new ArrayList();
        this.FinalPeptide2Protein = new Hashtable();
        this.FinalProtein2Peptides = new Hashtable();
        this.FinalCoverage = new Hashtable();
        Enumeration E = this.Protein2Peptide.keys();
        boolean MaxPeptides = false;
        int ProteinID = -1;
        while (E.hasMoreElements()) {
            int CurrProteinID = (Integer)E.nextElement();
            int uniqueCount = 0;
            ArrayList<String> uniquePeptides = new ArrayList<String>();
            ArrayList Peptides = (ArrayList)this.Protein2Peptide.get(CurrProteinID);
            int pep = 0;
            while (pep < Peptides.size()) {
                String currPep = (String)Peptides.get(pep);
                if (!this.Peptide2Protein.containsKey(currPep)) {
                    System.out.println("EEK! We have no record of proteins from " + currPep + ", but we know it matches to " + CurrProteinID);
                    Utils.WaitForEnter();
                } else {
                    ArrayList protList = (ArrayList)this.Peptide2Protein.get(currPep);
                    if (protList == null || protList.size() == 0) {
                        System.out.println("EEK! Protein list is empty/null from " + currPep + ", but we know it matches to " + CurrProteinID);
                        Utils.WaitForEnter();
                    } else if (protList.size() == 1) {
                        ++uniqueCount;
                        uniquePeptides.add(currPep);
                    }
                }
                ++pep;
            }
            if (uniqueCount <= 0) continue;
            this.FinalProteinList.add(new Integer(CurrProteinID));
            this.FinalProtein2Peptides.put(new Integer(CurrProteinID), uniquePeptides);
            this.FinalCoverage.put(new Integer(CurrProteinID), this.ComputeProteinCoverage(CurrProteinID, uniquePeptides));
            int i = 0;
            while (i < uniquePeptides.size()) {
                ArrayList<Integer> ProtList = new ArrayList<Integer>();
                ProtList.add(new Integer(CurrProteinID));
                this.FinalPeptide2Protein.put((String)uniquePeptides.get(i), ProtList);
                ++i;
            }
        }
    }

    private void PlotDiscoveryCurve() {
        String title = "Peptide and ProteinDiscoveryCurve (" + Utils.GetVersion() + ")";
        ApplicationFrame F = new ApplicationFrame(title);
        XYSeries series1 = new XYSeries((Comparable)((Object)"Peptides"));
        XYSeries series2 = new XYSeries((Comparable)((Object)"Proteins"));
        int cumCount = 0;
        int i = 0;
        while (i < this.DiscoveryCurveCounts.length) {
            series1.add((double)(cumCount += this.specCounts[i]), (double)this.DiscoveryCurveCounts[i]);
            series2.add((double)cumCount, (double)this.ProteinCounts[i]);
            ++i;
        }
        XYSeriesCollection dataset = new XYSeriesCollection();
        dataset.addSeries(series1);
        dataset.addSeries(series2);
        JFreeChart chart = ChartFactory.createXYLineChart((String)title, (String)"Spectra", (String)"Counts", (XYDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        chart.setBackgroundPaint((Paint)Color.white);
        XYPlot plot = chart.getXYPlot();
        plot.setBackgroundPaint((Paint)Color.lightGray);
        plot.setDomainGridlinePaint((Paint)Color.white);
        plot.setRangeGridlinePaint((Paint)Color.white);
        XYLineAndShapeRenderer renderer = new XYLineAndShapeRenderer();
        renderer.setSeriesLinesVisible(0, false);
        renderer.setSeriesShapesVisible(1, false);
        plot.setRenderer((XYItemRenderer)renderer);
        NumberAxis rangeAxis = (NumberAxis)plot.getRangeAxis();
        rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        BufferedImage Image2 = chart.createBufferedImage(1000, 1000);
        String ScoreFileName = this.PlotFile;
        System.out.println("Created discovery curve..." + ScoreFileName);
        try {
            ImageIO.write((RenderedImage)Image2, "png", new File(ScoreFileName));
        }
        catch (Exception E) {
            System.err.println(E.getMessage());
            return;
        }
    }

    public static ArrayList loadAllProteins(String fileName) {
        BufferedReader buf = null;
        String line = null;
        try {
            buf = new BufferedReader(new FileReader(fileName));
            line = buf.readLine();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        ArrayList<Object[]> ret = new ArrayList<Object[]>();
        while (line != null) {
            if ((line = line.trim()).length() == 0 || line.charAt(0) == '#') {
                try {
                    line = buf.readLine();
                    continue;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return null;
                }
            }
            Object[] el = new Object[5];
            String[] bits = line.split("\t");
            el[0] = bits[0];
            el[1] = new Double(bits[1]);
            el[2] = new Integer(bits[2]);
            el[3] = bits[3].split(",");
            el[4] = bits.length > 4 ? bits[4].split(",") : null;
            ret.add(el);
            try {
                line = buf.readLine();
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }
        try {
            buf.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        return ret;
    }

    public static ArrayList loadAllLoci(String fileName) {
        BufferedReader buf = null;
        String line = null;
        try {
            buf = new BufferedReader(new FileReader(fileName));
            line = buf.readLine();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        ArrayList<Object[]> ret = new ArrayList<Object[]>();
        while (line != null) {
            if ((line = line.trim()).length() == 0 || line.charAt(0) == '#') {
                try {
                    line = buf.readLine();
                    continue;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return null;
                }
            }
            Object[] el = new Object[4];
            String[] bits = line.split("\t");
            el[0] = bits[0];
            el[1] = new Integer(bits[1]);
            el[2] = bits[2].split(",");
            el[3] = bits.length > 3 ? bits[3].split(",") : null;
            ret.add(el);
            try {
                line = buf.readLine();
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }
        try {
            buf.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        return ret;
    }

    public static String[] loadPeptidesFromChosenFile(String fileName) {
        HashSet<String> peps = new HashSet<String>();
        BufferedReader buf = null;
        String line = null;
        try {
            buf = new BufferedReader(new FileReader(fileName));
            line = buf.readLine();
        }
        catch (IOException E) {
            ErrorThrower.ThrowError(5, fileName);
        }
        while (line != null) {
            String pep;
            if ((line = line.trim()).length() == 0 || line.charAt(0) == '#') {
                try {
                    line = buf.readLine();
                }
                catch (IOException E) {
                    ErrorThrower.ThrowError(6, fileName);
                }
                continue;
            }
            String[] bits = line.split("\t");
            String[] uPeps = bits[3].split(",");
            String[] sPeps = null;
            if (bits.length >= 5) {
                sPeps = bits[4].split(",");
            }
            int i = 0;
            while (i < uPeps.length) {
                pep = uPeps[i];
                if (pep.indexOf(46) >= 0) {
                    pep = pep.split(".")[1];
                }
                peps.add(pep);
                ++i;
            }
            i = 0;
            while (sPeps != null && i < sPeps.length) {
                pep = sPeps[i];
                if (pep.indexOf(46) >= 0) {
                    pep = pep.split(".")[1];
                }
                peps.add(pep);
                ++i;
            }
            try {
                line = buf.readLine();
            }
            catch (IOException E) {
                ErrorThrower.ThrowError(6, fileName);
            }
        }
        try {
            buf.close();
        }
        catch (IOException E) {
            ErrorThrower.ThrowError(8, fileName);
        }
        return Utils.ConvertHashSetToStringArray(peps);
    }

    private void WriteOutput() {
        FileWriter f = null;
        try {
            f = new FileWriter(this.OutputFile);
            f.write("#ProteinName\tCoverage\tNumPeptides\tUniquePeptides\tSharedPeptides\n");
        }
        catch (IOException E) {
            E.printStackTrace();
            System.exit(-1);
        }
        ArrayList<String> Uniques = new ArrayList<String>();
        ArrayList<String> Nots = new ArrayList<String>();
        int i = 0;
        while (i < this.FinalProteinList.size()) {
            Integer ProteinID = (Integer)this.FinalProteinList.get(i);
            String ProteinName = this.Proteome.getProteinName(ProteinID);
            Uniques.clear();
            Nots.clear();
            ArrayList Peps = (ArrayList)this.FinalProtein2Peptides.get(ProteinID);
            int k = 0;
            while (k < Peps.size()) {
                String CurrPep = (String)Peps.get(k);
                if (((ArrayList)this.FinalPeptide2Protein.get(CurrPep)).size() > 1) {
                    Nots.add(CurrPep);
                } else {
                    Uniques.add(CurrPep);
                }
                ++k;
            }
            try {
                f.write(String.valueOf(ProteinName) + "\t" + (Double)this.FinalCoverage.get(ProteinID) + "\t" + ((ArrayList)this.FinalProtein2Peptides.get(ProteinID)).size() + "\t" + Utils.JoinStringArray(Utils.ConvertArraylistToStringArray(Uniques), ",") + "\t" + Utils.JoinStringArray(Utils.ConvertArraylistToStringArray(Nots), ",") + "\n");
            }
            catch (IOException E) {
                E.printStackTrace();
                System.exit(-1);
            }
            ++i;
        }
        try {
            f.close();
        }
        catch (IOException E) {
            E.printStackTrace();
            System.exit(-1);
        }
    }

    private void ChooseProteinsParsimony() {
        this.FinalProteinList = new ArrayList();
        this.FinalPeptide2Protein = new Hashtable();
        this.FinalProtein2Peptides = new Hashtable();
        this.FinalCoverage = new Hashtable();
        while (this.Protein2Peptide.size() > 0) {
            Enumeration E = this.Protein2Peptide.keys();
            int MaxPeptides = 0;
            int ProteinID = -1;
            while (E.hasMoreElements()) {
                int CurrProteinID = (Integer)E.nextElement();
                ArrayList Peptides = (ArrayList)this.Protein2Peptide.get(CurrProteinID);
                if (Peptides.size() <= MaxPeptides) continue;
                MaxPeptides = Peptides.size();
                ProteinID = CurrProteinID;
            }
            if (MaxPeptides == 0) break;
            if (this.Debug) {
                System.out.println("Chose protein " + ProteinID + " with " + MaxPeptides + " peptides");
                System.out.println((String)this.Protein2Name.get(new Integer(ProteinID)));
            }
            ArrayList ChosenPeps = (ArrayList)this.Protein2Peptide.remove(new Integer(ProteinID));
            this.FinalProtein2Peptides.put(new Integer(ProteinID), ChosenPeps);
            this.FinalProteinList.add(new Integer(ProteinID));
            this.FinalCoverage.put(new Integer(ProteinID), this.ComputeProteinCoverage(ProteinID, ChosenPeps));
            ArrayList<Integer> ProtList = new ArrayList<Integer>();
            ProtList.add(new Integer(ProteinID));
            int i = 0;
            while (i < ChosenPeps.size()) {
                this.FinalPeptide2Protein.put((String)ChosenPeps.get(i), ProtList);
                ArrayList OtherProteins = (ArrayList)this.Peptide2Protein.get((String)ChosenPeps.get(i));
                int j = 0;
                while (j < OtherProteins.size()) {
                    Integer OtherProteinID = (Integer)OtherProteins.get(j);
                    if (!this.FinalProteinList.contains(OtherProteinID)) {
                        ArrayList OtherProteinPeps = (ArrayList)this.Protein2Peptide.get(OtherProteinID);
                        OtherProteinPeps.remove((String)ChosenPeps.get(i));
                        this.Protein2Peptide.put(OtherProteinID, OtherProteinPeps);
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    private void ChooseProteinsScore() {
        boolean LocalDebug = false;
        this.FinalProteinList = new ArrayList();
        this.FinalPeptide2Protein = new Hashtable();
        this.FinalProtein2Peptides = new Hashtable();
        this.FinalCoverage = new Hashtable();
        Enumeration E = this.Protein2Peptide.keys();
        boolean MaxPeptides = false;
        while (E.hasMoreElements()) {
            int CurrProteinID = (Integer)E.nextElement();
            ArrayList Peptides = (ArrayList)this.Protein2Peptide.get(CurrProteinID);
            double Prob = this.ComputeProb(Peptides);
            if (LocalDebug) {
                String Name = (String)this.Protein2Name.get(new Integer(CurrProteinID));
                System.out.println("Considering protein " + Name + " : " + Prob);
            }
            if (!(Prob >= this.MinProb)) continue;
            this.FinalProteinList.add(new Integer(CurrProteinID));
            this.FinalProtein2Peptides.put(new Integer(CurrProteinID), Peptides);
            this.FinalCoverage.put(new Integer(CurrProteinID), this.ComputeProteinCoverage(CurrProteinID, Peptides));
            int i = 0;
            while (i < Peptides.size()) {
                ArrayList ProtList = this.FinalPeptide2Protein.containsKey((String)Peptides.get(i)) ? (ArrayList)this.FinalPeptide2Protein.get((String)Peptides.get(i)) : new ArrayList();
                ProtList.add(new Integer(CurrProteinID));
                this.FinalPeptide2Protein.put((String)Peptides.get(i), ProtList);
                ++i;
            }
        }
    }

    private double ComputeProb(ArrayList Peptides) {
        double Ret = 1.0;
        int i = 0;
        while (i < Peptides.size()) {
            double LocationCount = ((ArrayList)this.Peptide2Protein.get((String)Peptides.get(i))).size();
            double LocalFDR = (Double)this.Peptide2BestLFDR.get((String)Peptides.get(i));
            Ret *= 1.0 - (1.0 - LocalFDR) / LocationCount;
            ++i;
        }
        return 1.0 - Ret;
    }

    private void ChooseProteinsMaximony() {
        this.FinalProteinList = new ArrayList();
        this.FinalPeptide2Protein = new Hashtable();
        this.FinalProtein2Peptides = new Hashtable();
        this.FinalCoverage = new Hashtable();
        Enumeration E = this.Protein2Peptide.keys();
        while (E.hasMoreElements()) {
            int CurrProteinID = (Integer)E.nextElement();
            ArrayList Peptides = (ArrayList)this.Protein2Peptide.get(CurrProteinID);
            if (Peptides.size() < this.MinPep) continue;
            if (this.Debug) {
                System.out.println("Chose protein " + CurrProteinID + " with " + Peptides.size() + " peptides");
                System.out.println((String)this.Protein2Name.get(new Integer(CurrProteinID)));
            }
            this.FinalProtein2Peptides.put(new Integer(CurrProteinID), Peptides);
            this.FinalProteinList.add(new Integer(CurrProteinID));
            this.FinalProtein2Peptides.put(new Integer(CurrProteinID), Peptides);
            this.FinalCoverage.put(new Integer(CurrProteinID), new Double(this.ComputeProteinCoverage(CurrProteinID, Peptides)));
            int i = 0;
            while (i < Peptides.size()) {
                ArrayList ProtList = this.FinalPeptide2Protein.containsKey((String)Peptides.get(i)) ? (ArrayList)this.FinalPeptide2Protein.get((String)Peptides.get(i)) : new ArrayList();
                ProtList.add(new Integer(CurrProteinID));
                this.FinalPeptide2Protein.put((String)Peptides.get(i), ProtList);
                ++i;
            }
        }
    }

    private double ComputeProteinCoverage(int ProteinID, ArrayList Peptides) {
        String CurrProtein = this.Proteome.getProteinSequence(ProteinID);
        boolean[] Covered = new boolean[CurrProtein.length()];
        double CoveredCount = 0.0;
        int i = 0;
        while (i < Peptides.size()) {
            int Index;
            String CurrPeptide = (String)Peptides.get(i);
            int j = Index = CurrProtein.indexOf(CurrPeptide);
            while (j < Index + CurrPeptide.length()) {
                if (!Covered[j]) {
                    CoveredCount += 1.0;
                }
                Covered[j] = true;
                ++j;
            }
            ++i;
        }
        return CoveredCount / (double)Covered.length;
    }

    private void PopulateHashes() {
        this.Protein2Name = new Hashtable();
        this.Protein2Peptide = new Hashtable();
        this.Peptide2Protein = new Hashtable();
        this.Peptide2Type = new Hashtable();
        if (this.PlotFile != null) {
            if (this.Scheme == 0) {
                System.out.println("WARNING: Unable to draw protein discovery curve in Parsimony mode, drawing in Maximony mode instead");
            }
            this.DiscoveryCurveCounts = new int[this.InputFiles.length];
            this.specCounts = new int[this.InputFiles.length];
            this.ProteinCounts = new int[this.InputFiles.length];
        }
        ArrayList<String> CurrPeptides = new ArrayList<String>();
        if (this.Scheme == 2) {
            this.Peptide2BestLFDR = new Hashtable();
        }
        this.InputFiles = (String[])Utils.SortIncreasingOrder((Comparable[])this.InputFiles);
        int i = 0;
        while (i < this.InputFiles.length) {
            String CurrPeptide;
            if (this.PlotFile != null) {
                this.specCounts[i] = this.InputFiles[i].indexOf("Maize-Endosperm-10DAP_Clustered.20.fil") >= 0 ? 20826 : (this.InputFiles[i].indexOf("Maize-Endosperm-10DAP") >= 0 || this.InputFiles[i].indexOf("Maize-Endosperm-12DAP") >= 0 ? 40000 : 20000);
                System.out.println("Loading peptides from " + this.InputFiles[i] + ", " + this.specCounts[i] + " spectra");
            }
            InspectAnnotation[] Anns = InspectAnnotation.LoadInspectResultsFile(this.InputFiles[i]);
            int j = 0;
            while (j < Anns.length) {
                CurrPeptide = Utils.GetUnModded(Anns[j].Annotation);
                if (this.Peptide2BestLFDR != null) {
                    if (!this.Peptide2BestLFDR.containsKey(CurrPeptide)) {
                        this.Peptide2BestLFDR.put(CurrPeptide, new Double(Anns[j].LocalFDR));
                    } else {
                        double OldVal = (Double)this.Peptide2BestLFDR.get(CurrPeptide);
                        if (Anns[j].LocalFDR < OldVal) {
                            this.Peptide2BestLFDR.put(CurrPeptide, new Double(Anns[j].LocalFDR));
                        }
                    }
                }
                if (!this.Peptide2Protein.containsKey(CurrPeptide) && !CurrPeptides.contains(CurrPeptide)) {
                    CurrPeptides.add(CurrPeptide);
                    if (CurrPeptides.size() >= 5000) {
                        if (this.Debug) {
                            System.out.println("Loaded " + CurrPeptides.size() + " peptides 2 search");
                        }
                        Hashtable AllLocations = this.Proteome.GetAllLocations(Utils.ConvertArraylistToStringArray(CurrPeptides));
                        int p = 0;
                        while (p < CurrPeptides.size()) {
                            CurrPeptide = (String)CurrPeptides.get(p);
                            ArrayList<Integer> P = new ArrayList<Integer>();
                            ArrayList Locations = (ArrayList)AllLocations.get(CurrPeptide);
                            if (Locations == null || Locations.size() == 0) {
                                System.out.println("WARNING: Peptide '" + CurrPeptide + "' does not have any locations!");
                            } else {
                                int k = 0;
                                while (k < Locations.size()) {
                                    Object[] Loc = (Object[])Locations.get(k);
                                    Integer ProteinID = (Integer)Loc[1];
                                    if (!this.Protein2Name.containsKey(ProteinID)) {
                                        this.Protein2Name.put(ProteinID, (String)Loc[3]);
                                    }
                                    ArrayList L = null;
                                    L = this.Protein2Peptide.containsKey(ProteinID) ? (ArrayList)this.Protein2Peptide.get(ProteinID) : new ArrayList();
                                    L.add(CurrPeptide);
                                    this.Protein2Peptide.put(ProteinID, L);
                                    P.add(ProteinID);
                                    ++k;
                                }
                                this.Peptide2Protein.put(CurrPeptide, P);
                            }
                            ++p;
                        }
                        CurrPeptides.clear();
                    }
                }
                ++j;
            }
            if (this.PlotFile != null && CurrPeptides.size() > 0) {
                if (this.Debug) {
                    System.out.println("Loaded " + CurrPeptides.size() + " peptides 2 search");
                }
                Hashtable AllLocations = this.Proteome.GetAllLocations(Utils.ConvertArraylistToStringArray(CurrPeptides));
                int p = 0;
                while (p < CurrPeptides.size()) {
                    CurrPeptide = (String)CurrPeptides.get(p);
                    ArrayList<Integer> P = new ArrayList<Integer>();
                    ArrayList Locations = (ArrayList)AllLocations.get(CurrPeptide);
                    int k = 0;
                    while (k < Locations.size()) {
                        Object[] Loc = (Object[])Locations.get(k);
                        Integer ProteinID = (Integer)Loc[1];
                        if (!this.Protein2Name.containsKey(ProteinID)) {
                            this.Protein2Name.put(ProteinID, (String)Loc[3]);
                        }
                        ArrayList L = null;
                        L = this.Protein2Peptide.containsKey(ProteinID) ? (ArrayList)this.Protein2Peptide.get(ProteinID) : new ArrayList();
                        L.add(CurrPeptide);
                        this.Protein2Peptide.put(ProteinID, L);
                        P.add(ProteinID);
                        ++k;
                    }
                    this.Peptide2Protein.put(CurrPeptide, P);
                    ++p;
                }
                CurrPeptides.clear();
                System.out.println("Choosing proteins from " + this.Peptide2Protein.size() + " peptides");
                this.DiscoveryCurveCounts[i] = this.Peptide2Protein.size();
                if (this.Scheme == 0 || this.Scheme == 1) {
                    this.ChooseProteinsMaximony();
                } else if (this.Scheme == 2) {
                    this.ChooseProteinsScore();
                }
                this.ProteinCounts[i] = this.FinalProteinList.size();
                System.out.println(String.valueOf(this.DiscoveryCurveCounts[i]) + " " + this.ProteinCounts[i]);
            } else if (this.PlotFile != null) {
                System.out.println("Choosing proteins from " + this.Peptide2Protein.size() + " peptides");
                this.DiscoveryCurveCounts[i] = this.Peptide2Protein.size();
                this.ProteinCounts[i] = this.FinalProteinList.size();
                System.out.println(String.valueOf(this.DiscoveryCurveCounts[i]) + " " + this.ProteinCounts[i]);
            }
            ++i;
        }
        if (CurrPeptides.size() > 0) {
            if (this.Debug) {
                System.out.println("Have " + CurrPeptides.size() + " left over peptides to search!!");
            }
            Hashtable AllLocations = this.Proteome.GetAllLocations(Utils.ConvertArraylistToStringArray(CurrPeptides));
            int p = 0;
            while (p < CurrPeptides.size()) {
                String CurrPeptide = (String)CurrPeptides.get(p);
                ArrayList<Integer> P = new ArrayList<Integer>();
                ArrayList Locations = (ArrayList)AllLocations.get(CurrPeptide);
                if (Locations == null || Locations.size() == 0) {
                    System.out.println("WARNING: Peptide '" + CurrPeptide + "' does not have any locations!");
                } else {
                    int k = 0;
                    while (k < Locations.size()) {
                        Object[] Loc = (Object[])Locations.get(k);
                        Integer ProteinID = (Integer)Loc[1];
                        if (!this.Protein2Name.containsKey(ProteinID)) {
                            this.Protein2Name.put(ProteinID, (String)Loc[3]);
                        }
                        ArrayList L = null;
                        L = this.Protein2Peptide.containsKey(ProteinID) ? (ArrayList)this.Protein2Peptide.get(ProteinID) : new ArrayList();
                        L.add(CurrPeptide);
                        this.Protein2Peptide.put(ProteinID, L);
                        P.add(ProteinID);
                        ++k;
                    }
                    this.Peptide2Protein.put(CurrPeptide, P);
                }
                ++p;
            }
            CurrPeptides.clear();
        }
    }

    public static Hashtable[] ChooseProteinsParsimonyExternal(String[] inputFiles, TrieDB proteome) {
        ChooseProteins chooser = new ChooseProteins(inputFiles, proteome);
        chooser.PopulateHashes();
        chooser.ChooseProteinsParsimony();
        Hashtable[] ret = new Hashtable[]{chooser.FinalPeptide2Protein, chooser.FinalProtein2Peptides};
        return ret;
    }

    public static String[] getPeptides(Object[] currProtein) {
        String uniquePeptideString = Utils.JoinStringArray((String[])currProtein[3], ",");
        String sharedPeptideString = Utils.JoinStringArray((String[])currProtein[4], ",");
        String[] peptideSeqs = null;
        if (uniquePeptideString.length() == 0 && sharedPeptideString.length() != 0) {
            peptideSeqs = sharedPeptideString.split(",");
        } else if (uniquePeptideString.length() != 0 && sharedPeptideString.length() == 0) {
            peptideSeqs = uniquePeptideString.split(",");
        } else if (uniquePeptideString.length() != 0 && sharedPeptideString.length() != 0) {
            uniquePeptideString = String.valueOf(uniquePeptideString) + "," + sharedPeptideString;
            peptideSeqs = uniquePeptideString.split(",");
        } else {
            System.err.println("ERROR: Protein '" + currProtein[0] + "' has no peptides!!");
            System.exit(-1);
        }
        return peptideSeqs;
    }

    public static void main(String[] args) {
        String Proteome;
        String InputDir;
        String[] options = new String[]{"-r", "-w", "-c", "-m", "-s", "-d", "-t", "-p", "-g", "-f"};
        boolean[] blArray = new boolean[10];
        blArray[0] = true;
        blArray[1] = true;
        blArray[2] = true;
        blArray[3] = true;
        blArray[4] = true;
        blArray[6] = true;
        blArray[7] = true;
        blArray[9] = true;
        boolean[] values = blArray;
        Hashtable CommandLineArgs = Utils.ParseCommandLine(args, options, values);
        if (!(CommandLineArgs.containsKey("-r") && CommandLineArgs.containsKey("-c") && CommandLineArgs.containsKey("-t"))) {
            System.err.println("ERROR: Must specify an input file/directory, a proteome file, and a choosing scheme!");
            System.err.println(UsageInfo);
            System.exit(0);
        }
        if (!Utils.IsFile(InputDir = (String)CommandLineArgs.get("-r")) && !Utils.IsDir(InputDir)) {
            System.err.println("ERROR: Invalid file/directory path '" + InputDir + "'!");
            System.err.println(UsageInfo);
            System.exit(-1);
        }
        String OutputDir = null;
        if (CommandLineArgs.containsKey("-w")) {
            OutputDir = (String)CommandLineArgs.get("-w");
        }
        String PlotFile = null;
        if (CommandLineArgs.containsKey("-p")) {
            PlotFile = (String)CommandLineArgs.get("-p");
        }
        if (!Utils.IsFile(Proteome = (String)CommandLineArgs.get("-t"))) {
            System.err.println("ERROR: Invalid proteome file '" + Proteome + "'\n");
            System.err.println(UsageInfo);
            System.exit(-1);
        }
        boolean reportGenes = false;
        if (CommandLineArgs.containsKey("-g")) {
            reportGenes = true;
        }
        int Scheme = Integer.parseInt((String)CommandLineArgs.get("-c"));
        String fastaFile = null;
        if (CommandLineArgs.containsKey("-f")) {
            fastaFile = (String)CommandLineArgs.get("-f");
        }
        ChooseProteins chooser = null;
        if (Scheme == 0) {
            chooser = new ChooseProteins(InputDir, OutputDir, Scheme, PlotFile, Proteome, 0, 0.0, reportGenes, fastaFile);
        } else if (Scheme == 1) {
            int PepCount;
            if (!CommandLineArgs.containsKey("-m") || !CommandLineArgs.containsKey("-t")) {
                System.err.println("ERROR: Must specify peptide/protein with -m option and proteome file with -t option to use Maximony scheme\n");
                System.err.println(UsageInfo);
                System.exit(-1);
            }
            if ((PepCount = Integer.parseInt((String)CommandLineArgs.get("-m"))) <= 0) {
                System.err.println("ERROR: Must specify peptide/protein > 0 with -m option to use Maximony scheme\n");
                System.err.println(UsageInfo);
                System.exit(-1);
            }
            chooser = new ChooseProteins(InputDir, OutputDir, Scheme, PlotFile, Proteome, PepCount, 0.0, reportGenes, fastaFile);
        } else if (Scheme == 2) {
            double MinProb;
            if (!CommandLineArgs.containsKey("-s")) {
                System.err.println("ERROR: Must specify protein probability with -s option to use Score-based scheme\n");
                System.err.println(UsageInfo);
                System.exit(-1);
            }
            if ((MinProb = Double.parseDouble((String)CommandLineArgs.get("-s"))) < 0.0 || MinProb > 1.0) {
                System.err.println("ERROR: Must specify valid protein probability  with -s option to use MScore-based scheme\n");
                System.err.println(UsageInfo);
                System.exit(-1);
            }
            chooser = new ChooseProteins(InputDir, OutputDir, Scheme, PlotFile, Proteome, 0, MinProb, reportGenes, fastaFile);
        } else if (Scheme == 3) {
            chooser = new ChooseProteins(InputDir, OutputDir, Scheme, PlotFile, Proteome, 0, 0.0, reportGenes, fastaFile);
        }
        if (CommandLineArgs.containsKey("-d")) {
            chooser.Debug = true;
        }
        chooser.ChooseWisely();
    }
}

