/*
 * Decompiled with CFR 0.152.
 */
package basicUtils;

import basicUtils.Utils;
import errorUtils.ErrorThrower;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;

public class GFFFile {
    public static String UsageInfo = "basicUtils.GFFFile version 9.16.2010\nCreates a shuffled proteome GFF file, as if the chromosome was reversed.\n[REQUIRED]:\n -r [FILE] File or directory containing files of Inspect results\n -w [FILE] the output file containing both forward and shuffled gene coordinates\n[OPTIONAL]:\n -d run in debug mode\n";

    public static int ParseStrand(String StrandEl) {
        if (StrandEl.compareTo("+") == 0 || StrandEl.compareTo("1") == 0) {
            return 1;
        }
        if (StrandEl.compareTo("-") == 0 || StrandEl.compareTo("0") == 0) {
            return 0;
        }
        if (StrandEl.compareTo(".") == 0) {
            return 2;
        }
        System.err.println("WARNING: UNABLE TO DETERMINE STRAND FROM : " + StrandEl);
        return -10;
    }

    public static String toString(String[] Bits, String delim) {
        String ret = String.valueOf(Bits[GFFColumns.SequenceName]) + delim;
        ret = String.valueOf(ret) + Bits[GFFColumns.Source] + delim;
        ret = String.valueOf(ret) + Bits[GFFColumns.FeatureType] + delim;
        ret = String.valueOf(ret) + Bits[GFFColumns.Start] + delim;
        ret = String.valueOf(ret) + Bits[GFFColumns.End] + delim;
        ret = String.valueOf(ret) + Bits[GFFColumns.Score] + delim;
        ret = String.valueOf(ret) + Bits[GFFColumns.Strand] + delim;
        ret = String.valueOf(ret) + Bits[GFFColumns.Frame] + delim;
        ret = String.valueOf(ret) + Bits[GFFColumns.Attributes];
        return ret;
    }

    public static int[] getRange(String GFFLine) {
        String[] bits = GFFLine.split("\t");
        int[] ret = new int[]{Integer.parseInt(bits[GFFColumns.Start]), Integer.parseInt(bits[GFFColumns.End])};
        return ret;
    }

    public static Hashtable loadIntoSequenceNameHashSorted(String inputFile, String featureName) {
        BufferedReader buf = null;
        String Line = null;
        try {
            buf = new BufferedReader(new FileReader(inputFile));
            Line = buf.readLine();
        }
        catch (IOException E) {
            E.printStackTrace();
            return null;
        }
        Hashtable<String, ArrayList> ret = new Hashtable<String, ArrayList>();
        while (Line != null) {
            if ((Line = Line.trim()).length() > 0) {
                String[] els = Line.split("\t");
                if (els.length < GFFColumns.NumColumns) {
                    System.out.println("Short GFFLine: " + Line);
                    try {
                        Line = buf.readLine();
                        continue;
                    }
                    catch (IOException E) {
                        E.printStackTrace();
                        return null;
                    }
                }
                if (featureName == null || els[GFFColumns.FeatureType].toLowerCase().equals(featureName.toLowerCase())) {
                    String seqName = els[GFFColumns.SequenceName].toLowerCase();
                    ArrayList currVals = null;
                    currVals = ret.containsKey(seqName) ? (ArrayList)ret.get(seqName) : new ArrayList();
                    Object[] entry = new Object[]{GFFFile.ParseStrand(els[GFFColumns.Strand]), new Integer(els[GFFColumns.Start]), new Integer(els[GFFColumns.End]), els[GFFColumns.Attributes]};
                    currVals = GFFFile.InsertGFFLineInOrder(currVals, entry);
                    ret.put(seqName, currVals);
                }
            }
            try {
                Line = buf.readLine();
            }
            catch (IOException E) {
                E.printStackTrace();
                return null;
            }
        }
        try {
            buf.close();
        }
        catch (IOException E) {
            E.printStackTrace();
            return null;
        }
        return ret;
    }

    private static ArrayList InsertGFFLineInOrder(ArrayList currVals, Object[] entry) {
        if (currVals == null) {
            currVals = new ArrayList<Object[]>();
            currVals.add(entry);
            return currVals;
        }
        int s = 0;
        int e = currVals.size();
        if (s == e) {
            currVals.add(s, entry);
            return currVals;
        }
        int currStrand = (Integer)entry[0];
        int currStart = (Integer)entry[1];
        int currEnd = (Integer)entry[2];
        while (s < e) {
            int mid = (s + e) / 2;
            Object[] listEntry = (Object[])currVals.get(mid);
            int listStrand = (Integer)listEntry[0];
            int listStart = (Integer)listEntry[1];
            int listEnd = (Integer)listEntry[2];
            if (currStrand < listStrand || currStrand == listStrand && currStart < listStart || currStrand == listStrand && currStart == listStart && currEnd < listEnd) {
                e = mid;
                continue;
            }
            if (currStrand > listStrand || currStrand == listStrand && currStart > listStart || currStrand == listStrand && currStart == listStart && currEnd > listEnd) {
                s = mid + 1;
                continue;
            }
            if (currStrand != listStrand || currStart != listStart || currEnd != listEnd) continue;
            return currVals;
        }
        currVals.add(s, entry);
        return currVals;
    }

    public static Hashtable loadIntoSequenceNameHash(String inputFile, String featureName) {
        BufferedReader buf = null;
        String Line = null;
        try {
            buf = new BufferedReader(new FileReader(inputFile));
            Line = buf.readLine();
        }
        catch (IOException E) {
            E.printStackTrace();
            return null;
        }
        Hashtable<String, ArrayList> ret = new Hashtable<String, ArrayList>();
        while (Line != null) {
            if ((Line = Line.trim()).length() > 0) {
                String[] els = Line.split("\t");
                if (els.length < GFFColumns.NumColumns) {
                    System.out.println("Short GFFLine: " + Line);
                    try {
                        Line = buf.readLine();
                        continue;
                    }
                    catch (IOException E) {
                        E.printStackTrace();
                        return null;
                    }
                }
                if (featureName == null || els[GFFColumns.FeatureType].toLowerCase().equals(featureName.toLowerCase())) {
                    String seqName = els[GFFColumns.SequenceName].toLowerCase();
                    ArrayList currVals = null;
                    currVals = ret.containsKey(seqName) ? (ArrayList)ret.get(seqName) : new ArrayList();
                    currVals.add(Line);
                    ret.put(seqName, currVals);
                }
            }
            try {
                Line = buf.readLine();
            }
            catch (IOException E) {
                E.printStackTrace();
                return null;
            }
        }
        try {
            buf.close();
        }
        catch (IOException E) {
            E.printStackTrace();
            return null;
        }
        return ret;
    }

    public static int getStrand(String GFFLine) {
        String[] bits = GFFLine.split("\t");
        return GFFFile.ParseStrand(bits[GFFColumns.Strand]);
    }

    public static String getSeqName(String GFFLine) {
        String[] bits = GFFLine.split("\t");
        return bits[GFFColumns.SequenceName];
    }

    public static Hashtable getAttributes(String GFFLine) {
        String[] bits = GFFLine.split("\t");
        Hashtable<String, String> ret = new Hashtable<String, String>();
        String[] atts = bits[GFFColumns.Attributes].split(";");
        int i = 0;
        while (i < atts.length) {
            String[] vals = atts[i].split("=");
            if (vals.length < 2) {
                System.err.println("ERROR:unable to identify attributes in '" + GFFLine + "'");
                return null;
            }
            ret.put(vals[0].toLowerCase(), vals[1].toLowerCase());
            ++i;
        }
        return ret;
    }

    public static Hashtable getAttributesFromCol(String AttsCol) {
        String[] atts = AttsCol.split(";");
        Hashtable<String, String> ret = new Hashtable<String, String>();
        int i = 0;
        while (i < atts.length) {
            String[] vals = atts[i].split("=");
            if (vals.length < 2) {
                ret.put("type", vals[0]);
            } else {
                ret.put(vals[0].toLowerCase(), vals[1].toLowerCase());
            }
            ++i;
        }
        return ret;
    }

    public static void WriteShuffledGFF(String inputFile, String outputFile, boolean debug) {
        if (!Utils.IsFile(inputFile)) {
            System.err.println("ERROR: input file '" + inputFile + "' is not a valid file!!");
            System.exit(-1);
        }
        BufferedReader buf = null;
        FileWriter f = null;
        String Line = null;
        try {
            buf = new BufferedReader(new FileReader(inputFile));
            f = new FileWriter(outputFile);
            Line = buf.readLine();
        }
        catch (IOException E) {
            E.printStackTrace();
            System.exit(-1);
        }
        int PrevStrand = -1;
        int PrevSuffix = 0;
        ArrayList<String> BufferedLines = new ArrayList<String>();
        ArrayList<String> DecoyLines = new ArrayList<String>();
        while (Line != null) {
            String NewLine;
            if ((Line = Line.trim()).length() == 0 || Line.charAt(0) == '#') {
                try {
                    Line = buf.readLine();
                }
                catch (IOException E) {
                    E.printStackTrace();
                    System.exit(-1);
                }
                continue;
            }
            String[] Bits = Line.split("\t");
            int Strand = -1;
            try {
                Strand = GFFFile.ParseStrand(Bits[GFFColumns.Strand]);
            }
            catch (Exception E) {
                Strand = -1;
            }
            if (Strand == -1) {
                System.out.println("Skipping this line with no strand: " + Line);
                try {
                    Line = buf.readLine();
                }
                catch (IOException Er) {
                    Er.printStackTrace();
                    System.exit(-1);
                }
                PrevStrand = -1;
                continue;
            }
            if (PrevStrand != -1 && Strand != -1 && Strand != PrevStrand && BufferedLines.size() > 0) {
                int i = 0;
                while (i < BufferedLines.size()) {
                    try {
                        f.write(String.valueOf((String)BufferedLines.get(i)) + "\n");
                        if (debug) {
                            System.out.println((String)BufferedLines.get(i));
                        }
                    }
                    catch (IOException E) {
                        E.printStackTrace();
                        System.exit(-1);
                    }
                    ++i;
                }
                i = 0;
                while (i < DecoyLines.size()) {
                    try {
                        f.write(String.valueOf((String)DecoyLines.get(i)) + "\n");
                        if (debug) {
                            System.out.println((String)DecoyLines.get(i));
                        }
                    }
                    catch (IOException E) {
                        E.printStackTrace();
                        System.exit(-1);
                    }
                    ++i;
                }
                BufferedLines.clear();
                DecoyLines.clear();
                PrevSuffix = 0;
                if (debug) {
                    Utils.WaitForEnter();
                }
            }
            if (Strand != -1) {
                PrevStrand = Strand;
            }
            if (Line.substring(0, 3).toLowerCase().compareTo("chr") != 0) {
                BufferedLines.add("chr" + Line);
            } else {
                BufferedLines.add(Line);
            }
            if (Strand >= 0) {
                Bits[GFFColumns.Strand] = "" + (1 - Strand);
                String NewAttributes = "";
                String Notes = Bits[GFFColumns.Attributes];
                String[] NoteElements = Notes.split(";");
                String GeneName = null;
                if (debug) {
                    System.out.println(Notes);
                }
                int i = 0;
                while (i < NoteElements.length) {
                    String[] Bits2 = NoteElements[i].split("=");
                    if (debug) {
                        System.out.println("Attr: " + Bits2[0]);
                    }
                    if (Bits2[0].toLowerCase().indexOf("id") >= 0) {
                        GeneName = Bits2[1].replace("\"", "");
                        NewAttributes = String.valueOf(NewAttributes) + "ID=\"XXX." + GeneName + "\";";
                    } else if (Bits2[0].toLowerCase().indexOf("parent") >= 0) {
                        GeneName = Bits2[1].replace("\"", "");
                        NewAttributes = String.valueOf(NewAttributes) + "Parent=\"XXX." + GeneName + "\";";
                    } else if (Bits2[0].toLowerCase().indexOf("name") >= 0) {
                        GeneName = Bits2[1].replace("\"", "");
                        NewAttributes = String.valueOf(NewAttributes) + "Name=\"XXX." + GeneName + "\";";
                    }
                    if (debug) {
                        System.out.println("New Attr: " + NewAttributes);
                    }
                    ++i;
                }
                if (NewAttributes.length() == 0) {
                    System.out.println("ERROR: Unable to parse gene name from line");
                    System.out.println(Line);
                    Utils.WaitForEnter();
                    try {
                        Line = buf.readLine();
                    }
                    catch (IOException E) {
                        E.printStackTrace();
                        System.exit(-1);
                    }
                    continue;
                }
                Bits[GFFColumns.Attributes] = NewAttributes.substring(0, NewAttributes.length() - 1);
                if (Bits[GFFColumns.FeatureType].toLowerCase().compareTo("cds") == 0) {
                    int Start = Integer.parseInt(Bits[GFFColumns.Start]) - 1;
                    int End = Integer.parseInt(Bits[GFFColumns.End]);
                    int Prefix = (3 - PrevSuffix) % 3;
                    int OldSuffix = (End - Start - Prefix) % 3;
                    if (Strand == 1) {
                        int NewReadingFrame = (3 - OldSuffix) % 3;
                        Bits[GFFColumns.Frame] = "" + NewReadingFrame;
                        PrevSuffix = OldSuffix;
                    } else {
                        PrevSuffix = OldSuffix;
                    }
                }
            }
            if ((NewLine = Utils.JoinStringArray(Bits, "\t")).substring(0, 3).toLowerCase().compareTo("chr") != 0) {
                DecoyLines.add("XXX.chr" + NewLine);
            } else {
                DecoyLines.add("XXX." + NewLine);
            }
            try {
                Line = buf.readLine();
            }
            catch (IOException E) {
                E.printStackTrace();
                System.exit(-1);
            }
        }
        if (BufferedLines.size() > 0) {
            int i = 0;
            while (i < BufferedLines.size()) {
                try {
                    f.write(String.valueOf((String)BufferedLines.get(i)) + "\n");
                    if (debug) {
                        System.out.println((String)BufferedLines.get(i));
                    }
                }
                catch (IOException E) {
                    E.printStackTrace();
                    System.exit(-1);
                }
                ++i;
            }
            i = 0;
            while (i < DecoyLines.size()) {
                try {
                    f.write(String.valueOf((String)DecoyLines.get(i)) + "\n");
                    if (debug) {
                        System.out.println((String)DecoyLines.get(i));
                    }
                }
                catch (IOException E) {
                    E.printStackTrace();
                    System.exit(-1);
                }
                ++i;
            }
        }
        BufferedLines.clear();
        DecoyLines.clear();
        PrevSuffix = 0;
        if (debug) {
            Utils.WaitForEnter();
        }
        try {
            buf.close();
            f.close();
        }
        catch (IOException E) {
            E.printStackTrace();
            System.exit(-1);
        }
    }

    public static String[] loadFeatureLines(String inputFile, String featureName) {
        BufferedReader buf = null;
        String Line = null;
        try {
            buf = new BufferedReader(new FileReader(inputFile));
            Line = buf.readLine();
        }
        catch (IOException E) {
            E.printStackTrace();
            return null;
        }
        ArrayList<String> tempRet = new ArrayList<String>();
        while (Line != null) {
            String[] els;
            if ((Line = Line.trim()).length() > 0 && (els = Line.split("\t"))[GFFColumns.FeatureType].toLowerCase().equals(featureName.toLowerCase())) {
                tempRet.add(Line);
            }
            try {
                Line = buf.readLine();
            }
            catch (IOException E) {
                E.printStackTrace();
                return null;
            }
        }
        try {
            buf.close();
        }
        catch (IOException E) {
            E.printStackTrace();
            return null;
        }
        if (tempRet.size() == 0) {
            System.out.println("WARNING: Could not find any features of type '" + featureName + "' in " + inputFile);
            return null;
        }
        String[] ret = new String[tempRet.size()];
        int i = 0;
        while (i < ret.length) {
            ret[i] = (String)tempRet.get(i);
            ++i;
        }
        return ret;
    }

    /*
     * Unable to fully structure code
     */
    public static double[] getMeanExonAndIntronLength(String gffFileName, HashSet tNames) {
        buf = null;
        debug = false;
        exonLength = 0.0;
        intronLength = 0.0;
        exonCount = 0;
        intronCount = 0;
        Line = null;
        try {
            buf = new BufferedReader(new FileReader(gffFileName));
            Line = buf.readLine();
            if (true) ** GOTO lbl46
        }
        catch (IOException E) {
            E.printStackTrace();
            return null;
        }
        do {
            if ((Line = Line.trim()).length() > 0) {
                els = Line.split("\t");
                atts = GFFFile.getAttributesFromCol(els[GFFColumns.Attributes]);
                if (atts.containsKey("parent")) {
                    geneName = (String)atts.get("parent");
                    if (tNames == null || tNames.contains(geneName)) {
                        if (els[GFFColumns.FeatureType].toLowerCase().equals("cds")) {
                            ++exonCount;
                            exonLength += Double.parseDouble(els[GFFColumns.End]) - Double.parseDouble(els[GFFColumns.Start]) + 1.0;
                        } else if (els[GFFColumns.FeatureType].toLowerCase().equals("intron")) {
                            ++intronCount;
                            intronLength += Double.parseDouble(els[GFFColumns.End]) - Double.parseDouble(els[GFFColumns.Start]) + 1.0;
                        } else if (debug) {
                            System.out.println("Skipping line for being wrong feature: " + Line);
                            Utils.WaitForEnter();
                        }
                    } else if (debug) {
                        System.out.println("Skipping line for being other gene: " + geneName);
                    }
                } else if (debug) {
                    System.out.println("Skipping line for having no parent attribute: " + Line);
                    Utils.WaitForEnter();
                }
            }
            try {
                Line = buf.readLine();
            }
            catch (IOException E) {
                E.printStackTrace();
                return null;
            }
lbl46:
            // 2 sources

        } while (Line != null);
        try {
            buf.close();
        }
        catch (IOException E) {
            E.printStackTrace();
            return null;
        }
        ret = new double[]{exonLength / (double)exonCount, intronLength / (double)intronCount};
        return ret;
    }

    public static Hashtable splitBySeqName(String[] gffFiles, String outputDir, boolean skipReWrite) {
        Hashtable<String, String> ret = new Hashtable<String, String>();
        System.out.println("SkipReWrite: " + skipReWrite);
        while (true) {
            String currSeqName = null;
            String currOutputFileName = null;
            FileWriter f = null;
            int lineCount = 0;
            int i = 0;
            while (i < gffFiles.length) {
                BufferedReader buf = Utils.openBufferedReader(gffFiles[i]);
                String line = Utils.readNextLine(buf, gffFiles[i]);
                while (line != null) {
                    if ((line = line.trim()).length() == 0 || line.charAt(0) == '#') {
                        line = Utils.readNextLine(buf, gffFiles[i]);
                        continue;
                    }
                    String seqName = GFFFile.getSeqName(line);
                    if (currSeqName == null && !ret.containsKey(seqName)) {
                        currSeqName = seqName;
                        currOutputFileName = String.valueOf(outputDir) + File.separator + seqName + ".gff";
                        ret.put(seqName, currOutputFileName);
                        if (!skipReWrite || !Utils.IsFile(currOutputFileName)) {
                            f = Utils.openFileWriter(currOutputFileName);
                            Utils.writeLine(f, currOutputFileName, String.valueOf(line) + "\n");
                        } else {
                            f = null;
                        }
                        System.out.println("Splitting gff lines for sequence " + currSeqName);
                        ++lineCount;
                    } else if (seqName.equals(currSeqName)) {
                        if (f != null) {
                            Utils.writeLine(f, currOutputFileName, String.valueOf(line) + "\n");
                        }
                        ++lineCount;
                    }
                    line = Utils.readNextLine(buf, gffFiles[i]);
                }
                Utils.closeBufferedReader(buf, gffFiles[i]);
                ++i;
            }
            if (currSeqName == null) break;
            if (f == null) continue;
            Utils.closeFileWriter(f, currOutputFileName);
            System.out.println(" - Wrote " + lineCount + " lines of evidence");
        }
        return ret;
    }

    public static void main(String[] args) {
        String[] options = new String[]{"-r", "-w", "-d"};
        boolean[] blArray = new boolean[3];
        blArray[0] = true;
        blArray[1] = true;
        boolean[] values = blArray;
        Hashtable CommandLineArgs = Utils.ParseCommandLine(args, options, values);
        if (!CommandLineArgs.containsKey("-r") || !CommandLineArgs.containsKey("-w")) {
            System.err.println("ERROR: Must specify an input file and output file!");
            System.err.println(UsageInfo);
            System.exit(0);
        }
        boolean Debug = CommandLineArgs.containsKey("-d");
        GFFFile.WriteShuffledGFF((String)CommandLineArgs.get("-r"), (String)CommandLineArgs.get("-w"), Debug);
    }

    /*
     * Unable to fully structure code
     */
    public static ArrayList getGeneLocationsFromTranscriptNames(String gffFileName, HashSet tNames) {
        buf = null;
        debug = false;
        ret = new ArrayList<String[]>();
        Line = null;
        try {
            buf = new BufferedReader(new FileReader(gffFileName));
            Line = buf.readLine();
            if (true) ** GOTO lbl30
        }
        catch (IOException E) {
            E.printStackTrace();
            return null;
        }
        do {
            if ((Line = Line.trim()).length() > 0 && (els = Line.split("\t"))[GFFColumns.FeatureType].toLowerCase().equals("mrna")) {
                atts = GFFFile.getAttributesFromCol(els[GFFColumns.Attributes]);
                if (atts.containsKey("id")) {
                    geneName = (String)atts.get("id");
                    if (tNames == null || tNames.contains(geneName)) {
                        ret.add(els);
                    }
                } else if (debug) {
                    System.out.println("Skipping line for having no parent attribute: " + Line);
                    Utils.WaitForEnter();
                }
            }
            try {
                Line = buf.readLine();
            }
            catch (IOException E) {
                E.printStackTrace();
                return null;
            }
lbl30:
            // 2 sources

        } while (Line != null);
        try {
            buf.close();
        }
        catch (IOException E) {
            E.printStackTrace();
            return null;
        }
        return ret;
    }

    /*
     * Unable to fully structure code
     */
    public static Hashtable getPeptideCoords(Hashtable prot2Pep, String gffFileName) {
        buf = null;
        debug = false;
        ret = new Hashtable<String, String[]>();
        protCoords = new Hashtable<String, ArrayList>();
        Line = null;
        try {
            buf = new BufferedReader(new FileReader(gffFileName));
            Line = buf.readLine();
            if (true) ** GOTO lbl35
        }
        catch (IOException E) {
            E.printStackTrace();
            return null;
        }
        do {
            if ((Line = Line.trim()).length() > 0 && (els = Line.split("\t"))[GFFColumns.FeatureType].toLowerCase().equals("cds")) {
                atts = GFFFile.getAttributesFromCol(els[GFFColumns.Attributes]);
                if (atts.containsKey("parent")) {
                    geneName = (String)atts.get("parent");
                    if (prot2Pep.containsKey(geneName)) {
                        exons = protCoords.containsKey(geneName) != false ? (ArrayList)protCoords.get(geneName) : new ArrayList();
                        coords = new int[]{Integer.parseInt(els[GFFColumns.Start]), Integer.parseInt(els[GFFColumns.End]), GFFFile.ParseStrand(els[GFFColumns.Strand])};
                        exons.add(coords);
                        protCoords.put(geneName, exons);
                    }
                } else if (debug) {
                    System.out.println("Skipping line for having no parent attribute: " + Line);
                    Utils.WaitForEnter();
                }
            }
            try {
                Line = buf.readLine();
            }
            catch (IOException E) {
                E.printStackTrace();
                return null;
            }
lbl35:
            // 2 sources

        } while (Line != null);
        try {
            buf.close();
        }
        catch (IOException E) {
            E.printStackTrace();
            return null;
        }
        e = prot2Pep.keys();
        while (e.hasMoreElements()) {
            currProt = (String)e.nextElement();
            if (debug) {
                System.out.println("Curr Protein: " + currProt);
            }
            pepInfo = (String[])prot2Pep.get(currProt);
            newPepInfo = new String[5];
            newPepInfo[0] = pepInfo[0];
            newPepInfo[2] = pepInfo[2];
            if (protCoords.containsKey(currProt)) {
                exons = (ArrayList)protCoords.get(currProt);
                newPepInfo[4] = "" + ((int[])exons.get(0))[2];
                exonDeets = new int[exons.size()][7];
                prefixLen = 0;
                suffixLen = 0;
                currPIndex = 0;
                i = 0;
                while (i < exons.size()) {
                    currExon = (int[])exons.get(i);
                    exonDeets[i][0] = currExon[0];
                    exonDeets[i][1] = currExon[1];
                    len = currExon[1] - currExon[0] + 1;
                    suffixLen = (len - prefixLen) % 3;
                    aalen = (len - prefixLen - suffixLen) / 3;
                    exonDeets[i][2] = currPIndex;
                    exonDeets[i][3] = exonDeets[i][2] + aalen;
                    exonDeets[i][4] = prefixLen;
                    exonDeets[i][5] = suffixLen;
                    exonDeets[i][6] = currExon[2];
                    if (debug) {
                        System.out.println("--Exon " + i + "--");
                        System.out.println(String.valueOf(exonDeets[i][0]) + "-" + exonDeets[i][1]);
                        System.out.println(String.valueOf(exonDeets[i][2]) + "-" + exonDeets[i][3]);
                        System.out.println("prefixLen: " + exonDeets[i][4]);
                        System.out.println("suffixLen: " + exonDeets[i][5]);
                        System.out.println("strand: " + exonDeets[i][6]);
                    }
                    currPIndex += aalen;
                    if (suffixLen != 0) {
                        ++currPIndex;
                    }
                    prefixLen = (3 - suffixLen) % 3;
                    ++i;
                }
                pCoords = null;
                pepString = "";
                if (pepInfo[0].length() > 0) {
                    pCoords = pepInfo[1].split(",");
                    pepString = "";
                    i = 0;
                    while (i < pCoords.length) {
                        t = pCoords[i].split("-");
                        pStart = -1;
                        pEnd = -1;
                        try {
                            pStart = Integer.parseInt(pCoords[i].split("-")[0]);
                            pEnd = Integer.parseInt(pCoords[i].split("-")[1]);
                        }
                        catch (Exception E) {
                            System.out.println(pCoords[i]);
                            ErrorThrower.ThrowErrorCustum(100, "Invalid values");
                        }
                        gCoords = GFFFile.getGenomicCoords(pStart, pEnd, exonDeets);
                        if (debug) {
                            System.out.println(gCoords);
                            Utils.WaitForEnter();
                        }
                        pepString = String.valueOf(pepString) + gCoords + ",";
                        ++i;
                    }
                }
                newPepInfo[1] = pepString;
                newPepInfo[2] = pepInfo[2];
                newPepInfo[3] = pepInfo[3];
                if (pepInfo[2].length() > 0) {
                    pCoords = pepInfo[3].split(",");
                    pepString = "";
                    i = 0;
                    while (i < pCoords.length) {
                        pStart = Integer.parseInt(pCoords[i].split("-")[0]);
                        pEnd = Integer.parseInt(pCoords[i].split("-")[1]);
                        gCoords = GFFFile.getGenomicCoords(pStart, pEnd, exonDeets);
                        if (debug) {
                            System.out.println(gCoords);
                            Utils.WaitForEnter();
                        }
                        pepString = String.valueOf(pepString) + gCoords + ",";
                        ++i;
                    }
                    newPepInfo[3] = pepString;
                }
                ret.put(currProt, newPepInfo);
                continue;
            }
            System.err.println("WARNING: Unable to find exon coords for protein " + currProt);
        }
        return ret;
    }

    private static String getGenomicCoords(int pStart, int pEnd, int[][] exonDeets) {
        boolean debug = false;
        if (debug) {
            System.out.println("Considering peptide with protCoords: " + pStart + " -" + pEnd);
        }
        int eStartIndex = -1;
        String gCoords = "";
        int j = 0;
        while (j < exonDeets.length) {
            if (debug) {
                System.out.println("Exon[" + j + "]=" + exonDeets[j][2] + "-" + exonDeets[j][3]);
            }
            if (pStart < exonDeets[j][3] && pStart >= exonDeets[j][2]) {
                if (exonDeets[j][6] == 1) {
                    gCoords = String.valueOf(gCoords) + (exonDeets[j][0] - 1 + exonDeets[j][4] + (pStart - exonDeets[j][2]) * 3) + "-";
                    if (debug) {
                        System.out.println("This peptide starts at " + (exonDeets[j][0] - 1 + exonDeets[j][4] + (pStart - exonDeets[j][2]) * 3));
                    }
                } else {
                    gCoords = String.valueOf(gCoords) + (exonDeets[j][1] - exonDeets[j][4] - (pStart - exonDeets[j][2]) * 3);
                }
                eStartIndex = j;
            }
            if (pStart < exonDeets[j][2] && eStartIndex < 0) {
                if (pStart == exonDeets[j][2] - 1) {
                    if (exonDeets[j][6] == 1) {
                        gCoords = String.valueOf(gCoords) + (exonDeets[j - 1][1] - exonDeets[j - 1][5]) + "-" + exonDeets[j - 1][1] + ";" + (exonDeets[j][0] - 1) + "-";
                        if (debug) {
                            System.out.println("This peptide starts at " + (exonDeets[j - 1][1] - exonDeets[j - 1][5]));
                        }
                    } else {
                        gCoords = String.valueOf(gCoords) + exonDeets[j][1] + ";" + (exonDeets[j - 1][0] - 1) + "-" + (exonDeets[j - 1][0] + exonDeets[j - 1][5] - 1);
                    }
                    eStartIndex = j;
                } else {
                    System.err.println("GFFFile.getPeptideCoords: Cannot find start of peptide (" + pStart + "-" + pEnd + ") in exon (" + exonDeets[j][2] + "-" + exonDeets[j][3] + ")");
                    System.exit(-1);
                }
            }
            if (pEnd - 1 <= exonDeets[j][3] && pEnd > exonDeets[j][2]) {
                if (eStartIndex != j) {
                    int k = eStartIndex;
                    while (k < j) {
                        gCoords = exonDeets[j][6] == 1 ? String.valueOf(gCoords) + exonDeets[k][1] + ";" + (exonDeets[k + 1][0] - 1) + "-" : String.valueOf(exonDeets[k + 1][1]) + ";" + (exonDeets[k][0] - 1) + "-" + gCoords;
                        ++k;
                    }
                }
                if (exonDeets[j][6] == 1) {
                    gCoords = String.valueOf(gCoords) + (exonDeets[j][0] + exonDeets[j][4] + (pEnd - exonDeets[j][2]) * 3);
                    if (!debug) break;
                    System.out.println("This peptide ends at " + (exonDeets[j][0] + exonDeets[j][4] + (pStart - exonDeets[j][2]) * 3));
                    break;
                }
                gCoords = String.valueOf(exonDeets[j][1] - exonDeets[j][4] - (pEnd - exonDeets[j][2]) * 3) + "-" + gCoords;
                break;
            }
            ++j;
        }
        return gCoords;
    }

    public static Hashtable getProteinCoords(Set tNames, String gffFileName, boolean debug) {
        BufferedReader buf = null;
        Hashtable<String, String[]> ret = new Hashtable<String, String[]>();
        String Line = null;
        try {
            buf = new BufferedReader(new FileReader(gffFileName));
            Line = buf.readLine();
        }
        catch (IOException E) {
            ErrorThrower.ThrowError(5, gffFileName);
        }
        while (Line != null) {
            String[] els;
            if ((Line = Line.trim()).length() > 0 && (els = Line.split("\t"))[GFFColumns.FeatureType].toLowerCase().equals("mrna")) {
                Hashtable atts = GFFFile.getAttributesFromCol(els[GFFColumns.Attributes]);
                if (atts.containsKey("id")) {
                    String geneName = (String)atts.get("id");
                    if (debug) {
                        System.out.println("geneName: " + geneName);
                    }
                    if (tNames == null || tNames.contains(geneName)) {
                        String[] deets = new String[]{els[GFFColumns.Start], els[GFFColumns.End], els[GFFColumns.Strand], els[GFFColumns.SequenceName]};
                        ret.put(geneName, deets);
                        if (debug) {
                            System.out.println("ret.size() = " + ret.size());
                        }
                    }
                } else if (debug) {
                    System.out.println("Skipping line for having no id attribute: " + Line);
                    Utils.WaitForEnter();
                }
            }
            try {
                Line = buf.readLine();
            }
            catch (IOException E) {
                ErrorThrower.ThrowError(6, gffFileName);
            }
        }
        try {
            buf.close();
        }
        catch (IOException E) {
            ErrorThrower.ThrowError(8, gffFileName);
        }
        return ret;
    }

    /*
     * Unable to fully structure code
     */
    public static Hashtable getGeneLines(String gffFileName, Hashtable gffToGeneMap, boolean verboseFlag) {
        ret = new Hashtable<String, ArrayList>();
        buf = null;
        Line = null;
        try {
            buf = new BufferedReader(new FileReader(gffFileName));
            Line = buf.readLine();
            if (true) ** GOTO lbl32
        }
        catch (IOException E) {
            E.printStackTrace();
            return null;
        }
        do {
            if ((Line = Line.trim()).length() > 0 && (atts = GFFFile.getAttributesFromCol((els = Line.split("\t"))[GFFColumns.Attributes])).containsKey("parent")) {
                geneName = tName = (String)atts.get("parent");
                if (gffToGeneMap != null && !gffToGeneMap.containsKey(tName)) {
                    if (verboseFlag) {
                        ErrorThrower.ThrowWarning(13, "GFFFile.getGeneLines:Unable to find value for '" + tName + "'.  Using key as value");
                    }
                } else if (gffToGeneMap != null) {
                    geneName = (String)gffToGeneMap.get(tName);
                }
                lines = null;
                lines = ret.containsKey(geneName) != false ? (ArrayList)ret.get(geneName) : new ArrayList();
                lines.add(Line);
                ret.put(geneName, lines);
            }
            try {
                Line = buf.readLine();
            }
            catch (IOException E) {
                E.printStackTrace();
                return null;
            }
lbl32:
            // 2 sources

        } while (Line != null);
        try {
            buf.close();
        }
        catch (IOException E) {
            E.printStackTrace();
            return null;
        }
        return ret;
    }

    /*
     * Unable to fully structure code
     */
    public static double[] getNumExonsAndIntrons(String gffFileName, HashSet tNames) {
        buf = null;
        debug = false;
        seenNames = new HashSet<String>();
        exonCount = 0.0;
        intronCount = 0.0;
        Line = null;
        try {
            buf = new BufferedReader(new FileReader(gffFileName));
            Line = buf.readLine();
            if (true) ** GOTO lbl45
        }
        catch (IOException E) {
            E.printStackTrace();
            return null;
        }
        do {
            if ((Line = Line.trim()).length() > 0) {
                els = Line.split("\t");
                atts = GFFFile.getAttributesFromCol(els[GFFColumns.Attributes]);
                if (atts.containsKey("parent")) {
                    geneName = (String)atts.get("parent");
                    if (tNames == null || tNames.contains(geneName)) {
                        seenNames.add(geneName);
                        if (els[GFFColumns.FeatureType].toLowerCase().equals("cds")) {
                            exonCount += 1.0;
                        } else if (els[GFFColumns.FeatureType].toLowerCase().equals("intron")) {
                            intronCount += 1.0;
                        } else if (debug) {
                            System.out.println("Skipping line for being wrong feature: " + Line);
                            Utils.WaitForEnter();
                        }
                    } else if (debug) {
                        System.out.println("Skipping line for being other gene: " + geneName);
                    }
                } else if (debug) {
                    System.out.println("Skipping line for having no parent attribute: " + Line);
                    Utils.WaitForEnter();
                }
            }
            try {
                Line = buf.readLine();
            }
            catch (IOException E) {
                E.printStackTrace();
                return null;
            }
lbl45:
            // 2 sources

        } while (Line != null);
        try {
            buf.close();
        }
        catch (IOException E) {
            E.printStackTrace();
            return null;
        }
        ret = new double[]{exonCount / (double)seenNames.size(), intronCount / (double)seenNames.size()};
        return ret;
    }

    public static String setAttributesCol(Hashtable atts) {
        String ret = "";
        String[] keys = Utils.GetHashtableKeysString(atts);
        int i = 0;
        while (i < keys.length) {
            String val = (String)atts.get(keys[i]);
            if (i != 0) {
                ret = String.valueOf(ret) + ";";
            }
            ret = String.valueOf(ret) + keys[i] + "=" + val;
            ++i;
        }
        return ret;
    }

    public static int[] getLineSpan(ArrayList supportingLines) {
        int[] nArray = new int[2];
        nArray[0] = Integer.MAX_VALUE;
        int[] ret = nArray;
        int i = 0;
        while (supportingLines != null && i < supportingLines.size()) {
            String line = (String)supportingLines.get(i);
            String[] bits = line.split("\t");
            int start = Integer.parseInt(bits[GFFColumns.Start]);
            int end = Integer.parseInt(bits[GFFColumns.End]);
            ret[0] = Math.min(ret[0], start);
            ret[1] = Math.max(ret[1], end);
            ++i;
        }
        return ret;
    }

    public static void shiftGFFCoords(String inputFile, String outputFile, int shift) {
        BufferedReader buf = Utils.openBufferedReader(inputFile);
        FileWriter f = Utils.openFileWriter(outputFile);
        String line = Utils.readNextLine(buf, inputFile);
        while (line != null) {
            if ((line = line.trim()).length() == 0 || line.charAt(0) == '#') {
                Utils.writeLine(f, outputFile, String.valueOf(line) + "\n");
                line = Utils.readNextLine(buf, inputFile);
                continue;
            }
            String[] bits = line.split("\t");
            if (bits.length <= GFFColumns.Start) {
                line = Utils.readNextLine(buf, inputFile);
                continue;
            }
            int start = Integer.parseInt(bits[GFFColumns.Start]);
            if (bits.length <= GFFColumns.End) {
                line = Utils.readNextLine(buf, inputFile);
                continue;
            }
            int end = Integer.parseInt(bits[GFFColumns.End]);
            bits[GFFColumns.Start] = String.valueOf(start += shift);
            bits[GFFColumns.End] = String.valueOf(end += shift);
            String newLine = Utils.JoinStringArray(bits, "\t");
            Utils.writeLine(f, outputFile, String.valueOf(newLine) + "\n");
            line = Utils.readNextLine(buf, inputFile);
        }
        Utils.closeBufferedReader(buf, inputFile);
        Utils.closeFileWriter(f, outputFile);
    }

    public static class GFFColumns {
        public static int NumColumns = 9;
        public static int SequenceName = 0;
        public static int Source = 1;
        public static int FeatureType = 2;
        public static int Start = 3;
        public static int End = 4;
        public static int Score = 5;
        public static int Strand = 6;
        public static int Frame = 7;
        public static int Attributes = 8;
    }
}

