/*
 * Decompiled with CFR 0.152.
 */
package basicUtils;

import basicUtils.GFFFile;
import basicUtils.Utils;
import errorUtils.ErrorThrower;
import java.io.BufferedReader;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.Hashtable;

public class GFFFramePredictor {
    private static final String DEFAULT_ATT_TAG = "parent";
    private static final String DEFAULT_FEATURE_NAME = "cds";
    public static String usageInfo = "basicUtils.GFFFramePredictor version 2012.03.20\nThis script adds a frame to GFF files that currently contain none.  This is generally\nthe case with mapped ESTs.  There are two modes for adding frames: 1) Use all in the file and 2) Use the one\nwith the longest open reading frame (unimplemented).\nAssumptions:\n 1.  Coordinates for the features to be linked are always in increasing coordinate order.\nUsage:\n -r [FILE] Input GFF file\n -w [FILE] Output GFF file with newly predicted frames\n(-n [NAME] Name in attribute column to link exons of the same match, case-insensitive (default: Parent)\n(-t [NAME] Type of feature to consider, case insensitive (default: CDS)\n";
    private String gffFileName;
    private String outputFileName;
    private String attTag;
    private String featureName;
    private boolean debug = false;

    public GFFFramePredictor(String gffFileName, String outputFileName, String attTag, String featureName) {
        if (!Utils.IsFile(gffFileName)) {
            ErrorThrower.ThrowError(4, gffFileName);
        }
        this.gffFileName = gffFileName;
        this.outputFileName = outputFileName;
        this.attTag = attTag;
        this.featureName = featureName;
    }

    public static void main(String[] args) {
        String[] options = new String[]{"-r", "-w", "-n", "-t", "-d"};
        boolean[] blArray = new boolean[5];
        blArray[0] = true;
        blArray[1] = true;
        blArray[2] = true;
        blArray[3] = true;
        boolean[] values = blArray;
        Hashtable CommandLineArgs = Utils.ParseCommandLine(args, options, values);
        if (!CommandLineArgs.containsKey("-r") || !CommandLineArgs.containsKey("-t")) {
            System.err.println("ERROR: Must specify an input file/directory, a proteome file, and a choosing scheme!");
            System.err.println(usageInfo);
            System.exit(0);
        }
        String gffFileName = (String)CommandLineArgs.get("-r");
        String outputFileName = (String)CommandLineArgs.get("-w");
        String attTag = DEFAULT_ATT_TAG;
        String featureName = DEFAULT_FEATURE_NAME;
        if (CommandLineArgs.containsKey("-n")) {
            attTag = (String)CommandLineArgs.get("-n");
        }
        if (CommandLineArgs.containsKey("-t")) {
            featureName = (String)CommandLineArgs.get("-t");
        }
        GFFFramePredictor p = new GFFFramePredictor(gffFileName, outputFileName, attTag, featureName);
        if (CommandLineArgs.containsKey("-d")) {
            p.debug = true;
        }
        p.runPrediction();
    }

    public void runPrediction() {
        String currParent = null;
        ArrayList<String[]> currLines = new ArrayList<String[]>();
        int currStrand = Integer.MAX_VALUE;
        int prevStart = -1;
        int prevEnd = -1;
        BufferedReader buf = Utils.openBufferedReader(this.gffFileName);
        String line = Utils.readNextLine(buf, this.gffFileName);
        FileWriter f = Utils.openFileWriter(this.outputFileName);
        while (line != null) {
            if ((line = line.trim()).length() == 0 || line.charAt(0) == '#') {
                line = Utils.readNextLine(buf, this.gffFileName);
                continue;
            }
            String[] bits = line.split("\t");
            if (this.debug) {
                System.out.println(line);
                System.out.println("feature type: " + bits[GFFFile.GFFColumns.FeatureType]);
            }
            if (bits[GFFFile.GFFColumns.FeatureType].equalsIgnoreCase(this.featureName)) {
                Hashtable atts = GFFFile.getAttributesFromCol(bits[GFFFile.GFFColumns.Attributes]);
                if (atts.containsKey(this.attTag.toLowerCase())) {
                    String parent = (String)atts.get(this.attTag.toLowerCase());
                    int newStart = Integer.parseInt(bits[GFFFile.GFFColumns.Start]);
                    int newEnd = Integer.parseInt(bits[GFFFile.GFFColumns.End]);
                    int strand = GFFFile.getStrand(line);
                    if (this.debug) {
                        System.out.println(String.valueOf(parent) + " - " + strand);
                    }
                    if (currParent != null && parent.equals(currParent)) {
                        if (Utils.HasOverlap(prevStart - 1, prevEnd, newStart - 1, newEnd)) {
                            ErrorThrower.ThrowWarningCustom(101, "Current feature overlaps previous feature in this group: " + line);
                        } else {
                            currLines.add(bits);
                            if (this.debug) {
                                System.out.println("Continuing previous feature!");
                            }
                            prevStart = newStart;
                            prevEnd = newEnd;
                        }
                    } else if (currParent != null) {
                        if (this.debug) {
                            System.out.println("Starting a new feature!!!");
                        }
                        int prefix = 0;
                        int suffix = 0;
                        int frame = 0;
                        while (frame < 3) {
                            prefix = frame;
                            suffix = frame;
                            if (this.debug) {
                                System.out.println("Frame: " + frame);
                            }
                            int i = 0;
                            while (i < currLines.size()) {
                                String[] currBits = (String[])currLines.get(i);
                                String[] newBits = new String[currBits.length];
                                int j = 0;
                                while (j < currBits.length) {
                                    newBits[j] = currBits[j];
                                    ++j;
                                }
                                int start = Integer.parseInt(currBits[GFFFile.GFFColumns.Start]);
                                int end = Integer.parseInt(currBits[GFFFile.GFFColumns.End]);
                                String newParent = String.valueOf(currParent) + ".frame" + frame;
                                Hashtable currAtts = GFFFile.getAttributesFromCol(newBits[GFFFile.GFFColumns.Attributes]);
                                currAtts.put(this.attTag.toLowerCase(), newParent);
                                newBits[GFFFile.GFFColumns.Attributes] = GFFFile.setAttributesCol(currAtts);
                                if (i == 0) {
                                    start += frame;
                                    prefix = 0;
                                    suffix = 0;
                                }
                                if (currStrand == 1) {
                                    newBits[GFFFile.GFFColumns.Start] = String.valueOf(start);
                                    newBits[GFFFile.GFFColumns.Frame] = String.valueOf(prefix);
                                    suffix = (end - start + 1 - prefix) % 3;
                                    if (this.debug) {
                                        System.out.println("Forward strand (" + i + "): ");
                                        System.out.println("(" + prefix + ") " + start + "-" + end + "(" + suffix + ")");
                                    }
                                    prefix = (3 - suffix) % 3;
                                } else {
                                    newBits[GFFFile.GFFColumns.Start] = String.valueOf(start);
                                    prefix = (end - start + 1 - suffix) % 3;
                                    newBits[GFFFile.GFFColumns.Frame] = String.valueOf(prefix);
                                    if (this.debug) {
                                        System.out.println("Reverse strand (" + i + "): ");
                                        System.out.println("(" + suffix + ") " + start + "-" + end + "(" + prefix + ")");
                                    }
                                    suffix = (3 - prefix) % 3;
                                }
                                if (i == currLines.size() - 1) {
                                    if (currStrand == 1) {
                                        end -= suffix;
                                    } else {
                                        end -= prefix;
                                        newBits[GFFFile.GFFColumns.Frame] = "0";
                                    }
                                    newBits[GFFFile.GFFColumns.End] = String.valueOf(end);
                                }
                                Utils.writeLine(f, this.outputFileName, String.valueOf(Utils.JoinStringArray(newBits, "\t")) + "\n");
                                ++i;
                            }
                            if (this.debug) {
                                Utils.WaitForEnter();
                            }
                            ++frame;
                        }
                        currLines.clear();
                        currLines.add(bits);
                        prevStart = newStart;
                        prevEnd = newEnd;
                        currStrand = strand;
                        currParent = parent;
                    } else {
                        if (this.debug) {
                            System.out.println("First guy!");
                        }
                        currLines.add(bits);
                        prevStart = newStart;
                        prevEnd = newEnd;
                        currStrand = strand;
                        currParent = parent;
                    }
                } else {
                    ErrorThrower.ThrowErrorCustum(100, "GFF attributes do not contain tag '" + this.attTag + "': " + bits[GFFFile.GFFColumns.Attributes]);
                }
            } else if (this.debug) {
                System.out.println("Skipping because wrong feature type");
            }
            line = Utils.readNextLine(buf, this.gffFileName);
        }
        if (currLines.size() > 0) {
            if (this.debug) {
                System.out.println("Last guy");
            }
            int prefix = 0;
            int suffix = 0;
            int frame = 0;
            while (frame < 3) {
                prefix = frame;
                suffix = frame;
                if (this.debug) {
                    System.out.println("Frame: " + frame);
                }
                int i = 0;
                while (i < currLines.size()) {
                    String[] currBits = (String[])currLines.get(i);
                    String[] newBits = new String[currBits.length];
                    int j = 0;
                    while (j < currBits.length) {
                        newBits[j] = currBits[j];
                        ++j;
                    }
                    int start = Integer.parseInt(currBits[GFFFile.GFFColumns.Start]);
                    int end = Integer.parseInt(currBits[GFFFile.GFFColumns.End]);
                    String newParent = String.valueOf(currParent) + ".frame" + frame;
                    Hashtable atts = GFFFile.getAttributesFromCol(newBits[GFFFile.GFFColumns.Attributes]);
                    atts.put(this.attTag.toLowerCase(), newParent);
                    newBits[GFFFile.GFFColumns.Attributes] = GFFFile.setAttributesCol(atts);
                    if (i == 0) {
                        start += frame;
                        prefix = 0;
                        suffix = 0;
                    }
                    if (currStrand == 1) {
                        newBits[GFFFile.GFFColumns.Start] = String.valueOf(start);
                        newBits[GFFFile.GFFColumns.Frame] = String.valueOf(prefix);
                        suffix = (end - start + 1 - prefix) % 3;
                        if (this.debug) {
                            System.out.println("Forward strand (" + i + "): ");
                            System.out.println("(" + prefix + ") " + start + "-" + end + "(" + suffix + ")");
                        }
                        prefix = (3 - suffix) % 3;
                    } else {
                        newBits[GFFFile.GFFColumns.Start] = String.valueOf(start);
                        prefix = (end - start + 1 - suffix) % 3;
                        newBits[GFFFile.GFFColumns.Frame] = String.valueOf(prefix);
                        if (this.debug) {
                            System.out.println("Reverse strand (" + i + "): ");
                            System.out.println("(" + suffix + ") " + start + "-" + end + "(" + prefix + ")");
                        }
                        suffix = (3 - prefix) % 3;
                    }
                    if (i == currLines.size() - 1) {
                        if (currStrand == 1) {
                            end -= suffix;
                        } else {
                            end -= prefix;
                            newBits[GFFFile.GFFColumns.Frame] = "0";
                        }
                        newBits[GFFFile.GFFColumns.End] = String.valueOf(end);
                    }
                    Utils.writeLine(f, this.outputFileName, String.valueOf(Utils.JoinStringArray(newBits, "\t")) + "\n");
                    ++i;
                }
                ++frame;
            }
        }
        Utils.closeBufferedReader(buf, this.gffFileName);
        Utils.closeFileWriter(f, this.outputFileName);
    }
}

