/*
 * Decompiled with CFR 0.152.
 */
package basicUtils;

import basicUtils.Utils;
import errorUtils.ErrorThrower;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.util.Hashtable;

public class RemoveMissedCleavagePeptides {
    public static String usageInfo = "basicUtils.RemoveMissedCleavagePeptides version 2012.04.17\nTakes one or more tab-delimited files containing peptides and removes\npeptides with too  many missed cleavages\n -r [FILE/DIR] File or directory containing peptides\n -w [DIR] Directory to write filtered results\n -c [NUM] Column number (0-based) containing the peptide\n -m [NUM] Max missed tryptic cleavages\n";
    private String[] inputFiles = null;
    private String outputDir = null;
    private int pepColumn = -1;
    private int maxCleavages = -1;
    private boolean debug = false;

    public RemoveMissedCleavagePeptides(String inputDir, String outputDir, int column, int maxCleavages, boolean debug) {
        if (Utils.IsFile(inputDir)) {
            this.inputFiles = new String[1];
            this.inputFiles[0] = inputDir;
        } else if (Utils.IsDir(inputDir)) {
            this.inputFiles = Utils.ListDir(inputDir);
        } else {
            ErrorThrower.ThrowError(1, inputDir);
        }
        if (!Utils.IsDir(outputDir)) {
            Utils.MakeDir(outputDir);
        }
        this.outputDir = outputDir;
        if (column < 0) {
            ErrorThrower.ThrowError(4, "Column must be a positive integer");
        }
        if (maxCleavages < 0) {
            ErrorThrower.ThrowError(4, "Max cleavages must be a non-negative integer");
        }
        this.pepColumn = column;
        this.maxCleavages = maxCleavages;
        this.debug = debug;
    }

    public static void main(String[] args) {
        String[] options = new String[]{"-r", "-w", "-c", "-m", "-d"};
        boolean[] blArray = new boolean[5];
        blArray[0] = true;
        blArray[1] = true;
        blArray[2] = true;
        blArray[3] = true;
        boolean[] values = blArray;
        Hashtable CommandLineArgs = Utils.ParseCommandLine(args, options, values);
        if (!(CommandLineArgs.containsKey("-r") && CommandLineArgs.containsKey("-w") && CommandLineArgs.containsKey("-c") && CommandLineArgs.containsKey("-m"))) {
            System.err.println(usageInfo);
            ErrorThrower.ThrowError(2);
        }
        String inputDir = (String)CommandLineArgs.get("-r");
        String outputDir = (String)CommandLineArgs.get("-w");
        int column = -1;
        int maxCleavages = -1;
        try {
            column = Integer.parseInt((String)CommandLineArgs.get("-c"));
        }
        catch (Exception E) {
            ErrorThrower.ThrowError(4, "Column (-c) must be an integer");
        }
        try {
            maxCleavages = Integer.parseInt((String)CommandLineArgs.get("-m"));
        }
        catch (Exception E) {
            ErrorThrower.ThrowError(4, "Missed cleavages (-m) must be an integer");
        }
        boolean debug = false;
        if (CommandLineArgs.containsKey("-d")) {
            debug = true;
        }
        RemoveMissedCleavagePeptides c = new RemoveMissedCleavagePeptides(inputDir, outputDir, column, maxCleavages, debug);
        c.removePeptides();
    }

    private int countMissedCleavages(String peptide) {
        peptide = peptide.toUpperCase();
        int missedCount = 0;
        int i = 0;
        while (i < peptide.length() - 1) {
            if (peptide.charAt(i) == 'K' || peptide.charAt(i) == 'R') {
                ++missedCount;
            }
            ++i;
        }
        return missedCount;
    }

    private void removePeptides() {
        int[] missedDistro = new int[5];
        missedDistro = Utils.initializeIntArray(missedDistro, 0);
        int removedCount = 0;
        int i = 0;
        while (i < this.inputFiles.length) {
            System.out.println("Filtering " + this.inputFiles[i] + " ...");
            String outputFileName = String.valueOf(this.outputDir) + File.separator + Utils.GetBaseName(this.inputFiles[i]);
            BufferedReader buf = Utils.openBufferedReader(this.inputFiles[i]);
            FileWriter f = Utils.openFileWriter(outputFileName);
            String line = Utils.readNextLine(buf, this.inputFiles[i]);
            while (line != null) {
                int missedCleavsBin;
                if ((line = line.trim()).length() == 0 || line.charAt(0) == '#') {
                    line = Utils.readNextLine(buf, this.inputFiles[i]);
                    continue;
                }
                String[] bits = line.split("\t");
                if (bits.length <= this.pepColumn) {
                    ErrorThrower.ThrowWarning(12, line);
                    line = Utils.readNextLine(buf, this.inputFiles[i]);
                    continue;
                }
                String pep = bits[this.pepColumn];
                if (pep.indexOf(46) >= 0) {
                    pep = pep.substring(2, pep.length() - 2);
                }
                int missedCleavs = this.countMissedCleavages(pep);
                if (this.debug) {
                    System.out.println(String.valueOf(bits[this.pepColumn]) + " -> " + pep + " has " + missedCleavs);
                    Utils.WaitForEnter();
                }
                if (missedCleavs <= this.maxCleavages) {
                    Utils.writeLine(f, outputFileName, String.valueOf(line) + "\n");
                } else {
                    ++removedCount;
                }
                int n = missedCleavsBin = Math.min(missedCleavs, missedDistro.length - 1);
                missedDistro[n] = missedDistro[n] + 1;
                line = Utils.readNextLine(buf, this.inputFiles[i]);
            }
            Utils.closeBufferedReader(buf, this.inputFiles[i]);
            Utils.closeFileWriter(f, outputFileName);
            ++i;
        }
        System.out.println("Removed " + removedCount + " PSMs");
        i = 0;
        while (i < missedDistro.length) {
            System.out.println(String.valueOf(i) + " missed cleavages: " + missedDistro[i]);
            ++i;
        }
    }
}

