/*
 * Decompiled with CFR 0.152.
 */
package freemods;

import basicUtils.Utils;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Random;
import trieUtils.TrieDB;

public class DBMutator {
    public static String UsageInfo = "Usage: freemods.DBMutator\nCreates a database by point mutating each protein and rewriting to a new trie file\n[Required]\n-r [FILE] Unmutated trie file, assumes an index file of the same name exists\n-m [NUM] Max divergence, '-r .4' means that the most diverged a sequence will be is 40%\n-o [FILE] Output trie file to create\n[Optional]\n-b [FILE] Subsititution matrix of probabilities.  If no matrix is provided, all mutations are equally likely\n-d Run in Debug mode\n";
    public static int BUFFER_SIZE = 1024;
    private String InputFile = null;
    private String OutputFile = null;
    private double DivergenceCap = 0.0;
    private String SubMatrixFile = null;
    private FileWriter OutputFileWriter = null;
    private double[][] MutationMatrix = null;
    boolean Debug = false;

    public DBMutator(String InputFile, String OutputFile, double DivergenceCap, String SubMatrixFile) {
        this.InputFile = InputFile;
        this.OutputFile = OutputFile;
        this.DivergenceCap = DivergenceCap;
        this.SubMatrixFile = SubMatrixFile;
    }

    public boolean Mutate() {
        this.InitializeMutationMatrix();
        if (this.Debug) {
            this.DebugPrintMutationMatrix();
        }
        try {
            this.OutputFileWriter = new FileWriter(this.OutputFile);
        }
        catch (IOException E) {
            E.printStackTrace();
            return false;
        }
        TrieDB DB = new TrieDB(this.InputFile);
        int MutateCount = 0;
        MutateCount = 0;
        while (MutateCount < DB.getNumProteins()) {
            if (MutateCount % 100 == 0) {
                System.out.println("Mutated " + MutateCount + " proteins");
            }
            String Protein = DB.getProteinSequence(MutateCount);
            this.MutateAndWrite(Protein);
            ++MutateCount;
        }
        System.out.println("Total proteins Mutated: " + MutateCount);
        try {
            this.OutputFileWriter.close();
        }
        catch (IOException E) {
            E.printStackTrace();
            return false;
        }
        String Command = "cp " + Utils.GetFileNameNoExtension(this.InputFile) + ".index " + Utils.GetFileNameNoExtension(this.OutputFile) + ".index";
        try {
            Utils.RunCommand(Command, null, Utils.GetFilePath(this.InputFile));
        }
        catch (Exception E) {
            E.printStackTrace();
            System.err.println("Unable to execute: " + Command);
            return false;
        }
        return true;
    }

    private void MutateAndWrite(String OldProtein) {
        StringBuffer NewProtein = new StringBuffer(OldProtein);
        Random R = new Random();
        int NumMutations = R.nextInt((int)Math.ceil((double)OldProtein.length() * this.DivergenceCap));
        int i = 0;
        while (i < NumMutations) {
            int Spot = R.nextInt(OldProtein.length());
            char OldAA = NewProtein.charAt(Spot);
            char NewAA = this.Mutate(OldAA);
            NewProtein.setCharAt(Spot, NewAA);
            ++i;
        }
        String Protein = NewProtein.toString();
        try {
            this.OutputFileWriter.write(String.valueOf(Protein) + "*");
        }
        catch (IOException E) {
            E.printStackTrace();
            return;
        }
        if (this.Debug) {
            System.out.println("Old Protein: " + OldProtein);
            System.out.println("New Protein: " + NewProtein);
            System.out.println("Mutations: " + NumMutations);
            Utils.WaitForEnter();
        }
    }

    private char Mutate(char AA) {
        Random R = new Random();
        double Val = R.nextDouble();
        if (this.Debug) {
            System.out.println("Mutation Val: " + Val);
        }
        double Cum = 0.0;
        int i = 0;
        while (i < this.MutationMatrix[AA - 65].length) {
            if ((Cum += this.MutationMatrix[AA - 65][i]) >= Val) {
                return (char)(i + 65);
            }
            ++i;
        }
        if (AA != 'X') {
            System.err.println("We chose V: " + Val + ", which is beyond the range we are looking at(" + Cum + ")!!");
            System.out.println("Attempt to mutate: " + AA);
            Utils.WaitForEnter();
        }
        return AA;
    }

    private void InitializeMutationMatrix() {
        if (this.SubMatrixFile == null) {
            this.InitializeEqualMatrix();
            return;
        }
        BufferedReader matrixReader = null;
        String Line = null;
        try {
            matrixReader = new BufferedReader(new FileReader(this.SubMatrixFile));
            Line = matrixReader.readLine();
        }
        catch (IOException E) {
            this.SubMatrixFile = null;
            E.printStackTrace();
            this.InitializeEqualMatrix();
            return;
        }
        this.MutationMatrix = new double[26][26];
        while (Line != null) {
            if ((Line = Line.trim()).charAt(0) == '#') {
                try {
                    Line = matrixReader.readLine();
                    continue;
                }
                catch (IOException E) {
                    this.SubMatrixFile = null;
                    E.printStackTrace();
                    this.InitializeEqualMatrix();
                    return;
                }
            }
            String[] Bits = Line.split("\t");
            int FromIndex = Bits[0].toLowerCase().charAt(0) - 97;
            int i = 1;
            while (i < Bits.length) {
                this.MutationMatrix[FromIndex][i - 1] = Double.parseDouble(Bits[i]);
                ++i;
            }
            try {
                Line = matrixReader.readLine();
            }
            catch (IOException E) {
                this.SubMatrixFile = null;
                E.printStackTrace();
                this.InitializeEqualMatrix();
                return;
            }
        }
        try {
            matrixReader.close();
        }
        catch (IOException E) {
            E.printStackTrace();
            return;
        }
    }

    private void InitializeEqualMatrix() {
        this.MutationMatrix = new double[26][26];
        int i = 0;
        while (i < 26) {
            if (i != 1 && i != 9 && i != 14 && i != 20 && i != 23 && i != 25) {
                int j = 0;
                while (j < 26) {
                    if (j != 1 && j != 9 && j != 14 && j != 20 && j != 23 && j != 25) {
                        this.MutationMatrix[i][j] = 0.05;
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    private void DebugPrintMutationMatrix() {
        int i = 0;
        while (i < this.MutationMatrix.length) {
            int j = 0;
            while (j < this.MutationMatrix[i].length) {
                if (this.MutationMatrix[i][j] != 0.0) {
                    System.out.println(String.valueOf((char)(i + 65)) + "->" + (char)(j + 65) + ":" + this.MutationMatrix[i][j]);
                }
                ++j;
            }
            ++i;
        }
        Utils.WaitForEnter();
    }

    public static void main(String[] args) {
        double DivergenceCap;
        String[] Commands = new String[]{"-r", "-m", "-b", "-o", "-d"};
        boolean[] blArray = new boolean[5];
        blArray[0] = true;
        blArray[1] = true;
        blArray[2] = true;
        blArray[3] = true;
        boolean[] Values = blArray;
        Hashtable Options = Utils.ParseCommandLine(args, Commands, Values);
        if (!Options.containsKey("-r") || !Options.containsKey("-o")) {
            System.err.println("ERROR: Must specify both an input and an output file");
            System.err.println(UsageInfo);
            System.exit(0);
        }
        if (!Options.containsKey("-m")) {
            System.err.println("ERROR: Must specify a divergence cap");
            System.err.println(UsageInfo);
            System.exit(0);
        }
        if ((DivergenceCap = Double.valueOf((String)Options.get("-m")).doubleValue()) <= 0.0 || DivergenceCap >= 1.0) {
            System.err.println("ERROR: Invalid divergence cap of " + DivergenceCap);
            System.err.println(UsageInfo);
            System.exit(0);
        }
        String SubMatrixFile = null;
        if (Options.containsKey("-b")) {
            SubMatrixFile = (String)Options.get("-b");
        }
        DBMutator Mutator = new DBMutator((String)Options.get("-r"), (String)Options.get("-o"), DivergenceCap, SubMatrixFile);
        if (Options.containsKey("-d")) {
            Mutator.Debug = true;
        }
        Mutator.Mutate();
    }
}

