/*
 * Decompiled with CFR 0.152.
 */
package maizeUtils;

import basicUtils.ChooseProteins;
import basicUtils.GFFFile;
import basicUtils.Utils;
import errorUtils.ErrorThrower;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import maizeUtils.MaizeUtils;
import proteogenomicUtils.AUGUSTUSRunner;
import proteogenomicUtils.ProteogenomicUtils;
import trieUtils.TrieDB;

public class KnownProteomeAnalyzer {
    private static final String UsageInfo = "basicUtils.KnownProteomeAnalyzer versions 2011.29.09\nGathers statistics on identified proteins, and optionally, unidentified\nproteins.\n[REQUIRED]:\n-r [FILE] The selected protein file produced by ChooseProteins.jar\n-t [FILE] The file containing the protein sequences of the proteome (.trie or .fasta)\n-g [FILE] GFF file containing protein structures\n-i [FILE] Info file for proteome\n[OPTIONAL]:\n-k [FILE] A filtered set of 'trusted' protein sequences (.trie or .fasta)\n-j [FILE] GFF file containing 'trusted' protein structures\n-f [FILE] Info file for 'trusted' proteome\n-o Gather statistics on the unidentified proteins (NOT YET SUPPORTED)\n-c [FILE] Write a circos plot file\n-w [FILE] Write a file of weird working set proteins\n-a [FILE] Trie file containing the genome\n-q [TYPE] Only look at the proteins which have TYPE as a form of evidence\n-l [FILE] File containing selected loci from KnownProteinChooser.jar\n-b [FILE] AUGUSTUS prediction/blast summary table\n-e [FILE] Write analysis with AUGUSTUS predictions to file\n";
    private ArrayList selectedProteins;
    private TrieDB wholeProteome;
    private TrieDB filteredProteome = null;
    private String chosenProteinFileName = null;
    private String circosFileName = null;
    private String weirdProtFileName = null;
    private String restrictedType = null;
    private int[] backgroundCount;
    private HashSet workingNames;
    private HashSet workingSelectedNames;
    private HashSet filteredNames;
    private HashSet filteredSelectedNames;
    private String workingGFFFileName;
    private String workingInfoFileName;
    private String filteredGFFFileName;
    private String filteredInfoFileName;
    private TrieDB genomeFile;
    private HashSet workingGeneNames;
    private HashSet workingsSelectedGeneNames;
    private HashSet filteredGeneNames;
    private HashSet filteredSelectedGeneNames;
    private String selectedLociFile = null;
    private ArrayList selectedLoci = null;
    private String seqBlastFileName = null;
    private HashSet selectedWorkingLociNames;
    private HashSet selectedFilteredLociNames;
    private String seqAnalysisOutFile;

    public KnownProteomeAnalyzer(String protFileName, String proteomeFileName, String gffFileName, String infoFileName, String filteredFileName, String filteredGFFFileName, String filteredInfoFileName, String circosFileName, String genomeFile, String weirdProtFile, String restrictedType, String selectedLociFileName) {
        this(protFileName, proteomeFileName, gffFileName, infoFileName, filteredFileName, filteredGFFFileName, filteredInfoFileName, circosFileName, genomeFile, weirdProtFile, restrictedType, selectedLociFileName, null);
    }

    public KnownProteomeAnalyzer(String protFileName, String proteomeFileName, String gffFileName, String infoFileName, String filteredFileName, String filteredGFFFileName, String filteredInfoFileName, String circosFileName, String genomeFile, String weirdProtFile, String restrictedType, String selectedLociFileName, String seqBlastFileName) {
        this(protFileName, proteomeFileName, gffFileName, infoFileName, filteredFileName, filteredGFFFileName, filteredInfoFileName, circosFileName, genomeFile, weirdProtFile, restrictedType, selectedLociFileName, null, null);
    }

    public KnownProteomeAnalyzer(String protFileName, String proteomeFileName, String gffFileName, String infoFileName, String filteredFileName, String filteredGFFFileName, String filteredInfoFileName, String circosFileName, String genomeFile, String weirdProtFile, String restrictedType, String selectedLociFileName, String seqBlastFileName, String blastAnalysisOutFile) {
        String[] trieFile;
        this.selectedProteins = ChooseProteins.loadAllProteins(protFileName);
        if (this.selectedProteins == null) {
            System.err.println("ERROR: Could not load proteins from selected protein file '" + protFileName + "'!");
            System.exit(-1);
        }
        System.out.println("Loaded " + this.selectedProteins.size() + " proteins");
        this.chosenProteinFileName = protFileName;
        String ext = Utils.GetFileExtension(proteomeFileName);
        if (ext.toLowerCase().equals(".fasta")) {
            trieFile = TrieDB.prepDB(proteomeFileName, null);
            this.wholeProteome = new TrieDB(trieFile[0]);
        } else if (ext.toLowerCase().equals(".trie")) {
            this.wholeProteome = new TrieDB(proteomeFileName);
        } else {
            System.err.println("ERROR: Invalid proteome file '" + proteomeFileName + "'.  Must be .fasta or .trie");
            System.exit(-1);
        }
        if (!Utils.IsFile(gffFileName)) {
            System.err.println("ERROR: Invalid GFF file '" + gffFileName + "'!!");
            System.exit(-1);
        }
        this.workingGFFFileName = gffFileName;
        if (!Utils.IsFile(infoFileName)) {
            System.err.println("ERROR: Invalid info file '" + infoFileName + "'!!");
            System.exit(-1);
        }
        this.workingInfoFileName = infoFileName;
        this.restrictedType = restrictedType;
        if (filteredFileName != null) {
            ext = Utils.GetFileExtension(filteredFileName);
            if (ext.toLowerCase().equals(".fasta")) {
                trieFile = TrieDB.prepDB(filteredFileName, null);
                this.filteredProteome = new TrieDB(trieFile[0]);
            } else if (ext.toLowerCase().equals(".trie")) {
                this.filteredProteome = new TrieDB(filteredFileName);
            } else {
                System.err.println("WARNING: Invalid filtered proteome file '" + filteredFileName + "'.  Must be .fasta or .trie");
                this.filteredProteome = null;
            }
            if (!Utils.IsFile(filteredGFFFileName)) {
                System.err.println("ERROR: Invalid GFF file '" + filteredGFFFileName + "'!!");
                System.exit(-1);
            }
            this.filteredGFFFileName = filteredGFFFileName;
            if (!Utils.IsFile(filteredInfoFileName)) {
                System.err.println("ERROR: Invalid info file '" + filteredInfoFileName + "'!!");
                System.exit(-1);
            }
            this.filteredInfoFileName = filteredInfoFileName;
        }
        this.backgroundCount = new int[4];
        int i = 0;
        while (i < this.backgroundCount.length) {
            this.backgroundCount[i] = 0;
            ++i;
        }
        if (circosFileName != null) {
            this.circosFileName = circosFileName;
        }
        this.weirdProtFileName = weirdProtFile;
        if (genomeFile != null) {
            this.genomeFile = new TrieDB(genomeFile);
        }
        if (selectedLociFileName != null && !Utils.IsFile(selectedLociFileName)) {
            ErrorThrower.ThrowError(4, selectedLociFileName);
        }
        if (selectedLociFileName != null) {
            this.selectedLociFile = selectedLociFileName;
            this.selectedLoci = ChooseProteins.loadAllLoci(this.selectedLociFile);
        }
        if (seqBlastFileName != null && !Utils.IsFile(seqBlastFileName)) {
            ErrorThrower.ThrowError(4, seqBlastFileName);
        }
        this.seqBlastFileName = seqBlastFileName;
        if (blastAnalysisOutFile != null && seqBlastFileName == null) {
            ErrorThrower.ThrowErrorCustum(100, "Must specify a sequence summary file if you want analysis of predicted sequences");
        }
        this.seqAnalysisOutFile = blastAnalysisOutFile;
    }

    public static void main(String[] args) {
        String[] options = new String[]{"-r", "-t", "-k", "-o", "-w", "-g", "-j", "-i", "-f", "-a", "-c", "-q", "-l", "-b", "-e"};
        boolean[] blArray = new boolean[15];
        blArray[0] = true;
        blArray[1] = true;
        blArray[2] = true;
        blArray[4] = true;
        blArray[5] = true;
        blArray[6] = true;
        blArray[7] = true;
        blArray[8] = true;
        blArray[9] = true;
        blArray[10] = true;
        blArray[11] = true;
        blArray[12] = true;
        blArray[13] = true;
        blArray[14] = true;
        boolean[] values = blArray;
        Hashtable CommandLineArgs = Utils.ParseCommandLine(args, options, values);
        if (!(CommandLineArgs.containsKey("-r") && CommandLineArgs.containsKey("-t") && CommandLineArgs.containsKey("-g") && CommandLineArgs.containsKey("-i"))) {
            System.err.println("ERROR: Must specify an input file, a proteome file, an info file, and a proteome GFF file!");
            System.err.println(UsageInfo);
            System.exit(0);
        }
        String protFileName = (String)CommandLineArgs.get("-r");
        String proteomeFileName = (String)CommandLineArgs.get("-t");
        String gffFileName = (String)CommandLineArgs.get("-g");
        String infoFileName = (String)CommandLineArgs.get("-i");
        String genomeFile = null;
        String filteredFileName = null;
        String filteredGFFFileName = null;
        String filteredInfoFileName = null;
        String selectedLociFileName = null;
        String seqBlastFileName = null;
        String seqAnalysisOutFile = null;
        if (CommandLineArgs.containsKey("-k")) {
            filteredFileName = (String)CommandLineArgs.get("-k");
        }
        if (CommandLineArgs.containsKey("-j")) {
            filteredGFFFileName = (String)CommandLineArgs.get("-j");
        }
        if (CommandLineArgs.containsKey("-f")) {
            filteredInfoFileName = (String)CommandLineArgs.get("-f");
        }
        if (CommandLineArgs.containsKey("-l")) {
            selectedLociFileName = (String)CommandLineArgs.get("-l");
        }
        if (CommandLineArgs.containsKey("-b")) {
            seqBlastFileName = (String)CommandLineArgs.get("-b");
        }
        if (CommandLineArgs.containsKey("-e")) {
            seqAnalysisOutFile = (String)CommandLineArgs.get("-e");
        }
        String restrictedType = null;
        if (CommandLineArgs.containsKey("-q")) {
            restrictedType = (String)CommandLineArgs.get("-q");
        }
        if (!(filteredFileName == null && filteredGFFFileName == null && filteredInfoFileName == null || filteredFileName != null && filteredGFFFileName != null && filteredInfoFileName != null)) {
            System.out.println("ERROR: Must specify a filtered protein sequence file, info file, and filtered GFF file (or none)\n");
            return;
        }
        if (CommandLineArgs.containsKey("-a")) {
            genomeFile = (String)CommandLineArgs.get("-a");
        }
        if (CommandLineArgs.containsKey("-o")) {
            System.out.println("WARNING: Argument '-o' is not supported at this time");
        }
        String circosFileName = null;
        if (CommandLineArgs.containsKey("-c")) {
            circosFileName = (String)CommandLineArgs.get("-c");
        }
        String weirdProtFile = null;
        if (CommandLineArgs.containsKey("-w")) {
            weirdProtFile = (String)CommandLineArgs.get("-w");
        }
        KnownProteomeAnalyzer a = new KnownProteomeAnalyzer(protFileName, proteomeFileName, gffFileName, infoFileName, filteredFileName, filteredGFFFileName, filteredInfoFileName, circosFileName, genomeFile, weirdProtFile, restrictedType, selectedLociFileName, seqBlastFileName, seqAnalysisOutFile);
        a.analyze();
    }

    private void analyze() {
        int numFilteredProteins = 0;
        this.workingNames = this.wholeProteome.getAllProteinNames();
        this.workingSelectedNames = new HashSet();
        if (this.restrictedType != null) {
            this.workingNames = this.RestrictToType(this.workingNames, this.workingInfoFileName);
        }
        this.workingGeneNames = this.getGeneNames(this.workingNames, this.workingInfoFileName);
        System.out.println("Working proteome full: " + this.workingNames.size() + " proteins in " + this.workingGeneNames.size() + " genes");
        this.filteredNames = null;
        this.filteredSelectedNames = null;
        if (this.filteredProteome != null) {
            this.filteredNames = this.filteredProteome.getAllProteinNames();
            if (this.restrictedType != null) {
                this.filteredNames = this.RestrictToType(this.filteredNames, this.filteredInfoFileName);
            }
            this.filteredGeneNames = this.getGeneNames(this.filteredNames, this.filteredInfoFileName);
            numFilteredProteins = this.filteredNames.size();
            this.workingNames.removeAll(this.filteredNames);
            this.workingGeneNames = this.getGeneNames(this.workingNames, this.workingInfoFileName);
            this.filteredSelectedNames = new HashSet();
        }
        int numWorkingProteins = this.workingNames.size();
        System.out.println("Working Proteome: " + numWorkingProteins + " proteins in " + this.workingGeneNames.size() + " genes");
        if (this.filteredProteome != null) {
            System.out.println("FilteredProteome: " + numFilteredProteins + " proteins in " + this.filteredGeneNames.size() + " genes");
        }
        int j = 0;
        while (j < this.selectedProteins.size()) {
            Object[] info = (Object[])this.selectedProteins.get(j);
            String pName = TrieDB.getProteinNameFromFull((String)info[0]);
            if (this.workingNames.contains(pName)) {
                this.backgroundCount[0] = this.backgroundCount[0] + 1;
                this.workingSelectedNames.add(pName);
            } else if (this.filteredProteome != null && this.filteredNames.contains(pName)) {
                this.backgroundCount[2] = this.backgroundCount[2] + 1;
                this.filteredSelectedNames.add(pName);
            }
            ++j;
        }
        System.out.println("\n-----Selected Proteins-----");
        System.out.println("Selected working proteome: " + this.backgroundCount[0] + "/" + numWorkingProteins + " = " + (double)this.backgroundCount[0] / (double)numWorkingProteins);
        if (this.filteredProteome != null) {
            System.out.println("Selected filtered proteome: " + this.backgroundCount[2] + "/" + numFilteredProteins + " = " + (double)this.backgroundCount[2] / (double)numFilteredProteins);
        }
        this.workingsSelectedGeneNames = this.getGeneNames(this.workingSelectedNames, this.workingInfoFileName);
        System.out.println("Selected working genes: " + this.workingsSelectedGeneNames.size());
        if (this.filteredProteome != null) {
            this.filteredSelectedGeneNames = this.getGeneNames(this.filteredSelectedNames, this.filteredInfoFileName);
            System.out.println("Selected filtered genes: " + this.filteredSelectedGeneNames.size());
        }
        int[] geneCount = new int[2];
        this.selectedWorkingLociNames = new HashSet();
        this.selectedFilteredLociNames = new HashSet();
        Utils.initializeIntArray(geneCount, 0);
        int j2 = 0;
        while (this.selectedLoci != null && j2 < this.selectedLoci.size()) {
            Object[] info = (Object[])this.selectedLoci.get(j2);
            String pName = TrieDB.getProteinNameFromFull((String)info[0]);
            if (this.workingGeneNames.contains(pName)) {
                geneCount[0] = geneCount[0] + 1;
                this.selectedWorkingLociNames.add(pName);
            } else if (this.filteredProteome != null && this.filteredGeneNames.contains(pName)) {
                geneCount[1] = geneCount[1] + 1;
                this.selectedFilteredLociNames.add(pName);
            }
            ++j2;
        }
        System.out.println("\n------Loci selected -----");
        System.out.println("Loci in working set: " + geneCount[0]);
        System.out.println("Loci in filtered set: " + geneCount[1]);
        System.out.println("Total locis: " + (geneCount[0] + geneCount[1]));
        this.determineAAsInSets();
        this.determineMeanProteinLength();
        this.determineStartAA();
        if (this.circosFileName != null) {
            this.writeCircosFile();
        }
        HashSet pNamesToInvestigate = this.determineSourceInfo();
        if (this.seqBlastFileName != null) {
            String line;
            int i;
            Hashtable sequenceSummary = AUGUSTUSRunner.loadSequenceSummaryTable(this.seqBlastFileName);
            System.out.println("\n----- Predicted Sequences -----");
            System.out.println("Total genes: " + sequenceSummary.size());
            ArrayList lines = new ArrayList();
            FileWriter f = null;
            if (this.seqAnalysisOutFile != null) {
                f = Utils.openFileWriter(this.seqAnalysisOutFile);
            }
            Hashtable genes2Proteins = ProteogenomicUtils.loadTranslationFileMany(this.workingInfoFileName, 1, 3);
            System.out.println("DEBUG: total genes in translation table: " + genes2Proteins.size());
            lines = this.selectedLociFile != null ? this.compareToBlastResults(this.selectedWorkingLociNames, genes2Proteins, sequenceSummary) : this.compareToBlastResults(this.workingsSelectedGeneNames, genes2Proteins, sequenceSummary);
            System.out.println("Selected working set genes: " + lines.size());
            if (this.seqAnalysisOutFile != null) {
                i = 0;
                while (i < lines.size()) {
                    line = (String)lines.get(i);
                    line = "selectedWS\t" + line + "\n";
                    Utils.writeLine(f, this.seqAnalysisOutFile, line);
                    ++i;
                }
            }
            lines.clear();
            lines = this.compareToBlastResults(this.workingGeneNames, genes2Proteins, sequenceSummary);
            System.out.println("Working set genes: " + lines.size());
            if (this.seqAnalysisOutFile != null) {
                i = 0;
                while (i < lines.size()) {
                    line = (String)lines.get(i);
                    line = "WS\t" + line + "\n";
                    Utils.writeLine(f, this.seqAnalysisOutFile, line);
                    ++i;
                }
            }
            genes2Proteins = ProteogenomicUtils.loadTranslationFileMany(this.filteredInfoFileName, 1, 3);
            System.out.println("DEBUG: total genes in translation table: " + genes2Proteins.size());
            lines.clear();
            lines = this.selectedLociFile != null ? this.compareToBlastResults(this.selectedFilteredLociNames, genes2Proteins, sequenceSummary) : this.compareToBlastResults(this.filteredSelectedGeneNames, genes2Proteins, sequenceSummary);
            System.out.println("Selected filtered set genes: " + lines.size());
            if (this.seqAnalysisOutFile != null) {
                i = 0;
                while (i < lines.size()) {
                    line = (String)lines.get(i);
                    line = "selectedFS\t" + line + "\n";
                    Utils.writeLine(f, this.seqAnalysisOutFile, line);
                    ++i;
                }
            }
            lines.clear();
            lines = this.compareToBlastResults(this.filteredGeneNames, genes2Proteins, sequenceSummary);
            System.out.println("Filtered set genes: " + lines.size());
            if (this.seqAnalysisOutFile != null) {
                i = 0;
                while (i < lines.size()) {
                    line = (String)lines.get(i);
                    line = "FS\t" + line + "\n";
                    Utils.writeLine(f, this.seqAnalysisOutFile, line);
                    ++i;
                }
            }
            if (this.seqAnalysisOutFile != null) {
                Utils.closeFileWriter(f, this.seqAnalysisOutFile);
            }
        }
    }

    private ArrayList compareToBlastResults(HashSet geneNames, Hashtable genes2Proteins, Hashtable sequenceSummary) {
        ArrayList<String> lines = new ArrayList<String>();
        String[] geneNameArray = Utils.ConvertHashSetToStringArray(geneNames);
        int i = 0;
        while (i < geneNameArray.length) {
            if (sequenceSummary.containsKey(geneNameArray[i])) {
                int transThatMatchAnn = 0;
                int transWithNovelPep = 0;
                ArrayList blastTrans = (ArrayList)sequenceSummary.get(geneNameArray[i]);
                String[] predSeqs = new String[blastTrans.size()];
                int k = 0;
                while (k < blastTrans.size()) {
                    String seq;
                    String summaryLine = (String)blastTrans.get(k);
                    String[] bits = summaryLine.split("\t");
                    predSeqs[k] = seq = bits[7];
                    int pepsObeyed = Integer.parseInt(bits[3]);
                    if (pepsObeyed > 0) {
                        ++transWithNovelPep;
                    }
                    ++k;
                }
                ArrayList annotatedTrans = (ArrayList)genes2Proteins.get(geneNameArray[i]);
                int j = 0;
                while (j < annotatedTrans.size()) {
                    String annotatedProteinName = (String)annotatedTrans.get(j);
                    String annotatedProteinSeq = this.wholeProteome.getProteinSequence(this.wholeProteome.getProteinIDFromPartial(annotatedProteinName));
                    int k2 = 0;
                    while (k2 < predSeqs.length) {
                        if (annotatedProteinSeq.equalsIgnoreCase(predSeqs[k2])) {
                            ++transThatMatchAnn;
                        }
                        ++k2;
                    }
                    ++j;
                }
                String infoLine = String.valueOf(geneNameArray[i]) + "\t" + annotatedTrans.size() + "\t" + predSeqs.length + "\t" + transThatMatchAnn + "\t" + transWithNovelPep;
                lines.add(infoLine);
            }
            ++i;
        }
        return lines;
    }

    private HashSet getGeneNames(HashSet pNames, String translationFile) {
        String[] vals = Utils.ConvertHashSetToStringArray(pNames);
        Hashtable conversion = ProteogenomicUtils.loadTranslationFile(translationFile, 3, 1);
        HashSet<String> ret = new HashSet<String>();
        int i = 0;
        while (i < vals.length) {
            if (conversion.containsKey(vals[i].toLowerCase())) {
                ret.add((String)conversion.get(vals[i].toLowerCase()));
            } else {
                System.err.println("ERROR: Cannot find gene for protein '" + vals[i].toLowerCase());
                System.exit(0);
            }
            ++i;
        }
        return ret;
    }

    private HashSet RestrictToType(HashSet proteinNames, String infoFileName) {
        int initCount = proteinNames.size();
        BufferedReader buf = null;
        String line = null;
        int removedCount = 0;
        try {
            buf = new BufferedReader(new FileReader(infoFileName));
            line = buf.readLine();
        }
        catch (IOException E) {
            ErrorThrower.ThrowError(5, infoFileName);
        }
        while (line != null) {
            if ((line = line.trim()).charAt(0) == '#') {
                try {
                    line = buf.readLine();
                }
                catch (IOException E) {
                    ErrorThrower.ThrowError(6, infoFileName);
                }
                continue;
            }
            String[] bits = line.split("\t");
            String pName = bits[3];
            String[] typeInfo = bits[10].split("[|]");
            int index = Utils.FindStringInArray(typeInfo, this.restrictedType);
            if (index < 0 && proteinNames.remove(pName)) {
                ++removedCount;
            }
            try {
                line = buf.readLine();
            }
            catch (IOException E) {
                ErrorThrower.ThrowError(6, infoFileName);
            }
        }
        try {
            buf.close();
        }
        catch (IOException E) {
            ErrorThrower.ThrowError(8, infoFileName);
        }
        System.out.println("Removed " + removedCount + "/" + initCount + " proteins without evidence from '" + this.restrictedType + "'");
        return proteinNames;
    }

    private Hashtable getPeptideOnProteinLocations(HashSet tNames) {
        Hashtable<String, String[]> protein2Peptides = new Hashtable<String, String[]>();
        int i = 0;
        while (i < this.selectedProteins.size()) {
            Object[] currProtein = (Object[])this.selectedProteins.get(i);
            String pName = ((String)currProtein[0]).split(" ")[0];
            String tName = MaizeUtils.getMaizeTranscriptNameFromProtein(pName).toLowerCase();
            if (tNames.contains(tName)) {
                int start;
                int j;
                String[] t;
                String peptides = "";
                String pepCoords = "";
                String sharedPeptides = "";
                String sharedPepCoords = "";
                int protID = this.wholeProteome.getProteinIDFromPartial(pName);
                String protSeq = this.wholeProteome.getProteinSequence(protID);
                if (currProtein[3] != null) {
                    t = (String[])currProtein[3];
                    j = 0;
                    while (j < t.length) {
                        start = protSeq.indexOf(t[j]);
                        if (start < 0) {
                            System.err.println("ERROR: Unable to find peptide '" + t[j] + "' in protein " + pName);
                            System.exit(-1);
                        }
                        pepCoords = String.valueOf(pepCoords) + start + "-" + (start + t[j].length()) + ",";
                        ++j;
                    }
                    peptides = Utils.JoinStringArray(t, ",");
                    pepCoords = pepCoords.substring(0, pepCoords.length() - 1);
                }
                if (currProtein[4] != null) {
                    t = (String[])currProtein[4];
                    j = 0;
                    while (j < t.length) {
                        start = protSeq.indexOf(t[j]);
                        if (start < 0) {
                            System.err.println("ERROR: Unable to find peptide '" + t[j] + "' in protein " + pName);
                            System.exit(-1);
                        }
                        sharedPepCoords = String.valueOf(sharedPepCoords) + start + "-" + (start + t[j].length()) + ",";
                        ++j;
                    }
                    sharedPeptides = Utils.JoinStringArray(t, ",");
                    sharedPepCoords = sharedPepCoords.substring(0, sharedPepCoords.length() - 1);
                }
                String[] peps = new String[]{peptides, pepCoords, sharedPeptides, sharedPepCoords};
                protein2Peptides.put(tName, peps);
            }
            ++i;
        }
        return protein2Peptides;
    }

    private void getProteinLocations(HashSet pNamesToInvestigate) {
        boolean ntPad = false;
        System.out.println("pNames: " + pNamesToInvestigate.size());
        HashSet tNames = MaizeUtils.getTranscriptNamesFromProteinNames(Utils.toLowerCase(pNamesToInvestigate));
        ArrayList pLocs = GFFFile.getGeneLocationsFromTranscriptNames(this.workingGFFFileName, tNames);
        System.out.println("tNames: " + tNames.size());
        Hashtable protein2Peptides = this.getPeptideOnProteinLocations(tNames);
        System.out.println("Loaded " + protein2Peptides.size() + " proteins with peptide info");
        Hashtable protein2Peptides_gCoords = this.getPeptideGenomicCoords(protein2Peptides);
        FileWriter f = null;
        FileWriter fastaWriter = null;
        String baseName = String.valueOf(Utils.GetFileNameNoExtension(this.weirdProtFileName)) + ".fasta";
        if (baseName.equals(this.weirdProtFileName)) {
            baseName = String.valueOf(Utils.GetFileNameNoExtension(this.weirdProtFileName)) + ".2.fasta";
        }
        try {
            f = new FileWriter(this.weirdProtFileName);
            f.write("#ProteinName\tChrNum\tRegionStart\tRegionEnd\tStrand\tPeptideSeqs\tSplicedSeqs\tRegions\n");
            fastaWriter = new FileWriter(baseName);
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        int i = 0;
        while (i < pLocs.size()) {
            String[] els = (String[])pLocs.get(i);
            Hashtable atts = GFFFile.getAttributesFromCol(els[GFFFile.GFFColumns.Attributes]);
            String geneName = (String)atts.get("id");
            String[] protInfo = (String[])protein2Peptides_gCoords.get(geneName);
            try {
                f.write(String.valueOf(geneName) + "\t" + els[GFFFile.GFFColumns.SequenceName] + "\t" + els[GFFFile.GFFColumns.Start] + "\t" + els[GFFFile.GFFColumns.End] + "\t" + els[GFFFile.GFFColumns.Strand] + "\t" + protInfo[1] + "\t" + protInfo[2] + "\t" + protInfo[3] + "\n");
            }
            catch (IOException e) {
                e.printStackTrace();
                return;
            }
            String pName = MaizeUtils.getMaizeProteinNameFromTranscript(geneName);
            int id = this.wholeProteome.getProteinIDFromPartial(pName);
            String seq = this.wholeProteome.getProteinSequence(id);
            try {
                fastaWriter.write(">" + pName + "\n");
                fastaWriter.write(String.valueOf(seq) + "\n");
            }
            catch (IOException e) {
                e.printStackTrace();
                return;
            }
            ++i;
        }
        try {
            f.close();
            fastaWriter.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
    }

    private Hashtable getPeptideGenomicCoords(Hashtable protein2Peptides) {
        Hashtable h = GFFFile.getPeptideCoords(protein2Peptides, this.workingGFFFileName);
        Hashtable<String, String[]> ret = new Hashtable<String, String[]>();
        String[] tNames = Utils.GetHashtableKeysString(h);
        boolean localDebug = false;
        int i = 0;
        while (i < tNames.length) {
            int aaLength;
            int ntLength;
            int k;
            int pepIndex;
            int suffix;
            int prefix;
            int prevEnd;
            int start;
            String[] s;
            String splices;
            String spliceSeq;
            if (localDebug) {
                System.out.println("looking at " + tNames[i]);
            }
            String[] pepInfo = (String[])h.get(tNames[i]);
            String[] peptides = pepInfo[0].split(",");
            String[] pepCoords = pepInfo[1].split(",");
            String[] newPepInfo = new String[8];
            newPepInfo[0] = pepInfo[0];
            int j = 1;
            while (j < newPepInfo.length) {
                newPepInfo[j] = "";
                ++j;
            }
            j = 0;
            while (j < peptides.length) {
                if (localDebug) {
                    System.out.println("CurrPep: " + peptides[j]);
                    System.out.println("Coords: " + pepCoords[j]);
                }
                spliceSeq = "";
                splices = "";
                s = pepCoords[j].split(";");
                if (s.length == 1) {
                    spliceSeq = peptides[j];
                    if (localDebug) {
                        System.out.println("No splicing!!");
                    }
                } else {
                    if (localDebug) {
                        System.out.println("There are splices!!");
                    }
                    start = Integer.parseInt(s[0].split("-")[0]);
                    prevEnd = Integer.parseInt(s[0].split("-")[1]);
                    prefix = 0;
                    suffix = 0;
                    pepIndex = (prevEnd - start) / 3;
                    if (localDebug) {
                        System.out.println("This exon claims " + pepIndex + " aas");
                    }
                    if (pepInfo[4].equals("1")) {
                        suffix = (prevEnd - start) % 3;
                        spliceSeq = String.valueOf(spliceSeq) + peptides[j].substring(0, pepIndex);
                        if (suffix == 0) {
                            spliceSeq = String.valueOf(spliceSeq) + ":";
                        } else {
                            spliceSeq = String.valueOf(spliceSeq) + ";" + peptides[j].charAt(pepIndex) + ";";
                            ++pepIndex;
                        }
                    } else {
                        prefix = (prevEnd - start) % 3;
                        pepIndex = peptides[j].length() - pepIndex;
                        if (localDebug) {
                            System.out.println("seq starts at index " + pepIndex);
                        }
                        spliceSeq = peptides[j].substring(pepIndex);
                        --pepIndex;
                        if (prefix == 0) {
                            spliceSeq = ":" + spliceSeq;
                        } else {
                            spliceSeq = ";" + peptides[j].charAt(pepIndex) + ";" + spliceSeq;
                            --pepIndex;
                        }
                    }
                    k = 1;
                    while (k < s.length) {
                        start = Integer.parseInt(s[k].split("-")[0]);
                        if (pepInfo[4].equals("1")) {
                            splices = String.valueOf(splices) + prevEnd + "-" + start + " ";
                            prefix = (3 - suffix) % 3;
                        } else {
                            splices = String.valueOf(splices) + start + "-" + prevEnd;
                            suffix = (3 - prefix) % 3;
                        }
                        prevEnd = Integer.parseInt(s[k].split("-")[1]);
                        ntLength = prevEnd - start;
                        if (pepInfo[4].equals("1")) {
                            suffix = (ntLength - prefix) % 3;
                        } else {
                            prefix = (ntLength - suffix) % 3;
                        }
                        aaLength = (ntLength - suffix - prefix) / 3;
                        while (aaLength > 0) {
                            if (pepInfo[4].equals("1")) {
                                spliceSeq = String.valueOf(spliceSeq) + peptides[j].charAt(pepIndex);
                                ++pepIndex;
                            } else {
                                spliceSeq = String.valueOf(peptides[j].charAt(pepIndex)) + spliceSeq;
                                --pepIndex;
                            }
                            --aaLength;
                        }
                        ++k;
                    }
                }
                if (localDebug) {
                    System.out.println(spliceSeq);
                    System.out.println(pepCoords[j]);
                    System.out.println(splices.trim());
                    Utils.WaitForEnter();
                }
                newPepInfo[1] = String.valueOf(newPepInfo[1]) + spliceSeq + ",";
                newPepInfo[3] = String.valueOf(newPepInfo[3]) + pepCoords[j] + ",";
                newPepInfo[2] = String.valueOf(newPepInfo[2]) + splices.trim() + ",";
                ++j;
            }
            newPepInfo[1] = newPepInfo[1].substring(0, newPepInfo[1].length() - 1);
            newPepInfo[2] = newPepInfo[2].substring(0, newPepInfo[2].length() - 1);
            newPepInfo[3] = newPepInfo[3].substring(0, newPepInfo[3].length() - 1);
            if (pepInfo[2].length() > 0) {
                peptides = pepInfo[2].split(",");
                pepCoords = pepInfo[3].split(",");
                newPepInfo[4] = pepInfo[2];
                j = 0;
                while (j < peptides.length) {
                    spliceSeq = "";
                    splices = "";
                    s = pepCoords[j].split(";");
                    if (s.length == 1) {
                        spliceSeq = peptides[j];
                    } else {
                        start = Integer.parseInt(s[0].split("-")[0]);
                        prevEnd = Integer.parseInt(s[0].split("-")[1]);
                        prefix = 0;
                        suffix = 0;
                        pepIndex = (prevEnd - start) / 3;
                        if (pepInfo[4].equals("1")) {
                            suffix = (prevEnd - start) % 3;
                            spliceSeq = String.valueOf(spliceSeq) + peptides[j].substring(0, pepIndex);
                            if (suffix == 0) {
                                spliceSeq = String.valueOf(spliceSeq) + ":";
                            } else {
                                spliceSeq = String.valueOf(spliceSeq) + ";" + peptides[j].charAt(pepIndex) + ";";
                                ++pepIndex;
                            }
                        } else {
                            prefix = (prevEnd - start) % 3;
                            pepIndex = peptides[j].length() - pepIndex;
                            spliceSeq = peptides[j].substring(pepIndex);
                            --pepIndex;
                            if (prefix == 0) {
                                spliceSeq = ":" + spliceSeq;
                            } else {
                                spliceSeq = ";" + peptides[j].charAt(pepIndex) + ";";
                                --pepIndex;
                            }
                        }
                        k = 1;
                        while (k < s.length) {
                            start = Integer.parseInt(s[k].split("-")[0]);
                            if (pepInfo[4].equals("1")) {
                                splices = String.valueOf(splices) + prevEnd + "-" + start + " ";
                                prefix = (3 - suffix) % 3;
                            } else {
                                splices = String.valueOf(splices) + start + "-" + prevEnd;
                                suffix = (3 - prefix) % 3;
                            }
                            prevEnd = Integer.parseInt(s[k].split("-")[1]);
                            ntLength = prevEnd - start;
                            if (pepInfo[4].equals("1")) {
                                suffix = (ntLength - prefix) % 3;
                            } else {
                                prefix = (ntLength - suffix) % 3;
                            }
                            aaLength = (ntLength - suffix - prefix) / 3;
                            while (aaLength > 0) {
                                if (pepInfo[4].equals("1")) {
                                    spliceSeq = String.valueOf(spliceSeq) + peptides[j].charAt(pepIndex);
                                    ++pepIndex;
                                } else {
                                    spliceSeq = String.valueOf(peptides[j].charAt(pepIndex)) + spliceSeq;
                                    --pepIndex;
                                }
                                --aaLength;
                            }
                            ++k;
                        }
                        newPepInfo[5] = String.valueOf(newPepInfo[5]) + spliceSeq + ",";
                        newPepInfo[6] = String.valueOf(newPepInfo[6]) + pepCoords[j] + ",";
                        newPepInfo[7] = String.valueOf(splices.trim()) + ",";
                    }
                    ++j;
                }
                newPepInfo[5] = newPepInfo[5].substring(0, newPepInfo[5].length() - 1);
                newPepInfo[6] = newPepInfo[6].substring(0, newPepInfo[6].length() - 1);
                newPepInfo[7] = newPepInfo[7].substring(0, newPepInfo[7].length() - 1);
            }
            ret.put(tNames[i], newPepInfo);
            ++i;
        }
        return ret;
    }

    /*
     * Unable to fully structure code
     */
    private HashSet determineSourceInfo() {
        workingSourcesCounts = new int[9];
        workingSourcesCounts = Utils.initializeIntArray(workingSourcesCounts, 0);
        workingSelectedSourcesCounts = new int[9];
        workingSelectedSourcesCounts = Utils.initializeIntArray(workingSelectedSourcesCounts, 0);
        workingProteinsToInvestigate = new HashSet<String>();
        filteredSourcesCounts = null;
        filteredSelectedSourcesCounts = null;
        if (this.filteredProteome != null) {
            filteredSourcesCounts = new int[9];
            filteredSourcesCounts = Utils.initializeIntArray(filteredSourcesCounts, 0);
            filteredSelectedSourcesCounts = new int[9];
            filteredSelectedSourcesCounts = Utils.initializeIntArray(filteredSelectedSourcesCounts, 0);
        }
        sourceNames = new Hashtable<String, int[]>();
        cdsStatus = new Hashtable<String, int[]>();
        biotypes = new Hashtable<String, int[]>();
        buf = null;
        line = null;
        try {
            buf = new BufferedReader(new FileReader(this.workingInfoFileName));
            line = buf.readLine();
            if (true) ** GOTO lbl137
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        do {
            if ((line = line.trim()).length() == 0 || line.charAt(0) == '#') {
                try {
                    line = buf.readLine();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return null;
                }
            }
            bits = line.split("\t");
            pName = bits[3];
            sources = bits[10].split("[|]");
            status = bits[11];
            biotype = bits[12];
            workingSelected = false;
            filteredSelected = false;
            working = false;
            filtered = false;
            if (this.workingNames.contains(pName)) {
                if (sources.length >= workingSourcesCounts.length) {
                    v0 = workingSourcesCounts.length - 1;
                    workingSourcesCounts[v0] = workingSourcesCounts[v0] + 1;
                } else {
                    v1 = sources.length;
                    workingSourcesCounts[v1] = workingSourcesCounts[v1] + 1;
                }
                working = true;
                if (this.workingSelectedNames.contains(pName)) {
                    if (sources.length >= workingSelectedSourcesCounts.length) {
                        v2 = workingSourcesCounts.length - 1;
                        workingSelectedSourcesCounts[v2] = workingSelectedSourcesCounts[v2] + 1;
                    } else {
                        v3 = sources.length;
                        workingSelectedSourcesCounts[v3] = workingSelectedSourcesCounts[v3] + 1;
                    }
                    workingSelected = true;
                }
            } else if (this.filteredProteome != null && this.filteredNames.contains(pName)) {
                if (sources.length >= filteredSourcesCounts.length) {
                    v4 = filteredSourcesCounts.length - 1;
                    filteredSourcesCounts[v4] = filteredSourcesCounts[v4] + 1;
                } else {
                    v5 = sources.length;
                    filteredSourcesCounts[v5] = filteredSourcesCounts[v5] + 1;
                }
                filtered = true;
                if (this.filteredSelectedNames.contains(pName)) {
                    if (sources.length >= filteredSelectedSourcesCounts.length) {
                        v6 = filteredSourcesCounts.length - 1;
                        filteredSelectedSourcesCounts[v6] = filteredSelectedSourcesCounts[v6] + 1;
                    } else {
                        v7 = sources.length;
                        filteredSelectedSourcesCounts[v7] = filteredSelectedSourcesCounts[v7] + 1;
                    }
                    filteredSelected = true;
                }
            }
            i = 0;
            while (i < sources.length) {
                c = null;
                currSource = sources[i].trim();
                if (sourceNames.containsKey(currSource)) {
                    c = (int[])sourceNames.get(currSource);
                } else {
                    c = new int[4];
                    c = Utils.initializeIntArray(c, 0);
                }
                if (working) {
                    c[0] = c[0] + 1;
                }
                if (workingSelected) {
                    c[1] = c[1] + 1;
                }
                if (filtered) {
                    c[2] = c[2] + 1;
                }
                if (filteredSelected) {
                    c[3] = c[3] + 1;
                }
                sourceNames.put(currSource, c);
                ++i;
            }
            stat = null;
            if (cdsStatus.containsKey(status)) {
                stat = (int[])cdsStatus.get(status);
            } else {
                stat = new int[4];
                stat = Utils.initializeIntArray(stat, 0);
            }
            if (working) {
                stat[0] = stat[0] + 1;
            }
            if (workingSelected) {
                stat[1] = stat[1] + 1;
            }
            if (filtered) {
                stat[2] = stat[2] + 1;
            }
            if (filteredSelected) {
                stat[3] = stat[3] + 1;
            }
            cdsStatus.put(status, stat);
            t = null;
            if (biotypes.containsKey(biotype)) {
                t = (int[])biotypes.get(biotype);
            } else {
                t = new int[4];
                t = Utils.initializeIntArray(t, 0);
            }
            if (working) {
                t[0] = t[0] + 1;
            }
            if (workingSelected) {
                t[1] = t[1] + 1;
            }
            if (filtered) {
                t[2] = t[2] + 1;
            }
            if (filteredSelected) {
                t[3] = t[3] + 1;
            }
            biotypes.put(biotype, t);
            try {
                line = buf.readLine();
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
            if (!workingSelected || !biotype.equals("protein_coding") || status.equals("good")) continue;
            workingProteinsToInvestigate.add(pName);
lbl137:
            // 4 sources

        } while (line != null);
        try {
            buf.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        System.out.println("\n-----Numbers of evidence sources-----");
        System.out.println("Working Set:");
        i = 0;
        while (i < workingSourcesCounts.length) {
            System.out.println(" " + i + " sources: " + workingSourcesCounts[i]);
            ++i;
        }
        System.out.println("Working Selected Set:");
        i = 0;
        while (i < workingSelectedSourcesCounts.length) {
            System.out.println(" " + i + " sources: " + workingSelectedSourcesCounts[i]);
            ++i;
        }
        if (this.filteredProteome != null) {
            System.out.println("Filtered Set:");
            i = 0;
            while (i < filteredSourcesCounts.length) {
                System.out.println(" " + i + " sources: " + filteredSourcesCounts[i]);
                ++i;
            }
            System.out.println("Filtered Selected Set:");
            i = 0;
            while (i < filteredSelectedSourcesCounts.length) {
                System.out.println(" " + i + " sources: " + filteredSelectedSourcesCounts[i]);
                ++i;
            }
        }
        System.out.println("\n----- Sources of Evidence-----");
        s = sourceNames.keys();
        while (s.hasMoreElements()) {
            src = (String)s.nextElement();
            c = (int[])sourceNames.get(src);
            System.out.println(String.valueOf(src) + " " + c[0] + " " + c[1] + " " + c[2] + " " + c[3]);
        }
        System.out.println("\n----- CDS Status -----");
        s = cdsStatus.keys();
        while (s.hasMoreElements()) {
            src = (String)s.nextElement();
            c = (int[])cdsStatus.get(src);
            System.out.println(String.valueOf(src) + " " + c[0] + " " + c[1] + " " + c[2] + " " + c[3]);
        }
        System.out.println("\n----- BioTypes -----");
        s = biotypes.keys();
        while (s.hasMoreElements()) {
            src = (String)s.nextElement();
            c = (int[])biotypes.get(src);
            System.out.println(String.valueOf(src) + " " + c[0] + " " + c[1] + " " + c[2] + " " + c[3]);
        }
        return workingProteinsToInvestigate;
    }

    private void writeCircosFile() {
        ArrayList allGroups = new ArrayList();
        int[] allGroupSizes = new int[100];
        allGroupSizes = Utils.initializeIntArray(allGroupSizes, 0);
        Hashtable<String, ArrayList> peptideToProtein = new Hashtable<String, ArrayList>();
        int i = 0;
        while (i < this.selectedProteins.size()) {
            Object[] currProtein = (Object[])this.selectedProteins.get(i);
            String[] peptideSeqs = ChooseProteins.getPeptides(currProtein);
            int j = 0;
            while (j < peptideSeqs.length) {
                ArrayList proteinIndexes = null;
                proteinIndexes = peptideToProtein.containsKey(peptideSeqs[j]) ? (ArrayList)peptideToProtein.get(peptideSeqs[j]) : new ArrayList();
                proteinIndexes.add(new Integer(i));
                peptideToProtein.put(peptideSeqs[j], proteinIndexes);
                ++j;
            }
            ++i;
        }
        boolean[] considered = new boolean[this.selectedProteins.size()];
        Utils.initializeBooleanArray(considered, false);
        ArrayList<String> currPeptides = new ArrayList<String>();
        ArrayList<Integer> currGroup = null;
        int i2 = 0;
        while (i2 < this.selectedProteins.size()) {
            if (!considered[i2]) {
                currGroup = new ArrayList<Integer>();
                currGroup.add(new Integer(i2));
                considered[i2] = true;
                String[] pepSeqs = ChooseProteins.getPeptides((Object[])this.selectedProteins.get(i2));
                int p = 0;
                while (p < pepSeqs.length) {
                    currPeptides.add(pepSeqs[p]);
                    ++p;
                }
                while (currPeptides.size() > 0) {
                    String currPep = (String)currPeptides.remove(0);
                    ArrayList prots = (ArrayList)peptideToProtein.get(currPep);
                    int j = 0;
                    while (j < prots.size()) {
                        Integer otherP = (Integer)prots.get(j);
                        if (!currGroup.contains(otherP)) {
                            currGroup.add(otherP);
                            considered[otherP.intValue()] = true;
                            String[] otherPeps = ChooseProteins.getPeptides((Object[])this.selectedProteins.get(otherP));
                            int k = 0;
                            while (k < otherPeps.length) {
                                currPeptides.add(otherPeps[k]);
                                ++k;
                            }
                        }
                        ++j;
                    }
                }
                if (currGroup.size() > 0) {
                    allGroups.add(currGroup);
                    if (currGroup.size() >= allGroupSizes.length) {
                        int n = allGroupSizes.length - 1;
                        allGroupSizes[n] = allGroupSizes[n] + 1;
                    } else {
                        int n = currGroup.size();
                        allGroupSizes[n] = allGroupSizes[n] + 1;
                    }
                }
            }
            ++i2;
        }
        System.out.println("Found " + allGroups.size() + " total components");
        i2 = 0;
        while (i2 < allGroupSizes.length - 1) {
            System.out.println(" - Components with " + i2 + " proteins:" + allGroupSizes[i2]);
            ++i2;
        }
        System.out.println(" - Components with " + (allGroupSizes.length - 1) + "+ proteins:" + allGroupSizes[allGroupSizes.length - 1]);
    }

    private void determineAAsInSets() {
        int workingSetAACount = this.wholeProteome.getAACount(this.workingNames);
        int workingSelectedSetAACount = this.wholeProteome.getAACount(this.workingSelectedNames);
        double[] workingCoverages = new double[this.workingSelectedNames.size()];
        ArrayList<String> workingNamesOrdered = new ArrayList<String>();
        int filteredSetAACount = 0;
        int filteredSelectedSetAACount = 0;
        double[] filteredCoverages = null;
        ArrayList<String> filteredNamesOrdered = null;
        if (this.filteredProteome != null) {
            filteredSetAACount = this.filteredProteome.getAACount(this.filteredNames);
            filteredSelectedSetAACount = this.filteredProteome.getAACount(this.filteredSelectedNames);
            filteredCoverages = new double[this.filteredSelectedNames.size()];
            filteredNamesOrdered = new ArrayList<String>();
        }
        int workingIndex = 0;
        int filteredIndex = 0;
        int j = 0;
        while (j < this.selectedProteins.size()) {
            Object[] info = (Object[])this.selectedProteins.get(j);
            String pName = TrieDB.getProteinNameFromFull((String)info[0]);
            if (this.workingNames.contains(pName)) {
                workingCoverages[workingIndex] = (Double)info[1];
                workingNamesOrdered.add(pName);
                ++workingIndex;
            } else if (this.filteredProteome != null && this.filteredNames.contains(pName)) {
                filteredCoverages[filteredIndex] = (Double)info[1];
                filteredNamesOrdered.add(pName);
                ++filteredIndex;
            }
            ++j;
        }
        int workingSetCoverage = this.wholeProteome.getAACoverage(workingCoverages, workingNamesOrdered);
        int filteredSetCoverage = 0;
        if (this.filteredProteome != null) {
            filteredSetCoverage = this.filteredProteome.getAACoverage(filteredCoverages, filteredNamesOrdered);
        }
        System.out.println("Working Proteome AAs: " + workingSetAACount);
        System.out.println("Selected Working Proteome AAs: " + workingSelectedSetAACount + " = " + (double)workingSelectedSetAACount / (double)workingSetAACount);
        System.out.println("Actual Selected Working Proteome AAs: " + workingSetCoverage + " = " + (double)workingSetCoverage / (double)workingSetAACount);
        if (this.filteredProteome != null) {
            System.out.println("Filtered Proteome AAs: " + filteredSetAACount);
            System.out.println("Selected Filtered Proteome AAs: " + filteredSelectedSetAACount + " = " + (double)filteredSelectedSetAACount / (double)filteredSetAACount);
            System.out.println("Actual Selected Filtered Proteome AAs: " + filteredSetCoverage + " = " + (double)filteredSetCoverage / (double)filteredSetAACount);
        }
    }

    private void determineStartAA() {
        int[] workingStartSiteCounts = this.wholeProteome.getStartAACounts(this.workingNames);
        int[] filteredStartSiteCounts = null;
        if (this.filteredProteome != null) {
            filteredStartSiteCounts = this.filteredProteome.getStartAACounts(this.filteredNames);
        }
        int[] workingSelectedStartSiteCounts = this.wholeProteome.getStartAACounts(this.workingSelectedNames);
        int[] filteredSelectedStartSiteCounts = null;
        if (this.filteredProteome != null) {
            filteredSelectedStartSiteCounts = this.filteredProteome.getStartAACounts(this.filteredSelectedNames);
        }
        double[] counts = new double[8];
        System.out.println("\n-----All Start Sites-----");
        counts = Utils.initializeDoubleArray(counts, 0.0);
        int i = 0;
        while (i < workingStartSiteCounts.length) {
            if (i == 12) {
                counts[0] = counts[0] + (double)workingStartSiteCounts[i];
                counts[2] = counts[2] + (double)workingSelectedStartSiteCounts[i];
                if (this.filteredProteome != null) {
                    counts[4] = counts[4] + (double)filteredStartSiteCounts[i];
                    counts[6] = counts[6] + (double)filteredSelectedStartSiteCounts[i];
                }
            } else {
                counts[1] = counts[1] + (double)workingStartSiteCounts[i];
                counts[3] = counts[3] + (double)workingSelectedStartSiteCounts[i];
                if (this.filteredProteome != null) {
                    counts[5] = counts[5] + (double)filteredStartSiteCounts[i];
                    counts[7] = counts[7] + (double)filteredSelectedStartSiteCounts[i];
                }
            }
            System.out.println(String.valueOf((char)(i + 65)) + " " + workingStartSiteCounts[i] + " " + workingSelectedStartSiteCounts[i] + " " + filteredStartSiteCounts[i] + " " + filteredSelectedStartSiteCounts[i]);
            ++i;
        }
        System.out.println("\n-----Start Sites-----");
        System.out.println("Working Set: ");
        System.out.println(" " + counts[0] + " start with 'M' = " + counts[0] / (double)this.workingNames.size());
        System.out.println(" " + counts[1] + " start with other = " + counts[1] / (double)this.workingNames.size());
        System.out.println("Selected Working Set: ");
        System.out.println(" " + counts[2] + " start with 'M' = " + counts[2] / (double)this.workingSelectedNames.size());
        System.out.println(" " + counts[3] + " start with other = " + counts[3] / (double)this.workingSelectedNames.size());
        if (this.filteredProteome != null) {
            System.out.println("Filtered Set: ");
            System.out.println(" " + counts[4] + " start with 'M' = " + counts[4] / (double)this.filteredNames.size());
            System.out.println(" " + counts[5] + " start with other = " + counts[5] / (double)this.filteredNames.size());
            System.out.println("Selected Filtered Set: ");
            System.out.println(" " + counts[6] + " start with 'M' = " + counts[6] / (double)this.filteredSelectedNames.size());
            System.out.println(" " + counts[7] + " start with other = " + counts[7] / (double)this.filteredSelectedNames.size());
        }
    }

    private void determineMeanCoverage() {
        double workingSetCoverage = 0.0;
        double filteredSetCoverage = 0.0;
        int j = 0;
        while (j < this.selectedProteins.size()) {
            Object[] info = (Object[])this.selectedProteins.get(j);
            String pName = TrieDB.getProteinNameFromFull((String)info[0]);
            if (this.workingNames.contains(pName)) {
                workingSetCoverage += ((Double)info[1]).doubleValue();
            } else if (this.filteredProteome != null && this.filteredNames.contains(pName)) {
                filteredSetCoverage += ((Double)info[1]).doubleValue();
            }
            ++j;
        }
        workingSetCoverage /= (double)this.backgroundCount[0];
        if (this.filteredProteome != null) {
            filteredSetCoverage /= (double)this.backgroundCount[2];
        }
        System.out.println("\n-----Mean Protein Coverage-----");
        System.out.println("Working Set: " + workingSetCoverage);
        if (this.filteredProteome != null) {
            System.out.println("FilteredSet: " + filteredSetCoverage);
        }
    }

    private void determineMeanProteinLength() {
        double meanWorkingLength = 0.0;
        double meanFilteredLength = 0.0;
        double selectedWorkingLength = 0.0;
        double selectedFilteredLength = 0.0;
        if (this.filteredProteome != null) {
            meanFilteredLength = this.filteredProteome.getMeanLength(this.filteredNames);
        }
        meanWorkingLength = this.wholeProteome.getMeanLength(this.workingNames);
        HashSet workingTNames = MaizeUtils.getTranscriptNamesFromProteinNames(this.workingNames);
        HashSet selectedWorkingTNames = MaizeUtils.getTranscriptNamesFromProteinNames(this.workingSelectedNames);
        double[] workingExonIntronSizes = GFFFile.getMeanExonAndIntronLength(this.workingGFFFileName, workingTNames);
        double[] workingSelectedExonIntronSizes = GFFFile.getMeanExonAndIntronLength(this.workingGFFFileName, selectedWorkingTNames);
        double[] workingExonIntronNums = GFFFile.getNumExonsAndIntrons(this.workingGFFFileName, workingTNames);
        double[] workingSelectedExonIntronNums = GFFFile.getNumExonsAndIntrons(this.workingGFFFileName, selectedWorkingTNames);
        selectedWorkingLength = this.wholeProteome.getMeanLength(this.workingSelectedNames);
        System.out.println("\n-----Mean Protein Lengths-----");
        System.out.println("Working Set: " + meanWorkingLength);
        System.out.println("Selected Working Set: " + selectedWorkingLength + "\n");
        System.out.println("Working Set Exon Length: " + workingExonIntronSizes[0]);
        System.out.println("Working Set Intron Length: " + workingExonIntronSizes[1]);
        System.out.println("Working Set Exon Count: " + workingExonIntronNums[0]);
        System.out.println("Working Set Intron Count: " + workingExonIntronNums[1]);
        System.out.println("Selected Working Set Exon Length: " + workingSelectedExonIntronSizes[0]);
        System.out.println("Selected Working Set Intron Length: " + workingSelectedExonIntronSizes[1]);
        System.out.println("Selected Working Set Exon Count: " + workingSelectedExonIntronNums[0]);
        System.out.println("Selected Working Set Intron Count: " + workingSelectedExonIntronNums[1]);
        if (this.filteredProteome != null) {
            selectedFilteredLength = this.filteredProteome.getMeanLength(this.filteredSelectedNames);
            System.out.println("\nFilteredSet: " + meanFilteredLength);
            System.out.println("Selected FilteredSet: " + selectedFilteredLength + "\n");
            HashSet filteredTNames = MaizeUtils.getTranscriptNamesFromProteinNames(this.filteredNames);
            HashSet selectedFilteredTNames = MaizeUtils.getTranscriptNamesFromProteinNames(this.filteredSelectedNames);
            double[] filteredExonIntronSizes = GFFFile.getMeanExonAndIntronLength(this.filteredGFFFileName, filteredTNames);
            double[] filteredSelectedExonIntronSizes = GFFFile.getMeanExonAndIntronLength(this.filteredGFFFileName, selectedFilteredTNames);
            double[] filteredExonIntronNums = GFFFile.getNumExonsAndIntrons(this.filteredGFFFileName, filteredTNames);
            double[] filteredSelectedExonIntronNums = GFFFile.getNumExonsAndIntrons(this.filteredGFFFileName, selectedFilteredTNames);
            System.out.println("Filtered Set Exon Length: " + filteredExonIntronSizes[0]);
            System.out.println("Filtered Set Intron Length: " + filteredExonIntronSizes[1]);
            System.out.println("Filtered Set Exon Count: " + filteredExonIntronNums[0]);
            System.out.println("Filtered Set Intron Count: " + filteredExonIntronNums[1]);
            System.out.println("Selected Filtered Set Exon Length: " + filteredSelectedExonIntronSizes[0]);
            System.out.println("Selected Filtered Set Intron Length: " + filteredSelectedExonIntronSizes[1]);
            System.out.println("Selected Filtered Set Exon Count: " + filteredSelectedExonIntronNums[0]);
            System.out.println("Selected Filtered Set Intron Count: " + filteredSelectedExonIntronNums[1]);
            System.out.println("\nTotal Selected Mean Length: " + (selectedWorkingLength * (double)this.workingSelectedNames.size() + selectedFilteredLength * (double)this.filteredSelectedNames.size()) / (double)this.selectedProteins.size());
        }
    }
}

