/*
 * Decompiled with CFR 0.152.
 */
package maizeUtils;

import basicUtils.InspectAnnotation;
import basicUtils.Utils;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.imageio.ImageIO;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.FastScatterPlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.statistics.HistogramDataset;
import org.jfree.data.xy.IntervalXYDataset;
import org.jfree.ui.ApplicationFrame;
import proteogenomicUtils.EventFinder;
import proteogenomicUtils.GenomicLocator;

public class PlotDecoyEvents {
    public static String UsageInfo = "proteogenomicUtils.PlotDecoyEvents version 09272010\nCreates a png file of the derived peptideFDR versus the empirical peptide FDR.\n[REQUIRED]\n -r [FILE] File containing Events from EventFinder\n -i [DIR] Directory containing pvalued results\n -m [NUM] Event scoring mode; 0: eFDR, 1: #peptides, 2: best peptide FDR, 3: eFDR with 2 or more peptides\n -w [FILE] Output file to write image to\n[OPTIONAL]\n -p [NUM] Score cutoff to report events\n";
    private double[] decoyDataPoints;
    private double[] targetDataPoints;
    private Hashtable peptideHash;
    private String outputFile;
    private String resultsFile;
    private EventScoreMode m;
    private double scoreThreshold;
    private String decoyEventsFile = null;
    private String targetEventsFile = null;
    private String inputFile;
    private boolean Debug = false;

    public PlotDecoyEvents(String inputFile, String outputFile, String resultFile, EventScoreMode m) {
        this.outputFile = outputFile;
        this.inputFile = inputFile;
        this.resultsFile = resultFile;
        this.m = m;
    }

    private void GeneratePlot() {
        this.populatePeptideHash();
        this.populateData();
        HistogramDataset ScoreHisto = new HistogramDataset();
        ScoreHisto.addSeries((Comparable)((Object)"IncorrectLabels"), this.decoyDataPoints, 200);
        ScoreHisto.addSeries((Comparable)((Object)"CorrectLabels"), this.targetDataPoints, 200);
        JFreeChart Chart = ChartFactory.createHistogram((String)("Score Histogram(" + this.targetDataPoints.length + " True, " + this.decoyDataPoints.length + " False)"), (String)"Score", (String)"Counts", (IntervalXYDataset)ScoreHisto, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)false, (boolean)false);
        if (this.m == EventScoreMode.NumPeptides || this.m == EventScoreMode.NumPeptidesFiltered) {
            int Bin;
            int[][] Counts = new int[25][2];
            int i = 0;
            while (i < this.targetDataPoints.length) {
                Bin = Math.min(Counts.length - 1, (int)this.targetDataPoints[i]);
                int[] nArray = Counts[Bin];
                nArray[0] = nArray[0] + 1;
                ++i;
            }
            i = 0;
            while (i < this.decoyDataPoints.length) {
                Bin = Math.min(Counts.length - 1, (int)this.decoyDataPoints[i]);
                int[] nArray = Counts[Bin];
                nArray[1] = nArray[1] + 1;
                ++i;
            }
            i = 0;
            while (i < Counts.length) {
                System.out.println(String.valueOf(i) + " " + Counts[i][0] + " " + Counts[i][1]);
                ++i;
            }
        }
        BufferedImage Image2 = Chart.createBufferedImage(1000, 1000);
        String ScoreFileName = this.outputFile;
        System.out.println("Created histo..." + ScoreFileName);
        try {
            ImageIO.write((RenderedImage)Image2, "png", new File(ScoreFileName));
        }
        catch (Exception E) {
            System.err.println(E.getMessage());
            return;
        }
        this.plotROC();
    }

    /*
     * Unable to fully structure code
     */
    private void plotROC() {
        block11: {
            block9: {
                tempDataX = new ArrayList<Float>();
                tempDataY = new ArrayList<Float>();
                this.decoyDataPoints = Utils.SortDoubleArrayIncreasing(this.decoyDataPoints);
                this.targetDataPoints = Utils.SortDoubleArrayIncreasing(this.targetDataPoints);
                TargetCount = 0;
                TargetIndex = 0;
                LocalDebug = false;
                if (this.m != EventScoreMode.BestPepFDR) break block9;
                i = 0;
                while (i < this.decoyDataPoints.length) {
                    block10: {
                        if (i >= this.decoyDataPoints.length - 1 || this.decoyDataPoints[i] != this.decoyDataPoints[i + 1]) ** GOTO lbl15
                        break block10;
lbl-1000:
                        // 1 sources

                        {
                            ++TargetCount;
                            ++TargetIndex;
lbl15:
                            // 2 sources

                            ** while (TargetIndex < this.targetDataPoints.length && this.targetDataPoints[TargetIndex] <= this.decoyDataPoints[i])
                        }
lbl16:
                        // 1 sources

                        tempDataX.add(new Float(i));
                        tempDataY.add(new Float(TargetCount));
                        System.out.println(String.valueOf(i) + " " + TargetCount + " " + this.decoyDataPoints[i] + " " + (double)i / (double)TargetCount);
                    }
                    ++i;
                }
                break block11;
            }
            TargetIndex = this.targetDataPoints.length - 1;
            i = this.decoyDataPoints.length - 1;
            while (i >= 0) {
                block12: {
                    if (LocalDebug) {
                        System.out.println("DECOY[" + i + "]: " + this.decoyDataPoints[i]);
                        System.out.println("TARGET[" + TargetIndex + "]: " + this.targetDataPoints[TargetIndex]);
                    }
                    if (i <= 0 || this.decoyDataPoints[i] != this.decoyDataPoints[i - 1]) ** GOTO lbl39
                    break block12;
lbl-1000:
                    // 1 sources

                    {
                        ++TargetCount;
                        --TargetIndex;
                        if (!LocalDebug) continue;
                        System.out.println("added that target since it is larger than decoy!");
                        System.out.println("TARGET[" + TargetIndex + "]: " + this.targetDataPoints[TargetIndex]);
lbl39:
                        // 3 sources

                        ** while (TargetIndex >= 0 && this.targetDataPoints[TargetIndex] >= this.decoyDataPoints[i])
                    }
lbl40:
                    // 1 sources

                    if (LocalDebug) {
                        System.out.println("Adding new coord (" + i + "," + TargetCount + ")");
                        Utils.WaitForEnter();
                    }
                    tempDataX.add(new Float(this.decoyDataPoints.length - i - 1));
                    tempDataY.add(new Float(TargetCount));
                    System.out.println(String.valueOf(this.decoyDataPoints.length - i - 1) + " " + TargetCount + " " + this.decoyDataPoints[i] + " " + (double)(this.decoyDataPoints.length - i - 1) / (double)TargetCount);
                }
                --i;
            }
        }
        dataPoints = new float[2][tempDataX.size()];
        i = 0;
        while (i < dataPoints[0].length) {
            dataPoints[0][i] = ((Float)tempDataX.get(i)).floatValue();
            dataPoints[1][i] = ((Float)tempDataY.get(i)).floatValue();
            ++i;
        }
        f = new ApplicationFrame(dataPoints[0].length + " data points");
        domainAxis = new NumberAxis("False Events");
        domainAxis.setAutoRangeIncludesZero(false);
        rangeAxis = new NumberAxis("True Events");
        rangeAxis.setAutoRangeIncludesZero(false);
        plot = new FastScatterPlot(dataPoints, (ValueAxis)domainAxis, (ValueAxis)rangeAxis);
        chart = new JFreeChart(dataPoints[0].length + " data points in " + (Object)this.m + " mode", (Plot)plot);
        Image = chart.createBufferedImage(1000, 1000);
        FileName = Utils.GetFileNameNoExtension(this.outputFile);
        ScoreFileName = String.valueOf(FileName) + "_ROC.png";
        System.out.println("Created dot plot..." + ScoreFileName);
        try {
            ImageIO.write((RenderedImage)Image, "png", new File(ScoreFileName));
        }
        catch (Exception E) {
            System.err.println(E.getMessage());
            return;
        }
    }

    private void populatePeptideHash() {
        this.peptideHash = InspectAnnotation.LoadInspectResultsFileToPeptideHash(this.resultsFile);
    }

    private void populateData() {
        ArrayList<Double> TrueScores = new ArrayList<Double>();
        ArrayList<Double> FalseScores = new ArrayList<Double>();
        ArrayList<EventFinder.Event> FilteredTrueEvents = new ArrayList<EventFinder.Event>();
        ArrayList<EventFinder.Event> FilteredDecoyEvents = new ArrayList<EventFinder.Event>();
        System.out.println("Loading events from " + this.inputFile);
        EventFinder.Event[] events = EventFinder.Event.LoadEventsFromFile(this.inputFile);
        System.out.println("Loaded " + events.length + " events to consider...");
        int j = 0;
        while (j < events.length) {
            double Score = this.GetScore(events[j]);
            if (this.m != EventScoreMode.NumPeptidesFiltered || !(events[j].Prob < this.scoreThreshold)) {
                boolean isFalse = this.DetermineIfFalse(events[j]);
                if (this.decoyEventsFile != null && (this.m == EventScoreMode.eFDR && Score >= this.scoreThreshold || this.m == EventScoreMode.BestPepFDR && Score <= this.scoreThreshold || this.m == EventScoreMode.NumPeptides && Score >= this.scoreThreshold)) {
                    if (isFalse) {
                        FilteredDecoyEvents.add(events[j]);
                    } else {
                        FilteredTrueEvents.add(events[j]);
                    }
                }
                if (this.Debug) {
                    System.out.println("Score: " + Score);
                    System.out.println("isFalse: " + isFalse);
                    events[j].DebugPrint();
                    Utils.WaitForEnter();
                }
                if (isFalse) {
                    FalseScores.add(new Double(Score));
                } else {
                    TrueScores.add(new Double(Score));
                }
            }
            ++j;
        }
        this.decoyDataPoints = Utils.ConvertArraylistToDoubleArray(FalseScores);
        this.targetDataPoints = Utils.ConvertArraylistToDoubleArray(TrueScores);
        if (this.decoyEventsFile != null && FilteredDecoyEvents.size() > 0) {
            System.out.println("Writing " + FilteredDecoyEvents.size() + " decoy events to " + this.decoyEventsFile + "!");
            FileWriter f = null;
            try {
                f = new FileWriter(this.decoyEventsFile);
            }
            catch (IOException E) {
                E.printStackTrace();
            }
            int i = 0;
            while (i < FilteredDecoyEvents.size()) {
                EventFinder.Event currE = (EventFinder.Event)FilteredDecoyEvents.get(i);
                try {
                    f.write(String.valueOf(currE.CreateFileString()) + "\n");
                }
                catch (IOException E) {
                    E.printStackTrace();
                }
                ++i;
            }
            try {
                f.close();
            }
            catch (IOException E) {
                E.printStackTrace();
            }
        }
        if (this.targetEventsFile != null && FilteredTrueEvents.size() > 0) {
            System.out.println("Writing " + FilteredTrueEvents.size() + " target events to " + this.targetEventsFile + "!");
            double TotalPeptides = 0.0;
            FileWriter f = null;
            try {
                f = new FileWriter(this.targetEventsFile);
            }
            catch (IOException E) {
                E.printStackTrace();
            }
            int i = 0;
            while (i < FilteredTrueEvents.size()) {
                EventFinder.Event currE = (EventFinder.Event)FilteredTrueEvents.get(i);
                TotalPeptides += (double)currE.getSupportingLocations().size();
                try {
                    f.write(String.valueOf(currE.CreateFileString()) + "\n");
                }
                catch (IOException E) {
                    E.printStackTrace();
                }
                ++i;
            }
            try {
                f.close();
            }
            catch (IOException E) {
                E.printStackTrace();
            }
            System.out.println("average peps/event = " + TotalPeptides / (double)FilteredTrueEvents.size());
        }
    }

    private boolean DetermineIfFalse(EventFinder.Event e) {
        if (Utils.IsDecoyProtein(e.RefinedFeature)) {
            return true;
        }
        if (this.Debug) {
            System.out.println("this event is on the forward strand, see if it has any target peptide matches!");
            e.DebugPrint();
        }
        int i = 0;
        while (i < e.getSupportingLocations().size()) {
            Object[] currLoc = (Object[])e.getSupportingLocations().get(i);
            String pep = (String)currLoc[GenomicLocator.GenomicColumns.Peptide];
            if (pep.indexOf(46) >= 0) {
                pep = pep.substring(2, pep.length() - 2);
            }
            InspectAnnotation bestAnn = (InspectAnnotation)this.peptideHash.get(pep);
            if (this.Debug) {
                System.out.println(pep);
                bestAnn.DebugPrint();
            }
            if (!Utils.IsDecoyProtein(bestAnn.ProteinName)) {
                if (this.Debug) {
                    System.out.println("This annotation is a ture peptide: " + pep);
                    Utils.WaitForEnter();
                }
                return false;
            }
            ++i;
        }
        if (this.Debug) {
            System.out.println("this event has no true peptides!");
            Utils.WaitForEnter();
        }
        return true;
    }

    private double GetScore(EventFinder.Event e) {
        if (this.m == EventScoreMode.eFDR) {
            return e.Prob;
        }
        if (this.m == EventScoreMode.NumPeptides || this.m == EventScoreMode.NumPeptidesFiltered) {
            return e.getSupportingLocations().size();
        }
        if (this.m == EventScoreMode.BestPepFDR) {
            double bestFDR = Double.MAX_VALUE;
            int i = 0;
            while (i < e.getSupportingLocations().size()) {
                Object[] currLoc = (Object[])e.getSupportingLocations().get(i);
                double currFDR = (Double)currLoc[GenomicLocator.GenomicColumns.BestLocalFDR];
                if (currFDR < bestFDR) {
                    bestFDR = currFDR;
                }
                ++i;
            }
            return bestFDR;
        }
        return Double.NEGATIVE_INFINITY;
    }

    public static void main(String[] args) {
        String[] options = new String[]{"-r", "-w", "-m", "-i", "-p"};
        boolean[] values = new boolean[]{true, true, true, true, true};
        Hashtable CommandLineArgs = Utils.ParseCommandLine(args, options, values);
        if (!(CommandLineArgs.containsKey("-r") && CommandLineArgs.containsKey("-w") && CommandLineArgs.containsKey("-m") && CommandLineArgs.containsKey("-i"))) {
            System.err.println("ERROR: Must specify an input file, score mode, and output file!");
            System.err.println(UsageInfo);
            System.exit(0);
        }
        String InputFile = (String)CommandLineArgs.get("-r");
        String OutputFile = (String)CommandLineArgs.get("-w");
        String ResultFile = (String)CommandLineArgs.get("-i");
        int ScoreMode = Integer.parseInt((String)CommandLineArgs.get("-m"));
        EventScoreMode m = null;
        if (ScoreMode == 0) {
            m = EventScoreMode.eFDR;
        } else if (ScoreMode == 1) {
            m = EventScoreMode.NumPeptides;
        } else if (ScoreMode == 2) {
            m = EventScoreMode.BestPepFDR;
        } else if (ScoreMode == 3) {
            m = EventScoreMode.NumPeptidesFiltered;
        } else {
            System.err.println("ERROR: Invalid score mode 'ScoreMode', must be 0, 1, 2, or 3");
            System.err.println(UsageInfo);
            System.exit(-1);
        }
        PlotDecoyEvents p = new PlotDecoyEvents(InputFile, OutputFile, ResultFile, m);
        if (CommandLineArgs.containsKey("-p")) {
            p.scoreThreshold = Double.parseDouble((String)CommandLineArgs.get("-p"));
            String outputBase = Utils.GetFileNameNoExtension(OutputFile);
            p.decoyEventsFile = String.valueOf(outputBase) + "_decoyEvents.txt";
            p.targetEventsFile = String.valueOf(outputBase) + "_targetEvents.txt";
        }
        p.GeneratePlot();
    }

    static enum EventScoreMode {
        NumPeptides,
        eFDR,
        BestPepFDR,
        NumPeptidesFiltered;

    }
}

