/*
 * Decompiled with CFR 0.152.
 */
package maizeUtils;

import basicUtils.Utils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import proteogenomicUtils.KnownProteinChooser;

public class SharedPeptideAnalyzer {
    public static final String usageInfo = "proteogenomicUtils.SharedPeptideAnalyzer version 10.08.2011\nThis class analyzes the structure of peptide - protein matches\n[REQUIRED]:\n -r [FILE/DIR] File or directory containing files of Inspect results\n -t [FILE] this specifies the proteome trie file\n";
    KnownProteinChooser c = null;
    boolean debug = false;
    private Hashtable proteinInfo = null;

    public SharedPeptideAnalyzer(String inputDir, String proteome) {
        this.c = new KnownProteinChooser(inputDir, proteome, KnownProteinChooser.ChooseScheme.Maximony, null, proteome, 1, 0.0, null, null, null);
        this.proteinInfo = new Hashtable();
    }

    public static void main(String[] args) {
        String Proteome;
        String InputDir;
        String[] options = new String[]{"-r", "-t", "-d"};
        boolean[] blArray = new boolean[3];
        blArray[0] = true;
        blArray[1] = true;
        boolean[] values = blArray;
        Hashtable CommandLineArgs = Utils.ParseCommandLine(args, options, values);
        if (!CommandLineArgs.containsKey("-r") || !CommandLineArgs.containsKey("-t")) {
            System.err.println("ERROR: Must specify an input file/directoryand  a proteome file!");
            System.err.println(usageInfo);
            System.exit(0);
        }
        if (!Utils.IsFile(InputDir = (String)CommandLineArgs.get("-r")) && !Utils.IsDir(InputDir)) {
            System.err.println("ERROR: Invalid file/directory path '" + InputDir + "'!");
            System.err.println(KnownProteinChooser.UsageInfo);
            System.exit(-1);
        }
        if (!Utils.IsFile(Proteome = (String)CommandLineArgs.get("-t"))) {
            System.err.println("ERROR: Invalid proteome file '" + Proteome + "'\n");
            System.err.println(KnownProteinChooser.UsageInfo);
            System.exit(-1);
        }
        SharedPeptideAnalyzer a = new SharedPeptideAnalyzer(InputDir, Proteome);
        if (CommandLineArgs.containsKey("-d")) {
            a.debug = true;
        }
        a.analyzeSharedPeptideStructure();
    }

    private void analyzeSharedPeptideStructure() {
        this.c.PopulateHashes();
        this.c.ChooseProteinsMaximony();
        if (this.debug) {
            System.out.println("Final Protein List size: " + this.c.FinalProteinList.size());
            System.out.println("Total peptides: " + this.c.FinalPeptide2Protein.size());
        }
        int totalComponents = 0;
        int totalLargeComponents = 0;
        int totalProteinsInLargeComponents = 0;
        int totalPeptidesInLargeComponents = 0;
        this.getProteinInfo();
        boolean[] analyzed = new boolean[this.c.FinalProteinList.size()];
        int i = 0;
        while (i < analyzed.length) {
            analyzed[i] = false;
            ++i;
        }
        i = 0;
        while (i < this.c.FinalProteinList.size()) {
            if (!analyzed[i]) {
                ArrayList<Integer> currComponent = new ArrayList<Integer>();
                ArrayList currComponentPeptides = new ArrayList();
                HashSet<String> peptides = new HashSet<String>();
                Integer currId = (Integer)this.c.FinalProteinList.get(i);
                if (this.debug) {
                    System.out.println("Considering protein[" + i + "]= " + currId);
                }
                currComponent.add(currId);
                ArrayList peps = (ArrayList)this.c.FinalProtein2Peptides.get(currId);
                currComponentPeptides.addAll((ArrayList)this.c.FinalProtein2Peptides.get(currId));
                if (this.debug) {
                    System.out.println("currComponentPeptides.size()=" + currComponentPeptides.size());
                }
                while (currComponentPeptides.size() > 0) {
                    String currPeptide = (String)currComponentPeptides.get(0);
                    currComponentPeptides.remove(0);
                    if (peptides.contains(currPeptide)) {
                        if (!this.debug) continue;
                        System.out.println("Peptide already exists in our set");
                        continue;
                    }
                    if (this.debug) {
                        System.out.println("New peptide: " + currPeptide);
                    }
                    peptides.add(currPeptide);
                    ArrayList linkedProteins = (ArrayList)this.c.FinalPeptide2Protein.get(currPeptide);
                    int j = 0;
                    while (j < linkedProteins.size()) {
                        Integer linkedID = (Integer)linkedProteins.get(j);
                        if (!currComponent.contains(linkedID)) {
                            currComponent.add(linkedID);
                            currComponentPeptides.addAll((ArrayList)this.c.FinalProtein2Peptides.get(linkedID));
                            int index = this.c.FinalProteinList.indexOf(linkedID);
                            if (analyzed[index]) {
                                System.out.println("FUCK!!");
                            }
                            analyzed[index] = true;
                        }
                        ++j;
                    }
                }
                if (this.debug) {
                    System.out.println("Completed a component containing " + currComponent.size() + " proteins and " + peptides.size() + " peptides");
                    ++totalComponents;
                    if (currComponent.size() > 1) {
                        Object[] pepList = peptides.toArray();
                        ++totalLargeComponents;
                        totalProteinsInLargeComponents += currComponent.size();
                        totalPeptidesInLargeComponents += peptides.size();
                        int j = 0;
                        while (j < currComponent.size()) {
                            Integer currID = (Integer)currComponent.get(j);
                            int[] protInfo = (int[])this.proteinInfo.get(currID);
                            String line = String.valueOf(currID) + " " + this.c.Proteome.getProteinName(currID) + " " + protInfo[0] + " " + protInfo[1] + " ";
                            ArrayList p = (ArrayList)this.c.FinalProtein2Peptides.get(currID);
                            int k = 0;
                            while (k < p.size()) {
                                String currPep = (String)p.get(k);
                                ArrayList links = (ArrayList)this.c.FinalPeptide2Protein.get(currPep);
                                int x = 0;
                                while (x < pepList.length) {
                                    String pepListPep = (String)pepList[x];
                                    if (pepListPep.equals(currPep)) {
                                        line = String.valueOf(line) + x + ",";
                                        break;
                                    }
                                    ++x;
                                }
                                ++k;
                            }
                            System.out.println(line);
                            ++j;
                        }
                        j = 0;
                        while (j < pepList.length) {
                            String currPep = (String)pepList[j];
                            int count = ((ArrayList)this.c.FinalPeptide2Protein.get(currPep)).size();
                            System.out.println(String.valueOf(currPep) + " " + j + " " + count);
                            ++j;
                        }
                        Utils.WaitForEnter();
                    }
                    System.out.println("total components: " + totalComponents);
                    System.out.println("total components with 2+ proteins: " + totalLargeComponents);
                    System.out.println("average proteins/large component: " + (double)totalProteinsInLargeComponents / (double)totalLargeComponents);
                    System.out.println("average proteins/large component: " + (double)totalPeptidesInLargeComponents / (double)totalLargeComponents);
                }
            }
            ++i;
        }
        System.out.println("total components: " + totalComponents);
        System.out.println("total components with 2+ proteins: " + totalLargeComponents);
        System.out.println("average proteins/large component: " + (double)totalProteinsInLargeComponents / (double)totalLargeComponents);
        System.out.println("average proteins/large component: " + (double)totalPeptidesInLargeComponents / (double)totalLargeComponents);
    }

    private void getProteinInfo() {
        int i = 0;
        while (i < this.c.FinalProteinList.size()) {
            Integer currProtein = (Integer)this.c.FinalProteinList.get(i);
            ArrayList peptides = (ArrayList)this.c.FinalProtein2Peptides.get(currProtein);
            int[] protInfo = new int[2];
            protInfo[0] = peptides.size();
            int sharedCount = 0;
            int j = 0;
            while (j < peptides.size()) {
                String currPeptide = (String)peptides.get(j);
                ArrayList otherProteins = (ArrayList)this.c.FinalPeptide2Protein.get(currPeptide);
                if (otherProteins.size() > 1) {
                    ++sharedCount;
                }
                ++j;
            }
            protInfo[1] = sharedCount;
            this.proteinInfo.put(currProtein, protInfo);
            ++i;
        }
    }
}

