/*
 * Decompiled with CFR 0.152.
 */
package maizeUtils;

import basicUtils.InspectAnnotation;
import basicUtils.Utils;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import proteogenomicUtils.GenomicLocator;

public class VennDiagramCreator {
    public static String UsageInfo = "maizeUtils.VennDiagramCreator \nLooks at maize seed data sets and creates the numbers for a venn diagram.\n[REQUIRED]\n -r [DIR] Directory containing peptide information\n -t [0/1] The type of peptide information (0: Inspect format, 1: location format)\n";
    private String[] classes = new String[]{"Endosperm", "Embryo", "Pericarp-Aleurone"};
    private String[] inputFiles;
    private fileTypes type;
    private Hashtable peptideHash;

    public VennDiagramCreator(String inputDir, int type) {
        if (!Utils.IsDir(inputDir)) {
            System.err.println("ERROR: Invalid input directory '" + inputDir + "'!");
            System.exit(-1);
        }
        this.inputFiles = Utils.ListDir(inputDir);
        if (type != 0 && type != 1) {
            System.err.println("ERROR: Invalid input data type '" + type + "', must be 0: Inspect format, or 1: location format\n");
            System.exit(-1);
        }
        this.type = type == 0 ? fileTypes.INSPECT_FORMAT : fileTypes.LOCATION_FORMAT;
    }

    public static void main(String[] args) {
        String[] options = new String[]{"-r", "-t"};
        boolean[] values = new boolean[]{true, true};
        Hashtable CommandLineArgs = Utils.ParseCommandLine(args, options, values);
        if (!CommandLineArgs.containsKey("-r") || !CommandLineArgs.containsKey("-t")) {
            System.err.println("ERROR: Must specify an input file/directory and a file type!");
            System.err.println(UsageInfo);
            System.exit(0);
        }
        String inputDir = (String)CommandLineArgs.get("-r");
        int type = Integer.parseInt((String)CommandLineArgs.get("-t"));
        VennDiagramCreator v = new VennDiagramCreator(inputDir, type);
        v.create();
    }

    private void create() {
        if (this.type == fileTypes.INSPECT_FORMAT) {
            this.peptideHash = InspectAnnotation.LoadInspectResultsPep2FileNameHash(this.inputFiles);
        } else {
            this.peptideHash = new Hashtable();
            int i = 0;
            while (i < this.inputFiles.length) {
                ArrayList locs = GenomicLocator.GenomicColumns.LoadFromFile(this.inputFiles[i]);
                int j = 0;
                while (j < locs.size()) {
                    Object[] loc = (Object[])locs.get(j);
                    String peptide = Utils.GetUnModded((String)loc[GenomicLocator.GenomicColumns.Peptide]);
                    if (peptide.indexOf(46) >= 0) {
                        peptide = peptide.substring(2, peptide.length() - 2);
                    }
                    ArrayList fileNames = null;
                    fileNames = this.peptideHash.containsKey(peptide) ? (ArrayList)this.peptideHash.get(peptide) : new ArrayList();
                    if (!fileNames.contains(this.inputFiles[i])) {
                        fileNames.add(this.inputFiles[i]);
                    }
                    this.peptideHash.put(peptide, fileNames);
                    ++j;
                }
                ++i;
            }
        }
        System.out.println("Loaded " + this.peptideHash.size() + " peptides");
        boolean[] found = new boolean[this.classes.length];
        int[] counts = new int[(int)Math.pow(2.0, this.classes.length)];
        Enumeration keys = this.peptideHash.keys();
        while (keys.hasMoreElements()) {
            int index;
            int i = 0;
            while (i < found.length) {
                found[i] = false;
                ++i;
            }
            String currPep = (String)keys.nextElement();
            ArrayList files = (ArrayList)this.peptideHash.get(currPep);
            int i2 = 0;
            while (i2 < files.size()) {
                String currFile = (String)files.get(i2);
                int j = 0;
                while (j < this.classes.length) {
                    if (currFile.indexOf(this.classes[j]) >= 0) {
                        found[j] = true;
                    }
                    ++j;
                }
                ++i2;
            }
            int n = index = Utils.convertBinary2Decimal(found);
            counts[n] = counts[n] + 1;
        }
        int i = 1;
        while (i < counts.length) {
            found = Utils.convertDecimal2Binary(i, this.classes.length);
            String categories = "";
            int j = 0;
            while (j < found.length) {
                if (found[j]) {
                    categories = String.valueOf(categories) + this.classes[j] + ",";
                }
                ++j;
            }
            System.out.println(String.valueOf(categories) + " " + counts[i]);
            ++i;
        }
    }

    public static enum fileTypes {
        INSPECT_FORMAT,
        LOCATION_FORMAT;

    }
}

