/*
 * Decompiled with CFR 0.152.
 */
package ms2dbUtils;

import basicUtils.GFFFile;
import basicUtils.Utils;
import errorUtils.ErrorThrower;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import ms2dbUtils.ParseSpliceGraph;
import trieUtils.TrieDB;

public class ConstructSpliceGraphWithInDel {
    public static String UsageInfo = "BuildMS2DB.java version 2012.20.03\nCreates an ms2db database given a fasta file (formatted using PrepDB.py) and\na set of exon/intron predictions in a gff file.  In contrast to the Inspect version of\nBuildMS2DB.c, multiple sequences can be specified and the exons will be correctly\ngrouped into genes.  In the Notes column of the GFF file, it uses the 'parent=XXX' to distinguish\nexons from the same transcript.  If no parent is specified, then it looks for 'id=XXX'. Also,\nthe sequence name in the FASTA file must be identical to the sequence name in the GFF file.\nREQUIRED:\n-r [FILE] GFF file build on the sequences in the sequence file given (may specify multiple times)\n-s [FILE] The FASTA or trie file version of the sequence file(if .trie then a corresponding .index file is assumed to exist)\n-w [FILE] The output file\nOPTIONAL:\n-c [NUM] Genetic code table to use for translation (default: 0)\n-t [STRING] The interval type to use (e.g. CDS, Exon, Match), case-insensitive (may specify multiple times, default: CDS)\n-d Run in Debug Mode\n-f Interpret the 'frame' as the 'phase'.  The frame is the number of nucleotides to skip before the start of the codon.  The phase \n   is the position of the first nucleotide in the codon (0,1,2).\n-g [NUM1-NUM2] Add introns between compatible exons if they are within this base pair range [NUM1-NUM2] (inclusive). (Default: no introns are added)\n-m [NUM] Max number of artificially added introns for each exon. (Default: 10 if intron range is specified with -g)\n";
    public boolean Debug = false;
    public boolean ReadPhase = false;
    private int minIntronLen = -1;
    private int maxIntronLen = -1;
    private int maxOutEdgesAdded = 10;
    private int codonTable = 0;
    private Hashtable HashedSequences = null;
    public MS2Gene CurrMS2GeneForParsing = null;
    public MS2Exon CurrMS2ExonForParsing = null;
    public InsertionExon FirstInsertionExon;
    public MutationExon FirstMutationExon;
    public InsertionExon LastInsertionExon;
    public MutationExon LastMutationExon;
    public int InsertionExonCount;
    public int MutationExonCount;
    public String TrieFile;
    public TrieDB Trie;
    public int ForwardFlag;
    public String OutputFileName;
    public FileWriter OutputFile = null;
    public String[] GFFFiles;
    public String[] SpliceInfoFiles;
    public String[] VCFFiles;
    public String[] DeletionInfoFiles;
    public String[] InsertionInfoFiles;
    public String UpdateMS2DBFile;
    public Hashtable ExonHash;
    public MS2Exon FirstExon;
    public MS2Exon LastExon;
    public MS2Gene FirstMS2Gene;
    public MS2Gene LastMS2Gene;
    public String[] intervalTypes = null;
    int ExonCount = 0;
    int GeneCount = 0;
    int GeneIndex = 0;
    public MS2Exon PrevExon = null;
    public String CurrFileName = "";

    public void AddInsertionExon(int Coordinate, String ChrString, int InsertionLen, String InsertionString, int Strand) {
        InsertionExon Exon = new InsertionExon(Coordinate, ChrString, InsertionLen, InsertionString, Strand);
        if (this.FirstInsertionExon == null) {
            this.FirstInsertionExon = Exon;
        } else {
            this.LastInsertionExon.Next = Exon;
        }
        this.LastInsertionExon = Exon;
        ++this.InsertionExonCount;
    }

    public void AddMutationExon(int Start, int End, String ChrString, int MutationLen, String MutationString, int Strand) {
        MutationExon Exon = new MutationExon(Start, End, ChrString, MutationLen, MutationString, Strand);
        if (this.FirstMutationExon == null) {
            this.FirstMutationExon = Exon;
        } else {
            this.LastMutationExon.Next = Exon;
        }
        this.LastMutationExon = Exon;
        ++this.MutationExonCount;
    }

    private void printParams() {
        System.out.println("PARAMS:");
        System.out.println("FASTA file: " + this.TrieFile);
        System.out.println("Genetic code: " + Utils.dnaCodeNames[this.codonTable]);
    }

    private String BuildHashKey(MS2Exon Exon) {
        return String.valueOf(Exon.SequenceName) + "@" + Exon.Start + "@" + Exon.End + "@" + Exon.Strand;
    }

    String BuildHashKey(String SequenceName, int Start, int End, int Strand) {
        return String.valueOf(SequenceName) + "@" + Start + "@" + End + "@" + Strand;
    }

    public static boolean isInteger(String s) {
        try {
            Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    public void AddMS2Exon(MS2Exon Exon) {
        boolean LocalDebug = false;
        if (this.FirstExon == null) {
            this.FirstExon = Exon;
            if (LocalDebug) {
                System.out.println("This is teh first exon!!");
            }
        } else {
            this.LastExon.Next = Exon;
            Exon.Prev = this.LastExon;
            if (LocalDebug) {
                System.out.println("This is the new last exon!!");
            }
        }
        this.LastExon = Exon;
        ++this.ExonCount;
        if (LocalDebug) {
            Utils.WaitForEnter();
        }
    }

    public MS2Exon HashExon(int Start, int End, String SequenceName, int Strand) {
        String HashValue = this.BuildHashKey(SequenceName, Start, End, Strand);
        if (this.ExonHash.containsKey(HashValue)) {
            if (this.Debug) {
                System.out.println("We've already created this exon [" + Start + "-" + End + "]" + " on " + SequenceName + " on strand " + Strand);
            }
            return (MS2Exon)this.ExonHash.get(HashValue);
        }
        MS2Exon Exon = new MS2Exon(Start, End, SequenceName, Strand);
        this.ExonHash.put(HashValue, Exon);
        this.AddMS2Exon(Exon);
        return Exon;
    }

    public MS2Exon HashExon(int Start, int End, String SequenceName, int Strand, int index) {
        String HashValue = this.BuildHashKey(SequenceName, Start, End, Strand);
        if (this.ExonHash.containsKey(HashValue)) {
            if (this.Debug) {
                System.out.println("We've already created this exon [" + Start + "-" + End + "]" + " on " + SequenceName + " on strand " + Strand);
            }
            return (MS2Exon)this.ExonHash.get(HashValue);
        }
        MS2Exon Exon = new MS2Exon(Start, End, SequenceName, Strand, index);
        this.ExonHash.put(HashValue, Exon);
        this.AddMS2Exon(Exon);
        return Exon;
    }

    public int HandleGFFFileLine(int LineNumber, int FilePos, String LineBuffer, String DesiredSeqName) {
        String[] Bits2;
        if ((LineBuffer = LineBuffer.trim()).startsWith("[(")) {
            return -1;
        }
        String[] Bits = LineBuffer.split("\t");
        if (Bits.length < 9) {
            return 0;
        }
        String SeqName = Bits[GFFFile.GFFColumns.SequenceName];
        if (ConstructSpliceGraphWithInDel.isInteger(SeqName) || SeqName == "X" || SeqName == "Y") {
            SeqName = "chr" + SeqName;
        }
        String DatabaseName = Bits[GFFFile.GFFColumns.Source];
        String IntervalType = Bits[GFFFile.GFFColumns.FeatureType];
        if (!Utils.MatchesAnyCaseInsensitive(IntervalType, this.intervalTypes)) {
            return -1;
        }
        int Start = 0;
        int End = 0;
        String GeneName = null;
        Start = Integer.parseInt(Bits[GFFFile.GFFColumns.Start]) - 1;
        End = Integer.parseInt(Bits[GFFFile.GFFColumns.End]);
        int Strand = GFFFile.ParseStrand(Bits[GFFFile.GFFColumns.Strand]);
        if (Strand < 0) {
            Strand = this.ForwardFlag;
        }
        if (Strand != this.ForwardFlag) {
            return -1;
        }
        String Notes = Bits[GFFFile.GFFColumns.Attributes];
        String[] NoteElements = Notes.split(";");
        GeneName = null;
        int i = 0;
        while (i < NoteElements.length) {
            Bits2 = NoteElements[i].split("=");
            if (Bits2[0].toLowerCase().indexOf("parent") >= 0) {
                GeneName = Bits2[1].replaceAll("\"", "");
                break;
            }
            ++i;
        }
        if (GeneName == null) {
            i = 0;
            while (i < NoteElements.length) {
                Bits2 = NoteElements[i].split("=");
                if (Bits2[0].toLowerCase().indexOf("id") >= 0) {
                    GeneName = Bits2[1].replaceAll("\"", "");
                    break;
                }
                ++i;
            }
        }
        if (GeneName == null) {
            GeneName = SeqName;
        }
        MS2Exon Exon = this.HashExon(Start, End, SeqName, Strand);
        if (this.PrevExon != null) {
            if (Utils.HasOverlap(Exon.Start, Exon.End, this.PrevExon.Start, this.PrevExon.End)) {
                System.err.println("ERROR: Exon [" + Exon.Start + "-" + Exon.End + "] overlaps previous exon [" + this.PrevExon.Start + "-" + this.PrevExon.End + "]");
                System.err.println(LineBuffer);
                return -1;
            }
            if (this.PrevExon.Start < Exon.Start) {
                this.PrevExon.LinkExonForward(Exon);
            } else {
                Exon.LinkExonForward(this.PrevExon);
            }
        }
        this.PrevExon = Exon;
        return 1;
    }

    public int HandleSpliceInfoFileLine(int LineNumber, int FilePos, String LineBuffer, String DesiredSeqName) {
        if ((LineBuffer = LineBuffer.trim()).startsWith("[(")) {
            return -1;
        }
        String[] Bits = LineBuffer.split("\t");
        String ChrName = Bits[0];
        if (ConstructSpliceGraphWithInDel.isInteger(ChrName) || ChrName == "X" || ChrName == "Y") {
            ChrName = "chr" + ChrName;
        }
        int JunctionStart = Integer.parseInt(Bits[1]) - 1;
        int JunctionEnd = Integer.parseInt(Bits[2]);
        int Strand = GFFFile.ParseStrand(Bits[4]);
        if (Strand < 0) {
            Strand = this.ForwardFlag;
        }
        if (Strand != this.ForwardFlag) {
            return -1;
        }
        MS2Exon Exon1 = this.HashExon(JunctionStart - 90, JunctionStart, ChrName, Strand);
        MS2Exon Exon2 = this.HashExon(JunctionEnd, JunctionEnd + 90, ChrName, Strand);
        Exon1.LinkExonForward(Exon2);
        return 1;
    }

    public int HandleDeletionInfoFileLine(int LineNumber, int FilePos, String LineBuffer, String DesiredSeqName) {
        if ((LineBuffer = LineBuffer.trim()).startsWith("[(")) {
            return -1;
        }
        String[] Bits = LineBuffer.split("\t");
        String ChrName = Bits[0];
        if (ConstructSpliceGraphWithInDel.isInteger(ChrName) || ChrName == "X" || ChrName == "Y") {
            ChrName = "chr" + ChrName;
        }
        int JunctionStart = Integer.parseInt(Bits[1]) - 1;
        int JunctionEnd = Integer.parseInt(Bits[2]);
        int Strand = GFFFile.ParseStrand(Bits[4]);
        if (Strand < 0) {
            Strand = this.ForwardFlag;
        }
        if (Strand != this.ForwardFlag) {
            return -1;
        }
        MS2Exon Exon1 = this.HashExon(JunctionStart - 90, JunctionStart, ChrName, Strand);
        MS2Exon Exon2 = this.HashExon(JunctionEnd, JunctionEnd + 90, ChrName, Strand);
        Exon1.LinkDeletionExonForward(Exon2);
        return 1;
    }

    public int HandleInsertionInfoFileLine(int LineNumber, int FilePos, String LineBuffer, String DesiredSeqName) {
        if ((LineBuffer = LineBuffer.trim()).startsWith("[(")) {
            return -1;
        }
        String[] Bits = LineBuffer.split("\t");
        String ChrName = Bits[0];
        if (ConstructSpliceGraphWithInDel.isInteger(ChrName) || ChrName == "X" || ChrName == "Y") {
            ChrName = "chr" + ChrName;
        }
        int JunctionStart = Integer.parseInt(Bits[1]) - 1;
        String tmpInsertionString = Bits[2];
        int tmpInsertionStringLen = Bits[2].length();
        int Strand = GFFFile.ParseStrand(Bits[4]);
        if (Strand < 0) {
            Strand = this.ForwardFlag;
        }
        if (Strand != this.ForwardFlag) {
            return -1;
        }
        InsertionExon Exon = new InsertionExon(JunctionStart, ChrName, tmpInsertionStringLen, tmpInsertionString, Strand);
        this.AddInsertionExon(JunctionStart, ChrName, tmpInsertionStringLen, tmpInsertionString, Strand);
        return 1;
    }

    public int HandleMutationInfoFileLine(int LineNumber, int FilePos, String LineBuffer, String DesiredSeqName) {
        if ((LineBuffer = LineBuffer.trim()).startsWith("[(")) {
            return -1;
        }
        String[] Bits = LineBuffer.split("\t");
        String ChrName = Bits[0];
        if (ConstructSpliceGraphWithInDel.isInteger(ChrName) || ChrName == "X" || ChrName == "Y") {
            ChrName = "chr" + ChrName;
        }
        int JunctionStart = Integer.parseInt(Bits[1]) - 1;
        int JunctionEnd = Integer.parseInt(Bits[2]);
        String tmpInsertionString = Bits[3];
        int tmpInsertionStringLen = Bits[3].length();
        int Strand = GFFFile.ParseStrand(Bits[4]);
        if (Strand < 0) {
            Strand = this.ForwardFlag;
        }
        if (Strand != this.ForwardFlag) {
            return -1;
        }
        MutationExon Exon = new MutationExon(JunctionStart, JunctionEnd, ChrName, tmpInsertionStringLen, tmpInsertionString, Strand);
        this.AddMutationExon(JunctionStart, JunctionEnd, ChrName, tmpInsertionStringLen, tmpInsertionString, Strand);
        return 1;
    }

    public int HandleVCFFileLine(int LineNumber, int FilePos, String LineBuffer, String DesiredSeqName) {
        if ((LineBuffer = LineBuffer.trim()).startsWith("[(")) {
            return -1;
        }
        String[] Bits = LineBuffer.split("\t");
        String ChrName = Bits[0];
        if (ConstructSpliceGraphWithInDel.isInteger(ChrName) || ChrName == "X" || ChrName == "Y") {
            ChrName = "chr" + ChrName;
        }
        int Strand = this.ForwardFlag;
        return 1;
    }

    public void ParseGFFFiles(String SeqName) {
        BufferedReader Buf = null;
        this.PrevExon = null;
        this.CurrFileName = "";
        int i = 0;
        while (i < this.GFFFiles.length) {
            block11: {
                String Line = null;
                try {
                    Buf = new BufferedReader(new FileReader(this.GFFFiles[i]));
                    Line = Buf.readLine();
                }
                catch (IOException E) {
                    E.printStackTrace();
                    break block11;
                }
                this.CurrFileName = this.GFFFiles[i];
                int LineNumber = 0;
                int FilePos = 0;
                while (Line != null) {
                    if ((Line = Line.trim()).length() == 0 || Line.charAt(0) == '#') {
                        try {
                            Line = Buf.readLine();
                            continue;
                        }
                        catch (IOException E) {
                            E.printStackTrace();
                            break;
                        }
                    }
                    this.HandleGFFFileLine(LineNumber, FilePos, Line, SeqName);
                    ++LineNumber;
                    FilePos += Line.length();
                    try {
                        Line = Buf.readLine();
                    }
                    catch (IOException E) {
                        E.printStackTrace();
                        break;
                    }
                }
                try {
                    Buf.close();
                }
                catch (IOException E) {
                    E.printStackTrace();
                }
            }
            ++i;
        }
    }

    public void ParseSAMInfoFiles(String SeqName) {
        BufferedReader Buf = null;
        this.PrevExon = null;
        this.CurrFileName = "";
        int ParseFlag = -1;
        int i = 0;
        while (i < this.SpliceInfoFiles.length) {
            block28: {
                String Line = null;
                try {
                    Buf = new BufferedReader(new FileReader(this.SpliceInfoFiles[i]));
                    Line = Buf.readLine();
                }
                catch (IOException E) {
                    E.printStackTrace();
                    break block28;
                }
                this.CurrFileName = this.SpliceInfoFiles[i];
                int LineNumber = 0;
                int FilePos = 0;
                while (Line != null) {
                    String[] FileCountBits;
                    String[] Bits = (Line = Line.trim()).split("\t");
                    if (Bits.length > 3 && (FileCountBits = Bits[3].split(",")).length < 2) {
                        try {
                            Line = Buf.readLine();
                            continue;
                        }
                        catch (IOException E) {
                            E.printStackTrace();
                            break;
                        }
                    }
                    if (Line.startsWith("#Splice")) {
                        ParseFlag = 0;
                    } else if (Line.startsWith("#Insertion")) {
                        ParseFlag = 1;
                    } else if (Line.startsWith("#Deletion")) {
                        ParseFlag = 2;
                    } else if (Line.startsWith("#Mutation")) {
                        ParseFlag = 3;
                    }
                    if (ParseFlag == -1) {
                        try {
                            Line = Buf.readLine();
                            continue;
                        }
                        catch (IOException E) {
                            E.printStackTrace();
                            break;
                        }
                    }
                    if (Line.length() == 0 || Line.charAt(0) == '#') {
                        try {
                            Line = Buf.readLine();
                            continue;
                        }
                        catch (IOException E) {
                            E.printStackTrace();
                            break;
                        }
                    }
                    if (ParseFlag == 0) {
                        this.HandleSpliceInfoFileLine(LineNumber, FilePos, Line, SeqName);
                    }
                    if (ParseFlag == 1) {
                        this.HandleInsertionInfoFileLine(LineNumber, FilePos, Line, SeqName);
                    }
                    if (ParseFlag == 2) {
                        this.HandleDeletionInfoFileLine(LineNumber, FilePos, Line, SeqName);
                    }
                    if (ParseFlag == 3) {
                        this.HandleMutationInfoFileLine(LineNumber, FilePos, Line, SeqName);
                    }
                    ++LineNumber;
                    FilePos += Line.length();
                    try {
                        Line = Buf.readLine();
                    }
                    catch (IOException E) {
                        E.printStackTrace();
                        break;
                    }
                }
                try {
                    Buf.close();
                }
                catch (IOException E) {
                    E.printStackTrace();
                }
            }
            ++i;
        }
    }

    public void ParseVCFFiles(String SeqName) {
        BufferedReader Buf = null;
        this.CurrFileName = "";
        int i = 0;
        while (i < this.VCFFiles.length) {
            block11: {
                String Line = null;
                try {
                    Buf = new BufferedReader(new FileReader(this.VCFFiles[i]));
                    Line = Buf.readLine();
                }
                catch (IOException E) {
                    E.printStackTrace();
                    break block11;
                }
                this.CurrFileName = this.VCFFiles[i];
                int LineNumber = 0;
                int FilePos = 0;
                while (Line != null) {
                    if ((Line = Line.trim()).length() == 0 || Line.charAt(0) == '#') {
                        try {
                            Line = Buf.readLine();
                            continue;
                        }
                        catch (IOException E) {
                            E.printStackTrace();
                            break;
                        }
                    }
                    this.HandleVCFFileLine(LineNumber, FilePos, Line, SeqName);
                    FilePos += Line.length();
                    try {
                        Line = Buf.readLine();
                    }
                    catch (IOException E) {
                        E.printStackTrace();
                        break;
                    }
                }
                try {
                    Buf.close();
                }
                catch (IOException E) {
                    E.printStackTrace();
                }
            }
            ++i;
        }
    }

    public void DeleteMS2Exon(MS2Exon Exon) {
        boolean LocalDebug = false;
        String HashValue = this.BuildHashKey(Exon);
        this.ExonHash.remove(HashValue);
        if (Exon == this.FirstExon) {
            if (LocalDebug) {
                System.out.println("This is the first exon!!");
            }
            this.FirstExon = this.FirstExon.Next;
        }
        if (Exon == this.LastExon) {
            if (LocalDebug) {
                System.out.println("This is the last exon!!");
            }
            this.LastExon = this.LastExon.Prev;
        }
        if (Exon.Next != null) {
            Exon.Next.Prev = Exon.Prev;
        }
        if (Exon.Prev != null) {
            Exon.Prev.Next = Exon.Next;
        }
        Exon.Prev = null;
        Exon.Next = null;
        if (LocalDebug) {
            if (Exon.ForwardSpliceIntrons != null) {
                System.out.println("We still have forward exons!!");
            }
            if (Exon.ReverseSpliceIntrons != null) {
                System.out.println("We still have reverse exons!!");
            }
            Utils.WaitForEnter();
        }
        MS2SpliceEdge E = Exon.ForwardSpliceIntrons;
        while (E != null) {
            if (LocalDebug) {
                E.LinkTo.DebugPrint(true);
            }
            E.LinkTo.RemoveBackwardEdge(Exon);
            if (LocalDebug) {
                E.LinkTo.DebugPrint(true);
                Utils.WaitForEnter();
            }
            E = E.Next;
        }
        E = Exon.ReverseSpliceIntrons;
        while (E != null) {
            E.LinkTo.RemoveForwardEdge(Exon);
            E = E.Next;
        }
        Exon.ReverseSpliceIntrons = null;
        Exon.ForwardSpliceIntrons = null;
        --this.ExonCount;
    }

    public void SplitOverlappingExons() {
        boolean LocalDebug = this.Debug;
        MS2Exon ExonA = this.FirstExon;
        MS2Exon NextExonA = null;
        MS2Exon ExonB = null;
        MS2Exon NextExonB = null;
        while (ExonA != null) {
            NextExonA = ExonA.Next;
            ExonB = ExonA.Next;
            while (ExonB != null) {
                MS2Exon Exon3;
                MS2Exon Exon2;
                MS2Exon Exon1;
                NextExonB = ExonB.Next;
                if (ExonA.Strand != ExonB.Strand) {
                    ExonB = ExonB.Next;
                    continue;
                }
                if (!Utils.HasOverlap(ExonA.Start, ExonA.End, ExonB.Start, ExonB.End)) {
                    ExonB = ExonB.Next;
                    continue;
                }
                if (ExonA.SequenceName.compareTo(ExonB.SequenceName) != 0) {
                    ExonB = ExonB.Next;
                    continue;
                }
                if (LocalDebug) {
                    System.out.println("Considering our exon!!!");
                }
                if (LocalDebug) {
                    System.out.println("Split overlapping exons...the following have overlap");
                    ExonA.DebugPrint(true);
                    ExonB.DebugPrint(true);
                    Utils.WaitForEnter();
                }
                if (ExonA.Start == ExonB.Start && ExonA.End == ExonB.End) {
                    ExonA.ExonInheritForwardEdges(ExonB);
                    ExonA.ExonInheritBackwardEdges(ExonB);
                    if (NextExonA.compareTo(ExonB) == 0) {
                        NextExonA = ExonB.Next;
                    }
                    NextExonB = ExonB.Next;
                    this.DeleteMS2Exon(ExonB);
                    ExonB = NextExonB;
                    if (!LocalDebug) continue;
                    System.out.println("No new exon");
                    Utils.WaitForEnter();
                    continue;
                }
                if (ExonA.Start == ExonB.Start) {
                    if (ExonA.End > ExonB.End) {
                        Exon1 = this.HashExon(ExonB.End, ExonA.End, ExonA.SequenceName, ExonA.Strand);
                        Exon1.ExonInheritForwardEdges(ExonA);
                        ExonB.ExonInheritBackwardEdges(ExonA);
                        NextExonA = ExonA.Next;
                        this.DeleteMS2Exon(ExonA);
                        if (!LocalDebug) break;
                        System.out.println("New Exon: ");
                        Exon1.DebugPrint(true);
                        System.out.println("Old Exon: ");
                        ExonB.DebugPrint(true);
                        Utils.WaitForEnter();
                        break;
                    }
                    Exon1 = this.HashExon(ExonA.End, ExonB.End, ExonA.SequenceName, ExonA.Strand);
                    Exon1.ExonInheritForwardEdges(ExonB);
                    ExonA.ExonInheritBackwardEdges(ExonB);
                    NextExonA = ExonA.Next;
                    if (NextExonA.compareTo(ExonB) == 0) {
                        NextExonA = ExonB.Next;
                    }
                    NextExonB = ExonB.Next;
                    this.DeleteMS2Exon(ExonB);
                    ExonB = NextExonB;
                    if (!LocalDebug) continue;
                    System.out.println("New Exon: ");
                    Exon1.DebugPrint(true);
                    System.out.println("Old Exon: ");
                    ExonA.DebugPrint(true);
                    Utils.WaitForEnter();
                    continue;
                }
                if (ExonA.End == ExonB.End) {
                    if (ExonA.Start < ExonB.Start) {
                        Exon1 = this.HashExon(ExonA.Start, ExonB.Start, ExonA.SequenceName, ExonA.Strand);
                        ExonB.ExonInheritForwardEdges(ExonA);
                        Exon1.ExonInheritBackwardEdges(ExonA);
                        NextExonA = ExonA.Next;
                        this.DeleteMS2Exon(ExonA);
                        if (!LocalDebug) break;
                        System.out.println("New Exon: ");
                        Exon1.DebugPrint(true);
                        System.out.println("Old Exon: ");
                        ExonB.DebugPrint(true);
                        Utils.WaitForEnter();
                        break;
                    }
                    Exon1 = this.HashExon(ExonB.Start, ExonA.Start, ExonA.SequenceName, ExonA.Strand);
                    ExonA.ExonInheritForwardEdges(ExonB);
                    Exon1.ExonInheritBackwardEdges(ExonB);
                    NextExonA = ExonA.Next;
                    if (NextExonA.compareTo(ExonB) == 0) {
                        NextExonA = ExonB.Next;
                    }
                    NextExonB = ExonB.Next;
                    this.DeleteMS2Exon(ExonB);
                    ExonB = NextExonB;
                    if (!LocalDebug) continue;
                    System.out.println("New Exon: ");
                    Exon1.DebugPrint(true);
                    System.out.println("Old Exon: ");
                    ExonA.DebugPrint(true);
                    Utils.WaitForEnter();
                    continue;
                }
                if (ExonA.Start < ExonB.Start && ExonA.End < ExonB.End) {
                    Exon1 = this.HashExon(ExonA.Start, ExonB.Start, ExonA.SequenceName, ExonA.Strand);
                    Exon2 = this.HashExon(ExonB.Start, ExonA.End, ExonA.SequenceName, ExonA.Strand);
                    Exon3 = this.HashExon(ExonA.End, ExonB.End, ExonA.SequenceName, ExonA.Strand);
                    Exon1.ExonInheritBackwardEdges(ExonA);
                    Exon2.ExonInheritBackwardEdges(ExonB);
                    Exon2.ExonInheritForwardEdges(ExonA);
                    Exon3.ExonInheritForwardEdges(ExonB);
                    NextExonA = ExonA.Next;
                    if (NextExonA.compareTo(ExonB) == 0) {
                        NextExonA = ExonB.Next;
                    }
                    NextExonB = ExonB.Next;
                    this.DeleteMS2Exon(ExonB);
                    ExonB = NextExonB;
                    this.DeleteMS2Exon(ExonA);
                    if (!LocalDebug) break;
                    System.out.println("New Exons: ");
                    Exon1.DebugPrint(true);
                    Exon2.DebugPrint(true);
                    Exon3.DebugPrint(true);
                    Utils.WaitForEnter();
                    break;
                }
                if (ExonA.Start < ExonB.Start && ExonA.End > ExonB.End) {
                    Exon1 = this.HashExon(ExonA.Start, ExonB.Start, ExonA.SequenceName, ExonA.Strand);
                    Exon2 = this.HashExon(ExonB.End, ExonA.End, ExonA.SequenceName, ExonA.Strand);
                    Exon1.ExonInheritBackwardEdges(ExonA);
                    Exon2.ExonInheritForwardEdges(ExonA);
                    NextExonA = ExonA.Next;
                    this.DeleteMS2Exon(ExonA);
                    if (!LocalDebug) break;
                    System.out.println("New Exons: ");
                    Exon1.DebugPrint(true);
                    Exon2.DebugPrint(true);
                    Utils.WaitForEnter();
                    break;
                }
                if (ExonA.Start > ExonB.Start && ExonA.End > ExonB.End) {
                    Exon1 = this.HashExon(ExonB.Start, ExonA.Start, ExonA.SequenceName, ExonA.Strand);
                    Exon2 = this.HashExon(ExonA.Start, ExonB.End, ExonA.SequenceName, ExonA.Strand);
                    Exon3 = this.HashExon(ExonB.End, ExonA.End, ExonA.SequenceName, ExonA.Strand);
                    Exon1.ExonInheritBackwardEdges(ExonB);
                    Exon2.ExonInheritBackwardEdges(ExonA);
                    Exon2.ExonInheritForwardEdges(ExonB);
                    Exon3.ExonInheritForwardEdges(ExonA);
                    NextExonA = ExonA.Next;
                    if (NextExonA.compareTo(ExonB) == 0) {
                        NextExonA = ExonB.Next;
                    }
                    NextExonB = ExonB.Next;
                    this.DeleteMS2Exon(ExonB);
                    ExonB = NextExonB;
                    this.DeleteMS2Exon(ExonA);
                    if (!LocalDebug) break;
                    System.out.println("New Exons: ");
                    Exon1.DebugPrint(true);
                    Exon2.DebugPrint(true);
                    Exon3.DebugPrint(true);
                    Utils.WaitForEnter();
                    break;
                }
                if (ExonA.Start > ExonB.Start && ExonA.End < ExonB.End) {
                    Exon1 = this.HashExon(ExonB.Start, ExonA.Start, ExonA.SequenceName, ExonA.Strand);
                    Exon2 = this.HashExon(ExonA.End, ExonB.End, ExonA.SequenceName, ExonA.Strand);
                    Exon1.ExonInheritBackwardEdges(ExonB);
                    Exon2.ExonInheritForwardEdges(ExonB);
                    NextExonA = ExonA.Next;
                    if (NextExonA.compareTo(ExonB) == 0) {
                        NextExonA = ExonB.Next;
                    }
                    NextExonB = ExonB.Next;
                    this.DeleteMS2Exon(ExonB);
                    ExonB = NextExonB;
                    if (!LocalDebug) continue;
                    System.out.println("New Exons: ");
                    Exon1.DebugPrint(true);
                    Exon2.DebugPrint(true);
                    Utils.WaitForEnter();
                    continue;
                }
                System.err.println("ERROR: UNHANDLED Split CASE!!!");
            }
            ExonA = NextExonA;
        }
    }

    public void SplitOverlappingInsertions() {
        boolean LocalDebug = this.Debug;
        boolean UpdateFlag = false;
        InsertionExon InsExon = this.FirstInsertionExon;
        while (InsExon != null) {
            MS2Exon Exon1;
            UpdateFlag = false;
            MS2Exon Exon = this.FirstExon;
            while (Exon != null) {
                if (Exon.Strand != InsExon.Strand) {
                    Exon = Exon.Next;
                    continue;
                }
                if (Exon.SequenceName.compareTo(InsExon.ChrString) != 0) {
                    Exon = Exon.Next;
                    continue;
                }
                if (Exon.End < 0) {
                    if (Exon.Start == InsExon.Coordinate) {
                        MS2Exon ExonInsert = this.HashExon(InsExon.Coordinate, -InsExon.InsertionString.length(), Exon.SequenceName, Exon.Strand);
                        ExonInsert.ExonInheritForwardInsertionEdges(Exon);
                        ExonInsert.ExonInheritBackwardInsertionEdges(Exon);
                        ExonInsert.Sequence = InsExon.InsertionString;
                        UpdateFlag = true;
                        break;
                    }
                    UpdateFlag = false;
                    Exon = Exon.Next;
                    continue;
                }
                if (Exon.Start == InsExon.Coordinate || Exon.End == InsExon.Coordinate) {
                    UpdateFlag = true;
                    Exon = Exon.Next;
                    continue;
                }
                if (Exon.Start < InsExon.Coordinate && Exon.End > InsExon.Coordinate) {
                    Exon1 = this.HashExon(Exon.Start, InsExon.Coordinate, Exon.SequenceName, Exon.Strand);
                    Exon1.ExonInheritBackwardEdges(Exon);
                    Exon.Start = InsExon.Coordinate;
                    MS2Exon ExonInsert = this.HashExon(InsExon.Coordinate, -InsExon.InsertionString.length(), Exon.SequenceName, Exon.Strand);
                    ExonInsert.Sequence = InsExon.InsertionString;
                    Exon1.LinkInsertionExonForward(ExonInsert);
                    ExonInsert.LinkInsertionExonForward(Exon);
                    UpdateFlag = true;
                    break;
                }
                Exon = Exon.Next;
            }
            if (!UpdateFlag) {
                Exon1 = this.HashExon(InsExon.Coordinate - 90, InsExon.Coordinate, InsExon.ChrString, InsExon.Strand);
                MS2Exon Exon2 = this.HashExon(InsExon.Coordinate, InsExon.Coordinate + 90, InsExon.ChrString, InsExon.Strand);
                MS2Exon ExonInsert = this.HashExon(InsExon.Coordinate, -InsExon.InsertionString.length(), InsExon.ChrString, InsExon.Strand);
                ExonInsert.Sequence = InsExon.InsertionString;
                Exon1.LinkInsertionExonForward(ExonInsert);
                ExonInsert.LinkInsertionExonForward(Exon2);
            }
            InsExon = InsExon.Next;
        }
    }

    public void SplitOverlappingMutations() {
        boolean LocalDebug = this.Debug;
        boolean UpdateFlag = false;
        MutationExon MuExon = this.FirstMutationExon;
        while (MuExon != null) {
            MS2Exon Exon2;
            MS2Exon Exon1;
            UpdateFlag = false;
            MS2Exon Exon = this.FirstExon;
            while (Exon != null) {
                if (Exon.Strand != MuExon.Strand) {
                    Exon = Exon.Next;
                    continue;
                }
                if (Exon.SequenceName.compareTo(MuExon.ChrString) != 0) {
                    Exon = Exon.Next;
                    continue;
                }
                if (Exon.End < 0) {
                    if (Exon.Start == MuExon.Start && Exon.End == MuExon.End) {
                        MS2Exon ExonMutation = this.HashExon(MuExon.Start, -1000 - MuExon.MutationString.length(), Exon.SequenceName, Exon.Strand);
                        ExonMutation.ExonInheritForwardMutationEdges(Exon);
                        ExonMutation.ExonInheritBackwardMutationEdges(Exon);
                        ExonMutation.Sequence = MuExon.MutationString;
                        UpdateFlag = true;
                        break;
                    }
                    UpdateFlag = false;
                    Exon = Exon.Next;
                    continue;
                }
                if (Exon.Start < MuExon.Start && Exon.End > MuExon.End) {
                    Exon1 = this.HashExon(Exon.Start, MuExon.Start, Exon.SequenceName, Exon.Strand);
                    Exon1.ExonInheritBackwardEdges(Exon);
                    Exon2 = this.HashExon(MuExon.Start, MuExon.End, Exon.SequenceName, Exon.Strand);
                    Exon.Start = MuExon.End;
                    MS2Exon ExonMutation = this.HashExon(MuExon.Start, -1000 - MuExon.MutationString.length(), Exon.SequenceName, Exon.Strand);
                    ExonMutation.Sequence = MuExon.MutationString;
                    Exon1.LinkMutationExonForward(ExonMutation);
                    ExonMutation.LinkMutationExonForward(Exon);
                    UpdateFlag = true;
                    break;
                }
                Exon = Exon.Next;
            }
            if (!UpdateFlag) {
                Exon1 = this.HashExon(MuExon.Start - 90, MuExon.Start, MuExon.ChrString, MuExon.Strand);
                Exon2 = this.HashExon(MuExon.End, MuExon.End + 90, MuExon.ChrString, MuExon.Strand);
                MS2Exon ExonInsert = this.HashExon(MuExon.Start, -1000 - MuExon.MutationString.length(), MuExon.ChrString, MuExon.Strand);
                ExonInsert.Sequence = MuExon.MutationString;
                Exon1.LinkMutationExonForward(ExonInsert);
                ExonInsert.LinkMutationExonForward(Exon2);
            }
            MuExon = MuExon.Next;
        }
    }

    public void AddAdjacentExonLinks() {
        boolean debug = false;
        ArrayList candidateLinkToExons = new ArrayList();
        MS2Exon ExonA = this.FirstExon;
        while (ExonA != null) {
            candidateLinkToExons.clear();
            if (debug) {
                System.out.println("This is our main guy!");
                ExonA.DebugPrint(true);
            }
            MS2Exon ExonB = this.FirstExon;
            while (ExonB != null) {
                if (ExonB.End >= 0) {
                    if (debug) {
                        System.out.println("This is our candidate guy!");
                        ExonB.DebugPrint(true);
                    }
                    if (ExonA.Strand == ExonB.Strand && ExonA.SequenceName.compareTo(ExonB.SequenceName) == 0) {
                        MS2SpliceEdge TestEdge;
                        boolean LinkFound;
                        int delta = ExonB.Start - ExonA.End;
                        if (delta == 0) {
                            if (debug) {
                                System.out.println(" - They are adjacent!!");
                            }
                            LinkFound = false;
                            TestEdge = ExonA.ForwardSpliceIntrons;
                            while (TestEdge != null) {
                                if (TestEdge.LinkTo == ExonB) {
                                    LinkFound = true;
                                    break;
                                }
                                TestEdge = TestEdge.Next;
                            }
                            if (!LinkFound) {
                                ExonA.LinkExonForward(ExonB);
                            }
                        } else if (this.minIntronLen >= 0 && delta >= this.minIntronLen && delta <= this.maxIntronLen) {
                            if (debug) {
                                System.out.println(" - They are close: " + delta);
                            }
                            LinkFound = false;
                            TestEdge = ExonA.ForwardSpliceIntrons;
                            while (TestEdge != null) {
                                if (TestEdge.LinkTo == ExonB) {
                                    LinkFound = true;
                                    break;
                                }
                                TestEdge = TestEdge.Next;
                            }
                            if (!LinkFound) {
                                if (debug) {
                                    System.out.println(" - No previous link found!");
                                }
                                candidateLinkToExons = Utils.InsertInOrder(candidateLinkToExons, ExonB);
                            } else if (debug) {
                                System.out.println(" - Previous link is found!");
                            }
                            while (candidateLinkToExons.size() > this.maxOutEdgesAdded) {
                                candidateLinkToExons.remove(candidateLinkToExons.size() - 1);
                            }
                        } else if (debug) {
                            System.out.println(" - Out of range: " + delta);
                        }
                    } else if (debug) {
                        System.out.println(" - Not compatible!");
                    }
                }
                ExonB = ExonB.Next;
            }
            if (candidateLinkToExons.size() > 0) {
                int i = 0;
                while (i < candidateLinkToExons.size()) {
                    MS2Exon ExonB2 = (MS2Exon)candidateLinkToExons.get(i);
                    if (debug) {
                        System.out.println("Adding link " + i);
                        ExonB2.DebugPrint(true);
                    }
                    ExonA.LinkExonForward(ExonB2);
                    ++i;
                }
            }
            if (debug) {
                Utils.WaitForEnter();
            }
            ExonA = ExonA.Next;
        }
    }

    public void CombineExtendsExon() {
        boolean debug = false;
        MS2Exon ExonA = this.FirstExon;
        while (ExonA != null) {
            MS2Exon ExonB = this.FirstExon;
            while (ExonB != null) {
                if (ExonA.Strand == ExonB.Strand && ExonA.SequenceName.compareTo(ExonB.SequenceName) == 0 && ExonB.Start - ExonA.End == 0 && ExonA.ForwardSpliceIntrons == null && ExonB.ReverseSpliceIntrons == null && ExonA.ForwardDeletionIntrons == null && ExonB.ReverseDeletionIntrons == null && ExonA.ForwardInsertionIntrons == null && ExonB.ReverseInsertionIntrons == null && ExonA.ForwardMutationIntrons == null && ExonB.ReverseMutationIntrons == null) {
                    ExonA.End = ExonB.End;
                    ExonA.ExonInheritForwardEdges(ExonB);
                    if (ExonA.Next != null && ExonB.Next != null && ExonA.Next.compareTo(ExonB) == 0) {
                        ExonA.Next = ExonB.Next;
                    }
                    this.DeleteMS2Exon(ExonB);
                    break;
                }
                ExonB = ExonB.Next;
            }
            ExonA = ExonA.Next;
        }
    }

    public void GroupExonsIntoGenes() {
        boolean LocalDebug = false;
        MS2Exon Exon = this.FirstExon;
        while (Exon != null) {
            if (LocalDebug) {
                System.out.println("Attempting to group:");
                Exon.DebugPrint(true);
                Utils.WaitForEnter();
            }
            if (Exon.ParentGene == null) {
                MS2Gene Gene = new MS2Gene();
                Gene.SequenceName = Exon.SequenceName;
                if (Gene.SequenceName != null) {
                    Gene.GeneName = String.valueOf(Gene.SequenceName) + "@" + this.GeneIndex;
                }
                ArrayList<MS2Exon> exonQueue = new ArrayList<MS2Exon>();
                exonQueue.add(Exon);
                while (exonQueue.size() > 0) {
                    MS2Exon e = (MS2Exon)exonQueue.remove(0);
                    if (e.ParentGene != null) continue;
                    Gene.AddSingleExonToGene(e);
                    Object Edge = e.ForwardSpliceIntrons;
                    while (Edge != null) {
                        exonQueue.add(((MS2SpliceEdge)Edge).LinkTo);
                        Edge = ((MS2SpliceEdge)Edge).Next;
                    }
                    Edge = e.ReverseSpliceIntrons;
                    while (Edge != null) {
                        exonQueue.add(((MS2SpliceEdge)Edge).LinkTo);
                        Edge = ((MS2SpliceEdge)Edge).Next;
                    }
                    Edge = e.ForwardDeletionIntrons;
                    while (Edge != null) {
                        exonQueue.add(((MS2DeletionEdge)Edge).LinkTo);
                        Edge = ((MS2DeletionEdge)Edge).Next;
                    }
                    Edge = e.ReverseDeletionIntrons;
                    while (Edge != null) {
                        exonQueue.add(((MS2DeletionEdge)Edge).LinkTo);
                        Edge = ((MS2DeletionEdge)Edge).Next;
                    }
                    Edge = e.ForwardInsertionIntrons;
                    while (Edge != null) {
                        exonQueue.add(((MS2InsertionEdge)Edge).LinkTo);
                        Edge = ((MS2InsertionEdge)Edge).Next;
                    }
                    Edge = e.ReverseInsertionIntrons;
                    while (Edge != null) {
                        exonQueue.add(((MS2InsertionEdge)Edge).LinkTo);
                        Edge = ((MS2InsertionEdge)Edge).Next;
                    }
                }
                if (this.Debug) {
                    System.out.println("Created a new gene!");
                    Gene.DebugPrint(true);
                    Utils.WaitForEnter();
                }
                if (this.FirstMS2Gene == null) {
                    this.FirstMS2Gene = Gene;
                } else {
                    this.LastMS2Gene.Next = Gene;
                }
                this.LastMS2Gene = Gene;
                ++this.GeneCount;
                ++this.GeneIndex;
            }
            Exon = Exon.Next;
        }
    }

    public static String GetSequenceNameFromGene(String GeneName) {
        return GeneName.split("@")[0];
    }

    public void ReadExonSequence(MS2Exon Exon) {
        boolean LocalDebug = false;
        String FullSeq = null;
        if (!this.HashedSequences.containsKey(Exon.SequenceName) && this.Trie.getNumProteins() > 1) {
            int SequenceID = this.Trie.getProteinID(Exon.SequenceName);
            if (SequenceID < 0) {
                ErrorThrower.ThrowError(15, String.valueOf(SequenceID));
            }
            FullSeq = this.Trie.getProteinSequence(SequenceID);
            this.HashedSequences.put(Exon.SequenceName, FullSeq);
        }
        String ExonSeq = null;
        if (this.Trie.getNumProteins() == 1) {
            if (Exon.End < 0) {
                return;
            }
            FullSeq = this.Trie.GetProteinSubstring(0, Exon.Start, Exon.End);
            ExonSeq = Utils.CleanUpPeptideString(FullSeq);
        } else {
            if (Exon.End < 0) {
                return;
            }
            FullSeq = (String)this.HashedSequences.get(Exon.SequenceName);
            ExonSeq = Utils.CleanUpPeptideString(FullSeq.substring(Exon.Start, Exon.End));
        }
        if (ExonSeq == null) {
            System.out.println("EXON SEQ IS NULL, WTF!!");
            Exon.DebugPrint(true);
            Utils.WaitForEnter();
        }
        if (Exon.Strand != 1) {
            ExonSeq = Utils.ReverseComplement(ExonSeq);
        }
        if (Exon.Sequence == null) {
            Exon.Sequence = ExonSeq;
        }
    }

    public void OutputMS2Exon(MS2Gene Gene, MS2Exon Exon) throws IOException {
        if (this.OutputFile == null) {
            return;
        }
        String ExonSeq = Utils.CleanUpPeptideString(Exon.Sequence);
        this.OutputFile.write("  <Exon Index=\"" + Exon.Index + "\" Start=\"" + Exon.Start + "\" End=\"" + Exon.End + "\">\n");
        if (Exon.Sequence != null) {
            this.OutputFile.write("    <ExonSequence Length=\"" + ExonSeq.length() + "\">" + ExonSeq + "</ExonSequence>\n");
        } else {
            this.OutputFile.write("    <ExonSequence Length=\"0\"></ExonSequence>\n");
        }
        MS2SpliceEdge Edge = null;
        Edge = Gene.ForwardFlag == 1 ? Exon.ReverseSpliceIntrons : Exon.ForwardSpliceIntrons;
        while (Edge != null) {
            MS2Exon LinkExon = Edge.LinkTo;
            if (LinkExon.Start == Exon.End || LinkExon.End == Exon.Start) {
                this.OutputFile.write("    <ExtendsExon");
            } else {
                this.OutputFile.write("    <LinkFrom");
            }
            this.OutputFile.write(" Index=\"" + LinkExon.Index + "\"");
            this.OutputFile.write("/>\n");
            Edge = Edge.Next;
        }
        MS2DeletionEdge DeletionEdge = null;
        DeletionEdge = Gene.ForwardFlag == 1 ? Exon.ReverseDeletionIntrons : Exon.ForwardDeletionIntrons;
        while (DeletionEdge != null) {
            MS2Exon LinkExon = DeletionEdge.LinkTo;
            this.OutputFile.write("    <LinkFromDeletion");
            this.OutputFile.write(" Index=\"" + LinkExon.Index + "\"");
            this.OutputFile.write("/>\n");
            DeletionEdge = DeletionEdge.Next;
        }
        MS2InsertionEdge InsertionEdge = null;
        InsertionEdge = Gene.ForwardFlag == 1 ? Exon.ReverseInsertionIntrons : Exon.ForwardInsertionIntrons;
        while (InsertionEdge != null) {
            MS2Exon LinkExon = InsertionEdge.LinkTo;
            this.OutputFile.write("    <LinkFromInsertion");
            this.OutputFile.write(" Index=\"" + LinkExon.Index + "\"");
            this.OutputFile.write("/>\n");
            InsertionEdge = InsertionEdge.Next;
        }
        this.OutputFile.write("  </Exon>\n");
    }

    public void SortMS2GeneExons(MS2Gene Gene) {
        if (Gene.ForwardFlag == 1) {
            this.SortMS2GeneExonsForward(Gene);
        } else {
            this.SortMS2GeneExonsReverse(Gene);
        }
    }

    private void SortMS2GeneExonsForward(MS2Gene Gene) {
        if (this.Debug) {
            System.out.println("Sorting exons for Gene: " + Gene.GeneName);
            Utils.WaitForEnter();
        }
        int ExonCount = Gene.Exons.size();
        if (this.Debug) {
            System.out.println("has " + ExonCount + " exons");
        }
        int i = 0;
        while (i < ExonCount) {
            int MinIndex = i;
            MS2Exon MinExon = (MS2Exon)Gene.Exons.get(i);
            int j = i + 1;
            while (j < ExonCount) {
                MS2Exon CurrExon = (MS2Exon)Gene.Exons.get(j);
                if (CurrExon.compareTo(MinExon) < 0) {
                    MinExon = CurrExon;
                    MinIndex = j;
                }
                ++j;
            }
            if (MinIndex != i) {
                Object Temp = Gene.Exons.get(i);
                MinExon.Index = i;
                Gene.Exons.set(i, MinExon);
                Gene.Exons.set(MinIndex, Temp);
            } else {
                MinExon.Index = i;
            }
            if (this.Debug) {
                System.out.println("Min Exon: ");
                MinExon.DebugPrint(true);
                Utils.WaitForEnter();
            }
            ++i;
        }
    }

    private void SortMS2GeneExonsReverse(MS2Gene Gene) {
        if (this.Debug) {
            System.out.println("Sorting(reverse) exons for Gene: " + Gene.GeneName);
            Utils.WaitForEnter();
        }
        int ExonCount = Gene.Exons.size();
        int i = 0;
        while (i < ExonCount) {
            int MaxIndex = i;
            MS2Exon MaxExon = (MS2Exon)Gene.Exons.get(i);
            int j = i + 1;
            while (j < ExonCount) {
                MS2Exon CurrExon = (MS2Exon)Gene.Exons.get(j);
                if (CurrExon.compareTo(MaxExon) > 0) {
                    MaxExon = CurrExon;
                    MaxIndex = j;
                }
                ++j;
            }
            if (MaxIndex != i) {
                Object Temp = Gene.Exons.get(i);
                MaxExon.Index = i;
                Gene.Exons.set(i, MaxExon);
                Gene.Exons.set(MaxIndex, Temp);
            } else {
                MaxExon.Index = i;
            }
            ++i;
        }
    }

    public void OutputMS2Gene(MS2Gene Gene) throws IOException {
        if (this.OutputFile == null) {
            return;
        }
        int ExonCount = Gene.Exons.size();
        this.OutputFile.write("<Gene Name=\"" + Gene.GeneName + "\" ExonCount=\"" + ExonCount + "\" Chromosome=\"" + Gene.SequenceName + "\" ForwardFlag=\"" + Gene.ForwardFlag + "\">\n");
        if (this.Debug) {
            System.out.print("<Gene ExonCount=\"" + ExonCount + "\" Chromosome\"" + Gene.SequenceName + "\" ForwardFlag=\"" + Gene.ForwardFlag + "\">\n");
        }
        int i = 0;
        while (i < ExonCount) {
            int j = 0;
            while (j < ExonCount) {
                MS2Exon CurrExon = (MS2Exon)Gene.Exons.get(j);
                if (CurrExon.Index == i) {
                    this.OutputMS2Exon(Gene, CurrExon);
                    break;
                }
                ++j;
            }
            ++i;
        }
        this.OutputFile.write("</Gene>\n\n");
        this.OutputFile.flush();
        if (this.Debug) {
            System.out.print("</Gene>\n\n");
            Utils.WaitForEnter();
        }
    }

    public static int GetCodonHashValue(String Codon) {
        int[] Multiplier = new int[]{1, 4, 16};
        int Value = 0;
        int i = 0;
        while (i < Codon.length()) {
            switch (Codon.charAt(i)) {
                case 'A': 
                case 'a': {
                    Value += 0 * Multiplier[i];
                    break;
                }
                case 'C': 
                case 'c': {
                    Value += 1 * Multiplier[i];
                    break;
                }
                case 'G': 
                case 'g': {
                    Value += 2 * Multiplier[i];
                    break;
                }
                case 'T': 
                case 't': {
                    Value += 3 * Multiplier[i];
                    break;
                }
                default: {
                    System.err.println("ERROR: Unidentified nucleotide '" + Codon.charAt(i) + "'");
                    return 0;
                }
            }
            ++i;
        }
        return Value;
    }

    public void Build(int ForwardFlag) {
        if (this.TrieFile == null) {
            return;
        }
        if (this.Trie == null) {
            this.Trie = new TrieDB(this.TrieFile);
        }
        if (this.GFFFiles == null) {
            return;
        }
        if (this.OutputFileName == null) {
            return;
        }
        this.ForwardFlag = ForwardFlag;
        if (this.OutputFile == null) {
            return;
        }
        this.ExonHash = new Hashtable();
        if (this.Debug) {
            System.out.println("Parsing GFF File Lines...");
        }
        this.ParseGFFFiles(null);
        if (this.FirstExon == null) {
            if (ForwardFlag == 0) {
                System.err.println("WARNING: Unable to build any exons on reverse strand!!!");
            } else {
                System.err.println("WARNING: Unable to build any exons on forward strand!!!");
            }
            return;
        }
        System.out.println("Finished parsing GFF files, created " + this.ExonCount + " exons");
        if (this.Debug) {
            this.DebugPrintBuilder();
            Utils.WaitForEnter();
        }
        System.out.println("Splitting Overlapping Exons...");
        this.SplitOverlappingExons();
        System.out.println("Combine Extend Exon...");
        this.CombineExtendsExon();
        System.out.println("Reading Exon Sequence...");
        MS2Exon Exon = this.FirstExon;
        while (Exon != null) {
            this.ReadExonSequence(Exon);
            Exon = Exon.Next;
        }
        System.out.println("Adding Adjacent Links...");
        this.AddAdjacentExonLinks();
        System.out.println("Grouping Exons...");
        this.GroupExonsIntoGenes();
        if (this.FirstMS2Gene == null) {
            System.out.println("SHIT NO GENES!!");
            Utils.WaitForEnter();
        }
        System.out.println("Sorting genes...");
        MS2Gene Gene = this.FirstMS2Gene;
        while (Gene != null) {
            this.SortMS2GeneExons(Gene);
            Gene = Gene.Next;
        }
        Gene = this.FirstMS2Gene;
        while (Gene != null) {
            try {
                this.OutputMS2Gene(Gene);
            }
            catch (IOException E) {
                E.printStackTrace();
                return;
            }
            Gene = Gene.Next;
        }
        System.out.println("Total Genes: " + this.GeneCount);
        System.out.println("Total Exons: " + this.ExonCount);
        this.ClearBuilder();
    }

    public void Update(int ForwardFlag) {
        if (this.TrieFile == null) {
            return;
        }
        if (this.Trie == null) {
            this.Trie = new TrieDB(this.TrieFile);
        }
        if (this.GFFFiles == null) {
            return;
        }
        if (this.OutputFileName == null) {
            return;
        }
        this.ForwardFlag = ForwardFlag;
        if (this.OutputFile == null) {
            return;
        }
        this.ExonHash = new Hashtable();
        System.out.println("Parsing MS2DB File...");
        ParseSpliceGraph Updater = new ParseSpliceGraph(this.UpdateMS2DBFile);
        Updater.ParseBuildMS2DB(this, ForwardFlag, this.ExonHash);
        Updater = null;
        System.out.println("Parsing GFF File Lines...");
        this.ParseGFFFiles(null);
        if (this.FirstExon == null) {
            if (ForwardFlag == 0) {
                System.err.println("WARNING: Unable to build any exons on reverse strand!!!");
            } else {
                System.err.println("WARNING: Unable to build any exons on forward strand!!!");
            }
            return;
        }
        System.out.println("Finished parsing GFF files, created " + this.ExonCount + " exons");
        System.out.println("Splitting Overlapping Exons...");
        this.SplitOverlappingExons();
        System.out.println("Combine Extend Exon...");
        this.CombineExtendsExon();
        System.out.println("Reading Exon Sequence...");
        MS2Exon Exon = this.FirstExon;
        while (Exon != null) {
            this.ReadExonSequence(Exon);
            Exon = Exon.Next;
        }
        System.out.println("Adding Adjacent Links...");
        this.AddAdjacentExonLinks();
        System.out.println("Grouping Exons...");
        this.GroupExonsIntoGenes();
        if (this.FirstMS2Gene == null) {
            System.out.println("SHIT NO GENES!!");
            Utils.WaitForEnter();
        }
        System.out.println("Sorting genes...");
        MS2Gene Gene = this.FirstMS2Gene;
        while (Gene != null) {
            this.SortMS2GeneExons(Gene);
            Gene = Gene.Next;
        }
        Gene = this.FirstMS2Gene;
        while (Gene != null) {
            try {
                this.OutputMS2Gene(Gene);
            }
            catch (IOException E) {
                E.printStackTrace();
                return;
            }
            Gene = Gene.Next;
        }
        System.out.println("Total Genes: " + this.GeneCount);
        System.out.println("Total Exons: " + this.ExonCount);
        this.ClearBuilder();
    }

    public void BuildSpliceAndInDel(int ForwardFlag) {
        if (this.TrieFile == null) {
            return;
        }
        if (this.Trie == null) {
            this.Trie = new TrieDB(this.TrieFile);
        }
        if (this.OutputFileName == null) {
            return;
        }
        this.ForwardFlag = ForwardFlag;
        if (this.OutputFile == null) {
            return;
        }
        this.ExonHash = new Hashtable();
        System.out.println("Parsing SAM Info File Lines...");
        this.ParseSAMInfoFiles(null);
        if (this.FirstExon == null) {
            if (ForwardFlag == 0) {
                System.err.println("WARNING: Unable to build any exons on reverse strand!!!");
            } else {
                System.err.println("WARNING: Unable to build any exons on forward strand!!!");
            }
            return;
        }
        System.out.println("Finished parsing SAM Info files, created " + this.ExonCount + " exons");
        System.out.println("Splitting Overlapping Exons...");
        this.SplitOverlappingExons();
        System.out.println("Combine Extend Exon...");
        this.CombineExtendsExon();
        System.out.println("Splitting Overlapping Insertions...");
        this.SplitOverlappingInsertions();
        System.out.println("Reading Exon Sequence...");
        MS2Exon Exon = this.FirstExon;
        while (Exon != null) {
            this.ReadExonSequence(Exon);
            Exon = Exon.Next;
        }
        System.out.println("Adding Adjacent Links...");
        this.AddAdjacentExonLinks();
        System.out.println("Grouping Exons...");
        this.GroupExonsIntoGenes();
        if (this.FirstMS2Gene == null) {
            System.out.println("SHIT NO GENES!!");
            Utils.WaitForEnter();
        }
        System.out.println("Sorting genes...");
        MS2Gene Gene = this.FirstMS2Gene;
        while (Gene != null) {
            this.SortMS2GeneExons(Gene);
            Gene = Gene.Next;
        }
        Gene = this.FirstMS2Gene;
        while (Gene != null) {
            try {
                this.OutputMS2Gene(Gene);
            }
            catch (IOException E) {
                E.printStackTrace();
                return;
            }
            Gene = Gene.Next;
        }
        System.out.println("Total Genes: " + this.GeneCount);
        System.out.println("Total Exons: " + this.ExonCount);
        this.ClearBuilder();
    }

    public void ClearBuilder() {
        this.ExonHash.clear();
        this.FirstExon = null;
        this.LastExon = null;
        this.FirstMS2Gene = null;
        this.LastMS2Gene = null;
        this.ExonCount = 0;
        this.GeneCount = 0;
    }

    public void ClearUpdateBuilder() {
        this.FirstExon = null;
        this.LastExon = null;
        this.FirstMS2Gene = null;
        this.LastMS2Gene = null;
        this.ExonCount = 0;
        this.GeneCount = 0;
    }

    public ConstructSpliceGraphWithInDel(String TrieFile, String[] GFFFiles, String OutputName) {
        String ext = Utils.GetFileExtension(TrieFile);
        if (ext.compareTo(".trie") == 0) {
            this.TrieFile = TrieFile;
            this.Trie = new TrieDB(this.TrieFile);
        } else {
            String tFile = String.valueOf(Utils.GetFileNameNoExtension(TrieFile)) + ".trie";
            String[] names = TrieDB.prepDB(TrieFile, tFile);
            System.out.println("Prepping the db");
            this.TrieFile = names[0];
            System.out.println("Produced trie file " + this.TrieFile);
            this.Trie = new TrieDB(this.TrieFile);
        }
        this.GFFFiles = GFFFiles;
        this.OutputFileName = OutputName;
        this.HashedSequences = new Hashtable();
        try {
            this.OutputFile = new FileWriter(OutputName);
            this.OutputFile.write("<Database CreatedBy=\"BuildMS2DB.java\">\n");
        }
        catch (IOException E) {
            E.printStackTrace();
            System.exit(0);
        }
    }

    public ConstructSpliceGraphWithInDel(String TrieFile, String[] SpliceInfoFiles, String OutputName, int splice_info_file_flag) {
        String ext = Utils.GetFileExtension(TrieFile);
        if (ext.compareTo(".trie") == 0) {
            this.TrieFile = TrieFile;
            this.Trie = new TrieDB(this.TrieFile);
        } else {
            String tFile = String.valueOf(Utils.GetFileNameNoExtension(TrieFile)) + ".trie";
            String[] names = TrieDB.prepDB(TrieFile, tFile);
            System.out.println("Prepping the db");
            this.TrieFile = names[0];
            System.out.println("Produced trie file " + this.TrieFile);
            this.Trie = new TrieDB(this.TrieFile);
        }
        this.SpliceInfoFiles = SpliceInfoFiles;
        this.OutputFileName = OutputName;
        this.HashedSequences = new Hashtable();
        try {
            this.OutputFile = new FileWriter(OutputName);
            this.OutputFile.write("<Database CreatedBy=\"BuildMS2DB.java\">\n");
        }
        catch (IOException E) {
            E.printStackTrace();
            System.exit(0);
        }
    }

    public ConstructSpliceGraphWithInDel(String TrieFile, String[] SpliceInfoFiles, String[] VCFFiles, String OutputName, int splice_info_file_flag) {
        String ext = Utils.GetFileExtension(TrieFile);
        if (ext.compareTo(".trie") == 0) {
            this.TrieFile = TrieFile;
            this.Trie = new TrieDB(this.TrieFile);
        } else {
            String tFile = String.valueOf(Utils.GetFileNameNoExtension(TrieFile)) + ".trie";
            String[] names = TrieDB.prepDB(TrieFile, tFile);
            System.out.println("Prepping the db");
            this.TrieFile = names[0];
            System.out.println("Produced trie file " + this.TrieFile);
            this.Trie = new TrieDB(this.TrieFile);
        }
        this.SpliceInfoFiles = SpliceInfoFiles;
        this.VCFFiles = VCFFiles;
        this.OutputFileName = OutputName;
        this.HashedSequences = new Hashtable();
        try {
            this.OutputFile = new FileWriter(OutputName);
            this.OutputFile.write("<Database CreatedBy=\"BuildMS2DB.java\">\n");
        }
        catch (IOException E) {
            E.printStackTrace();
            System.exit(0);
        }
    }

    public void DebugPrintBuilder() {
        block4: {
            block3: {
                System.out.println("=======Builder========");
                System.out.println("SeqFile: " + this.TrieFile);
                System.out.println("OutputFile: " + this.OutputFileName);
                int i = 0;
                while (i < this.GFFFiles.length) {
                    System.out.println("GFFFile[" + i + "]: " + this.GFFFiles[i]);
                    ++i;
                }
                System.out.println("NumExons: " + this.ExonCount);
                System.out.println("ForwardFlag: " + this.ForwardFlag);
                System.out.println("GeneCount: " + this.GeneCount);
                if (this.FirstMS2Gene == null) break block3;
                MS2Gene Gene = this.FirstMS2Gene;
                while (Gene != null) {
                    Gene.DebugPrint(true);
                    Utils.WaitForEnter();
                    Gene = Gene.Next;
                }
                break block4;
            }
            if (this.FirstExon == null) break block4;
            System.out.println("NO GENES, PRINTING BY EXON");
            MS2Exon Exon = this.FirstExon;
            while (Exon != null) {
                Exon.DebugPrint(true);
                Exon = Exon.Next;
            }
        }
    }

    public void DestroyBuilder() {
        try {
            this.OutputFile.write("\n</Database>\n");
            this.OutputFile.close();
        }
        catch (IOException E) {
            E.printStackTrace();
            System.exit(0);
        }
    }

    public ConstructSpliceGraphWithInDel() {
    }

    public MS2Gene NewMS2Gene() {
        return new MS2Gene();
    }

    public MS2Exon NewMS2Exon(int Start, int End, String SeqName, int Strand) {
        return new MS2Exon(Start, End, SeqName, Strand);
    }

    public static void main(String[] args) {
        ConstructSpliceGraphWithInDel Builder2;
        String[] options = new String[]{"-r", "-s", "-w", "-t", "-f", "-g", "-m", "-c", "-u", "-p", "-v"};
        boolean[] blArray = new boolean[12];
        blArray[0] = true;
        blArray[1] = true;
        blArray[2] = true;
        blArray[4] = true;
        blArray[6] = true;
        blArray[7] = true;
        blArray[8] = true;
        blArray[9] = true;
        blArray[10] = true;
        blArray[11] = true;
        boolean[] values = blArray;
        Hashtable Options = Utils.ParseCommandLineMulti(args, options, values);
        if (!(Options.containsKey("-r") || Options.containsKey("-p") || Options.containsKey("-j"))) {
            System.err.println("ERROR: Must specify at least 1 gff file");
            System.out.println(UsageInfo);
            Utils.printGeneticCodeOptions();
            return;
        }
        if (!Options.containsKey("-s")) {
            System.err.println("ERROR: Must specify a FASTA or trie formated sequence file");
            System.out.println(UsageInfo);
            Utils.printGeneticCodeOptions();
            return;
        }
        if (!Options.containsKey("-w")) {
            System.err.println("ERROR: Must specify an output ms2db file");
            System.out.println(UsageInfo);
            Utils.printGeneticCodeOptions();
            return;
        }
        ArrayList Temp = (ArrayList)Options.get("-s");
        if (Temp.size() > 1) {
            System.err.println("ERROR: Number of reference sequence file(trie) is only one for chromosome");
            System.out.println(UsageInfo);
            return;
        }
        String TrieDB2 = (String)Temp.get(0);
        Temp = (ArrayList)Options.get("-w");
        String OutputFileName = (String)Temp.get(0);
        if (Options.containsKey("-r")) {
            Temp = (ArrayList)Options.get("-r");
            String[] GFFFiles = Utils.ConvertArraylistToStringArray(Temp);
            Builder2 = new ConstructSpliceGraphWithInDel(TrieDB2, GFFFiles, OutputFileName);
        } else {
            Temp = (ArrayList)Options.get("-p");
            String[] tmpSpliceInfoFiles = Utils.ConvertArraylistToStringArray(Temp);
            if (Options.containsKey("-v")) {
                Temp = (ArrayList)Options.get("-v");
                String[] tmpVCFFiles = Utils.ConvertArraylistToStringArray(Temp);
                Builder2 = new ConstructSpliceGraphWithInDel(TrieDB2, tmpSpliceInfoFiles, tmpVCFFiles, OutputFileName, 1);
            } else {
                Builder2 = new ConstructSpliceGraphWithInDel(TrieDB2, tmpSpliceInfoFiles, OutputFileName, 1);
            }
        }
        if (Options.containsKey("-c")) {
            Temp = (ArrayList)Options.get("-c");
            Builder2.codonTable = Integer.parseInt((String)Temp.get(0));
            if (Builder2.codonTable < 0 || Builder2.codonTable >= Utils.dnaCodeNames.length) {
                System.err.println("ERROR: Invalid codon table number '" + Builder2.codonTable + "'");
                System.out.println(UsageInfo);
                Utils.printGeneticCodeOptions();
                return;
            }
        }
        if (Options.containsKey("-t")) {
            Temp = (ArrayList)Options.get("-t");
            Builder2.intervalTypes = Utils.ConvertArraylistToStringArray(Temp);
        } else {
            Builder2.intervalTypes = new String[2];
            Builder2.intervalTypes[0] = "CDS";
            Builder2.intervalTypes[1] = "match";
        }
        if (Options.containsKey("-f")) {
            Builder2.ReadPhase = true;
        }
        if (Options.containsKey("-g")) {
            Temp = (ArrayList)Options.get("-g");
            String[] interval = ((String)Temp.get(0)).split("-");
            Builder2.minIntronLen = Integer.parseInt(interval[0]);
            Builder2.maxIntronLen = Integer.parseInt(interval[1]);
            if (Builder2.minIntronLen <= 0 || Builder2.maxIntronLen < Builder2.minIntronLen) {
                System.err.println("ERROR: Invalid intron length range [" + Builder2.minIntronLen + " - " + Builder2.maxIntronLen + "]!");
                return;
            }
            if (Options.containsKey("-m")) {
                Temp = (ArrayList)Options.get("-m");
                String val = (String)Temp.get(0);
                Builder2.maxOutEdgesAdded = Integer.parseInt(val);
                if (Builder2.maxOutEdgesAdded <= 0) {
                    System.err.println("ERROR: Invalid max introns per gene '" + Builder2.maxOutEdgesAdded + "'!");
                    return;
                }
            }
        }
        if (Options.containsKey("-u")) {
            String UpdateFileName;
            Temp = (ArrayList)Options.get("-u");
            Builder2.UpdateMS2DBFile = UpdateFileName = (String)Temp.get(0);
            Builder2.Update(0);
            Builder2.Update(1);
            Builder2.DestroyBuilder();
            return;
        }
        Builder2.printParams();
        Builder2.BuildSpliceAndInDel(0);
        Builder2.BuildSpliceAndInDel(1);
        Builder2.DestroyBuilder();
    }

    public class InsertionExon {
        public int Coordinate;
        public int InsertionLen;
        public String InsertionString;
        public String ChrString;
        public int Strand;
        public InsertionExon Next;

        public InsertionExon(int Coordinate, String ChrString, int InsertionLen, String InsertionString, int Strand) {
            this.Coordinate = Coordinate;
            this.InsertionLen = InsertionLen;
            this.InsertionString = InsertionString;
            this.ChrString = ChrString;
            this.Strand = Strand;
        }
    }

    public class MS2DeletionEdge {
        public MS2Exon LinkTo;
        public MS2Exon LinkFrom;
        public MS2DeletionEdge Next;

        public MS2DeletionEdge(MS2Exon Prev, MS2Exon Next) {
            this.LinkFrom = Prev;
            this.LinkTo = Next;
        }
    }

    public class MS2Exon
    implements Comparable {
        public int Start;
        public int End;
        public MS2Exon Next;
        public MS2Exon Prev;
        public MS2SpliceEdge ForwardSpliceIntrons;
        public MS2SpliceEdge ReverseSpliceIntrons;
        public MS2DeletionEdge ForwardDeletionIntrons;
        public MS2DeletionEdge ReverseDeletionIntrons;
        public MS2InsertionEdge ForwardInsertionIntrons;
        public MS2InsertionEdge ReverseInsertionIntrons;
        public MS2MutationEdge ForwardMutationIntrons;
        public MS2MutationEdge ReverseMutationIntrons;
        public MS2Gene ParentGene = null;
        public String SequenceName;
        public int Strand = -1;
        public int Index = -1;
        public String Sequence;

        public MS2Exon(int Start, int End, String SeqName, int Strand) {
            this.Start = Start;
            this.End = End;
            this.SequenceName = SeqName;
            this.Strand = Strand;
        }

        public MS2Exon(int Start, int End, String SeqName, int Strand, int index) {
            this.Start = Start;
            this.End = End;
            this.SequenceName = SeqName;
            this.Strand = Strand;
            this.Index = index;
        }

        public void LinkExonForward(MS2Exon ToExon) {
            boolean LocalDebug = false;
            if (ToExon.Start < this.End) {
                System.err.println("ERROR: Cannot link exon ending at " + this.End + " " + this.Sequence + " forward to exon starting at " + ToExon.Start + " " + ToExon.Sequence);
                return;
            }
            MS2SpliceEdge Edge = this.ForwardSpliceIntrons;
            while (Edge != null) {
                if (Edge.LinkTo == ToExon) {
                    if (LocalDebug) {
                        System.out.println("Edge Exists!!");
                    }
                    return;
                }
                Edge = Edge.Next;
            }
            Edge = ToExon.ReverseSpliceIntrons;
            while (Edge != null) {
                if (Edge.LinkTo == this) {
                    System.err.println("ERROR: Reverse edge (and no forward edge) exists between " + this.Start + "-" + this.End + " and " + ToExon.Start + "-" + ToExon.End);
                    Utils.WaitForEnter();
                }
                Edge = Edge.Next;
            }
            Edge = new MS2SpliceEdge(this, ToExon);
            Edge.Next = this.ForwardSpliceIntrons;
            this.ForwardSpliceIntrons = Edge;
            if (LocalDebug && ToExon.ReverseSpliceIntrons != null) {
                System.out.println("(1)This is not the first reverse intron for this exon");
                System.out.println("To Exon:");
                ToExon.DebugPrint(true);
                System.out.println("Exon:");
                this.DebugPrint(true);
            }
            MS2SpliceEdge Edge2 = new MS2SpliceEdge(ToExon, this);
            Edge2.Next = ToExon.ReverseSpliceIntrons;
            ToExon.ReverseSpliceIntrons = Edge2;
            if (LocalDebug && ToExon.ReverseSpliceIntrons.Next != null) {
                System.out.println("(2)This is not the first reverse intron for this exon");
                System.out.println("To Exon:");
                ToExon.DebugPrint(true);
                System.out.println("Exon:");
                this.DebugPrint(true);
                Utils.WaitForEnter();
            }
        }

        public void LinkDeletionExonForward(MS2Exon ToExon) {
            boolean LocalDebug = false;
            if (ToExon.Start < this.End) {
                System.err.println("ERROR: Cannot link exon ending at " + this.End + " " + this.Sequence + " forward to exon starting at " + ToExon.Start + " " + ToExon.Sequence);
                return;
            }
            MS2DeletionEdge Edge = this.ForwardDeletionIntrons;
            while (Edge != null) {
                if (Edge.LinkTo == ToExon) {
                    if (LocalDebug) {
                        System.out.println("Edge Exists!!");
                    }
                    return;
                }
                Edge = Edge.Next;
            }
            Edge = ToExon.ReverseDeletionIntrons;
            while (Edge != null) {
                if (Edge.LinkTo == this) {
                    System.err.println("ERROR: Reverse edge (and no forward edge) exists between " + this.Start + "-" + this.End + " and " + ToExon.Start + "-" + ToExon.End);
                    Utils.WaitForEnter();
                }
                Edge = Edge.Next;
            }
            Edge = new MS2DeletionEdge(this, ToExon);
            Edge.Next = this.ForwardDeletionIntrons;
            this.ForwardDeletionIntrons = Edge;
            if (LocalDebug && ToExon.ReverseDeletionIntrons != null) {
                System.out.println("(1)This is not the first reverse intron for this exon");
                System.out.println("To Exon:");
                ToExon.DebugPrint(true);
                System.out.println("Exon:");
                this.DebugPrint(true);
            }
            MS2DeletionEdge Edge2 = new MS2DeletionEdge(ToExon, this);
            Edge2.Next = ToExon.ReverseDeletionIntrons;
            ToExon.ReverseDeletionIntrons = Edge2;
            if (LocalDebug && ToExon.ReverseDeletionIntrons.Next != null) {
                System.out.println("(2)This is not the first reverse intron for this exon");
                System.out.println("To Exon:");
                ToExon.DebugPrint(true);
                System.out.println("Exon:");
                this.DebugPrint(true);
                Utils.WaitForEnter();
            }
        }

        public void LinkInsertionExonForward(MS2Exon ToExon) {
            boolean LocalDebug = false;
            if (ToExon.Start < this.End) {
                System.err.println("ERROR: Cannot link insertsion exon ending at " + this.End + " " + this.Sequence + " forward to exon starting at " + ToExon.Start + " " + ToExon.Sequence);
                return;
            }
            MS2InsertionEdge Edge = this.ForwardInsertionIntrons;
            while (Edge != null) {
                if (Edge.LinkTo == ToExon) {
                    if (LocalDebug) {
                        System.out.println("Edge Exists!!");
                    }
                    return;
                }
                Edge = Edge.Next;
            }
            Edge = ToExon.ReverseInsertionIntrons;
            while (Edge != null) {
                if (Edge.LinkTo == this) {
                    System.err.println("ERROR: Reverse edge (and no forward edge) exists between " + this.Start + "-" + this.End + " and " + ToExon.Start + "-" + ToExon.End);
                    Utils.WaitForEnter();
                }
                Edge = Edge.Next;
            }
            Edge = new MS2InsertionEdge(this, ToExon);
            Edge.Next = this.ForwardInsertionIntrons;
            this.ForwardInsertionIntrons = Edge;
            if (LocalDebug && ToExon.ReverseInsertionIntrons != null) {
                System.out.println("(1)This is not the first reverse intron for this exon");
                System.out.println("To Exon:");
                ToExon.DebugPrint(true);
                System.out.println("Exon:");
                this.DebugPrint(true);
            }
            MS2InsertionEdge Edge2 = new MS2InsertionEdge(ToExon, this);
            Edge2.Next = ToExon.ReverseInsertionIntrons;
            ToExon.ReverseInsertionIntrons = Edge2;
            if (LocalDebug && ToExon.ReverseInsertionIntrons.Next != null) {
                System.out.println("(2)This is not the first reverse intron for this exon");
                System.out.println("To Exon:");
                ToExon.DebugPrint(true);
                System.out.println("Exon:");
                this.DebugPrint(true);
                Utils.WaitForEnter();
            }
        }

        public void LinkMutationExonForward(MS2Exon ToExon) {
            boolean LocalDebug = false;
            if (ToExon.Start < this.End) {
                System.err.println("ERROR: Cannot link mutation exon ending at " + this.End + " " + this.Sequence + " forward to exon starting at " + ToExon.Start + " " + ToExon.Sequence);
                return;
            }
            MS2MutationEdge Edge = this.ForwardMutationIntrons;
            while (Edge != null) {
                if (Edge.LinkTo == ToExon) {
                    if (LocalDebug) {
                        System.out.println("Edge Exists!!");
                    }
                    return;
                }
                Edge = Edge.Next;
            }
            Edge = ToExon.ReverseMutationIntrons;
            while (Edge != null) {
                if (Edge.LinkTo == this) {
                    System.err.println("ERROR: Reverse edge (and no forward edge) exists between " + this.Start + "-" + this.End + " and " + ToExon.Start + "-" + ToExon.End);
                    Utils.WaitForEnter();
                }
                Edge = Edge.Next;
            }
            Edge = new MS2MutationEdge(this, ToExon);
            Edge.Next = this.ForwardMutationIntrons;
            this.ForwardMutationIntrons = Edge;
            if (LocalDebug && ToExon.ReverseMutationIntrons != null) {
                System.out.println("(1)This is not the first reverse intron for this exon");
                System.out.println("To Exon:");
                ToExon.DebugPrint(true);
                System.out.println("Exon:");
                this.DebugPrint(true);
            }
            MS2MutationEdge Edge2 = new MS2MutationEdge(ToExon, this);
            Edge2.Next = ToExon.ReverseMutationIntrons;
            ToExon.ReverseMutationIntrons = Edge2;
            if (LocalDebug && ToExon.ReverseMutationIntrons.Next != null) {
                System.out.println("(2)This is not the first reverse intron for this exon");
                System.out.println("To Exon:");
                ToExon.DebugPrint(true);
                System.out.println("Exon:");
                this.DebugPrint(true);
                Utils.WaitForEnter();
            }
        }

        public void RemoveBackwardEdge(MS2Exon LinkedExon) {
            MS2SpliceEdge Prev = null;
            MS2SpliceEdge Edge = this.ReverseSpliceIntrons;
            while (Edge != null) {
                if (Edge.LinkTo == LinkedExon) {
                    if (Prev != null) {
                        Prev.Next = Edge.Next;
                    } else {
                        this.ReverseSpliceIntrons = Edge.Next;
                    }
                    return;
                }
                Prev = Edge;
                Edge = Edge.Next;
            }
            MS2DeletionEdge PrevDeletion = null;
            MS2DeletionEdge Edge2 = this.ReverseDeletionIntrons;
            while (Edge2 != null) {
                if (Edge2.LinkTo == LinkedExon) {
                    if (PrevDeletion != null) {
                        PrevDeletion.Next = Edge2.Next;
                    } else {
                        this.ReverseDeletionIntrons = Edge2.Next;
                    }
                    return;
                }
                PrevDeletion = Edge2;
                Edge2 = Edge2.Next;
            }
            MS2InsertionEdge PrevInsertion = null;
            MS2InsertionEdge Edge3 = this.ReverseInsertionIntrons;
            while (Edge3 != null) {
                if (Edge3.LinkTo == LinkedExon) {
                    if (PrevInsertion != null) {
                        PrevInsertion.Next = Edge3.Next;
                    } else {
                        this.ReverseInsertionIntrons = Edge3.Next;
                    }
                    return;
                }
                PrevInsertion = Edge3;
                Edge3 = Edge3.Next;
            }
        }

        public void RemoveBackwardSpliceEdge(MS2Exon LinkedExon) {
            MS2SpliceEdge Prev = null;
            MS2SpliceEdge Edge = this.ReverseSpliceIntrons;
            while (Edge != null) {
                if (Edge.LinkTo == LinkedExon) {
                    if (Prev != null) {
                        Prev.Next = Edge.Next;
                    } else {
                        this.ReverseSpliceIntrons = Edge.Next;
                    }
                    return;
                }
                Prev = Edge;
                Edge = Edge.Next;
            }
        }

        public void RemoveForwardEdge(MS2Exon LinkedExon) {
            MS2SpliceEdge Prev = null;
            MS2SpliceEdge Edge = this.ForwardSpliceIntrons;
            while (Edge != null) {
                if (Edge.LinkTo == LinkedExon) {
                    if (Prev != null) {
                        Prev.Next = Edge.Next;
                        break;
                    }
                    this.ForwardSpliceIntrons = Edge.Next;
                    break;
                }
                Prev = Edge;
                Edge = Edge.Next;
            }
            MS2DeletionEdge PrevDeletion = null;
            MS2DeletionEdge Edge2 = this.ForwardDeletionIntrons;
            while (Edge2 != null) {
                if (Edge2.LinkTo == LinkedExon) {
                    if (PrevDeletion != null) {
                        PrevDeletion.Next = Edge2.Next;
                        break;
                    }
                    this.ForwardDeletionIntrons = Edge2.Next;
                    break;
                }
                PrevDeletion = Edge2;
                Edge2 = Edge2.Next;
            }
            MS2InsertionEdge PrevInsertion = null;
            MS2InsertionEdge Edge3 = this.ForwardInsertionIntrons;
            while (Edge3 != null) {
                if (Edge3.LinkTo == LinkedExon) {
                    if (PrevInsertion != null) {
                        PrevInsertion.Next = Edge3.Next;
                        break;
                    }
                    this.ForwardInsertionIntrons = Edge3.Next;
                    break;
                }
                PrevInsertion = Edge3;
                Edge3 = Edge3.Next;
            }
        }

        public void RemoveForwardSpliceEdge(MS2Exon LinkedExon) {
            MS2SpliceEdge Prev = null;
            MS2SpliceEdge Edge = this.ForwardSpliceIntrons;
            while (Edge != null) {
                if (Edge.LinkTo == LinkedExon) {
                    if (Prev != null) {
                        Prev.Next = Edge.Next;
                        break;
                    }
                    this.ForwardSpliceIntrons = Edge.Next;
                    break;
                }
                Prev = Edge;
                Edge = Edge.Next;
            }
        }

        public void ExonInheritForwardEdges(MS2Exon DeadExon) {
            boolean LocalDebug = false;
            Object Edge = DeadExon.ForwardSpliceIntrons;
            while (Edge != null) {
                this.LinkExonForward(((MS2SpliceEdge)Edge).LinkTo);
                ((MS2SpliceEdge)Edge).LinkTo.RemoveBackwardEdge(DeadExon);
                Edge = ((MS2SpliceEdge)Edge).Next;
            }
            DeadExon.ForwardSpliceIntrons = null;
            Edge = DeadExon.ForwardDeletionIntrons;
            while (Edge != null) {
                this.LinkExonForward(((MS2DeletionEdge)Edge).LinkTo);
                ((MS2DeletionEdge)Edge).LinkTo.RemoveBackwardEdge(DeadExon);
                Edge = ((MS2DeletionEdge)Edge).Next;
            }
            DeadExon.ForwardDeletionIntrons = null;
            Edge = DeadExon.ForwardInsertionIntrons;
            while (Edge != null) {
                this.LinkExonForward(((MS2InsertionEdge)Edge).LinkTo);
                ((MS2InsertionEdge)Edge).LinkTo.RemoveBackwardEdge(DeadExon);
                Edge = ((MS2InsertionEdge)Edge).Next;
            }
            DeadExon.ForwardInsertionIntrons = null;
        }

        public void ExonInheritBackwardInsertionEdges(MS2Exon DeadExon) {
            boolean LocalDebug = false;
            MS2InsertionEdge Edge = DeadExon.ReverseInsertionIntrons;
            while (Edge != null) {
                Edge.LinkTo.LinkInsertionExonForward(this);
                Edge = Edge.Next;
            }
        }

        public void ExonInheritBackwardMutationEdges(MS2Exon DeadExon) {
            boolean LocalDebug = false;
            MS2MutationEdge Edge = DeadExon.ReverseMutationIntrons;
            while (Edge != null) {
                Edge.LinkTo.LinkMutationExonForward(this);
                Edge = Edge.Next;
            }
        }

        public void ExonInheritBackwardEdges(MS2Exon DeadExon) {
            boolean LocalDebug = false;
            if (this.Start != DeadExon.Start) {
                System.err.println("ERROR: Exon starting at " + this.Start + " cannot inherit edges from " + DeadExon.Start);
                return;
            }
            Object Edge = DeadExon.ReverseSpliceIntrons;
            while (Edge != null) {
                ((MS2SpliceEdge)Edge).LinkTo.LinkExonForward(this);
                ((MS2SpliceEdge)Edge).LinkTo.RemoveForwardEdge(DeadExon);
                Edge = ((MS2SpliceEdge)Edge).Next;
            }
            DeadExon.ReverseSpliceIntrons = null;
            Edge = DeadExon.ReverseDeletionIntrons;
            while (Edge != null) {
                ((MS2DeletionEdge)Edge).LinkTo.LinkExonForward(this);
                ((MS2DeletionEdge)Edge).LinkTo.RemoveForwardEdge(DeadExon);
                Edge = ((MS2DeletionEdge)Edge).Next;
            }
            DeadExon.ReverseDeletionIntrons = null;
            Edge = DeadExon.ReverseInsertionIntrons;
            while (Edge != null) {
                ((MS2InsertionEdge)Edge).LinkTo.LinkExonForward(this);
                ((MS2InsertionEdge)Edge).LinkTo.RemoveForwardEdge(DeadExon);
                Edge = ((MS2InsertionEdge)Edge).Next;
            }
            DeadExon.ReverseInsertionIntrons = null;
        }

        public void ExonInheritForwardInsertionEdges(MS2Exon DeadExon) {
            boolean LocalDebug = false;
            MS2InsertionEdge Edge = DeadExon.ForwardInsertionIntrons;
            while (Edge != null) {
                this.LinkInsertionExonForward(Edge.LinkTo);
                Edge = Edge.Next;
            }
        }

        public void ExonInheritForwardMutationEdges(MS2Exon DeadExon) {
            boolean LocalDebug = false;
            MS2MutationEdge Edge = DeadExon.ForwardMutationIntrons;
            while (Edge != null) {
                this.LinkMutationExonForward(Edge.LinkTo);
                Edge = Edge.Next;
            }
        }

        public void DebugPrint(boolean Full) {
            if (this.ParentGene != null) {
                System.out.println("**----MS2Exon " + this.Index + " of " + this.ParentGene.GeneName + "----");
            } else {
                System.out.println("**----MS2Exon (No Parent)------");
            }
            System.out.println("[" + this.Start + " - " + this.End + "] ");
            if (Full) {
                System.out.println("SequenceName: " + this.SequenceName);
                System.out.println("Sequence: " + this.Sequence);
                System.out.println("Strand: " + this.Strand);
                System.out.println("Links to ...");
                MS2SpliceEdge Temp = this.ForwardSpliceIntrons;
                while (Temp != null) {
                    Temp.DebugPrint();
                    Temp = Temp.Next;
                }
                System.out.println("Links from ...");
                Temp = this.ReverseSpliceIntrons;
                while (Temp != null) {
                    Temp.DebugPrint();
                    Temp = Temp.Next;
                }
            }
        }

        public int compareTo(Object arg0) {
            MS2Exon Other = (MS2Exon)arg0;
            if (this == Other) {
                return 0;
            }
            if (this.SequenceName.compareTo(Other.SequenceName) < 0) {
                return -1;
            }
            if (this.SequenceName.compareTo(Other.SequenceName) > 0) {
                return 1;
            }
            if (this.Strand < Other.Strand) {
                return -1;
            }
            if (this.Strand > Other.Strand) {
                return 1;
            }
            if (this.Start < Other.Start) {
                return -1;
            }
            if (this.Start > Other.Start) {
                return 1;
            }
            if (this.End < Other.End) {
                return -1;
            }
            if (this.End > Other.End) {
                return 1;
            }
            return 0;
        }
    }

    public class MS2Gene {
        public ArrayList Exons = new ArrayList();
        public MS2Gene Next;
        public String SequenceName;
        public String GeneName = "Unknown";
        public int ForwardFlag = -1;
        public ArrayList CrossReferences = new ArrayList();
        public int GeneStart = -1;
        public int GeneEnd = -1;

        public void DebugPrint(boolean Full) {
            System.out.println("---MS2Gene " + this.GeneName + " on " + this.SequenceName + ", ForwardFlag: " + this.ForwardFlag);
            System.out.println("TotalExons: " + this.Exons.size());
            if (Full) {
                int i = 0;
                while (this.Exons != null && i < this.Exons.size()) {
                    ((MS2Exon)this.Exons.get(i)).DebugPrint(true);
                    ++i;
                }
            }
        }

        public void AddExonToGene(MS2Exon Exon) {
            boolean LocalDebug = false;
            if (Exon.ParentGene != null) {
                if (LocalDebug) {
                    System.out.println("This exon already has a gene: " + Exon.ParentGene.GeneName);
                    Utils.WaitForEnter();
                }
                return;
            }
            if (this.ForwardFlag == -1) {
                this.ForwardFlag = Exon.Strand;
                if (LocalDebug) {
                    System.out.println("This gene now has a strand!!! = " + this.ForwardFlag);
                }
            }
            Exon.ParentGene = this;
            this.Exons.add(Exon);
            MS2SpliceEdge Edge = Exon.ForwardSpliceIntrons;
            while (Edge != null) {
                this.AddExonToGene(Edge.LinkTo);
                Edge = Edge.Next;
            }
            Edge = Exon.ReverseSpliceIntrons;
            while (Edge != null) {
                this.AddExonToGene(Edge.LinkTo);
                Edge = Edge.Next;
            }
            if (Exon.Start < this.GeneStart) {
                this.GeneStart = Exon.Start;
            }
            if (Exon.End > this.GeneEnd) {
                this.GeneEnd = Exon.End;
            }
        }

        public void AddSingleExonToGene(MS2Exon Exon) {
            boolean LocalDebug = false;
            if (Exon.ParentGene != null) {
                if (LocalDebug) {
                    System.out.println("This exon already has a gene: " + Exon.ParentGene.GeneName);
                    Utils.WaitForEnter();
                }
                return;
            }
            if (this.ForwardFlag == -1) {
                this.ForwardFlag = Exon.Strand;
                if (LocalDebug) {
                    System.out.println("This gene now has a strand!!! = " + this.ForwardFlag);
                }
            }
            Exon.ParentGene = this;
            this.Exons.add(Exon);
            if (Exon.Start < this.GeneStart) {
                this.GeneStart = Exon.Start;
            }
            if (Exon.End > this.GeneEnd) {
                this.GeneEnd = Exon.End;
            }
        }
    }

    public class MS2InsertionEdge {
        public MS2Exon LinkTo;
        public MS2Exon LinkFrom;
        public MS2InsertionEdge Next;

        public MS2InsertionEdge(MS2Exon Prev, MS2Exon Next) {
            this.LinkFrom = Prev;
            this.LinkTo = Next;
        }
    }

    public class MS2MutationEdge {
        public MS2Exon LinkTo;
        public MS2Exon LinkFrom;
        public MS2MutationEdge Next;

        public MS2MutationEdge(MS2Exon Prev, MS2Exon Next) {
            this.LinkFrom = Prev;
            this.LinkTo = Next;
        }
    }

    public class MS2SpliceEdge {
        public MS2Exon LinkTo;
        public MS2Exon LinkFrom;
        public MS2SpliceEdge Next;

        public MS2SpliceEdge(MS2Exon Prev, MS2Exon Next) {
            this.LinkFrom = Prev;
            this.LinkTo = Next;
        }

        public void DebugPrint() {
            if (this.LinkFrom.Index >= 0) {
                System.out.println("----MS2SpliceEdge [" + this.LinkFrom.Index + " to " + this.LinkTo.Index + "]");
            }
        }
    }

    public class MutationExon {
        public int Start;
        public int End;
        public int MutationLen;
        public String MutationString;
        public String ChrString;
        public int Strand;
        public MutationExon Next;

        public MutationExon(int Start, int End, String ChrString, int MutationLen, String MutationString, int Strand) {
            this.Start = Start;
            this.End = End;
            this.MutationLen = MutationLen;
            this.MutationString = MutationString;
            this.ChrString = ChrString;
            this.Strand = Strand;
        }
    }
}

