/*
 * Decompiled with CFR 0.152.
 */
package mutationMode;

import basicUtils.Utils;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.imageio.ImageIO;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.statistics.HistogramDataset;
import org.jfree.data.xy.IntervalXYDataset;

public class HistogramBuilder {
    public static String usageInfo = "mutationMode.HistogramBuilder\nBuilds a histogram of the mutation mass deltas\nUsage: java -jar HistogramBuilder\n-w [FILE] Output file to write .png to\n";

    public static boolean DrawHistogram(String outputFile, String title, String xAxisTitle, ArrayList seriesData, ArrayList seriesNames) {
        HistogramDataset ScoreHisto = new HistogramDataset();
        int i = 0;
        while (i < seriesData.size()) {
            double[] currSeries = (double[])seriesData.get(i);
            String currName = (String)seriesNames.get(i);
            ScoreHisto.addSeries((Comparable)((Object)currName), currSeries, 200);
            ++i;
        }
        JFreeChart Chart = ChartFactory.createHistogram((String)title, (String)xAxisTitle, (String)"Counts", (IntervalXYDataset)ScoreHisto, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)false, (boolean)false);
        BufferedImage Image2 = Chart.createBufferedImage(1000, 1000);
        System.out.println("Created histo..." + outputFile);
        try {
            ImageIO.write((RenderedImage)Image2, "png", new File(outputFile));
        }
        catch (Exception E) {
            System.err.println(E.getMessage());
            return false;
        }
        return true;
    }

    public static void main(String[] args) {
        String[] options = new String[]{"-w"};
        boolean[] values = new boolean[]{true};
        Hashtable commandLineArgs = Utils.ParseCommandLine(args, options, values);
        if (!commandLineArgs.containsKey("-w")) {
            System.err.println("ERROR: Missing output file!!");
            System.out.println(usageInfo);
            System.exit(-1);
        }
        String outputFileName = (String)commandLineArgs.get("-w");
        ArrayList<double[]> seriesData = new ArrayList<double[]>();
        ArrayList<String> seriesNames = new ArrayList<String>();
        seriesNames.add("Mutation Deltas");
        double[] massDeltas = new double[441];
        int[] counts = new int[400];
        String AAs = "ACDEFGHIKLMNOPQRSTVWY";
        int strIndex = 0;
        while (strIndex < AAs.length()) {
            int arrayIndex = AAs.charAt(strIndex) - 65;
            double mass1 = (int)Utils.AAMasses[arrayIndex];
            int strIndex2 = 0;
            while (strIndex2 < AAs.length()) {
                int arrayIndex2 = AAs.charAt(strIndex2) - 65;
                double mass2 = (int)Utils.AAMasses[arrayIndex2];
                massDeltas[strIndex * 21 + strIndex2] = mass1 - mass2;
                System.out.println(mass1 - mass2);
                int n = (int)(mass1 - mass2) + 200;
                counts[n] = counts[n] + 1;
                ++strIndex2;
            }
            ++strIndex;
        }
        int i = 0;
        while (i < counts.length) {
            System.out.println(String.valueOf(i - 200) + " Da : " + counts[i]);
            ++i;
        }
        seriesData.add(massDeltas);
        HistogramBuilder.DrawHistogram(outputFileName, "Mutation Delta Histogram", "Mass Delta (Da)", seriesData, seriesNames);
    }
}

