/*
 * Decompiled with CFR 0.152.
 */
package mutationMode;

import basicUtils.ChooseProteins;
import basicUtils.Utils;
import java.util.Date;
import java.util.Hashtable;
import trieUtils.TrieDB;

public class ProteinSequencer {
    public static String usageInfo = "mutationMode.ProteinSequencer\nUsage: java -jar ProteinSequencer.jar\n -r [FILE/DIR] Input file(s) from the mutation tolerant search\n -t [FILE] Trie file used for mutation tolerant search\n(-s [0/1] Indicate which score to use as the peptide discriminator (0: FScore - default, 1: SpecProb))\n";
    private String[] inputFiles;
    private TrieDB trieFile;
    private int scoreChoice = 0;

    public ProteinSequencer(String inputDir, String trieDB, int scoreChoice) {
        if (Utils.IsDir(inputDir)) {
            this.inputFiles = Utils.ListDir(inputDir);
        } else if (Utils.IsFile(inputDir)) {
            this.inputFiles = new String[1];
            this.inputFiles[0] = inputDir;
        } else {
            System.err.println("ERROR: Invalid input file/directory '" + inputDir + "'!");
            System.exit(-1);
        }
        if (Utils.IsFile(trieDB)) {
            this.trieFile = new TrieDB(trieDB);
        } else {
            System.err.println("ERROR: Inavlid trie file name '" + trieDB + "'!");
            System.exit(-1);
        }
        if (scoreChoice < 0 || scoreChoice > 1) {
            System.err.println("ERROR: Invalid score type '" + scoreChoice + "'!");
            System.exit(-1);
        }
        this.scoreChoice = scoreChoice;
    }

    public static void main(String[] args) {
        Date start = new Date();
        long startTime = start.getTime();
        String[] commands = new String[]{"-r", "-t", "-s"};
        boolean[] values = new boolean[]{true, true, true};
        Hashtable options = Utils.ParseCommandLine(args, commands, values);
        if (!options.containsKey("-r") || !options.containsKey("-t")) {
            System.err.println("ERROR: Must specify an input file/directory and a searched database\n");
            System.out.println(usageInfo);
            System.exit(-1);
        }
        String inputDir = (String)options.get("-r");
        String trieDB = (String)options.get("-t");
        int scoreChoice = 0;
        if (options.containsKey("-s")) {
            try {
                scoreChoice = Integer.parseInt((String)options.get("-s"));
            }
            catch (Exception E) {
                E.printStackTrace();
                System.err.println("ERROR: Must specify a score type as 0/1\n");
                System.exit(-1);
            }
        }
        ProteinSequencer pSeq = new ProteinSequencer(inputDir, trieDB, scoreChoice);
        pSeq.RunSequencer();
    }

    private void RunSequencer() {
        Hashtable[] hashes = ChooseProteins.ChooseProteinsParsimonyExternal(this.inputFiles, this.trieFile);
        Hashtable peptide2ProteinHash = hashes[0];
        Hashtable protein2PeptideHash = hashes[1];
        System.out.println("Step 1: Load peptides and choose parsimonious proteins");
        System.out.println("  - Loaded " + peptide2ProteinHash.size() + " peptides for " + protein2PeptideHash.size());
    }
}

