/*
 * Decompiled with CFR 0.152.
 */
package mutationMode;

import basicUtils.InspectAnnotation;
import basicUtils.Utils;
import errorUtils.ErrorThrower;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import trieUtils.TrieDB;

public class ValidateMutationResults {
    public static final String usageInfo = "basicUtils.ValidateMutationResults version 01.25.2011\nLooks at a set of un-filtered mutation mode results and compares\nthem to the oracle results\nREQUIRED:\n -r [DIR/FILE] of unfiltered mutation mode results\n -p [DIR/FILE] of oracle results\nOPTIONAL:\n -w [FILE] File to write missed peptides to\n -t [File] Trie file used for search\n -d [DIR] Directory containing tags\n";
    private String[] oracleFiles;
    private String[] mutFiles;
    private Hashtable oraclePeptides;
    private String missedPeptideFile;
    private TrieDB searchDB = null;

    public ValidateMutationResults(String inputFile, String oracleFile, String missedPeptideFile, String trieDB) {
        if (Utils.IsDir(inputFile)) {
            this.mutFiles = Utils.ListDir(inputFile);
        } else if (Utils.IsFile(inputFile)) {
            this.mutFiles = new String[1];
            this.mutFiles[0] = inputFile;
        } else {
            ErrorThrower.ThrowError(0, inputFile);
        }
        if (Utils.IsDir(oracleFile)) {
            this.oracleFiles = Utils.ListDir(oracleFile);
        } else if (Utils.IsFile(oracleFile)) {
            this.oracleFiles = new String[1];
            this.oracleFiles[0] = oracleFile;
        } else {
            ErrorThrower.ThrowError(0, oracleFile);
        }
        this.missedPeptideFile = missedPeptideFile;
        if (trieDB != null) {
            this.searchDB = new TrieDB(trieDB);
        }
    }

    public static void main(String[] args) {
        String[] options = new String[]{"-r", "-p", "-w", "-t"};
        boolean[] values = new boolean[]{true, true, true, true};
        Hashtable commandLineArgs = Utils.ParseCommandLine(args, options, values);
        if (!commandLineArgs.containsKey("-r") || !commandLineArgs.containsKey("-p")) {
            System.err.println("ERROR: Must specify an input file/dir and an oracle file/dir!");
            System.err.println(usageInfo);
            System.exit(0);
        }
        String inputFile = (String)commandLineArgs.get("-r");
        String oracleFile = (String)commandLineArgs.get("-p");
        String outputFile = null;
        if (commandLineArgs.containsKey("-w")) {
            outputFile = (String)commandLineArgs.get("-w");
        }
        String trieFile = null;
        if (commandLineArgs.containsKey("-t")) {
            trieFile = (String)commandLineArgs.get("-t");
        }
        ValidateMutationResults validator = new ValidateMutationResults(inputFile, oracleFile, outputFile, trieFile);
        validator.validate();
    }

    private void validate() {
        this.oraclePeptides = InspectAnnotation.LoadInspectAnnotationsIntoSpec2PeptideAndScoreHash(this.oracleFiles);
        System.out.println("Loaded " + this.oraclePeptides.size() + " annotated spectra from oracle");
        Enumeration e = this.oraclePeptides.keys();
        Hashtable<String, Integer> correctPeptides = new Hashtable<String, Integer>();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String[] info = (String[])this.oraclePeptides.get(key);
            String correctPeptide = info[0];
            if (correctPeptide.indexOf(46) >= 0) {
                correctPeptide = correctPeptide.split("[.]")[1];
            }
            correctPeptides.put(correctPeptide, new Integer(1));
        }
        System.out.println("Oracle peptides: " + correctPeptides.size());
        Hashtable peptide2DB = this.searchDB.getAllMatchedNames(correctPeptides);
        boolean localDebug = false;
        int[] rankCounts = new int[10];
        int[] noMutationCounts = new int[10];
        int[] PRMrankCounts = new int[10];
        int incorrectCalls = 0;
        BufferedReader buf = null;
        String line = null;
        String currFileName = null;
        int currScanNum = -1;
        int shortPeptides = 0;
        int numSpectraWithNoOracle = 0;
        ArrayList<String[]> currPeptides = new ArrayList<String[]>();
        ArrayList<Boolean> areModified = new ArrayList<Boolean>();
        Hashtable<String, Integer> missedPeptides = new Hashtable<String, Integer>();
        Hashtable[] rankPeptides = new Hashtable[10];
        int i = 0;
        while (i < rankPeptides.length) {
            rankPeptides[i] = new Hashtable();
            ++i;
        }
        FileWriter missedWriter = null;
        if (this.missedPeptideFile != null) {
            try {
                missedWriter = new FileWriter(this.missedPeptideFile);
                missedWriter.write("#FileOrder\tPredictedPeptide\tScore\tMatchedPeptideUnMutated\tMatchedProtein\t%CorrectPRMs\t%MissedPRMs\tHammingDistanceVersusLength\tAlignmentLength\n");
            }
            catch (IOException E) {
                E.printStackTrace();
                this.missedPeptideFile = null;
            }
        }
        int i2 = 0;
        while (i2 < this.mutFiles.length) {
            String ext = Utils.GetFileExtension(this.mutFiles[i2]);
            if (ext.indexOf("zip") < 0) {
                System.out.println("Considering predictions in " + this.mutFiles[i2]);
                try {
                    buf = new BufferedReader(new FileReader(this.mutFiles[i2]));
                    line = buf.readLine();
                }
                catch (IOException E) {
                    E.printStackTrace();
                    System.exit(-1);
                }
                while (line != null) {
                    String[] newPep;
                    String score;
                    String pep;
                    if ((line = line.trim()).length() == 0 || line.charAt(0) == '#') {
                        try {
                            line = buf.readLine();
                        }
                        catch (IOException E) {
                            E.printStackTrace();
                            System.exit(-1);
                        }
                        continue;
                    }
                    String[] bits = line.split("\t");
                    String fileName = Utils.GetBaseName(bits[InspectAnnotation.InspectColumns.SpectrumFile]);
                    int scanNum = 0;
                    try {
                        scanNum = Integer.parseInt(bits[InspectAnnotation.InspectColumns.ScanNumber]);
                    }
                    catch (NumberFormatException E2) {
                        System.err.println("Unable to parse scan number from " + line);
                        E2.printStackTrace();
                        try {
                            line = buf.readLine();
                        }
                        catch (IOException E) {
                            E.printStackTrace();
                            System.exit(-1);
                        }
                        continue;
                    }
                    if (bits[InspectAnnotation.InspectColumns.Annotation].length() < 9) {
                        ++shortPeptides;
                        try {
                            line = buf.readLine();
                        }
                        catch (IOException E) {
                            E.printStackTrace();
                            System.exit(-1);
                        }
                        continue;
                    }
                    if (currFileName == null) {
                        currFileName = fileName;
                        currScanNum = scanNum;
                        if (localDebug) {
                            System.out.println("First observation for " + fileName + ":" + scanNum);
                        }
                        pep = Utils.GetPeptideFromMutated(bits[InspectAnnotation.InspectColumns.Annotation]);
                        score = bits[InspectAnnotation.InspectColumns.FScore];
                        newPep = new String[]{pep, score, bits[InspectAnnotation.InspectColumns.ProteinName], bits[InspectAnnotation.InspectColumns.ProteinID]};
                        currPeptides.add(newPep);
                        if (pep.compareTo(bits[InspectAnnotation.InspectColumns.Annotation]) == 0) {
                            areModified.add(new Boolean(false));
                        } else {
                            areModified.add(new Boolean(true));
                        }
                    } else if (currFileName.compareTo(fileName) != 0 || currScanNum != scanNum) {
                        if (!this.oraclePeptides.containsKey(String.valueOf(currFileName) + "_" + currScanNum)) {
                            if (localDebug) {
                                System.out.println("This scan has no oracle val: " + currFileName + ":" + currScanNum);
                            }
                            ++numSpectraWithNoOracle;
                        } else {
                            String p;
                            String[] pepInfo;
                            String[] info = (String[])this.oraclePeptides.get(String.valueOf(currFileName) + "_" + currScanNum);
                            String correctPeptide = info[0];
                            String MQScore = info[1];
                            if (correctPeptide.indexOf(46) >= 0) {
                                correctPeptide = correctPeptide.split("[.]")[1];
                            }
                            if (localDebug) {
                                System.out.println("Finished observations for " + currFileName + ":" + currScanNum);
                                System.out.println("oraclePeptide: " + correctPeptide);
                            }
                            boolean found = false;
                            int j = 0;
                            while (j < currPeptides.size()) {
                                pepInfo = (String[])currPeptides.get(j);
                                p = pepInfo[0];
                                boolean isModified = (Boolean)areModified.get(j);
                                if (p.indexOf(46) >= 0) {
                                    p = p.split("[.]")[1];
                                }
                                if (localDebug) {
                                    System.out.println("Comparing to peptide: " + p);
                                }
                                if (Utils.PeptidesAreILQKEquivalent(correctPeptide, p)) {
                                    int n = j;
                                    rankCounts[n] = rankCounts[n] + 1;
                                    rankPeptides[j].put(correctPeptide, new Integer(1));
                                    if (!isModified) {
                                        int n2 = j;
                                        noMutationCounts[n2] = noMutationCounts[n2] + 1;
                                    }
                                    found = true;
                                    if (!localDebug) break;
                                    System.out.println("Match!!");
                                    break;
                                }
                                ++j;
                            }
                            if (!found) {
                                ++incorrectCalls;
                                j = 0;
                                while (j < currPeptides.size()) {
                                    pepInfo = (String[])currPeptides.get(j);
                                    p = pepInfo[0];
                                    if (p.indexOf(46) >= 0) {
                                        p = p.split("[.]")[1];
                                    }
                                    if (localDebug) {
                                        System.out.println("Comparing to peptide: " + p);
                                    }
                                    if (Utils.PeptidesArePRMEquivalent(correctPeptide, p)) {
                                        int n = j;
                                        PRMrankCounts[n] = PRMrankCounts[n] + 1;
                                        found = true;
                                        if (!localDebug) break;
                                        System.out.println("Match!!");
                                        break;
                                    }
                                    ++j;
                                }
                                if (!found) {
                                    try {
                                        String intendedMutant = "";
                                        String mutation = "";
                                        String deltas = "";
                                        if (this.searchDB != null && peptide2DB.containsKey(correctPeptide)) {
                                            int[] protIDs = Utils.ConvertArraylistToIntArray((ArrayList)peptide2DB.get(correctPeptide));
                                            int protID = 0;
                                            while (protID < protIDs.length) {
                                                String mut = this.searchDB.getProteinSequence(protID);
                                                intendedMutant = String.valueOf(intendedMutant) + mut + ",";
                                                int index = 0;
                                                while (index < mut.length()) {
                                                    if (mut.charAt(index) != correctPeptide.charAt(index)) {
                                                        mutation = String.valueOf(mutation) + correctPeptide.charAt(index) + "->" + mut.charAt(index) + ",";
                                                        deltas = String.valueOf(deltas) + (Utils.AAMasses[correctPeptide.charAt(index) - 65] - Utils.AAMasses[mut.charAt(index) - 65]) + ",";
                                                        break;
                                                    }
                                                    ++index;
                                                }
                                                ++protID;
                                            }
                                        }
                                        missedWriter.write(String.valueOf(currFileName) + "\t" + currScanNum + "\t" + correctPeptide + "\t" + MQScore + "\t" + intendedMutant + "\t" + mutation + "\t" + deltas + "\t" + currPeptides.size() + "\n");
                                        int j2 = 0;
                                        while (j2 < currPeptides.size()) {
                                            String[] p2 = (String[])currPeptides.get(j2);
                                            String dbSeq = "";
                                            if (this.searchDB != null && (dbSeq = this.searchDB.getProteinSequence(Integer.parseInt(p2[3]))) == null) {
                                                System.out.println("WTF! We didn't get a DB seq for protein " + p2[0] + "/" + correctPeptide + " with id " + p2[3]);
                                                Utils.WaitForEnter();
                                            } else {
                                                double percentageCorrect = Utils.GetPercentCorrectPRMs(correctPeptide, p2[0], Utils.LTQFragTol);
                                                double percentageMissed = Utils.GetPercentMissedPRMs(correctPeptide, p2[0], Utils.LTQFragTol);
                                                int[] HammingData = Utils.getHammingDistanceOfSubstrings(correctPeptide, p2[0]);
                                                double Frac = (double)HammingData[0] / (double)HammingData[1];
                                                missedWriter.write("[" + j2 + "]\t" + p2[0] + "\t" + p2[1] + "\t" + p2[2] + "\t" + dbSeq + "\t" + percentageCorrect + "\t" + percentageMissed + "\t" + Frac + "\t" + HammingData[1] + "\n");
                                            }
                                            ++j2;
                                        }
                                    }
                                    catch (IOException E) {
                                        E.printStackTrace();
                                    }
                                    missedPeptides.put(correctPeptide, new Integer(1));
                                }
                                if (localDebug) {
                                    System.out.println("Could not find match in top 10 for " + currFileName + ":" + currScanNum);
                                    System.out.println("Correct Peptide: " + correctPeptide);
                                    j = 0;
                                    while (j < currPeptides.size()) {
                                        String p3 = ((String[])currPeptides.get(j))[0];
                                        System.out.println("[" + j + "] : " + p3);
                                        ++j;
                                    }
                                    Utils.WaitForEnter();
                                }
                                if (localDebug) {
                                    System.out.println("No match found!");
                                }
                            }
                        }
                        if (localDebug) {
                            Utils.WaitForEnter();
                        }
                        currPeptides.clear();
                        areModified.clear();
                        currFileName = fileName;
                        currScanNum = scanNum;
                        if (localDebug) {
                            System.out.println("First observation for " + fileName + ":" + scanNum);
                        }
                        pep = Utils.GetPeptideFromMutated(bits[InspectAnnotation.InspectColumns.Annotation]);
                        score = bits[InspectAnnotation.InspectColumns.FScore];
                        newPep = new String[]{pep, score, bits[InspectAnnotation.InspectColumns.ProteinName], bits[InspectAnnotation.InspectColumns.ProteinID]};
                        currPeptides.add(newPep);
                        if (pep.compareTo(bits[InspectAnnotation.InspectColumns.Annotation]) == 0) {
                            areModified.add(new Boolean(false));
                        } else {
                            areModified.add(new Boolean(true));
                        }
                    } else {
                        pep = Utils.GetPeptideFromMutated(bits[InspectAnnotation.InspectColumns.Annotation]);
                        score = bits[InspectAnnotation.InspectColumns.FScore];
                        newPep = new String[]{pep, score, bits[InspectAnnotation.InspectColumns.ProteinName], bits[InspectAnnotation.InspectColumns.ProteinID]};
                        currPeptides.add(newPep);
                        if (pep.compareTo(bits[InspectAnnotation.InspectColumns.Annotation]) == 0) {
                            areModified.add(new Boolean(false));
                        } else {
                            areModified.add(new Boolean(true));
                        }
                    }
                    try {
                        line = buf.readLine();
                    }
                    catch (IOException E) {
                        E.printStackTrace();
                        System.exit(-1);
                    }
                }
                try {
                    buf.close();
                }
                catch (IOException E) {
                    E.printStackTrace();
                    System.exit(-1);
                }
            }
            ++i2;
        }
        if (currPeptides.size() > 0 && this.oraclePeptides.containsKey(String.valueOf(currFileName) + "_" + currScanNum)) {
            String p;
            String[] pepInfo;
            String[] info = (String[])this.oraclePeptides.get(String.valueOf(currFileName) + "_" + currScanNum);
            String correctPeptide = info[0];
            String MQScore = info[1];
            if (correctPeptide.indexOf(46) >= 0) {
                correctPeptide = correctPeptide.split("[.]")[1];
            }
            if (localDebug) {
                System.out.println("Finished observations for " + currFileName + ":" + currScanNum);
                System.out.println("oraclePeptide: " + correctPeptide);
            }
            boolean found = false;
            int j = 0;
            while (j < currPeptides.size()) {
                pepInfo = (String[])currPeptides.get(j);
                p = pepInfo[0];
                boolean isModified = (Boolean)areModified.get(j);
                if (p.indexOf(46) >= 0) {
                    p = p.split("[.]")[1];
                }
                if (localDebug) {
                    System.out.println("Comparing to peptide: " + p);
                }
                if (Utils.PeptidesAreILQKEquivalent(correctPeptide, p)) {
                    int n = j;
                    rankCounts[n] = rankCounts[n] + 1;
                    rankPeptides[j].put(correctPeptide, new Integer(1));
                    if (!isModified) {
                        int n3 = j;
                        noMutationCounts[n3] = noMutationCounts[n3] + 1;
                    }
                    found = true;
                    if (!localDebug) break;
                    System.out.println("Match!!");
                    break;
                }
                ++j;
            }
            if (!found) {
                ++incorrectCalls;
                j = 0;
                while (j < currPeptides.size()) {
                    pepInfo = (String[])currPeptides.get(j);
                    p = pepInfo[0];
                    if (p.indexOf(46) >= 0) {
                        p = p.split("[.]")[1];
                    }
                    if (localDebug) {
                        System.out.println("Comparing to peptide: " + p);
                    }
                    if (Utils.PeptidesArePRMEquivalent(correctPeptide, p)) {
                        found = true;
                        int n = j;
                        PRMrankCounts[n] = PRMrankCounts[n] + 1;
                        if (!localDebug) break;
                        System.out.println("Match!!");
                        break;
                    }
                    ++j;
                }
                if (!found) {
                    try {
                        String intendedMutant = "";
                        String mutation = "";
                        String deltas = "";
                        if (this.searchDB != null && peptide2DB.containsKey(correctPeptide)) {
                            int[] protIDs = Utils.ConvertArraylistToIntArray((ArrayList)peptide2DB.get(correctPeptide));
                            int protID = 0;
                            while (protID < protIDs.length) {
                                String mut = this.searchDB.getProteinSequence(protID);
                                intendedMutant = String.valueOf(intendedMutant) + mut + ",";
                                int index = 0;
                                while (index < mut.length()) {
                                    if (mut.charAt(index) != correctPeptide.charAt(index)) {
                                        mutation = String.valueOf(mutation) + correctPeptide.charAt(index) + "->" + mut.charAt(index) + ",";
                                        deltas = String.valueOf(deltas) + (Utils.AAMasses[correctPeptide.charAt(index) - 65] - Utils.AAMasses[mut.charAt(index) - 65]) + ",";
                                        break;
                                    }
                                    ++index;
                                }
                                ++protID;
                            }
                        }
                        missedWriter.write(String.valueOf(currFileName) + "\t" + currScanNum + "\t" + correctPeptide + "\t" + MQScore + "\t" + intendedMutant + "\t" + mutation + "\t" + deltas + "\t" + currPeptides.size() + "\n");
                        int j3 = 0;
                        while (j3 < currPeptides.size()) {
                            String[] p4 = (String[])currPeptides.get(j3);
                            String dbSeq = "";
                            if (this.searchDB != null && (dbSeq = this.searchDB.getProteinSequence(Integer.parseInt(p4[3]))) == null) {
                                System.out.println("WTF! We didn't get a DB seq for protein " + p4[0] + "/" + correctPeptide + " with id " + p4[3]);
                                Utils.WaitForEnter();
                            }
                            double percentageCorrect = Utils.GetPercentCorrectPRMs(correctPeptide, p4[0], Utils.LTQFragTol);
                            double percentageMissed = Utils.GetPercentMissedPRMs(correctPeptide, p4[0], Utils.LTQFragTol);
                            int[] HammingData = Utils.getHammingDistanceOfSubstrings(correctPeptide, p4[0]);
                            double Frac = (double)HammingData[0] / (double)HammingData[1];
                            missedWriter.write("[" + j3 + "]\t" + p4[0] + "\t" + p4[1] + "\t" + p4[2] + "\t" + dbSeq + "\t" + percentageCorrect + "\t" + percentageMissed + "\t" + Frac + "\t" + HammingData[1] + "\n");
                            ++j3;
                        }
                    }
                    catch (IOException E) {
                        E.printStackTrace();
                    }
                    missedPeptides.put(correctPeptide, new Integer(1));
                }
                if (localDebug) {
                    System.out.println("Could not find match in top 10 for " + currFileName + ":" + currScanNum);
                    System.out.println("Correct Peptide: " + correctPeptide);
                    j = 0;
                    while (j < currPeptides.size()) {
                        pepInfo = (String[])currPeptides.get(j);
                        p = pepInfo[0];
                        System.out.println("[" + j + "] : " + p);
                        ++j;
                    }
                    Utils.WaitForEnter();
                }
                if (localDebug) {
                    System.out.println("No match found!");
                }
            }
            if (localDebug) {
                Utils.WaitForEnter();
            }
        }
        if (this.missedPeptideFile != null) {
            try {
                missedWriter.close();
            }
            catch (IOException E) {
                E.printStackTrace();
            }
        }
        i = 0;
        while (i < rankCounts.length) {
            System.out.println("rankCount[" + i + "]: " + rankCounts[i] + ", with " + noMutationCounts[i] + " with unmutated db matches, and " + rankPeptides[i].size() + " peptides");
            ++i;
        }
        System.out.println("Total spectra with no correct annotation in the top 10: " + incorrectCalls);
        System.out.println("Total peptides with no correct annotation: " + missedPeptides.size());
        if (this.searchDB != null) {
            String[] peps = Utils.GetHashtableKeysString(missedPeptides);
            Hashtable locs = this.searchDB.GetAllLocations(peps);
            Hashtable mutatedLocs = this.searchDB.GetAllLocations1MisMatch(peps);
            int missedButInDB = 0;
            int missedButInDBMutated = 0;
            int i3 = 0;
            while (i3 < peps.length) {
                if (locs.containsKey(peps[i3])) {
                    ++missedButInDB;
                } else if (mutatedLocs.containsKey(peps[i3])) {
                    ++missedButInDBMutated;
                }
                ++i3;
            }
            System.out.println("Missed peptides with a entry in the DB: " + missedButInDB);
            System.out.println("Missed peptides with a mutated entry in the DB: " + missedButInDBMutated);
        }
        i = 0;
        while (i < PRMrankCounts.length) {
            System.out.println("PRMRankCount[" + i + "]: " + PRMrankCounts[i]);
            ++i;
        }
        System.out.println("Skipped " + shortPeptides + " short peptides !");
    }
}

