/*
 * Decompiled with CFR 0.152.
 */
package proteogenomicUtils;

import basicUtils.InspectAnnotation;
import basicUtils.Utils;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import trieUtils.TrieDB;

public class DetermineDecoyTargetKnown {
    public static String UsageInfo = "proteogenomicUtils.DetermineDecoyTargetKnown version 9.16.2010\nThis program is used to determine the counts of the following categories of peptides.\n (1) Peptides identified against a target DB, specifically in the target known proteome\n (2) Peptides identified against a target DB, but appearing in the decoy known proteome\n (3) Peptides identified against a Decoy DB, but appearing in the target known proteome\n (4) Peptides identified against a decoy DB, specifically in the decoy known proteome\nThe policy for assigning peptides to groups is the following: If a peptide appears in both the target and decoy database\nthen it can be counted as both a target and decoy PSM.  If there is a spectrum for which the target peptide is hightest, then this \nPSM is counted as a target PSM, while if the spectrum matches the decoy peptide with higher score, then this \nPSM is counted as a decoy PSM\n[REQUIRED]:\n -r [FILE] File containing Inspect original search results\n -k [FILE] Known proteome trie file (contains both known and decoy proteins)\n -w [FILE] An output file name for the 'known' peptides\n -n [FILE] An output file name for the 'novel' peptides\n[OPTIONAL]:\n -f Use flanking masses of peptides to differentiate\n -d run in debug mode\n";
    private boolean Debug;
    private String inputFile;
    private TrieDB TrieFile;
    private int[][] SpecCounts = null;
    private int[] PepCounts = null;
    private String OutputFileKnown;
    private String OutputFileNovel;
    private int[][] ModSpecCounts = null;
    private boolean UseFlankingMasses = false;

    public DetermineDecoyTargetKnown(String inputFile, String DBFile, String KnownOutputFile, String NovelOutputFile) {
        this.inputFile = inputFile;
        if (!Utils.IsFile(this.inputFile)) {
            System.err.println("ERROR: Input file '" + this.inputFile + "' is not a valid file!");
            System.exit(-1);
        }
        this.TrieFile = new TrieDB(DBFile);
        this.SpecCounts = new int[2][4];
        this.ModSpecCounts = new int[2][2];
        this.PepCounts = new int[4];
        this.OutputFileKnown = KnownOutputFile;
        this.OutputFileNovel = NovelOutputFile;
    }

    private void Run() {
        FileWriter OutFileNovel;
        FileWriter OutFileKnown;
        Hashtable<String, ArrayList> CurrPeptides = new Hashtable<String, ArrayList>();
        Hashtable<String, Integer> SeenPeptides = new Hashtable<String, Integer>();
        BufferedReader InFile = null;
        String Line = null;
        int AnnCount = 0;
        try {
            InFile = new BufferedReader(new FileReader(this.inputFile));
            OutFileKnown = new FileWriter(this.OutputFileKnown);
            OutFileKnown.write(InspectAnnotation.SplicedHeaderLineDefault);
            OutFileNovel = new FileWriter(this.OutputFileNovel);
            OutFileNovel.write(InspectAnnotation.SplicedHeaderLineDefault);
            Line = InFile.readLine();
        }
        catch (IOException E) {
            E.printStackTrace();
            return;
        }
        String[] columnHeaders = null;
        while (Line != null) {
            if ((Line = Line.trim()).length() == 0 || Line.charAt(0) == '#') {
                if (Line.length() > 0 && Line.charAt(0) == '#') {
                    columnHeaders = Line.substring(1).split("\t");
                }
                try {
                    Line = InFile.readLine();
                    continue;
                }
                catch (IOException E) {
                    E.printStackTrace();
                    return;
                }
            }
            InspectAnnotation NewAnn = new InspectAnnotation(Line, columnHeaders);
            ++AnnCount;
            String UnModded = Utils.GetUnModded(NewAnn.Annotation);
            if (this.UseFlankingMasses && NewAnn.AnnotationWithFlanking != null && NewAnn.AnnotationWithFlanking.indexOf(".") >= 0) {
                UnModded = String.valueOf(NewAnn.AnnotationWithFlanking.charAt(0)) + "." + UnModded + "." + NewAnn.AnnotationWithFlanking.charAt(NewAnn.AnnotationWithFlanking.length() - 1);
            }
            if (SeenPeptides.containsKey(UnModded)) {
                if (this.Debug) {
                    System.out.println("We've seen it before!");
                }
                int Value = (Integer)SeenPeptides.get(UnModded);
                if (this.Debug) {
                    System.out.println(String.valueOf(NewAnn.ProteinName) + "-IsDecoy: " + Utils.IsDecoyProtein(NewAnn.ProteinName) + " -> " + Value);
                }
                if (Utils.IsDecoyProtein(NewAnn.ProteinName)) {
                    if (Value == 1 || Value == 3) {
                        try {
                            OutFileKnown.write(String.valueOf(NewAnn.toString()) + "\n");
                        }
                        catch (IOException E) {
                            E.printStackTrace();
                            return;
                        }
                        int[] nArray = this.ModSpecCounts[1];
                        nArray[0] = nArray[0] + 1;
                    } else {
                        try {
                            OutFileNovel.write(String.valueOf(NewAnn.toString()) + "\n");
                        }
                        catch (IOException E) {
                            E.printStackTrace();
                            return;
                        }
                        int[] nArray = this.ModSpecCounts[1];
                        nArray[1] = nArray[1] + 1;
                    }
                    int[] nArray = this.SpecCounts[1];
                    int n = Value;
                    nArray[n] = nArray[n] + 1;
                } else {
                    if (Value == 0 || Value == 3) {
                        try {
                            OutFileKnown.write(String.valueOf(NewAnn.toString()) + "\n");
                        }
                        catch (IOException E) {
                            E.printStackTrace();
                            return;
                        }
                        int[] nArray = this.ModSpecCounts[0];
                        nArray[0] = nArray[0] + 1;
                    } else {
                        try {
                            OutFileNovel.write(String.valueOf(NewAnn.toString()) + "\n");
                        }
                        catch (IOException E) {
                            E.printStackTrace();
                            return;
                        }
                        int[] nArray = this.ModSpecCounts[0];
                        nArray[1] = nArray[1] + 1;
                    }
                    int[] nArray = this.SpecCounts[0];
                    int n = Value;
                    nArray[n] = nArray[n] + 1;
                }
            } else {
                ArrayList Temp = null;
                Temp = CurrPeptides.containsKey(UnModded) ? (ArrayList)CurrPeptides.get(UnModded) : new ArrayList();
                Temp.add(Line);
                CurrPeptides.put(UnModded, Temp);
                if (CurrPeptides.size() >= 5000) {
                    System.out.println("We've reached " + CurrPeptides.size() + " peptides, so we search...");
                    String[] PeptidesToSearch = Utils.GetHashtableKeysString(CurrPeptides);
                    Hashtable Locations = this.TrieFile.GetAllLocations(PeptidesToSearch);
                    int i = 0;
                    while (i < PeptidesToSearch.length) {
                        if (this.Debug) {
                            System.out.println(" Peptide: " + PeptidesToSearch[i]);
                        }
                        boolean TargetFound = false;
                        boolean DecoyFound = false;
                        if (Locations.containsKey(PeptidesToSearch[i]) && ((ArrayList)Locations.get(PeptidesToSearch[i])).size() > 0) {
                            InspectAnnotation Ann;
                            int ProteinID = -1;
                            String ProteinName = "";
                            int TrieDBPos = -1;
                            ArrayList Locs = (ArrayList)Locations.get(PeptidesToSearch[i]);
                            int k = 0;
                            while (k < Locs.size()) {
                                Object[] Location = (Object[])Locs.get(k);
                                ProteinName = (String)Location[3];
                                if (this.Debug) {
                                    System.out.println(String.valueOf(ProteinName) + "-IsDecoy: " + Utils.IsDecoyProtein(ProteinName));
                                }
                                if (Utils.IsDecoyProtein(ProteinName)) {
                                    DecoyFound = true;
                                } else {
                                    TargetFound = true;
                                }
                                ++k;
                            }
                            ArrayList Lines = (ArrayList)CurrPeptides.get(PeptidesToSearch[i]);
                            int CountIndex = -1;
                            CountIndex = DecoyFound && TargetFound ? 3 : (DecoyFound ? 1 : (TargetFound ? 0 : 2));
                            if (this.Debug) {
                                System.out.println("Value -> " + CountIndex);
                            }
                            SeenPeptides.put(PeptidesToSearch[i], new Integer(CountIndex));
                            Object[] Location = (Object[])Locs.get(0);
                            ProteinID = (Integer)Location[1];
                            ProteinName = (String)Location[3];
                            TrieDBPos = this.TrieFile.GetTriePos(ProteinID) + (Integer)Location[2];
                            boolean TargetPSM = false;
                            boolean DecoyPSM = false;
                            int j = 0;
                            while (j < Lines.size()) {
                                Ann = new InspectAnnotation((String)Lines.get(j), columnHeaders);
                                if (this.Debug) {
                                    System.out.println(String.valueOf(Ann.ProteinName) + "-IsDecoy: " + Utils.IsDecoyProtein(Ann.ProteinName) + ", Value = 2");
                                }
                                if (Utils.IsDecoyProtein(Ann.ProteinName)) {
                                    if (CountIndex == 0 || CountIndex == 3) {
                                        System.out.println("Oops: this decoy PSM was ID'd against the target DB!!");
                                        System.out.println(Ann.toString());
                                    }
                                    DecoyPSM = true;
                                    if (DecoyFound) {
                                        try {
                                            OutFileKnown.write(String.valueOf(Ann.toString()) + "\n");
                                        }
                                        catch (IOException E) {
                                            E.printStackTrace();
                                            return;
                                        }
                                        int[] nArray = this.ModSpecCounts[1];
                                        nArray[0] = nArray[0] + 1;
                                    } else {
                                        try {
                                            OutFileNovel.write(String.valueOf(Ann.toString()) + "\n");
                                        }
                                        catch (IOException E) {
                                            E.printStackTrace();
                                            return;
                                        }
                                        int[] nArray = this.ModSpecCounts[1];
                                        nArray[1] = nArray[1] + 1;
                                    }
                                    int[] nArray = this.SpecCounts[1];
                                    int n = CountIndex;
                                    nArray[n] = nArray[n] + 1;
                                } else {
                                    if (CountIndex == 1 || CountIndex == 3) {
                                        System.out.println("Oops: this target PSM was ID'd against the decoy DB!!");
                                        System.out.println(Ann.toString());
                                    }
                                    TargetPSM = true;
                                    int[] nArray = this.SpecCounts[0];
                                    int n = CountIndex;
                                    nArray[n] = nArray[n] + 1;
                                    if (TargetFound) {
                                        try {
                                            OutFileKnown.write(String.valueOf(Ann.toString()) + "\n");
                                        }
                                        catch (IOException E) {
                                            E.printStackTrace();
                                            return;
                                        }
                                        int[] nArray2 = this.ModSpecCounts[0];
                                        nArray2[0] = nArray2[0] + 1;
                                    } else {
                                        try {
                                            OutFileNovel.write(String.valueOf(Ann.toString()) + "\n");
                                        }
                                        catch (IOException E) {
                                            E.printStackTrace();
                                            return;
                                        }
                                        int[] nArray3 = this.ModSpecCounts[0];
                                        nArray3[1] = nArray3[1] + 1;
                                    }
                                }
                                ++j;
                            }
                            if (TargetPSM && DecoyPSM) {
                                System.out.println("CRAP: THIS Peptide was id'd with both decoy and target PSMs!!");
                                j = 0;
                                while (j < Lines.size()) {
                                    Ann = new InspectAnnotation((String)Lines.get(j), columnHeaders);
                                    System.out.println(Ann.toString());
                                    ++j;
                                }
                                Utils.WaitForEnter();
                            }
                            int n = CountIndex;
                            this.PepCounts[n] = this.PepCounts[n] + 1;
                            if (this.Debug) {
                                Utils.WaitForEnter();
                            }
                        } else {
                            InspectAnnotation Ann;
                            if (this.Debug) {
                                System.out.println(String.valueOf(PeptidesToSearch[i]) + " - NOVEL");
                            }
                            boolean TargetPSM = false;
                            boolean DecoyPSM = false;
                            SeenPeptides.put(PeptidesToSearch[i], new Integer(2));
                            ArrayList Lines = (ArrayList)CurrPeptides.get(PeptidesToSearch[i]);
                            int j = 0;
                            while (j < Lines.size()) {
                                Ann = new InspectAnnotation((String)Lines.get(j), columnHeaders);
                                if (Utils.IsDecoyProtein(Ann.ProteinName)) {
                                    DecoyPSM = true;
                                    int[] nArray = this.ModSpecCounts[1];
                                    nArray[1] = nArray[1] + 1;
                                    int[] nArray4 = this.SpecCounts[1];
                                    nArray4[2] = nArray4[2] + 1;
                                } else {
                                    TargetPSM = true;
                                    int[] nArray = this.ModSpecCounts[0];
                                    nArray[1] = nArray[1] + 1;
                                    int[] nArray5 = this.SpecCounts[0];
                                    nArray5[2] = nArray5[2] + 1;
                                }
                                try {
                                    OutFileNovel.write(String.valueOf(Ann.toString()) + "\n");
                                }
                                catch (IOException E) {
                                    E.printStackTrace();
                                    return;
                                }
                                ++j;
                            }
                            if (TargetPSM && DecoyPSM) {
                                System.out.println("CRAP: THIS Peptide was id'd with both decoy and target PSMs!!");
                                j = 0;
                                while (j < Lines.size()) {
                                    Ann = new InspectAnnotation((String)Lines.get(j), columnHeaders);
                                    System.out.println(Ann.toString());
                                    ++j;
                                }
                                Utils.WaitForEnter();
                            }
                            this.PepCounts[2] = this.PepCounts[2] + 1;
                        }
                        ++i;
                    }
                    CurrPeptides.clear();
                    if (this.Debug) {
                        Utils.WaitForEnter();
                    }
                    if (SeenPeptides.size() > Utils.MAX_STORED_PEPTIDES) {
                        System.out.println("Reached the max stored peptides, clearing the list");
                        SeenPeptides.clear();
                    }
                }
            }
            try {
                Line = InFile.readLine();
            }
            catch (IOException E) {
                E.printStackTrace();
                return;
            }
        }
        if (CurrPeptides.size() > 0) {
            System.out.println("We have " + CurrPeptides.size() + " leftover peptides to search...");
            String[] PeptidesToSearch = Utils.GetHashtableKeysString(CurrPeptides);
            Hashtable Locations = this.TrieFile.GetAllLocations(PeptidesToSearch);
            int i = 0;
            while (i < PeptidesToSearch.length) {
                if (this.Debug) {
                    System.out.println(PeptidesToSearch[i]);
                }
                boolean TargetFound = false;
                boolean DecoyFound = false;
                if (Locations.containsKey(PeptidesToSearch[i]) && ((ArrayList)Locations.get(PeptidesToSearch[i])).size() > 0) {
                    InspectAnnotation Ann;
                    int ProteinID = -1;
                    String ProteinName = "";
                    int TrieDBPos = -1;
                    ArrayList Locs = (ArrayList)Locations.get(PeptidesToSearch[i]);
                    int k = 0;
                    while (k < Locs.size()) {
                        Object[] Location = (Object[])Locs.get(k);
                        ProteinName = (String)Location[3];
                        if (this.Debug) {
                            System.out.println(String.valueOf(ProteinName) + "-IsDecoy: " + Utils.IsDecoyProtein(ProteinName));
                        }
                        if (Utils.IsDecoyProtein(ProteinName)) {
                            DecoyFound = true;
                        } else {
                            TargetFound = true;
                        }
                        ++k;
                    }
                    ArrayList Lines = (ArrayList)CurrPeptides.get(PeptidesToSearch[i]);
                    int CountIndex = -1;
                    CountIndex = DecoyFound && TargetFound ? 3 : (DecoyFound ? 1 : (TargetFound ? 0 : 2));
                    if (this.Debug) {
                        System.out.println("Value -> " + CountIndex);
                    }
                    SeenPeptides.put(PeptidesToSearch[i], new Integer(CountIndex));
                    boolean TargetPSM = false;
                    boolean DecoyPSM = false;
                    int j = 0;
                    while (j < Lines.size()) {
                        Ann = new InspectAnnotation((String)Lines.get(j), columnHeaders);
                        if (Utils.IsDecoyProtein(Ann.ProteinName)) {
                            if (CountIndex == 0 || CountIndex == 3) {
                                System.out.println("Oops: this decoy PSM was ID'd against the target DB!!");
                                System.out.println(Ann.toString());
                            }
                            DecoyPSM = true;
                            if (DecoyFound) {
                                try {
                                    OutFileKnown.write(String.valueOf(Ann.toString()) + "\n");
                                }
                                catch (IOException E) {
                                    E.printStackTrace();
                                    return;
                                }
                                int[] nArray = this.ModSpecCounts[1];
                                nArray[0] = nArray[0] + 1;
                            } else {
                                try {
                                    OutFileNovel.write(String.valueOf(Ann.toString()) + "\n");
                                }
                                catch (IOException E) {
                                    E.printStackTrace();
                                    return;
                                }
                                int[] nArray = this.ModSpecCounts[1];
                                nArray[1] = nArray[1] + 1;
                            }
                            int[] nArray = this.SpecCounts[1];
                            int n = CountIndex;
                            nArray[n] = nArray[n] + 1;
                        } else {
                            if (CountIndex == 1 || CountIndex == 3) {
                                System.out.println("Oops: this target PSM was ID'd against the decoy DB!!");
                                System.out.println(Ann.toString());
                            }
                            TargetPSM = true;
                            int[] nArray = this.SpecCounts[0];
                            int n = CountIndex;
                            nArray[n] = nArray[n] + 1;
                            if (TargetFound) {
                                try {
                                    OutFileKnown.write(String.valueOf(Ann.toString()) + "\n");
                                }
                                catch (IOException E) {
                                    E.printStackTrace();
                                    return;
                                }
                                int[] nArray6 = this.ModSpecCounts[0];
                                nArray6[0] = nArray6[0] + 1;
                            } else {
                                try {
                                    OutFileNovel.write(String.valueOf(Ann.toString()) + "\n");
                                }
                                catch (IOException E) {
                                    E.printStackTrace();
                                    return;
                                }
                                int[] nArray7 = this.ModSpecCounts[0];
                                nArray7[1] = nArray7[1] + 1;
                            }
                        }
                        ++j;
                    }
                    if (TargetPSM && DecoyPSM) {
                        System.out.println("CRAP: THIS Peptide was id'd with both decoy and target PSMs!!");
                        j = 0;
                        while (j < Lines.size()) {
                            Ann = new InspectAnnotation((String)Lines.get(j), columnHeaders);
                            System.out.println(Ann.toString());
                            ++j;
                        }
                        Utils.WaitForEnter();
                    }
                    int n = CountIndex;
                    this.PepCounts[n] = this.PepCounts[n] + 1;
                    if (this.Debug) {
                        Utils.WaitForEnter();
                    }
                } else {
                    InspectAnnotation Ann;
                    if (this.Debug) {
                        System.out.println(String.valueOf(PeptidesToSearch[i]) + " - NOVEL");
                    }
                    SeenPeptides.put(PeptidesToSearch[i], new Integer(1));
                    ArrayList Lines = (ArrayList)CurrPeptides.get(PeptidesToSearch[i]);
                    boolean TargetPSM = false;
                    boolean DecoyPSM = false;
                    int j = 0;
                    while (j < Lines.size()) {
                        Ann = new InspectAnnotation((String)Lines.get(j), columnHeaders);
                        if (this.Debug) {
                            System.out.println(String.valueOf(Ann.ProteinName) + "-IsDecoy: " + Utils.IsDecoyProtein(Ann.ProteinName) + ", Value = 2");
                        }
                        if (Utils.IsDecoyProtein(Ann.ProteinName)) {
                            DecoyPSM = true;
                            try {
                                OutFileNovel.write(String.valueOf(Ann.toString()) + "\n");
                            }
                            catch (IOException E) {
                                E.printStackTrace();
                                return;
                            }
                            int[] nArray = this.ModSpecCounts[1];
                            nArray[1] = nArray[1] + 1;
                            int[] nArray8 = this.SpecCounts[1];
                            nArray8[2] = nArray8[2] + 1;
                        } else {
                            TargetPSM = true;
                            try {
                                OutFileNovel.write(String.valueOf(Ann.toString()) + "\n");
                            }
                            catch (IOException E) {
                                E.printStackTrace();
                                return;
                            }
                            int[] nArray = this.ModSpecCounts[0];
                            nArray[1] = nArray[1] + 1;
                            int[] nArray9 = this.SpecCounts[0];
                            nArray9[2] = nArray9[2] + 1;
                        }
                        ++j;
                    }
                    if (TargetPSM && DecoyPSM) {
                        System.out.println("CRAP: THIS Peptide was id'd with both decoy and target PSMs!!");
                        j = 0;
                        while (j < Lines.size()) {
                            Ann = new InspectAnnotation((String)Lines.get(j), columnHeaders);
                            System.out.println(Ann.toString());
                            ++j;
                        }
                        Utils.WaitForEnter();
                    }
                    this.PepCounts[2] = this.PepCounts[2] + 1;
                }
                ++i;
            }
            CurrPeptides.clear();
            if (SeenPeptides.size() > Utils.MAX_STORED_PEPTIDES) {
                System.out.println("Reached the max stored peptides, clearing the list");
                SeenPeptides.clear();
            }
        }
        try {
            InFile.close();
            OutFileNovel.close();
            OutFileKnown.close();
        }
        catch (IOException E) {
            E.printStackTrace();
            return;
        }
        System.out.println("Total PSMs: " + AnnCount);
        System.out.println("Total peptides searched: " + SeenPeptides.size());
        String p = "\tKnownProteome\tDecoyProteome\tNovel\tBothProteomes\n";
        p = String.valueOf(p) + "TargetPSMs\t" + this.SpecCounts[0][0] + "\t" + this.SpecCounts[0][1] + "\t" + this.SpecCounts[0][2] + "\t" + this.SpecCounts[0][3] + "\n";
        p = String.valueOf(p) + "DecoyPSMs\t" + this.SpecCounts[1][0] + "\t" + this.SpecCounts[1][1] + "\t" + this.SpecCounts[1][2] + "\t" + this.SpecCounts[1][3] + "\n";
        p = String.valueOf(p) + "Peptides\t" + this.PepCounts[0] + "\t" + this.PepCounts[1] + "\t" + this.PepCounts[2] + "\t" + this.PepCounts[3] + "\n";
        p = String.valueOf(p) + "\n";
        p = String.valueOf(p) + "SeparateTargetPSMs\t" + this.ModSpecCounts[0][0] + "\t" + this.ModSpecCounts[0][1] + "\n";
        p = String.valueOf(p) + "SeparateDecoyPSMs\t" + this.ModSpecCounts[1][0] + "\t" + this.ModSpecCounts[1][1] + "\n";
        System.out.println(p);
    }

    public static void main(String[] args) {
        String[] options = new String[]{"-r", "-k", "-d", "-w", "-n", "-f"};
        boolean[] blArray = new boolean[6];
        blArray[0] = true;
        blArray[1] = true;
        blArray[3] = true;
        blArray[4] = true;
        boolean[] values = blArray;
        Hashtable CommandLineArgs = Utils.ParseCommandLine(args, options, values);
        if (!(CommandLineArgs.containsKey("-r") && CommandLineArgs.containsKey("-k") && CommandLineArgs.containsKey("-w") && CommandLineArgs.containsKey("-n"))) {
            System.err.println("ERROR: Must specify an input file, a proteome file, and output files!");
            System.err.println(UsageInfo);
            System.exit(0);
        }
        boolean Debug = CommandLineArgs.containsKey("-d");
        DetermineDecoyTargetKnown d = new DetermineDecoyTargetKnown((String)CommandLineArgs.get("-r"), (String)CommandLineArgs.get("-k"), (String)CommandLineArgs.get("-w"), (String)CommandLineArgs.get("-n"));
        d.Debug = Debug;
        if (CommandLineArgs.containsKey("-f")) {
            d.UseFlankingMasses = true;
        }
        d.Run();
    }
}

