/*
 * Decompiled with CFR 0.152.
 */
package proteogenomicUtils;

import basicUtils.InspectAnnotation;
import basicUtils.Utils;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.Hashtable;
import proteogenomicUtils.GenomicLocator;

public class GeneralCounter {
    public static final String UsageInfo = "java stats.GeneralCounter\n[Required]:\n-r [DIR/FILE] File or directory containing Inspect or location results\n-t [NUM] Type of file: Inspect (0), or genomic location (1)\n";
    private String[] FileNames = null;
    private String CompareFile = null;
    private int FileType = -1;

    public GeneralCounter(String InputDir, int FileType2, String CompareFile) {
        if (Utils.IsFile(InputDir)) {
            this.FileNames = new String[1];
            this.FileNames[0] = InputDir;
        } else {
            this.FileNames = Utils.ListDir(InputDir);
        }
        this.FileType = FileType2;
        this.CompareFile = CompareFile;
        System.out.println("CompareFile: " + this.CompareFile);
    }

    public void Run() {
        if (this.FileType == 1) {
            this.RunWithLocations();
            return;
        }
        Hashtable<String, Integer> ModdedPeptides = new Hashtable<String, Integer>();
        Hashtable<String, Integer> Peptides = new Hashtable<String, Integer>();
        int i = 0;
        while (i < this.FileNames.length) {
            System.out.println("Considering file " + this.FileNames[i]);
            InspectAnnotation[] Anns = InspectAnnotation.LoadInspectResultsFile(this.FileNames[i]);
            System.out.println("   " + Anns.length + " PSMs");
            Hashtable<String, Integer> LocalPeps = new Hashtable<String, Integer>();
            Hashtable<String, Integer> LocalModded = new Hashtable<String, Integer>();
            int j = 0;
            while (j < Anns.length) {
                LocalPeps.put(Utils.GetUnModded(Anns[j].Annotation), new Integer(1));
                Peptides.put(Utils.GetUnModded(Anns[j].Annotation), new Integer(1));
                LocalModded.put(Anns[j].Annotation, new Integer(1));
                ModdedPeptides.put(Anns[j].Annotation, new Integer(1));
                ++j;
            }
            System.out.println("   " + LocalPeps.size() + " peptide sequences");
            System.out.println("   " + LocalModded.size() + " modification forms");
            ++i;
        }
        System.out.println("Total : " + Peptides.size() + " peptide sequences");
        System.out.println("Total : " + ModdedPeptides.size() + " modification forms");
        if (this.CompareFile != null) {
            System.out.println("Comparing with " + this.CompareFile);
            InspectAnnotation[] OtherAnns = InspectAnnotation.LoadInspectResultsFile(this.CompareFile);
            System.out.println("   " + OtherAnns.length + " PSMs in other file");
            int i2 = 0;
            while (i2 < OtherAnns.length) {
                if (!Peptides.containsKey(Utils.GetUnModded(OtherAnns[i2].Annotation))) {
                    System.out.println("File A does not contain unmodded peptide form of " + OtherAnns[i2].Annotation);
                    System.out.println(OtherAnns[i2].toString());
                    Utils.WaitForEnter();
                }
                if (!ModdedPeptides.containsKey(OtherAnns[i2].Annotation)) {
                    System.out.println("File A does not contain modded peptide form of " + OtherAnns[i2].Annotation);
                    System.out.println(OtherAnns[i2].toString());
                    Utils.WaitForEnter();
                }
                ++i2;
            }
        }
    }

    public void RunWithLocations() {
        Hashtable<String, Integer> ModdedPeptides = new Hashtable<String, Integer>();
        Hashtable<String, Integer> Peptides = new Hashtable<String, Integer>();
        BufferedReader b = null;
        String Line = null;
        int PSMCount = 0;
        int i = 0;
        while (i < this.FileNames.length) {
            System.out.println("Considering file " + this.FileNames[i]);
            try {
                b = new BufferedReader(new FileReader(this.FileNames[i]));
                Line = b.readLine();
            }
            catch (IOException E) {
                E.printStackTrace();
                System.exit(-1);
            }
            Hashtable<String, Integer> LocalPeps = new Hashtable<String, Integer>();
            Hashtable<String, Integer> LocalModded = new Hashtable<String, Integer>();
            while (Line != null) {
                if ((Line = Line.trim()).length() == 0 || Line.charAt(0) == '#') {
                    try {
                        Line = b.readLine();
                    }
                    catch (IOException E) {
                        E.printStackTrace();
                        System.exit(-1);
                    }
                    continue;
                }
                Object[] Location = GenomicLocator.GenomicColumns.LoadFromString(Line);
                ++PSMCount;
                String Annotation = (String)Location[GenomicLocator.GenomicColumns.Peptide];
                if (Annotation.indexOf(46) >= 0) {
                    Annotation = Annotation.substring(2, Annotation.length() - 2);
                }
                String UnModdedAnn = Utils.GetUnModded(Annotation);
                System.out.println(String.valueOf(Annotation) + " -> " + UnModdedAnn);
                LocalPeps.put(UnModdedAnn, new Integer(1));
                Peptides.put(UnModdedAnn, new Integer(1));
                LocalModded.put(Annotation, new Integer(1));
                ModdedPeptides.put(Annotation, new Integer(1));
                try {
                    Line = b.readLine();
                }
                catch (IOException E) {
                    E.printStackTrace();
                    System.exit(-1);
                }
            }
            try {
                b.close();
            }
            catch (IOException E) {
                E.printStackTrace();
                System.exit(-1);
            }
            System.out.println("   " + PSMCount + " Locations");
            System.out.println("   " + LocalPeps.size() + " peptide sequences");
            System.out.println("   " + LocalModded.size() + " modification forms");
            ++i;
        }
        System.out.println("Total : " + Peptides.size() + " peptide sequences");
        System.out.println("Total : " + ModdedPeptides.size() + " modification forms");
        if (this.CompareFile != null) {
            System.out.println("Comparing with " + this.CompareFile);
            InspectAnnotation[] OtherAnns = InspectAnnotation.LoadInspectResultsFile(this.CompareFile);
            System.out.println("   " + OtherAnns.length + " PSMs in other file");
            int i2 = 0;
            while (i2 < OtherAnns.length) {
                if (!Peptides.containsKey(Utils.GetUnModded(OtherAnns[i2].Annotation))) {
                    System.out.println("File A does not contain unmodded peptide form of " + OtherAnns[i2].Annotation);
                    System.out.println(OtherAnns[i2].toString());
                    Utils.WaitForEnter();
                }
                if (!ModdedPeptides.containsKey(OtherAnns[i2].Annotation)) {
                    System.out.println("File A does not contain modded peptide form of " + OtherAnns[i2].Annotation);
                    System.out.println(OtherAnns[i2].toString());
                    Utils.WaitForEnter();
                }
                ++i2;
            }
        }
    }

    public static void main(String[] args) {
        String[] options = new String[]{"-r", "-t", "-b"};
        boolean[] values = new boolean[]{true, true, true};
        Hashtable CommandLineArgs = Utils.ParseCommandLine(args, options, values);
        if (!CommandLineArgs.containsKey("-r")) {
            System.err.println("ERROR: Must specify an input directory or file\n");
            System.out.println(UsageInfo);
            return;
        }
        if (!CommandLineArgs.containsKey("-t")) {
            System.err.println("ERROR: Must specify a file type\n");
            System.out.println(UsageInfo);
            return;
        }
        String InputDir = (String)CommandLineArgs.get("-r");
        if (!Utils.IsFile(InputDir) && !Utils.IsDir(InputDir)) {
            System.err.println("ERROR: Input file/dir '" + InputDir + "' is an invalid file/dir name\n");
            System.out.println(UsageInfo);
            return;
        }
        int FileType2 = Integer.parseInt((String)CommandLineArgs.get("-t"));
        if (FileType2 != 0 && FileType2 != 1) {
            System.err.println("ERROR: Invalid filetype input '" + FileType2 + "'!\n");
            System.out.println(UsageInfo);
            return;
        }
        String OtherWoman = null;
        if (CommandLineArgs.containsKey("-b") && !Utils.IsFile(OtherWoman = (String)CommandLineArgs.get("-b"))) {
            System.err.println("ERROR: Comparison file '" + OtherWoman + "' is an invalid file\n");
            System.out.println(UsageInfo);
            return;
        }
        GeneralCounter g = new GeneralCounter(InputDir, FileType2, OtherWoman);
        g.Run();
    }
}

