/*
 * Decompiled with CFR 0.152.
 */
package proteogenomicUtils;

import java.util.ArrayList;
import proteogenomicUtils.GenomicLocator;

public class PeptideCluster {
    private ArrayList NovelLocations;
    private ArrayList KnownLocations;
    private int ClusterType = ClusterTypes.Unknown;
    private int ClusterNumber = 0;
    private String SequenceName;
    private int Strand;
    private int UniqueNovelCount = 0;
    private int UniqueCount = 0;

    public PeptideCluster(int ClusterNumber, int ClusterType, String SequenceName, int Strand) {
        this.ClusterNumber = ClusterNumber;
        this.ClusterType = ClusterType;
        this.SequenceName = SequenceName;
        this.Strand = Strand;
    }

    public void AddNewLocation(Object[] Loc) {
        boolean IsNovel = (Boolean)Loc[GenomicLocator.GenomicColumns.IsNovel];
        boolean IsUnique = (Boolean)Loc[GenomicLocator.GenomicColumns.IsUnique];
        if (IsNovel) {
            if (this.NovelLocations == null) {
                this.NovelLocations = new ArrayList();
            }
            this.NovelLocations.add(Loc);
            if (IsUnique) {
                ++this.UniqueNovelCount;
            }
        } else {
            if (this.KnownLocations == null) {
                this.KnownLocations = new ArrayList();
            }
            this.KnownLocations.add(Loc);
        }
        if (IsUnique) {
            ++this.UniqueCount;
        }
    }

    public String ExportToGFF() {
        Object[] Loc;
        String Ret = "";
        Ret = String.valueOf(Ret) + "#Cluster " + this.ClusterNumber + "\n";
        int i = 0;
        while (this.NovelLocations != null && i < this.NovelLocations.size()) {
            Loc = (Object[])this.NovelLocations.get(i);
            Ret = String.valueOf(Ret) + this.ExportLocationToGff(Loc);
            ++i;
        }
        i = 0;
        while (this.KnownLocations != null && i < this.KnownLocations.size()) {
            Loc = (Object[])this.KnownLocations.get(i);
            Ret = String.valueOf(Ret) + this.ExportLocationToGff(Loc);
            ++i;
        }
        return Ret;
    }

    private String ExportLocationToGff(Object[] Loc) {
        String Ret = "";
        Ret = String.valueOf(Ret) + this.SequenceName + "\tGenomeClusterer\tCDS\t";
        Ret = String.valueOf(Ret) + ((Integer)Loc[GenomicLocator.GenomicColumns.Start] + 1) + "\t";
        Ret = String.valueOf(Ret) + (Integer)Loc[GenomicLocator.GenomicColumns.End] + "\t";
        Ret = String.valueOf(Ret) + (Double)Loc[GenomicLocator.GenomicColumns.BestFDR] + "\t";
        Ret = this.Strand == 0 ? String.valueOf(Ret) + "-\t0\t" : String.valueOf(Ret) + "+\t0\t";
        boolean IsNovel = (Boolean)Loc[GenomicLocator.GenomicColumns.IsNovel];
        boolean IsUnique = (Boolean)Loc[GenomicLocator.GenomicColumns.IsUnique];
        Ret = String.valueOf(Ret) + "IsNovel=\"" + IsNovel + "\";IsUnique=\"" + IsUnique + "\";ClusterNum=\"" + this.ClusterNumber + "\";ClusterType=\"" + ClusterTypes.TypeNames[this.ClusterType] + "\";";
        int NovelLocs = 0;
        if (this.NovelLocations != null) {
            NovelLocs = this.NovelLocations.size();
        }
        int KnownLocs = 0;
        if (this.KnownLocations != null) {
            KnownLocs = this.KnownLocations.size();
        }
        Ret = String.valueOf(Ret) + "NovelLocs=\"" + NovelLocs + "\";KnownLocs=\"" + KnownLocs + "\";UniqueLocs=\"" + this.UniqueCount + "\";NovelUniqueLocs=\"" + this.UniqueNovelCount + "\"\n";
        return Ret;
    }

    public void DebugPrint() {
        Object[] Loc;
        int i;
        System.out.println("#ClusterNumber: " + this.ClusterNumber + " on Seq: " + this.SequenceName + " Strand: " + this.Strand);
        System.out.println("ClusterType: " + ClusterTypes.TypeNames[this.ClusterType]);
        System.out.println("UniqueCount: " + this.UniqueCount + ", UniqueNovelCount: " + this.UniqueNovelCount);
        if (this.NovelLocations != null) {
            System.out.println("Novel Locations: " + this.NovelLocations.size());
            i = 0;
            while (i < this.NovelLocations.size()) {
                Loc = (Object[])this.NovelLocations.get(i);
                System.out.println(GenomicLocator.GenomicColumns.toString(Loc, " "));
                ++i;
            }
        }
        if (this.KnownLocations != null) {
            System.out.println("Known Locations: " + this.KnownLocations.size());
            i = 0;
            while (i < this.KnownLocations.size()) {
                Loc = (Object[])this.KnownLocations.get(i);
                System.out.println(GenomicLocator.GenomicColumns.toString(Loc, " "));
                ++i;
            }
        }
    }

    public static class ClusterTypes {
        public static int Unknown = 0;
        public static int Intergenic = 1;
        public static int IntragenicWS = 2;
        public static int IntragenicFS = 3;
        public static String[] TypeNames = new String[]{"Unknown", "Intergenic", "IntragenicWS", "IntragenicFS"};
    }
}

