/*
 * Decompiled with CFR 0.152.
 */
package proteogenomicUtils;

import basicUtils.Utils;
import errorUtils.ErrorThrower;
import java.io.BufferedReader;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.Hashtable;
import proteogenomicUtils.EventFinder;
import proteogenomicUtils.ProteogenomicUtils;

public class PredictionSupportAssessor {
    public static String usageInfo = "proteogenomicUtils.PredictionSupportAssessor version 2012.03.22\nTakes the summary table from AUGUSTUSRunner.jar and the event table to determine if the peptides support\nthe predictions\nUsage:\n-r [FILE] AUGUSTUS summary table file\n-e [FILE] Event table used to create augustus instances\n-w [FILE] Updated summary table containing peptides supported\n(-t [FILE] Translation file to map event file names (transcripts) to gene names\n(-c [NUM] Column in translation file of transcript name (default:2))\n(-n [NUM] Column in translation file of gene name (default: 1))\n(-y The events are from PLGs)\n";
    private boolean debug = false;
    private String augustusFileName;
    private String eventFileName;
    private String outputFileName;
    private int tranColNum = 2;
    private int geneColNum = 1;
    private String translationFileName = null;
    private boolean arePLGs = false;

    public PredictionSupportAssessor(String augustusFileName, String eventFileName, String outputFileName, String translationFileName, int tranColNum, int geneColNum) {
        if (!Utils.IsFile(augustusFileName)) {
            ErrorThrower.ThrowError(1, augustusFileName);
        }
        this.augustusFileName = augustusFileName;
        if (!Utils.IsFile(eventFileName)) {
            ErrorThrower.ThrowError(1, eventFileName);
        }
        if (translationFileName != null && !Utils.IsFile(translationFileName)) {
            ErrorThrower.ThrowError(1, translationFileName);
        }
        this.translationFileName = translationFileName;
        if (tranColNum < 0) {
            ErrorThrower.ThrowError(4, "Transcript column number must be non-negative");
        }
        if (geneColNum < 0) {
            ErrorThrower.ThrowError(4, "Gene name column number must be non-negative");
        }
        this.tranColNum = tranColNum;
        this.geneColNum = geneColNum;
        this.eventFileName = eventFileName;
        this.outputFileName = outputFileName;
    }

    public static void main(String[] args) {
        String[] options = new String[]{"-r", "-w", "-e", "-d", "-t", "-c", "-n", "-y"};
        boolean[] blArray = new boolean[8];
        blArray[0] = true;
        blArray[1] = true;
        blArray[2] = true;
        blArray[4] = true;
        blArray[5] = true;
        blArray[6] = true;
        boolean[] values = blArray;
        Hashtable CommandLineArgs = Utils.ParseCommandLine(args, options, values);
        if (!(CommandLineArgs.containsKey("-r") && CommandLineArgs.containsKey("-w") && CommandLineArgs.containsKey("-e"))) {
            System.err.println("ERROR: Must specify an AUGUSTUS summary file (-r), an event table file (-e), and an output file (-w)!");
            System.err.println(usageInfo);
            System.exit(0);
        }
        String augustusFileName = (String)CommandLineArgs.get("-r");
        String eventFileName = (String)CommandLineArgs.get("-e");
        String outputFileName = (String)CommandLineArgs.get("-w");
        int tranColNum = 2;
        int geneColNum = 1;
        String translationFileName = null;
        if (CommandLineArgs.containsKey("-t")) {
            translationFileName = (String)CommandLineArgs.get("-t");
        }
        if (CommandLineArgs.containsKey("-c")) {
            tranColNum = Integer.parseInt((String)CommandLineArgs.get("-c"));
        }
        if (CommandLineArgs.containsKey("-n")) {
            geneColNum = Integer.parseInt((String)CommandLineArgs.get("-n"));
        }
        PredictionSupportAssessor a = new PredictionSupportAssessor(augustusFileName, eventFileName, outputFileName, translationFileName, tranColNum, geneColNum);
        if (CommandLineArgs.containsKey("-d")) {
            a.debug = true;
        }
        if (CommandLineArgs.containsKey("-y")) {
            a.arePLGs = true;
        }
        a.assess();
    }

    private void assess() {
        Hashtable translator = null;
        if (this.translationFileName != null) {
            translator = ProteogenomicUtils.loadTranslationFileMany(this.translationFileName, this.geneColNum, this.tranColNum);
        }
        String[] geneNames = null;
        if (translator != null) {
            geneNames = Utils.GetHashtableKeysString(translator);
        }
        Hashtable events = EventFinder.loadEventPeptidesFromTableFile(this.eventFileName, !this.arePLGs, this.arePLGs);
        String[] eNames = Utils.GetHashtableKeysString(events);
        BufferedReader buf = Utils.openBufferedReader(this.augustusFileName);
        FileWriter f = Utils.openFileWriter(this.outputFileName);
        String line = Utils.readNextLine(buf, this.augustusFileName);
        while (line != null) {
            if ((line = line.trim()).length() == 0 || line.charAt(0) == '#') {
                line = Utils.readNextLine(buf, this.augustusFileName);
            }
            String[] bits = line.split("\t");
            String locusName = bits[0];
            int supportCount = 0;
            String supporters = "";
            String seq = bits[7];
            if (translator != null && translator.containsKey(locusName)) {
                ArrayList tNames = (ArrayList)translator.get(locusName);
                int j = 0;
                while (j < tNames.size()) {
                    String currTName = ((String)tNames.get(j)).toLowerCase();
                    if (events.containsKey(currTName)) {
                        String[] peptides = (String[])events.get(currTName);
                        int k = 0;
                        while (k < peptides.length) {
                            if (seq.indexOf(peptides[k]) >= 0) {
                                if (++supportCount > 1) {
                                    supporters = String.valueOf(supporters) + ",";
                                }
                                supporters = String.valueOf(supporters) + peptides[k];
                            }
                            ++k;
                        }
                    }
                    ++j;
                }
            } else if (translator != null && locusName.indexOf("chr") < 0) {
                int foundCount = 0;
                ArrayList<String> fullNames = new ArrayList<String>();
                int i = 0;
                while (i < geneNames.length) {
                    if (geneNames[i].indexOf(locusName) == 0) {
                        ++foundCount;
                        fullNames.add(geneNames[i]);
                    }
                    ++i;
                }
                if (foundCount > 0) {
                    int g = 0;
                    while (g < fullNames.size()) {
                        String fullName = (String)fullNames.get(g);
                        ArrayList tNames = (ArrayList)translator.get(fullName);
                        int j = 0;
                        while (j < tNames.size()) {
                            String currTName = ((String)tNames.get(j)).toLowerCase();
                            if (events.containsKey(currTName)) {
                                String[] peptides = (String[])events.get(currTName);
                                int k = 0;
                                while (k < peptides.length) {
                                    if (seq.indexOf(peptides[k]) >= 0) {
                                        if (++supportCount > 1) {
                                            supporters = String.valueOf(supporters) + ",";
                                        }
                                        supporters = String.valueOf(supporters) + peptides[k];
                                    }
                                    ++k;
                                }
                            }
                            ++j;
                        }
                        ++g;
                    }
                } else {
                    ErrorThrower.ThrowWarning(13, locusName);
                }
            } else {
                String currTName = locusName.toLowerCase();
                if (events.containsKey(currTName)) {
                    String[] peptides = (String[])events.get(currTName);
                    int k = 0;
                    while (k < peptides.length) {
                        if (seq.indexOf(peptides[k]) >= 0) {
                            if (++supportCount > 1) {
                                supporters = String.valueOf(supporters) + ",";
                            }
                            supporters = String.valueOf(supporters) + peptides[k];
                        }
                        ++k;
                    }
                } else {
                    String[] lBits = locusName.split("[.]");
                    lBits[1] = lBits[1].equals("+") ? "1" : (lBits[1].equals("1") ? "+" : (lBits[1].equals("-") ? "0" : "-"));
                    locusName = Utils.JoinStringArray(lBits, ".");
                    currTName = locusName.toLowerCase();
                    if (events.containsKey(currTName)) {
                        String[] peptides = (String[])events.get(currTName);
                        int k = 0;
                        while (k < peptides.length) {
                            if (seq.indexOf(peptides[k]) >= 0) {
                                if (++supportCount > 1) {
                                    supporters = String.valueOf(supporters) + ",";
                                }
                                supporters = String.valueOf(supporters) + peptides[k];
                            }
                            ++k;
                        }
                    } else {
                        System.out.println("SHIT! Couldn't lookup peptides for : " + locusName);
                    }
                }
            }
            String outLine = String.valueOf(line) + "\t" + supportCount + "\t" + supporters + "\n";
            Utils.writeLine(f, this.outputFileName, outLine);
            line = Utils.readNextLine(buf, this.augustusFileName);
        }
        Utils.closeBufferedReader(buf, this.augustusFileName);
        Utils.closeFileWriter(f, this.outputFileName);
    }
}

