/*
 * Decompiled with CFR 0.152.
 */
package quantUtils;

import basicUtils.Utils;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import trieUtils.TrieDB;

public class SpecCountNormalizer {
    private static final double NORMALIZED_COUNT = 1000000.0;
    public static String usageInfo = "SpecCountNormalizer\n Normalizes spectra counts to 1,000,000 within each dataset, and if a \n grouping file is provided, a summed result can be computed for replicates\nUsage java -jar SpecCountNormalizer.jar\n -r [FILE] spectral count file with experiments listed in the header\n -w [FILE] file to write normalized/summed spectral counts\n(-g [FILE] dataset providing replicate information)\n(-t [FILE] Trie file of proteins for protein quantification\n(-d Run in debug mod)\n";
    private String inputFileName;
    private String outputFileName;
    private String replicateFileName;
    private int numDatasets;
    private double[] totalCounts;
    private String[] dataSetNames;
    private Hashtable replicateMap;
    private int[] dataset2Sample;
    private String[] replicateNames;
    private double[] scaleFactor;
    private int numSamples;
    private boolean debug = false;
    private TrieDB trieDB;
    private Hashtable peptide2ProteinHash;
    private Hashtable proteinCounts;
    private Hashtable protein2Peptide;
    private Hashtable sharedPeptide2ProteinHash;

    public SpecCountNormalizer(String inputFile, String outputFile, String replicateFile, String trieFileName) {
        if (!Utils.IsFile(inputFile)) {
            System.err.println("ERROR: Invalid input file '" + inputFile + "'!!");
            System.exit(-1);
        }
        if (replicateFile != null && !Utils.IsFile(replicateFile)) {
            System.err.println("ERROR: Invalid replicate file '" + replicateFile + "'!!");
            System.exit(-1);
        }
        if (trieFileName != null && !Utils.IsFile(trieFileName)) {
            System.err.println("ERROR: Invalid triel file '" + trieFileName + "'!!");
            System.exit(-1);
        } else {
            this.trieDB = new TrieDB(trieFileName);
            System.out.println("Comparing to trie with " + this.trieDB.getNumProteins() + " proteins");
        }
        this.inputFileName = inputFile;
        this.outputFileName = outputFile;
        this.replicateFileName = replicateFile;
    }

    public static void main(String[] args) {
        String[] options = new String[]{"-r", "-w", "-g", "-d", "-t"};
        boolean[] blArray = new boolean[5];
        blArray[0] = true;
        blArray[1] = true;
        blArray[2] = true;
        blArray[4] = true;
        boolean[] values = blArray;
        Hashtable CommandLineArgs = Utils.ParseCommandLine(args, options, values);
        if (!CommandLineArgs.containsKey("-r") || !CommandLineArgs.containsKey("-w")) {
            System.err.println("ERROR: Must specify an input file and an output file!");
            System.err.println(usageInfo);
            System.exit(0);
        }
        String inputFile = (String)CommandLineArgs.get("-r");
        String outputFile = (String)CommandLineArgs.get("-w");
        String replicateFile = null;
        if (CommandLineArgs.containsKey("-g")) {
            replicateFile = (String)CommandLineArgs.get("-g");
        }
        String trieFileName = null;
        if (CommandLineArgs.containsKey("-t")) {
            trieFileName = (String)CommandLineArgs.get("-t");
        }
        SpecCountNormalizer sC = new SpecCountNormalizer(inputFile, outputFile, replicateFile, trieFileName);
        if (CommandLineArgs.containsKey("-d")) {
            sC.debug = true;
        }
        sC.normalize();
    }

    private void normalize() {
        this.loadTotalCounts();
        this.processResults();
        if (this.trieDB != null) {
            this.countPhosphoSites();
        }
    }

    private void countPhosphoSites() {
        int totalSites = 0;
        int totalMSites = 0;
        int totalQSites = 0;
        Enumeration protKeys = this.proteinCounts.keys();
        while (protKeys.hasMoreElements()) {
            ArrayList<Integer> listOfSites = new ArrayList<Integer>();
            ArrayList<Integer> listOfMSites = new ArrayList<Integer>();
            ArrayList<Integer> listOfQSites = new ArrayList<Integer>();
            String protLine = "";
            int protID = (Integer)protKeys.nextElement();
            String protName = this.trieDB.getProteinName(protID);
            String protSequence = this.trieDB.getProteinSequence(protID);
            String[] peps = ((String)this.protein2Peptide.get(new Integer(protID))).split(",");
            int i = 0;
            while (i < peps.length) {
                String currPep = peps[i].split(":")[0];
                if (!currPep.equals(currPep.toUpperCase())) {
                    String pepSeq = currPep.toUpperCase();
                    int index = protSequence.indexOf(pepSeq);
                    if (index < 0) {
                        System.err.println("FUCK!! Couldn't find '" + currPep + "' in " + protSequence);
                        Utils.WaitForEnter();
                    }
                    int j = 0;
                    while (j < pepSeq.length()) {
                        if (pepSeq.charAt(j) != currPep.charAt(j)) {
                            Integer site = new Integer(index + j);
                            if (currPep.charAt(j) == 's' || currPep.charAt(j) == 't' || currPep.charAt(j) == 'y') {
                                if (!listOfSites.contains(site)) {
                                    listOfSites.add(site);
                                }
                            } else if (currPep.charAt(j) == 'm') {
                                if (!listOfMSites.contains(site)) {
                                    listOfMSites.add(site);
                                }
                            } else if (currPep.charAt(j) == 'q') {
                                if (!listOfQSites.contains(site)) {
                                    listOfQSites.add(site);
                                }
                            } else {
                                System.err.println("WARNING: Unexpected modification in " + currPep);
                                Utils.WaitForEnter();
                            }
                        }
                        ++j;
                    }
                }
                ++i;
            }
            totalSites += listOfSites.size();
            totalMSites += listOfMSites.size();
            totalQSites += listOfQSites.size();
        }
        System.out.println("Total phospho sites: " + totalSites);
        System.out.println("Total oxiM sites: " + totalMSites);
        System.out.println("Total pyroQ sites: " + totalQSites);
    }

    private void loadTotalCounts() {
        BufferedReader buf = null;
        String line = null;
        try {
            buf = new BufferedReader(new FileReader(this.inputFileName));
            line = buf.readLine();
        }
        catch (IOException E) {
            E.printStackTrace();
            System.exit(-1);
        }
        int lostPeptides = 0;
        ArrayList<String> currPeptides = new ArrayList<String>();
        while (line != null) {
            String[] bits;
            if ((line = line.trim()).length() == 0) {
                try {
                    line = buf.readLine();
                }
                catch (IOException E) {
                    E.printStackTrace();
                    System.exit(-1);
                }
                continue;
            }
            if (line.charAt(0) == '#') {
                bits = line.split("\t");
                this.numDatasets = bits.length - 3;
                this.dataSetNames = new String[this.numDatasets];
                int i = 0;
                while (i < this.dataSetNames.length) {
                    this.dataSetNames[i] = bits[i + 3];
                    if (this.dataSetNames[i].indexOf(".SpecCount") >= 0) {
                        this.dataSetNames[i] = this.dataSetNames[i].substring(0, this.dataSetNames[i].indexOf(".SpecCount"));
                    }
                    ++i;
                }
                System.out.println("Identified " + this.numDatasets + " datasets!");
                if (this.replicateFileName != null) {
                    this.loadReplicateInfo();
                    this.numSamples = this.replicateMap.size();
                } else {
                    this.numSamples = this.numDatasets;
                    this.dataset2Sample = new int[this.numSamples];
                    i = 0;
                    while (i < this.numSamples) {
                        this.dataset2Sample[i] = i;
                        ++i;
                    }
                }
                this.totalCounts = new double[this.numSamples];
                this.scaleFactor = new double[this.numSamples];
            } else {
                if (this.totalCounts == null) {
                    System.err.println("ERROR: We've encountered a line with data, before the header!!!");
                    System.err.println(line);
                    try {
                        line = buf.readLine();
                    }
                    catch (IOException E) {
                        E.printStackTrace();
                        System.exit(-1);
                    }
                    continue;
                }
                bits = line.split("\t");
                int i = 0;
                while (i < this.numDatasets) {
                    int sampleIndex;
                    int n = sampleIndex = this.dataset2Sample[i];
                    this.totalCounts[n] = this.totalCounts[n] + (double)Integer.parseInt(bits[i + 3]);
                    ++i;
                }
                if (this.trieDB != null && !currPeptides.contains(bits[0].toUpperCase())) {
                    currPeptides.add(bits[0].toUpperCase());
                }
                if (this.trieDB != null && currPeptides.size() >= 5000) {
                    Hashtable Locations = this.trieDB.GetAllLocations(Utils.ConvertArraylistToStringArray(currPeptides));
                    if (this.peptide2ProteinHash == null) {
                        this.peptide2ProteinHash = new Hashtable();
                    }
                    if (this.proteinCounts == null) {
                        this.proteinCounts = new Hashtable();
                    }
                    if (this.protein2Peptide == null) {
                        this.protein2Peptide = new Hashtable();
                    }
                    if (this.sharedPeptide2ProteinHash == null) {
                        this.sharedPeptide2ProteinHash = new Hashtable();
                    }
                    int i2 = 0;
                    while (i2 < currPeptides.size()) {
                        String currPep = (String)currPeptides.get(i2);
                        if (!this.peptide2ProteinHash.containsKey(currPep) && !this.sharedPeptide2ProteinHash.containsKey(currPep)) {
                            if (!Locations.containsKey(currPep)) {
                                ++lostPeptides;
                            } else {
                                ArrayList locs = (ArrayList)Locations.get(currPep);
                                if (locs == null) {
                                    ++lostPeptides;
                                } else if (locs.size() > 1) {
                                    int[] protIDs = new int[locs.size()];
                                    int p = 0;
                                    while (p < protIDs.length) {
                                        Object[] loc = (Object[])locs.get(p);
                                        protIDs[p] = (Integer)loc[1];
                                        ++p;
                                    }
                                    this.sharedPeptide2ProteinHash.put(currPep, protIDs);
                                } else {
                                    Object[] uniqueLoc = (Object[])locs.get(0);
                                    Integer protID = (Integer)uniqueLoc[1];
                                    this.peptide2ProteinHash.put(currPep, protID);
                                    if (!this.proteinCounts.containsKey(protID)) {
                                        double[] countArray = new double[this.numSamples];
                                        this.proteinCounts.put(protID, countArray);
                                    }
                                }
                            }
                        }
                        ++i2;
                    }
                    currPeptides.clear();
                }
            }
            try {
                line = buf.readLine();
            }
            catch (IOException E) {
                E.printStackTrace();
                System.exit(-1);
            }
        }
        if (this.trieDB != null && currPeptides.size() > 0) {
            Hashtable Locations = this.trieDB.GetAllLocations(Utils.ConvertArraylistToStringArray(currPeptides));
            if (this.peptide2ProteinHash == null) {
                this.peptide2ProteinHash = new Hashtable();
            }
            if (this.proteinCounts == null) {
                this.proteinCounts = new Hashtable();
            }
            int i = 0;
            while (i < currPeptides.size()) {
                String currPep = (String)currPeptides.get(i);
                if (!this.peptide2ProteinHash.containsKey(currPep)) {
                    if (!Locations.containsKey(currPep)) {
                        ++lostPeptides;
                    } else {
                        ArrayList locs = (ArrayList)Locations.get(currPep);
                        if (locs == null) {
                            ++lostPeptides;
                        } else if (locs.size() > 1) {
                            int[] protIDs = new int[locs.size()];
                            int p = 0;
                            while (p < protIDs.length) {
                                Object[] loc = (Object[])locs.get(p);
                                protIDs[p] = (Integer)loc[1];
                                ++p;
                            }
                            this.sharedPeptide2ProteinHash.put(currPep, protIDs);
                        } else {
                            Object[] uniqueLoc = (Object[])locs.get(0);
                            Integer protID = (Integer)uniqueLoc[1];
                            this.peptide2ProteinHash.put(currPep, protID);
                            if (!this.proteinCounts.containsKey(protID)) {
                                double[] countArray = new double[this.numSamples];
                                this.proteinCounts.put(protID, countArray);
                            }
                        }
                    }
                }
                ++i;
            }
            currPeptides.clear();
        }
        try {
            buf.close();
        }
        catch (IOException E) {
            E.printStackTrace();
            System.exit(-1);
        }
        int i = 0;
        while (i < this.totalCounts.length) {
            this.scaleFactor[i] = 1000000.0 / this.totalCounts[i];
            if (this.replicateFileName != null) {
                System.out.print(String.valueOf(this.replicateNames[i]) + " ");
                System.out.print(String.valueOf(((int[])this.replicateMap.get(this.replicateNames[i])).length) + " ");
            } else {
                System.out.print(String.valueOf(this.dataSetNames[i]) + " 1 ");
            }
            System.out.println(this.totalCounts[i]);
            ++i;
        }
        if (this.trieDB != null) {
            System.out.println("Total peptides with unique locations: " + this.peptide2ProteinHash.size());
            System.out.println("Total proteins ID's: " + this.proteinCounts.size());
            System.out.println("Lost peptides: " + lostPeptides);
        }
    }

    private void loadReplicateInfo() {
        int j;
        BufferedReader buf = null;
        String line = null;
        try {
            buf = new BufferedReader(new FileReader(this.replicateFileName));
            line = buf.readLine();
        }
        catch (IOException E) {
            E.printStackTrace();
            System.exit(-1);
        }
        this.replicateMap = new Hashtable();
        this.dataset2Sample = new int[this.numDatasets];
        while (line != null) {
            if ((line = line.trim()).length() == 0 || line.charAt(0) == '#') {
                try {
                    line = buf.readLine();
                }
                catch (IOException E) {
                    E.printStackTrace();
                    System.exit(-1);
                }
                continue;
            }
            String[] bits = line.split("\t");
            String repName = bits[0];
            if (repName.equals("Maize-Endosperm-8DAP-2b")) {
                System.out.println("AHHH!!");
            }
            ArrayList<Integer> dataSetIndices = new ArrayList<Integer>();
            int i = 1;
            while (i < bits.length) {
                if (repName.equals("Maize-Endosperm-8DAP-2b")) {
                    System.out.println("Found dataset " + bits[1]);
                }
                j = 0;
                while (j < this.dataSetNames.length) {
                    if (bits[i].equals(this.dataSetNames[j])) {
                        dataSetIndices.add(new Integer(j));
                        break;
                    }
                    ++j;
                }
                ++i;
            }
            this.replicateMap.put(repName, Utils.ConvertArraylistToIntArray(dataSetIndices));
            try {
                line = buf.readLine();
            }
            catch (IOException E) {
                E.printStackTrace();
                System.exit(-1);
            }
        }
        System.out.println("Reducing datasets to " + this.replicateMap.size() + " distinct samples");
        this.replicateNames = new String[this.replicateMap.size()];
        Enumeration e = this.replicateMap.keys();
        int index = 0;
        while (e.hasMoreElements()) {
            String name;
            this.replicateNames[index] = name = (String)e.nextElement();
            int[] dataSets = (int[])this.replicateMap.get(name);
            j = 0;
            while (j < dataSets.length) {
                this.dataset2Sample[dataSets[j]] = index;
                ++j;
            }
            ++index;
        }
        try {
            buf.close();
        }
        catch (IOException E) {
            E.printStackTrace();
            System.exit(-1);
        }
    }

    private void processResults() {
        int i;
        BufferedReader buf = null;
        String line = null;
        FileWriter f = null;
        FileWriter protF = null;
        try {
            buf = new BufferedReader(new FileReader(this.inputFileName));
            f = new FileWriter(this.outputFileName);
            if (this.trieDB != null) {
                String protFileName = String.valueOf(Utils.GetFileNameNoExtension(this.outputFileName)) + "_prot.txt";
                protF = new FileWriter(protFileName);
            }
            line = buf.readLine();
        }
        catch (IOException E) {
            E.printStackTrace();
            System.exit(-1);
        }
        String header = "#peptide\tcharge\tspecTotal";
        if (this.trieDB != null) {
            header = "#peptide\tcharge\tproteins\tspecTotal";
        }
        String protHeader = "#protein\tpeptides\tspecTotal";
        if (this.replicateMap != null) {
            i = 0;
            while (i < this.replicateNames.length) {
                header = String.valueOf(header) + "\t" + this.replicateNames[i];
                protHeader = String.valueOf(protHeader) + "\t" + this.replicateNames[i];
                ++i;
            }
        } else {
            i = 0;
            while (i < this.dataSetNames.length) {
                header = String.valueOf(header) + "\t" + this.dataSetNames[i];
                protHeader = String.valueOf(protHeader) + "\t" + this.dataSetNames[i];
                ++i;
            }
        }
        header = String.valueOf(header) + "\n";
        protHeader = String.valueOf(protHeader) + "\n";
        try {
            f.write(header);
            if (protF != null) {
                protF.write(protHeader);
            }
        }
        catch (IOException E) {
            E.printStackTrace();
            System.exit(-1);
        }
        double[] newSampleCounts = new double[this.numSamples];
        while (line != null) {
            if ((line = line.trim()).length() == 0 || line.charAt(0) == '#') {
                try {
                    line = buf.readLine();
                }
                catch (IOException E) {
                    E.printStackTrace();
                    System.exit(-1);
                }
                continue;
            }
            String[] bits = line.split("\t");
            double newTotalCount = 0.0;
            double[] sampleCounts = new double[this.numSamples];
            int i2 = 0;
            while (i2 < this.numDatasets) {
                int sampleIndex;
                int n = sampleIndex = this.dataset2Sample[i2];
                sampleCounts[n] = sampleCounts[n] + Double.parseDouble(bits[i2 + 3]);
                ++i2;
            }
            String newLine = "";
            double[] protCounts = null;
            Integer protID = null;
            String pepList = "";
            String protListStr = "";
            if (this.trieDB != null && this.peptide2ProteinHash.containsKey(bits[0].toUpperCase())) {
                protID = (Integer)this.peptide2ProteinHash.get(bits[0].toUpperCase());
                protCounts = (double[])this.proteinCounts.get(protID);
                protListStr = this.trieDB.getProteinName(protID).split(" ")[0];
                if (this.protein2Peptide.containsKey(protID)) {
                    pepList = String.valueOf((String)this.protein2Peptide.get(protID)) + ",";
                }
                pepList = String.valueOf(pepList) + bits[0] + ":" + bits[1];
                this.protein2Peptide.put(protID, pepList);
            } else if (this.trieDB != null && this.sharedPeptide2ProteinHash.containsKey(bits[0].toUpperCase())) {
                int[] protIDs = (int[])this.sharedPeptide2ProteinHash.get(bits[0].toUpperCase());
                int p = 0;
                while (p < protIDs.length) {
                    protListStr = String.valueOf(protListStr) + this.trieDB.getProteinName(protIDs[p]).split(" ")[0];
                    if (p < protIDs.length - 1) {
                        // empty if block
                    }
                    protListStr = String.valueOf(protListStr) + ";";
                    ++p;
                }
            }
            int i3 = 0;
            while (i3 < sampleCounts.length) {
                sampleCounts[i3] = sampleCounts[i3] * this.scaleFactor[i3];
                if (protID != null) {
                    int n = i3;
                    protCounts[n] = protCounts[n] + sampleCounts[i3];
                }
                newTotalCount += sampleCounts[i3];
                newLine = String.valueOf(newLine) + "\t" + sampleCounts[i3];
                int n = i3;
                newSampleCounts[n] = newSampleCounts[n] + sampleCounts[i3];
                ++i3;
            }
            if (protID != null) {
                this.proteinCounts.put(protID, protCounts);
            }
            newLine = this.trieDB != null ? String.valueOf(bits[0]) + "\t" + bits[1] + "\t" + protListStr + "\t" + newTotalCount + newLine + "\n" : String.valueOf(bits[0]) + "\t" + bits[1] + "\t" + newTotalCount + newLine + "\n";
            if (this.debug) {
                Utils.WaitForEnter();
            }
            try {
                f.write(newLine);
                line = buf.readLine();
            }
            catch (IOException E) {
                E.printStackTrace();
                System.exit(-1);
            }
        }
        int i4 = 0;
        while (i4 < this.numSamples) {
            if (this.replicateFileName != null) {
                System.out.print(String.valueOf(this.replicateNames[i4]) + " ");
            } else {
                System.out.print(String.valueOf(this.dataSetNames[i4]) + " ");
            }
            System.out.println(newSampleCounts[i4]);
            ++i4;
        }
        try {
            buf.close();
            f.close();
        }
        catch (IOException E) {
            E.printStackTrace();
            System.exit(-1);
        }
        if (this.trieDB != null) {
            Enumeration protKeys = this.proteinCounts.keys();
            while (protKeys.hasMoreElements()) {
                String protLine = "";
                int protID = (Integer)protKeys.nextElement();
                String protName = this.trieDB.getProteinName(protID);
                String pepList = (String)this.protein2Peptide.get(new Integer(protID));
                int pepCount = pepList.split(",").length;
                double specTotal = 0.0;
                double[] specCounts = (double[])this.proteinCounts.get(new Integer(protID));
                int i5 = 0;
                while (i5 < this.numSamples) {
                    double averagedSpecCount = specCounts[i5] / (double)pepCount;
                    protLine = String.valueOf(protLine) + "\t" + averagedSpecCount;
                    specTotal += averagedSpecCount;
                    ++i5;
                }
                protLine = String.valueOf(protName) + "\t" + pepList + "\t" + specTotal + protLine + "\n";
                try {
                    protF.write(protLine);
                }
                catch (IOException E) {
                    E.printStackTrace();
                    System.exit(-1);
                }
            }
            try {
                protF.close();
            }
            catch (IOException E) {
                E.printStackTrace();
                System.exit(-1);
            }
        }
    }
}

