/*
 * Decompiled with CFR 0.152.
 */
package specUtils;

import basicUtils.InspectAnnotation;
import basicUtils.Utils;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import specUtils.MGFExtractor;

public class AnalyzeInspectRuns {
    public static String usageInfo = "specUtils.AnalyzeInspectRuns \nDesigned to compare Inspect performance on raw spectra versus Inspect\nperformance on deconvoluted spectra (MSDeconv).  Computes the number of spectra\nidentified in each case, and retrieves the original spectrum charge for the deconvoluted spectra\nthat were not identified by the raw spectrum experiment\n[REQUIRED]:\n-r [FILE] File containing Inspect run with raw spectra\n-d [FILE] File containing Inspect results with deconvoluted spectra\n-s [FILE] File containing deconvoluted spectra\n-q [FILE] File containing original spectra\n";
    private String rawFileName;
    private String deconvFileName;
    private String specFileName;
    private String origSpecFileName;
    private Hashtable oldChargeHash;
    private boolean debug = false;

    public AnalyzeInspectRuns(String rawInputFile, String deconvInputFile, String spectrumFile, String origSpecFileName) {
        if (!Utils.IsFile(rawInputFile)) {
            System.err.println("ERROR: Invalid file raw inspect file name '" + rawInputFile + "'!");
            System.exit(-1);
        }
        if (!Utils.IsFile(deconvInputFile)) {
            System.err.println("ERROR: Invalid file deconv inspect file name '" + deconvInputFile + "'!");
            System.exit(-1);
        }
        if (!Utils.IsFile(spectrumFile)) {
            System.err.println("ERROR: Invalid file spectrum file name '" + spectrumFile + "'!");
            System.exit(-1);
        }
        if (!Utils.IsFile(origSpecFileName)) {
            System.err.println("ERROR: Invalid file spectrum file name '" + origSpecFileName + "'!");
            System.exit(-1);
        }
        this.rawFileName = rawInputFile;
        this.deconvFileName = deconvInputFile;
        this.specFileName = spectrumFile;
        this.origSpecFileName = origSpecFileName;
        this.oldChargeHash = new Hashtable();
    }

    public static void main(String[] args) {
        String[] options = new String[]{"-r", "-d", "-s", "-q"};
        boolean[] values = new boolean[]{true, true, true, true};
        Hashtable CommandLineArgs = Utils.ParseCommandLine(args, options, values);
        if (!(CommandLineArgs.containsKey("-r") && CommandLineArgs.containsKey("-d") && CommandLineArgs.containsKey("-s") && CommandLineArgs.containsKey("-q"))) {
            System.err.println("ERROR: Missing arguments!");
            System.out.println(usageInfo);
            System.exit(-1);
        }
        String rawInputFile = (String)CommandLineArgs.get("-r");
        String deconvInputFile = (String)CommandLineArgs.get("-d");
        String spectrumFile = (String)CommandLineArgs.get("-s");
        String origSpecFile = (String)CommandLineArgs.get("-q");
        AnalyzeInspectRuns r = new AnalyzeInspectRuns(rawInputFile, deconvInputFile, spectrumFile, origSpecFile);
        r.analyze();
    }

    private void analyze() {
        Hashtable rawAnns = InspectAnnotation.LoadInspectAnnotationsIntoSpec2PeptideHash(this.rawFileName);
        Hashtable deconvAnns = InspectAnnotation.LoadInspectAnnotationsIntoSpec2PeptideHash(this.deconvFileName);
        deconvAnns = this.fixDeconvAnns(deconvAnns);
        ArrayList<String> rawAnnOnly = new ArrayList<String>();
        ArrayList<String> deconvOnly = new ArrayList<String>();
        int disagree = 0;
        int total = 0;
        int[] chargeHisto = new int[10];
        Enumeration rawKeys = rawAnns.keys();
        while (rawKeys.hasMoreElements()) {
            String key = (String)rawKeys.nextElement();
            if (deconvAnns.containsKey(key)) {
                String deconvPep;
                String rawPep = (String)rawAnns.get(key);
                if (rawPep.compareTo(deconvPep = (String)deconvAnns.get(key)) != 0) {
                    System.out.println("For " + key + " rawPep: " + rawPep + ", deconvPep = " + deconvPep);
                    ++disagree;
                }
                ++total;
                continue;
            }
            rawAnnOnly.add(key);
        }
        Enumeration deconvKeys = deconvAnns.keys();
        int ChargeShift = 1;
        while (deconvKeys.hasMoreElements()) {
            String key = (String)deconvKeys.nextElement();
            if (rawAnns.containsKey(key)) continue;
            deconvOnly.add(key);
            int oldCharge = (Integer)this.oldChargeHash.get(key);
            if ((oldCharge -= ChargeShift) < 0) {
                oldCharge = 0;
            }
            if (oldCharge >= chargeHisto.length) {
                oldCharge = chargeHisto.length - 1;
            }
            int n = oldCharge;
            chargeHisto[n] = chargeHisto[n] + 1;
        }
        total += rawAnnOnly.size();
        System.out.println("Total spectra: " + (total += deconvOnly.size()));
        System.out.println("Shared: " + (total - rawAnnOnly.size() - deconvOnly.size()) + ", disagree: " + disagree);
        System.out.println("RawAnnOnly: " + rawAnnOnly.size());
        System.out.println("DeconvOnly: " + deconvOnly.size());
        System.out.println(" z=1.." + ChargeShift + ": " + chargeHisto[0]);
        int i = 1;
        while (i < chargeHisto.length - 1) {
            System.out.println(" z=" + (i + ChargeShift) + ": " + chargeHisto[i]);
            ++i;
        }
        System.out.println(" z=" + (chargeHisto.length - 1 + ChargeShift) + "+: " + chargeHisto[chargeHisto.length - 1]);
    }

    private Hashtable fixDeconvAnns(Hashtable oldAnns) {
        Hashtable<String, String> fixedAnns = new Hashtable<String, String>();
        ArrayList deconvScanNums = new ArrayList();
        Enumeration keys = oldAnns.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            String[] bits = key.split("@");
            Utils.InsertInAscendingOrder(deconvScanNums, Integer.parseInt(bits[1]));
        }
        int[] scanNums = Utils.ConvertArraylistToIntArray(deconvScanNums);
        int sIndex = 0;
        MGFExtractor e = new MGFExtractor();
        e.openMGFExtractorSequential(this.specFileName);
        int currScanNum = 0;
        String currScan = e.getNextScanString();
        while (currScan != null && sIndex < scanNums.length) {
            if (currScanNum == scanNums[sIndex]) {
                int[] oldScanInfo = this.getOldScanInfo(currScan);
                String oldKey = String.valueOf(Utils.GetBaseName(this.specFileName)) + "@" + scanNums[sIndex];
                if (this.debug) {
                    System.out.print(String.valueOf(oldKey) + "->");
                }
                String pep = (String)oldAnns.get(oldKey);
                String newKey = String.valueOf(Utils.GetBaseName(this.origSpecFileName)) + "@" + oldScanInfo[0];
                if (this.debug) {
                    System.out.println(String.valueOf(newKey) + ":" + pep + ", oldZ: " + oldScanInfo[1]);
                }
                this.oldChargeHash.put(newKey, new Integer(oldScanInfo[1]));
                fixedAnns.put(newKey, pep);
                ++sIndex;
            }
            ++currScanNum;
            currScan = e.getNextScanString();
        }
        e.closeMGFExtractorSequential();
        return fixedAnns;
    }

    private int[] getOldScanInfo(String currScan) {
        int[] ret = new int[]{-1, -1};
        int retIndex = currScan.indexOf(10);
        int currStart = 0;
        while (retIndex >= 0) {
            String[] bits;
            String currLine = currScan.substring(currStart, retIndex);
            if (currLine.indexOf("TITLE") >= 0) {
                bits = currLine.split("=");
                ret[0] = Integer.parseInt(bits[1].split("_")[1]);
            } else if (currLine.indexOf("OLDZ") >= 0) {
                bits = currLine.split("=");
                ret[1] = Integer.parseInt(bits[1].replace("+", ""));
            }
            if (ret[0] >= 0 && ret[1] >= 0) {
                return ret;
            }
            currStart = retIndex + 1;
            retIndex = currStart + currScan.substring(currStart).indexOf(10);
        }
        return null;
    }
}

