/*
 * Decompiled with CFR 0.152.
 */
package specUtils;

import basicUtils.Utils;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import org.systemsbiology.jrap.stax.Scan;
import specUtils.SpectrumLoader;
import specUtils.SpectrumWriter;

public class ConvertMGF2PKL {
    public static String UsageInfo = "specUtils.ConvertMGF2PKL version 08.16.2010\nConverts an MGF file to a pkl file\nREQUIRED:\n -r [FILE] MGF file\n -w [FILE] PKL file to write\nOPTIONAL:\n -b Write to pklbin format instead\n";
    private String InputFileName = null;
    private String OutputFileName = null;

    public ConvertMGF2PKL(String InputFile, String OutputFile) {
        this.InputFileName = InputFile;
        this.OutputFileName = OutputFile;
        System.out.println("Loading from " + this.InputFileName);
        System.out.println("Creating file " + this.OutputFileName);
    }

    public void Convert() {
        SpectrumLoader sLoader = new SpectrumLoader(this.InputFileName);
        if (!sLoader.openSequential()) {
            System.err.println("ERROR: Unable to open " + this.InputFileName);
            System.exit(-1);
        }
        FileWriter f = null;
        try {
            f = new FileWriter(this.OutputFileName);
        }
        catch (IOException E) {
            E.printStackTrace();
            System.exit(-1);
        }
        Scan currScan = sLoader.getNextScan();
        if (currScan == null) {
            System.out.println("NULL!");
        }
        while (currScan != null) {
            String PKLScan = SpectrumWriter.WriteScanAsPKL(currScan);
            try {
                if (currScan.header.getPrecursorCharge() >= 4) {
                    f.write(PKLScan);
                }
            }
            catch (IOException E) {
                E.printStackTrace();
                System.exit(-1);
            }
            currScan = sLoader.getNextScan();
        }
        sLoader.closeSequential();
        try {
            f.close();
        }
        catch (IOException E) {
            E.printStackTrace();
            System.exit(-1);
        }
    }

    public static void main(String[] args) {
        String InputFile;
        String[] options = new String[]{"-r", "-w", "-b"};
        boolean[] blArray = new boolean[3];
        blArray[0] = true;
        blArray[1] = true;
        boolean[] values = blArray;
        Hashtable CommandLineArgs = Utils.ParseCommandLine(args, options, values);
        if (!CommandLineArgs.containsKey("-r") || !CommandLineArgs.containsKey("-w")) {
            System.err.println("ERROR: Missing arguments!");
            System.out.println(UsageInfo);
            System.exit(-1);
        }
        if (!Utils.IsFile(InputFile = (String)CommandLineArgs.get("-r"))) {
            System.err.println("ERROR: Input file '" + InputFile + "' is not a valid file!");
            System.out.println(UsageInfo);
            System.exit(-1);
        }
        String OutputFile = (String)CommandLineArgs.get("-w");
        ConvertMGF2PKL c = new ConvertMGF2PKL(InputFile, OutputFile);
        if (CommandLineArgs.containsKey("-b")) {
            c.Convert2PKLBIN();
        } else {
            c.Convert();
        }
    }

    private void Convert2PKLBIN() {
        int[] charges = new int[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3};
        boolean LocalDebug = true;
        SpectrumLoader sLoader = new SpectrumLoader(this.InputFileName);
        if (!sLoader.openSequential()) {
            System.err.println("ERROR: Unable to open " + this.InputFileName);
            System.exit(-1);
        }
        int scanCount = 0;
        ArrayList<Short> peakCounts = new ArrayList<Short>();
        Scan currScan = sLoader.getNextScan();
        while (currScan != null) {
            peakCounts.add(new Short((short)currScan.getMassIntensityList()[0].length));
            if (LocalDebug) {
                System.out.println("peakcount[" + scanCount + "]: " + (Short)peakCounts.get(scanCount));
            }
            ++scanCount;
            currScan = sLoader.getNextScan();
        }
        if (!sLoader.closeSequential()) {
            System.err.println("ERROR: Unable to open " + this.InputFileName);
            System.exit(-1);
        }
        if (LocalDebug) {
            System.out.println("scanCount: " + scanCount);
            Utils.WaitForEnter();
        }
        DataOutputStream f = null;
        try {
            f = new DataOutputStream(new FileOutputStream(this.OutputFileName));
            f.writeInt(Integer.reverseBytes(scanCount));
            int i = 0;
            while (i < peakCounts.size()) {
                short v = (Short)peakCounts.get(i);
                f.writeShort(Short.reverseBytes(v));
                ++i;
            }
        }
        catch (IOException E) {
            E.printStackTrace();
            return;
        }
        if (!sLoader.openSequential()) {
            System.err.println("ERROR: Unable to open " + this.InputFileName);
            System.exit(-1);
        }
        currScan = sLoader.getNextScan();
        scanCount = 0;
        while (currScan != null) {
            int charge = charges[scanCount];
            float precursorMZ = currScan.header.getPrecursorMz();
            float parentMH = (float)((double)(precursorMZ * (float)charge) - (double)(charge - 1) * 1.0078);
            double[][] peakList = currScan.getMassIntensityList();
            if (LocalDebug) {
                System.out.println("Scan[" + scanCount + "]");
                System.out.println(" - Z=" + charge);
                System.out.println(" - M/Z = " + precursorMZ);
                System.out.println(" - MH = " + parentMH);
                System.out.println(" - numPeaks = " + peakList[0].length);
            }
            try {
                f.writeFloat(parentMH);
                f.writeFloat(charge);
                int i = 0;
                while (i < peakList[0].length) {
                    f.writeFloat((float)peakList[0][i]);
                    f.writeFloat((float)peakList[1][i]);
                    ++i;
                }
            }
            catch (IOException E) {
                E.printStackTrace();
                return;
            }
            ++scanCount;
            currScan = sLoader.getNextScan();
        }
        if (!sLoader.closeSequential()) {
            System.err.println("ERROR: Unable to open " + this.InputFileName);
            System.exit(-1);
        }
        try {
            f.close();
        }
        catch (IOException E) {
            E.printStackTrace();
            System.exit(-1);
        }
    }
}

