/*
 * Decompiled with CFR 0.152.
 */
package specUtils;

import basicUtils.Utils;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import org.systemsbiology.jrap.stax.Scan;

public class MGFExtractor {
    private String fileName;
    private BufferedReader fileReader;

    public static String getMGFString(Scan spectrum) {
        String ret = "BEGIN IONS\n";
        ret = String.valueOf(ret) + "PEPMASS=" + spectrum.getHeader().getPrecursorMz() + "\n";
        double[][] data = spectrum.getMassIntensityList();
        int i = 0;
        while (i < data[0].length) {
            ret = String.valueOf(ret) + data[0][i] + " " + data[1][i] + "\n";
            ++i;
        }
        ret = String.valueOf(ret) + "END IONS\n";
        return ret;
    }

    /*
     * Unable to fully structure code
     */
    public static void ExtractMGFSpectra(String OriginalSpectrumFile, String OutputFile, int[] ScansToKeep) {
        CurrScan = -1;
        ScansWritten = 0;
        WriteThisScan = false;
        Buf = null;
        Writer = null;
        Line = null;
        try {
            Buf = new BufferedReader(new FileReader(OriginalSpectrumFile));
            Line = Buf.readLine();
            Writer = new FileWriter(OutputFile);
            if (true) ** GOTO lbl35
        }
        catch (IOException E) {
            E.printStackTrace();
            return;
        }
        do {
            if (Line.indexOf("BEGIN IONS") >= 0) {
                if (Utils.IntArrayContains(ScansToKeep, ++CurrScan)) {
                    WriteThisScan = true;
                    ++ScansWritten;
                } else {
                    WriteThisScan = false;
                }
            }
            if (WriteThisScan) {
                try {
                    Writer.write(String.valueOf(Line) + "\n");
                }
                catch (IOException E) {
                    E.printStackTrace();
                    return;
                }
            }
            try {
                Line = Buf.readLine();
            }
            catch (IOException E) {
                E.printStackTrace();
                return;
            }
lbl35:
            // 2 sources

        } while (Line != null);
        try {
            Buf.close();
            Writer.close();
        }
        catch (IOException E) {
            E.printStackTrace();
            return;
        }
        System.out.println("Wrote " + ScansWritten + " to " + OutputFile);
    }

    public void openMGFExtractorSequential(String fileName) {
        this.fileName = fileName;
        try {
            this.fileReader = new BufferedReader(new FileReader(this.fileName));
        }
        catch (IOException E) {
            E.printStackTrace();
            System.exit(-1);
        }
    }

    public void closeMGFExtractorSequential() {
        try {
            this.fileReader.close();
        }
        catch (IOException E) {
            E.printStackTrace();
            System.exit(-1);
        }
    }

    public String getNextScanString() {
        if (this.fileReader == null) {
            System.err.println("ERROR: Must open file before attempting to read!!");
            return null;
        }
        String line = null;
        try {
            line = this.fileReader.readLine();
        }
        catch (IOException E) {
            E.printStackTrace();
            return null;
        }
        String ret = "";
        while (line != null) {
            ret = String.valueOf(ret) + line + "\n";
            if (line.indexOf("END") >= 0) {
                return ret;
            }
            try {
                line = this.fileReader.readLine();
            }
            catch (IOException E) {
                E.printStackTrace();
                return null;
            }
        }
        if (ret.compareTo("") == 0) {
            return null;
        }
        return ret;
    }

    public static void main(String[] args) {
        int[] ScansToKeep = new int[6];
        ScansToKeep[1] = 208;
        ScansToKeep[2] = 218;
        ScansToKeep[3] = 238;
        ScansToKeep[4] = 376;
        ScansToKeep[5] = 395;
        ScansToKeep[0] = 108;
        String OutputFile = "/home/natalie/Projects/MSDeconv/3F12_DTT_IAA_insoln_ArgC_90min_msms_FT_021210_msdeconv.reduced.mgf";
        MGFExtractor.ExtractMGFSpectra("/home/natalie/Projects/MSDeconv/3F12_DTT_IAA_insoln_ArgC_90min_msms_FT_021210_msdeconv.mgf", OutputFile, ScansToKeep);
    }
}

