/*
 * Decompiled with CFR 0.152.
 */
package stats;

import basicUtils.Utils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Hashtable;

public class PeptideStatPlotter {
    public static final String UsageInfo = "java stats.PeptideStatPlotter\n[Required]:\n-r [DIR/FILE] File or directory containing Inspect results\n-m [NUM] Mode to run stats\n[Modes]:\n0 - Plot missed cleavages per peptide\n";
    private String[] InputFiles = null;
    private int Mode = 0;

    public PeptideStatPlotter(String[] InputFiles, int Mode) {
        this.InputFiles = InputFiles;
        this.Mode = Mode;
    }

    public void Run() {
        if (this.Mode == StatMode.MISSED_CLEAVAGE_COUNTER) {
            this.RunMissedCleavageCounter();
        }
    }

    public void RunMissedCleavageCounter() {
        BufferedReader Buf = null;
        int[] Counter = new int[20];
        Hashtable<String, Integer> PeptidesSeen = new Hashtable<String, Integer>();
        String Line = null;
        int i = 0;
        while (i < this.InputFiles.length) {
            System.out.println("Loading from " + this.InputFiles[i]);
            try {
                Buf = new BufferedReader(new FileReader(this.InputFiles[i]));
                Line = Buf.readLine();
            }
            catch (IOException E) {
                E.printStackTrace();
                System.exit(0);
            }
            while (Line != null) {
                String[] Bits;
                String Peptide2;
                if ((Line = Line.trim()) != null && Line.length() > 0 && !PeptidesSeen.containsKey(Peptide2 = Utils.GetUnModded((Bits = Line.split("\t"))[4]))) {
                    PeptidesSeen.put(Peptide2, new Integer(0));
                    int Cleavages = 0;
                    int j = 0;
                    while (j < Peptide2.length() - 1) {
                        if (Peptide2.charAt(j) == 'K' || Peptide2.charAt(j) == 'R') {
                            ++Cleavages;
                        }
                        ++j;
                    }
                    int n = Cleavages;
                    Counter[n] = Counter[n] + 1;
                    if (Cleavages >= 9) {
                        System.out.println(String.valueOf(Peptide2) + ":" + Cleavages);
                        Utils.WaitForEnter();
                    }
                }
                try {
                    Line = Buf.readLine();
                }
                catch (IOException E) {
                    E.printStackTrace();
                    System.exit(0);
                }
            }
            int j = 0;
            while (j < Counter.length) {
                System.out.print(String.valueOf(Counter[j]) + " ");
                ++j;
            }
            System.out.println(" ");
            try {
                Buf.close();
            }
            catch (IOException E) {
                E.printStackTrace();
                System.exit(0);
            }
            ++i;
        }
    }

    public static void main(String[] args) {
        String[] InputFiles;
        String[] options = new String[]{"-r", "-m"};
        boolean[] values = new boolean[]{true, true};
        Hashtable CommandLineArgs = Utils.ParseCommandLine(args, options, values);
        if (!CommandLineArgs.containsKey("-r")) {
            System.err.println("ERROR: Must specify an input directory or file\n");
            System.out.println(UsageInfo);
            return;
        }
        if (!CommandLineArgs.containsKey("-m")) {
            System.err.println("ERROR: Must specify a mode\n");
            System.out.println(UsageInfo);
            return;
        }
        String Input = (String)CommandLineArgs.get("-r");
        File T = new File(Input);
        if (!T.exists()) {
            System.err.println("ERROR: Invalide input directory or file '" + Input + "'\n");
            System.out.println(UsageInfo);
            return;
        }
        if (T.isDirectory()) {
            InputFiles = T.list();
            int i = 0;
            while (i < InputFiles.length) {
                InputFiles[i] = String.valueOf(T.getAbsolutePath()) + File.separator + InputFiles[i];
                ++i;
            }
        } else {
            InputFiles = new String[]{Input};
        }
        int Mode = Integer.parseInt((String)CommandLineArgs.get("-m"));
        if (Mode != 0) {
            System.out.println("WARNING: Unsupported mode '" + Mode + "'");
            return;
        }
        PeptideStatPlotter Driver = new PeptideStatPlotter(InputFiles, Mode);
        Driver.Run();
    }

    public static class StatMode {
        public static int MISSED_CLEAVAGE_COUNTER = 0;
    }
}

