/*
 * Decompiled with CFR 0.152.
 */
package trieUtils;

import basicUtils.InspectAnnotation;
import basicUtils.ProteoDB;
import basicUtils.Utils;
import errorUtils.ErrorThrower;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedList;
import specUtils.MGFExtractor;
import trieUtils.TrieNode;

public class TrieDB
extends ProteoDB {
    public static final int MAX_PEPTIDES = 5000;
    public static final int MAX_PROTEINS = 500;
    private static boolean Debug = true;
    private static int TRIE_RECORD_SIZE = 92;
    private String[] ProteinNames;
    private String[] ProteinSequences;
    private long[] FASTAPosition;
    private int[] TriePosition;
    private static final int MAX_PROTEIN_NAMES = 1000000;
    private int IndexFileStart = 0;
    private int ShiftIndex = Integer.MAX_VALUE;
    private int ShiftFilePos = 0;
    private static final int SHIFT_VALUE = 2140000000;
    private RandomAccessFile TrieReader = null;
    private RandomAccessFile IndexReader = null;
    private Hashtable triePosHash = null;
    private static int MAX_TRIE_POS_ENTRIES = 10000;
    private long NumAA;
    private int NumProteins;
    private String IndexFileName;

    public TrieDB(String TrieFileName) {
        this.DBFileName = TrieFileName;
        this.IndexFileName = String.valueOf(Utils.GetFileNameNoExtension(TrieFileName)) + ".index";
        try {
            this.TrieReader = new RandomAccessFile(this.DBFileName, "r");
            this.IndexReader = new RandomAccessFile(this.IndexFileName, "r");
            this.NumAA = this.TrieReader.length();
            this.NumProteins = (int)(this.IndexReader.length() / (long)TRIE_RECORD_SIZE);
        }
        catch (Exception E) {
            ErrorThrower.ThrowError(5, String.valueOf(this.DBFileName) + " and " + this.IndexFileName);
        }
    }

    public TrieDB(String trieFileName, String indexFileName) {
        this.DBFileName = trieFileName;
        this.IndexFileName = indexFileName == null ? String.valueOf(Utils.GetFileNameNoExtension(trieFileName)) + ".index" : indexFileName;
        try {
            this.TrieReader = new RandomAccessFile(this.DBFileName, "r");
            this.IndexReader = new RandomAccessFile(this.IndexFileName, "r");
            this.NumAA = this.TrieReader.length();
            this.NumProteins = (int)(this.IndexReader.length() / (long)TRIE_RECORD_SIZE);
        }
        catch (Exception E) {
            ErrorThrower.ThrowError(5, String.valueOf(this.DBFileName) + " and " + this.IndexFileName);
        }
    }

    public static String[] reverseDB(String trieFile) {
        TrieDB db = new TrieDB(trieFile);
        return TrieDB.reverseDB(db, null);
    }

    public static String[] reverseDB(String trieFile, String shuffledTrieFile) {
        TrieDB db = new TrieDB(trieFile);
        return TrieDB.reverseDB(db, shuffledTrieFile);
    }

    public static String[] reverseDB(String inputTrieFile, String inputIndexFile, String outputTrieFile, String outputIndexFile) {
        TrieDB t = new TrieDB(inputTrieFile, inputIndexFile);
        return TrieDB.reverseDB(t, outputTrieFile, outputIndexFile);
    }

    public static String[] reverseDB(TrieDB forwardTrie, String shuffledTrie) {
        return TrieDB.reverseDB(forwardTrie, shuffledTrie, null);
    }

    public static String[] reverseDB(TrieDB forwardTrie, String shuffledTrie, String shuffledIndex) {
        String[] ret = new String[2];
        if (shuffledTrie == null) {
            ret[0] = String.valueOf(Utils.GetFileNameNoExtension(forwardTrie.DBFileName)) + ".RS.trie";
            ret[1] = String.valueOf(Utils.GetFileNameNoExtension(forwardTrie.DBFileName)) + ".RS.index";
        } else {
            ret[0] = shuffledTrie;
            ret[1] = shuffledIndex == null ? String.valueOf(Utils.GetFileNameNoExtension(shuffledTrie)) + ".index" : shuffledIndex;
        }
        boolean LocalDebug = false;
        if (LocalDebug) {
            System.out.println("Creating trie file " + ret[0]);
        }
        long shuffledFASTAPos = 0L;
        int shuffledTriePos = 0;
        FileWriter trieWriter = null;
        DataOutputStream indexWriter = null;
        try {
            trieWriter = new FileWriter(ret[0]);
            indexWriter = new DataOutputStream(new FileOutputStream(ret[1]));
        }
        catch (IOException E) {
            E.printStackTrace();
            return null;
        }
        int i = 0;
        while (i < forwardTrie.NumProteins) {
            String proteinSequence = forwardTrie.getProteinSequence(i);
            String proteinName = forwardTrie.getProteinName(i);
            String shuffledProteinSequence = Utils.ReverseString(proteinSequence);
            String shuffledName = "XXX." + proteinName;
            if (shuffledName.length() > 80) {
                shuffledName = shuffledName.substring(0, 80);
            }
            while (shuffledName.length() < 80) {
                shuffledName = String.valueOf(shuffledName) + "\u0000";
            }
            while (proteinName.length() < 80) {
                proteinName = String.valueOf(proteinName) + "\u0000";
            }
            if (LocalDebug) {
                System.out.println("P-name: " + proteinName);
                System.out.println("P-seq: " + proteinSequence);
                System.out.println("S-name: " + shuffledName);
                System.out.println("S-seq: " + shuffledProteinSequence);
            }
            try {
                indexWriter.writeLong(Long.reverseBytes(shuffledFASTAPos));
                indexWriter.writeInt(Integer.reverseBytes(shuffledTriePos));
                indexWriter.writeBytes(shuffledName);
                if (LocalDebug) {
                    System.out.println("Writing shuffled protein for " + i);
                    System.out.println("FASTA POS: " + shuffledFASTAPos);
                    System.out.println("TRIE POS: " + shuffledTriePos);
                    System.out.println("NAME: " + shuffledName);
                }
                trieWriter.write(String.valueOf(shuffledProteinSequence) + "*");
                indexWriter.writeLong(Long.reverseBytes(shuffledFASTAPos));
                indexWriter.writeInt(Integer.reverseBytes(shuffledTriePos += shuffledProteinSequence.length() + 1));
                indexWriter.writeBytes(proteinName);
                if (LocalDebug) {
                    System.out.println("Writing forward protein for " + i);
                    System.out.println("FASTA POS: " + shuffledFASTAPos);
                    System.out.println("TRIE POS: " + shuffledTriePos);
                    System.out.println("NAME: " + proteinName);
                    System.out.println(proteinName.length());
                }
                shuffledTriePos += proteinSequence.length();
                if (i < forwardTrie.NumProteins - 1) {
                    trieWriter.write(String.valueOf(proteinSequence) + "*");
                    ++shuffledTriePos;
                } else {
                    trieWriter.write(proteinSequence);
                }
                if (LocalDebug) {
                    System.out.println("New triepos: " + shuffledTriePos);
                }
            }
            catch (IOException E) {
                E.printStackTrace();
            }
            ++i;
        }
        try {
            trieWriter.close();
            indexWriter.close();
        }
        catch (IOException E) {
            E.printStackTrace();
            return null;
        }
        if (LocalDebug) {
            TrieDB test = new TrieDB(ret[0]);
            System.out.println("Test for db " + test.GetDBFileName());
            int i2 = 0;
            while (i2 < test.NumProteins) {
                System.out.print("Record " + i2);
                System.out.println(test.getProteinName(i2));
                System.out.println(test.getProteinSequence(i2));
                System.out.println(String.valueOf(test.GetTriePos(i2)) + "-" + test.GetTriePos(i2 + 1));
                ++i2;
            }
        }
        return ret;
    }

    public static TrieDB createDatabaseObject(String knownDB) {
        if (knownDB == null) {
            return null;
        }
        String ext = Utils.GetFileExtension(knownDB);
        if (ext.equalsIgnoreCase(".trie")) {
            return new TrieDB(knownDB);
        }
        String[] names = TrieDB.prepDB(knownDB, null);
        return new TrieDB(names[0]);
    }

    public static String[] prepDB(String fastaFileName, String trieFileName) {
        return TrieDB.prepDB(fastaFileName, trieFileName, null);
    }

    public static String[] prepDB(String fastaFileName, String trieFileName, String indexFileName) {
        boolean LocalDebug = false;
        String[] ret = new String[2];
        if (trieFileName == null) {
            ret[0] = String.valueOf(Utils.GetFileNameNoExtension(fastaFileName)) + ".trie";
            ret[1] = indexFileName == null ? String.valueOf(Utils.GetFileNameNoExtension(fastaFileName)) + ".index" : indexFileName;
        } else {
            ret[0] = trieFileName;
            ret[1] = indexFileName == null ? String.valueOf(Utils.GetFileNameNoExtension(trieFileName)) + ".index" : indexFileName;
        }
        FileWriter trieWriter = null;
        DataOutputStream indexWriter = null;
        BufferedReader fastaReader = null;
        String fastaLine = null;
        try {
            trieWriter = new FileWriter(ret[0]);
            indexWriter = new DataOutputStream(new FileOutputStream(ret[1]));
            fastaReader = new BufferedReader(new FileReader(fastaFileName));
            fastaLine = fastaReader.readLine();
        }
        catch (IOException E) {
            ErrorThrower.ThrowError(5, String.valueOf(ret[0]) + ", " + ret[1] + ", and " + fastaFileName);
        }
        int masterTriePos = 0;
        long fastaFilePos = 0L;
        String rawfastaLine = null;
        while (fastaLine != null) {
            rawfastaLine = fastaLine;
            if ((fastaLine = fastaLine.trim()).length() == 0) {
                try {
                    fastaFilePos += (long)(rawfastaLine.length() + 1);
                    fastaLine = fastaReader.readLine();
                }
                catch (IOException E) {
                    ErrorThrower.ThrowError(6, fastaFileName);
                }
                continue;
            }
            if (fastaLine.charAt(0) == '>') {
                try {
                    if (masterTriePos > 0) {
                        trieWriter.write("*");
                        ++masterTriePos;
                    }
                }
                catch (IOException E) {
                    ErrorThrower.ThrowError(7, ret[0]);
                }
                String proteinName = fastaLine.substring(1, Math.min(81, fastaLine.length()));
                while (proteinName.length() < 80) {
                    proteinName = String.valueOf(proteinName) + '\u0000';
                }
                if (LocalDebug) {
                    System.out.println("New protein: " + fastaLine);
                    System.out.println("reduced name: " + proteinName);
                    System.out.println("FASTA File Pos: " + fastaFilePos);
                    System.out.println("TRIE FILE Pos: " + masterTriePos);
                    Utils.WaitForEnter();
                }
                try {
                    indexWriter.writeLong(Long.reverseBytes(fastaFilePos));
                    indexWriter.writeInt(Integer.reverseBytes(masterTriePos));
                    indexWriter.writeBytes(proteinName);
                }
                catch (IOException E) {
                    ErrorThrower.ThrowError(7, ret[1]);
                }
            } else {
                try {
                    if (fastaLine.indexOf(42) >= 0) {
                        ErrorThrower.ThrowWarning(12, "Database cannot contain reserved character '*'.  Replacing with 'X'");
                        fastaLine = fastaLine.replace('*', 'X');
                    }
                    trieWriter.write(fastaLine);
                    masterTriePos += fastaLine.length();
                }
                catch (IOException E) {
                    ErrorThrower.ThrowError(7, ret[0]);
                }
            }
            try {
                fastaFilePos += (long)(rawfastaLine.length() + 1);
                fastaLine = fastaReader.readLine();
            }
            catch (IOException E) {
                ErrorThrower.ThrowError(6, fastaFileName);
            }
        }
        try {
            indexWriter.close();
            trieWriter.close();
            fastaReader.close();
        }
        catch (IOException E) {
            ErrorThrower.ThrowError(8, String.valueOf(ret[0]) + ", " + ret[1] + ", and " + fastaFileName);
        }
        return ret;
    }

    public String convert2FASTA(String fastaFileName) {
        if (fastaFileName == null) {
            fastaFileName = String.valueOf(Utils.GetFileNameNoExtension(this.DBFileName)) + ".fasta";
        }
        FileWriter f = null;
        try {
            f = new FileWriter(fastaFileName);
        }
        catch (IOException E) {
            System.out.println("ERROR:convert2FASTA:" + E.getLocalizedMessage());
            return null;
        }
        int i = 0;
        while (i < this.NumProteins) {
            String protName = this.getProteinName(i);
            String protSequence = this.getProteinSequence(i);
            try {
                f.write(">" + protName + "\n" + protSequence + "\n");
            }
            catch (IOException E) {
                System.out.println("ERROR:convert2FASTA:" + E.getLocalizedMessage());
                return null;
            }
            ++i;
        }
        try {
            f.close();
        }
        catch (IOException E) {
            System.out.println("ERROR:convert2FASTA:" + E.getLocalizedMessage());
            return null;
        }
        return fastaFileName;
    }

    private void LoadProteinSequences() {
        if (Debug) {
            System.out.println("Loading protein sequences...");
        }
        RandomAccessFile TrieFile = null;
        try {
            TrieFile = new RandomAccessFile(this.DBFileName, "r");
        }
        catch (Exception E) {
            System.err.println(E.getMessage());
            return;
        }
        this.ProteinSequences = new String[10];
        int i = 0;
        while (i < this.TriePosition.length) {
            int StartPos = this.TriePosition[i];
            int EndPos = 0;
            if (i < this.TriePosition.length - 1) {
                EndPos = this.TriePosition[i + 1];
            } else {
                try {
                    EndPos = (int)TrieFile.length();
                }
                catch (Exception E) {
                    System.err.println(E.getLocalizedMessage());
                    return;
                }
            }
            byte[] Bytes = null;
            try {
                TrieFile.seek(StartPos);
                if (i >= this.ShiftIndex) {
                    TrieFile.skipBytes(2140000000);
                }
                int Size = EndPos - StartPos - 1;
                if (i < this.ShiftIndex && i + 1 >= this.ShiftIndex) {
                    Size = EndPos - (StartPos - 2140000000) - 1;
                }
                System.out.println("Start:" + StartPos + ",End: " + EndPos + ",Size: " + Size);
                Bytes = new byte[Size];
                TrieFile.read(Bytes);
            }
            catch (Exception E) {
                System.err.println("ERROR:" + E.getMessage());
                return;
            }
            this.ProteinSequences[i] = new String(Bytes);
            System.out.println("StartPos: " + StartPos + ",Sequence: " + this.ProteinSequences[i]);
            this.NumAA += (long)this.ProteinSequences[i].length();
            ++i;
        }
        if (Debug) {
            System.out.println("Loaded " + this.ProteinSequences.length + "/" + this.ProteinNames.length + " sequences");
        }
    }

    public long GetNumAA() {
        return this.NumAA;
    }

    public String GetProteinSubstring(int ProteinID, int StartAA, int EndAA) {
        long TriePos = this.GetTriePos(ProteinID) + StartAA;
        Object Ret = null;
        byte[] B = new byte[EndAA - StartAA];
        try {
            if (TriePos > this.TrieReader.length()) {
                ErrorThrower.ThrowError(4, "Seeking a trie position (" + TriePos + ") exceeding the length of the file (" + this.TrieReader.length() + ")");
            }
            this.TrieReader.seek(TriePos);
            int val = this.TrieReader.read(B);
        }
        catch (Exception E) {
            System.err.println("ERROR:GetProteinSubstring: " + E.getMessage());
            return null;
        }
        return new String(B, Charset.forName("US-ASCII")).trim();
    }

    public int getProteinID(String Name) {
        int Index = 0;
        String FixedName = Name;
        if (this.ProteinNames != null) {
            FixedName = Name.replace("_", ":");
            String[] NameParts = FixedName.split(":");
            int i = 0;
            while (i < this.ProteinNames.length) {
                String[] OtherParts;
                if (this.ProteinNames[i] != null && NameParts[0].compareTo((OtherParts = this.ProteinNames[i].split(" "))[0]) == 0) {
                    return i;
                }
                ++i;
            }
            Index = 1000000;
        }
        byte[] B = new byte[80];
        try {
            this.IndexReader.seek(0L);
        }
        catch (Exception E) {
            E.printStackTrace();
            System.err.println("ERROR:getProteinID: " + E.getLocalizedMessage());
        }
        while (true) {
            long FASTAPos = 0L;
            int TriePos = 0;
            Object ProteinName = null;
            try {
                FASTAPos = Long.reverseBytes(this.IndexReader.readLong());
                TriePos = Integer.reverseBytes(this.IndexReader.readInt());
                this.IndexReader.read(B);
                String SeqName = new String(B);
                int NullIndex = SeqName.indexOf(0);
                if (NullIndex < 0) {
                    NullIndex = SeqName.length();
                }
                SeqName = SeqName.substring(0, NullIndex);
                SeqName = SeqName.split(" ")[0];
                if ((FixedName = FixedName.split(" ")[0]).equalsIgnoreCase(SeqName)) {
                    return Index;
                }
            }
            catch (Exception E) {
                E.printStackTrace();
                System.err.println("ERROR:getProteinID: " + E.getLocalizedMessage());
                break;
            }
            ++Index;
        }
        return -1;
    }

    public boolean[] ContainsProteins(String[] Proteins) {
        try {
            this.IndexReader.seek(0L);
        }
        catch (Exception E) {
            System.err.println("ERROR:ContainsProteins: " + E.getMessage());
            return null;
        }
        boolean[] Ret = new boolean[Proteins.length];
        byte[] B = new byte[80];
        while (true) {
            long FASTAPos = 0L;
            int TriePos = 0;
            Object ProteinName = null;
            try {
                FASTAPos = Long.reverseBytes(this.IndexReader.readLong());
                TriePos = Integer.reverseBytes(this.IndexReader.readInt());
                this.IndexReader.read(B);
                String SeqName = new String(B);
                int NullIndex = SeqName.indexOf(0);
                if (NullIndex < 0) {
                    NullIndex = SeqName.length();
                }
                SeqName = SeqName.substring(0, NullIndex);
                boolean Debug = false;
                int i = 0;
                while (i < Proteins.length) {
                    if (Proteins[i] != null) {
                        if (Proteins[i].compareTo("GRMZM2G114182_P01") == 0 && Debug) {
                            System.out.println("Our protein has this matching name god dammit!!");
                        }
                        if (SeqName.indexOf(Proteins[i]) >= 0) {
                            Ret[i] = true;
                            if (!Debug) break;
                            System.out.println("Match found in our list at index " + i);
                            break;
                        }
                    }
                    ++i;
                }
                if (!Debug) continue;
                Utils.WaitForEnter();
            }
            catch (Exception exception) {
                return Ret;
            }
        }
    }

    public int getProteinIDFromPartial(String Name) {
        int Index = 0;
        String FixedName = Name;
        String[] NameParts = FixedName.split(":");
        if (this.ProteinNames != null) {
            int i = 0;
            while (i < this.ProteinNames.length) {
                String[] OtherParts;
                if (this.ProteinNames[i] != null && NameParts[0].compareTo((OtherParts = this.ProteinNames[i].split(" "))[0]) == 0) {
                    return i;
                }
                ++i;
            }
            Index = 1000000;
        }
        try {
            this.IndexReader.seek(0L);
        }
        catch (Exception E) {
            System.err.println("ERROR:getProteinIDFromPartial: " + E.getMessage());
            return -1;
        }
        byte[] B = new byte[80];
        while (true) {
            long FASTAPos = 0L;
            int TriePos = 0;
            Object ProteinName = null;
            try {
                FASTAPos = Long.reverseBytes(this.IndexReader.readLong());
                TriePos = Integer.reverseBytes(this.IndexReader.readInt());
                this.IndexReader.read(B);
                String SeqName = new String(B);
                int NullIndex = SeqName.indexOf(0);
                if (NullIndex < 0) {
                    NullIndex = SeqName.length();
                }
                if ((SeqName = SeqName.substring(0, NullIndex)).toLowerCase().indexOf(FixedName.toLowerCase()) >= 0) {
                    return Index;
                }
            }
            catch (Exception E) {
                break;
            }
            ++Index;
        }
        return -1;
    }

    public String getProteinName(int ID) {
        boolean LocalDebug = false;
        if (this.ProteinNames != null && ID < 1000000) {
            if (LocalDebug) {
                System.out.println("ID " + ID + " is quick lookup");
            }
            return this.ProteinNames[ID];
        }
        if (LocalDebug) {
            System.out.println("ID " + ID + " is a slow lookup");
        }
        int Index = 1000000;
        try {
            this.IndexReader.seek(0L);
            this.IndexReader.skipBytes(TRIE_RECORD_SIZE * ID);
            if (LocalDebug) {
                System.out.println("skipbytes: " + TRIE_RECORD_SIZE * ID);
                System.out.println(this.IndexReader.getFilePointer());
            }
        }
        catch (Exception E) {
            System.err.println("ERROR:getProteinName: " + E.getMessage());
            return "";
        }
        byte[] B = new byte[80];
        long FASTAPos = 0L;
        int TriePos = 0;
        try {
            FASTAPos = Long.reverseBytes(this.IndexReader.readLong());
            TriePos = Integer.reverseBytes(this.IndexReader.readInt());
            this.IndexReader.read(B);
        }
        catch (Exception E) {
            E.printStackTrace();
            return null;
        }
        String ProteinName = new String(B);
        ProteinName = ProteinName.trim();
        int NullIndex = ProteinName.indexOf(0);
        if (NullIndex < 0) {
            NullIndex = ProteinName.length();
        }
        return ProteinName.substring(0, NullIndex);
    }

    public static String getProteinName(int ID, String IndexFileName) {
        boolean LocalDebug = false;
        if (LocalDebug) {
            System.out.println("ID " + ID + " is a slow lookup");
        }
        int Index = 1000000;
        DataInputStream IndexReader = null;
        try {
            IndexReader = new DataInputStream(new FileInputStream(IndexFileName));
            IndexReader.skipBytes(TRIE_RECORD_SIZE * ID);
        }
        catch (Exception E) {
            System.err.println("ERROR:getProteinName: " + E.getMessage());
            return "";
        }
        byte[] B = new byte[80];
        long FASTAPos = 0L;
        int TriePos = 0;
        try {
            FASTAPos = Long.reverseBytes(IndexReader.readLong());
            TriePos = Integer.reverseBytes(IndexReader.readInt());
            IndexReader.read(B);
        }
        catch (Exception E) {
            System.err.println("ERROR 2: " + E);
        }
        try {
            IndexReader.close();
        }
        catch (Exception E) {
            E.printStackTrace();
            System.err.println(E.getLocalizedMessage());
            return "";
        }
        String ProteinName = new String(B);
        ProteinName = ProteinName.trim();
        int NullIndex = ProteinName.indexOf(0);
        if (NullIndex < 0) {
            NullIndex = ProteinName.length();
        }
        return ProteinName.substring(0, NullIndex);
    }

    public long GetFASTAPos(int ID) {
        try {
            this.IndexReader.seek(0L);
            this.IndexReader.skipBytes(TRIE_RECORD_SIZE * ID);
        }
        catch (Exception E) {
            System.err.println("ERROR:GetFASTAPos: " + E.getMessage());
            return -1L;
        }
        byte[] B = new byte[80];
        long FASTAPos = 0L;
        int TriePos = 0;
        try {
            FASTAPos = Long.reverseBytes(this.IndexReader.readLong());
            TriePos = Integer.reverseBytes(this.IndexReader.readInt());
            this.IndexReader.read(B);
        }
        catch (Exception E) {
            System.err.println("ERROR 2: " + E);
        }
        return FASTAPos;
    }

    public int GetTriePos(int ID) {
        if (ID >= this.NumProteins || ID < 0) {
            return -1;
        }
        if (this.triePosHash == null) {
            this.triePosHash = new Hashtable();
        } else if (this.triePosHash.containsKey(new Integer(ID))) {
            int triePos = (Integer)this.triePosHash.get(new Integer(ID));
            return triePos;
        }
        if (this.triePosHash.size() >= MAX_TRIE_POS_ENTRIES) {
            this.triePosHash.clear();
        }
        try {
            this.IndexReader.seek(0L);
            this.IndexReader.skipBytes(TRIE_RECORD_SIZE * ID);
        }
        catch (Exception E) {
            System.err.println("ERROR:GetTriePos: " + E.getMessage());
            return -1;
        }
        byte[] B = new byte[80];
        long FASTAPos = 0L;
        int TriePos = 0;
        try {
            FASTAPos = Long.reverseBytes(this.IndexReader.readLong());
            TriePos = Integer.reverseBytes(this.IndexReader.readInt());
            this.IndexReader.read(B);
        }
        catch (Exception E) {
            System.err.println("ERROR:GetTriePos: " + E.getLocalizedMessage());
        }
        this.triePosHash.put(new Integer(ID), new Integer(TriePos));
        return TriePos;
    }

    public String getProteinSequence(int ID) {
        if (this.ProteinSequences != null) {
            return this.ProteinSequences[ID];
        }
        long StartPos = this.GetTriePos(ID);
        long EndPos = 0L;
        if (ID + 1 == this.NumProteins) {
            try {
                EndPos = this.TrieReader.length() + 1L;
            }
            catch (IOException E) {
                E.printStackTrace();
                System.exit(-1);
            }
        } else {
            EndPos = this.GetTriePos(ID + 1);
        }
        try {
            if (EndPos == -1L) {
                EndPos = this.TrieReader.length() + 1L;
            }
        }
        catch (Exception E) {
            System.err.println(E.getMessage());
            return "";
        }
        byte[] Bytes = null;
        try {
            this.TrieReader.seek(StartPos);
            int Size = (int)(EndPos - StartPos - 1L);
            Bytes = new byte[Size];
            this.TrieReader.read(Bytes);
        }
        catch (Exception E) {
            return null;
        }
        return new String(Bytes).trim();
    }

    public int getNumProteins() {
        return this.NumProteins;
    }

    public String GetShuffledDB(int Length) {
        String Ret = "";
        int i = 0;
        while (i < this.ProteinNames.length) {
            String CurrName = this.ProteinNames[i];
            if (CurrName.substring(0, 3).compareTo("XXX") == 0 && (Ret = String.valueOf(Ret) + this.ProteinSequences[i]).length() >= Length) {
                return Ret.substring(0, Length);
            }
            ++i;
        }
        return Ret;
    }

    public ArrayList GetAllLocations(String Peptide2) {
        ArrayList<Object[]> Ret = new ArrayList<Object[]>();
        if (Peptide2.indexOf(46) >= 0) {
            Peptide2 = String.valueOf(Peptide2.charAt(0)) + Peptide2.substring(2, Peptide2.length() - 2) + Peptide2.charAt(Peptide2.length() - 1);
        }
        int i = 0;
        while (i < this.NumProteins) {
            String ProteinSequence = this.getProteinSequence(i);
            if (ProteinSequence != null) {
                int Index = ProteinSequence.indexOf(Peptide2);
                while (Index >= 0) {
                    String LeftAA = "*";
                    String RightAA = "*";
                    if (Index > 0) {
                        LeftAA = "" + ProteinSequence.charAt(Index - 1);
                    }
                    if (Index + Peptide2.length() < ProteinSequence.length()) {
                        RightAA = "" + ProteinSequence.charAt(Index + Peptide2.length());
                    }
                    Object[] NewLocation = new Object[]{String.valueOf(LeftAA) + "." + Peptide2 + "." + RightAA, new Integer(i), new Integer(Index), this.getProteinName(i)};
                    Ret.add(NewLocation);
                    Index = ProteinSequence.indexOf(Peptide2, Index + 1);
                }
            }
            ++i;
        }
        return Ret;
    }

    public String getTrieFileName() {
        return this.DBFileName;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public Hashtable GetAllLocations(String[] allPeptides) {
        LocalDebug = false;
        Ret = new Hashtable<String, ArrayList>();
        startIndex = 0;
        endIndex = Math.min(allPeptides.length, 5000);
        while (startIndex < allPeptides.length) {
            Peptides = new String[endIndex - startIndex];
            i = 0;
            while (i < Peptides.length) {
                Peptides[i] = allPeptides[startIndex + i];
                ++i;
            }
            System.out.println("Searching " + Peptides.length + " peptides against trie...");
            Root = TrieDB.BuildTrieStruct(Peptides);
            if (LocalDebug) {
                System.out.println("Finished building trie of " + Peptides.length + " peptides...");
            }
            i = 0;
            while (i < this.NumProteins) {
                block12: {
                    block11: {
                        CurrNode = Root;
                        ProteinSequence = this.getProteinSequence(i);
                        if (ProteinSequence != null) break block11;
                        System.out.println("ERROR: Protein " + i + "/" + this.NumProteins + " is null!!");
                        break block12;
                    }
                    ProteinSequence = ProteinSequence.toUpperCase();
                    if (i % 500000 == 0 && LocalDebug) {
                        System.out.println("Searched " + i + "/" + this.NumProteins);
                    }
                    j = 0;
                    while (j < ProteinSequence.length()) {
                        nextTrans = ProteinSequence.charAt(j) - 65;
                        if (nextTrans >= 0 && nextTrans < 26) ** GOTO lbl34
                        System.out.println("Irregular Protein: " + ProteinSequence);
                        break;
lbl-1000:
                        // 1 sources

                        {
                            CurrNode = CurrNode.FailureNode;
lbl34:
                            // 2 sources

                            ** while (CurrNode.Transitions[nextTrans] == null)
                        }
lbl35:
                        // 1 sources

                        CurrNode = CurrNode.Transitions[nextTrans];
                        if (CurrNode.OutputPeptides != null) {
                            k = 0;
                            while (k < CurrNode.OutputPeptides.length) {
                                Temp = null;
                                Temp = Ret.containsKey(CurrNode.OutputPeptides[k]) == false ? new ArrayList() : (ArrayList)Ret.get(CurrNode.OutputPeptides[k]);
                                LeftAA = "*";
                                RightAA = "*";
                                if (j - CurrNode.OutputPeptides[k].length() + 1 > 0) {
                                    LeftAA = "" + ProteinSequence.charAt(j - CurrNode.OutputPeptides[k].length());
                                }
                                if (j + 1 < ProteinSequence.length()) {
                                    RightAA = "" + ProteinSequence.charAt(j + 1);
                                }
                                NewLocation = new Object[]{String.valueOf(LeftAA) + "." + CurrNode.OutputPeptides[k] + "." + RightAA, new Integer(i), new Integer(j - CurrNode.OutputPeptides[k].length() + 1), this.getProteinName(i)};
                                Temp.add(NewLocation);
                                Ret.put(CurrNode.OutputPeptides[k], Temp);
                                ++k;
                            }
                        }
                        ++j;
                    }
                }
                ++i;
            }
            startIndex = endIndex;
            endIndex = Math.min(allPeptides.length, startIndex + 5000);
        }
        return Ret;
    }

    public static TrieNode BuildTrieStruct(String[] Peptides) {
        int NodeCount = 0;
        TrieNode RootState = new TrieNode(NodeCount);
        boolean LocalDebug = false;
        int i = 0;
        while (i < Peptides.length) {
            if (Peptides[i] != null) {
                String CurrPeptide = Peptides[i].toUpperCase();
                CurrPeptide = CurrPeptide.replace("_", "");
                if ((CurrPeptide = CurrPeptide.replace("?", "")).indexOf(46) >= 0) {
                    if ((CurrPeptide = String.valueOf(CurrPeptide.charAt(0)) + CurrPeptide.substring(2, CurrPeptide.length() - 2) + CurrPeptide.charAt(CurrPeptide.length() - 1)).charAt(0) < 'A' || CurrPeptide.charAt(0) >= '[') {
                        CurrPeptide = CurrPeptide.substring(1);
                    }
                    if (CurrPeptide.charAt(CurrPeptide.length() - 1) < 'A' || CurrPeptide.charAt(CurrPeptide.length() - 1) >= '[') {
                        CurrPeptide = CurrPeptide.substring(0, CurrPeptide.length() - 1);
                    }
                }
                if (LocalDebug) {
                    System.out.println("Adding " + CurrPeptide + " to Trie");
                }
                TrieNode CurrNode = RootState;
                int j = 0;
                int nextTrans = CurrPeptide.charAt(j) - 65;
                if (nextTrans < 0 || nextTrans >= 26) {
                    System.out.println("Funky letters in " + Peptides[i]);
                }
                while (CurrNode.Transitions[nextTrans] != null) {
                    if (LocalDebug) {
                        System.out.println("We have a transltion at state " + CurrNode.StateNum + " for " + CurrPeptide.charAt(j));
                    }
                    CurrNode = CurrNode.Transitions[nextTrans];
                    if (++j == CurrPeptide.length()) break;
                    nextTrans = CurrPeptide.charAt(j) - 65;
                    if (nextTrans >= 0 && nextTrans < 26) continue;
                    System.out.println("Funky letters in " + Peptides[i]);
                }
                int p = j;
                while (p < CurrPeptide.length()) {
                    TrieNode NextNode = new TrieNode(++NodeCount);
                    if (LocalDebug) {
                        System.out.println("Need a new state for transition at state " + CurrNode.StateNum + " for " + CurrPeptide.charAt(p));
                    }
                    if ((nextTrans = CurrPeptide.charAt(p) - 65) < 0 || nextTrans >= 26) {
                        System.out.println("Funky letters in " + Peptides[i]);
                    }
                    CurrNode.Transitions[nextTrans] = NextNode;
                    CurrNode = NextNode;
                    ++p;
                }
                if (LocalDebug) {
                    System.out.println("Adding peptide as output at " + CurrNode.StateNum);
                }
                CurrNode.AddNewOutputString(Peptides[i]);
            }
            ++i;
        }
        i = 0;
        while (i < RootState.Transitions.length) {
            if (RootState.Transitions[i] == null) {
                RootState.Transitions[i] = RootState;
            }
            ++i;
        }
        LinkedList<TrieNode> Q = new LinkedList<TrieNode>();
        int a = 0;
        while (a < 26) {
            if (RootState.Transitions[a].StateNum != 0 && !Q.contains(RootState.Transitions[a])) {
                Q.add(RootState.Transitions[a]);
                RootState.Transitions[a].FailureNode = RootState;
            }
            ++a;
        }
        while (Q.peek() != null) {
            TrieNode r = (TrieNode)Q.remove();
            int a2 = 0;
            while (a2 < 26) {
                if (r.Transitions[a2] != null) {
                    if (!Q.contains(r.Transitions[a2])) {
                        Q.add(r.Transitions[a2]);
                    }
                    TrieNode State2 = r.FailureNode;
                    while (State2.Transitions[a2] == null) {
                        State2 = State2.FailureNode;
                    }
                    r.Transitions[a2].FailureNode = State2.Transitions[a2];
                    r.Transitions[a2].AddNewOutputStrings(r.Transitions[a2].FailureNode.OutputPeptides);
                }
                ++a2;
            }
        }
        return RootState;
    }

    public static TrieNode BuildTrieStructNoFail(String[] Peptides) {
        int NodeCount = 0;
        TrieNode RootState = new TrieNode(NodeCount);
        boolean LocalDebug = false;
        int i = 0;
        while (i < Peptides.length) {
            if (Peptides[i] != null) {
                String CurrPeptide = Peptides[i].toUpperCase();
                if (CurrPeptide.indexOf(".") >= 0) {
                    if ((CurrPeptide = String.valueOf(CurrPeptide.charAt(0)) + CurrPeptide.substring(2, CurrPeptide.length() - 2) + CurrPeptide.charAt(CurrPeptide.length() - 1)).charAt(0) < 'A' || CurrPeptide.charAt(0) >= '[') {
                        CurrPeptide = CurrPeptide.substring(1);
                    }
                    if (CurrPeptide.charAt(CurrPeptide.length() - 1) < 'A' || CurrPeptide.charAt(CurrPeptide.length() - 1) >= '[') {
                        CurrPeptide = CurrPeptide.substring(0, CurrPeptide.length() - 1);
                    }
                }
                if (LocalDebug) {
                    System.out.println("Adding " + CurrPeptide + " to Trie");
                }
                TrieNode CurrNode = RootState;
                int j = 0;
                int nextTrans = CurrPeptide.charAt(j) - 65;
                if (nextTrans < 0 || nextTrans >= 26) {
                    System.out.println("Funky letters in " + Peptides[i]);
                }
                while (CurrNode.Transitions[nextTrans] != null) {
                    if (LocalDebug) {
                        System.out.println("We have a transltion at state " + CurrNode.StateNum + " for " + CurrPeptide.charAt(j));
                    }
                    CurrNode = CurrNode.Transitions[nextTrans];
                    if (++j == CurrPeptide.length()) break;
                    nextTrans = CurrPeptide.charAt(j) - 65;
                    if (nextTrans >= 0 && nextTrans < 26) continue;
                    System.out.println("Funky letters in " + Peptides[i]);
                }
                int p = j;
                while (p < CurrPeptide.length()) {
                    TrieNode NextNode = new TrieNode(++NodeCount);
                    if (LocalDebug) {
                        System.out.println("Need a new state for transition at state " + CurrNode.StateNum + " for " + CurrPeptide.charAt(p));
                    }
                    if ((nextTrans = CurrPeptide.charAt(p) - 65) < 0 || nextTrans >= 26) {
                        System.out.println("Funky letters in " + Peptides[i]);
                    }
                    CurrNode.Transitions[nextTrans] = NextNode;
                    CurrNode = NextNode;
                    ++p;
                }
                if (LocalDebug) {
                    System.out.println("Adding peptide as output at " + CurrNode.StateNum);
                }
                CurrNode.AddNewOutputString(Peptides[i]);
            }
            ++i;
        }
        i = 0;
        while (i < RootState.Transitions.length) {
            if (RootState.Transitions[i] == null) {
                RootState.Transitions[i] = RootState;
            }
            ++i;
        }
        return RootState;
    }

    public static int[] GetMostCoveredProteins(int NumProteins, TrieDB Trie, String InspectDir) {
        Hashtable<Integer, boolean[]> Proteins;
        boolean LocalDebug;
        block42: {
            LocalDebug = false;
            String[] InspectResults = InspectAnnotation.LoadPeptidesDir(InspectDir);
            Hashtable<String, Integer> PeptidesSearched = new Hashtable<String, Integer>();
            Proteins = new Hashtable<Integer, boolean[]>();
            Hashtable<Integer, String> ProteinSeqs = new Hashtable<Integer, String>();
            ArrayList<String> CurrPeptides = new ArrayList<String>();
            int i = 0;
            while (i < InspectResults.length) {
                block39: {
                    String ModdedPeptide = InspectResults[i];
                    String PeptideSeq = Utils.GetUnModded(ModdedPeptide);
                    if (PeptidesSearched.containsKey(PeptideSeq)) break block39;
                    if (!CurrPeptides.contains(PeptideSeq)) {
                        CurrPeptides.add(PeptideSeq);
                    }
                    if (CurrPeptides.size() < 5000) break block39;
                    Hashtable Locs = Trie.GetAllLocations(Utils.ConvertArraylistToStringArray(CurrPeptides));
                    Enumeration PeptidesFound = Locs.keys();
                    while (PeptidesFound.hasMoreElements()) {
                        String CurrPeptide = (String)PeptidesFound.nextElement();
                        if (LocalDebug) {
                            System.out.println("FOund locations for " + CurrPeptide);
                        }
                        PeptidesSearched.put(CurrPeptide, new Integer(1));
                        ArrayList CurrLocs = (ArrayList)Locs.get(CurrPeptide);
                        int j = 0;
                        while (j < CurrLocs.size()) {
                            block41: {
                                String ProteinSeq;
                                Integer ProteinID;
                                block40: {
                                    Object[] CurrLoc = (Object[])CurrLocs.get(j);
                                    ProteinID = (Integer)CurrLoc[0];
                                    if (Proteins.containsKey(ProteinID)) break block40;
                                    if (LocalDebug) {
                                        System.out.println("This is the first tiem we've seen " + ProteinID + " - " + Trie.getProteinName(ProteinID));
                                    }
                                    if ((ProteinSeq = Trie.getProteinSequence(ProteinID)).length() < 50) break block41;
                                    if (LocalDebug) {
                                        System.out.println("ProteinSeq: " + ProteinSeq);
                                        System.out.println("Len: " + ProteinSeq.length());
                                    }
                                    boolean[] Temp = new boolean[ProteinSeq.length()];
                                    int t = 0;
                                    while (t < Temp.length) {
                                        Temp[t] = false;
                                        ++t;
                                    }
                                    Proteins.put(ProteinID, Temp);
                                    ProteinSeqs.put(ProteinID, ProteinSeq);
                                }
                                if (LocalDebug) {
                                    System.out.println("Adding to coverage of " + CurrPeptide + " to " + ProteinID);
                                }
                                ProteinSeq = (String)ProteinSeqs.get(ProteinID);
                                boolean[] Coverage = (boolean[])Proteins.get(ProteinID);
                                int Index = ProteinSeq.indexOf(CurrPeptide);
                                if (LocalDebug) {
                                    System.out.println("Peptide found at " + Index);
                                }
                                if (Index < 0) {
                                    System.err.println("ERROR: Peptide " + CurrPeptide + " not found in " + ProteinSeq);
                                    Utils.WaitForEnter();
                                } else {
                                    int k = Index;
                                    while (k < CurrPeptide.length() + Index) {
                                        Coverage[k] = true;
                                        ++k;
                                    }
                                    Proteins.put(ProteinID, Coverage);
                                    if (LocalDebug) {
                                        System.out.println("Coverage: " + Utils.BooleanArrayToString(Coverage));
                                        Utils.WaitForEnter();
                                    }
                                }
                            }
                            ++j;
                        }
                    }
                    CurrPeptides.clear();
                }
                ++i;
            }
            if (CurrPeptides.size() <= 0) break block42;
            Hashtable Locs = Trie.GetAllLocations(Utils.ConvertArraylistToStringArray(CurrPeptides));
            Enumeration PeptidesFound = Locs.keys();
            while (PeptidesFound.hasMoreElements()) {
                String CurrPeptide = (String)PeptidesFound.nextElement();
                if (LocalDebug) {
                    System.out.println("FOund locations for " + CurrPeptide);
                }
                PeptidesSearched.put(CurrPeptide, new Integer(1));
                ArrayList CurrLocs = (ArrayList)Locs.get(CurrPeptide);
                int j = 0;
                while (j < CurrLocs.size()) {
                    block44: {
                        String ProteinSeq;
                        Integer ProteinID;
                        block43: {
                            Object[] CurrLoc = (Object[])CurrLocs.get(j);
                            ProteinID = (Integer)CurrLoc[0];
                            if (Proteins.containsKey(ProteinID)) break block43;
                            if (LocalDebug) {
                                System.out.println("This is the first tiem we've seen " + ProteinID + " - " + Trie.getProteinName(ProteinID));
                            }
                            if ((ProteinSeq = Trie.getProteinSequence(ProteinID)).length() < 50) break block44;
                            if (LocalDebug) {
                                System.out.println("ProteinSeq: " + ProteinSeq);
                                System.out.println("Len: " + ProteinSeq.length());
                            }
                            boolean[] Temp = new boolean[ProteinSeq.length()];
                            int t = 0;
                            while (t < Temp.length) {
                                Temp[t] = false;
                                ++t;
                            }
                            Proteins.put(ProteinID, Temp);
                            ProteinSeqs.put(ProteinID, ProteinSeq);
                        }
                        if (LocalDebug) {
                            System.out.println("Adding to coverage of " + ProteinID);
                        }
                        ProteinSeq = (String)ProteinSeqs.get(ProteinID);
                        boolean[] Coverage = (boolean[])Proteins.get(ProteinID);
                        int Index = ProteinSeq.indexOf(CurrPeptide);
                        if (Index < 0) {
                            System.err.println("ERROR: Peptide " + CurrPeptide + " not found in " + ProteinSeq);
                            Utils.WaitForEnter();
                        } else {
                            int k = Index;
                            while (k < CurrPeptide.length() + Index) {
                                Coverage[k] = true;
                                ++k;
                            }
                            Proteins.put(ProteinID, Coverage);
                            if (LocalDebug) {
                                System.out.println("Coverage: " + Utils.BooleanArrayToString(Coverage));
                                Utils.WaitForEnter();
                            }
                        }
                    }
                    ++j;
                }
            }
            CurrPeptides.clear();
        }
        int[] Ret = new int[NumProteins];
        double[] Covered = new double[Ret.length];
        double MinCoverage = 0.0;
        int MinIndex = 0;
        Enumeration ProteinIDs = Proteins.keys();
        while (ProteinIDs.hasMoreElements()) {
            Integer CurrID = (Integer)ProteinIDs.nextElement();
            boolean[] Coverage = (boolean[])Proteins.get(CurrID);
            int Count = 0;
            int i = 0;
            while (i < Coverage.length) {
                if (Coverage[i]) {
                    ++Count;
                }
                ++i;
            }
            double AmtCovered = (double)Count / (double)Coverage.length;
            if (LocalDebug) {
                System.out.println(" " + CurrID + " = " + AmtCovered);
            }
            if (!(AmtCovered > MinCoverage)) continue;
            if (LocalDebug) {
                System.out.println("Coverage is ranked for " + CurrID + " = " + AmtCovered);
            }
            Ret[MinIndex] = CurrID;
            Covered[MinIndex] = AmtCovered;
            MinCoverage = AmtCovered;
            int j = 0;
            while (j < Ret.length) {
                if (Covered[j] < MinCoverage) {
                    MinCoverage = Covered[j];
                    MinIndex = j;
                }
                ++j;
            }
            if (!LocalDebug) continue;
            System.out.println("New Min coverage: " + MinCoverage + " at index " + MinIndex);
        }
        int i = 0;
        while (i < NumProteins) {
            System.out.println("[" + i + "] = Protein(" + Ret[i] + ")-" + Trie.getProteinName(Ret[i]) + " = " + Covered[i]);
            boolean[] Coverage = (boolean[])Proteins.get(Ret[i]);
            System.out.println(Utils.BooleanArrayToString(Coverage));
            ++i;
        }
        return Ret;
    }

    public static String[] GetAllSpectraFiles(int[] ProteinIDs, TrieDB DB, String Dir) {
        System.out.println("Getting Spectra for " + ProteinIDs.length + " proteins");
        String[] ProteinSeqs = new String[ProteinIDs.length];
        int i = 0;
        while (i < ProteinSeqs.length) {
            ProteinSeqs[i] = DB.getProteinSequence(ProteinIDs[i]);
            ++i;
        }
        File InDir = new File(Dir);
        String[] Files = InDir.list();
        Hashtable<String, Integer> FilesToCopy = new Hashtable<String, Integer>();
        int k = 0;
        while (k < Files.length) {
            String[] Peptides = InspectAnnotation.LoadPeptidesFile(String.valueOf(InDir.getAbsolutePath()) + File.separator + Files[k]);
            int CurrCount = 0;
            int i2 = 0;
            while (Peptides != null && i2 < Peptides.length) {
                int j = 0;
                while (j < ProteinSeqs.length) {
                    if (ProteinSeqs[j].indexOf(Peptides[i2]) > 0) {
                        ++CurrCount;
                        System.out.println("Peptide found: " + Peptides[i2]);
                        break;
                    }
                    ++j;
                }
                ++i2;
            }
            if (CurrCount >= 1) {
                FilesToCopy.put(Files[k], new Integer(CurrCount));
                System.out.println(String.valueOf(Files[k]) + " = " + CurrCount);
            }
            ++k;
        }
        Enumeration Keys = FilesToCopy.keys();
        String[] Ret = new String[FilesToCopy.size()];
        int Index = 0;
        while (Keys.hasMoreElements()) {
            String File2;
            Ret[Index] = File2 = (String)Keys.nextElement();
            ++Index;
        }
        return Ret;
    }

    public static void GetAllSpectraFilesSpectra(int[] ProteinIDs, TrieDB DB, String Dir, String SpectrumDir, String OutputDir) {
        System.out.println("Getting Spectra for " + ProteinIDs.length + " proteins");
        String[] ProteinSeqs = new String[ProteinIDs.length];
        int i = 0;
        while (i < ProteinSeqs.length) {
            ProteinSeqs[i] = DB.getProteinSequence(ProteinIDs[i]);
            System.out.println("Protein " + ProteinIDs[i] + ": " + ProteinSeqs[i]);
            ++i;
        }
        File InDir = new File(Dir);
        String[] Files = InDir.list();
        int k = 0;
        while (k < Files.length) {
            ArrayList<Integer> ScanNums = new ArrayList<Integer>();
            InspectAnnotation[] Anns = InspectAnnotation.LoadInspectResultsFile(String.valueOf(InDir.getAbsolutePath()) + File.separator + Files[k]);
            int CurrCount = 0;
            int i2 = 0;
            while (i2 < Anns.length) {
                String CurrPep = Utils.GetUnModded(Anns[i2].Annotation);
                int j = 0;
                while (j < ProteinSeqs.length) {
                    if (ProteinSeqs[j].indexOf(CurrPep) > 0) {
                        ++CurrCount;
                        System.out.println("Peptide found: " + CurrPep);
                        ScanNums.add(new Integer(Anns[i2].ScanNumber));
                        break;
                    }
                    ++j;
                }
                ++i2;
            }
            if (ScanNums.size() > 0) {
                int[] Scans = Utils.ConvertArraylistToIntArray(ScanNums);
                MGFExtractor.ExtractMGFSpectra(String.valueOf(SpectrumDir) + File.separator + Utils.GetBaseNameNoExtension(Files[k]) + ".mgf", String.valueOf(OutputDir) + File.separator + Utils.GetBaseNameNoExtension(Files[k]) + ".mgf", Scans);
            }
            ++k;
        }
    }

    public static int RemoveAllFASTAEntries(String CombinedDBFasta, String CombinedDBFasta_Reduced, String[] BadWords) {
        BufferedReader Buf = null;
        FileWriter Writer2 = null;
        String Line = null;
        int Count = 0;
        try {
            Buf = new BufferedReader(new FileReader(CombinedDBFasta));
            Writer2 = new FileWriter(CombinedDBFasta_Reduced);
            Line = Buf.readLine();
        }
        catch (Exception E) {
            E.printStackTrace();
            return -1;
        }
        String CurrHeader = null;
        String CurrProtein = null;
        while (Line != null) {
            if (Line.length() == 0 || Line.length() > 0 && Line.charAt(0) == '>') {
                if (CurrProtein != null) {
                    boolean Found = false;
                    int i = 0;
                    while (i < BadWords.length) {
                        if (CurrProtein.toUpperCase().indexOf(BadWords[i].toUpperCase()) >= 0) {
                            ++Count;
                            Found = true;
                            break;
                        }
                        ++i;
                    }
                    if (!Found) {
                        try {
                            Writer2.write(String.valueOf(CurrHeader) + "\n");
                            Writer2.write(String.valueOf(CurrProtein) + "\n");
                        }
                        catch (Exception E) {
                            E.printStackTrace();
                            return -1;
                        }
                    }
                }
                CurrHeader = Line;
                CurrProtein = "";
                continue;
            }
            CurrProtein = String.valueOf(CurrProtein) + Line;
        }
        return 0;
    }

    public static boolean sanityCheck(TrieDB testDB) {
        if (testDB.NumProteins <= 0) {
            System.out.println("ERROR: " + testDB.DBFileName + " has " + testDB.NumProteins + " proteins!");
            return false;
        }
        System.out.println("sanityCheck: " + testDB.DBFileName + " has " + testDB.NumProteins + " proteins");
        int i = 0;
        while (i < testDB.NumProteins) {
            String name = testDB.getProteinName(i);
            String seq = testDB.getProteinSequence(i);
            long fastaPos = testDB.GetFASTAPos(i);
            int startTriePos = testDB.GetTriePos(i);
            int endTriePos = testDB.GetTriePos(i + 1);
            if (name == null || name.length() == 0) {
                System.out.println("ERROR: " + testDB.DBFileName + " has a null or zero-length protein name at Record " + i);
                return false;
            }
            if (seq == null || seq.length() == 0) {
                System.out.println("ERROR: " + testDB.DBFileName + " has a null or zero-length protein sequence at Record " + i);
                return false;
            }
            if (fastaPos < 0L) {
                System.out.println("ERROR: " + testDB.DBFileName + " has an invalid FASTA position '" + fastaPos + "' at Record " + i);
                return false;
            }
            if (startTriePos < 0 || i < testDB.NumProteins - 1 && endTriePos < 0 || i < testDB.NumProteins - 1 && endTriePos < startTriePos) {
                System.out.println("ERROR: " + testDB.DBFileName + " has an invalid trie positions '" + startTriePos + "' and '" + endTriePos + "' at Record " + i);
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isEqual(TrieDB db1, TrieDB db2) {
        boolean ret = true;
        if (db1.NumAA != db2.NumAA) {
            System.out.println("ERROR: " + db1.DBFileName + " has " + db1.NumAA + " AAs while " + db2.DBFileName + " has " + db2.NumAA + " AAs!");
            ret = false;
            Utils.WaitForEnter();
        }
        if (db1.NumProteins != db2.NumProteins) {
            System.out.println(String.valueOf(db1.DBFileName) + " has " + db1.NumProteins + " Proteins while " + db2.DBFileName + " has " + db2.NumProteins + " Proteins!");
            ret = false;
            Utils.WaitForEnter();
        }
        int i = 0;
        while (i < Math.min(db1.NumProteins, db2.NumProteins)) {
            String seq2;
            String seq1;
            String name2;
            String name1 = db1.getProteinName(i);
            if (name1.compareTo(name2 = db2.getProteinName(i)) != 0) {
                System.out.println("DBs have different protein names for record " + i);
                System.out.println(String.valueOf(db1.DBFileName) + " has name " + name1);
                System.out.println(String.valueOf(db2.DBFileName) + " has name " + name2);
                ret = false;
                Utils.WaitForEnter();
            }
            if ((seq1 = db1.getProteinSequence(i)).compareTo(seq2 = db2.getProteinSequence(i)) != 0) {
                System.out.println("DBs have different protein seqs for record " + i);
                System.out.println(String.valueOf(db1.DBFileName) + " has seq " + seq1);
                System.out.println(String.valueOf(db2.DBFileName) + " has seq " + seq2);
                ret = false;
                Utils.WaitForEnter();
            }
            ++i;
        }
        return ret;
    }

    private Hashtable GetAllLocations1MisMatchHelper(TrieNode CurrNode, Hashtable Ret, int misMatchPos, String ProteinName, int proteinID, String ProteinSequence, int startIndex, int currIndex) {
        boolean localDebug = false;
        if (localDebug) {
            System.out.println("Call to GetAllLocations1MisMatchHelper:");
            System.out.println("  currNode: " + CurrNode.StateNum);
            System.out.println("  misMatchPos: " + misMatchPos);
            System.out.println("  ProteinName: " + ProteinName);
            System.out.println("  Length: " + ProteinSequence.length());
            System.out.println("  proteinID: " + proteinID);
            System.out.println("  startIndex: " + startIndex);
            System.out.println("  currIndex: " + currIndex);
        }
        if (CurrNode.OutputPeptides != null) {
            int k = 0;
            while (k < CurrNode.OutputPeptides.length) {
                if (localDebug) {
                    System.out.println("OutputPeptide: " + CurrNode.OutputPeptides[k]);
                }
                ArrayList Temp = null;
                Temp = !Ret.containsKey(CurrNode.OutputPeptides[k]) ? new ArrayList() : (ArrayList)Ret.get(CurrNode.OutputPeptides[k]);
                int NullIndex = ProteinName.indexOf(0);
                if (NullIndex < 0) {
                    NullIndex = ProteinName.length();
                }
                String LeftAA = "*";
                String RightAA = "*";
                if (startIndex > 0) {
                    LeftAA = "" + ProteinSequence.charAt(startIndex - 1);
                }
                if (currIndex < ProteinSequence.length()) {
                    RightAA = "" + ProteinSequence.charAt(currIndex);
                }
                Object[] NewLocation = new Object[]{String.valueOf(LeftAA) + "." + CurrNode.OutputPeptides[k] + "." + RightAA, new Integer(proteinID), new Integer(startIndex), ProteinName, misMatchPos};
                Temp.add(NewLocation);
                Ret.put(CurrNode.OutputPeptides[k], Temp);
                ++k;
            }
        }
        if (currIndex == ProteinSequence.length()) {
            if (localDebug) {
                System.out.println("Reached end of protein!!");
            }
            return Ret;
        }
        int nextTrans = ProteinSequence.charAt(currIndex) - 65;
        if (localDebug) {
            System.out.println("Next AA: " + (char)(nextTrans + 65));
        }
        if (nextTrans < 0 || nextTrans >= 26) {
            System.out.println("Fucked up Protein: " + ProteinSequence);
        }
        if (CurrNode.Transitions[nextTrans] == null && misMatchPos >= 0) {
            return Ret;
        }
        int i = 0;
        while (i < CurrNode.Transitions.length) {
            if (i == nextTrans && CurrNode.Transitions[i] != null) {
                if (localDebug) {
                    System.out.println("No-mismatch transition");
                }
                CurrNode = CurrNode.Transitions[i];
                Ret = this.GetAllLocations1MisMatchHelper(CurrNode, Ret, misMatchPos, ProteinName, proteinID, ProteinSequence, startIndex, currIndex + 1);
            } else if (CurrNode.Transitions[i] != null && misMatchPos < 0) {
                if (localDebug) {
                    System.out.println("mismatch transition");
                }
                CurrNode = CurrNode.Transitions[i];
                Ret = this.GetAllLocations1MisMatchHelper(CurrNode, Ret, currIndex - startIndex, ProteinName, proteinID, ProteinSequence, startIndex, currIndex + 1);
            }
            ++i;
        }
        return Ret;
    }

    public Hashtable GetAllLocations1MisMatch(String[] Peptides) {
        boolean LocalDebug = false;
        TrieNode Root = TrieDB.BuildTrieStructNoFail(Peptides);
        if (LocalDebug) {
            System.out.println("Finished building trie of " + Peptides.length + " peptides...");
        }
        Hashtable Ret = new Hashtable();
        try {
            this.IndexReader.seek(0L);
        }
        catch (Exception E) {
            System.err.println("ERROR:GetAllLocations1MisMatch: " + E.getMessage());
            return null;
        }
        byte[] B = new byte[80];
        long FASTAPos = 0L;
        int TriePos = 0;
        int i = 0;
        while (i < this.NumProteins) {
            TrieNode CurrNode = Root;
            String ProteinSequence = this.getProteinSequence(i);
            if (ProteinSequence == null) {
                System.out.println("ERROR: Protein " + i + "/" + this.NumProteins + " is null!!");
            } else {
                ProteinSequence = ProteinSequence.toUpperCase();
                if (i % 500000 == 0 && LocalDebug) {
                    System.out.println("Searched " + i + "/" + this.NumProteins);
                }
                try {
                    FASTAPos = Long.reverseBytes(this.IndexReader.readLong());
                    TriePos = Integer.reverseBytes(this.IndexReader.readInt());
                    this.IndexReader.read(B);
                }
                catch (Exception E) {
                    break;
                }
                String ProteinName = new String(B);
                ProteinName = ProteinName.trim();
                int NullIndex = ProteinName.indexOf(0);
                if (NullIndex < 0) {
                    NullIndex = ProteinName.length();
                }
                ProteinName = ProteinName.substring(0, NullIndex);
                int j = 0;
                while (j < ProteinSequence.length()) {
                    Ret = this.GetAllLocations1MisMatchHelper(CurrNode, Ret, -1, ProteinName, i, ProteinSequence, j, j);
                    ++j;
                }
            }
            ++i;
        }
        return Ret;
    }

    public static int printProteinInfo(String trieFileName, String outputFileName) {
        TrieDB d = new TrieDB(trieFileName);
        int numProteins = d.getNumProteins();
        try {
            d.IndexReader.seek(0L);
        }
        catch (Exception E) {
            System.err.println("ERROR:GetFASTAPos: " + E.getMessage());
            return -1;
        }
        byte[] B = new byte[80];
        long FASTAPos = 0L;
        int TriePos = 0;
        FileWriter f = null;
        try {
            f = new FileWriter(outputFileName);
        }
        catch (IOException E) {
            E.printStackTrace();
            return -1;
        }
        int prevPos = 0;
        String ProteinName = "";
        try {
            FASTAPos = Long.reverseBytes(d.IndexReader.readLong());
            prevPos = Integer.reverseBytes(d.IndexReader.readInt());
            d.IndexReader.read(B);
            ProteinName = new String(B);
            ProteinName = ProteinName.trim();
            int NullIndex = ProteinName.indexOf(0);
            if (NullIndex < 0) {
                NullIndex = ProteinName.length();
            }
            ProteinName = ProteinName.substring(0, NullIndex);
        }
        catch (Exception E) {
            System.err.println("ERROR: " + E);
            return -1;
        }
        int i = 1;
        while (i < numProteins) {
            String line = String.valueOf(i - 1) + "\t" + ProteinName + "\t";
            try {
                FASTAPos = Long.reverseBytes(d.IndexReader.readLong());
                TriePos = Integer.reverseBytes(d.IndexReader.readInt());
                d.IndexReader.read(B);
                line = String.valueOf(line) + (TriePos - prevPos - 1) + "\n";
                f.write(line);
                prevPos = TriePos;
                ProteinName = new String(B);
                ProteinName = ProteinName.trim();
                int NullIndex = ProteinName.indexOf(0);
                if (NullIndex < 0) {
                    NullIndex = ProteinName.length();
                }
                ProteinName = ProteinName.substring(0, NullIndex);
            }
            catch (Exception E) {
                System.err.println("ERROR 2: " + E);
                return -1;
            }
            ++i;
        }
        String lastLine = String.valueOf(numProteins - 1) + "\t" + ProteinName + "\t" + (d.GetNumAA() - (long)prevPos);
        try {
            f.write(String.valueOf(lastLine) + "\n");
            f.close();
        }
        catch (IOException E) {
            E.printStackTrace();
            return -1;
        }
        return 1;
    }

    public static void main(String[] args) {
        String peptide = "ISRDNAKNTLYLQLSSLRSEDTAFL";
        TrieDB myDB = new TrieDB("/home/natalie/Projects/MySVNProjects/ImmunoSeq/AntibodyData/DBs/IMGT_20120213_HC_LC_RS.trie");
        ArrayList Locations = myDB.GetAllLocations(peptide);
        int i = 0;
        while (i < Locations.size()) {
            Object[] loc = (Object[])Locations.get(i);
            System.out.println("Location[" + i + "] = " + (String)loc[3] + "(" + (Integer)loc[1] + ")");
            ++i;
        }
    }

    public int[] getAllIDsFromName(String correctPeptide) {
        ArrayList<Integer> currList = new ArrayList<Integer>();
        try {
            this.IndexReader.seek(0L);
        }
        catch (Exception E) {
            System.err.println("ERROR:getProteinName: " + E.getMessage());
            return null;
        }
        byte[] B = new byte[80];
        long FASTAPos = 0L;
        int TriePos = 0;
        int Index = 0;
        while (true) {
            block6: {
                try {
                    FASTAPos = Long.reverseBytes(this.IndexReader.readLong());
                    TriePos = Integer.reverseBytes(this.IndexReader.readInt());
                    this.IndexReader.read(B);
                    String SeqName = new String(B);
                    int NullIndex = SeqName.indexOf(0);
                    if (NullIndex < 0) {
                        NullIndex = SeqName.length();
                    }
                    if (!(SeqName = SeqName.substring(0, NullIndex)).equals(correctPeptide)) break block6;
                    currList.add(new Integer(Index));
                }
                catch (Exception E) {
                    break;
                }
            }
            ++Index;
        }
        return Utils.ConvertArraylistToIntArray(currList);
    }

    public Hashtable getAllMatchedNames(Hashtable peptides) {
        Hashtable<String, ArrayList> ret = new Hashtable<String, ArrayList>();
        try {
            this.IndexReader.seek(0L);
        }
        catch (Exception E) {
            System.err.println("ERROR:getProteinName: " + E.getMessage());
            return null;
        }
        byte[] B = new byte[80];
        long FASTAPos = 0L;
        int TriePos = 0;
        int Index = 0;
        while (true) {
            block7: {
                try {
                    FASTAPos = Long.reverseBytes(this.IndexReader.readLong());
                    TriePos = Integer.reverseBytes(this.IndexReader.readInt());
                    this.IndexReader.read(B);
                    String SeqName = new String(B);
                    int NullIndex = SeqName.indexOf(0);
                    if (NullIndex < 0) {
                        NullIndex = SeqName.length();
                    }
                    if (!peptides.containsKey(SeqName = SeqName.substring(0, NullIndex))) break block7;
                    ArrayList a = null;
                    a = ret.containsKey(SeqName) ? (ArrayList)ret.get(SeqName) : new ArrayList();
                    a.add(new Integer(Index));
                    ret.put(SeqName, a);
                }
                catch (Exception E) {
                    break;
                }
            }
            ++Index;
        }
        if (ret.size() != peptides.size()) {
            System.out.println("ERROR: We only found DB entries for " + ret.size() + "/" + peptides.size() + " peptides!!");
            Utils.WaitForEnter();
        }
        return ret;
    }

    public HashSet getAllProteinNames() {
        HashSet<String> ret = new HashSet<String>();
        try {
            this.IndexReader.seek(0L);
        }
        catch (Exception E) {
            System.err.println("ERROR:getAllProteinNames: " + E.getMessage());
            return null;
        }
        byte[] B = new byte[80];
        long FASTAPos = 0L;
        int TriePos = 0;
        int Index = 0;
        while (true) {
            try {
                FASTAPos = Long.reverseBytes(this.IndexReader.readLong());
                TriePos = Integer.reverseBytes(this.IndexReader.readInt());
                this.IndexReader.read(B);
                String SeqName = new String(B);
                int NullIndex = SeqName.indexOf(0);
                if (NullIndex < 0) {
                    NullIndex = SeqName.length();
                }
                SeqName = SeqName.substring(0, NullIndex);
                ret.add(TrieDB.getProteinNameFromFull(SeqName));
            }
            catch (Exception E) {
                break;
            }
            ++Index;
        }
        return ret;
    }

    public double getMeanLength(HashSet filteredNames) {
        double ret = this.getAACount(filteredNames);
        if (filteredNames == null) {
            return ret / (double)this.NumProteins;
        }
        return ret / (double)filteredNames.size();
    }

    public static String getProteinNameFromFull(String fullName) {
        return fullName.split(" ")[0];
    }

    public int[] getStartAACounts(HashSet filteredNames) {
        byte[] Bytes;
        int[] ret = new int[Utils.AAMasses.length];
        ret = Utils.initializeIntArray(ret, 0);
        try {
            this.IndexReader.seek(0L);
        }
        catch (Exception E) {
            System.err.println("ERROR:getStartAACounts: " + E.getMessage());
            return null;
        }
        byte[] B = new byte[80];
        long FASTAPos = 0L;
        int TriePos = 0;
        int Index = 0;
        String prevName = null;
        int prevTriePos = 0;
        String SeqName = null;
        int read = 0;
        int Size = 0;
        while (true) {
            try {
                FASTAPos = Long.reverseBytes(this.IndexReader.readLong());
                TriePos = Integer.reverseBytes(this.IndexReader.readInt());
                this.IndexReader.read(B);
                SeqName = new String(B);
            }
            catch (Exception E) {
                break;
            }
            int NullIndex = SeqName.indexOf(0);
            if (NullIndex < 0) {
                NullIndex = SeqName.length();
            }
            SeqName = SeqName.substring(0, NullIndex);
            SeqName = TrieDB.getProteinNameFromFull(SeqName);
            if (prevName != null && (filteredNames == null || filteredNames.contains(prevName))) {
                int startAA;
                String seq;
                try {
                    Size = TriePos - prevTriePos;
                    Bytes = new byte[Size];
                    read = this.TrieReader.read(Bytes);
                }
                catch (Exception E) {
                    E.printStackTrace();
                    break;
                }
                if (read < Size) {
                    System.err.println("ERROR: Couldn't read the full " + Size + " bytes!! Only got " + read);
                    System.err.println(String.valueOf(prevTriePos) + "-" + TriePos);
                }
                if ((seq = new String(Bytes).trim().toUpperCase()).length() == 0) {
                    System.out.println("Index:" + Index);
                    System.out.println("SeqName: " + SeqName);
                    System.out.println("Size: " + Size);
                }
                int n = startAA = seq.charAt(0) - 65;
                ret[n] = ret[n] + 1;
            } else {
                try {
                    this.TrieReader.seek(TriePos);
                }
                catch (Exception E) {
                    E.printStackTrace();
                    break;
                }
            }
            prevTriePos = TriePos;
            prevName = SeqName;
            ++Index;
        }
        if (filteredNames == null || prevName != null && filteredNames.contains(prevName)) {
            try {
                int startAA;
                Size = (int)(this.TrieReader.length() - (long)prevTriePos);
                Bytes = new byte[Size];
                read = this.TrieReader.read(Bytes);
                String seq = new String(Bytes).trim().toUpperCase();
                if (seq.length() == 0) {
                    System.err.println(prevName);
                    System.err.println("ERROR: Found an invalid protein at triePos " + prevTriePos + " - " + this.TrieReader.length());
                    System.err.println("Only read " + read + " bytes of " + (int)(this.TrieReader.length() - (long)prevTriePos));
                }
                int n = startAA = seq.charAt(0) - 65;
                ret[n] = ret[n] + 1;
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }
        return ret;
    }

    public int getAACount(HashSet filteredNames) {
        int ret = 0;
        try {
            this.IndexReader.seek(0L);
        }
        catch (Exception E) {
            System.err.println("ERROR:getMeanLength: " + E.getMessage());
            return 0;
        }
        byte[] B = new byte[80];
        long FASTAPos = 0L;
        int TriePos = 0;
        int Index = 0;
        String prevName = null;
        int prevTriePos = 0;
        while (true) {
            try {
                FASTAPos = Long.reverseBytes(this.IndexReader.readLong());
                TriePos = Integer.reverseBytes(this.IndexReader.readInt());
                this.IndexReader.read(B);
                String SeqName = new String(B);
                int NullIndex = SeqName.indexOf(0);
                if (NullIndex < 0) {
                    NullIndex = SeqName.length();
                }
                SeqName = SeqName.substring(0, NullIndex);
                SeqName = TrieDB.getProteinNameFromFull(SeqName);
                if (filteredNames == null || prevName != null && filteredNames.contains(prevName)) {
                    ret += TriePos - prevTriePos - 1;
                }
                prevTriePos = TriePos;
                prevName = SeqName;
            }
            catch (Exception E) {
                break;
            }
            ++Index;
        }
        if (filteredNames == null || prevName != null && filteredNames.contains(prevName)) {
            try {
                ret = (int)((long)ret + (this.TrieReader.length() - (long)prevTriePos - 1L));
            }
            catch (IOException e) {
                e.printStackTrace();
                return 0;
            }
        }
        return ret;
    }

    public int getAACoverage(double[] workingCoverages, ArrayList workingNamesOrdered) {
        int ret = 0;
        try {
            this.IndexReader.seek(0L);
        }
        catch (Exception E) {
            System.err.println("ERROR:getMeanLength: " + E.getMessage());
            return 0;
        }
        byte[] B = new byte[80];
        long FASTAPos = 0L;
        int TriePos = 0;
        int Index = 0;
        String prevName = null;
        int prevTriePos = 0;
        while (true) {
            try {
                FASTAPos = Long.reverseBytes(this.IndexReader.readLong());
                TriePos = Integer.reverseBytes(this.IndexReader.readInt());
                this.IndexReader.read(B);
                String SeqName = new String(B);
                int NullIndex = SeqName.indexOf(0);
                if (NullIndex < 0) {
                    NullIndex = SeqName.length();
                }
                SeqName = SeqName.substring(0, NullIndex);
                SeqName = TrieDB.getProteinNameFromFull(SeqName);
                if (workingNamesOrdered == null || prevName != null && workingNamesOrdered.contains(prevName)) {
                    int idx = workingNamesOrdered.indexOf(prevName);
                    ret = (int)((double)ret + (double)(TriePos - prevTriePos - 1) * workingCoverages[idx]);
                }
                prevTriePos = TriePos;
                prevName = SeqName;
            }
            catch (Exception E) {
                break;
            }
            ++Index;
        }
        if (workingNamesOrdered == null || prevName != null && workingNamesOrdered.contains(prevName)) {
            int idx = workingNamesOrdered.indexOf(prevName);
            try {
                ret = (int)((double)ret + (double)(this.TrieReader.length() - (long)prevTriePos - 1L) * workingCoverages[idx]);
            }
            catch (IOException e) {
                e.printStackTrace();
                return 0;
            }
        }
        return ret;
    }

    public String getPeptideSeq(long triePos, int length) {
        byte[] Bytes = null;
        try {
            this.TrieReader.seek(triePos);
            Bytes = new byte[length];
            this.TrieReader.read(Bytes);
        }
        catch (Exception E) {
            return null;
        }
        return new String(Bytes).trim();
    }

    public String[] getProteinSequencesFromNames(String[] protNames) {
        String[] ret = new String[protNames.length];
        int i = 0;
        while (i < protNames.length) {
            int id = this.getProteinIDFromPartial(protNames[i]);
            if (id < 0) {
                ErrorThrower.ThrowError(15, "Cannot find id for protein '" + protNames[i] + "'");
                ret[i] = null;
            } else {
                ret[i] = this.getProteinSequence(id);
            }
            ++i;
        }
        return ret;
    }

    public int getProteinID(long triePos) {
        try {
            this.IndexReader.seek(0L);
        }
        catch (Exception E) {
            System.err.println("ERROR:getMeanLength: " + E.getMessage());
            return 0;
        }
        byte[] B = new byte[80];
        int Index = 0;
        boolean prevTriePos = false;
        long FASTAPos = 0L;
        int currTriePos = 0;
        while (true) {
            block6: {
                try {
                    FASTAPos = Long.reverseBytes(this.IndexReader.readLong());
                    currTriePos = Integer.reverseBytes(this.IndexReader.readInt());
                    if ((long)currTriePos > triePos) {
                        return Index - 1;
                    }
                    this.IndexReader.read(B);
                    String SeqName = new String(B);
                    int NullIndex = SeqName.indexOf(0);
                    if (NullIndex >= 0) break block6;
                    NullIndex = SeqName.length();
                }
                catch (Exception E) {
                    break;
                }
            }
            ++Index;
        }
        return this.NumProteins - 1;
    }

    public String getProteinName(long triePos) {
        int index = this.getProteinID(triePos);
        return this.getProteinName(index);
    }

    public static class TrieLocationColumns {
        public static final int Peptide = 0;
        public static final int ProteinID = 1;
        public static final int Index = 2;
        public static final int ProteinName = 3;
    }
}

