/*
 * Decompiled with CFR 0.152.
 */
package basicUtils;

import basicUtils.Utils;
import errorUtils.ErrorThrower;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;

public class InspectAnnotation {
    public static final String RESERVED_CHAR = "@";
    public static String EMPTY_STRING = "";
    public String SpectrumFile;
    public int ScanNumber;
    public String AnnotationWithFlanking;
    public String Annotation;
    public String ProteinName;
    public int Charge = -1;
    public double MQScore = 0.0;
    public int Length = 0;
    public int NTT = -1;
    public double FDR = -1.0;
    public double FScore = 0.0;
    public double DeltaScoreAny = 0.0;
    public double DeltaScore = 0.0;
    public int ProteinID = -1;
    public int TrieDBPos = -1;
    public int SpecFileOffset = -1;
    public double ParentMZ = 0.0;
    public double MZError = Double.MAX_VALUE;
    public double TotalPRMScore = -1.0;
    public double MedianPRMScore = -1.0;
    public double FractionY = -1.0;
    public double FractionB = -1.0;
    public double Intensity = -1.0;
    public int SpecIndex = -1;
    public String[] columnHeaders = null;
    public int Chromosome = -1;
    public int Strand = -1;
    public String GenomicPos = EMPTY_STRING;
    public String SplicedSequence = EMPTY_STRING;
    public String Splices = EMPTY_STRING;
    public String SearchDB = EMPTY_STRING;
    public double SpecProb = -1.0;
    public double LocalFDR = -1.0;
    public double DeltaKnown = Double.NaN;
    public String DeltaKnownAnn = null;
    public boolean IsNovel;
    public String OriginalLine;
    public String OriginalFileName = EMPTY_STRING;
    public String SourceProgram = "Inspect";
    public boolean IsUnique = false;
    public static String HeaderLineDefault = "#SpectrumFile\tScan#\tAnnotation\tProtein\tCharge\tMQScore\tLength\tTotalPRMScore\tMedianPRMScore\tFractionY\tFractionB\tInstensity\tNTT\tInspectFDR\tF-Score\tDeltaScore\tDeltaScoreOther\tRecordNumber\tDBFilePos\tSpecFilePos\tFileMZ\tMZError\tUnModdedAnnotation\n";
    public static String SplicedHeaderLineDefault = "#SpectrumFile\tScan#\tAnnotation\tProtein\tCharge\tMQScore\tLength\tTotalPRMScore\tMedianPRMScore\tFractionY\tFractionB\tInstensity\tNTT\tInspectFDR\tF-Score\tDeltaScore\tDeltaScoreOther\tRecordNumber\tDBFilePos\tSpecFilePos\tFileMZ\tMZError\tChromosome\tStrand\tGenomicPos\tSplicedSequence\tSplices\tSearchDB\tOriginalFile\tLocalFDR\tDeltaKnown\tDeltaKnownAnn\tIsNovel\tSpecProb\n";
    public static String SplicedHeaderLineNoSpecProbDefault = "#SpectrumFile\tScan#\tAnnotation\tProtein\tCharge\tMQScore\tLength\tTotalPRMScore\tMedianPRMScore\tFractionY\tFractionB\tInstensity\tNTT\tInspectFDR\tF-Score\tDeltaScore\tDeltaScoreOther\tRecordNumber\tDBFilePos\tSpecFilePos\tFileMZ\tMZError\tChromosome\tStrand\tGenomicPos\tSplicedSequence\tSplices\tSearchDB\tOriginalFile\tLocalFDR\tDeltaKnown\tDeltaKnownAnn\tIsNovel\n";
    private static final String MSGFDBHeaderLineDefault = "#SpecFile\tSpecIndex\tScan#\tFragMethod\tPrecursor\tPMError(Da)\tCharge\tPeptide\tProtein\tDeNovoScore\tMSGFScore\tSpecProb\tP-value\tFDR\tPepFDR\n";

    public InspectAnnotation() {
    }

    public InspectAnnotation(String FileLine, String[] columnHeaders) {
        this(FileLine, false, columnHeaders);
    }

    public InspectAnnotation(String line, boolean isMSGFDBLine, String[] columnHeaders) {
        this.columnHeaders = columnHeaders;
        if (columnHeaders == null) {
            this.columnHeaders = HeaderLineDefault.substring(1).split("\t");
        }
        if (!isMSGFDBLine) {
            String FileLine = line;
            if (FileLine.length() == 0 || FileLine.charAt(0) == '#') {
                return;
            }
            String[] Elements = FileLine.split("\t", -1);
            String val = "";
            if (Elements.length == JackFormatColumns.MinElements || Elements.length == JackFormatColumns.MinElements + 1) {
                this.SpectrumFile = columnHeaders == null ? Elements[JackFormatColumns.SpectrumFile] : Elements[Utils.FindStringInArray(columnHeaders, "SpectrumFile")];
                try {
                    val = columnHeaders == null ? Elements[JackFormatColumns.ScanNumber] : Elements[Utils.FindStringInArray(columnHeaders, "Scan#")];
                    this.ScanNumber = Integer.parseInt(val);
                }
                catch (NumberFormatException E) {
                    ErrorThrower.ThrowError(4, "Unable to parse scan number from " + val);
                }
                if (columnHeaders == null) {
                    this.Annotation = Elements[JackFormatColumns.Annotation];
                    this.AnnotationWithFlanking = Elements[JackFormatColumns.Annotation];
                    this.Annotation = this.Annotation.substring(2, this.Annotation.length() - 2);
                    this.Charge = Integer.parseInt(Elements[JackFormatColumns.Charge]);
                    this.SourceProgram = Elements[JackFormatColumns.SourceProgram];
                    this.ProteinName = Elements[JackFormatColumns.ProteinName];
                } else {
                    this.AnnotationWithFlanking = this.Annotation = Elements[Utils.FindStringInArray(columnHeaders, "Annotation")];
                    this.Annotation = this.Annotation.substring(2, this.Annotation.length() - 2);
                    this.Charge = Integer.parseInt(Elements[Utils.FindStringInArray(columnHeaders, "Charge")]);
                    this.SourceProgram = Elements[Utils.FindStringInArray(columnHeaders, "Source")];
                    this.ProteinName = Elements[Utils.FindStringInArray(columnHeaders, "Protein")];
                }
                try {
                    val = columnHeaders == null ? Elements[JackFormatColumns.SpecProb] : Elements[Utils.FindStringInArray(columnHeaders, "SpecProb")];
                    this.SpecProb = Double.parseDouble(val);
                }
                catch (Exception E2) {
                    ErrorThrower.ThrowError(4, "Unable to parse SpecProb from " + val);
                }
                String pep = Utils.GetUnModded(this.Annotation);
                this.Length = pep.length();
                this.OriginalLine = FileLine;
                return;
            }
            if (Elements.length < InspectColumns.MinElements) {
                ErrorThrower.ThrowWarning(12, "Short Inspect file line " + line);
                return;
            }
            this.SpectrumFile = columnHeaders == null ? Elements[InspectColumns.SpectrumFile] : Elements[Utils.FindStringInArray(columnHeaders, "SpectrumFile")];
            try {
                val = columnHeaders == null ? Elements[InspectColumns.ScanNumber] : Elements[Utils.FindStringInArray(columnHeaders, "Scan#")];
                this.ScanNumber = Integer.parseInt(val);
            }
            catch (NumberFormatException E) {
                ErrorThrower.ThrowError(4, "Unable to parse scan number from " + val);
            }
            if (columnHeaders == null) {
                this.Annotation = Elements[InspectColumns.Annotation];
                this.AnnotationWithFlanking = Elements[InspectColumns.Annotation];
                this.Annotation = this.Annotation.substring(2, this.Annotation.length() - 2);
                this.ProteinName = Elements[InspectColumns.ProteinName];
                this.Charge = Integer.parseInt(Elements[InspectColumns.Charge]);
                this.MQScore = Double.parseDouble(Elements[InspectColumns.MQScore]);
                this.TotalPRMScore = Double.parseDouble(Elements[InspectColumns.TotalPRMScore]);
                this.MedianPRMScore = Double.parseDouble(Elements[InspectColumns.MedianPRMScore]);
                this.Intensity = Double.parseDouble(Elements[InspectColumns.Intensity]);
                this.FractionY = Double.parseDouble(Elements[InspectColumns.FractionY]);
                this.FractionB = Double.parseDouble(Elements[InspectColumns.FractionB]);
            } else {
                if (Utils.FindStringInArray(columnHeaders, "Annotation") < 0) {
                    ErrorThrower.ThrowError(16, "Annotation");
                }
                this.AnnotationWithFlanking = this.Annotation = Elements[Utils.FindStringInArray(columnHeaders, "Annotation")];
                this.Annotation = this.Annotation.substring(2, this.Annotation.length() - 2);
                if (Utils.FindStringInArray(columnHeaders, "Protein") < 0) {
                    ErrorThrower.ThrowError(16, "Protein");
                }
                this.ProteinName = Elements[Utils.FindStringInArray(columnHeaders, "Protein")];
                if (Utils.FindStringInArray(columnHeaders, "Charge") < 0) {
                    ErrorThrower.ThrowError(16, "Charge");
                }
                this.Charge = Integer.parseInt(Elements[Utils.FindStringInArray(columnHeaders, "Charge")]);
                if (Utils.FindStringInArray(columnHeaders, "MQScore") < 0) {
                    ErrorThrower.ThrowError(16, "MQScore");
                }
                this.MQScore = Double.parseDouble(Elements[Utils.FindStringInArray(columnHeaders, "MQScore")]);
                if (Utils.FindStringInArray(columnHeaders, "TotalPRMScore") < 0) {
                    ErrorThrower.ThrowWarning(16, "TotalPRMScore");
                }
                this.TotalPRMScore = Double.parseDouble(Elements[Utils.FindStringInArray(columnHeaders, "TotalPRMScore")]);
                if (Utils.FindStringInArray(columnHeaders, "MedianPRMScore") < 0) {
                    ErrorThrower.ThrowWarning(16, "MedianPRMScore");
                }
                this.MedianPRMScore = Double.parseDouble(Elements[Utils.FindStringInArray(columnHeaders, "MedianPRMScore")]);
                int col = Utils.FindStringInArray(columnHeaders, "Intensity");
                if (col < 0) {
                    col = Utils.FindStringInArray(columnHeaders, "Instensity");
                }
                if (col < 0) {
                    ErrorThrower.ThrowWarning(16, "Intensity");
                }
                this.Intensity = Double.parseDouble(Elements[col]);
                if (Utils.FindStringInArray(columnHeaders, "FractionY") < 0) {
                    ErrorThrower.ThrowWarning(16, "FractionY");
                }
                this.FractionY = Double.parseDouble(Elements[Utils.FindStringInArray(columnHeaders, "FractionY")]);
                if (Utils.FindStringInArray(columnHeaders, "FractionB") < 0) {
                    ErrorThrower.ThrowWarning(16, "FractionB");
                }
                this.FractionB = Double.parseDouble(Elements[Utils.FindStringInArray(columnHeaders, "FractionB")]);
            }
            if (this.ProteinName == null) {
                ErrorThrower.ThrowError(12, "Protein name is null in " + line);
            }
            try {
                if (columnHeaders == null) {
                    val = Elements[InspectColumns.Length];
                } else {
                    if (Utils.FindStringInArray(columnHeaders, "Length") < 0) {
                        ErrorThrower.ThrowError(16, "Length");
                    }
                    val = Elements[Utils.FindStringInArray(columnHeaders, "Length")];
                }
                this.Length = Integer.parseInt(val);
            }
            catch (NumberFormatException e) {
                try {
                    this.Length = (int)Double.parseDouble(val);
                }
                catch (Exception E) {
                    ErrorThrower.ThrowError(4, "Unable to parse length from " + val);
                }
            }
            try {
                if (columnHeaders == null) {
                    val = Elements[InspectColumns.NumTrypTermini];
                } else {
                    if (Utils.FindStringInArray(columnHeaders, "NTT") < 0) {
                        ErrorThrower.ThrowError(16, "NTT");
                    }
                    val = Elements[Utils.FindStringInArray(columnHeaders, "NTT")];
                }
                this.NTT = Integer.parseInt(val);
            }
            catch (NumberFormatException e) {
                try {
                    this.NTT = (int)Double.parseDouble(Elements[Utils.FindStringInArray(columnHeaders, "NTT")]);
                }
                catch (Exception E) {
                    ErrorThrower.ThrowError(4, "Unable to parse NTT from " + val);
                }
            }
            try {
                if (columnHeaders == null) {
                    this.FDR = Double.parseDouble(Elements[InspectColumns.FDR]);
                } else if (Utils.FindStringInArray(columnHeaders, "p-value") >= 0) {
                    this.FDR = Double.parseDouble(Elements[Utils.FindStringInArray(columnHeaders, "p-value")]);
                } else if (Utils.FindStringInArray(columnHeaders, "InspectFDR") >= 0) {
                    this.FDR = Double.parseDouble(Elements[Utils.FindStringInArray(columnHeaders, "InspectFDR")]);
                } else {
                    ErrorThrower.ThrowWarning(16, "InspectFDR or p-value");
                }
            }
            catch (Exception E) {
                this.FDR = 1.0;
            }
            if (columnHeaders == null) {
                this.FScore = Double.parseDouble(Elements[InspectColumns.FScore]);
                this.DeltaScoreAny = Double.parseDouble(Elements[InspectColumns.DeltaScoreAny]);
                this.DeltaScore = Double.parseDouble(Elements[InspectColumns.DeltaScore]);
                this.ProteinID = Integer.parseInt(Elements[InspectColumns.ProteinID]);
                this.TrieDBPos = Integer.parseInt(Elements[InspectColumns.TrieDBPos]);
                this.SpecFileOffset = Integer.parseInt(Elements[InspectColumns.SpecFileOffset]);
            } else {
                if (Utils.FindStringInArray(columnHeaders, "F-Score") < 0) {
                    ErrorThrower.ThrowError(16, "F-Score");
                }
                this.FScore = Double.parseDouble(Elements[Utils.FindStringInArray(columnHeaders, "F-Score")]);
                if (Utils.FindStringInArray(columnHeaders, "DeltaScore") < 0) {
                    ErrorThrower.ThrowError(16, "DeltaScore");
                }
                this.DeltaScoreAny = Double.parseDouble(Elements[Utils.FindStringInArray(columnHeaders, "DeltaScore")]);
                if (Utils.FindStringInArray(columnHeaders, "DeltaScoreOther") < 0) {
                    ErrorThrower.ThrowError(16, "DeltaScoreOther");
                }
                this.DeltaScore = Double.parseDouble(Elements[Utils.FindStringInArray(columnHeaders, "DeltaScoreOther")]);
                if (Utils.FindStringInArray(columnHeaders, "RecordNumber") < 0) {
                    ErrorThrower.ThrowError(16, "RecordNumber");
                }
                this.ProteinID = Integer.parseInt(Elements[Utils.FindStringInArray(columnHeaders, "RecordNumber")]);
                if (Utils.FindStringInArray(columnHeaders, "DBFilePos") < 0) {
                    ErrorThrower.ThrowError(16, "DBFilePos");
                }
                this.TrieDBPos = Integer.parseInt(Elements[Utils.FindStringInArray(columnHeaders, "DBFilePos")]);
                if (Utils.FindStringInArray(columnHeaders, "SpecFilePos") < 0) {
                    ErrorThrower.ThrowError(16, "SpecFilePos");
                }
                this.SpecFileOffset = Integer.parseInt(Elements[Utils.FindStringInArray(columnHeaders, "SpecFilePos")]);
            }
            if (columnHeaders == null) {
                if (Elements.length > InspectColumns.ParentMZ) {
                    try {
                        this.ParentMZ = Double.parseDouble(Elements[InspectColumns.ParentMZ]);
                    }
                    catch (Exception E) {
                        this.ParentMZ = 0.0;
                    }
                }
                if (Elements.length > InspectColumns.MZError) {
                    try {
                        this.MZError = Double.parseDouble(Elements[InspectColumns.MZError]);
                    }
                    catch (Exception E) {
                        this.MZError = 0.0;
                    }
                }
                if (Elements.length > InspectColumns.OriginalFileName) {
                    try {
                        this.Chromosome = Integer.parseInt(Elements[InspectColumns.Chromosome]);
                    }
                    catch (Exception E) {
                        this.Chromosome = -1;
                    }
                    try {
                        this.Strand = Integer.parseInt(Elements[InspectColumns.Strand]);
                    }
                    catch (Exception E) {
                        this.Strand = -1;
                    }
                    try {
                        this.GenomicPos = Elements[InspectColumns.GenomicPos];
                        if (this.GenomicPos.length() == 0) {
                            this.GenomicPos = EMPTY_STRING;
                        }
                    }
                    catch (Exception E) {
                        this.GenomicPos = EMPTY_STRING;
                    }
                    try {
                        this.SplicedSequence = Elements[InspectColumns.SplicedSequence];
                        if (this.SplicedSequence.length() == 0) {
                            this.SplicedSequence = EMPTY_STRING;
                        }
                    }
                    catch (Exception E) {
                        this.SplicedSequence = EMPTY_STRING;
                    }
                    try {
                        this.Splices = Elements[InspectColumns.Splices];
                        if (this.Splices.length() == 0 || this.Splices.compareTo("null") == 0) {
                            this.Splices = " ";
                        }
                    }
                    catch (Exception E) {
                        this.Splices = EMPTY_STRING;
                    }
                    try {
                        this.SearchDB = Elements[InspectColumns.SearchDB];
                        if (this.SearchDB.length() == 0) {
                            this.SearchDB = EMPTY_STRING;
                        }
                    }
                    catch (Exception E) {
                        this.SearchDB = EMPTY_STRING;
                    }
                } else if (Elements.length > InspectColumns.MZError + 1) {
                    try {
                        this.SpecProb = Double.parseDouble(Elements[InspectColumns.MZError + 1]);
                    }
                    catch (Exception E) {
                        this.SpecProb = -1.0;
                    }
                }
                if (Elements.length > InspectColumns.OriginalFileName) {
                    try {
                        this.OriginalFileName = Elements[InspectColumns.OriginalFileName];
                        if (this.OriginalFileName.length() == 0) {
                            this.OriginalFileName = EMPTY_STRING;
                        }
                    }
                    catch (Exception E) {
                        this.OriginalFileName = EMPTY_STRING;
                    }
                }
                if (Elements.length > InspectColumns.LocalFDR) {
                    try {
                        this.LocalFDR = Double.parseDouble(Elements[InspectColumns.LocalFDR]);
                    }
                    catch (Exception E) {
                        this.LocalFDR = -1.0;
                    }
                }
                if (Elements.length > InspectColumns.DeltaKnown) {
                    try {
                        this.DeltaKnown = Double.parseDouble(Elements[InspectColumns.DeltaKnown]);
                    }
                    catch (Exception E) {
                        this.DeltaKnown = Double.NaN;
                    }
                }
                if (Elements.length > InspectColumns.DeltaKnownAnn) {
                    try {
                        this.DeltaKnownAnn = Elements[InspectColumns.DeltaKnownAnn];
                    }
                    catch (Exception E) {
                        this.DeltaKnownAnn = null;
                    }
                }
                if (Elements.length > InspectColumns.IsNovel) {
                    try {
                        this.IsNovel = Boolean.parseBoolean(Elements[InspectColumns.IsNovel]);
                    }
                    catch (Exception E) {
                        this.IsNovel = false;
                    }
                }
                if (Elements.length > InspectColumns.SpecProb) {
                    try {
                        this.SpecProb = Double.parseDouble(Elements[InspectColumns.SpecProb]);
                    }
                    catch (Exception E) {
                        this.SpecProb = -1.0;
                    }
                }
            } else {
                if (Utils.FindStringInArray(columnHeaders, "PrecursorMZ") >= 0) {
                    try {
                        this.ParentMZ = Double.parseDouble(Elements[Utils.FindStringInArray(columnHeaders, "PrecursorMZ")]);
                    }
                    catch (Exception E) {
                        this.ParentMZ = 0.0;
                    }
                } else if (Utils.FindStringInArray(columnHeaders, "FileMZ") >= 0) {
                    try {
                        this.ParentMZ = Double.parseDouble(Elements[Utils.FindStringInArray(columnHeaders, "FileMZ")]);
                    }
                    catch (Exception E) {
                        this.ParentMZ = 0.0;
                    }
                }
                if (Utils.FindStringInArray(columnHeaders, "PrecursorMZError") >= 0) {
                    try {
                        this.MZError = Double.parseDouble(Elements[Utils.FindStringInArray(columnHeaders, "PrecursorMZError")]);
                    }
                    catch (Exception E) {
                        this.MZError = 0.0;
                    }
                } else if (Utils.FindStringInArray(columnHeaders, "MZError") >= 0) {
                    try {
                        this.MZError = Double.parseDouble(Elements[Utils.FindStringInArray(columnHeaders, "MZError")]);
                    }
                    catch (Exception E) {
                        this.MZError = 0.0;
                    }
                }
                if (Utils.FindStringInArray(columnHeaders, "Chromosome") >= 0) {
                    try {
                        this.Chromosome = Integer.parseInt(Elements[Utils.FindStringInArray(columnHeaders, "Chromosome")]);
                    }
                    catch (Exception E) {
                        this.Chromosome = -1;
                    }
                }
                if (Utils.FindStringInArray(columnHeaders, "Strand") >= 0) {
                    try {
                        this.Strand = Integer.parseInt(Elements[Utils.FindStringInArray(columnHeaders, "Strand")]);
                    }
                    catch (Exception E) {
                        this.Strand = -1;
                    }
                }
                if (Utils.FindStringInArray(columnHeaders, "GenomicPos") >= 0) {
                    try {
                        this.GenomicPos = Elements[Utils.FindStringInArray(columnHeaders, "GenomicPos")];
                        if (this.GenomicPos.length() == 0) {
                            this.GenomicPos = EMPTY_STRING;
                        }
                    }
                    catch (Exception E) {
                        this.GenomicPos = EMPTY_STRING;
                    }
                }
                if (Utils.FindStringInArray(columnHeaders, "SplicedSequence") >= 0) {
                    try {
                        this.SplicedSequence = Elements[Utils.FindStringInArray(columnHeaders, "SplicedSequence")];
                        if (this.SplicedSequence.length() == 0) {
                            this.SplicedSequence = EMPTY_STRING;
                        }
                    }
                    catch (Exception E) {
                        this.SplicedSequence = EMPTY_STRING;
                    }
                }
                if (Utils.FindStringInArray(columnHeaders, "Splices") >= 0) {
                    try {
                        this.Splices = Elements[Utils.FindStringInArray(columnHeaders, "Splices")];
                        if (this.Splices.length() == 0 || this.Splices.compareTo("null") == 0) {
                            this.Splices = " ";
                        }
                    }
                    catch (Exception E) {
                        this.Splices = EMPTY_STRING;
                    }
                }
                if (Utils.FindStringInArray(columnHeaders, "SearchDB") >= 0) {
                    try {
                        this.SearchDB = Elements[Utils.FindStringInArray(columnHeaders, "SearchDB")];
                        if (this.SearchDB.length() == 0) {
                            this.SearchDB = EMPTY_STRING;
                        }
                    }
                    catch (Exception E) {
                        this.SearchDB = EMPTY_STRING;
                    }
                }
                if (Utils.FindStringInArray(columnHeaders, "OriginalFile") >= 0) {
                    try {
                        this.OriginalFileName = Elements[Utils.FindStringInArray(columnHeaders, "OriginalFile")];
                        if (this.OriginalFileName.length() == 0) {
                            this.OriginalFileName = EMPTY_STRING;
                        }
                    }
                    catch (Exception E) {
                        this.OriginalFileName = EMPTY_STRING;
                    }
                }
                if (Utils.FindStringInArray(columnHeaders, "LocalFDR") >= 0) {
                    try {
                        this.LocalFDR = Double.parseDouble(Elements[Utils.FindStringInArray(columnHeaders, "LocalFDR")]);
                    }
                    catch (Exception E) {
                        this.LocalFDR = -1.0;
                    }
                }
                if (Utils.FindStringInArray(columnHeaders, "DeltaKnown") >= 0) {
                    try {
                        this.DeltaKnown = Double.parseDouble(Elements[Utils.FindStringInArray(columnHeaders, "DeltaKnown")]);
                    }
                    catch (Exception E) {
                        this.DeltaKnown = Double.NaN;
                    }
                }
                if (Utils.FindStringInArray(columnHeaders, "DeltaKnownAnn") >= 0) {
                    try {
                        this.DeltaKnownAnn = Elements[Utils.FindStringInArray(columnHeaders, "DeltaKnownAnn")];
                    }
                    catch (Exception E) {
                        this.DeltaKnownAnn = null;
                    }
                }
                if (Utils.FindStringInArray(columnHeaders, "IsNovel") >= 0) {
                    try {
                        this.IsNovel = Boolean.parseBoolean(Elements[Utils.FindStringInArray(columnHeaders, "IsNovel")]);
                    }
                    catch (Exception E) {
                        this.IsNovel = false;
                    }
                }
                if (Utils.FindStringInArray(columnHeaders, "SpecProb") >= 0) {
                    try {
                        this.SpecProb = Double.parseDouble(Elements[Utils.FindStringInArray(columnHeaders, "SpecProb")]);
                    }
                    catch (Exception E) {
                        this.SpecProb = -1.0;
                    }
                }
                if (Utils.FindStringInArray(columnHeaders, "SpecIndex") >= 0) {
                    try {
                        this.SpecIndex = Integer.parseInt(Elements[Utils.FindStringInArray(columnHeaders, "SpecIndex")]);
                    }
                    catch (Exception E) {
                        this.SpecIndex = -1;
                    }
                }
            }
        } else {
            String[] Elements;
            if (columnHeaders == null) {
                this.columnHeaders = MSGFDBHeaderLineDefault.substring(1).split("\t");
                columnHeaders = MSGFDBHeaderLineDefault.substring(1).split("\t");
            }
            if ((Elements = line.split("\t", -1)).length < MSGFDBFormatColumns.MinElements) {
                ErrorThrower.ThrowError(12, "Short MSGFDB file line " + line);
            }
            this.SpectrumFile = Elements[Utils.FindStringInArray(columnHeaders, "SpecFile")];
            try {
                this.ScanNumber = Integer.parseInt(Elements[Utils.FindStringInArray(columnHeaders, "Scan#")]);
            }
            catch (NumberFormatException E) {
                ErrorThrower.ThrowError(4, "Unable to parse scan number from " + Elements[Utils.FindStringInArray(columnHeaders, "Scan#")]);
            }
            if (this.ScanNumber <= 0) {
                try {
                    this.ScanNumber = Integer.parseInt(Elements[Utils.FindStringInArray(columnHeaders, "SpecIndex")]) - 1;
                }
                catch (NumberFormatException E) {
                    ErrorThrower.ThrowError(4, "Unable to parse scan number from " + Elements[Utils.FindStringInArray(columnHeaders, "SpecIndex")]);
                }
            }
            this.AnnotationWithFlanking = this.Annotation = Elements[Utils.FindStringInArray(columnHeaders, "Peptide")];
            this.ProteinName = Elements[Utils.FindStringInArray(columnHeaders, "Protein")];
            if (this.ProteinName == null) {
                ErrorThrower.ThrowError(12, "Protein name is null in " + line);
            }
            if (this.ProteinName.startsWith("Splice")) {
                this.SplicedSequence = EMPTY_STRING;
                this.Splices = this.ProteinName;
            } else {
                this.SplicedSequence = EMPTY_STRING;
                this.Splices = EMPTY_STRING;
            }
            this.Charge = Integer.parseInt(Elements[Utils.FindStringInArray(columnHeaders, "Charge")]);
            this.MQScore = -1.0;
            this.Length = this.Annotation.length();
            try {
                this.FDR = Double.parseDouble(Elements[Utils.FindStringInArray(columnHeaders, "FDR")]);
                this.LocalFDR = Double.parseDouble(Elements[Utils.FindStringInArray(columnHeaders, "FDR")]);
            }
            catch (Exception E) {
                this.FDR = 1.0;
                this.LocalFDR = 1.0;
            }
            this.FScore = Double.NaN;
            this.DeltaScoreAny = Double.NaN;
            this.DeltaScore = Double.NaN;
            this.ProteinID = -1;
            this.TrieDBPos = -1;
            this.SpecFileOffset = -1;
            this.ParentMZ = Double.parseDouble(Elements[Utils.FindStringInArray(columnHeaders, "Precursor")]);
            this.MZError = Double.parseDouble(Elements[Utils.FindStringInArray(columnHeaders, "PMError(ppm)")]);
            this.SpecProb = Double.parseDouble(Elements[Utils.FindStringInArray(columnHeaders, "SpecProb")]);
        }
        this.OriginalLine = line;
    }

    public static boolean isInteger(String s) {
        try {
            Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    public static InspectAnnotation[] LoadInpsectResultsDir(String Dir) {
        File DirFile = new File(Dir);
        if (DirFile.isFile()) {
            return InspectAnnotation.LoadInspectResultsFile(Dir);
        }
        System.out.println("We are loading from a directory: " + Dir);
        ArrayList<InspectAnnotation> Annotations = new ArrayList<InspectAnnotation>();
        String[] Files = DirFile.list();
        int i = 0;
        while (i < Files.length) {
            System.out.println("Loading from " + Files[i]);
            InspectAnnotation[] Temp = InspectAnnotation.LoadInspectResultsFile(String.valueOf(DirFile.getAbsolutePath()) + File.separator + Files[i]);
            int j = 0;
            while (j < Temp.length) {
                Temp[j].OriginalFileName = Files[i];
                if (Temp[j].columnHeaders == null || Utils.FindStringInArray(Temp[j].columnHeaders, "OriginalFileName") < 0) {
                    Temp[j].columnHeaders = Utils.appendToArray(Temp[j].columnHeaders, "OriginalFileName");
                }
                Annotations.add(Temp[j]);
                ++j;
            }
            ++i;
        }
        System.out.println("Loaded " + Annotations.size() + " annotations from directory " + Dir);
        InspectAnnotation[] Ret = new InspectAnnotation[Annotations.size()];
        int i2 = 0;
        while (i2 < Ret.length) {
            Ret[i2] = (InspectAnnotation)Annotations.get(i2);
            ++i2;
        }
        return Ret;
    }

    public static String[] LoadPeptidesDir(String Dir) {
        File DirFile = new File(Dir);
        if (DirFile.isFile()) {
            return InspectAnnotation.LoadPeptidesFile(Dir);
        }
        System.out.println("We are loading from a directory: " + Dir);
        String[] Files = Utils.ListDir(Dir);
        return InspectAnnotation.LoadPeptides(Files);
    }

    public static String[] LoadPeptides(String[] Files) {
        ArrayList<String> Annotations = new ArrayList<String>();
        int i = 0;
        while (i < Files.length) {
            System.out.println("Loading from " + Files[i]);
            String[] Temp = InspectAnnotation.LoadPeptidesFile(Files[i]);
            int j = 0;
            while (Temp != null && j < Temp.length) {
                String UnModded = Utils.GetUnModded(Temp[j]);
                if (!Annotations.contains(UnModded)) {
                    Annotations.add(UnModded);
                }
                ++j;
            }
            ++i;
        }
        return Utils.ConvertArraylistToStringArray(Annotations);
    }

    public static String[] LoadPeptidesFile(String File2) {
        String Line;
        BufferedReader Reader2;
        try {
            Reader2 = new BufferedReader(new FileReader(File2));
            Line = Reader2.readLine();
        }
        catch (Exception E) {
            System.err.println(E.getMessage());
            return null;
        }
        ArrayList<String> Annotations = new ArrayList<String>();
        String[] columnHeaders = null;
        while (Line != null) {
            if (Line.length() > 0 && Line.charAt(0) == '#') {
                columnHeaders = Line.substring(1).split("\t");
            }
            if (Line.length() > 0 && Line.charAt(0) != '#') {
                String[] Bits = Line.split("\t");
                if (columnHeaders == null && Bits.length <= InspectColumns.Annotation || columnHeaders != null && Utils.FindStringInArray(columnHeaders, "Annotation") < 0) continue;
                String UnModded = columnHeaders == null ? Utils.GetUnModded(Bits[InspectColumns.Annotation]) : Utils.GetUnModded(Bits[Utils.FindStringInArray(columnHeaders, "Annotation")]);
                if (!Annotations.contains(UnModded)) {
                    Annotations.add(UnModded);
                }
            }
            try {
                Line = Reader2.readLine();
            }
            catch (Exception E) {
                System.err.println(E.getMessage());
                return null;
            }
        }
        return Utils.ConvertArraylistToStringArray(Annotations);
    }

    public static InspectAnnotation[] LoadInspectResultsFile(String File2) {
        String Line;
        BufferedReader Reader2;
        boolean LocalDebug = false;
        try {
            Reader2 = new BufferedReader(new FileReader(File2));
            Line = Reader2.readLine();
        }
        catch (Exception E) {
            System.err.println(E.getMessage());
            return null;
        }
        if (LocalDebug) {
            System.out.println("Loading InsPecT results from " + File2);
        }
        ArrayList<InspectAnnotation> Annotations = new ArrayList<InspectAnnotation>();
        String[] columnHeaders = null;
        while (Line != null) {
            if (Line.length() > 0 && Line.charAt(0) == '#') {
                columnHeaders = Line.substring(1).split("\t");
            } else if (Line.length() > 0 && Line.charAt(0) != '#') {
                if (LocalDebug) {
                    System.out.println("Adding annotation:");
                    System.out.println(Line);
                }
                InspectAnnotation NewAnnotation = new InspectAnnotation(Line, columnHeaders);
                if (NewAnnotation.Length > 0) {
                    NewAnnotation.OriginalFileName = File2;
                    if (NewAnnotation.columnHeaders == null || Utils.FindStringInArray(NewAnnotation.columnHeaders, "OriginalFileName") < 0) {
                        NewAnnotation.columnHeaders = Utils.appendToArray(NewAnnotation.columnHeaders, "OriginalFileName");
                    }
                    Annotations.add(NewAnnotation);
                    if (LocalDebug) {
                        System.out.println("Added the new annotation!!");
                    }
                } else if (LocalDebug) {
                    System.out.println("Did not add the new annotation!!");
                }
                if (LocalDebug) {
                    Utils.WaitForEnter();
                }
            }
            try {
                Line = Reader2.readLine();
            }
            catch (Exception E) {
                System.err.println(E.getMessage());
                return null;
            }
        }
        InspectAnnotation[] Ret = new InspectAnnotation[Annotations.size()];
        int i = 0;
        while (i < Annotations.size()) {
            Ret[i] = (InspectAnnotation)Annotations.get(i);
            ++i;
        }
        return Ret;
    }

    public static InspectAnnotation[] LoadInspectResultsFileIncreasingOrder(String File2, int Column) {
        String Line;
        BufferedReader Reader2;
        try {
            Reader2 = new BufferedReader(new FileReader(File2));
            Line = Reader2.readLine();
        }
        catch (Exception E) {
            System.err.println(E.getMessage());
            return null;
        }
        ArrayList Annotations = new ArrayList();
        String[] columnHeaders = null;
        while (Line != null) {
            if (Line.length() > 0 && Line.charAt(0) == '#') {
                columnHeaders = Line.substring(1).split("\t");
            } else if (Line.length() > 0 && Line.charAt(0) != '#') {
                InspectAnnotation NewAnnotation = new InspectAnnotation(Line, columnHeaders);
                if (NewAnnotation.Length > 0) {
                    NewAnnotation.OriginalFileName = File2;
                    if (NewAnnotation.columnHeaders == null || Utils.FindStringInArray(NewAnnotation.columnHeaders, "OriginalFileName") < 0) {
                        NewAnnotation.columnHeaders = Utils.appendToArray(NewAnnotation.columnHeaders, "OriginalFileName");
                    }
                    Annotations = InspectAnnotation.InsertIncreasingOrder(Annotations, NewAnnotation, 0, Annotations.size(), Column);
                }
            }
            try {
                Line = Reader2.readLine();
            }
            catch (Exception E) {
                System.err.println(E.getMessage());
                return null;
            }
        }
        InspectAnnotation[] Ret = new InspectAnnotation[Annotations.size()];
        int i = 0;
        while (i < Annotations.size()) {
            Ret[i] = (InspectAnnotation)Annotations.get(i);
            ++i;
        }
        return Ret;
    }

    public static InspectAnnotation[] LoadInspectResultsFileIncreasingOrderTwoVotes(String File2, int Column) {
        String Line;
        BufferedReader Reader2;
        if (Column != InspectColumns.SpecProb && Column != InspectColumns.FScore) {
            System.out.println("WARNING: Cannot sort by anything but SpecProb or FScore!!");
            return InspectAnnotation.LoadInspectResultsFile(File2);
        }
        try {
            Reader2 = new BufferedReader(new FileReader(File2));
            Line = Reader2.readLine();
        }
        catch (Exception E) {
            System.err.println(E.getMessage());
            return null;
        }
        ArrayList Annotations = new ArrayList();
        String[] columnHeaders = null;
        while (Line != null) {
            if (Line.length() > 0 && Line.charAt(0) == '#') {
                columnHeaders = Line.substring(1).split("\t");
            }
            if (Line.length() > 0 && Line.charAt(0) != '#') {
                InspectAnnotation NewAnnotation = new InspectAnnotation(Line, columnHeaders);
                if (NewAnnotation.Length > 0) {
                    NewAnnotation.OriginalFileName = File2;
                    if (NewAnnotation.columnHeaders == null || Utils.FindStringInArray(NewAnnotation.columnHeaders, "OriginalFileName") < 0) {
                        NewAnnotation.columnHeaders = Utils.appendToArray(NewAnnotation.columnHeaders, "OriginalFileName");
                    }
                    Annotations = InspectAnnotation.InsertIncreasingOrder(Annotations, NewAnnotation, 0, Annotations.size(), Column);
                } else {
                    System.err.println("WARNING: Skipping invalid file line: " + Line);
                }
            }
            try {
                Line = Reader2.readLine();
            }
            catch (Exception E) {
                System.err.println(E.getMessage());
                return null;
            }
        }
        int Index = 0;
        Hashtable<String, boolean[]> ScanHash = new Hashtable<String, boolean[]>();
        boolean LocalDebug = false;
        System.out.println("Loaded " + Annotations.size() + " anns");
        while (Index < Annotations.size()) {
            InspectAnnotation CurrAnn = (InspectAnnotation)Annotations.get(Index);
            String HashKey = String.valueOf(CurrAnn.SpectrumFile) + "_" + CurrAnn.ScanNumber;
            if (LocalDebug) {
                System.out.println("CurrAnn: " + HashKey + " - " + CurrAnn.SpecProb + " - " + CurrAnn.ProteinName);
            }
            boolean[] FoundInfo = null;
            if (ScanHash.containsKey(HashKey)) {
                FoundInfo = (boolean[])ScanHash.get(HashKey);
                if (LocalDebug) {
                    System.out.println("We've seen this guy before!!");
                    System.out.println("Seen true: " + FoundInfo[0]);
                    System.out.println("Seen false: " + FoundInfo[1]);
                }
            } else {
                FoundInfo = new boolean[]{false, false};
                if (LocalDebug) {
                    System.out.println("We've NEVER seen this guy before!!");
                }
            }
            if (CurrAnn.ProteinName == null) {
                System.out.println(CurrAnn.OriginalLine);
            }
            if (Utils.IsDecoyProtein(CurrAnn.ProteinName) && FoundInfo[1] || !Utils.IsDecoyProtein(CurrAnn.ProteinName) && FoundInfo[0]) {
                Annotations.remove(Index);
                if (!LocalDebug) continue;
                System.out.println("We've seen the same version of this guy before, removing it from list!!");
                Utils.WaitForEnter();
                continue;
            }
            if (Utils.IsDecoyProtein(CurrAnn.ProteinName)) {
                FoundInfo[1] = true;
            } else {
                FoundInfo[0] = true;
            }
            ScanHash.put(HashKey, FoundInfo);
            ++Index;
            if (!LocalDebug) continue;
            System.out.println("We're adding new info about this guy!!");
            System.out.println("Seen true: " + FoundInfo[0]);
            System.out.println("Seen false: " + FoundInfo[1]);
            Utils.WaitForEnter();
        }
        System.out.println("Reduced to " + Annotations.size() + " anns of extreme values only");
        InspectAnnotation[] Ret = new InspectAnnotation[Annotations.size()];
        int i = 0;
        while (i < Annotations.size()) {
            Ret[i] = (InspectAnnotation)Annotations.get(i);
            ++i;
        }
        return Ret;
    }

    public static InspectAnnotation[] LoadInspectResultsFileDecreasingOrderTwoVotes(String File2, int Column) {
        String Line;
        BufferedReader Reader2;
        if (Column != InspectColumns.SpecProb && Column != InspectColumns.FScore) {
            System.out.println("WARNING: Cannot sort by anything but SpecProb or FScore!!");
            return InspectAnnotation.LoadInspectResultsFile(File2);
        }
        try {
            Reader2 = new BufferedReader(new FileReader(File2));
            Line = Reader2.readLine();
        }
        catch (Exception E) {
            System.err.println(E.getMessage());
            return null;
        }
        ArrayList Annotations = new ArrayList();
        String[] columnHeaders = null;
        while (Line != null) {
            if (Line.length() > 0 && Line.charAt(0) == '#') {
                columnHeaders = Line.substring(1).split("\t");
            }
            if (Line.length() > 0 && Line.charAt(0) != '#') {
                InspectAnnotation NewAnnotation = new InspectAnnotation(Line, columnHeaders);
                if (NewAnnotation.Length > 0) {
                    NewAnnotation.OriginalFileName = File2;
                    if (NewAnnotation.columnHeaders == null || Utils.FindStringInArray(NewAnnotation.columnHeaders, "OriginalFileName") < 0) {
                        NewAnnotation.columnHeaders = Utils.appendToArray(NewAnnotation.columnHeaders, "OriginalFileName");
                    }
                    Annotations = InspectAnnotation.InsertDecreasingOrder(Annotations, NewAnnotation, 0, Annotations.size(), Column);
                }
            }
            try {
                Line = Reader2.readLine();
            }
            catch (Exception E) {
                System.err.println(E.getMessage());
                return null;
            }
        }
        int Index = 0;
        Hashtable<String, boolean[]> ScanHash = new Hashtable<String, boolean[]>();
        boolean LocalDebug = false;
        System.out.println("Loaded " + Annotations.size() + " anns");
        while (Index < Annotations.size()) {
            InspectAnnotation CurrAnn = (InspectAnnotation)Annotations.get(Index);
            String HashKey = String.valueOf(CurrAnn.SpectrumFile) + "_" + CurrAnn.ScanNumber;
            if (LocalDebug) {
                System.out.println("CurrAnn: " + HashKey + " - " + CurrAnn.SpecProb + " - " + CurrAnn.ProteinName);
            }
            boolean[] FoundInfo = null;
            if (ScanHash.containsKey(HashKey)) {
                FoundInfo = (boolean[])ScanHash.get(HashKey);
                if (LocalDebug) {
                    System.out.println("We've seen this guy before!!");
                    System.out.println("Seen true: " + FoundInfo[0]);
                    System.out.println("Seen false: " + FoundInfo[1]);
                }
            } else {
                FoundInfo = new boolean[]{false, false};
                if (LocalDebug) {
                    System.out.println("We've NEVER seen this guy before!!");
                }
            }
            if (Utils.IsDecoyProtein(CurrAnn.ProteinName) && FoundInfo[1] || !Utils.IsDecoyProtein(CurrAnn.ProteinName) && FoundInfo[0]) {
                Annotations.remove(Index);
                if (!LocalDebug) continue;
                System.out.println("We've seen the same version of this guy before, removing it from list!!");
                Utils.WaitForEnter();
                continue;
            }
            if (Utils.IsDecoyProtein(CurrAnn.ProteinName)) {
                FoundInfo[1] = true;
            } else {
                FoundInfo[0] = true;
            }
            ScanHash.put(HashKey, FoundInfo);
            ++Index;
            if (!LocalDebug) continue;
            System.out.println("We're adding new info about this guy!!");
            System.out.println("Seen true: " + FoundInfo[0]);
            System.out.println("Seen false: " + FoundInfo[1]);
            Utils.WaitForEnter();
        }
        System.out.println("Reduced to " + Annotations.size() + " anns of extreme values only");
        InspectAnnotation[] Ret = new InspectAnnotation[Annotations.size()];
        int i = 0;
        while (i < Annotations.size()) {
            Ret[i] = (InspectAnnotation)Annotations.get(i);
            ++i;
        }
        return Ret;
    }

    public static Hashtable LoadInspectScoresTwoVotes(String File2, int Column) {
        String Line;
        BufferedReader Reader2;
        boolean LowIsBetter = true;
        try {
            Reader2 = new BufferedReader(new FileReader(File2));
            Line = Reader2.readLine();
        }
        catch (Exception E) {
            System.err.println(E.getMessage());
            return null;
        }
        Hashtable<String, double[]> ScanHash = new Hashtable<String, double[]>();
        String[] columnHeaders = null;
        while (Line != null) {
            if (Line.length() > 0 && Line.charAt(0) == '#') {
                columnHeaders = Line.substring(1).split("\t");
                if (columnHeaders[Column].equals("SpecProb") || columnHeaders[Column].equals("p-value") || columnHeaders[Column].equals("LocalFDR") || columnHeaders[Column].equals("InspectFDR")) {
                    LowIsBetter = true;
                } else if (columnHeaders[Column].equals("MQScore") || columnHeaders[Column].equals("F-Score") || columnHeaders[Column].equals("DeltaScore") || columnHeaders[Column].equals("DeltaScoreOther")) {
                    LowIsBetter = false;
                } else {
                    System.out.println("WARNING: You are trying to rank Inspect results by a non-canonical column.  We assume that a higher value is better\n");
                    LowIsBetter = false;
                }
            }
            if (Line.length() > 0 && Line.charAt(0) != '#') {
                String[] Bits = Line.split("\t");
                String sFile = null;
                sFile = columnHeaders == null ? Bits[InspectColumns.SpectrumFile] : Bits[Utils.FindStringInArray(columnHeaders, "SpectrumFile")];
                if (sFile.indexOf(RESERVED_CHAR) >= 0) {
                    ErrorThrower.ThrowErrorCustum(100, "Cannot hash file name '" + sFile + "' containing reserved char '" + RESERVED_CHAR + "'!");
                }
                String sNumber = columnHeaders == null ? Bits[InspectColumns.ScanNumber] : Bits[Utils.FindStringInArray(columnHeaders, "Scan#")];
                String HashKey = String.valueOf(sFile) + RESERVED_CHAR + sNumber;
                double[] FoundInfo = null;
                if (ScanHash.containsKey(HashKey)) {
                    FoundInfo = (double[])ScanHash.get(HashKey);
                } else {
                    FoundInfo = new double[2];
                    if (LowIsBetter) {
                        FoundInfo[0] = Double.POSITIVE_INFINITY;
                        FoundInfo[1] = Double.POSITIVE_INFINITY;
                    } else {
                        FoundInfo[0] = Double.NEGATIVE_INFINITY;
                        FoundInfo[1] = Double.NEGATIVE_INFINITY;
                    }
                }
                double CurrVal = Double.parseDouble(Bits[Column]);
                int Index = 0;
                String pName = columnHeaders == null ? Bits[InspectColumns.ProteinName] : Bits[Utils.FindStringInArray(columnHeaders, "Protein")];
                if (Utils.IsDecoyProtein(pName)) {
                    Index = 1;
                }
                if (LowIsBetter && CurrVal < FoundInfo[Index]) {
                    FoundInfo[Index] = CurrVal;
                } else if (!LowIsBetter && CurrVal > FoundInfo[Index]) {
                    FoundInfo[Index] = CurrVal;
                }
                ScanHash.put(HashKey, FoundInfo);
            }
            try {
                Line = Reader2.readLine();
            }
            catch (Exception E) {
                System.err.println(E.getMessage());
                return null;
            }
        }
        return ScanHash;
    }

    private static ArrayList InsertIncreasingOrder(ArrayList CurrList, InspectAnnotation NewAnn, int Start, int End, int ScoreColumn) {
        double CurrScore;
        double NewScore;
        boolean LocalDebug = false;
        if (LocalDebug) {
            System.out.println("[" + Start + "-" + End + "]");
        }
        if (Start == End) {
            if (LocalDebug) {
                System.out.println("Start = End (" + Start + "): adding NewAnn with value " + NewAnn.SpecProb + " here");
                Utils.WaitForEnter();
            }
            CurrList.add(Start, NewAnn);
            return CurrList;
        }
        int MidIndex = Start + (End - Start) / 2;
        InspectAnnotation CurrAnn = (InspectAnnotation)CurrList.get(MidIndex);
        if (NewAnn.columnHeaders[ScoreColumn].equals("SpecProb")) {
            NewScore = NewAnn.SpecProb;
            CurrScore = CurrAnn.SpecProb;
        } else if (NewAnn.columnHeaders[ScoreColumn].equals("F-Score")) {
            NewScore = NewAnn.FScore;
            CurrScore = CurrAnn.FScore;
        } else {
            System.err.println("ERROR: Unsupported score type for p-Value computation!!");
            return null;
        }
        if (NewScore < CurrScore) {
            if (LocalDebug) {
                System.out.println("New Ann < CurrAnn[" + MidIndex + "], " + NewAnn.SpecProb + " < " + CurrAnn.SpecProb);
                Utils.WaitForEnter();
            }
            return InspectAnnotation.InsertIncreasingOrder(CurrList, NewAnn, Start, MidIndex, ScoreColumn);
        }
        if (NewScore > CurrScore) {
            if (LocalDebug) {
                System.out.println("New Ann > CurrAnn[" + MidIndex + "], " + NewAnn.SpecProb + " > " + CurrAnn.SpecProb);
                Utils.WaitForEnter();
            }
            return InspectAnnotation.InsertIncreasingOrder(CurrList, NewAnn, MidIndex + 1, End, ScoreColumn);
        }
        if (LocalDebug) {
            System.out.println("New Ann = CurrAnn[" + MidIndex + "], " + NewAnn.SpecProb + " = " + CurrAnn.SpecProb);
            Utils.WaitForEnter();
        }
        CurrList.add(MidIndex, NewAnn);
        return CurrList;
    }

    private static ArrayList InsertDecreasingOrder(ArrayList CurrList, InspectAnnotation NewAnn, int Start, int End, int ScoreColumn) {
        double CurrScore;
        double NewScore;
        boolean LocalDebug = false;
        if (LocalDebug) {
            System.out.println("[" + Start + "-" + End + "]");
        }
        if (Start == End) {
            if (LocalDebug) {
                System.out.println("Start = End (" + Start + "): adding NewAnn with value " + NewAnn.SpecProb + " here");
                Utils.WaitForEnter();
            }
            CurrList.add(Start, NewAnn);
            return CurrList;
        }
        int MidIndex = Start + (End - Start) / 2;
        InspectAnnotation CurrAnn = (InspectAnnotation)CurrList.get(MidIndex);
        if (NewAnn.columnHeaders[ScoreColumn].equals("SpecProb")) {
            NewScore = NewAnn.SpecProb;
            CurrScore = CurrAnn.SpecProb;
        } else if (NewAnn.columnHeaders[ScoreColumn].equals("F-Score")) {
            NewScore = NewAnn.FScore;
            CurrScore = CurrAnn.FScore;
        } else {
            System.err.println("ERROR: Unsupported score type for p-Value computation!!");
            return null;
        }
        if (NewScore > CurrScore) {
            if (LocalDebug) {
                System.out.println("New Ann < CurrAnn[" + MidIndex + "], " + NewAnn.SpecProb + " < " + CurrAnn.SpecProb);
                Utils.WaitForEnter();
            }
            return InspectAnnotation.InsertDecreasingOrder(CurrList, NewAnn, Start, MidIndex, ScoreColumn);
        }
        if (NewScore < CurrScore) {
            if (LocalDebug) {
                System.out.println("New Ann > CurrAnn[" + MidIndex + "], " + NewAnn.SpecProb + " > " + CurrAnn.SpecProb);
                Utils.WaitForEnter();
            }
            return InspectAnnotation.InsertDecreasingOrder(CurrList, NewAnn, MidIndex + 1, End, ScoreColumn);
        }
        if (LocalDebug) {
            System.out.println("New Ann = CurrAnn[" + MidIndex + "], " + NewAnn.SpecProb + " = " + CurrAnn.SpecProb);
            Utils.WaitForEnter();
        }
        CurrList.add(MidIndex, NewAnn);
        return CurrList;
    }

    public static Hashtable LoadInspectResultsFileToHash(String File2) {
        String Line;
        BufferedReader Reader2;
        try {
            Reader2 = new BufferedReader(new FileReader(File2));
            Line = Reader2.readLine();
        }
        catch (Exception E) {
            System.err.println(E.getMessage());
            return null;
        }
        Hashtable<String, InspectAnnotation> Annotations = new Hashtable<String, InspectAnnotation>();
        String[] columnHeaders = null;
        while (Line != null) {
            if (Line.length() > 0 && Line.charAt(0) == '#') {
                columnHeaders = Line.substring(1).split("\t");
            }
            if (Line.length() > 0 && Line.charAt(0) != '#') {
                InspectAnnotation NewAnnotation = new InspectAnnotation(Line, columnHeaders);
                NewAnnotation.OriginalFileName = File2;
                if (NewAnnotation.columnHeaders == null || Utils.FindStringInArray(NewAnnotation.columnHeaders, "OriginalFileName") < 0) {
                    NewAnnotation.columnHeaders = Utils.appendToArray(NewAnnotation.columnHeaders, "OriginalFileName");
                }
                if (NewAnnotation.Length > 0) {
                    String HashKey;
                    String fileName = Utils.GetBaseNameNoExtension(NewAnnotation.SpectrumFile);
                    if (fileName.indexOf(RESERVED_CHAR) >= 0) {
                        ErrorThrower.ThrowErrorCustum(100, "Cannot hash file name '" + fileName + "' containing reserved char '" + RESERVED_CHAR + "'!");
                    }
                    if (Annotations.containsKey(HashKey = String.valueOf(fileName) + RESERVED_CHAR + NewAnnotation.ScanNumber)) {
                        InspectAnnotation OldAnnotation = (InspectAnnotation)Annotations.get(HashKey);
                        if (OldAnnotation.MQScore < NewAnnotation.MQScore) {
                            Annotations.put(HashKey, NewAnnotation);
                        }
                    } else {
                        Annotations.put(HashKey, NewAnnotation);
                    }
                }
            }
            try {
                Line = Reader2.readLine();
            }
            catch (Exception E) {
                System.err.println(E.getMessage());
                return null;
            }
        }
        return Annotations;
    }

    public static Hashtable LoadInspectResultsFileToPeptideHash(String File2) {
        String Line;
        BufferedReader Reader2;
        try {
            Reader2 = new BufferedReader(new FileReader(File2));
            Line = Reader2.readLine();
        }
        catch (Exception E) {
            System.err.println(E.getMessage());
            return null;
        }
        Hashtable<String, InspectAnnotation> Annotations = new Hashtable<String, InspectAnnotation>();
        String[] columnHeaders = null;
        while (Line != null) {
            if (Line.length() > 0 && Line.charAt(0) == '#') {
                columnHeaders = Line.substring(1).split("\t");
            }
            if (Line.length() > 0 && Line.charAt(0) != '#') {
                InspectAnnotation NewAnnotation = new InspectAnnotation(Line, columnHeaders);
                NewAnnotation.OriginalFileName = File2;
                if (NewAnnotation.columnHeaders == null || Utils.FindStringInArray(NewAnnotation.columnHeaders, "OriginalFileName") < 0) {
                    NewAnnotation.columnHeaders = Utils.appendToArray(NewAnnotation.columnHeaders, "OriginalFileName");
                }
                if (NewAnnotation.Length > 0) {
                    String HashKey = NewAnnotation.Annotation;
                    if (Annotations.containsKey(HashKey)) {
                        InspectAnnotation OldAnnotation = (InspectAnnotation)Annotations.get(HashKey);
                        if (OldAnnotation.SpecProb > NewAnnotation.SpecProb) {
                            Annotations.put(HashKey, NewAnnotation);
                        }
                    } else {
                        Annotations.put(HashKey, NewAnnotation);
                    }
                }
            }
            try {
                Line = Reader2.readLine();
            }
            catch (Exception E) {
                System.err.println(E.getMessage());
                return null;
            }
        }
        return Annotations;
    }

    public static Hashtable LoadIntoProteinHashtable(String FileName) {
        BufferedReader buf = null;
        String Line = null;
        Hashtable<String, Object[]> Result = new Hashtable<String, Object[]>();
        try {
            buf = new BufferedReader(new FileReader(FileName));
            Line = buf.readLine();
        }
        catch (IOException E) {
            ErrorThrower.ThrowError(5, FileName);
        }
        String[] columnHeaders = null;
        while (Line != null) {
            Object[] Value;
            String Peptide2;
            String ProteinName;
            if ((Line = Line.trim()).length() == 0 || Line.charAt(0) == '#') {
                if (Line.length() > 0 && Line.charAt(0) == '#') {
                    columnHeaders = Line.substring(1).split("\t");
                }
                try {
                    Line = buf.readLine();
                }
                catch (IOException E) {
                    ErrorThrower.ThrowError(7, FileName);
                }
                continue;
            }
            String[] Bits = Line.split("\t");
            if (columnHeaders == null) {
                ProteinName = Bits[InspectColumns.ProteinName];
                Peptide2 = Bits[InspectColumns.Annotation];
            } else {
                ProteinName = Bits[Utils.FindStringInArray(columnHeaders, "Protein")];
                Peptide2 = Bits[Utils.FindStringInArray(columnHeaders, "Annotation")];
            }
            if (Result.containsKey(ProteinName)) {
                Value = (Object[])Result.get(ProteinName);
                if (!((ArrayList)Value[0]).contains(Peptide2)) {
                    ((ArrayList)Value[0]).add(Peptide2);
                }
                int NewSpecCount = (Integer)Value[1] + 1;
                Value[1] = new Integer(NewSpecCount);
                Result.put(ProteinName, Value);
            } else {
                Value = new Object[2];
                Value[0] = new ArrayList();
                ((ArrayList)Value[0]).add(Peptide2);
                Value[1] = new Integer(1);
                Result.put(ProteinName, Value);
            }
            try {
                Line = buf.readLine();
            }
            catch (IOException E) {
                ErrorThrower.ThrowError(7, FileName);
            }
        }
        try {
            buf.close();
        }
        catch (IOException E) {
            ErrorThrower.ThrowError(8, FileName);
        }
        return Result;
    }

    public static InspectAnnotation[] ArrayListToList(ArrayList Old) {
        InspectAnnotation[] Ret = new InspectAnnotation[Old.size()];
        int i = 0;
        while (i < Old.size()) {
            Ret[i] = (InspectAnnotation)Old.get(i);
            ++i;
        }
        return Ret;
    }

    public boolean compareToNoSpecFile(InspectAnnotation Ann) {
        if (this.ScanNumber != Ann.ScanNumber) {
            return false;
        }
        if (this.AnnotationWithFlanking.compareTo(Ann.AnnotationWithFlanking) != 0) {
            return false;
        }
        if (this.Charge != Ann.Charge) {
            return false;
        }
        if (this.MQScore != Ann.MQScore) {
            return false;
        }
        if (this.FDR != Ann.FDR) {
            return false;
        }
        return this.SpecProb == Ann.SpecProb;
    }

    public static int indexOfNoSpecFile(InspectAnnotation[] CurrList, InspectAnnotation CurrAnn) {
        int i = 0;
        while (i < CurrList.length) {
            if (CurrList[i] != null && CurrList[i].compareToNoSpecFile(CurrAnn)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public String toString() {
        String Ret = "";
        int i = 0;
        while (i < this.columnHeaders.length) {
            Ret = this.columnHeaders[i].equals("SpectrumFile") ? String.valueOf(Ret) + this.SpectrumFile + "\t" : (this.columnHeaders[i].equals("Scan#") ? String.valueOf(Ret) + this.ScanNumber + "\t" : (this.columnHeaders[i].equals("Annotation") ? String.valueOf(Ret) + this.AnnotationWithFlanking + "\t" : (this.columnHeaders[i].equals("Protein") ? String.valueOf(Ret) + this.ProteinName + "\t" : (this.columnHeaders[i].equals("Charge") ? String.valueOf(Ret) + this.Charge + "\t" : (this.columnHeaders[i].equals("MQScore") ? String.valueOf(Ret) + this.MQScore + "\t" : (this.columnHeaders[i].equals("Length") ? String.valueOf(Ret) + this.Length + "\t" : (this.columnHeaders[i].equals("TotalPRMScore") ? String.valueOf(Ret) + this.TotalPRMScore + "\t" : (this.columnHeaders[i].equals("MedianPRMScore") ? String.valueOf(Ret) + this.MedianPRMScore + "\t" : (this.columnHeaders[i].equals("FractionY") ? String.valueOf(Ret) + this.FractionY + "\t" : (this.columnHeaders[i].equals("FractionB") ? String.valueOf(Ret) + this.FractionB + "\t" : (this.columnHeaders[i].equals("Intensity") || this.columnHeaders[i].equals("Instensity") ? String.valueOf(Ret) + this.Intensity + "\t" : (this.columnHeaders[i].equals("NTT") ? String.valueOf(Ret) + this.NTT + "\t" : (this.columnHeaders[i].equals("p-value") || this.columnHeaders[i].equals("InspectFDR") ? String.valueOf(Ret) + this.FDR + "\t" : (this.columnHeaders[i].equals("F-Score") ? String.valueOf(Ret) + this.FScore + "\t" : (this.columnHeaders[i].equals("DeltaScore") ? String.valueOf(Ret) + this.DeltaScoreAny + "\t" : (this.columnHeaders[i].equals("DeltaScoreOther") ? String.valueOf(Ret) + this.DeltaScore + "\t" : (this.columnHeaders[i].equals("RecordNumber") ? String.valueOf(Ret) + this.ProteinID + "\t" : (this.columnHeaders[i].equals("DBFilePos") ? String.valueOf(Ret) + this.TrieDBPos + "\t" : (this.columnHeaders[i].equals("SpecFilePos") ? String.valueOf(Ret) + this.SpecFileOffset + "\t" : (this.columnHeaders[i].equals("FileMZ") || this.columnHeaders[i].equals("PrecursorMZ") ? String.valueOf(Ret) + this.ParentMZ + "\t" : (this.columnHeaders[i].equals("MZError") || this.columnHeaders[i].equals("PrecursorMZError") ? String.valueOf(Ret) + this.MZError + "\t" : (this.columnHeaders[i].equals("Chromosome") ? String.valueOf(Ret) + this.Chromosome + "\t" : (this.columnHeaders[i].equals("Strand") ? String.valueOf(Ret) + this.Strand + "\t" : (this.columnHeaders[i].equals("GenomicPos") ? String.valueOf(Ret) + this.GenomicPos + "\t" : (this.columnHeaders[i].equals("SplicedSequence") ? String.valueOf(Ret) + this.SplicedSequence + "\t" : (this.columnHeaders[i].equals("Splices") ? String.valueOf(Ret) + this.Splices + "\t" : (this.columnHeaders[i].equals("SearchDB") || this.columnHeaders[i].equals("SearchedDB") ? String.valueOf(Ret) + this.SearchDB + "\t" : (this.columnHeaders[i].equals("OriginalFile") || this.columnHeaders[i].equals("OriginalFileName") ? String.valueOf(Ret) + this.OriginalFileName + "\t" : (this.columnHeaders[i].equals("LocalFDR") ? String.valueOf(Ret) + this.LocalFDR + "\t" : (this.columnHeaders[i].equals("DeltaKnown") ? String.valueOf(Ret) + this.DeltaKnown + "\t" : (this.columnHeaders[i].equals("DeltaKnownAnn") ? String.valueOf(Ret) + this.DeltaKnownAnn + "\t" : (this.columnHeaders[i].equals("IsNovel") ? String.valueOf(Ret) + this.IsNovel + "\t" : (this.columnHeaders[i].equals("SpecProb") ? String.valueOf(Ret) + this.SpecProb + "\t" : (this.columnHeaders[i].equals("SpecIndex") ? String.valueOf(Ret) + this.SpecIndex + "\t" : String.valueOf(Ret) + "\t"))))))))))))))))))))))))))))))))));
            ++i;
        }
        return Ret.substring(0, Ret.length() - 1);
    }

    public String toStringMSGFDBFormat() {
        String Ret = "";
        int i = 0;
        while (i < this.columnHeaders.length) {
            if (this.columnHeaders[i].equals("SpecFile")) {
                Ret = String.valueOf(Ret) + this.SpectrumFile + "\t";
            } else if (this.columnHeaders[i].equals("SpecIndex")) {
                Ret = String.valueOf(Ret) + this.ScanNumber + "\t";
            } else if (this.columnHeaders[i].equals("Scan#")) {
                Ret = String.valueOf(Ret) + this.ScanNumber + "\t";
            } else if (this.columnHeaders[i].equals("FragMethod")) {
                Ret = String.valueOf(Ret) + "NA\t";
            } else if (this.columnHeaders[i].equals("FileMZ") || this.columnHeaders[i].equals("Precursor")) {
                Ret = String.valueOf(Ret) + this.ParentMZ + "\t";
            } else if (this.columnHeaders[i].equals("PMError(ppm)") || this.columnHeaders[i].equals("PMError(Da)")) {
                Ret = String.valueOf(Ret) + this.MZError + "\t";
            } else if (this.columnHeaders[i].equals("Charge")) {
                Ret = String.valueOf(Ret) + this.Charge + "\t";
            } else if (this.columnHeaders[i].equals("Peptide")) {
                Ret = String.valueOf(Ret) + this.AnnotationWithFlanking + "\t";
            } else if (this.columnHeaders[i].equals("Protein")) {
                Ret = String.valueOf(Ret) + this.ProteinName + "\t";
            } else if (this.columnHeaders[i].equals("DeNovoScore")) {
                Ret = String.valueOf(Ret) + "0\t";
            } else if (this.columnHeaders[i].equals("MSGFScore")) {
                Ret = String.valueOf(Ret) + "0\t";
            } else if (this.columnHeaders[i].equals("SpecProb")) {
                Ret = String.valueOf(Ret) + this.SpecProb + "\t";
            } else if (this.columnHeaders[i].equals("P-value") || this.columnHeaders[i].equals("p-value")) {
                Ret = String.valueOf(Ret) + "0\t";
            } else if (this.columnHeaders[i].equals("FDR")) {
                Ret = String.valueOf(Ret) + this.FDR + "\t";
            } else if (this.columnHeaders[i].equals("PepFDR")) {
                Ret = String.valueOf(Ret) + "1\t";
            } else if (this.columnHeaders[i].equals("SplicedSequence")) {
                Ret = String.valueOf(Ret) + this.SplicedSequence + "\t";
            } else if (this.columnHeaders[i].equals("Splices")) {
                Ret = String.valueOf(Ret) + this.Splices + "\t";
            } else if (this.columnHeaders[i].equals("IsNovel")) {
                Ret = String.valueOf(Ret) + this.IsNovel + "\t";
            }
            ++i;
        }
        return Ret.substring(0, Ret.length() - 1);
    }

    public String toStringMinimalOld() {
        String Ret = "";
        Ret = String.valueOf(Ret) + this.SpectrumFile + "\t" + this.ScanNumber + "\t" + this.AnnotationWithFlanking + "\t" + this.ProteinName + "\t";
        Ret = String.valueOf(Ret) + this.Charge + "\t" + this.MQScore + "\t" + this.Length + "\t" + this.TotalPRMScore + "\t" + this.MedianPRMScore + "\t";
        Ret = String.valueOf(Ret) + this.FractionY + "\t" + this.FractionB + "\t" + this.Intensity + "\t" + this.NTT + "\t";
        Ret = String.valueOf(Ret) + this.FDR + "\t" + this.FScore + "\t" + this.DeltaScoreAny + "\t" + this.DeltaScore + "\t" + this.ProteinID + "\t" + this.TrieDBPos + "\t";
        Ret = String.valueOf(Ret) + this.SpecFileOffset;
        if (Utils.FindStringInArray(this.columnHeaders, "PrecursorMZ") >= 0 || Utils.FindStringInArray(this.columnHeaders, "FileMZ") >= 0) {
            Ret = this.ParentMZ != 0.0 ? String.valueOf(Ret) + "\t" + this.ParentMZ + "\t" + this.MZError : String.valueOf(Ret) + "\t \t ";
        }
        if (Utils.FindStringInArray(this.columnHeaders, "Chromosome") >= 0) {
            Ret = String.valueOf(Ret) + "\t" + this.Chromosome;
            Ret = String.valueOf(Ret) + "\t" + this.Strand;
            Ret = String.valueOf(Ret) + "\t" + this.GenomicPos;
            Ret = String.valueOf(Ret) + "\t" + this.SplicedSequence;
            Ret = String.valueOf(Ret) + "\t" + this.Splices;
            Ret = String.valueOf(Ret) + "\t" + this.SearchDB;
        }
        if (Utils.FindStringInArray(this.columnHeaders, "OriginalFile") >= 0) {
            Ret = String.valueOf(Ret) + "\t" + this.OriginalFileName;
        }
        if (Utils.FindStringInArray(this.columnHeaders, "LocalFDR") >= 0) {
            Ret = this.LocalFDR != -1.0 ? String.valueOf(Ret) + "\t" + this.LocalFDR : String.valueOf(Ret) + "\t";
        }
        if (Utils.FindStringInArray(this.columnHeaders, "DeltaKnown") >= 0) {
            Ret = this.DeltaKnown != Double.NaN ? String.valueOf(Ret) + "\t" + this.DeltaKnown : String.valueOf(Ret) + "\t";
            Ret = this.DeltaKnownAnn != null ? String.valueOf(Ret) + "\t" + this.DeltaKnownAnn : String.valueOf(Ret) + "\t";
        }
        if (Utils.FindStringInArray(this.columnHeaders, "IsNovel") >= 0) {
            Ret = String.valueOf(Ret) + "\t" + this.IsNovel;
        }
        if (Utils.FindStringInArray(this.columnHeaders, "SpecProb") >= 0 && this.SpecProb != -1.0) {
            Ret = String.valueOf(Ret) + "\t" + this.SpecProb;
        }
        if (Utils.FindStringInArray(this.columnHeaders, "SpecIndex") >= 0) {
            Ret = String.valueOf(Ret) + "\t" + this.SpecIndex;
        }
        return Ret;
    }

    public String toJackFormatString() {
        String ret = "";
        String[] Bits = this.OriginalLine.split("\t");
        ret = String.valueOf(ret) + this.SpectrumFile + "\t" + this.ScanNumber + "\t" + this.ScanNumber + "\t" + Bits[JackFormatColumns.Score] + "\t";
        ret = String.valueOf(ret) + this.AnnotationWithFlanking + "\t" + this.Charge + "\t" + this.SourceProgram + "\t" + this.SpecProb + "\t" + this.ProteinName + "\t";
        ret = String.valueOf(ret) + this.FDR;
        return ret;
    }

    public String toStringOld() {
        String[] Bits = this.OriginalLine.split("\t");
        if (Bits.length == JackFormatColumns.MinElements) {
            return this.toJackFormatString();
        }
        String Ret = "";
        Ret = String.valueOf(Ret) + this.SpectrumFile + "\t" + this.ScanNumber + "\t" + this.AnnotationWithFlanking + "\t" + this.ProteinName + "\t";
        Ret = String.valueOf(Ret) + this.Charge + "\t" + this.MQScore + "\t" + this.Length + "\t" + this.TotalPRMScore + "\t" + this.MedianPRMScore + "\t";
        Ret = String.valueOf(Ret) + this.FractionY + "\t" + this.FractionB + "\t" + this.Intensity + "\t" + this.NTT + "\t";
        Ret = String.valueOf(Ret) + this.FDR + "\t" + this.FScore + "\t" + this.DeltaScoreAny + "\t" + this.DeltaScore + "\t" + this.ProteinID + "\t" + this.TrieDBPos + "\t";
        Ret = String.valueOf(Ret) + this.SpecFileOffset;
        Ret = this.ParentMZ != 0.0 ? String.valueOf(Ret) + "\t" + this.ParentMZ + "\t" + this.MZError : String.valueOf(Ret) + "\t \t ";
        Ret = String.valueOf(Ret) + "\t" + this.Chromosome;
        Ret = String.valueOf(Ret) + "\t" + this.Strand;
        Ret = String.valueOf(Ret) + "\t" + this.GenomicPos;
        Ret = String.valueOf(Ret) + "\t" + this.SplicedSequence;
        Ret = String.valueOf(Ret) + "\t" + this.Splices;
        Ret = String.valueOf(Ret) + "\t" + this.SearchDB;
        Ret = String.valueOf(Ret) + "\t" + this.OriginalFileName;
        Ret = this.LocalFDR != -1.0 ? String.valueOf(Ret) + "\t" + this.LocalFDR : String.valueOf(Ret) + "\t";
        Ret = this.DeltaKnown != Double.NaN ? String.valueOf(Ret) + "\t" + this.DeltaKnown : String.valueOf(Ret) + "\t";
        Ret = this.DeltaKnownAnn != null ? String.valueOf(Ret) + "\t" + this.DeltaKnownAnn : String.valueOf(Ret) + "\t";
        Ret = String.valueOf(Ret) + "\t" + this.IsNovel;
        if (this.SpecProb != -1.0) {
            Ret = String.valueOf(Ret) + "\t" + this.SpecProb;
        }
        return Ret;
    }

    public static Hashtable LoadInspectAnnotationsIntoSpecHash(String[] files) {
        Hashtable<String, Boolean> ret = new Hashtable<String, Boolean>();
        BufferedReader buf = null;
        String Line = null;
        int i = 0;
        while (i < files.length) {
            try {
                buf = new BufferedReader(new FileReader(files[i]));
                Line = buf.readLine();
            }
            catch (IOException E) {
                ErrorThrower.ThrowError(5, files[i]);
            }
            String[] columnHeaders = null;
            while (Line != null) {
                if ((Line = Line.trim()).length() == 0 || Line.charAt(0) == '#') {
                    if (Line.length() > 0 && Line.charAt(0) == '#') {
                        columnHeaders = Line.substring(1).split("\t");
                    }
                    try {
                        Line = buf.readLine();
                    }
                    catch (IOException E) {
                        ErrorThrower.ThrowError(7, files[i]);
                    }
                    continue;
                }
                String[] Bits = Line.split("\t");
                String sFile = columnHeaders == null ? Bits[InspectColumns.SpectrumFile] : Bits[Utils.FindStringInArray(columnHeaders, "SpectrumFile")];
                String fileName = Utils.GetBaseName(sFile);
                if (fileName.indexOf(RESERVED_CHAR) >= 0) {
                    ErrorThrower.ThrowErrorCustum(100, "Cannot hash file with reserved char '@'!");
                }
                String scanNum = columnHeaders == null ? Bits[InspectColumns.ScanNumber] : Bits[Utils.FindStringInArray(columnHeaders, "Scan#")];
                String hashKey = String.valueOf(fileName) + RESERVED_CHAR + scanNum;
                ret.put(hashKey, new Boolean(true));
                try {
                    Line = buf.readLine();
                }
                catch (IOException E) {
                    ErrorThrower.ThrowError(7, files[i]);
                }
            }
            try {
                buf.close();
            }
            catch (IOException E) {
                ErrorThrower.ThrowError(8, files[i]);
            }
            ++i;
        }
        return ret;
    }

    public static Hashtable LoadInspectAnnotationsIntoSpec2PeptideHash(String Dir) {
        Hashtable ret = new Hashtable();
        Object buf = null;
        Object Line = null;
        String[] files = Utils.IsDir(Dir) ? Utils.ListDir(Dir) : new String[]{Dir};
        return InspectAnnotation.LoadInspectAnnotationsIntoSpec2PeptideHash(files);
    }

    public static Hashtable LoadInspectAnnotationsIntoSpec2PeptideHash(String[] files) {
        Hashtable<String, String> ret = new Hashtable<String, String>();
        BufferedReader buf = null;
        String Line = null;
        int i = 0;
        while (i < files.length) {
            try {
                buf = new BufferedReader(new FileReader(files[i]));
                Line = buf.readLine();
            }
            catch (IOException E) {
                ErrorThrower.ThrowError(5, files[i]);
            }
            String[] columnHeaders = null;
            while (Line != null) {
                if ((Line = Line.trim()).length() == 0 || Line.charAt(0) == '#') {
                    if (Line.length() > 0 && Line.charAt(0) == '#') {
                        columnHeaders = Line.substring(1).split("\t");
                    }
                    try {
                        Line = buf.readLine();
                    }
                    catch (IOException E) {
                        ErrorThrower.ThrowError(7, files[i]);
                    }
                    continue;
                }
                String[] Bits = Line.split("\t");
                String sFile = columnHeaders == null ? Bits[InspectColumns.SpectrumFile] : Bits[Utils.FindStringInArray(columnHeaders, "SpectrumFile")];
                String fileName = Utils.GetBaseName(sFile);
                if (fileName.indexOf(RESERVED_CHAR) >= 0) {
                    ErrorThrower.ThrowErrorCustum(100, "Cannot hash file with reserved char '@'!");
                }
                String scanNumber = columnHeaders == null ? Bits[InspectColumns.ScanNumber] : Bits[Utils.FindStringInArray(columnHeaders, "Scan#")];
                String hashKey = String.valueOf(fileName) + RESERVED_CHAR + scanNumber;
                String Ann = columnHeaders == null ? Bits[InspectColumns.Annotation] : Bits[Utils.FindStringInArray(columnHeaders, "Annotation")];
                if (!ret.containsKey(hashKey)) {
                    ret.put(hashKey, Ann);
                }
                try {
                    Line = buf.readLine();
                }
                catch (IOException E) {
                    ErrorThrower.ThrowError(7, files[i]);
                }
            }
            try {
                buf.close();
            }
            catch (IOException E) {
                ErrorThrower.ThrowError(8, files[i]);
            }
            ++i;
        }
        return ret;
    }

    public void DebugPrint() {
        System.out.println("FileName: " + this.SpectrumFile + " Scan: " + this.ScanNumber);
        System.out.println("Peptide: " + this.Annotation);
        System.out.println(this.toString());
        System.out.println("SpecProb: " + this.SpecProb);
    }

    public static Hashtable LoadInspectAnnotationsIntoSpec2PeptideAndScoreHash(String[] files) {
        Hashtable<String, String[]> ret = new Hashtable<String, String[]>();
        BufferedReader buf = null;
        String Line = null;
        int i = 0;
        while (i < files.length) {
            try {
                buf = new BufferedReader(new FileReader(files[i]));
                Line = buf.readLine();
            }
            catch (IOException E) {
                ErrorThrower.ThrowError(5, files[i]);
            }
            String[] columnHeaders = null;
            while (Line != null) {
                if ((Line = Line.trim()).length() == 0 || Line.charAt(0) == '#') {
                    if (Line.length() > 0 && Line.charAt(0) == '#') {
                        columnHeaders = Line.substring(1).split("\t");
                    }
                    try {
                        Line = buf.readLine();
                    }
                    catch (IOException E) {
                        ErrorThrower.ThrowError(7, files[i]);
                    }
                    continue;
                }
                String[] Bits = Line.split("\t");
                String sFile = columnHeaders == null ? Bits[InspectColumns.SpectrumFile] : Bits[Utils.FindStringInArray(columnHeaders, "SpectrumFile")];
                String fileName = Utils.GetBaseName(sFile);
                String scanNumber = columnHeaders == null ? Bits[InspectColumns.ScanNumber] : Bits[Utils.FindStringInArray(columnHeaders, "Scan#")];
                if (fileName.indexOf(RESERVED_CHAR) >= 0) {
                    ErrorThrower.ThrowErrorCustum(100, "Cannot hash file with reserved char '@'!");
                }
                String hashKey = String.valueOf(fileName) + RESERVED_CHAR + scanNumber;
                String[] val = new String[2];
                String Ann = columnHeaders == null ? Bits[InspectColumns.Annotation] : Bits[Utils.FindStringInArray(columnHeaders, "Annotation")];
                String score = columnHeaders == null ? Bits[InspectColumns.MQScore] : Bits[Utils.FindStringInArray(columnHeaders, "MQScore")];
                val[0] = Ann;
                val[1] = score;
                if (!ret.containsKey(hashKey)) {
                    ret.put(hashKey, val);
                }
                try {
                    Line = buf.readLine();
                }
                catch (IOException E) {
                    ErrorThrower.ThrowError(7, files[i]);
                }
            }
            try {
                buf.close();
            }
            catch (IOException E) {
                ErrorThrower.ThrowError(8, files[i]);
            }
            ++i;
        }
        return ret;
    }

    public static Hashtable GetAllAnnotatedScanNums(String fileName) {
        Hashtable<String, Object> map = new Hashtable<String, Object>();
        BufferedReader buf = null;
        String Line = null;
        try {
            buf = new BufferedReader(new FileReader(fileName));
            Line = buf.readLine();
        }
        catch (IOException E) {
            ErrorThrower.ThrowError(5, fileName);
        }
        String[] columnHeaders = null;
        while (Line != null) {
            if ((Line = Line.trim()).length() == 0 || Line.charAt(0) == '#') {
                if (Line.length() > 0 && Line.charAt(0) == '#') {
                    columnHeaders = Line.substring(1).split("\t");
                }
                try {
                    Line = buf.readLine();
                }
                catch (IOException E) {
                    ErrorThrower.ThrowError(7, fileName);
                }
                continue;
            }
            String[] Bits = Line.split("\t");
            String sFile = columnHeaders == null ? Bits[InspectColumns.SpectrumFile] : Bits[Utils.FindStringInArray(columnHeaders, "SpectrumFile")];
            String specFile = Utils.GetBaseName(sFile);
            String scanNumber = columnHeaders == null ? Bits[InspectColumns.ScanNumber] : Bits[Utils.FindStringInArray(columnHeaders, "Scan#")];
            ArrayList scanNums = null;
            scanNums = map.containsKey(specFile) ? (ArrayList)map.get(specFile) : new ArrayList();
            Utils.InsertInAscendingOrder(scanNums, Integer.parseInt(scanNumber));
            map.put(specFile, scanNums);
            try {
                Line = buf.readLine();
            }
            catch (IOException E) {
                ErrorThrower.ThrowError(7, fileName);
            }
        }
        try {
            buf.close();
        }
        catch (IOException E) {
            ErrorThrower.ThrowError(8, fileName);
        }
        Enumeration E = map.keys();
        while (E.hasMoreElements()) {
            String f = (String)E.nextElement();
            ArrayList scans = (ArrayList)map.get(f);
            int[] scanList = Utils.ConvertArraylistToIntArray(scans);
            map.put(f, scanList);
        }
        return map;
    }

    public static Hashtable GetAllAnnotatedScanNumsWithPeptides(String fileName, ArrayList peptideList) {
        Hashtable<String, Object> map = new Hashtable<String, Object>();
        BufferedReader buf = null;
        String Line = null;
        try {
            buf = new BufferedReader(new FileReader(fileName));
            Line = buf.readLine();
        }
        catch (IOException E) {
            ErrorThrower.ThrowError(5, fileName);
        }
        String[] columnHeaders = null;
        while (Line != null) {
            if ((Line = Line.trim()).length() == 0 || Line.charAt(0) == '#') {
                if (Line.length() > 0 && Line.charAt(0) == '#') {
                    columnHeaders = Line.substring(1).split("\t");
                }
                try {
                    Line = buf.readLine();
                }
                catch (IOException E) {
                    ErrorThrower.ThrowError(7, fileName);
                }
                continue;
            }
            String[] Bits = Line.split("\t");
            String sFile = columnHeaders == null ? Bits[InspectColumns.SpectrumFile] : Bits[Utils.FindStringInArray(columnHeaders, "SpectrumFile")];
            String specFile = Utils.GetBaseName(sFile);
            String scanNumber = columnHeaders == null ? Bits[InspectColumns.ScanNumber] : Bits[Utils.FindStringInArray(columnHeaders, "Scan#")];
            String ann = columnHeaders == null ? Bits[InspectColumns.Annotation] : Bits[Utils.FindStringInArray(columnHeaders, "Annotation")];
            String peptide = Utils.GetUnModded(ann);
            if (!peptideList.contains(peptide)) {
                try {
                    Line = buf.readLine();
                }
                catch (IOException E) {
                    ErrorThrower.ThrowError(7, fileName);
                }
                continue;
            }
            ArrayList scanNums = null;
            scanNums = map.containsKey(specFile) ? (ArrayList)map.get(specFile) : new ArrayList();
            Utils.InsertInAscendingOrder(scanNums, Integer.parseInt(scanNumber));
            map.put(specFile, scanNums);
            try {
                Line = buf.readLine();
            }
            catch (IOException E) {
                ErrorThrower.ThrowError(7, fileName);
            }
        }
        try {
            buf.close();
        }
        catch (IOException E) {
            ErrorThrower.ThrowError(8, fileName);
        }
        Enumeration E = map.keys();
        while (E.hasMoreElements()) {
            String f = (String)E.nextElement();
            ArrayList scans = (ArrayList)map.get(f);
            int[] scanList = Utils.ConvertArraylistToIntArray(scans);
            map.put(f, scanList);
        }
        return map;
    }

    public static Hashtable LoadInspectResultsPep2FileNameHash(String[] files) {
        Hashtable<String, ArrayList> ret = new Hashtable<String, ArrayList>();
        BufferedReader buf = null;
        String Line = null;
        int i = 0;
        while (i < files.length) {
            try {
                buf = new BufferedReader(new FileReader(files[i]));
                Line = buf.readLine();
            }
            catch (IOException E) {
                ErrorThrower.ThrowError(5, files[i]);
            }
            String[] columnHeaders = null;
            while (Line != null) {
                if ((Line = Line.trim()).length() == 0 || Line.charAt(0) == '#') {
                    if (Line.length() > 0 && Line.charAt(0) == '#') {
                        columnHeaders = Line.substring(1).split("\t");
                    }
                    try {
                        Line = buf.readLine();
                    }
                    catch (IOException E) {
                        ErrorThrower.ThrowError(7, files[i]);
                    }
                    continue;
                }
                String[] Bits = Line.split("\t");
                String sFile = columnHeaders == null ? Bits[InspectColumns.SpectrumFile] : Bits[Utils.FindStringInArray(columnHeaders, "SpectrumFile")];
                String fileName = Utils.GetBaseName(sFile);
                String ann = columnHeaders == null ? Bits[InspectColumns.Annotation] : Bits[Utils.FindStringInArray(columnHeaders, "Annotation")];
                if (ann.indexOf(46) >= 0) {
                    ann = ann.substring(2, ann.length() - 2);
                }
                String hashKey = ann;
                String val = fileName;
                ArrayList fileNames = null;
                fileNames = !ret.containsKey(hashKey) ? new ArrayList() : (ArrayList)ret.get(hashKey);
                if (!fileNames.contains(val)) {
                    fileNames.add(val);
                }
                ret.put(hashKey, fileNames);
                try {
                    Line = buf.readLine();
                }
                catch (IOException E) {
                    ErrorThrower.ThrowError(7, files[i]);
                }
            }
            try {
                buf.close();
            }
            catch (IOException E) {
                ErrorThrower.ThrowError(8, files[i]);
            }
            ++i;
        }
        return ret;
    }

    public static InspectAnnotation[] LoadMSGFDBResultsFile(String fileName, double FDRcutoff) {
        String Line;
        System.out.println("LOADING");
        BufferedReader Reader2 = null;
        boolean LocalDebug = true;
        try {
            Reader2 = new BufferedReader(new FileReader(fileName));
            Line = Reader2.readLine();
        }
        catch (Exception E) {
            System.err.println(E.getMessage());
            return null;
        }
        if (LocalDebug) {
            System.out.println("Loading MSGFDB results from " + fileName);
        }
        ArrayList<InspectAnnotation> Annotations = new ArrayList<InspectAnnotation>();
        String[] columnHeaders = null;
        while (Line != null) {
            if (Line.length() > 0 && Line.charAt(0) == '#') {
                columnHeaders = Line.substring(1).split("\t");
            }
            if (Line.length() > 0 && Line.charAt(0) != '#') {
                if (LocalDebug) {
                    System.out.println("Adding annotation:");
                    System.out.println(Line);
                }
                InspectAnnotation NewAnnotation = new InspectAnnotation(Line, true, columnHeaders);
                if (NewAnnotation.Length > 0 && NewAnnotation.FDR <= FDRcutoff) {
                    NewAnnotation.OriginalFileName = fileName;
                    if (NewAnnotation.columnHeaders == null || Utils.FindStringInArray(NewAnnotation.columnHeaders, "OriginalFileName") < 0) {
                        NewAnnotation.columnHeaders = Utils.appendToArray(NewAnnotation.columnHeaders, "OriginalFileName");
                    }
                    Annotations.add(NewAnnotation);
                    if (LocalDebug) {
                        System.out.println("Added the new annotation!!");
                    }
                } else if (LocalDebug) {
                    System.out.println("Did not add the new annotation!!");
                }
                if (LocalDebug) {
                    Utils.WaitForEnter();
                }
            }
            try {
                Line = Reader2.readLine();
            }
            catch (Exception E) {
                System.err.println(E.getMessage());
                return null;
            }
        }
        InspectAnnotation[] Ret = new InspectAnnotation[Annotations.size()];
        int i = 0;
        while (i < Annotations.size()) {
            Ret[i] = (InspectAnnotation)Annotations.get(i);
            ++i;
        }
        return Ret;
    }

    public static InspectAnnotation[] LoadInspectResultsFileIncreasingOrderTwoVotes(String inputFile, String colName) {
        String Line;
        BufferedReader Reader2;
        if (!colName.equals("SpecProb") && !colName.equals("F-Score")) {
            System.out.println("WARNING: Cannot sort by anything but SpecProb or FScore!!");
            return InspectAnnotation.LoadInspectResultsFile(inputFile);
        }
        try {
            Reader2 = new BufferedReader(new FileReader(inputFile));
            Line = Reader2.readLine();
        }
        catch (Exception E) {
            System.err.println(E.getMessage());
            return null;
        }
        ArrayList Annotations = new ArrayList();
        String[] columnHeaders = null;
        int Column = -1;
        while (Line != null) {
            if (Line.length() > 0 && Line.charAt(0) == '#') {
                columnHeaders = Line.substring(1).split("\t");
                Column = Utils.FindStringInArray(columnHeaders, colName);
            }
            if (Line.length() > 0 && Line.charAt(0) != '#') {
                InspectAnnotation NewAnnotation = new InspectAnnotation(Line, columnHeaders);
                if (NewAnnotation.Length > 0) {
                    NewAnnotation.OriginalFileName = inputFile;
                    if (NewAnnotation.columnHeaders == null || Utils.FindStringInArray(NewAnnotation.columnHeaders, "OriginalFileName") < 0) {
                        NewAnnotation.columnHeaders = Utils.appendToArray(NewAnnotation.columnHeaders, "OriginalFileName");
                    }
                    Annotations = InspectAnnotation.InsertIncreasingOrder(Annotations, NewAnnotation, 0, Annotations.size(), Column);
                } else {
                    System.err.println("WARNING: Skipping invalid file line: " + Line);
                }
            }
            try {
                Line = Reader2.readLine();
            }
            catch (Exception E) {
                System.err.println(E.getMessage());
                return null;
            }
        }
        int Index = 0;
        Hashtable<String, boolean[]> ScanHash = new Hashtable<String, boolean[]>();
        boolean LocalDebug = false;
        System.out.println("Loaded " + Annotations.size() + " anns");
        while (Index < Annotations.size()) {
            InspectAnnotation CurrAnn = (InspectAnnotation)Annotations.get(Index);
            String HashKey = String.valueOf(CurrAnn.SpectrumFile) + "_" + CurrAnn.ScanNumber;
            if (LocalDebug) {
                System.out.println("CurrAnn: " + HashKey + " - " + CurrAnn.SpecProb + " - " + CurrAnn.ProteinName);
            }
            boolean[] FoundInfo = null;
            if (ScanHash.containsKey(HashKey)) {
                FoundInfo = (boolean[])ScanHash.get(HashKey);
                if (LocalDebug) {
                    System.out.println("We've seen this guy before!!");
                    System.out.println("Seen true: " + FoundInfo[0]);
                    System.out.println("Seen false: " + FoundInfo[1]);
                }
            } else {
                FoundInfo = new boolean[]{false, false};
                if (LocalDebug) {
                    System.out.println("We've NEVER seen this guy before!!");
                }
            }
            if (CurrAnn.ProteinName == null) {
                System.out.println(CurrAnn.OriginalLine);
            }
            if (Utils.IsDecoyProtein(CurrAnn.ProteinName) && FoundInfo[1] || !Utils.IsDecoyProtein(CurrAnn.ProteinName) && FoundInfo[0]) {
                Annotations.remove(Index);
                if (!LocalDebug) continue;
                System.out.println("We've seen the same version of this guy before, removing it from list!!");
                Utils.WaitForEnter();
                continue;
            }
            if (Utils.IsDecoyProtein(CurrAnn.ProteinName)) {
                FoundInfo[1] = true;
            } else {
                FoundInfo[0] = true;
            }
            ScanHash.put(HashKey, FoundInfo);
            ++Index;
            if (!LocalDebug) continue;
            System.out.println("We're adding new info about this guy!!");
            System.out.println("Seen true: " + FoundInfo[0]);
            System.out.println("Seen false: " + FoundInfo[1]);
            Utils.WaitForEnter();
        }
        System.out.println("Reduced to " + Annotations.size() + " anns of extreme values only");
        InspectAnnotation[] Ret = new InspectAnnotation[Annotations.size()];
        int i = 0;
        while (i < Annotations.size()) {
            Ret[i] = (InspectAnnotation)Annotations.get(i);
            ++i;
        }
        return Ret;
    }

    public static InspectAnnotation[] LoadInspectResultsFileDecreasingOrderTwoVotes(String inputFile, String colName) {
        String Line;
        BufferedReader Reader2;
        if (!colName.equals("SpecProb") && !colName.equals("F-Score")) {
            System.out.println("WARNING: Cannot sort by anything but SpecProb or FScore!!");
            return InspectAnnotation.LoadInspectResultsFile(inputFile);
        }
        try {
            Reader2 = new BufferedReader(new FileReader(inputFile));
            Line = Reader2.readLine();
        }
        catch (Exception E) {
            System.err.println(E.getMessage());
            return null;
        }
        ArrayList Annotations = new ArrayList();
        String[] columnHeaders = null;
        int Column = -1;
        while (Line != null) {
            if (Line.length() > 0 && Line.charAt(0) == '#') {
                columnHeaders = Line.substring(1).split("\t");
                Column = Utils.FindStringInArray(columnHeaders, colName);
            }
            if (Line.length() > 0 && Line.charAt(0) != '#') {
                InspectAnnotation NewAnnotation = new InspectAnnotation(Line, columnHeaders);
                if (NewAnnotation.Length > 0) {
                    NewAnnotation.OriginalFileName = inputFile;
                    if (NewAnnotation.columnHeaders == null || Utils.FindStringInArray(NewAnnotation.columnHeaders, "OriginalFileName") < 0) {
                        NewAnnotation.columnHeaders = Utils.appendToArray(NewAnnotation.columnHeaders, "OriginalFileName");
                    }
                    Annotations = InspectAnnotation.InsertDecreasingOrder(Annotations, NewAnnotation, 0, Annotations.size(), Column);
                }
            }
            try {
                Line = Reader2.readLine();
            }
            catch (Exception E) {
                System.err.println(E.getMessage());
                return null;
            }
        }
        int Index = 0;
        Hashtable<String, boolean[]> ScanHash = new Hashtable<String, boolean[]>();
        boolean LocalDebug = false;
        if (LocalDebug) {
            System.out.println("Loaded " + Annotations.size() + " anns");
        }
        while (Index < Annotations.size()) {
            InspectAnnotation CurrAnn = (InspectAnnotation)Annotations.get(Index);
            String HashKey = String.valueOf(CurrAnn.SpectrumFile) + "_" + CurrAnn.ScanNumber;
            if (LocalDebug) {
                System.out.println("CurrAnn: " + HashKey + " - " + CurrAnn.SpecProb + " - " + CurrAnn.ProteinName);
            }
            boolean[] FoundInfo = null;
            if (ScanHash.containsKey(HashKey)) {
                FoundInfo = (boolean[])ScanHash.get(HashKey);
                if (LocalDebug) {
                    System.out.println("We've seen this guy before!!");
                    System.out.println("Seen true: " + FoundInfo[0]);
                    System.out.println("Seen false: " + FoundInfo[1]);
                }
            } else {
                FoundInfo = new boolean[]{false, false};
                if (LocalDebug) {
                    System.out.println("We've NEVER seen this guy before!!");
                }
            }
            if (Utils.IsDecoyProtein(CurrAnn.ProteinName) && FoundInfo[1] || !Utils.IsDecoyProtein(CurrAnn.ProteinName) && FoundInfo[0]) {
                Annotations.remove(Index);
                if (!LocalDebug) continue;
                System.out.println("We've seen the same version of this guy before, removing it from list!!");
                Utils.WaitForEnter();
                continue;
            }
            if (Utils.IsDecoyProtein(CurrAnn.ProteinName)) {
                FoundInfo[1] = true;
            } else {
                FoundInfo[0] = true;
            }
            ScanHash.put(HashKey, FoundInfo);
            ++Index;
            if (!LocalDebug) continue;
            System.out.println("We're adding new info about this guy!!");
            System.out.println("Seen true: " + FoundInfo[0]);
            System.out.println("Seen false: " + FoundInfo[1]);
            Utils.WaitForEnter();
        }
        System.out.println("Reduced to " + Annotations.size() + " anns of extreme values only");
        InspectAnnotation[] Ret = new InspectAnnotation[Annotations.size()];
        int i = 0;
        while (i < Annotations.size()) {
            Ret[i] = (InspectAnnotation)Annotations.get(i);
            ++i;
        }
        return Ret;
    }

    public static class InspectColumns {
        public static int MinElements = 20;
        public static int SpectrumFile = 0;
        public static int ScanNumber = 1;
        public static int Annotation = 2;
        public static int ProteinName = 3;
        public static int Charge = 4;
        public static int MQScore = 5;
        public static int Length = 6;
        public static int TotalPRMScore = 7;
        public static int MedianPRMScore = 8;
        public static int FractionY = 9;
        public static int FractionB = 10;
        public static int Intensity = 11;
        public static int NumTrypTermini = 12;
        public static int FDR = 13;
        public static int FScore = 14;
        public static int DeltaScoreAny = 15;
        public static int DeltaScore = 16;
        public static int ProteinID = 17;
        public static int TrieDBPos = 18;
        public static int SpecFileOffset = 19;
        public static int ParentMZ = 20;
        public static int MZError = 21;
        public static int Chromosome = 22;
        public static int Strand = 23;
        public static int GenomicPos = 24;
        public static int SplicedSequence = 25;
        public static int Splices = 26;
        public static int SearchDB = 27;
        public static int OriginalFileName = 28;
        public static int LocalFDR = 29;
        public static int DeltaKnown = 30;
        public static int DeltaKnownAnn = 31;
        public static int IsNovel = 32;
        public static int SpecProb = 33;
    }

    public static class JackFormatColumns {
        public static int MinElements = 10;
        public static int SpectrumFile = 0;
        public static int ScanNumber = 1;
        public static int LastScanNumber = 2;
        public static int Score = 3;
        public static int Annotation = 4;
        public static int Charge = 5;
        public static int SourceProgram = 6;
        public static int SpecProb = 7;
        public static int PeptideType = 8;
        public static int ProteinName = 9;
    }

    public static class MSGFDBFormatColumns {
        public static int MinElements = 13;
        public static int SpectrumFile = 0;
        public static int SpecIndex = 1;
        public static int ScanNumber = 2;
        public static int FragmentationMethod = 3;
        public static int PrecursorMZ = 4;
        public static int PrecursorPPM = 5;
        public static int Charge = 6;
        public static int Annotation = 7;
        public static int Protein = 8;
        public static int DeNovoScore = 9;
        public static int MSGFScore = 10;
        public static int SpecProb = 11;
        public static int pvalue = 12;
        public static int FDR = 13;
    }
}

