/*
 * Decompiled with CFR 0.152.
 */
package basicUtils;

import basicUtils.InspectAnnotation;
import basicUtils.StreamGobbler;
import errorUtils.ErrorThrower;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TimeZone;

public class Utils {
    public static double[] AAMasses = new double[]{71.03711, Double.NEGATIVE_INFINITY, 103.08406, 115.02694, 129.04259, 147.06841, 57.02146, 137.05891, 113.08406, Double.NEGATIVE_INFINITY, 128.09496, 113.08406, 131.04049, 114.04293, 237.1, 97.05276, 128.05858, 156.10111, 87.03203, 101.04768, Double.NEGATIVE_INFINITY, 99.06841, 186.07931, Double.NEGATIVE_INFINITY, 163.06333};
    public static int[] AAMassesScaled = new int[]{71037, Integer.MIN_VALUE, 103084, 115026, 129042, 147068, 57021, 137058, 113084, Integer.MIN_VALUE, 128094, 113084, 131040, 114042, 237100, 97052, 128058, 156101, 87032, 101047, Integer.MIN_VALUE, 99068, 186079, Integer.MIN_VALUE, 163063};
    public static final String VERSION = "2010.08.03";
    public static final int MIN_PEPTIDE_LEN = 7;
    public static final String ReservedDelim = "@";
    public static final char ReservedDelimChar = '@';
    public static final double HydrogenMass = 1.0078;
    public static final double WaterMass = 17.0;
    public static final double AmmoniaMass = 18.0;
    public static char STOP_AA = (char)88;
    public static String STOP_AA_STR = String.valueOf(STOP_AA);
    public static double OrbiFragTol = 0.1;
    public static double LTQFragTol = 0.5;
    public static String[] dnaCodeNames = new String[]{"Standard", "Vertebrate Mitochondrial", "Yeast Mitochondrial", "Mold Mitochondrial; Protozoan Mitochondrial; Coelenterate Mitochondrial; Mycoplasma; Spiroplasma", "Invertebrate Mitochondrial", "Ciliate Nuclear; Dasycladacean Nuclear; Hexamita Nuclear", "Echinoderm Mitochondrial; Flatworm Mitochondrial", "Euplotid Nuclear", "Bacterial and Plant Plastid", "Alternative Yeast Nuclear", "Ascidian Mitochondrial", "Alternative Flatworm Mitochondrial", "Blepharisma Macronuclear", "Chlorophycean Mitochondrial", "Trematode Mitochondrial", "Scenedesmus obliquus Mitochondrial", "Thraustochytrium Mitochondrial"};
    public static String[] dnaCodes = new String[]{"FFLLSSSSYYXXCCXWLLLLPPPPHHQQRRRRIIIMTTTTNNKKSSRRVVVVAAAADDEEGGGG", "FFLLSSSSYYXXCCWWLLLLPPPPHHQQRRRRIIMMTTTTNNKKSSXXVVVVAAAADDEEGGGG", "FFLLSSSSYYXXCCWWTTTTPPPPHHQQRRRRIIMMTTTTNNKKSSRRVVVVAAAADDEEGGGG", "FFLLSSSSYYXXCCWWLLLLPPPPHHQQRRRRIIIMTTTTNNKKSSRRVVVVAAAADDEEGGGG", "FFLLSSSSYYXXCCWWLLLLPPPPHHQQRRRRIIMMTTTTNNKKSSSSVVVVAAAADDEEGGGG", "FFLLSSSSYYQQCCXWLLLLPPPPHHQQRRRRIIIMTTTTNNKKSSRRVVVVAAAADDEEGGGG", "FFLLSSSSYYXXCCWWLLLLPPPPHHQQRRRRIIIMTTTTNNNKSSSSVVVVAAAADDEEGGGG", "FFLLSSSSYYXXCCCWLLLLPPPPHHQQRRRRIIIMTTTTNNKKSSRRVVVVAAAADDEEGGGG", "FFLLSSSSYYXXCCXWLLLLPPPPHHQQRRRRIIIMTTTTNNKKSSRRVVVVAAAADDEEGGGG", "FFLLSSSSYYXXCCXWLLLSPPPPHHQQRRRRIIIMTTTTNNKKSSRRVVVVAAAADDEEGGGG", "FFLLSSSSYYXXCCWWLLLLPPPPHHQQRRRRIIMMTTTTNNKKSSGGVVVVAAAADDEEGGGG", "FFLLSSSSYYYXCCWWLLLLPPPPHHQQRRRRIIIMTTTTNNNKSSSSVVVVAAAADDEEGGGG", "FFLLSSSSYYXQCCXWLLLLPPPPHHQQRRRRIIIMTTTTNNKKSSRRVVVVAAAADDEEGGGG", "FFLLSSSSYYXLCCXWLLLLPPPPHHQQRRRRIIIMTTTTNNKKSSRRVVVVAAAADDEEGGGG", "FFLLSSSSYYXXCCWWLLLLPPPPHHQQRRRRIIMMTTTTNNNKSSSSVVVVAAAADDEEGGGG", "FFLLSSXSYYXLCCXWLLLLPPPPHHQQRRRRIIIMTTTTNNKKSSRRVVVVAAAADDEEGGGG", "FFXLSSSSYYXXCCXWLLLLPPPPHHQQRRRRIIIMTTTTNNKKSSRRVVVVAAAADDEEGGGG"};
    public static int MAX_STORED_PEPTIDES = 200000;

    public static boolean IsInteger(String SeqName) {
        try {
            int i = Integer.parseInt(SeqName);
            return true;
        }
        catch (Exception E) {
            return false;
        }
    }

    public static String translateSequence(String seq, int codonTable) {
        char[] codon = new char[3];
        String s = "";
        int i = 0;
        while (i + 2 < seq.length()) {
            codon[0] = seq.charAt(i);
            codon[1] = seq.charAt(i + 1);
            codon[2] = seq.charAt(i + 2);
            s = String.valueOf(s) + Utils.translateCodon(codon, codonTable);
            i += 3;
        }
        return s;
    }

    public static void printGeneticCodeOptions() {
        System.out.println("--- Codon Table Options ---");
        int i = 0;
        while (i < dnaCodeNames.length) {
            System.out.println(String.valueOf(i) + ":" + dnaCodeNames[i]);
            ++i;
        }
    }

    public static String translateCodon(String codon, int codonTable) {
        char[] c = codon.toCharArray();
        return String.valueOf(Utils.translateCodon(c, codonTable));
    }

    public static char translateCodon(char[] codon, int codonTable) {
        if (codon.length != 3) {
            System.err.println("ERROR: Invalid codon is not of length 3!!");
            System.exit(-1);
        }
        int val = 0;
        int i = 0;
        while (i < codon.length) {
            if (codon[2 - i] == 't' || codon[2 - i] == 'T') {
                val += 0;
            } else if (codon[2 - i] == 'c' || codon[2 - i] == 'C') {
                val = (int)((double)val + 1.0 * Math.pow(4.0, i));
            } else if (codon[2 - i] == 'a' || codon[2 - i] == 'A') {
                val = (int)((double)val + 2.0 * Math.pow(4.0, i));
            } else if (codon[2 - i] == 'g' || codon[2 - i] == 'G') {
                val = (int)((double)val + 3.0 * Math.pow(4.0, i));
            } else {
                return STOP_AA;
            }
            ++i;
        }
        return dnaCodes[codonTable].charAt(val);
    }

    public static String GetVersion() {
        GregorianCalendar rightNow = new GregorianCalendar(TimeZone.getTimeZone("PST"));
        String Version = String.valueOf(rightNow.get(1)) + "." + rightNow.get(2) + "." + rightNow.get(5);
        return Version;
    }

    public static double GetSeqMass(String Sequence) {
        if (Sequence.length() == 0) {
            return 0.0;
        }
        if (Sequence.length() >= 2 && Sequence.charAt(1) == '.') {
            Sequence = Sequence.substring(2, Sequence.length() - 2);
        }
        double TotalMass = 0.0;
        int i = 0;
        while (i < Sequence.length()) {
            if (Sequence.charAt(i) == '[') {
                int End = Sequence.indexOf(93, i);
                String AAStr = Sequence.substring(i + 1, End);
                TotalMass += Double.parseDouble(AAStr);
                i = End;
            } else {
                int AAIndex = Sequence.charAt(i) - 65;
                if (AAIndex < 0 || AAIndex > AAMasses.length) {
                    System.err.println("ERROR: Unrecognized char in AA Sequence: " + Sequence.charAt(i) + " in " + Sequence);
                    return 0.0;
                }
                double CurrMass = AAMasses[Sequence.charAt(i) - 65];
                if (CurrMass != 0.0) {
                    TotalMass += CurrMass;
                } else {
                    System.err.println("Utils.GetSeqMass: " + Sequence.charAt(i) + " is not a valid Amino Acid");
                    System.exit(2);
                }
            }
            ++i;
        }
        return TotalMass;
    }

    public static void WaitForEnter() {
        System.out.println("\nPress Enter:");
        try {
            System.in.read();
            while (System.in.available() > 0) {
                System.in.read();
            }
        }
        catch (IOException e) {
            System.err.println(e.getMessage());
            return;
        }
    }

    public static String ReverseString(String ForwardString) {
        String Ret = "";
        int i = 0;
        while (i < ForwardString.length()) {
            Ret = String.valueOf(ForwardString.charAt(i)) + Ret;
            ++i;
        }
        return Ret;
    }

    public static int[][] GetSpliceInfo(String Splices, int Strand, int Start, int End) {
        if ((Splices = Splices.trim()).compareTo(InspectAnnotation.EMPTY_STRING) == 0 || Splices.compareTo("NA") == 0 || Splices.compareTo("") == 0 || Splices.compareTo("\t") == 0) {
            int[][] Ret = new int[1][3];
            Ret[0][0] = Start;
            Ret[0][1] = End;
            Ret[0][2] = Strand == 1 ? Start % 3 : (End - 1) % 3;
            return Ret;
        }
        String[] SEBits = Splices.split(",");
        int[][] Ret = new int[SEBits.length + 1][3];
        int PrevEnd = Start;
        int Prefix = 0;
        int Suffix = 0;
        int i = 0;
        while (i < SEBits.length) {
            String[] B = SEBits[i].split("-");
            Ret[i][0] = PrevEnd;
            Ret[i][1] = Integer.parseInt(B[0]);
            Ret[i][2] = (PrevEnd + Prefix) % 3;
            Suffix = (Ret[i][1] - Ret[i][0] - Prefix) % 3;
            Prefix = (3 - Suffix) % 3;
            PrevEnd = Integer.parseInt(B[1]);
            ++i;
        }
        Ret[Ret.length - 1][0] = PrevEnd;
        Ret[Ret.length - 1][1] = End;
        Ret[Ret.length - 1][2] = (PrevEnd + Prefix) % 3;
        return Ret;
    }

    public static boolean IsDecoyProtein(String ProteinName) {
        if (ProteinName.length() < 3) {
            System.err.println("ERROR: Invalid protein name '" + ProteinName + "'");
            System.exit(-1);
        }
        return ProteinName.substring(0, 3).compareTo("XXX") == 0;
    }

    public static Hashtable ParseCommandLine(String[] args, String[] options, boolean[] values) {
        int i = 0;
        Hashtable<String, String> returnArgs = new Hashtable<String, String>();
        block0: while (i < args.length && args[i].startsWith("-")) {
            String currArg = args[i];
            ++i;
            int j = 0;
            while (j < options.length) {
                if (options[j].compareTo(currArg) == 0) {
                    if (values[j]) {
                        returnArgs.put(currArg, args[i]);
                        ++i;
                        continue block0;
                    }
                    returnArgs.put(currArg, "");
                    continue block0;
                }
                ++j;
            }
        }
        return returnArgs;
    }

    public static Hashtable ParseCommandLineMulti(String[] args, String[] options, boolean[] values) {
        int i = 0;
        Hashtable<String, Serializable> returnArgs = new Hashtable<String, Serializable>();
        block0: while (i < args.length && args[i].startsWith("-")) {
            String currArg = args[i];
            ++i;
            int j = 0;
            while (j < options.length) {
                if (options[j].compareTo(currArg) == 0) {
                    if (values[j]) {
                        ArrayList Temp = returnArgs.containsKey(currArg) ? (ArrayList)returnArgs.get(currArg) : new ArrayList();
                        Temp.add(args[i]);
                        returnArgs.put(currArg, Temp);
                        ++i;
                        continue block0;
                    }
                    returnArgs.put(currArg, new Integer(1));
                    continue block0;
                }
                ++j;
            }
        }
        return returnArgs;
    }

    public static String GetBaseName(String FileName) {
        File f = new File(FileName);
        return f.getName();
    }

    public static String GetBaseNameNoExtension(String FileName) {
        return Utils.GetFileNameNoExtension(Utils.GetBaseName(FileName));
    }

    public static String GetFileExtension(String FileName) {
        String[] Bits = FileName.split(".");
        int Index = FileName.indexOf(".");
        int PrevIndex = -1;
        while (Index >= 0) {
            Index = FileName.substring(PrevIndex += Index + 1).indexOf(".");
        }
        if (PrevIndex < 0) {
            System.out.println("WARNING: No extension on " + FileName);
            System.out.println("Index of . = " + FileName.indexOf("."));
            return "";
        }
        return "." + FileName.substring(PrevIndex);
    }

    public static String CleanUpPeptideString(String Peptide2) {
        if (Peptide2 == null) {
            return "";
        }
        Peptide2 = Peptide2.trim().toUpperCase();
        int i = 0;
        while (i < Peptide2.length()) {
            if (Peptide2.charAt(i) < 'A' || Peptide2.charAt(i) > 'Z') {
                Peptide2 = Peptide2.replace(Peptide2.charAt(i), '*');
                Peptide2 = Peptide2.replaceAll("[*]", "");
                Peptide2 = Peptide2.replaceAll("\n", "");
            }
            ++i;
        }
        int NullIndex = Peptide2.indexOf(0);
        if (NullIndex < 0) {
            NullIndex = Peptide2.length();
        }
        return Peptide2.substring(0, NullIndex);
    }

    /*
     * Unable to fully structure code
     */
    public static String GetFileNameNoExtension(String FileName) {
        Ret = "";
        sTok = new StringTokenizer(FileName, ".");
        if (sTok.countTokens() >= 2) ** GOTO lbl6
        return FileName;
lbl-1000:
        // 1 sources

        {
            Ret = String.valueOf(Ret) + sTok.nextToken() + ".";
lbl6:
            // 2 sources

            ** while (sTok.countTokens() > 1)
        }
lbl7:
        // 1 sources

        return Ret.substring(0, Ret.length() - 1);
    }

    public static String GetFilePath(String FileName) {
        File f = new File(FileName);
        return f.getParent();
    }

    public static String GetPeptideFromMutated(String Peptide2) {
        boolean LocalDebug = false;
        if (LocalDebug) {
            System.out.println("Modified form of peptide: " + Peptide2);
        }
        String ret = "";
        int i = 1;
        while (i < Peptide2.length() - 1) {
            if (Peptide2.charAt(i) == '-') {
                if (Peptide2.charAt(i + 1) == '>') {
                    ret = String.valueOf(Peptide2.substring(0, i - 2)) + Peptide2.substring(i + 2, Peptide2.length());
                    break;
                }
                ret = Peptide2.substring(0, i - 1);
                if (LocalDebug) {
                    System.out.println("Prefix: " + ret);
                }
                int moddedAA = Peptide2.charAt(i - 1) - 65;
                double moddedAAMass = AAMasses[moddedAA];
                int j = i + 1;
                while (j < Peptide2.length()) {
                    try {
                        int test = Integer.parseInt(Peptide2.substring(j, j + 1));
                    }
                    catch (NumberFormatException E) {
                        break;
                    }
                    ++j;
                }
                double deltaMass = Double.parseDouble(Peptide2.substring(i, j));
                if (LocalDebug) {
                    System.out.println("Modified AA: " + (char)(moddedAA + 65) + ", Modded mass: " + deltaMass + ", new AA mass: " + (deltaMass + moddedAAMass));
                }
                char newChar = Utils.GetClosestAAUnScaled(moddedAAMass + deltaMass, LTQFragTol);
                if (LocalDebug) {
                    System.out.println("Closest aa to Predicted mass " + (deltaMass + moddedAAMass) + " is " + newChar + " with mass " + AAMasses[newChar - 65]);
                }
                ret = String.valueOf(ret) + newChar + Peptide2.substring(j, Peptide2.length());
                break;
            }
            if (Peptide2.charAt(i) == '+') {
                ret = Peptide2.substring(0, i - 1);
                if (LocalDebug) {
                    System.out.println("Prefix: " + ret);
                }
                int moddedAA = Peptide2.charAt(i - 1) - 65;
                double moddedAAMass = AAMasses[moddedAA];
                int j = i + 1;
                while (j < Peptide2.length()) {
                    try {
                        int test = Integer.parseInt(Peptide2.substring(j, j + 1));
                    }
                    catch (NumberFormatException E) {
                        break;
                    }
                    ++j;
                }
                double deltaMass = Double.parseDouble(Peptide2.substring(i, j));
                if (LocalDebug) {
                    System.out.println("Modified AA: " + (char)(moddedAA + 65) + ", Modded mass: " + deltaMass);
                }
                char newChar = Utils.GetClosestAAUnScaled(moddedAAMass + deltaMass, LTQFragTol);
                if (LocalDebug) {
                    System.out.println("Closest aa to Predicted mass " + (deltaMass + moddedAAMass) + " is " + newChar + " with mass " + AAMasses[newChar - 65]);
                }
                ret = String.valueOf(ret) + newChar + Peptide2.substring(j, Peptide2.length());
                break;
            }
            ++i;
        }
        if (ret.compareTo("") == 0) {
            ret = Peptide2;
        }
        ret = ret.toUpperCase();
        if (LocalDebug) {
            System.out.println("Final peptide: " + ret);
            Utils.WaitForEnter();
        }
        return ret;
    }

    private static char GetClosestAAUnScaled(double d, double tol) {
        int ClosestIndex = -1;
        double MassDelta = Double.MAX_VALUE;
        int i = 0;
        while (i < AAMasses.length) {
            if (Math.abs(AAMasses[i] - d) < MassDelta && Math.abs(AAMasses[i] - d) <= tol) {
                ClosestIndex = i;
                MassDelta = Math.abs(AAMasses[i] - d);
            }
            ++i;
        }
        return (char)(ClosestIndex + 65);
    }

    public static boolean PeptidesAreILEquivalent(String pep1, String pep2) {
        if (pep1.indexOf(46) >= 0) {
            pep1 = pep1.split("[.]")[1];
        }
        if (pep2.indexOf(46) >= 0) {
            pep2 = pep2.split("[.]")[1];
        }
        if (pep1.length() != pep2.length()) {
            return false;
        }
        int i = 0;
        while (i < pep1.length()) {
            if (!(pep1.charAt(i) == pep2.charAt(i) || pep1.charAt(i) == 'L' && pep2.charAt(i) == 'I' || pep2.charAt(i) == 'L' && pep1.charAt(i) == 'I')) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean PeptidesAreILQKEquivalent(String pep1, String pep2) {
        if (pep1.indexOf(46) >= 0) {
            pep1 = pep1.split("[.]")[1];
        }
        if (pep2.indexOf(46) >= 0) {
            pep2 = pep2.split("[.]")[1];
        }
        if (pep1.length() != pep2.length()) {
            return false;
        }
        int i = 0;
        while (i < pep1.length()) {
            if (!(pep1.charAt(i) == pep2.charAt(i) || pep1.charAt(i) == 'L' && pep2.charAt(i) == 'I' || pep2.charAt(i) == 'L' && pep1.charAt(i) == 'I' || pep1.charAt(i) == 'Q' && pep2.charAt(i) == 'K' || pep2.charAt(i) == 'Q' && pep1.charAt(i) == 'K')) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static String GetUnModded(String Peptide2) {
        Peptide2 = Peptide2.replace("+", "");
        Peptide2 = Peptide2.replace("phos", "");
        Peptide2 = Peptide2.replace("-", "");
        Peptide2 = Peptide2.replace("0", "");
        Peptide2 = Peptide2.replace("1", "");
        Peptide2 = Peptide2.replace("2", "");
        Peptide2 = Peptide2.replace("3", "");
        Peptide2 = Peptide2.replace("4", "");
        Peptide2 = Peptide2.replace("5", "");
        Peptide2 = Peptide2.replace("6", "");
        Peptide2 = Peptide2.replace("7", "");
        Peptide2 = Peptide2.replace("8", "");
        Peptide2 = Peptide2.replace("9", "");
        Peptide2 = Peptide2.replace(".", "");
        return Peptide2;
    }

    public static String[] ConvertArraylistToStringArray(ArrayList Input) {
        String[] Ret = new String[Input.size()];
        int i = 0;
        while (i < Ret.length) {
            Ret[i] = (String)Input.get(i);
            ++i;
        }
        return Ret;
    }

    public static int[] ConvertArraylistToIntArray(ArrayList Input) {
        int[] Ret = new int[Input.size()];
        int i = 0;
        while (i < Ret.length) {
            Ret[i] = (Integer)Input.get(i);
            ++i;
        }
        return Ret;
    }

    public static double[] ConvertArraylistToDoubleArray(ArrayList Input) {
        double[] Ret = new double[Input.size()];
        int i = 0;
        while (i < Ret.length) {
            Ret[i] = (Double)Input.get(i);
            ++i;
        }
        return Ret;
    }

    public static boolean HasOverlap(int S1, int E1, int S2, int E2) {
        return S1 < E2 && E1 > S2;
    }

    public static String[] ListDir(String InputDir) {
        File d = new File(InputDir);
        String[] fList = d.list();
        int i = 0;
        while (i < fList.length) {
            fList[i] = String.valueOf(InputDir) + File.separator + fList[i];
            ++i;
        }
        return fList;
    }

    public static String BooleanArrayToString(boolean[] Input) {
        String Ret = "";
        int i = 0;
        while (i < Input.length) {
            Ret = Input[i] ? String.valueOf(Ret) + "1" : String.valueOf(Ret) + "0";
            ++i;
        }
        return Ret;
    }

    public static String IntArrayToString(int[] Input) {
        if (Input == null || Input.length == 0) {
            return "";
        }
        String Ret = "" + Input[0];
        int i = 1;
        while (i < Input.length) {
            Ret = String.valueOf(Ret) + " " + Input[i];
            ++i;
        }
        return Ret;
    }

    public static String DoubleArrayToString(double[] Input) {
        if (Input == null || Input.length == 0) {
            return "";
        }
        String Ret = "" + Input[0];
        int i = 1;
        while (i < Input.length) {
            Ret = String.valueOf(Ret) + " " + Input[i];
            ++i;
        }
        return Ret;
    }

    public static boolean IntArrayContains(int[] List2, int Value) {
        int i = 0;
        while (i < List2.length) {
            if (Value == List2[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static int FindClosestPeakPPM(double[] peakList, double Value, double PPMTol) {
        int ClosestIndex = -1;
        double SmallestTol = 2.147483647E9;
        double Tol = Value / 1000000.0 * PPMTol;
        int i = 0;
        while (i < peakList.length) {
            if (Math.abs(peakList[i] - Value) < Tol && Math.abs(peakList[i] - Value) < SmallestTol) {
                SmallestTol = Math.abs(peakList[i] - Value);
                ClosestIndex = i;
            }
            ++i;
        }
        return ClosestIndex;
    }

    public static String JoinStringArray(String[] array, String delim) {
        if (array == null || array.length == 0) {
            return "";
        }
        String Ret = "";
        Ret = String.valueOf(Ret) + array[0];
        int i = 1;
        while (i < array.length) {
            Ret = String.valueOf(Ret) + delim + array[i];
            ++i;
        }
        return Ret;
    }

    public static ArrayList InsertInAscendingOrder(ArrayList L, int Value) {
        if (L == null) {
            L = new ArrayList<Integer>();
            L.add(new Integer(Value));
            return L;
        }
        if (L.isEmpty()) {
            L.add(new Integer(Value));
            return L;
        }
        int i = 0;
        while (i < L.size()) {
            int CurrInt = (Integer)L.get(i);
            if (Value <= CurrInt) {
                L.add(i, new Integer(Value));
                return L;
            }
            ++i;
        }
        L.add(new Integer(Value));
        return L;
    }

    public static ArrayList InsertDoubleInAscendingOrder(ArrayList L, double Value) {
        if (L == null) {
            L = new ArrayList<Double>();
            L.add(new Double(Value));
            return L;
        }
        if (L.isEmpty()) {
            L.add(new Double(Value));
            return L;
        }
        int i = 0;
        while (i < L.size()) {
            double CurrInt = (Double)L.get(i);
            if (Value <= CurrInt) {
                L.add(i, new Double(Value));
                return L;
            }
            ++i;
        }
        L.add(new Double(Value));
        return L;
    }

    public static boolean IntegerArrayListContains(ArrayList IntList, int Value) {
        int i = 0;
        while (i < IntList.size()) {
            if ((Integer)IntList.get(i) == Value) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static String[] GetHashtableKeysString(Hashtable Input) {
        String[] Ret = new String[Input.size()];
        Enumeration Keys = Input.keys();
        int Index = 0;
        while (Keys.hasMoreElements()) {
            Ret[Index] = (String)Keys.nextElement();
            ++Index;
        }
        return Ret;
    }

    public static byte[] ReverseByteOrder(byte[] OldOrder) {
        byte[] Ret = new byte[OldOrder.length];
        int i = 0;
        while (i < OldOrder.length) {
            Ret[Ret.length - 1 - i] = OldOrder[i];
            ++i;
        }
        return Ret;
    }

    public static void ClearDir(String Dir) {
        if (Utils.IsFile(Dir)) {
            Utils.DeleteFile(Dir);
            return;
        }
        if (!Utils.IsDir(Dir)) {
            return;
        }
        String[] Files = Utils.ListDir(Dir);
        int i = 0;
        while (i < Files.length) {
            if (Utils.IsDir(Files[i])) {
                Utils.ClearDir(Files[i]);
                Utils.DeleteFile(Files[i]);
            } else {
                Utils.DeleteFile(Files[i]);
            }
            ++i;
        }
    }

    public static void DeleteFile(String fileName) {
        File T = new File(fileName);
        if (T.isDirectory()) {
            Utils.ClearDir(fileName);
            T.delete();
        } else {
            T.delete();
        }
    }

    public static boolean MakeDir(String Dir) {
        File D = new File(Dir);
        if (!D.exists()) {
            return D.mkdirs();
        }
        return D.isDirectory();
    }

    public static boolean IsFile(String FileName) {
        File T = new File(FileName);
        return T.isFile();
    }

    public static boolean IsDir(String FileName) {
        File T = new File(FileName);
        return T.isDirectory();
    }

    public static boolean RunCommandWithStdOutToFile(String Command, String OutputFile, String errFileName, String[] env, String Dir) throws Exception {
        System.out.println("Issuing Command: " + Command + " from dir " + Dir + " to " + OutputFile);
        Runtime CurrRuntime = Runtime.getRuntime();
        Process P = CurrRuntime.exec(Command, env, new File(Dir));
        FileOutputStream fos = new FileOutputStream(OutputFile);
        FileOutputStream ferr = new FileOutputStream(errFileName);
        StreamGobbler errorGobbler = new StreamGobbler(P.getErrorStream(), "ERROR", ferr);
        StreamGobbler outputGobbler = new StreamGobbler(P.getInputStream(), "", fos);
        errorGobbler.start();
        outputGobbler.start();
        int exitCode = P.waitFor();
        fos.close();
        ferr.close();
        System.out.println("Command finished with exit code " + exitCode);
        return true;
    }

    /*
     * Unable to fully structure code
     */
    public static boolean Cat(String[] Files, String CombinedFile) {
        try {
            Writer = new BufferedWriter(new FileWriter(CombinedFile));
        }
        catch (Exception E) {
            System.out.println(E.getMessage());
            return false;
        }
        i = 0;
        while (i < Files.length) {
            try {
                Reader = new BufferedReader(new FileReader(Files[i]));
                Line = Reader.readLine();
                if (true) ** GOTO lbl25
            }
            catch (Exception E) {
                System.out.println(E.getMessage());
                return false;
            }
            do {
                try {
                    Writer.write(Line);
                    Writer.newLine();
                    Line = Reader.readLine();
                }
                catch (Exception E) {
                    System.out.println(E.getMessage());
                    return false;
                }
lbl25:
                // 2 sources

            } while (Line != null);
            try {
                Reader.close();
            }
            catch (Exception E) {
                System.out.println(E.getMessage());
                return false;
            }
            ++i;
        }
        try {
            Writer.close();
        }
        catch (Exception E) {
            System.out.println(E.getMessage());
            return false;
        }
        return true;
    }

    public static boolean RunCommand(String Command, String[] env, String Dir) throws Exception {
        System.out.println("Issuing Command: " + Command + " from dir " + Dir);
        Runtime CurrRuntime = Runtime.getRuntime();
        Process P = CurrRuntime.exec(Command, env, new File(Dir));
        StreamGobbler errorGobbler = new StreamGobbler(P.getErrorStream(), "ERROR");
        StreamGobbler outputGobbler = new StreamGobbler(P.getInputStream(), "");
        errorGobbler.start();
        outputGobbler.start();
        P.waitFor();
        System.out.println("Command finished");
        return true;
    }

    public static String ReverseComplement(String S) {
        String Ret = "";
        int i = S.length() - 1;
        while (i >= 0) {
            Ret = String.valueOf(Ret) + Utils.Complement(S.charAt(i));
            --i;
        }
        return Ret;
    }

    public static char Complement(char Nuc) {
        switch (Nuc) {
            case 'A': 
            case 'a': {
                return 'T';
            }
            case 'C': 
            case 'c': {
                return 'G';
            }
            case 'G': 
            case 'g': {
                return 'C';
            }
            case 'T': 
            case 't': {
                return 'A';
            }
        }
        return 'X';
    }

    public static boolean IsSingleAAGap(double abs, double tol) {
        int i = 0;
        while (i < AAMasses.length) {
            if (AAMasses[i] != Double.NEGATIVE_INFINITY && Math.abs(abs - AAMasses[i]) < tol) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean IsDoubleAAGap(double abs, double tol) {
        int i = 0;
        while (i < AAMasses.length) {
            if (AAMasses[i] != Double.NEGATIVE_INFINITY) {
                int j = 0;
                while (j < AAMasses.length) {
                    if (AAMasses[j] != Double.NEGATIVE_INFINITY && Math.abs(abs - AAMasses[i] - AAMasses[j]) < tol) {
                        return true;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return false;
    }

    public static String GetSingleAA(double abs, double tol) {
        int i = 0;
        while (i < AAMasses.length) {
            if (AAMasses[i] != Double.NEGATIVE_INFINITY && Math.abs(abs - AAMasses[i]) < tol) {
                return "" + (char)(i + 65);
            }
            ++i;
        }
        return null;
    }

    public static String GetDoubleAA(double abs, double tol) {
        int i = 0;
        while (i < AAMasses.length) {
            if (AAMasses[i] != Double.NEGATIVE_INFINITY) {
                int j = 0;
                while (j < AAMasses.length) {
                    if (AAMasses[j] != Double.NEGATIVE_INFINITY && Math.abs(abs - AAMasses[i] - AAMasses[j]) < tol) {
                        return "[" + abs + "]";
                    }
                    ++j;
                }
            }
            ++i;
        }
        return null;
    }

    public static Comparable[] SortIncreasingOrder(Comparable[] list) {
        int i = 0;
        while (i < list.length) {
            int currMinIndex = i;
            Comparable currMinVal = list[i];
            int j = i + 1;
            while (j < list.length) {
                if (list[j].compareTo(currMinVal) < 0) {
                    currMinVal = list[j];
                    currMinIndex = j;
                }
                ++j;
            }
            if (currMinIndex != i) {
                Comparable temp = list[i];
                list[i] = list[currMinIndex];
                list[currMinIndex] = temp;
            }
            ++i;
        }
        return list;
    }

    public static ArrayList DeepCopyIntArrayList(ArrayList arrayList) {
        ArrayList<Integer> NewList = new ArrayList<Integer>();
        int i = 0;
        while (i < arrayList.size()) {
            int currVal = (Integer)arrayList.get(i);
            NewList.add(new Integer(currVal));
            ++i;
        }
        return NewList;
    }

    public static int CountMissedCleavages(String Peptide2) {
        if (Peptide2.indexOf(".") >= 0) {
            Peptide2 = Peptide2.substring(2, Peptide2.length() - 2);
        }
        int CleavageCount = 0;
        int i = 0;
        while (i < Peptide2.length() - 1) {
            if (Peptide2.charAt(i) == 'R' || Peptide2.charAt(i) == 'K') {
                ++CleavageCount;
            }
            ++i;
        }
        return CleavageCount;
    }

    public static double[] SortDoubleArrayIncreasing(double[] input) {
        int i = 0;
        while (i < input.length) {
            int MinIndex = i;
            double MinValue = input[i];
            int j = i + 1;
            while (j < input.length) {
                if (input[j] < MinValue) {
                    MinValue = input[j];
                    MinIndex = j;
                }
                ++j;
            }
            if (MinIndex != i) {
                double temp = input[i];
                input[i] = input[MinIndex];
                input[MinIndex] = temp;
            }
            ++i;
        }
        return input;
    }

    public static double GetClosestSingleOrDoubleAAMass(double abs, double tol) {
        int i = 0;
        while (i < AAMasses.length) {
            if (AAMasses[i] != Double.NEGATIVE_INFINITY && Math.abs(abs - AAMasses[i]) < tol) {
                return AAMasses[i];
            }
            ++i;
        }
        i = 0;
        while (i < AAMasses.length) {
            if (AAMasses[i] != Double.NEGATIVE_INFINITY) {
                int j = 0;
                while (j < AAMasses.length) {
                    if (AAMasses[j] != Double.NEGATIVE_INFINITY && Math.abs(abs - AAMasses[i] - AAMasses[j]) < tol) {
                        return AAMasses[i] + AAMasses[j];
                    }
                    ++j;
                }
            }
            ++i;
        }
        return -1.0;
    }

    public static String ConvertMutations(String annotationWithFlanking) {
        String Ret = "";
        int Index = annotationWithFlanking.indexOf(62);
        int PrevIndex = 0;
        while (Index >= 0) {
            Ret = String.valueOf(Ret) + annotationWithFlanking.substring(PrevIndex, Index - 3);
            PrevIndex = Index + 1;
            Index = annotationWithFlanking.indexOf(">", PrevIndex);
        }
        Ret = String.valueOf(Ret) + annotationWithFlanking.substring(PrevIndex);
        return Ret.toUpperCase();
    }

    public static boolean IsRunningWindows() {
        String sysName = System.getProperty("os.name").toLowerCase();
        return sysName.indexOf("win") >= 0;
    }

    public static boolean IsRunning32Bit() {
        String sysName = System.getProperty("os.arch").toLowerCase();
        return sysName.indexOf("64") < 0;
    }

    public static double[] GetSeqPRM(String Sequence) {
        if (Sequence.charAt(1) == '.' && Sequence.charAt(Sequence.length() - 2) == '.') {
            Sequence = Sequence.substring(2, Sequence.length() - 2);
        }
        ArrayList<Double> PRMs = new ArrayList<Double>();
        PRMs.add(new Double(0.0));
        double CurrSum = 0.0;
        int i = 0;
        while (i < Sequence.length()) {
            if (Sequence.charAt(i) == '[') {
                int End = Sequence.indexOf(93, i);
                double PRM = (int)Double.parseDouble(Sequence.substring(i + 1, End));
                PRMs.add(new Double(CurrSum += PRM));
                i = End;
            } else {
                int Index = Sequence.charAt(i) - 65;
                if (Index < 0 || Index > AAMasses.length) {
                    System.out.println("**ERROR:Inappropriate Char: " + Sequence.charAt(i) + " in **" + Sequence + "**");
                }
                PRMs.add(new Double(CurrSum += AAMasses[Sequence.charAt(i) - 65]));
            }
            ++i;
        }
        return Utils.ConvertArraylistToDoubleArray(PRMs);
    }

    public static boolean PeptidesArePRMEquivalent(String correctPeptide, String p) {
        double[] prmB;
        double[] prmA = Utils.GetSeqPRM(correctPeptide);
        if (prmA.length < (prmB = Utils.GetSeqPRM(p)).length) {
            return false;
        }
        int i = 0;
        while (i < prmB.length) {
            boolean found = false;
            int j = 0;
            while (j < prmA.length) {
                if (Math.abs(prmB[i] - prmA[j]) <= LTQFragTol) {
                    found = true;
                    break;
                }
                ++j;
            }
            if (!found) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static double GetPercentCorrectPRMs(String correctPeptide, String string, double fragTol) {
        double[] correctPRMs = Utils.GetSeqPRM(correctPeptide);
        double[] guessedPRMs = Utils.GetSeqPRM(string);
        double correctPRMCount = 0.0;
        int i = 0;
        while (i < guessedPRMs.length) {
            int j = 0;
            while (j < correctPRMs.length) {
                if (Math.abs(guessedPRMs[i] - correctPRMs[j]) < fragTol) {
                    correctPRMCount += 1.0;
                    break;
                }
                ++j;
            }
            ++i;
        }
        return correctPRMCount / (double)guessedPRMs.length;
    }

    public static double GetPercentMissedPRMs(String correctPeptide, String string, double fragTol) {
        double[] correctPRMs = Utils.GetSeqPRM(correctPeptide);
        double[] guessedPRMs = Utils.GetSeqPRM(string);
        double foundPRMCount = 0.0;
        int i = 0;
        while (i < correctPRMs.length) {
            int j = 0;
            while (j < guessedPRMs.length) {
                if (Math.abs(guessedPRMs[j] - correctPRMs[i]) < fragTol) {
                    foundPRMCount += 1.0;
                    break;
                }
                ++j;
            }
            ++i;
        }
        return 1.0 - foundPRMCount / (double)correctPRMs.length;
    }

    public static int[] getHammingDistanceOfSubstrings(String A, String B) {
        int[][] Score = new int[A.length()][B.length()];
        int i = 0;
        while (i < Score[0].length) {
            Score[0][i] = 0;
            if (A.charAt(0) == B.charAt(i)) {
                Score[0][i] = 1;
            }
            ++i;
        }
        i = 0;
        while (i < Score.length) {
            Score[i][0] = 0;
            if (A.charAt(i) == B.charAt(0)) {
                Score[i][0] = 1;
            }
            ++i;
        }
        int bestScore = Score[0][0];
        int[] bestCoords = new int[2];
        int i2 = 1;
        while (i2 < Score.length) {
            int j = 1;
            while (j < Score[0].length) {
                Score[i2][j] = A.charAt(i2) == B.charAt(j) ? Score[i2 - 1][j - 1] + 1 : Score[i2 - 1][j - 1];
                if (Score[i2][j] >= bestScore) {
                    bestCoords[0] = i2;
                    bestCoords[1] = j;
                    bestScore = Score[i2][j];
                }
                ++j;
            }
            ++i2;
        }
        int length = Math.min(bestCoords[0], bestCoords[1]) + 1;
        int[] ret = new int[]{length - bestScore, length};
        return ret;
    }

    public static boolean isGoodTag(String correctPeptide, double tagPrefix, String tagSeq, double tagSuffix) {
        int strPos = 0;
        int tagPos = 0;
        boolean debug = false;
        if (correctPeptide.charAt(1) == '.') {
            correctPeptide = correctPeptide.substring(2, correctPeptide.length() - 2);
        }
        if (debug) {
            System.out.println("Find tag [" + tagPrefix + "]" + tagSeq + "[" + tagSuffix + "] in " + correctPeptide);
        }
        while (strPos < correctPeptide.length()) {
            if (tagPos == tagSeq.length()) {
                double observedPrefix = Utils.GetSeqMass(correctPeptide.substring(0, strPos - tagPos));
                double observedSuffix = Utils.GetSeqMass(correctPeptide.substring(strPos));
                if (debug) {
                    System.out.println("Found seq match at : " + strPos);
                }
                if (Math.abs(observedPrefix - tagPrefix) < LTQFragTol && Math.abs(observedSuffix - tagSuffix) < LTQFragTol) {
                    if (debug) {
                        System.out.println("And matched the prefix suffix");
                        System.out.println(String.valueOf(observedPrefix) + "~" + tagPrefix + " and " + observedSuffix + "~" + tagSuffix);
                        Utils.WaitForEnter();
                    }
                    return true;
                }
                if (debug) {
                    System.out.println("Not a match!");
                    System.out.println(String.valueOf(observedPrefix) + "!~" + tagPrefix + " and " + observedSuffix + "!~" + tagSuffix);
                    Utils.WaitForEnter();
                }
                strPos -= tagPos;
                ++strPos;
                tagPos = 0;
                continue;
            }
            if (correctPeptide.charAt(strPos) == tagSeq.charAt(tagPos) || correctPeptide.charAt(strPos) == 'K' && tagSeq.charAt(tagPos) == 'Q' || correctPeptide.charAt(strPos) == 'Q' && tagSeq.charAt(tagPos) == 'K' || correctPeptide.charAt(strPos) == 'I' && tagSeq.charAt(tagPos) == 'L' || correctPeptide.charAt(strPos) == 'L' && tagSeq.charAt(tagPos) == 'I') {
                ++strPos;
                ++tagPos;
                continue;
            }
            if (correctPeptide.charAt(strPos) == tagSeq.charAt(tagPos)) continue;
            strPos -= tagPos;
            ++strPos;
            tagPos = 0;
        }
        return false;
    }

    public static int findTagPositionILQKAgnostic(String string, String tagSeq) {
        int strPos = 0;
        int tagPos = 0;
        while (strPos < string.length()) {
            if (tagPos == tagSeq.length()) {
                return strPos - tagPos;
            }
            if (string.charAt(strPos) == tagSeq.charAt(tagPos) || string.charAt(strPos) == 'K' && tagSeq.charAt(tagPos) == 'Q' || string.charAt(strPos) == 'Q' && tagSeq.charAt(tagPos) == 'K' || string.charAt(strPos) == 'I' && tagSeq.charAt(tagPos) == 'L' || string.charAt(strPos) == 'L' && tagSeq.charAt(tagPos) == 'I') {
                ++strPos;
                ++tagPos;
                continue;
            }
            if (string.charAt(strPos) == tagSeq.charAt(tagPos)) continue;
            ++strPos;
            tagPos = 0;
        }
        return -1;
    }

    public static int[] MergeIntArraysInAscendingOrder(int[] scans, int[] oldScans) {
        int[] ret = new int[oldScans.length + scans.length];
        int retIndex = 0;
        int aIndex = 0;
        int bIndex = 0;
        while (aIndex < scans.length && bIndex < oldScans.length) {
            if (scans[aIndex] < oldScans[bIndex]) {
                ret[retIndex] = scans[aIndex];
                ++aIndex;
                ++retIndex;
                continue;
            }
            if (scans[aIndex] > oldScans[bIndex]) {
                ret[retIndex] = oldScans[bIndex];
                ++bIndex;
                ++retIndex;
                continue;
            }
            ret[retIndex] = scans[aIndex];
            ++aIndex;
            ret[++retIndex] = oldScans[bIndex];
            ++bIndex;
            ++retIndex;
        }
        while (aIndex < scans.length) {
            ret[retIndex] = scans[aIndex];
            ++aIndex;
            ++retIndex;
        }
        while (bIndex < oldScans.length) {
            ret[retIndex] = oldScans[bIndex];
            ++bIndex;
            ++retIndex;
        }
        return ret;
    }

    public static int convertBinary2Decimal(boolean[] bits) {
        int ret = 0;
        String temp = "";
        int i = bits.length - 1;
        while (i >= 0) {
            if (bits[i]) {
                ret = (int)((double)ret + Math.pow(2.0, bits.length - 1 - i));
                temp = "1" + temp;
            } else {
                temp = "0" + temp;
            }
            --i;
        }
        return ret;
    }

    public static boolean[] convertDecimal2Binary(int i, int len) {
        int val = i;
        boolean[] ret = new boolean[len];
        int k = len - 1;
        while (k >= 0) {
            int currPower = (int)Math.pow(2.0, k);
            if (currPower <= val) {
                ret[len - 1 - k] = true;
                val -= currPower;
            } else {
                ret[len - 1 - k] = false;
            }
            --k;
        }
        return ret;
    }

    public static boolean MatchesAnyCaseInsensitive(String intervalType, String[] intervalTypes) {
        if (intervalType == null) {
            System.err.println("ERROR: Utils.MatchesAnyCaseInsensitive: query string is null!");
            return false;
        }
        if (intervalTypes == null || intervalTypes.length == 0) {
            System.err.println("ERROR: Utils.MatchesAnyCaseInsensitive: DB string array is null or 0-length!");
            return false;
        }
        int i = 0;
        while (i < intervalTypes.length) {
            if (intervalTypes[i].length() != 0 && intervalType.compareToIgnoreCase(intervalTypes[i]) == 0) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean copyFile(String sourceName, String destName) {
        String sysCall = "cp " + sourceName + " " + destName;
        boolean ret = false;
        try {
            ret = Utils.RunCommand(sysCall, null, Utils.GetFilePath(sourceName));
        }
        catch (Exception E) {
            E.printStackTrace();
            return false;
        }
        return ret;
    }

    public static String JoinIntArray(int[] usedPRMs, String string) {
        String ret = "";
        int i = 0;
        while (i < usedPRMs.length) {
            if (i != 0) {
                ret = String.valueOf(ret) + string;
            }
            ret = String.valueOf(ret) + usedPRMs[i];
            ++i;
        }
        return ret;
    }

    public static Hashtable ParseCSPSInputFile(String configFileName, String[] options, int[] numValues) {
        boolean LocalDebug = false;
        Hashtable<String, ArrayList> Ret = new Hashtable<String, ArrayList>();
        BufferedReader Reader2 = null;
        try {
            Reader2 = new BufferedReader(new FileReader(configFileName));
        }
        catch (IOException E) {
            System.out.println(E.getMessage());
            System.exit(0);
        }
        String Line = null;
        try {
            Line = Reader2.readLine();
        }
        catch (IOException E) {
            System.out.println(E.getMessage());
            System.exit(0);
        }
        while (Line != null) {
            String[] vals = Line.split("=");
            if (vals.length < 1) {
                try {
                    Line = Reader2.readLine();
                }
                catch (IOException E) {
                    System.out.println(E.getMessage());
                    System.exit(0);
                }
                continue;
            }
            String ID = vals[0].toLowerCase();
            String[] Values = null;
            if (LocalDebug) {
                System.out.println("Found ID: " + ID);
            }
            int i = 0;
            while (i < options.length) {
                if (ID.compareTo(options[i].toLowerCase()) == 0) {
                    Values = new String[numValues[i]];
                    break;
                }
                ++i;
            }
            String[] splitVals = vals[1].split(",");
            if (Values != null) {
                if (LocalDebug) {
                    System.out.println("Expecting " + Values.length + " values");
                }
                if (splitVals.length >= Values.length) {
                    ArrayList PrevValues;
                    if (LocalDebug) {
                        System.out.println("Found " + splitVals.length + " values");
                    }
                    int j = 0;
                    while (j < Values.length) {
                        Values[j] = splitVals[j];
                        ++j;
                    }
                    if (LocalDebug) {
                        System.out.println("Values: " + Values);
                    }
                    if (!Ret.containsKey(ID.toLowerCase())) {
                        if (LocalDebug) {
                            System.out.println("This is the first occurrence of this option");
                        }
                        PrevValues = new ArrayList();
                        PrevValues.add(Values);
                        Ret.put(ID.toLowerCase(), PrevValues);
                    } else {
                        if (LocalDebug) {
                            System.out.println("This is not the first occurrence of this option");
                        }
                        PrevValues = (ArrayList)Ret.get(ID.toLowerCase());
                        PrevValues.add(Values);
                        Ret.put(ID.toLowerCase(), PrevValues);
                    }
                }
            }
            try {
                Line = Reader2.readLine();
            }
            catch (IOException E) {
                System.out.println(E.getMessage());
                System.exit(0);
            }
        }
        return Ret;
    }

    public static Hashtable ParseInputFile(String FileName, String[] Options, int[] NumValues) {
        boolean LocalDebug = false;
        Hashtable<String, ArrayList> Ret = new Hashtable<String, ArrayList>();
        BufferedReader Reader2 = null;
        try {
            Reader2 = new BufferedReader(new FileReader(FileName));
        }
        catch (IOException E) {
            System.out.println(E.getMessage());
            System.exit(0);
        }
        String Line = null;
        try {
            Line = Reader2.readLine();
        }
        catch (IOException E) {
            System.out.println(E.getMessage());
            System.exit(0);
        }
        while (Line != null) {
            StringTokenizer sTok = new StringTokenizer(Line, ",");
            if (sTok.countTokens() < 1) {
                try {
                    Line = Reader2.readLine();
                }
                catch (IOException E) {
                    System.out.println(E.getMessage());
                    System.exit(0);
                }
                continue;
            }
            String ID = (String)sTok.nextElement();
            String[] Values = null;
            if (LocalDebug) {
                System.out.println("Found ID: " + ID);
            }
            int i = 0;
            while (i < Options.length) {
                if (ID.toLowerCase().compareTo(Options[i].toLowerCase()) == 0) {
                    Values = new String[NumValues[i]];
                    break;
                }
                ++i;
            }
            if (Values != null) {
                if (LocalDebug) {
                    System.out.println("Expecting " + Values.length + " values");
                }
                int j = 0;
                while (j < Values.length) {
                    Values[j] = sTok.hasMoreElements() ? sTok.nextToken() : null;
                    ++j;
                }
                if (!Ret.containsKey(ID.toLowerCase())) {
                    if (LocalDebug) {
                        System.out.println("This is the first occurrence of this option");
                    }
                    ArrayList<String[]> PrevValues = new ArrayList<String[]>();
                    PrevValues.add(Values);
                    Ret.put(ID.toLowerCase(), PrevValues);
                } else {
                    if (LocalDebug) {
                        System.out.println("This is not the first occurrence of this option");
                    }
                    ArrayList PrevValues = (ArrayList)Ret.get(ID.toLowerCase());
                    PrevValues.add(Values);
                    Ret.put(ID.toLowerCase(), PrevValues);
                }
            }
            try {
                Line = Reader2.readLine();
            }
            catch (IOException E) {
                System.out.println(E.getMessage());
                System.exit(0);
            }
        }
        return Ret;
    }

    public static boolean createEmptyFile(String fileName) {
        File f = new File(fileName);
        try {
            f.createNewFile();
        }
        catch (Exception E) {
            E.printStackTrace();
            return false;
        }
        return true;
    }

    public static double GetMFromMZ(double parentMZ, int charge) {
        return parentMZ * (double)charge - (double)charge * 1.0078 + 19.0;
    }

    public static ArrayList InsertInOrder(ArrayList candidateLinkToExons, Comparable exonB) {
        if (candidateLinkToExons == null) {
            return null;
        }
        int i = 0;
        while (i < candidateLinkToExons.size()) {
            Comparable currEl = (Comparable)candidateLinkToExons.get(i);
            if (currEl.compareTo(exonB) > 0) {
                candidateLinkToExons.add(i, exonB);
                return candidateLinkToExons;
            }
            ++i;
        }
        candidateLinkToExons.add(exonB);
        return candidateLinkToExons;
    }

    public static boolean[] initializeBooleanArray(boolean[] considered, boolean b) {
        int i = 0;
        while (i < considered.length) {
            considered[i] = b;
            ++i;
        }
        return considered;
    }

    public static boolean[][] initializeBooleanMatrix(boolean[][] edgeMap, boolean b) {
        int i = 0;
        while (i < edgeMap.length) {
            int j = 0;
            while (j < edgeMap[0].length) {
                edgeMap[i][j] = b;
                ++j;
            }
            ++i;
        }
        return edgeMap;
    }

    public static int[] initializeIntArray(int[] ret, int i) {
        int j = 0;
        while (j < ret.length) {
            ret[j] = i;
            ++j;
        }
        return ret;
    }

    public static double[] initializeDoubleArray(double[] ret, double d) {
        int j = 0;
        while (j < ret.length) {
            ret[j] = d;
            ++j;
        }
        return ret;
    }

    public static String JoinHashSet(Set sources, String delim) {
        if (sources == null || sources.size() == 0) {
            return "";
        }
        String ret = "";
        for (String name : sources) {
            ret = String.valueOf(ret) + name + delim;
        }
        return ret.substring(0, ret.length() - 1);
    }

    public static HashSet toLowerCase(HashSet pNamesToInvestigate) {
        HashSet<String> ret = new HashSet<String>();
        for (String currName : pNamesToInvestigate) {
            ret.add(currName.toLowerCase());
        }
        return ret;
    }

    public static int FindStringInArray(String[] array, String string) {
        int i = 0;
        while (array != null && i < array.length) {
            if (array[i].equals(string)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static int FindStringInArrayCaseInsensitive(String[] array, String string) {
        int i = 0;
        while (array != null && i < array.length) {
            if (array[i].equalsIgnoreCase(string)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static String[] appendToArray(String[] columnHeaders, String string) {
        if (columnHeaders == null) {
            String[] ret = new String[]{string};
            return ret;
        }
        String[] ret = new String[columnHeaders.length + 1];
        int i = 0;
        while (i < columnHeaders.length) {
            ret[i] = columnHeaders[i];
            ++i;
        }
        ret[columnHeaders.length] = string;
        return ret;
    }

    public static ArrayList InsertObjectArrayInOrder(ArrayList eventAndCompList, Object[] currEntry, int i) {
        if (eventAndCompList == null) {
            eventAndCompList = new ArrayList<Object[]>();
        }
        if (currEntry.length <= i) {
            ErrorThrower.ThrowError(4, "Index " + i + " is larger than entry size '" + currEntry.length + "'");
        }
        Comparable value = (Comparable)currEntry[i];
        int j = 0;
        while (j < eventAndCompList.size()) {
            Comparable listVal;
            Object[] listEl = (Object[])eventAndCompList.get(j);
            if (listEl.length <= i) {
                ErrorThrower.ThrowError(4, "Index " + i + " is larger than list item size '" + listEl.length + "'");
            }
            if (value.compareTo(listVal = (Comparable)listEl[i]) <= 0) {
                eventAndCompList.add(j, currEntry);
                return eventAndCompList;
            }
            ++j;
        }
        eventAndCompList.add(currEntry);
        return eventAndCompList;
    }

    public static String getOperatingSystem() {
        String sysName = System.getProperty("os.name").toLowerCase();
        System.out.println("SYSNAME: " + sysName);
        if (sysName.indexOf("win") >= 0) {
            return "win";
        }
        if (sysName.indexOf("mac") >= 0) {
            return "mac";
        }
        return "linux";
    }

    public static String[] LoadColumnFromFiles(String[] peptideFileNames, String delim, int column) {
        HashSet<String> columnVals = new HashSet<String>();
        int i = 0;
        while (i < peptideFileNames.length) {
            BufferedReader buf = null;
            String line = null;
            try {
                buf = new BufferedReader(new FileReader(peptideFileNames[i]));
                line = buf.readLine();
            }
            catch (IOException E) {
                ErrorThrower.ThrowError(5, peptideFileNames[i]);
            }
            while (line != null) {
                if ((line = line.trim()).length() == 0 || line.charAt(0) == '#') {
                    try {
                        line = buf.readLine();
                    }
                    catch (IOException E) {
                        ErrorThrower.ThrowError(6, peptideFileNames[i]);
                    }
                    continue;
                }
                String[] bits = line.split(delim);
                columnVals.add(bits[column]);
                try {
                    line = buf.readLine();
                }
                catch (IOException E) {
                    ErrorThrower.ThrowError(6, peptideFileNames[i]);
                }
            }
            try {
                buf.close();
            }
            catch (IOException E) {
                ErrorThrower.ThrowError(8, peptideFileNames[i]);
            }
            ++i;
        }
        return Utils.ConvertHashSetToStringArray(columnVals);
    }

    public static String[] ConvertHashSetToStringArray(Set sources) {
        Iterator i = sources.iterator();
        String[] ret = new String[sources.size()];
        int index = 0;
        while (i.hasNext()) {
            String el;
            ret[index] = el = (String)i.next();
            ++index;
        }
        return ret;
    }

    public static void compareKeySets(Hashtable map1, Hashtable map2, boolean full) {
        Set A = map1.keySet();
        Set B = map2.keySet();
        A.removeAll(B);
        System.out.println("Set A contains " + A.size() + " elements not in B");
        if (full) {
            Utils.WaitForEnter();
            for (Object n : A) {
                System.out.println(" - " + n + " -> " + map1.get(n));
            }
        }
        A = map1.keySet();
        System.out.println(A.size());
        B.removeAll(A);
        System.out.println("Set B contains " + B.size() + " elements not in A");
        if (full) {
            Utils.WaitForEnter();
            for (Object n : B) {
                System.out.println(" - " + n + " -> " + map2.get(n));
            }
        }
    }

    public static String AminoAcidify(String line) {
        String newLine = "";
        int i = 0;
        while (i < line.length()) {
            if (Utils.isAminoAcid(line.charAt(i))) {
                newLine = String.valueOf(newLine) + line.charAt(i);
            }
            ++i;
        }
        return newLine;
    }

    public static String AminoAcidify(String line, boolean silenceWarnings) {
        String newLine = "";
        int i = 0;
        while (i < line.length()) {
            if (Utils.isAminoAcid(line.charAt(i))) {
                newLine = String.valueOf(newLine) + line.charAt(i);
            }
            ++i;
        }
        return newLine;
    }

    public static boolean isAminoAcid(char c) {
        String cStr = "" + c;
        int index = (cStr = cStr.toUpperCase()).charAt(0) - 65;
        if (index < 0 || index >= AAMasses.length) {
            return false;
        }
        return !(AAMasses[index] < 0.0);
    }

    public static String[] SplitLineMergingDelims(String line, String delim) {
        String[] bits = line.split(delim);
        ArrayList<String> temp = new ArrayList<String>();
        int i = 0;
        while (i < bits.length) {
            if (bits[i].length() != 0) {
                temp.add(bits[i]);
            }
            ++i;
        }
        return Utils.ConvertArraylistToStringArray(temp);
    }

    public static BufferedReader openBufferedReader(String string) {
        BufferedReader buf = null;
        try {
            buf = new BufferedReader(new FileReader(string));
        }
        catch (IOException E) {
            ErrorThrower.ThrowError(5, string);
        }
        return buf;
    }

    public static String readNextLine(BufferedReader buf, String fileName) {
        String line = null;
        try {
            line = buf.readLine();
        }
        catch (IOException E) {
            ErrorThrower.ThrowError(6, fileName);
        }
        return line;
    }

    public static void closeBufferedReader(BufferedReader buf, String fileName) {
        try {
            buf.close();
        }
        catch (IOException E) {
            ErrorThrower.ThrowError(8, fileName);
        }
    }

    public static FileWriter openFileWriter(String currOutputFileName) {
        FileWriter f = null;
        try {
            f = new FileWriter(currOutputFileName);
        }
        catch (IOException E) {
            ErrorThrower.ThrowError(5, currOutputFileName);
        }
        return f;
    }

    public static void writeLine(FileWriter f, String currOutputFileName, String string) {
        try {
            f.write(string);
        }
        catch (IOException E) {
            ErrorThrower.ThrowError(7, currOutputFileName);
        }
    }

    public static void closeFileWriter(FileWriter f, String currOutputFileName) {
        try {
            f.close();
        }
        catch (IOException E) {
            ErrorThrower.ThrowError(8, currOutputFileName);
        }
    }

    public static int findMatchingPrefix(String query, String[] prefixes) {
        query = query.toLowerCase();
        int i = 0;
        while (prefixes != null && i < prefixes.length) {
            if (query.indexOf(prefixes[i].toLowerCase()) == 0) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static String RemoveFlankingAAs(String string) {
        if (string.indexOf(46) >= 0) {
            return string.substring(2, string.length() - 2);
        }
        return string;
    }

    public static String[] getKeyForValuePrefix(Hashtable gene2TranMap, String tran) {
        String[] keys = Utils.GetHashtableKeysString(gene2TranMap);
        ArrayList<String> ret = new ArrayList<String>();
        int i = 0;
        while (i < keys.length) {
            ArrayList currTrans = (ArrayList)gene2TranMap.get(keys[i]);
            int j = 0;
            while (j < currTrans.size()) {
                if (tran.equalsIgnoreCase((String)currTrans.get(j))) {
                    ret.add(keys[i]);
                }
                ++j;
            }
            ++i;
        }
        return Utils.ConvertArraylistToStringArray(ret);
    }

    public static boolean StringIsNum(String i) {
        try {
            Integer.parseInt(i);
            return true;
        }
        catch (NumberFormatException nfe) {
            return false;
        }
    }
}

