/*
 * Decompiled with CFR 0.152.
 */
package freemods;

import basicUtils.InspectAnnotation;
import basicUtils.Utils;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Hashtable;

public class AdjustMutations {
    public static String UsageInfo = "freemods.AdjustMutations version 08.31.2010\nRewrites Inspect results from a freemod search so that the X->Y in peptides is replaced by Y[REQUIRED]:\n -r [FILE] File containing Inspect results\n -w [FILE] Output file\n[OPTIONAL]:\n -d Run in Debug mode\n";
    private boolean Debug = false;
    private String InputFile;
    private String OutputFile;

    public AdjustMutations(String inputFile, String outputFile) {
        this.InputFile = inputFile;
        this.OutputFile = outputFile;
    }

    private void Adjust() {
        FileWriter w = null;
        BufferedReader buf = null;
        String Line = null;
        try {
            w = new FileWriter(this.OutputFile);
            buf = new BufferedReader(new FileReader(this.InputFile));
            Line = buf.readLine();
        }
        catch (IOException E) {
            E.printStackTrace();
            System.exit(-1);
        }
        while (Line != null) {
            if ((Line = Line.trim()).length() == 0 || Line.charAt(0) == '#') {
                try {
                    Line = buf.readLine();
                }
                catch (IOException E) {
                    E.printStackTrace();
                    System.exit(-1);
                }
                continue;
            }
            InspectAnnotation CurrAnn = new InspectAnnotation(Line, null);
            if (this.Debug) {
                System.out.println("Before conversion: " + CurrAnn.AnnotationWithFlanking);
            }
            CurrAnn.AnnotationWithFlanking = Utils.ConvertMutations(CurrAnn.AnnotationWithFlanking);
            if (this.Debug) {
                System.out.println("After conversion: " + CurrAnn.AnnotationWithFlanking);
                Utils.WaitForEnter();
            }
            try {
                w.write(String.valueOf(CurrAnn.toString()) + "\n");
                Line = buf.readLine();
            }
            catch (IOException E) {
                E.printStackTrace();
                System.exit(-1);
            }
        }
        try {
            w.close();
            buf.close();
        }
        catch (IOException E) {
            E.printStackTrace();
            System.exit(-1);
        }
    }

    public static void main(String[] args) {
        String InputFile;
        String[] options = new String[]{"-r", "-w", "-d"};
        boolean[] blArray = new boolean[3];
        blArray[0] = true;
        blArray[1] = true;
        boolean[] values = blArray;
        Hashtable CommandLineArgs = Utils.ParseCommandLine(args, options, values);
        if (!CommandLineArgs.containsKey("-r") || !CommandLineArgs.containsKey("-w")) {
            System.err.println("ERROR: Must specify an input and output file!");
            System.err.println(UsageInfo);
            System.exit(0);
        }
        if (!Utils.IsFile(InputFile = (String)CommandLineArgs.get("-r"))) {
            System.err.println("ERROR: Must specify a valid file for the input: " + InputFile);
            System.err.println(UsageInfo);
            System.exit(0);
        }
        String OutputFile = (String)CommandLineArgs.get("-w");
        AdjustMutations Adjuster = new AdjustMutations(InputFile, OutputFile);
        if (CommandLineArgs.containsKey("-d")) {
            Adjuster.Debug = true;
        }
        Adjuster.Adjust();
    }
}

