/*
 * Decompiled with CFR 0.152.
 */
package itraqUtils;

import basicUtils.Peptide;
import basicUtils.Utils;
import itraqUtils.InspectAnnotationITRAQ;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;

public class ITRAQPeptide
extends Peptide {
    public static final String UsageInfo = "itraqUtils.ITRAQPeptide\n  -r [DIR] directory containing Inspect results, itraq intensities extracted\n";
    public static boolean Debug = true;
    private double[] AvgITRAQIntensities;
    public static final int FoldChangeThreshold = 1;
    public static String[] ExpressionProfileNames = new String[]{"Strict Increase", "Strict Decrease", "Strict No Change", "Early Increase, Late Decrease", "Early Decrease, Late Increase", "Early No Change, Late Increase", "Early No Change, Late Decrease", "Early Increase, Late No Change", "Early Decrease, Late No Change"};

    public ITRAQPeptide(InspectAnnotationITRAQ Ann) {
        super(Ann);
        this.AvgITRAQIntensities = new double[Ann.ITRAQIntensities.length];
        int i = 0;
        while (i < this.AvgITRAQIntensities.length) {
            this.AvgITRAQIntensities[i] = Ann.ITRAQIntensities[i];
            ++i;
        }
    }

    public void AddAnnotation(InspectAnnotationITRAQ Ann) {
        int i = 0;
        while (i < this.AvgITRAQIntensities.length) {
            this.AvgITRAQIntensities[i] = (this.AvgITRAQIntensities[i] * (double)this.GetNumSupportingSpectra() + Ann.ITRAQIntensities[i]) / (double)(this.GetNumSupportingSpectra() + 1);
            ++i;
        }
        super.AddAnnotation(Ann);
    }

    public double[] GetITRAQIntensities() {
        return this.AvgITRAQIntensities;
    }

    public boolean IsUpRegulated(int Ion1, int Ion2) {
        return this.AvgITRAQIntensities[Ion2] / this.AvgITRAQIntensities[Ion1] > 1.0;
    }

    public double GetFoldChange(int Ion1, int Ion2) {
        return this.AvgITRAQIntensities[Ion2] / this.AvgITRAQIntensities[Ion1];
    }

    public static ITRAQPeptide[] LoadPeptideList(String DirName) {
        File Dir = new File(DirName);
        String[] Files = Dir.isDirectory() ? Dir.list() : new String[]{DirName};
        Hashtable<String, ITRAQPeptide> Peptides = new Hashtable<String, ITRAQPeptide>();
        int i = 0;
        while (i < Files.length) {
            int NonZeroCount = 0;
            String FileName = Files[i];
            if (Dir.isDirectory()) {
                FileName = String.valueOf(Dir.getAbsolutePath()) + File.separator + Files[i];
            }
            InspectAnnotationITRAQ[] Anns = InspectAnnotationITRAQ.LoadInspectResultsFile(FileName);
            if (Debug) {
                System.out.println("Loaded " + Anns.length + " annotations from " + FileName);
            }
            int j = 0;
            while (j < Anns.length) {
                boolean Found = false;
                int k = 0;
                while (k < InspectAnnotationITRAQ.ITRAQColumnHeaders.length) {
                    if (Anns[j].ITRAQIntensities[k] != 0.0) {
                        Found = true;
                        break;
                    }
                    ++k;
                }
                if (Found) {
                    Anns[j].NormalizeIntensities();
                    ++NonZeroCount;
                    if (Peptides.containsKey(Anns[j].Annotation)) {
                        ITRAQPeptide Temp = (ITRAQPeptide)Peptides.get(Anns[j].Annotation);
                        Temp.AddAnnotation(Anns[j]);
                        Peptides.put(Anns[j].Annotation, Temp);
                    } else {
                        ITRAQPeptide Temp = new ITRAQPeptide(Anns[j]);
                        Peptides.put(Anns[j].Annotation, Temp);
                    }
                }
                ++j;
            }
            if (Debug) {
                System.out.println("Annotations with a non-zero reporter ion: " + NonZeroCount);
            }
            ++i;
        }
        if (Debug) {
            System.out.println("Total peptides: " + Peptides.size());
        }
        Enumeration Keys = Peptides.keys();
        ITRAQPeptide[] Ret = new ITRAQPeptide[Peptides.size()];
        int Count = 0;
        Hashtable<String, ArrayList> UnModdedTable = new Hashtable<String, ArrayList>();
        while (Keys.hasMoreElements()) {
            String PeptideSeq = (String)Keys.nextElement();
            Ret[Count] = (ITRAQPeptide)Peptides.get(PeptideSeq);
            String Pep = Ret[Count].GetUnModifiedPeptideString();
            ArrayList List2 = UnModdedTable.containsKey(Pep) ? (ArrayList)UnModdedTable.get(Pep) : new ArrayList();
            List2.add(new Integer(Count));
            UnModdedTable.put(Pep, List2);
            if (Debug && !Debug) {
                System.out.println("[" + Count + "]:" + Ret[Count].toString());
            }
            ++Count;
        }
        Keys = UnModdedTable.keys();
        int MultipleVersionCount = 0;
        while (Keys.hasMoreElements()) {
            ArrayList Indexes;
            String Pep = (String)Keys.nextElement();
            if (Debug && !Debug) {
                System.out.println("Peptide: " + Pep);
            }
            if ((Indexes = (ArrayList)UnModdedTable.get(Pep)).size() >= 2) {
                ++MultipleVersionCount;
            }
            int i2 = 0;
            while (i2 < Indexes.size()) {
                int IndexA = (Integer)Indexes.get(i2);
                int j = i2 + 1;
                while (j < Indexes.size()) {
                    int IndexB = (Integer)Indexes.get(j);
                    Ret[IndexA].AddRelatedPeptide(Ret[IndexB]);
                    Ret[IndexB].AddRelatedPeptide(Ret[IndexA]);
                    ++j;
                }
                if (Debug && !Debug) {
                    System.out.println("[" + i2 + "]:" + Ret[IndexA].toString());
                }
                ++i2;
            }
            if (!Debug || Debug) continue;
            Utils.WaitForEnter();
        }
        System.out.println("Peptides with multiple mod versions: " + MultipleVersionCount);
        return Ret;
    }

    public String toString() {
        String Ret = "ITRAQPeptide: " + this.GetSequence() + ", Spectra: " + this.GetNumSupportingSpectra() + ", ITRAQ:";
        int i = 0;
        while (i < InspectAnnotationITRAQ.ITRAQColumnHeaders.length) {
            Ret = String.valueOf(Ret) + " " + InspectAnnotationITRAQ.ITRAQColumnHeaders[i] + "-" + this.AvgITRAQIntensities[i];
            ++i;
        }
        Ret = String.valueOf(Ret) + ", RELATED:";
        if (this.RelatedPeptides != null) {
            i = 0;
            while (i < this.RelatedPeptides.length) {
                Ret = String.valueOf(Ret) + " " + this.RelatedPeptides[i].GetSequence();
                ++i;
            }
        }
        return Ret;
    }

    public static ArrayList[] GetPeptidesByClassification(ITRAQPeptide[] Peptides, String[] Conditions) {
        ArrayList[] PeptideClasses = new ArrayList[9];
        int i = 0;
        while (i < PeptideClasses.length) {
            PeptideClasses[i] = new ArrayList();
            ++i;
        }
        int PeptidesSkipped = 0;
        int i2 = 0;
        while (i2 < Peptides.length) {
            ITRAQPeptide CurrPeptide = Peptides[i2];
            int PeptideClass = -1;
            double[] Temp = CurrPeptide.GetITRAQIntensities();
            if (Temp[0] == 0.0 || Temp[1] == 0.0 || Temp[2] == 0.0) {
                ++PeptidesSkipped;
            } else {
                double Early = Math.log(CurrPeptide.GetFoldChange(0, 1));
                double Late = Math.log(CurrPeptide.GetFoldChange(0, 2));
                if (Debug && !Debug) {
                    System.out.println("Early Fold Change: " + Early);
                    System.out.println("Late Fold Change: " + Late);
                }
                PeptideClass = Early >= 1.0 ? (Late >= Early + 1.0 ? 0 : (Late <= Early - 1.0 ? 3 : 7)) : (Early <= -1.0 ? (Late >= Early + 1.0 ? 4 : (Late <= Early - 1.0 ? 1 : 8)) : (Late >= 1.0 ? 5 : (Late <= -1.0 ? 6 : 2)));
                PeptideClasses[PeptideClass].add(CurrPeptide);
                if (Debug && !Debug) {
                    System.out.println(CurrPeptide.toString());
                    System.out.println("ExpressionProfile: " + PeptideClass);
                    Utils.WaitForEnter();
                }
            }
            ++i2;
        }
        System.out.println("Peptides skipped, with a zero reporter ion intensity: " + PeptidesSkipped);
        i2 = 0;
        while (i2 < PeptideClasses.length) {
            System.out.println("Class[" + ExpressionProfileNames[i2] + "]:" + PeptideClasses[i2].size());
            ++i2;
        }
        return PeptideClasses;
    }

    public static void WritePeptideClasses(ArrayList[] PeptideClasses, String OutputDir) {
        FileWriter Writer2;
        if (OutputDir == null) {
            return;
        }
        try {
            Writer2 = new FileWriter(OutputDir);
        }
        catch (IOException E) {
            E.printStackTrace();
            return;
        }
        int i = 0;
        while (i < PeptideClasses.length) {
            ArrayList Class2 = PeptideClasses[i];
            if (Class2.size() != 0) {
                try {
                    Writer2.write("#Expression Profile: " + i + ":" + ExpressionProfileNames[i] + "\n");
                    Writer2.write("#Protein\tPeptide\tSpectralCount\t114\t115\t116\t117\tRelatedPeptides\n");
                }
                catch (IOException E) {
                    E.printStackTrace();
                    return;
                }
                int j = 0;
                while (j < Class2.size()) {
                    ITRAQPeptide CurrPeptide = (ITRAQPeptide)Class2.get(j);
                    ArrayList Support = CurrPeptide.SupportingSpectra;
                    InspectAnnotationITRAQ Ann = (InspectAnnotationITRAQ)Support.get(0);
                    String Line = String.valueOf(Ann.ProteinName) + "\t" + CurrPeptide.Sequence + "\t" + Support.size() + "\t";
                    double[] ITRAQIntensities = CurrPeptide.GetITRAQIntensities();
                    Line = String.valueOf(Line) + ITRAQIntensities[0] + "\t" + ITRAQIntensities[1] + "\t" + ITRAQIntensities[2] + "\t" + ITRAQIntensities[3];
                    Line = String.valueOf(Line) + "\t";
                    Peptide[] Related = CurrPeptide.RelatedPeptides;
                    int k = 0;
                    while (Related != null && k < Related.length) {
                        Line = String.valueOf(Line) + Related[k].GetSequence() + ",";
                        ++k;
                    }
                    try {
                        Writer2.write(String.valueOf(Line) + "\n");
                    }
                    catch (IOException E) {
                        E.printStackTrace();
                        return;
                    }
                    ++j;
                }
            }
            ++i;
        }
        try {
            Writer2.close();
        }
        catch (IOException E) {
            E.printStackTrace();
            return;
        }
    }

    public static void main(String[] args) {
        String[] options = new String[]{"-r", "-o"};
        boolean[] values = new boolean[]{true, true};
        Hashtable Arguments = Utils.ParseCommandLine(args, options, values);
        String InputDir = "";
        String OutputDir = null;
        Enumeration Keys = Arguments.keys();
        while (Keys.hasMoreElements()) {
            String Opt = (String)Keys.nextElement();
            if (Opt.compareTo("-r") == 0) {
                InputDir = (String)Arguments.get(Opt);
                continue;
            }
            if (Opt.compareTo("-o") == 0) {
                OutputDir = (String)Arguments.get(Opt);
                continue;
            }
            System.err.println("ERROR: Option " + Opt + " is not recognized");
        }
        if (InputDir.compareTo("") == 0) {
            System.err.println("ERROR: Missing Arguments");
            System.out.println(UsageInfo);
            return;
        }
        String[] Conditions = new String[]{"0hrs", "2hrs", "4hrs", "None"};
        ITRAQPeptide[] List2 = ITRAQPeptide.LoadPeptideList(InputDir);
        ArrayList[] PeptideClasses = ITRAQPeptide.GetPeptidesByClassification(List2, Conditions);
        ITRAQPeptide.WritePeptideClasses(PeptideClasses, OutputDir);
    }
}

