/*
 * Decompiled with CFR 0.152.
 */
package itraqUtils;

import basicUtils.InspectAnnotation;
import java.io.BufferedReader;
import java.io.FileReader;
import java.util.ArrayList;

public class InspectAnnotationITRAQ
extends InspectAnnotation {
    public static String[] ITRAQColumnHeaders = new String[]{"114", "115", "116", "117"};
    public double[] ITRAQIntensities = new double[ITRAQColumnHeaders.length];

    public InspectAnnotationITRAQ(String FileLine, String HeaderLine) {
        super(FileLine, HeaderLine.substring(1).split("\t"));
        String[] HeaderElements = HeaderLine.split("\t");
        String[] Elements = FileLine.split("\t", -1);
        int i = 0;
        while (i < ITRAQColumnHeaders.length) {
            int j = 0;
            while (j < HeaderElements.length) {
                if (j >= Elements.length) break;
                if (HeaderElements[j].compareTo(ITRAQColumnHeaders[i]) == 0) {
                    this.ITRAQIntensities[i] = Double.parseDouble(Elements[j]);
                }
                ++j;
            }
            ++i;
        }
    }

    public void NormalizeIntensities() {
        double IntensitySum = 0.0;
        int i = 0;
        while (i < this.ITRAQIntensities.length) {
            IntensitySum += this.ITRAQIntensities[i];
            ++i;
        }
        i = 0;
        while (i < this.ITRAQIntensities.length) {
            int n = i++;
            this.ITRAQIntensities[n] = this.ITRAQIntensities[n] / IntensitySum;
        }
    }

    public static InspectAnnotationITRAQ[] LoadInspectResultsFile(String File2) {
        String Line;
        BufferedReader Reader2;
        String HeaderLine = "";
        try {
            Reader2 = new BufferedReader(new FileReader(File2));
            Line = Reader2.readLine();
        }
        catch (Exception E) {
            System.err.println(E.getMessage());
            return null;
        }
        ArrayList<InspectAnnotationITRAQ> Annotations = new ArrayList<InspectAnnotationITRAQ>();
        while (Line != null) {
            if (Line.length() > 0 && Line.charAt(0) != '#') {
                InspectAnnotationITRAQ NewAnnotation = new InspectAnnotationITRAQ(Line, HeaderLine);
                if (NewAnnotation.Length > 0) {
                    Annotations.add(NewAnnotation);
                }
            } else if (Line.length() > 0 && Line.charAt(0) == '#') {
                HeaderLine = Line;
            }
            try {
                Line = Reader2.readLine();
            }
            catch (Exception E) {
                System.err.println(E.getMessage());
                return null;
            }
        }
        InspectAnnotationITRAQ[] Ret = new InspectAnnotationITRAQ[Annotations.size()];
        int i = 0;
        while (i < Annotations.size()) {
            Ret[i] = (InspectAnnotationITRAQ)Annotations.get(i);
            ++i;
        }
        return Ret;
    }

    public static /* bridge */ /* synthetic */ InspectAnnotation[] LoadInspectResultsFile(String string) {
        return InspectAnnotationITRAQ.LoadInspectResultsFile(string);
    }
}

