/*
 * Decompiled with CFR 0.152.
 */
package maizeUtils;

import basicUtils.Utils;
import errorUtils.ErrorThrower;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.Hashtable;
import maizeUtils.MaizeUtils;

public class ClusterAnalyzer {
    public static final String UsageInfo = "UsageInfo: proteogenomicUtils.ClusterAnalyzer\nReports useful information about clusters\n[Required]\n-r [FILE] File containing novel events (in table form).\n[Optional]\n-p [FILE] File containing chosen proteins\n";
    private String inputFileName = null;
    private String chosenProteinFileName = null;
    private Hashtable proteinHash;
    private String[] typeNames = new String[]{"NovelExon", "GeneBoundary", "ExonBoundary", "NovelSplice", "TranslatedUTR", "ReverseStrand", "FrameShift"};
    private int[][] typeCountsWithKnown = new int[][]{new int[2], new int[2], new int[2], new int[2], new int[2], new int[2], new int[2]};
    private int totalNovelGenes = 0;
    private int totalEvents = 0;

    public ClusterAnalyzer(String InputDir, String proteinFileName) {
        this.inputFileName = InputDir;
        if (!Utils.IsFile(InputDir)) {
            ErrorThrower.ThrowError(4, "Invalid input directory '" + InputDir + "'");
        }
        this.chosenProteinFileName = proteinFileName;
        if (this.chosenProteinFileName != null && !Utils.IsFile(this.chosenProteinFileName)) {
            ErrorThrower.ThrowError(4, "Invalid protein file '" + this.chosenProteinFileName + "'");
        }
    }

    private void analyzeClusters() {
        if (this.chosenProteinFileName != null) {
            this.loadChosenProteins();
        }
        System.out.println("Analyzing : " + this.inputFileName);
        this.analyzeClusterFile(this.inputFileName);
        System.out.println("EventType Total TotalWithConfirming");
        int i = 0;
        while (i < this.typeNames.length) {
            System.out.println(String.valueOf(this.typeNames[i]) + " " + this.typeCountsWithKnown[i][0] + " " + this.typeCountsWithKnown[i][1]);
            ++i;
        }
        System.out.println("NovelGene " + this.totalNovelGenes);
        System.out.println("Total Events: " + this.totalEvents);
    }

    private void loadChosenProteins() {
        this.proteinHash = MaizeUtils.loadProteinFile2GeneHash(this.chosenProteinFileName);
    }

    private void analyzeClusterFile(String FileName) {
        BufferedReader buf = null;
        String Line = null;
        try {
            buf = new BufferedReader(new FileReader(FileName));
            Line = buf.readLine();
        }
        catch (IOException E) {
            ErrorThrower.ThrowError(5, FileName);
        }
        while (Line != null) {
            if ((Line = Line.trim()).length() == 0 || Line.charAt(0) == '#') {
                try {
                    Line = buf.readLine();
                }
                catch (IOException E) {
                    E.printStackTrace();
                    ErrorThrower.ThrowError(6, FileName);
                }
                continue;
            }
            ++this.totalEvents;
            String[] bits = Line.split("\t");
            if (bits[0].indexOf("chr") == 0) {
                ++this.totalNovelGenes;
            } else {
                String geneName = MaizeUtils.getMaizeGeneName(bits[0]);
                boolean confirmingPeptides = false;
                if (this.proteinHash != null && this.proteinHash.containsKey(geneName)) {
                    confirmingPeptides = true;
                }
                int i = 0;
                while (i < this.typeNames.length) {
                    if (this.typeNames[i].equals(bits[1])) {
                        int[] nArray = this.typeCountsWithKnown[i];
                        nArray[0] = nArray[0] + 1;
                        if (!confirmingPeptides) break;
                        int[] nArray2 = this.typeCountsWithKnown[i];
                        nArray2[1] = nArray2[1] + 1;
                        break;
                    }
                    ++i;
                }
            }
            try {
                Line = buf.readLine();
            }
            catch (IOException E) {
                E.printStackTrace();
                ErrorThrower.ThrowError(6, FileName);
            }
        }
        try {
            buf.close();
        }
        catch (IOException E) {
            E.printStackTrace();
            ErrorThrower.ThrowError(8, FileName);
        }
    }

    public static void main(String[] args) {
        String[] options = new String[]{"-r", "-p"};
        boolean[] values = new boolean[]{true, true};
        Hashtable CommandLineArgs = Utils.ParseCommandLine(args, options, values);
        if (!CommandLineArgs.containsKey("-r")) {
            System.err.println(UsageInfo);
            ErrorThrower.ThrowError(2, "Must specify an input directory!");
        }
        String InputDir = (String)CommandLineArgs.get("-r");
        String knownProteins = null;
        if (CommandLineArgs.containsKey("-p")) {
            knownProteins = (String)CommandLineArgs.get("-p");
        }
        ClusterAnalyzer runner = new ClusterAnalyzer(InputDir, knownProteins);
        runner.analyzeClusters();
    }
}

