/*
 * Decompiled with CFR 0.152.
 */
package maizeUtils;

import basicUtils.InspectAnnotation;
import basicUtils.Utils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import maizeUtils.MaizeUtils;
import proteogenomicUtils.ProteogenomicUtils;
import trieUtils.TrieDB;

public class JackFormatAugmenter {
    public static String UsageInfo = "maizeUtils.JackFormatAugmenter version 10.13.2011\nAdds the protein name of the first appearance of the peptide in the database, or\na stand in 'decoy' name with XXX.tempProtein\nAlso splits SpectrumMill results into 2 lines if the cluster contains\nmore than 1 spectrum.\n[REQUIRED]:\n-r [FILE/DIR] Directory of Jack formated files\n-w [DIR] Directory to write augmented files\n-t [FILE] Trie file containing proteins\n";
    private String[] inputFileNames;
    private String outputDir;
    private TrieDB trieFile;
    private Hashtable Peptide2Protein;

    public JackFormatAugmenter(String inputDir, String outputDir, String trieFileName) {
        if (Utils.IsFile(inputDir)) {
            this.inputFileNames = new String[1];
            this.inputFileNames[0] = inputDir;
        } else if (!Utils.IsDir(inputDir)) {
            System.err.println("ERROR: Invalid input directory '" + inputDir + "'!!");
            System.exit(-1);
        } else {
            this.inputFileNames = Utils.ListDir(inputDir);
        }
        if (!Utils.IsDir(outputDir)) {
            Utils.MakeDir(outputDir);
        }
        this.outputDir = outputDir;
        this.trieFile = new TrieDB(trieFileName);
    }

    public static void main(String[] args) {
        String[] options = new String[]{"-r", "-w", "-t"};
        boolean[] values = new boolean[]{true, true, true};
        Hashtable CommandLineArgs = Utils.ParseCommandLine(args, options, values);
        if (!(CommandLineArgs.containsKey("-r") && CommandLineArgs.containsKey("-w") && CommandLineArgs.containsKey("-t"))) {
            System.err.println("ERROR: Missing required arguments!");
            System.err.println(UsageInfo);
            System.exit(0);
        }
        String inputDir = (String)CommandLineArgs.get("-r");
        String outputDir = (String)CommandLineArgs.get("-w");
        String trieFileName = (String)CommandLineArgs.get("-t");
        JackFormatAugmenter a = new JackFormatAugmenter(inputDir, outputDir, trieFileName);
        int i = 0;
        while (i < a.inputFileNames.length) {
            a.augment(a.inputFileNames[i]);
            ++i;
        }
    }

    private void writeResults(String fileName) {
        FileWriter f = null;
        BufferedReader buf = null;
        String line = null;
        String outputFileName = String.valueOf(this.outputDir) + File.separator + Utils.GetBaseName(fileName);
        System.out.println("Writing augmented data to " + outputFileName);
        try {
            f = new FileWriter(outputFileName, false);
            buf = new BufferedReader(new FileReader(fileName));
            line = buf.readLine();
        }
        catch (IOException E) {
            E.printStackTrace();
            System.exit(-1);
        }
        while (line != null) {
            int scanEnd;
            int scanStart;
            if ((line = line.trim()).length() == 0) {
                try {
                    line = buf.readLine();
                }
                catch (IOException E) {
                    E.printStackTrace();
                    System.exit(-1);
                }
                continue;
            }
            if (line.charAt(0) == '#') {
                try {
                    f.write(String.valueOf(line) + "\tPeptideType\tAllProteinNames\n");
                    line = buf.readLine();
                }
                catch (IOException E) {
                    E.printStackTrace();
                    System.exit(-1);
                }
                continue;
            }
            String[] bits = line.split("\t");
            String CurrPeptide = Utils.GetUnModded(bits[InspectAnnotation.JackFormatColumns.Annotation]);
            if (!this.Peptide2Protein.containsKey(CurrPeptide)) {
                System.err.println("ERROR: Could not find a protein for " + CurrPeptide);
                try {
                    line = buf.readLine();
                }
                catch (IOException E) {
                    E.printStackTrace();
                    System.exit(-1);
                }
                continue;
            }
            HashSet proteinNames = (HashSet)this.Peptide2Protein.get(CurrPeptide);
            String sProteinNames = Utils.JoinHashSet(proteinNames, "!");
            ProteogenomicUtils.uniqueType t = MaizeUtils.getUniquenessType(proteinNames);
            String line2 = null;
            if (bits[InspectAnnotation.JackFormatColumns.SourceProgram].compareTo("SpectrumMill") == 0 && (scanStart = Integer.parseInt(bits[InspectAnnotation.JackFormatColumns.ScanNumber])) != (scanEnd = Integer.parseInt(bits[InspectAnnotation.JackFormatColumns.LastScanNumber]))) {
                bits[InspectAnnotation.JackFormatColumns.ScanNumber] = String.valueOf(scanStart);
                bits[InspectAnnotation.JackFormatColumns.LastScanNumber] = String.valueOf(scanStart);
                line2 = String.valueOf(bits[InspectAnnotation.JackFormatColumns.SpectrumFile]) + "\t" + scanEnd + "\t" + scanEnd;
                line2 = String.valueOf(line2) + "\t" + bits[InspectAnnotation.JackFormatColumns.Score] + "\t" + bits[InspectAnnotation.JackFormatColumns.Annotation];
                line2 = String.valueOf(line2) + "\t" + bits[InspectAnnotation.JackFormatColumns.Charge] + "\t" + bits[InspectAnnotation.JackFormatColumns.SourceProgram];
                line2 = String.valueOf(line2) + "\t" + bits[InspectAnnotation.JackFormatColumns.SpecProb];
                if (t == ProteogenomicUtils.uniqueType.PROT_UNIQUE) {
                    line2 = String.valueOf(line2) + "\t0";
                } else if (t == ProteogenomicUtils.uniqueType.LOC_UNIQUE) {
                    line2 = String.valueOf(line2) + "\t1";
                }
                if (t == ProteogenomicUtils.uniqueType.SHARED) {
                    line2 = String.valueOf(line2) + "\t2";
                }
                line2 = String.valueOf(line2) + "\t" + sProteinNames;
                line2 = String.valueOf(line2) + "\n";
            }
            String newLine = Utils.JoinStringArray(bits, "\t");
            if (t == ProteogenomicUtils.uniqueType.PROT_UNIQUE) {
                newLine = String.valueOf(newLine) + "\t0";
            } else if (t == ProteogenomicUtils.uniqueType.LOC_UNIQUE) {
                newLine = String.valueOf(newLine) + "\t1";
            }
            if (t == ProteogenomicUtils.uniqueType.SHARED) {
                newLine = String.valueOf(newLine) + "\t2";
            }
            newLine = String.valueOf(newLine) + "\t" + sProteinNames + "\n";
            try {
                f.write(newLine);
                if (line2 != null) {
                    f.write(line2);
                }
            }
            catch (IOException E) {
                E.printStackTrace();
                System.exit(-1);
            }
            try {
                line = buf.readLine();
            }
            catch (IOException E) {
                E.printStackTrace();
                System.exit(-1);
            }
        }
        try {
            buf.close();
            f.close();
        }
        catch (IOException E) {
            E.printStackTrace();
            System.exit(-1);
        }
    }

    private void augment(String fileName) {
        String CurrPeptide;
        if (this.Peptide2Protein == null) {
            this.Peptide2Protein = new Hashtable();
        } else {
            this.Peptide2Protein.clear();
        }
        BufferedReader buf = null;
        String line = null;
        ArrayList<String> CurrPeptides = new ArrayList<String>();
        System.out.println("Loading peptides from " + fileName);
        String outputFileName = String.valueOf(this.outputDir) + Utils.GetBaseName(fileName);
        try {
            buf = new BufferedReader(new FileReader(fileName));
            line = buf.readLine();
        }
        catch (IOException E) {
            E.printStackTrace();
            System.exit(-1);
        }
        while (line != null) {
            if ((line = line.trim()).length() == 0 || line.charAt(0) == '#') {
                try {
                    line = buf.readLine();
                }
                catch (IOException E) {
                    E.printStackTrace();
                    System.exit(-1);
                }
                continue;
            }
            String[] bits = line.split("\t");
            CurrPeptide = Utils.GetUnModded(bits[InspectAnnotation.JackFormatColumns.Annotation]);
            if (this.Peptide2Protein.containsKey(CurrPeptide)) {
                try {
                    line = buf.readLine();
                }
                catch (IOException E) {
                    E.printStackTrace();
                    System.exit(-1);
                }
                continue;
            }
            if (CurrPeptides.contains(CurrPeptide)) {
                try {
                    line = buf.readLine();
                }
                catch (IOException E) {
                    E.printStackTrace();
                    System.exit(-1);
                }
                continue;
            }
            CurrPeptides.add(CurrPeptide);
            if (CurrPeptides.size() >= 5000) {
                System.out.println("Loaded " + CurrPeptides.size() + " peptides, searching...");
                Hashtable AllLocations = this.trieFile.GetAllLocations(Utils.ConvertArraylistToStringArray(CurrPeptides));
                int p = 0;
                while (p < CurrPeptides.size()) {
                    CurrPeptide = (String)CurrPeptides.get(p);
                    ArrayList P = new ArrayList();
                    ArrayList Locations = (ArrayList)AllLocations.get(CurrPeptide);
                    HashSet pNames = null;
                    pNames = this.Peptide2Protein.containsKey(CurrPeptide) ? (HashSet)this.Peptide2Protein.get(CurrPeptide) : new HashSet();
                    if (Locations == null || Locations.size() == 0) {
                        pNames.add("XXX.tempProtein");
                    } else {
                        int l = 0;
                        while (l < Locations.size()) {
                            Object[] Loc = (Object[])Locations.get(l);
                            String ProteinName = TrieDB.getProteinNameFromFull((String)Loc[3]);
                            pNames.add(ProteinName);
                            ++l;
                        }
                    }
                    this.Peptide2Protein.put(CurrPeptide, pNames);
                    ++p;
                }
                CurrPeptides.clear();
            }
            try {
                line = buf.readLine();
            }
            catch (IOException E) {
                E.printStackTrace();
                System.exit(-1);
            }
        }
        try {
            buf.close();
        }
        catch (IOException E) {
            E.printStackTrace();
            System.exit(-1);
        }
        if (CurrPeptides.size() > 0) {
            System.out.println("Loaded " + CurrPeptides.size() + " peptides, searching...");
            Hashtable AllLocations = this.trieFile.GetAllLocations(Utils.ConvertArraylistToStringArray(CurrPeptides));
            int p = 0;
            while (p < CurrPeptides.size()) {
                CurrPeptide = (String)CurrPeptides.get(p);
                ArrayList P = new ArrayList();
                ArrayList Locations = (ArrayList)AllLocations.get(CurrPeptide);
                HashSet pNames = null;
                pNames = this.Peptide2Protein.containsKey(CurrPeptide) ? (HashSet)this.Peptide2Protein.get(CurrPeptide) : new HashSet();
                if (Locations == null || Locations.size() == 0) {
                    pNames.add("XXX.tempProtein");
                } else {
                    int l = 0;
                    while (l < Locations.size()) {
                        Object[] Loc = (Object[])Locations.get(l);
                        String ProteinName = TrieDB.getProteinNameFromFull((String)Loc[3]);
                        pNames.add(ProteinName);
                        ++l;
                    }
                }
                this.Peptide2Protein.put(CurrPeptide, pNames);
                ++p;
            }
            CurrPeptides.clear();
        }
        try {
            buf.close();
        }
        catch (IOException E) {
            E.printStackTrace();
            System.exit(-1);
        }
        this.writeResults(fileName);
    }
}

