/*
 * Decompiled with CFR 0.152.
 */
package maizeUtils;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import proteogenomicUtils.ProteogenomicUtils;
import trieUtils.TrieDB;

public class MaizeUtils {
    public static int[] ZeaMaysChromosomeSizes;
    public static String[] chrNames;

    static {
        int[] nArray = new int[14];
        nArray[1] = 300239041;
        nArray[2] = 234752839;
        nArray[3] = 230558137;
        nArray[4] = 247095508;
        nArray[5] = 216915529;
        nArray[6] = 169254300;
        nArray[7] = 170974187;
        nArray[8] = 174515299;
        nArray[9] = 152350485;
        nArray[10] = 149686045;
        nArray[11] = 7140151;
        nArray[12] = 569630;
        nArray[13] = 140384;
        ZeaMaysChromosomeSizes = nArray;
        chrNames = new String[]{"chr1", "chr2", "chr3", "chr4", "chr5", "chr6", "chr7", "chr8", "chr9", "chr10", "chrunknown", "chrm", "chrc"};
    }

    public static Hashtable loadTranscriptInfoIntoHash(String filename) {
        Hashtable<String, String[]> ret = new Hashtable<String, String[]>();
        BufferedReader buf = null;
        String line = null;
        try {
            buf = new BufferedReader(new FileReader(filename));
            line = buf.readLine();
        }
        catch (IOException E) {
            E.printStackTrace();
            System.exit(-1);
        }
        int lineNum = 0;
        while (line != null) {
            if ((line = line.trim()).length() == 0 || line.charAt(0) == '#' || lineNum == 0) {
                try {
                    line = buf.readLine();
                }
                catch (IOException E) {
                    E.printStackTrace();
                    System.exit(-1);
                }
                ++lineNum;
                continue;
            }
            String[] bits = line.split("\t");
            String[] newInfo = new String[]{bits[10], bits[11], bits[12], bits[13]};
            ret.put(bits[2], newInfo);
            try {
                line = buf.readLine();
            }
            catch (IOException E) {
                E.printStackTrace();
                System.exit(-1);
            }
            ++lineNum;
        }
        try {
            buf.close();
        }
        catch (IOException E) {
            E.printStackTrace();
            System.exit(-1);
        }
        return ret;
    }

    public static String getMaizeGeneName(String protName) {
        protName = protName.split(" ")[0];
        boolean isDecoy = false;
        if (protName.substring(0, 3).equals("XXX")) {
            isDecoy = true;
            protName = protName.substring(4);
        }
        if (isDecoy) {
            System.out.println("Attempting to get gene name from XXX." + protName);
        }
        if (protName.substring(0, 4).equals("GRMZ") || protName.substring(8).equals("XXX.GRMZ")) {
            if (isDecoy) {
                System.out.println("Matches XXX.GRMZ!!! returning " + protName.split("_")[0]);
                return "XXX." + protName.split("_")[0];
            }
            return protName.split("_")[0];
        }
        if (protName.substring(0, 2).equals("AC") || protName.substring(0, 2).equals("EF") || protName.substring(0, 2).equals("AF") || protName.substring(0, 2).equals("AY")) {
            String[] bits = protName.split("_");
            if (isDecoy) {
                return "XXX." + bits[0] + "_" + bits[1].substring(0, 2) + bits[1].substring(3);
            }
            return String.valueOf(bits[0]) + "_" + bits[1].substring(0, 2) + bits[1].substring(3);
        }
        System.err.println("WARNING:getMaizeGeneName:Unrecognized protein name '" + protName + "'");
        return protName;
    }

    private void countGenes(ArrayList FinalProteinList, TrieDB Proteome) {
        Hashtable<String, Integer> geneList = new Hashtable<String, Integer>();
        int i = 0;
        while (i < FinalProteinList.size()) {
            int protID = (Integer)FinalProteinList.get(i);
            String protName = Proteome.getProteinName(protID).split(" ")[0];
            String geneName = MaizeUtils.getMaizeGeneName(protName);
            int protCount = 0;
            if (geneList.containsKey(geneName)) {
                protCount = (Integer)geneList.get(geneName);
            }
            geneList.put(geneName, new Integer(++protCount));
            ++i;
        }
        Enumeration e = geneList.keys();
        double sum = 0.0;
        int maxCount = 0;
        int minCount = Integer.MAX_VALUE;
        while (e.hasMoreElements()) {
            String geneName = (String)e.nextElement();
            int count = (Integer)geneList.get(geneName);
            if (count > maxCount) {
                maxCount = count;
            }
            if (count < minCount) {
                minCount = count;
            }
            sum += (double)count;
            if (count <= 1) continue;
            System.out.println(String.valueOf(geneName) + " " + count);
        }
        System.out.println("Total genes: " + geneList.size());
        System.out.println("Avg proteins/genes: " + (sum /= (double)geneList.size()));
        System.out.println("Max proteins/genes: " + maxCount);
        System.out.println("Min proteins/genes: " + minCount);
    }

    public static Hashtable loadProteinFile2GeneHash(String fileName) {
        BufferedReader buf = null;
        String line = null;
        try {
            buf = new BufferedReader(new FileReader(fileName));
            line = buf.readLine();
        }
        catch (IOException E) {
            E.printStackTrace();
            return null;
        }
        Hashtable<String, Integer> ret = new Hashtable<String, Integer>();
        while (line != null) {
            if ((line = line.trim()).length() == 0 || line.charAt(0) == '#') {
                try {
                    line = buf.readLine();
                    continue;
                }
                catch (IOException E) {
                    E.printStackTrace();
                    return null;
                }
            }
            String[] bits = line.split("\t");
            String proteinName = bits[0];
            String geneName = MaizeUtils.getMaizeGeneName(proteinName);
            ret.put(geneName, new Integer(1));
            try {
                line = buf.readLine();
            }
            catch (IOException E) {
                E.printStackTrace();
                return null;
            }
        }
        try {
            buf.close();
        }
        catch (IOException E) {
            E.printStackTrace();
            return null;
        }
        return ret;
    }

    public static void main(String[] args) {
        System.out.println("Loads a novel event file, and adds the locus name if there is one");
        System.out.println("Novel event file: " + args[0]);
        System.out.println("Updated file: " + args[1]);
        BufferedReader buf = null;
        OutputStreamWriter f = null;
        String line = null;
        Hashtable geneInfo = null;
        if (args.length >= 3) {
            geneInfo = MaizeUtils.loadTranscriptInfoIntoHash(args[2]);
        }
        try {
            buf = new BufferedReader(new FileReader(args[0]));
            f = new FileWriter(args[1]);
            line = buf.readLine();
        }
        catch (IOException E) {
            E.printStackTrace();
            System.exit(-1);
        }
        while (line != null) {
            if ((line = line.trim()).length() == 0 || line.charAt(0) == '#') {
                try {
                    f.write(String.valueOf(line) + "\n");
                    line = buf.readLine();
                }
                catch (IOException E) {
                    E.printStackTrace();
                    System.exit(-1);
                }
                continue;
            }
            String[] bits = line.split("\t");
            String newLine = null;
            if (bits[0].indexOf("chr") == 0) {
                newLine = line;
            } else {
                String locusName = MaizeUtils.getMaizeGeneName(bits[0]);
                newLine = String.valueOf(locusName) + "\t" + line;
                if (geneInfo != null && geneInfo.containsKey(bits[0])) {
                    String[] info = (String[])geneInfo.get(bits[0]);
                    int i = 0;
                    while (i < info.length) {
                        newLine = String.valueOf(newLine) + "\t" + info[i];
                        ++i;
                    }
                }
            }
            try {
                f.write(String.valueOf(newLine) + "\n");
                line = buf.readLine();
            }
            catch (IOException E) {
                E.printStackTrace();
                System.exit(-1);
            }
        }
        try {
            buf.close();
            f.close();
        }
        catch (IOException E) {
            E.printStackTrace();
            System.exit(-1);
        }
    }

    public static int countLocii(ArrayList proteinNames) {
        if (proteinNames == null || proteinNames.size() == 0) {
            return 0;
        }
        HashSet<String> locii = new HashSet<String>();
        int i = 0;
        while (i < proteinNames.size()) {
            String protName = (String)proteinNames.get(i);
            String locusName = MaizeUtils.getMaizeGeneName(protName);
            locii.add(locusName);
            ++i;
        }
        return locii.size();
    }

    public static String getMaizeProteinNameFromTranscript(String refinedFeature) {
        boolean debug = false;
        refinedFeature = refinedFeature.split(" ")[0];
        boolean isDecoy = false;
        if (refinedFeature.toLowerCase().substring(0, 3).equals("xxx")) {
            isDecoy = true;
            refinedFeature = refinedFeature.substring(4);
        }
        if (refinedFeature.toLowerCase().substring(0, 4).equals("grmz")) {
            String[] bits = refinedFeature.split("_");
            if (debug) {
                System.out.println(String.valueOf(refinedFeature) + "->" + bits[0] + "_P" + bits[1].substring(1));
            }
            if (isDecoy) {
                return "XXX." + bits[0] + "_P" + bits[1].substring(1);
            }
            return String.valueOf(bits[0]) + "_P" + bits[1].substring(1);
        }
        if (refinedFeature.toUpperCase().substring(0, 2).equals("AC") || refinedFeature.toUpperCase().substring(0, 2).equals("EF") || refinedFeature.toUpperCase().substring(0, 2).equals("AF") || refinedFeature.toUpperCase().substring(0, 2).equals("AY")) {
            String[] bits = refinedFeature.split("_");
            if (debug) {
                System.out.println(String.valueOf(refinedFeature) + "->" + bits[0] + "_" + bits[1].substring(0, 2) + "P" + bits[1].substring(3));
            }
            if (isDecoy) {
                return "XXX." + bits[0] + "_" + bits[1].substring(0, 2) + "P" + bits[1].substring(3);
            }
            return String.valueOf(bits[0]) + "_" + bits[1].substring(0, 2) + "P" + bits[1].substring(3);
        }
        System.err.println("ERROR:getMaizeProteinNameFromTranscript:Unrecognized protein name '" + refinedFeature + "'");
        if (isDecoy) {
            return "XXX." + refinedFeature;
        }
        return refinedFeature;
    }

    public static String getMaizeTranscriptNameFromProtein(String refinedFeature) {
        boolean debug = false;
        refinedFeature = refinedFeature.split(" ")[0];
        boolean isDecoy = false;
        if (refinedFeature.substring(0, 3).equals("XXX")) {
            isDecoy = true;
            refinedFeature = refinedFeature.substring(4);
        }
        if (refinedFeature.substring(0, 4).equalsIgnoreCase("GRMZ")) {
            String[] bits = refinedFeature.split("_");
            if (debug) {
                System.out.println(String.valueOf(refinedFeature) + "->" + bits[0] + "_T" + bits[1].substring(1));
            }
            if (isDecoy) {
                return "XXX." + bits[0] + "_T" + bits[1].substring(1);
            }
            return String.valueOf(bits[0]) + "_T" + bits[1].substring(1);
        }
        if (refinedFeature.substring(0, 2).equalsIgnoreCase("AC") || refinedFeature.substring(0, 2).equalsIgnoreCase("EF") || refinedFeature.substring(0, 2).equalsIgnoreCase("AF") || refinedFeature.substring(0, 2).equalsIgnoreCase("AY")) {
            String[] bits = refinedFeature.split("_");
            if (isDecoy) {
                return "XXX." + bits[0] + "_" + bits[1].substring(0, 2) + "T" + bits[1].substring(3);
            }
            return String.valueOf(bits[0]) + "_" + bits[1].substring(0, 2) + "T" + bits[1].substring(3);
        }
        System.err.println("ERROR:getMaizeTranscriptNameFromProtein:Unrecognized protein name '" + refinedFeature + "'");
        if (isDecoy) {
            return "XXX." + refinedFeature;
        }
        return refinedFeature;
    }

    public static HashSet getTranscriptNamesFromProteinNames(HashSet workingNames) {
        HashSet<String> ret = new HashSet<String>();
        for (String pName : workingNames) {
            String tName = MaizeUtils.getMaizeTranscriptNameFromProtein(pName).toLowerCase();
            ret.add(tName);
        }
        return ret;
    }

    public static ProteogenomicUtils.uniqueType getUniquenessType(HashSet pNames) {
        if (pNames.size() == 1) {
            return ProteogenomicUtils.uniqueType.PROT_UNIQUE;
        }
        HashSet<String> locii = new HashSet<String>();
        for (String protName : pNames) {
            String locusName = MaizeUtils.getMaizeGeneName(protName);
            locii.add(locusName);
        }
        if (locii.size() == 1) {
            return ProteogenomicUtils.uniqueType.LOC_UNIQUE;
        }
        return ProteogenomicUtils.uniqueType.SHARED;
    }

    public static ProteogenomicUtils.uniqueType getUniquenessType(ArrayList currLocs) {
        boolean debug = false;
        if (currLocs.size() == 1) {
            if (debug) {
                System.out.println("This peptide only has 1 locations, so it is prot_unique");
            }
            return ProteogenomicUtils.uniqueType.PROT_UNIQUE;
        }
        HashSet<String> locii = new HashSet<String>();
        int i = 0;
        while (i < currLocs.size()) {
            Object[] currLoc = (Object[])currLocs.get(i);
            String protName = (String)currLoc[3];
            String locusName = MaizeUtils.getMaizeGeneName(protName);
            if (debug) {
                System.out.println("[" + i + "]: " + protName + "-> " + locusName);
            }
            locii.add(locusName);
            ++i;
        }
        if (locii.size() == 1) {
            if (debug) {
                System.out.println("THis peptide only has 1 locus, so it is loc_unique");
            }
            return ProteogenomicUtils.uniqueType.LOC_UNIQUE;
        }
        if (debug) {
            System.out.println("This peptide is shared between several locii, so it is shared");
        }
        return ProteogenomicUtils.uniqueType.SHARED;
    }
}

