/*
 * Decompiled with CFR 0.152.
 */
package maizeUtils;

import basicUtils.GFFFile;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import proteogenomicUtils.GenomicLocator;

public class NovelClusterGroupAnalyzer {
    public NovelClusterGroup[] loadNovelClusterGroupsFromFile(String fileName) {
        BufferedReader buf = null;
        String line = null;
        try {
            buf = new BufferedReader(new FileReader(fileName));
            line = buf.readLine();
        }
        catch (IOException E) {
            E.printStackTrace();
            return null;
        }
        ArrayList<NovelClusterGroup> tempClusterGroups = new ArrayList<NovelClusterGroup>();
        NovelClusterGroup currGroup = null;
        while (line != null) {
            if ((line = line.trim()).length() == 0) {
                try {
                    line = buf.readLine();
                    continue;
                }
                catch (IOException E) {
                    E.printStackTrace();
                    return null;
                }
            }
            if (line.charAt(0) == '#') {
                if (currGroup != null) {
                    currGroup.PopulateValuesFromClusters();
                    tempClusterGroups.add(currGroup);
                }
                currGroup = new NovelClusterGroup();
            } else {
                String[] els = line.split("\t");
                int clusterID = Integer.parseInt(els[0]);
                ArrayList currCluster = null;
                currCluster = clusterID >= currGroup.clusters.size() ? new ArrayList() : (ArrayList)currGroup.clusters.get(clusterID);
                String subString = line.substring(2);
                Object[] loc = GenomicLocator.GenomicColumns.LoadFromString(subString);
                currCluster.add(loc);
                currGroup.clusters.add(clusterID, currCluster);
            }
            try {
                line = buf.readLine();
            }
            catch (IOException E) {
                E.printStackTrace();
                return null;
            }
        }
        try {
            buf.close();
        }
        catch (IOException E) {
            E.printStackTrace();
            return null;
        }
        NovelClusterGroup[] ret = new NovelClusterGroup[tempClusterGroups.size()];
        int i = 0;
        while (i < ret.length) {
            ret[i] = (NovelClusterGroup)tempClusterGroups.get(i);
            ++i;
        }
        return ret;
    }

    public NovelClusterGroup[] populateNearestFeature(NovelClusterGroup[] groups, String featureGFFFile, String featureType) {
        String[] geneGFFLines = GFFFile.loadFeatureLines(featureGFFFile, featureType);
        return groups;
    }

    public class NovelClusterGroup {
        ArrayList peptideSeqs;
        ArrayList clusters = new ArrayList();
        int[][] nearestGenes;
        int[][] clusterSpans;

        public NovelClusterGroup() {
            this.peptideSeqs = new ArrayList();
        }

        public void PopulateValuesFromClusters() {
            this.nearestGenes = new int[this.clusters.size()][2];
            this.clusterSpans = new int[this.clusters.size()][2];
            int i = 0;
            while (i < this.clusters.size()) {
                ArrayList currCluster = (ArrayList)this.clusters.get(i);
                this.nearestGenes[i][0] = -1;
                this.nearestGenes[i][1] = Integer.MAX_VALUE;
                this.clusterSpans[i][0] = Integer.MAX_VALUE;
                this.clusterSpans[i][1] = Integer.MIN_VALUE;
                int j = 0;
                while (j < currCluster.size()) {
                    Object[] currLoc = (Object[])currCluster.get(j);
                    String peptide = (String)currLoc[GenomicLocator.GenomicColumns.Peptide];
                    int start = (Integer)currLoc[GenomicLocator.GenomicColumns.Start];
                    int end = (Integer)currLoc[GenomicLocator.GenomicColumns.End];
                    if (start < this.clusterSpans[i][0]) {
                        this.clusterSpans[i][0] = start;
                    }
                    if (end > this.clusterSpans[i][1]) {
                        this.clusterSpans[i][1] = end;
                    }
                    if (!this.peptideSeqs.contains(peptide)) {
                        this.peptideSeqs.add(peptide);
                    }
                    ++j;
                }
                ++i;
            }
        }
    }
}

