/*
 * Decompiled with CFR 0.152.
 */
package maizeUtils;

import basicUtils.InspectAnnotation;
import basicUtils.Utils;
import java.util.Hashtable;

public class SpectrumMillVersusInspectCounter {
    public static String UsageInfo = "maizeUtils.SpectrumMillVersusInspectCounter version 03.20.2011\nCompares the results (Jack Format) of merged and filtered results from SpectrumMill and Inspect.  Counts\nThe number of spectra and peptides shared and distinct\n[REQUIRED]:\n-r [FILE/DIR] Directory of Jack formated files\n";
    private String[] spectrumFiles;

    public SpectrumMillVersusInspectCounter(String inputDir) {
        if (Utils.IsFile(inputDir)) {
            this.spectrumFiles = new String[1];
            this.spectrumFiles[0] = inputDir;
        } else if (Utils.IsDir(inputDir)) {
            this.spectrumFiles = Utils.ListDir(inputDir);
        } else {
            System.err.println("ERROR: Invalid input file/directory '" + inputDir + "'!");
            System.exit(-1);
        }
    }

    public static void main(String[] args) {
        String[] options = new String[]{"-r"};
        boolean[] values = new boolean[]{true};
        Hashtable CommandLineArgs = Utils.ParseCommandLine(args, options, values);
        if (!CommandLineArgs.containsKey("-r")) {
            System.err.println("ERROR: Missing required arguments!");
            System.err.println(UsageInfo);
            System.exit(0);
        }
        String inputDir = (String)CommandLineArgs.get("-r");
        SpectrumMillVersusInspectCounter counter = new SpectrumMillVersusInspectCounter(inputDir);
        counter.count();
    }

    /*
     * Unable to fully structure code
     */
    private void count() {
        peptideHash = new Hashtable<String, int[]>();
        totalSpecCounts = new int[]{0, 0};
        i = 0;
        while (i < this.spectrumFiles.length) {
            System.out.println("Loading annotations from " + this.spectrumFiles[i]);
            anns = InspectAnnotation.LoadInspectResultsFile(this.spectrumFiles[i]);
            j = 0;
            while (j < anns.length) {
                block8: {
                    currPeptide = Utils.GetUnModded(anns[j].Annotation);
                    if (currPeptide.indexOf(46) >= 0) {
                        currPeptide = currPeptide.substring(2, currPeptide.length() - 2);
                    }
                    specCounts = null;
                    specCounts = peptideHash.containsKey(currPeptide) != false ? (int[])peptideHash.get(currPeptide) : new int[]{0, 0};
                    if (!anns[j].SourceProgram.equals("Inspect")) break block8;
                    specCounts[0] = specCounts[0] + 1;
                    totalSpecCounts[0] = totalSpecCounts[0] + 1;
                    ** GOTO lbl24
                }
                if (!anns[j].SourceProgram.equals("SpectrumMill")) {
                    System.err.println("ERROR: Unexpected source program '" + anns[j].SourceProgram);
                } else {
                    specCounts[1] = specCounts[1] + 1;
                    totalSpecCounts[1] = totalSpecCounts[1] + 1;
lbl24:
                    // 2 sources

                    peptideHash.put(currPeptide, specCounts);
                }
                ++j;
            }
            ++i;
        }
        System.out.println("Spectrum Counts");
        System.out.println("  - total: " + (totalSpecCounts[0] + totalSpecCounts[1]));
        System.out.println("  - Inspect: " + totalSpecCounts[0]);
        System.out.println("  - SpectrumMill: " + totalSpecCounts[1]);
        System.out.println("Peptide Counts");
        System.out.println("  - total: " + peptideHash.size());
        sharedPeptides = 0;
        InspectPeptides = 0;
        SpectrumMillPeptides = 0;
        peps = peptideHash.keys();
        while (peps.hasMoreElements()) {
            currPep = (String)peps.nextElement();
            counts = (int[])peptideHash.get(currPep);
            if (counts[0] == 0) {
                ++SpectrumMillPeptides;
                continue;
            }
            if (counts[1] == 0) {
                ++InspectPeptides;
                continue;
            }
            ++sharedPeptides;
        }
        System.out.println("  - Inspect: " + InspectPeptides);
        System.out.println("  - SpectrumMill: " + SpectrumMillPeptides);
        System.out.println("  - Shared: " + sharedPeptides);
    }
}

