/*
 * Decompiled with CFR 0.152.
 */
package ms2dbUtils;

import basicUtils.ProteoDB;
import basicUtils.Utils;
import java.io.DataOutputStream;
import java.io.File;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import ms2dbUtils.ConstructSpliceGraph;
import ms2dbUtils.ConstructSpliceGraphWithInDel;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ParseSpliceGraph
extends ProteoDB {
    public static final int MS2DB_RECORD_SIZE = 92;
    DataOutputStream OutFile = null;

    public ParseSpliceGraph(String DatabaseName) {
        this.DBFileName = DatabaseName;
    }

    @Override
    public Hashtable GetAllLocations(String[] Peptides) {
        Hashtable Locations = new Hashtable();
        return Locations;
    }

    public void ParseBuildMS2DB(ConstructSpliceGraph parent_builder, int ParseForwardFlag, Hashtable ExonHash) {
        SAXParserFactory ParserFactory = SAXParserFactory.newInstance();
        MS2DBContentHandler MS2DBHandler = new MS2DBContentHandler(parent_builder, this, 1, ParseForwardFlag);
        try {
            SAXParser Parser2 = ParserFactory.newSAXParser();
            Parser2.parse(new File(this.DBFileName), (DefaultHandler)MS2DBHandler);
        }
        catch (Exception E) {
            E.printStackTrace();
            return;
        }
    }

    public void ParseBuildMS2DB(ConstructSpliceGraphWithInDel parent_builder, int ParseForwardFlag, Hashtable ExonHash) {
        SAXParserFactory ParserFactory = SAXParserFactory.newInstance();
        MS2DBContentHandler MS2DBHandler = new MS2DBContentHandler(parent_builder, this, 1, ParseForwardFlag);
        try {
            SAXParser Parser2 = ParserFactory.newSAXParser();
            Parser2.parse(new File(this.DBFileName), (DefaultHandler)MS2DBHandler);
        }
        catch (Exception E) {
            E.printStackTrace();
            return;
        }
    }

    public static void main(String[] args) {
    }

    public class MS2DBContentHandler
    extends DefaultHandler {
        private ConstructSpliceGraph ParentBuilder;
        private ConstructSpliceGraphWithInDel ParentBuilderWithInDel;
        public static final int NONE = 0;
        public static final int DATABASE = 1;
        public static final int GENE = 2;
        public static final int EXON = 3;
        public static final int EXONEXTENDS = 5;
        public static final int EXONLINKFROM = 6;
        public static final int GENECROSSREFERNCE = 7;
        public static final int ERROR = -1;
        public static final int PARSE_MODE = 1;
        public int Mode = 0;
        public int RunMode = 0;
        public int ParseForwardFlag = -1;
        public ParseSpliceGraph Parent = null;
        public boolean LocalDebug = false;

        public MS2DBContentHandler(ConstructSpliceGraph parent_builder, ParseSpliceGraph Parent, int Mode, int ParseForwardFlag) {
            this.ParentBuilder = parent_builder;
            this.Parent = Parent;
            this.RunMode = Mode;
            this.ParseForwardFlag = ParseForwardFlag;
        }

        public MS2DBContentHandler(ConstructSpliceGraphWithInDel parent_builder, ParseSpliceGraph Parent, int Mode, int ParseForwardFlag) {
            this.ParentBuilderWithInDel = parent_builder;
            this.Parent = Parent;
            this.RunMode = Mode;
            this.ParseForwardFlag = ParseForwardFlag;
        }

        @Override
        public void endElement(String uri, String localName, String name) throws SAXException {
            if (this.Mode == -1) {
                if (this.LocalDebug) {
                    System.out.println("Skipping due to ERROR mode!!");
                }
                return;
            }
            if (name.compareTo("Gene") == 0) {
                this.ParentBuilder.CurrMS2GeneForParsing = null;
            }
            if (name.compareTo("Exon") == 0) {
                this.ParentBuilder.CurrMS2ExonForParsing = null;
            }
        }

        @Override
        public void startElement(String uri, String localName, String name, Attributes atts) throws SAXException {
            if (this.Mode == -1) {
                if (this.LocalDebug) {
                    System.out.println("Skipping due to ERROR mode!!");
                }
                return;
            }
            if (name.compareTo("Database") == 0) {
                this.Mode = 1;
            } else if (name.compareTo("Gene") == 0) {
                this.Mode = 2;
                String GeneName = atts.getValue("Name");
                if (GeneName == null) {
                    System.err.println("ERROR: Cannot find attribute 'Name' in start of Element Gene");
                    this.Mode = -1;
                    return;
                }
                String Strand = atts.getValue("ForwardFlag");
                if (Strand == null) {
                    System.err.println("ERROR: Cannot find attribute 'ForwardFlag' in start of Element Gene");
                    this.Mode = -1;
                    return;
                }
                String SeqName = atts.getValue("Chromosome");
                if (SeqName == null) {
                    System.err.println("ERROR: Cannot find attribute 'Chromosome' in start of Element Gene");
                    this.Mode = -1;
                    return;
                }
                if (this.LocalDebug) {
                    System.out.println("SequenceName: " + this.ParentBuilder.CurrMS2GeneForParsing.SequenceName);
                }
                if (this.ParseForwardFlag == Integer.parseInt(Strand)) {
                    ConstructSpliceGraph.GFFGeneClass GFFGene;
                    if (this.LocalDebug) {
                        System.out.println("Creating a new GFF Gene: " + GeneName + " on " + SeqName);
                    }
                    String tmpFilename = new File(this.ParentBuilder.UpdateMS2DBFile).getName();
                    this.ParentBuilder.CurrentGene = GFFGene = this.ParentBuilder.CreateGFFGene(GeneName, SeqName, Integer.parseInt(Strand), tmpFilename);
                    if (this.ParentBuilder.FirstGFFGene == null) {
                        this.ParentBuilder.FirstGFFGene = GFFGene;
                    } else {
                        this.ParentBuilder.LastGFFGene.Next = GFFGene;
                    }
                    this.ParentBuilder.LastGFFGene = GFFGene;
                    this.ParentBuilder.PrevExon = null;
                    this.ParentBuilder.CurrMS2GeneForParsing = this.ParentBuilder.NewMS2Gene();
                } else {
                    this.ParentBuilder.CurrMS2GeneForParsing = null;
                }
            } else if (name.compareTo("Exon") == 0 && this.ParentBuilder.CurrMS2GeneForParsing != null) {
                this.Mode = 3;
                String[] Names = new String[]{"Index", "Start", "End"};
                int[] Values = new int[Names.length];
                int i = 0;
                while (i < Values.length) {
                    String Temp = atts.getValue(Names[i]);
                    if (Temp == null) {
                        System.err.println("ERROR: Cannot find attribute '" + Names[i] + "' in start of Element Exon");
                        if (this.LocalDebug) {
                            Utils.WaitForEnter();
                        }
                        this.Mode = -1;
                        return;
                    }
                    Values[i] = Integer.parseInt(Temp);
                    ++i;
                }
                ConstructSpliceGraph.GFFExonClass GFFExon = this.ParentBuilder.ConstructGFFExon(Values[1], Values[2], this.ParentBuilder.CurrentGene.SequenceName, Values[0]);
                this.ParentBuilder.CurrentGene.GFFExons.add(GFFExon);
                this.ParentBuilder.CurrMS2ExonForParsing = this.ParentBuilder.HashExon(Values[1], Values[2], this.ParentBuilder.CurrentGene.SequenceName, this.ParentBuilder.CurrentGene.Strand, Values[0]);
                this.ParentBuilder.CurrMS2GeneForParsing.Exons.add(this.ParentBuilder.CurrMS2ExonForParsing);
            } else if (name.compareTo("LinkFrom") == 0 && this.ParentBuilder.CurrMS2GeneForParsing != null) {
                String Temp = atts.getValue("Index");
                if (Temp == null) {
                    System.err.println("ERROR: Cannot find attribute 'Index' in start of Element LinkFrom");
                    this.Mode = -1;
                    return;
                }
                int LinkFromIndex = Integer.parseInt(Temp);
                ArrayList Exons = this.ParentBuilder.CurrMS2GeneForParsing.Exons;
                int i = 0;
                while (i < Exons.size()) {
                    ConstructSpliceGraph.MS2Exon Exon = (ConstructSpliceGraph.MS2Exon)Exons.get(i);
                    if (Exon.Index == LinkFromIndex) {
                        if (this.ParseForwardFlag == 1) {
                            Exon.LinkExonForward(this.ParentBuilder.CurrMS2ExonForParsing);
                            break;
                        }
                        this.ParentBuilder.CurrMS2ExonForParsing.LinkExonForward(Exon);
                        break;
                    }
                    ++i;
                }
                this.Mode = 6;
            }
        }
    }

    public static class MS2DBLocationColumns {
        public static final int Peptide = 0;
        public static final int Start = 1;
        public static final int End = 2;
        public static final int SplicedAAString = 3;
        public static final int SpliceString = 4;
        public static final int SequenceName = 5;
        public static final int GeneName = 6;
        public static final int ForwardFlag = 7;
    }
}

