/*
 * Decompiled with CFR 0.152.
 */
package mutationMode;

import basicUtils.Utils;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;

public class AnalyzeMissedPeptides {
    private static final double HAMMING_THRESHOLD = 0.1;
    private static final double CORRECT_PRM_THRESHOLD = 0.6;
    private static final double MISSED_PRM_THRESHOLD = 0.25;
    public static String usageInfo = "mutationMode.AnalyzeMissedPeptides\nUsage: java -jar AnalyzeMissedPeptides.jar\n-r [FILE] Missed peptide file produced by ValidateMutationResults\n-t [FILE/DIR] Tag file for the spectra\n(-f Only look at the best peptide per spectrum)\n(-o [FILE] output file)\n";
    private String inputFileName;
    private String[] tagFileNames;
    private boolean lookAtBestPeptideOnly = false;
    private String outputFileName = null;

    public AnalyzeMissedPeptides(String inputFileName, String tagFileName, boolean firstPeptideOnly, String outputFileName) {
        if (!Utils.IsFile(inputFileName)) {
            System.err.println("ERROR: Invalid input file name '" + inputFileName + "'");
            System.exit(-1);
        }
        if (Utils.IsDir(tagFileName)) {
            this.tagFileNames = Utils.ListDir(tagFileName);
        } else if (Utils.IsFile(tagFileName)) {
            this.tagFileNames = new String[1];
            this.tagFileNames[0] = tagFileName;
        } else {
            System.err.println("ERROR: Invalid tag file name '" + tagFileName + "'");
            System.exit(-1);
        }
        this.inputFileName = inputFileName;
        this.lookAtBestPeptideOnly = firstPeptideOnly;
        this.outputFileName = outputFileName;
    }

    public static void main(String[] args) {
        String[] options = new String[]{"-r", "-t", "-f", "-o"};
        boolean[] blArray = new boolean[4];
        blArray[0] = true;
        blArray[1] = true;
        blArray[3] = true;
        boolean[] values = blArray;
        Hashtable commandLineArgs = Utils.ParseCommandLine(args, options, values);
        if (!commandLineArgs.containsKey("-r") || !commandLineArgs.containsKey("-t")) {
            System.err.println("ERROR: Must specify an input file and a tag file!");
            System.err.println(usageInfo);
            System.exit(0);
        }
        String inputFileName = (String)commandLineArgs.get("-r");
        String tagFileName = (String)commandLineArgs.get("-t");
        boolean firstPeptideOnly = false;
        if (commandLineArgs.containsKey("-f")) {
            firstPeptideOnly = true;
        }
        String outputFileName = null;
        if (commandLineArgs.containsKey("-o")) {
            outputFileName = (String)commandLineArgs.get("-o");
        }
        AnalyzeMissedPeptides p = new AnalyzeMissedPeptides(inputFileName, tagFileName, firstPeptideOnly, outputFileName);
        p.analyze();
    }

    private void analyze() {
        boolean debug = false;
        Hashtable<String, double[]> currResults = new Hashtable<String, double[]>();
        double[] totalInfo = new double[7];
        Hashtable<String, Object[]> wildPeptides = new Hashtable<String, Object[]>();
        BufferedReader buf = null;
        String line = null;
        try {
            buf = new BufferedReader(new FileReader(this.inputFileName));
            line = buf.readLine();
        }
        catch (IOException E) {
            System.err.println("ERROR:analyze:" + E.getLocalizedMessage());
            System.exit(-1);
        }
        int psmsLeft = 0;
        int psmsTotal = 0;
        String currHashKey = null;
        String correctPeptide = null;
        double correctScore = -10.0;
        String[] DBpeptides = null;
        double[] DBpeptideDeltas = null;
        ArrayList<String[]> guys = new ArrayList<String[]>();
        while (line != null) {
            if ((line = line.trim()).length() == 0 || line.charAt(0) == '#') {
                try {
                    line = buf.readLine();
                }
                catch (IOException E) {
                    System.err.println("ERROR:analyze:" + E.getLocalizedMessage());
                    System.exit(-1);
                }
                continue;
            }
            String[] bits = line.split("\t");
            if (bits.length < 7) {
                try {
                    line = buf.readLine();
                }
                catch (IOException E) {
                    System.err.println("ERROR:analyze:" + E.getLocalizedMessage());
                    System.exit(-1);
                }
                continue;
            }
            if (psmsLeft == 0) {
                if (guys.size() > 0) {
                    double[] scanInfo = new double[7];
                    if (debug) {
                        System.out.println("Considering PMS for " + currHashKey + ":" + correctPeptide);
                    }
                    int psm = 0;
                    while (psm < guys.size()) {
                        double psmScore;
                        String[] psmInfo = (String[])guys.get(psm);
                        String guessedPeptide = psmInfo[1];
                        if (guessedPeptide.charAt(1) == '.') {
                            guessedPeptide = guessedPeptide.substring(2, guessedPeptide.length() - 2);
                        }
                        if ((psmScore = Double.parseDouble(psmInfo[2])) > correctScore) {
                            if (debug) {
                                System.out.println("psm[" + psm + "]: score is better! " + psmScore + " > " + correctScore);
                            }
                            scanInfo[0] = scanInfo[0] + 1.0;
                        } else if (psmInfo[3].compareTo(correctPeptide) == 0 && guessedPeptide.length() == correctPeptide.length()) {
                            scanInfo[1] = scanInfo[1] + 1.0;
                            double observedDelta = Utils.GetSeqMass(psmInfo[1]) - Utils.GetSeqMass(psmInfo[4]);
                            int deltaIndex = 0;
                            if (deltaIndex < DBpeptideDeltas.length && Math.abs(observedDelta - DBpeptideDeltas[deltaIndex]) < Utils.LTQFragTol) {
                                scanInfo[2] = scanInfo[2] + 1.0;
                                int oracleIndex = AnalyzeMissedPeptides.findMutationIndex(correctPeptide, DBpeptides[deltaIndex]);
                                int mutIndex = AnalyzeMissedPeptides.findMutationIndex(guessedPeptide, psmInfo[4]);
                                if (mutIndex >= 0) {
                                    scanInfo[3] = scanInfo[3] + (double)Math.abs(mutIndex - oracleIndex);
                                } else {
                                    mutIndex = AnalyzeMissedPeptides.findMutationIndex(guessedPeptide, correctPeptide);
                                    scanInfo[3] = scanInfo[3] + (double)Math.abs(mutIndex - oracleIndex);
                                }
                            }
                        } else if (Double.parseDouble(psmInfo[7]) <= 0.1) {
                            if (debug) {
                                System.out.println("psm[" + psm + "]: db peptide was not intended but has close hamming (" + psmInfo[7] + "), " + psmInfo[1] + "~" + correctPeptide);
                            }
                            scanInfo[0] = scanInfo[0] + 1.0;
                            scanInfo[4] = scanInfo[4] + 1.0;
                        } else if (Double.parseDouble(psmInfo[5]) >= 0.6 && Double.parseDouble(psmInfo[6]) <= 0.25) {
                            if (debug) {
                                System.out.println("psm[" + psm + "]: db peptide was not intended but has good stats (" + psmInfo[5] + " correct PRMs, " + psmInfo[6] + " missed PRMs), " + psmInfo[1] + "~" + correctPeptide);
                            }
                            scanInfo[5] = scanInfo[5] + 1.0;
                        } else {
                            if (debug) {
                                System.out.println("psm[" + psm + "]: db peptide seems to be wild! " + psmInfo[1] + "!=" + correctPeptide);
                            }
                            scanInfo[6] = scanInfo[6] + 1.0;
                            Object[] wildInfo = new Object[]{correctPeptide, DBpeptides};
                            wildPeptides.put(currHashKey, wildInfo);
                        }
                        ++psm;
                    }
                    if (scanInfo[2] > 0.0) {
                        scanInfo[3] = scanInfo[3] / scanInfo[2];
                    }
                    if (debug) {
                        System.out.println("Final info for " + currHashKey);
                        System.out.println("A:#peptides with higher score: " + scanInfo[0]);
                        System.out.println("B:#peptides with correct db location: " + scanInfo[1]);
                        System.out.println("B:#peptides with correct delta: " + scanInfo[2]);
                        System.out.println("B:Avg distance from correct position: " + scanInfo[3]);
                        System.out.println("C:#peptides with close hamming: " + scanInfo[4]);
                        System.out.println("D:#peptides with close stats: " + scanInfo[5]);
                        System.out.println("E:#wild cards: " + scanInfo[6]);
                        Utils.WaitForEnter();
                    }
                    currResults.put(currHashKey, scanInfo);
                    int i = 0;
                    while (i < scanInfo.length) {
                        int n = i;
                        totalInfo[n] = totalInfo[n] + scanInfo[i];
                        ++i;
                    }
                }
                if (debug) {
                    System.out.println(line);
                }
                currHashKey = String.valueOf(Utils.GetBaseName(bits[0])) + "_" + bits[1];
                correctPeptide = bits[2];
                if (correctPeptide.indexOf(".") >= 0) {
                    correctPeptide = correctPeptide.substring(2, correctPeptide.length() - 2);
                }
                correctScore = Double.parseDouble(bits[3]);
                DBpeptides = bits[4].split(",");
                String[] temp = bits[6].split(",");
                DBpeptideDeltas = new double[temp.length - 1];
                int delta = 0;
                while (delta < temp.length - 1) {
                    DBpeptideDeltas[delta] = Double.parseDouble(temp[delta]);
                    ++delta;
                }
                psmsTotal = psmsLeft = Integer.parseInt(bits[7]);
                guys.clear();
            } else if (psmsLeft > 0) {
                if (this.lookAtBestPeptideOnly && psmsLeft == psmsTotal) {
                    guys.add(bits);
                    if (debug) {
                        System.out.println(line);
                    }
                } else if (!this.lookAtBestPeptideOnly) {
                    guys.add(bits);
                    if (debug) {
                        System.out.println(line);
                    }
                }
                --psmsLeft;
            }
            try {
                line = buf.readLine();
            }
            catch (IOException E) {
                System.err.println("ERROR:analyze:" + E.getLocalizedMessage());
                System.exit(-1);
            }
        }
        try {
            buf.close();
        }
        catch (IOException E) {
            System.err.println("ERROR:analyze:" + E.getLocalizedMessage());
            System.exit(-1);
        }
        if (guys.size() > 0) {
            double[] scanInfo = new double[7];
            if (debug) {
                System.out.println("Considering PMS for " + currHashKey + ":" + correctPeptide);
            }
            int psm = 0;
            while (psm < guys.size()) {
                double psmScore;
                String[] psmInfo = (String[])guys.get(psm);
                String guessedPeptide = psmInfo[1];
                if (guessedPeptide.charAt(1) == '.') {
                    guessedPeptide = guessedPeptide.substring(2, guessedPeptide.length() - 2);
                }
                if ((psmScore = Double.parseDouble(psmInfo[2])) > correctScore) {
                    if (debug) {
                        System.out.println("psm[" + psm + "]: score is better! " + psmScore + " > " + correctScore);
                    }
                    scanInfo[0] = scanInfo[0] + 1.0;
                } else if (psmInfo[3].compareTo(correctPeptide) == 0 && guessedPeptide.length() == correctPeptide.length()) {
                    scanInfo[1] = scanInfo[1] + 1.0;
                    double observedDelta = Utils.GetSeqMass(psmInfo[1]) - Utils.GetSeqMass(psmInfo[4]);
                    int deltaIndex = 0;
                    if (deltaIndex < DBpeptideDeltas.length && Math.abs(observedDelta - DBpeptideDeltas[deltaIndex]) < Utils.LTQFragTol) {
                        scanInfo[2] = scanInfo[2] + 1.0;
                        int oracleIndex = AnalyzeMissedPeptides.findMutationIndex(correctPeptide, DBpeptides[deltaIndex]);
                        int mutIndex = AnalyzeMissedPeptides.findMutationIndex(guessedPeptide, psmInfo[4]);
                        if (mutIndex >= 0) {
                            scanInfo[3] = scanInfo[3] + (double)Math.abs(mutIndex - oracleIndex);
                        } else {
                            mutIndex = AnalyzeMissedPeptides.findMutationIndex(guessedPeptide, correctPeptide);
                            scanInfo[3] = scanInfo[3] + (double)Math.abs(mutIndex - oracleIndex);
                        }
                    }
                } else if (Double.parseDouble(psmInfo[7]) <= 0.1) {
                    if (debug) {
                        System.out.println("psm[" + psm + "]: db peptide was not intended but has close hamming (" + psmInfo[7] + "), " + psmInfo[1] + "~" + correctPeptide);
                    }
                    scanInfo[0] = scanInfo[0] + 1.0;
                    scanInfo[4] = scanInfo[4] + 1.0;
                } else if (Double.parseDouble(psmInfo[5]) >= 0.6 && Double.parseDouble(psmInfo[6]) <= 0.25) {
                    if (debug) {
                        System.out.println("psm[" + psm + "]: db peptide was not intended but has good stats (" + psmInfo[5] + " correct PRMs, " + psmInfo[6] + " missed PRMs), " + psmInfo[1] + "~" + correctPeptide);
                    }
                    scanInfo[5] = scanInfo[5] + 1.0;
                } else {
                    if (debug) {
                        System.out.println("psm[" + psm + "]: db peptide seems to be wild! " + psmInfo[1] + "!=" + correctPeptide);
                    }
                    scanInfo[6] = scanInfo[6] + 1.0;
                    Object[] wildInfo = new Object[]{correctPeptide, DBpeptides};
                    wildPeptides.put(currHashKey, wildInfo);
                }
                ++psm;
            }
            if (scanInfo[2] > 0.0) {
                scanInfo[3] = scanInfo[3] / scanInfo[2];
            }
            if (debug) {
                System.out.println("Final info for " + currHashKey);
                System.out.println("A:#peptides with higher score: " + scanInfo[0]);
                System.out.println("B:#peptides with correct db location: " + scanInfo[1]);
                System.out.println("B:#peptides with correct delta: " + scanInfo[2]);
                System.out.println("B:Avg distance from correct position: " + scanInfo[3]);
                System.out.println("C:#peptides with close hamming: " + scanInfo[4]);
                System.out.println("D:#peptides with close stats: " + scanInfo[5]);
                System.out.println("E:#wild cards: " + scanInfo[6]);
                Utils.WaitForEnter();
            }
            currResults.put(currHashKey, scanInfo);
            int i = 0;
            while (i < scanInfo.length) {
                int n = i;
                totalInfo[n] = totalInfo[n] + scanInfo[i];
                ++i;
            }
        }
        System.out.println("Total info:");
        System.out.println("A:#peptides with higher score: " + totalInfo[0]);
        System.out.println("B:#peptides with correct db location: " + totalInfo[1]);
        System.out.println("B:#peptides with correct delta: " + totalInfo[2]);
        System.out.println("B:Avg distance from correct position: " + totalInfo[3]);
        System.out.println("C:#peptides with close hamming: " + totalInfo[4]);
        System.out.println("D:#peptides with close stats: " + totalInfo[5]);
        System.out.println("E:#wild cards: " + totalInfo[6]);
        this.checkWildPeptidesForTags(wildPeptides);
        if (this.outputFileName != null) {
            this.writeResults(currResults);
        }
    }

    private void checkWildPeptidesForTags(Hashtable wildPeptides) {
        BufferedReader tagReader = null;
        Hashtable<String, Integer> findablePeptides = new Hashtable<String, Integer>();
        String line = null;
        int i = 0;
        while (i < this.tagFileNames.length) {
            System.out.println("Loading tags from " + this.tagFileNames[i]);
            try {
                tagReader = new BufferedReader(new FileReader(this.tagFileNames[i]));
                line = tagReader.readLine();
            }
            catch (IOException E) {
                System.err.println("ERROR:checkWildPeptidesForTags:" + E.getLocalizedMessage());
                System.exit(-1);
            }
            while (line != null) {
                if ((line = line.trim()).length() == 0 || line.charAt(0) == '#') {
                    try {
                        line = tagReader.readLine();
                    }
                    catch (IOException E) {
                        System.err.println("ERROR:checkWildPeptidesForTags:" + E.getLocalizedMessage());
                        System.exit(-1);
                    }
                    continue;
                }
                String[] bits = line.split("\t");
                String specFile = Utils.GetBaseName(bits[0]);
                String scanNum = bits[1];
                String hashKey = String.valueOf(specFile) + "_" + scanNum;
                if (wildPeptides.containsKey(hashKey)) {
                    double tagSuffix;
                    String tagSeq;
                    Object[] peptideInfo = (Object[])wildPeptides.get(hashKey);
                    String correctPeptide = (String)peptideInfo[0];
                    String[] dbPeptides = (String[])peptideInfo[1];
                    double tagPrefix = Double.parseDouble(bits[4]);
                    if (Utils.isGoodTag(correctPeptide, tagPrefix, tagSeq = bits[5], tagSuffix = Double.parseDouble(bits[6]))) {
                        int j = 0;
                        while (j < dbPeptides.length) {
                            if (Utils.findTagPositionILQKAgnostic(dbPeptides[j], tagSeq) >= 0) {
                                int currCount = 0;
                                if (findablePeptides.containsKey(hashKey)) {
                                    currCount = (Integer)findablePeptides.get(hashKey);
                                }
                                findablePeptides.put(hashKey, new Integer(++currCount));
                                break;
                            }
                            ++j;
                        }
                    }
                }
                try {
                    line = tagReader.readLine();
                }
                catch (IOException E) {
                    System.err.println("ERROR:checkWildPeptidesForTags:" + E.getLocalizedMessage());
                    System.exit(-1);
                }
            }
            try {
                tagReader.close();
            }
            catch (IOException E) {
                System.err.println("ERROR:checkWildPeptidesForTags:" + E.getLocalizedMessage());
                System.exit(-1);
            }
            ++i;
        }
        System.out.println("Total spectra with a good tag: " + findablePeptides.size());
    }

    private void writeResults(Hashtable currResults) {
        FileWriter f = null;
        try {
            f = new FileWriter(this.outputFileName);
            f.write("#FileName\tScanNum\tA:#PeptidesWithHigherScore");
            f.write("\tB:#PeptidesWithCorrectDBMatch\tB:#PeptidesWithCorrectDelta");
            f.write("\tB:AvgDistFromCorrectDeltaPositiong\tC:#PeptidesWithHD<0.1");
            f.write("\tD:#PeptidesWithCorrectPRM>0.6AndMissedPRM<0.25");
            f.write("\tE:Other\n");
        }
        catch (IOException E) {
            System.err.println("ERROR:analyze:" + E.getLocalizedMessage());
            System.exit(-1);
        }
        Enumeration e = currResults.keys();
        while (e.hasMoreElements()) {
            String hashKey = (String)e.nextElement();
            String fileName = hashKey.split("_")[0];
            String scanNum = hashKey.split("_")[1];
            double[] info = (double[])currResults.get(e);
            try {
                f.write(String.valueOf(fileName) + "\t" + scanNum + "\t" + info[0]);
                f.write("\t" + info[1] + "\t" + info[2] + "\t" + info[3]);
                f.write("\t" + info[4] + "\t" + info[5] + "\t" + info[6] + "\n");
            }
            catch (IOException E) {
                System.err.println("ERROR:analyze:" + E.getLocalizedMessage());
                System.exit(-1);
            }
        }
        try {
            f.close();
        }
        catch (IOException E) {
            System.err.println("ERROR:analyze:" + E.getLocalizedMessage());
            System.exit(-1);
        }
    }

    private static int findMutationIndex(String string, String string2) {
        if (string.length() != string2.length()) {
            System.err.println("ERROR:findMutationIndex: Cannot find index of first mutation in strings of different length, '" + string + "' and '" + string2 + "'!");
            System.exit(-1);
        }
        int i = 0;
        while (i < string.length()) {
            if (string.charAt(i) != string2.charAt(i)) {
                return i;
            }
            ++i;
        }
        return -1;
    }
}

