/*
 * Decompiled with CFR 0.152.
 */
package mutationMode;

import basicUtils.InspectAnnotation;
import basicUtils.Utils;
import java.io.FileWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Random;
import trieUtils.TrieDB;

public class MutatedDBCreator {
    private static final int DB_EXPLOSION = 3;
    public static String usageInfo = "mutationMode.MutatedDBCreator\nCreates a mutated database given a set of Inspect search results.  Duplicate\npeptides are removed from the input set, and no duplicate peptides are written to the database\nUsage: java -jar MutatedDBCreator.jar\n -r [FILE/DIR] File or directory containing InsPecT results\n or\n -t [FILE] Database of proteins to mutate\n -w [FILE] FASTA file to write mutated database to\n(-m [BLOSUM80/BLOSUM62/RANDOM] The scoring matrix to be used to choose mutations (default:RANDOM))\n(-n [NUM] Number of mutations per peptide (when  mutation a peptide database wtih -r, default: 1))\n(-x [NUM] Number of mutations per AA (when mutating a protein database with -t, default: 0.1)\n";
    public static double[][] BLOSUM80 = new double[][]{{1024.0, 1.0, 0.25, 0.0625, 0.25, 0.015625, 1.0, 0.0625, 0.0625, 1.0, 0.25, 0.0625, 0.25, 0.0625, 1.0, 0.25, 0.25, 0.0625, 4.0, 1.0, 1.0, 1.0, 0.015625, 1.0, 0.0625, 1.0}, {1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0}, {0.25, 1.0, 262144.0, 0.00390625, 9.765625E-4, 0.015625, 0.00390625, 0.00390625, 0.0625, 1.0, 0.00390625, 0.0625, 0.0625, 0.015625, 1.0, 0.00390625, 0.00390625, 0.00390625, 0.0625, 0.25, 1.0, 0.25, 0.015625, 1.0, 0.015625, 1.0}, {0.0625, 1.0, 0.00390625, 4096.0, 4.0, 0.00390625, 0.0625, 0.0625, 0.00390625, 1.0, 0.25, 9.765625E-4, 0.00390625, 4.0, 1.0, 0.0625, 0.25, 0.0625, 0.25, 0.25, 1.0, 0.00390625, 2.44140625E-4, 1.0, 0.00390625, 1.0}, {0.25, 1.0, 9.765625E-4, 4.0, 4096.0, 0.00390625, 0.015625, 1.0, 0.00390625, 1.0, 4.0, 0.00390625, 0.0625, 0.25, 1.0, 0.0625, 16.0, 0.25, 1.0, 0.25, 1.0, 0.015625, 0.00390625, 1.0, 0.015625, 1.0}, {0.015625, 1.0, 0.015625, 0.00390625, 0.00390625, 4096.0, 0.00390625, 0.0625, 0.25, 1.0, 0.00390625, 1.0, 1.0, 0.00390625, 1.0, 0.00390625, 0.00390625, 0.00390625, 0.015625, 0.0625, 1.0, 0.25, 1.0, 1.0, 64.0, 1.0}, {1.0, 1.0, 0.00390625, 0.0625, 0.015625, 0.00390625, 4096.0, 0.015625, 9.765625E-4, 1.0, 0.0625, 0.00390625, 0.00390625, 0.25, 1.0, 0.015625, 0.0625, 0.015625, 0.25, 0.0625, 1.0, 0.00390625, 0.00390625, 1.0, 0.00390625, 1.0}, {0.0625, 1.0, 0.00390625, 0.0625, 1.0, 0.0625, 0.015625, 65536.0, 0.00390625, 1.0, 0.25, 0.015625, 0.0625, 1.0, 1.0, 0.015625, 4.0, 1.0, 0.25, 0.0625, 1.0, 0.00390625, 0.015625, 1.0, 16.0, 1.0}, {0.0625, 1.0, 0.0625, 0.00390625, 0.00390625, 0.25, 9.765625E-4, 0.00390625, 1024.0, 1.0, 0.015625, 4.0, 4.0, 0.00390625, 1.0, 0.00390625, 0.015625, 0.015625, 0.015625, 0.25, 1.0, 64.0, 0.015625, 1.0, 0.0625, 1.0}, {1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0}, {0.25, 1.0, 0.00390625, 0.25, 4.0, 0.00390625, 0.0625, 0.25, 0.015625, 1.0, 1024.0, 0.015625, 0.0625, 1.0, 1.0, 0.25, 4.0, 16.0, 0.25, 0.25, 1.0, 0.015625, 0.00390625, 1.0, 0.015625, 1.0}, {0.25, 1.0, 0.0625, 9.765625E-4, 0.00390625, 1.0, 0.00390625, 0.015625, 4.0, 1.0, 0.015625, 256.0, 16.0, 0.00390625, 1.0, 0.015625, 0.015625, 0.015625, 0.015625, 0.0625, 1.0, 4.0, 0.0625, 1.0, 0.0625, 1.0}, {0.25, 1.0, 0.0625, 0.00390625, 0.0625, 1.0, 0.00390625, 0.0625, 4.0, 1.0, 0.0625, 16.0, 4096.0, 0.015625, 1.0, 0.015625, 1.0, 0.0625, 0.0625, 0.25, 1.0, 4.0, 0.0625, 1.0, 0.0625, 1.0}, {0.0625, 1.0, 0.015625, 4.0, 0.25, 0.00390625, 0.25, 1.0, 0.00390625, 1.0, 1.0, 0.00390625, 0.015625, 4096.0, 1.0, 0.015625, 1.0, 0.25, 1.0, 1.0, 1.0, 0.00390625, 0.00390625, 1.0, 0.015625, 1.0}, {1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0}, {0.25, 1.0, 0.00390625, 0.0625, 0.0625, 0.00390625, 0.015625, 0.015625, 0.00390625, 1.0, 0.25, 0.015625, 0.015625, 0.015625, 1.0, 65536.0, 0.0625, 0.0625, 0.25, 0.0625, 1.0, 0.015625, 9.765625E-4, 1.0, 0.00390625, 1.0}, {0.25, 1.0, 0.00390625, 0.25, 16.0, 0.00390625, 0.015625, 4.0, 0.015625, 1.0, 4.0, 0.015625, 1.0, 1.0, 1.0, 0.0625, 4096.0, 4.0, 1.0, 0.25, 1.0, 0.015625, 0.015625, 1.0, 0.015625, 1.0}, {0.0625, 1.0, 0.00390625, 0.0625, 0.25, 0.00390625, 0.015625, 1.0, 0.015625, 1.0, 16.0, 0.015625, 0.0625, 0.25, 1.0, 0.0625, 4.0, 4096.0, 0.25, 0.25, 1.0, 0.015625, 0.00390625, 1.0, 0.015625, 1.0}, {4.0, 1.0, 0.0625, 0.25, 1.0, 0.015625, 0.25, 0.25, 0.015625, 1.0, 0.25, 0.015625, 0.0625, 1.0, 1.0, 0.25, 1.0, 0.25, 1024.0, 4.0, 1.0, 0.0625, 0.00390625, 1.0, 0.0625, 1.0}, {1.0, 1.0, 0.25, 0.25, 0.25, 0.0625, 0.0625, 0.0625, 0.25, 1.0, 0.25, 0.0625, 0.25, 1.0, 1.0, 0.0625, 0.25, 0.25, 4.0, 1024.0, 1.0, 1.0, 0.00390625, 1.0, 0.0625, 1.0}, {1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0}, {1.0, 1.0, 0.25, 0.00390625, 0.015625, 0.25, 0.00390625, 0.00390625, 64.0, 1.0, 0.015625, 4.0, 4.0, 0.00390625, 1.0, 0.015625, 0.015625, 0.015625, 0.0625, 1.0, 1.0, 256.0, 0.015625, 1.0, 0.0625, 1.0}, {0.015625, 1.0, 0.015625, 2.44140625E-4, 0.00390625, 1.0, 0.00390625, 0.015625, 0.015625, 1.0, 0.00390625, 0.0625, 0.0625, 0.00390625, 1.0, 9.765625E-4, 0.015625, 0.00390625, 0.00390625, 0.00390625, 1.0, 0.015625, 4194304.0, 1.0, 16.0, 1.0}, {1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0}, {0.0625, 1.0, 0.015625, 0.00390625, 0.015625, 64.0, 0.00390625, 16.0, 0.0625, 1.0, 0.015625, 0.0625, 0.0625, 0.015625, 1.0, 0.00390625, 0.0625, 0.015625, 0.0625, 0.0625, 1.0, 0.0625, 16.0, 1.0, 16384.0, 1.0}};
    public static int[] ValidAAs;
    private double minDeltaMass = 1.1;
    private String inputDir;
    private String outputFile;
    private int numMutations;
    private String scoringMatrix;
    private Random randomNumGen;
    private String trieFileName;
    private double mutationRate;

    static {
        int[] nArray = new int[20];
        nArray[1] = 2;
        nArray[2] = 3;
        nArray[3] = 4;
        nArray[4] = 5;
        nArray[5] = 6;
        nArray[6] = 7;
        nArray[7] = 8;
        nArray[8] = 10;
        nArray[9] = 11;
        nArray[10] = 12;
        nArray[11] = 13;
        nArray[12] = 15;
        nArray[13] = 16;
        nArray[14] = 17;
        nArray[15] = 18;
        nArray[16] = 19;
        nArray[17] = 21;
        nArray[18] = 22;
        nArray[19] = 24;
        ValidAAs = nArray;
    }

    public MutatedDBCreator(String inputDir, String trieFile, String outputFile, int numMutations, double mutationRate, String scoringMatrix) {
        this.inputDir = inputDir;
        this.trieFileName = trieFile;
        this.outputFile = outputFile;
        if (this.inputDir != null) {
            this.numMutations = numMutations;
        }
        if (this.trieFileName != null) {
            this.mutationRate = mutationRate;
        }
        this.scoringMatrix = scoringMatrix;
        this.randomNumGen = new Random();
    }

    public static void main(String[] args) {
        String[] options = new String[]{"-r", "-w", "-m", "-n", "-t", "-x"};
        boolean[] values = new boolean[]{true, true, true, true, true, true};
        Hashtable commandLineArgs = Utils.ParseCommandLine(args, options, values);
        if (!commandLineArgs.containsKey("-r") && !commandLineArgs.containsKey("-t")) {
            System.err.println("ERROR: Must specify an input file/dir!");
            System.err.println(usageInfo);
            System.exit(0);
        }
        if (commandLineArgs.containsKey("-r") && commandLineArgs.containsKey("-t")) {
            System.err.println("ERROR: Must specify only 1 type of input file/dir!");
            System.err.println(usageInfo);
            System.exit(0);
        }
        if (!commandLineArgs.containsKey("-w")) {
            System.err.println("ERROR: Must specify an output FASTA file!");
            System.err.println(usageInfo);
            System.exit(0);
        }
        String inputDir = null;
        String trieFile = null;
        if (commandLineArgs.containsKey("-r")) {
            inputDir = (String)commandLineArgs.get("-r");
        } else if (commandLineArgs.containsKey("-t")) {
            trieFile = (String)commandLineArgs.get("-t");
        }
        String outputFile = (String)commandLineArgs.get("-w");
        int numMutations = 1;
        String scoringMatrix = "RANDOM";
        if (commandLineArgs.containsKey("-m") && (scoringMatrix = ((String)commandLineArgs.get("-m")).toUpperCase()).compareTo("RANDOM") != 0 && scoringMatrix.compareTo("BLOSUM80") != 0) {
            System.err.println("ERROR: Unsupported scoring matrix '" + scoringMatrix + "'!");
            System.exit(-1);
        }
        if (commandLineArgs.containsKey("-n")) {
            if (!commandLineArgs.containsKey("-r")) {
                System.err.println("ERROR: Cannot specify mutations per peptide when not using peptide input!");
                System.err.println(usageInfo);
                System.exit(-1);
            }
            if ((numMutations = Integer.parseInt((String)commandLineArgs.get("-n"))) < 0) {
                System.err.println("ERROR: Invalid number of mutations specified '" + numMutations + "!");
                System.exit(-1);
            }
        }
        double mutationRate = 0.1;
        if (commandLineArgs.containsKey("-x")) {
            if (!commandLineArgs.containsKey("-t")) {
                System.err.println("ERROR: Cannot specify mutations per AA when not using protein input!");
                System.err.println(usageInfo);
                System.exit(-1);
            }
            if ((mutationRate = Double.parseDouble((String)commandLineArgs.get("-x"))) < 0.0 || mutationRate > 1.0) {
                System.err.println("ERROR: Invalid rate of mutation specified '" + mutationRate + "!");
                System.exit(-1);
            }
        }
        MutatedDBCreator creator = new MutatedDBCreator(inputDir, trieFile, outputFile, numMutations, mutationRate, scoringMatrix);
        creator.createDB();
    }

    private void createDB() {
        if (this.inputDir != null) {
            this.createDBPeptide();
        } else if (this.trieFileName != null) {
            this.createDBProtein();
        }
    }

    private void createDBProtein() {
        TrieDB trie = new TrieDB(this.trieFileName);
        FileWriter f = null;
        try {
            f = new FileWriter(this.outputFile);
        }
        catch (Exception E) {
            E.printStackTrace();
            System.exit(-1);
        }
        int i = 0;
        while (i < trie.getNumProteins()) {
            String proteinName = trie.getProteinName(i);
            String proteinSequence = trie.getProteinSequence(i);
            int totalMutations = (int)((double)proteinSequence.length() * this.mutationRate);
            String mutatedSequence = proteinSequence;
            int j = 0;
            while (j < totalMutations) {
                mutatedSequence = this.MutatePeptide(mutatedSequence);
                ++j;
            }
            try {
                f.write(">[MUTATED]" + proteinName + "\n");
                f.write(String.valueOf(mutatedSequence) + "\n");
            }
            catch (Exception E) {
                E.printStackTrace();
                System.exit(-1);
            }
            ++i;
        }
        try {
            f.close();
        }
        catch (Exception E) {
            E.printStackTrace();
            System.exit(-1);
        }
    }

    private void createDBPeptide() {
        String pep;
        String[] peptides = InspectAnnotation.LoadPeptidesDir(this.inputDir);
        Hashtable<String, Integer> loadedPeptideHash = new Hashtable<String, Integer>();
        Hashtable<String, Integer> writtenPeptideHash = new Hashtable<String, Integer>();
        FileWriter f = null;
        try {
            f = new FileWriter(this.outputFile);
        }
        catch (Exception E) {
            E.printStackTrace();
            System.exit(-1);
        }
        int i = 0;
        while (i < peptides.length) {
            pep = peptides[i];
            if (pep.indexOf(46) >= 0) {
                pep = pep.substring(2, pep.length() - 2);
            }
            loadedPeptideHash.put(pep, new Integer(1));
            ++i;
        }
        System.out.println("Loaded " + loadedPeptideHash.size() + " peptides");
        Enumeration unModdedPeps = loadedPeptideHash.keys();
        while (unModdedPeps.hasMoreElements()) {
            pep = (String)unModdedPeps.nextElement();
            double pepMass = Utils.GetSeqMass(pep);
            int i2 = 0;
            while (i2 < 3) {
                String mutatedPep = this.MutatePeptide(pep);
                while (writtenPeptideHash.containsKey(mutatedPep) || loadedPeptideHash.containsKey(mutatedPep) || Math.abs(Utils.GetSeqMass(mutatedPep) - pepMass) < this.minDeltaMass) {
                    mutatedPep = this.MutatePeptide(pep);
                }
                writtenPeptideHash.put(mutatedPep, new Integer(1));
                try {
                    f.write(">" + pep + "\n" + mutatedPep + "\n");
                }
                catch (Exception E) {
                    E.printStackTrace();
                    System.exit(-1);
                }
                ++i2;
            }
        }
        System.out.println("Wrote " + writtenPeptideHash.size() + " mutated peptides");
        try {
            f.close();
        }
        catch (Exception E) {
            E.printStackTrace();
            System.exit(-1);
        }
        int count = 0;
        Enumeration unModdedPeptide = loadedPeptideHash.keys();
        block10: while (unModdedPeptide.hasMoreElements()) {
            String p1 = (String)unModdedPeptide.nextElement();
            Enumeration moddedPeptides = writtenPeptideHash.keys();
            while (moddedPeptides.hasMoreElements()) {
                String p2 = (String)moddedPeptides.nextElement();
                if (p2.indexOf(p1) < 0) continue;
                ++count;
                continue block10;
            }
        }
        System.out.println(String.valueOf(count) + " peptides appear unmodded in DB");
    }

    private String MutatePeptide(String pep) {
        boolean LocalDebug = false;
        int indexOfMutation = this.randomNumGen.nextInt(pep.length());
        char AAToMutate = pep.charAt(indexOfMutation);
        int AAToMutateIndex = AAToMutate - 65;
        double[] NormalizedCumVals = new double[26];
        if (LocalDebug) {
            System.out.println("Mutated peptide " + pep + " at position " + indexOfMutation + "(" + AAToMutate + ")");
        }
        double Sum = 0.0;
        int i = 0;
        while (i < ValidAAs.length) {
            if (ValidAAs[i] + 65 != AAToMutate) {
                Sum = this.scoringMatrix.compareTo("RANDOM") == 0 ? (Sum += 1.0) : (this.scoringMatrix.compareTo("BLOSUM80") == 0 ? (Sum += BLOSUM80[AAToMutateIndex][ValidAAs[i]]) : (Sum += 1.0 / (double)ValidAAs.length));
                NormalizedCumVals[MutatedDBCreator.ValidAAs[i]] = Sum;
            }
            ++i;
        }
        i = 0;
        while (i < ValidAAs.length) {
            int n = ValidAAs[i];
            NormalizedCumVals[n] = NormalizedCumVals[n] / Sum;
            if (LocalDebug) {
                System.out.println("P[" + AAToMutate + "->" + (char)(ValidAAs[i] + 65) + "] = " + NormalizedCumVals[ValidAAs[i]]);
            }
            ++i;
        }
        double val = this.randomNumGen.nextDouble();
        char FinalAA = (char)(ValidAAs[ValidAAs.length - 1] + 65);
        int i2 = 0;
        while (i2 < ValidAAs.length) {
            if (val < NormalizedCumVals[ValidAAs[i2]]) {
                FinalAA = (char)(ValidAAs[i2] + 65);
                break;
            }
            ++i2;
        }
        if (LocalDebug) {
            System.out.println("Random double: " + val);
            System.out.println("NewAA: " + FinalAA);
        }
        while (FinalAA == AAToMutate) {
            if (LocalDebug) {
                System.out.println("No change!!");
            }
            val = this.randomNumGen.nextDouble();
            FinalAA = (char)(ValidAAs[ValidAAs.length - 1] + 65);
            i2 = 0;
            while (i2 < ValidAAs.length) {
                if (val <= NormalizedCumVals[ValidAAs[i2]]) {
                    FinalAA = (char)(ValidAAs[i2] + 65);
                    break;
                }
                ++i2;
            }
            if (!LocalDebug) continue;
            System.out.println("Random double: " + val);
            System.out.println("NewAA: " + FinalAA);
        }
        String ret = pep.substring(0, indexOfMutation);
        ret = String.valueOf(ret) + FinalAA;
        ret = String.valueOf(ret) + pep.substring(indexOfMutation + 1);
        if (LocalDebug) {
            System.out.println("Mutated Pep: " + ret);
            Utils.WaitForEnter();
        }
        return ret;
    }
}

