/*
 * Decompiled with CFR 0.152.
 */
package proteogenomicUtils;

import basicUtils.GFFFile;
import basicUtils.Utils;
import errorUtils.ErrorThrower;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import proteogenomicUtils.EventFinder;
import proteogenomicUtils.ProteogenomicUtils;
import trieUtils.TrieDB;

public class AUGUSTUSRunner {
    private static final int DEFAULT_SEQ_BUFFER = 300;
    private static final int DEFAULT_GENE_COL = 1;
    private static final int DEFAULT_PROT_COL = 2;
    public static String usageInfo = "proteogenomicUtils.AUGUSTUSRunner version 2012.02.27\nThis class creates individual gene prediction problems given an events file\nUsage: java -jar AUGUSTUSRunner.jar\n -g [FILE] FASTA or trie file containing the genome\n -o [DIR] Output directory for all intermediate and gene prediction output\n -i [FILE] Novel event gff file\n -a [FILE] AUGUSTUS executable\n -c [DIR] Path for augustus config\n -s [STR] Species\n(-p [FILE] Known Proteome gff file)\n(-e [FILE/DIR] Other GFF file of evidence (ESTs, homology, etc))\n(-v Run in verbose mode)\n(-b [NUM] Amount of sequence to add outside of evidence boundaries, default: 300 bp)\n(-t [FILE] A file containing conversions from GFF file protein/transcript names to gene names)\n(-q [NUM] The column of the  gene name in the conversions file, default is 1)\n(-d [NUM] The column of the GFF protein/transcript name in the conversions file, default is 2)\n(-w [FILE] Write protein summary to file\n(-x Force creation of input files, even if they already exist (default: create files only if they don't exist)\n";
    private String sequenceFASTA;
    private String outputDir;
    private String eventGFF;
    private String augustusExec;
    private boolean SkipFileCreation = true;
    private String[] evidenceFiles = null;
    private String knownProteomeGFFFileName = null;
    private int ntBuffer = 300;
    private boolean verboseMode = false;
    private Hashtable knownProteinCoords;
    private String[] types = null;
    private String geneNameConversionFile = null;
    private int geneNameCol = 1;
    private int protNameCol = 2;
    private Hashtable eventLocations = null;
    private Hashtable GFFToGeneMap;
    private Hashtable spans;
    private String species;
    private Hashtable knownProteinLines;
    private String[] augustusCommands;
    private String augustusConfigPath;
    private String[] augustus2Locus;
    private String outputSummaryFile;
    private String[] augustusOutputFile;
    private Hashtable evidenceHash;
    private String[] contigNames = null;
    private TrieDB seqDB;

    public AUGUSTUSRunner(String seqFile, String outputDir, String eventGFF, String augustusExec, String knownProteomeFileName, String evidenceDir, boolean verboseMode, int seqBuffer, String geneNameConversionFile, int geneNameCol, int protNameCol, String species, String augustusConfigPath, String summaryFileName) {
        if (!Utils.IsFile(seqFile)) {
            ErrorThrower.ThrowError(1, seqFile);
        }
        this.sequenceFASTA = seqFile;
        String ext = Utils.GetFileExtension(this.sequenceFASTA);
        this.seqDB = null;
        if (ext.compareTo(".trie") == 0) {
            this.seqDB = new TrieDB(this.sequenceFASTA);
        } else {
            String[] trieFileName = TrieDB.prepDB(this.sequenceFASTA, null);
            this.seqDB = new TrieDB(trieFileName[0]);
        }
        if (!Utils.IsDir(outputDir)) {
            Utils.MakeDir(outputDir);
        }
        this.outputDir = outputDir;
        if (!Utils.IsFile(eventGFF)) {
            ErrorThrower.ThrowError(1, eventGFF);
        }
        this.eventGFF = eventGFF;
        if (!Utils.IsFile(augustusExec)) {
            ErrorThrower.ThrowError(1, augustusExec);
        }
        this.augustusExec = augustusExec;
        if (knownProteomeFileName != null && !Utils.IsFile(knownProteomeFileName)) {
            ErrorThrower.ThrowError(1, knownProteomeFileName);
        }
        this.knownProteomeGFFFileName = knownProteomeFileName;
        if (evidenceDir != null) {
            if (Utils.IsFile(evidenceDir)) {
                this.evidenceFiles = new String[1];
                this.evidenceFiles[0] = evidenceDir;
            } else if (Utils.IsDir(evidenceDir)) {
                this.evidenceFiles = Utils.ListDir(evidenceDir);
            } else {
                ErrorThrower.ThrowError(1, evidenceDir);
            }
        }
        this.verboseMode = verboseMode;
        if (seqBuffer < 0) {
            ErrorThrower.ThrowError(4, "Sequence buffer must be non-negative");
        }
        this.ntBuffer = seqBuffer;
        if (geneNameConversionFile != null && !Utils.IsFile(geneNameConversionFile)) {
            ErrorThrower.ThrowError(1, geneNameConversionFile);
        }
        this.geneNameConversionFile = geneNameConversionFile;
        if (geneNameCol != Integer.MAX_VALUE && geneNameCol < 0) {
            ErrorThrower.ThrowError(4, "Gene name column must be non-negative");
        }
        this.geneNameCol = geneNameCol;
        if (protNameCol != Integer.MAX_VALUE && protNameCol < 0) {
            ErrorThrower.ThrowError(4, "Protein name column must be non-negative");
        }
        this.protNameCol = protNameCol;
        int speciesIndex = Utils.FindStringInArray(ProteogenomicUtils.species, species);
        if (speciesIndex < 0) {
            ErrorThrower.ThrowWarningCustom(101, "Unsupported species '" + species + "'! Using the FASTA file to learn numbers");
            this.contigNames = Utils.ConvertHashSetToStringArray(this.seqDB.getAllProteinNames());
        }
        this.species = species;
        if (!Utils.IsDir(augustusConfigPath)) {
            ErrorThrower.ThrowError(1, augustusConfigPath);
        }
        this.augustusConfigPath = augustusConfigPath;
        this.outputSummaryFile = summaryFileName;
    }

    public static void main(String[] args) {
        String[] options = new String[]{"-g", "-o", "-i", "-a", "-p", "-e", "-v", "-b", "-t", "-q", "-d", "-s", "-c", "-w", "-x"};
        boolean[] blArray = new boolean[15];
        blArray[0] = true;
        blArray[1] = true;
        blArray[2] = true;
        blArray[3] = true;
        blArray[4] = true;
        blArray[5] = true;
        blArray[7] = true;
        blArray[8] = true;
        blArray[9] = true;
        blArray[10] = true;
        blArray[11] = true;
        blArray[12] = true;
        blArray[13] = true;
        boolean[] values = blArray;
        Hashtable commandLineArgs = Utils.ParseCommandLine(args, options, values);
        if (!(commandLineArgs.containsKey("-g") && commandLineArgs.containsKey("-o") && commandLineArgs.containsKey("-i") && commandLineArgs.containsKey("-a") && commandLineArgs.containsKey("-s") && commandLineArgs.containsKey("-c"))) {
            System.out.println(usageInfo);
            ErrorThrower.ThrowError(2, "Must specify a sequence file (-g), an output directory (-o), a novel event GFF file (-i), an augustus executable (-a), a species (-s), and the augustus config path (-c)");
        }
        String seqFile = (String)commandLineArgs.get("-g");
        String outputDir = (String)commandLineArgs.get("-o");
        String eventGFF = (String)commandLineArgs.get("-i");
        String augustusExec = (String)commandLineArgs.get("-a");
        String species = (String)commandLineArgs.get("-s");
        String augustusConfigPath = (String)commandLineArgs.get("-c");
        String knownProteomeFileName = null;
        String evidenceDir = null;
        boolean verboseMode = false;
        int seqBuffer = 300;
        String geneNameConversionFile = null;
        int geneNameCol = 1;
        int protNameCol = 2;
        String summaryFileName = null;
        if (commandLineArgs.containsKey("-p")) {
            knownProteomeFileName = (String)commandLineArgs.get("-p");
        }
        if (commandLineArgs.containsKey("-e")) {
            evidenceDir = (String)commandLineArgs.get("-e");
        }
        if (commandLineArgs.containsKey("-v")) {
            verboseMode = true;
        }
        if (commandLineArgs.containsKey("-b")) {
            seqBuffer = Integer.parseInt((String)commandLineArgs.get("-b"));
        }
        if (commandLineArgs.containsKey("-q")) {
            geneNameCol = Integer.parseInt((String)commandLineArgs.get("-q"));
        }
        if (commandLineArgs.containsKey("-d")) {
            protNameCol = Integer.parseInt((String)commandLineArgs.get("-d"));
        }
        if (commandLineArgs.containsKey("-t")) {
            geneNameConversionFile = (String)commandLineArgs.get("-t");
        }
        if (commandLineArgs.containsKey("-w")) {
            summaryFileName = (String)commandLineArgs.get("-w");
        }
        AUGUSTUSRunner r = new AUGUSTUSRunner(seqFile, outputDir, eventGFF, augustusExec, knownProteomeFileName, evidenceDir, verboseMode, seqBuffer, geneNameConversionFile, geneNameCol, protNameCol, species, augustusConfigPath, summaryFileName);
        if (commandLineArgs.containsKey("-x")) {
            r.SkipFileCreation = false;
        }
        r.run();
    }

    private void run() {
        if (this.geneNameConversionFile != null) {
            if (this.verboseMode) {
                System.out.println("Loading the conversion file '" + this.geneNameConversionFile + "'...");
            }
            this.GFFToGeneMap = ProteogenomicUtils.loadTranslationFile(this.geneNameConversionFile, this.protNameCol, this.geneNameCol);
            if (this.verboseMode) {
                System.out.println(" - Loaded conversions for " + this.GFFToGeneMap.size() + " gene names");
            }
        } else if (this.verboseMode) {
            System.out.println("Skipping conversion file load...");
        }
        if (this.knownProteomeGFFFileName != null) {
            if (this.verboseMode) {
                System.out.println("Loading the known proteome from '" + this.knownProteomeGFFFileName + "'...");
            }
            this.knownProteinCoords = GFFFile.getProteinCoords(null, this.knownProteomeGFFFileName, false);
            if (this.verboseMode) {
                System.out.println(" - Loaded gff lines for " + this.knownProteinCoords.size() + " proteins");
            }
            this.knownProteinLines = GFFFile.getGeneLines(this.knownProteomeGFFFileName, this.GFFToGeneMap, false);
            if (this.verboseMode) {
                System.out.println(" - Loaded coords for " + this.knownProteinLines.size() + " genes");
            }
        }
        if (this.evidenceFiles != null) {
            if (this.verboseMode) {
                System.out.println("Splitting the evidence files by sequence name");
            }
            this.evidenceHash = GFFFile.splitBySeqName(this.evidenceFiles, this.outputDir, this.SkipFileCreation);
        }
        if (this.verboseMode) {
            System.out.println("Loading event locations file '" + this.eventGFF + "'...");
        }
        this.eventLocations = EventFinder.loadEventGFF(this.eventGFF, this.GFFToGeneMap, false, this.types);
        if (this.verboseMode) {
            System.out.println(" - Loaded events for " + this.eventLocations.size() + " loci");
        }
        if (this.verboseMode) {
            System.out.println("Updating locus spans...");
        }
        this.getLocusSpans();
        if (this.verboseMode) {
            System.out.println("Writing augustus input files...");
        }
        this.writeFilesForEachSpan();
        if (this.verboseMode) {
            System.out.println("Executing augustus...");
        }
        OutputStreamWriter outFile = null;
        OutputStreamWriter outFASTAFile = null;
        String outputFASTAFile = null;
        if (this.outputSummaryFile != null) {
            outputFASTAFile = String.valueOf(Utils.GetFileNameNoExtension(this.outputSummaryFile)) + ".fasta";
            try {
                outFile = new FileWriter(this.outputSummaryFile);
                outFASTAFile = new FileWriter(outputFASTAFile);
                outFile.write("#LocusName\tGeneName\tTranNum\tPeptidesObeyed\tPeptidesDenied\tOtherObeyed\tOtherDenied\tProteinSequence\n");
            }
            catch (IOException E) {
                ErrorThrower.ThrowError(5, this.outputSummaryFile);
            }
        }
        int i = 0;
        while (i < this.augustusCommands.length) {
            if (this.augustusCommands[i] != null) {
                if (this.verboseMode) {
                    System.out.println(this.augustusCommands[i]);
                }
                if (!this.SkipFileCreation || !Utils.IsFile(this.augustusOutputFile[i])) {
                    try {
                        Utils.RunCommand(this.augustusCommands[i], null, this.augustusConfigPath);
                    }
                    catch (Exception E) {
                        ErrorThrower.ThrowError(14, this.augustusCommands[i]);
                    }
                }
                if (outFile != null) {
                    String locusName = this.augustus2Locus[i];
                    String augustusOutput = this.augustusOutputFile[i];
                    ArrayList lines = this.parseAugustusOutput(augustusOutput);
                    int j = 0;
                    while (j < lines.size()) {
                        String sumLine = (String)lines.get(j);
                        sumLine = String.valueOf(locusName) + "\t" + sumLine + "\n";
                        try {
                            outFile.write(sumLine);
                        }
                        catch (IOException E) {
                            ErrorThrower.ThrowError(7, this.outputSummaryFile);
                        }
                        String[] bits = sumLine.split("\t");
                        try {
                            outFASTAFile.write(">" + bits[0] + "." + bits[1] + "." + bits[2] + "\n");
                            outFASTAFile.write(bits[7]);
                        }
                        catch (IOException E) {
                            ErrorThrower.ThrowError(7, outputFASTAFile);
                        }
                        ++j;
                    }
                }
            }
            ++i;
        }
        if (outFile != null) {
            try {
                outFile.close();
                outFASTAFile.close();
            }
            catch (IOException E) {
                ErrorThrower.ThrowError(8, this.outputSummaryFile);
            }
        }
    }

    private ArrayList parseAugustusOutput(String augustusOutput) {
        ArrayList<String> lines = new ArrayList<String>();
        boolean Debug = false;
        BufferedReader buf = null;
        String line = null;
        try {
            buf = new BufferedReader(new FileReader(augustusOutput));
            line = buf.readLine();
        }
        catch (IOException E) {
            ErrorThrower.ThrowError(5, augustusOutput);
        }
        String currGeneName = "";
        int transNum = 1;
        String currProteinSequence = "";
        boolean readingProtein = false;
        int remainingObeyed = 0;
        int remainingDenied = 0;
        int peptideObeyed = 0;
        int otherObeyed = 0;
        int peptideDenied = 0;
        int otherDenied = 0;
        while (line != null) {
            int num;
            String type;
            String[] bits;
            String summaryLine;
            if ((line = line.trim()).length() == 0) {
                try {
                    line = buf.readLine();
                }
                catch (IOException E) {
                    ErrorThrower.ThrowError(6, augustusOutput);
                }
                continue;
            }
            if (Debug) {
                System.out.println(line);
            }
            if (line.indexOf("start gene") >= 0) {
                currGeneName = line.split(" ")[3];
                transNum = 1;
                currProteinSequence = "";
                peptideObeyed = 0;
                otherObeyed = 0;
                peptideDenied = 0;
                otherDenied = 0;
            } else if (line.indexOf("protein sequence") >= 0) {
                if (currProteinSequence.length() > 0) {
                    if (remainingDenied != 0 || remainingObeyed != 0) {
                        ErrorThrower.ThrowWarningCustom(101, "There are remaining hints no considered!");
                    }
                    summaryLine = String.valueOf(currGeneName) + "\t" + transNum + "\t" + peptideObeyed + "\t" + peptideDenied + "\t" + otherObeyed + "\t" + otherDenied + "\t" + currProteinSequence;
                    if (Debug) {
                        System.out.println(summaryLine);
                        Utils.WaitForEnter();
                    }
                    lines.add(summaryLine);
                    currProteinSequence = "";
                    peptideObeyed = 0;
                    otherObeyed = 0;
                    peptideDenied = 0;
                    otherDenied = 0;
                    ++transNum;
                }
                currProteinSequence = String.valueOf(currProteinSequence) + line.substring(line.indexOf("[") + 1);
                readingProtein = true;
            } else if (readingProtein) {
                if ((currProteinSequence = String.valueOf(currProteinSequence) + line.split(" ")[1]).indexOf(93) >= 0) {
                    currProteinSequence = currProteinSequence.substring(0, currProteinSequence.indexOf(93));
                    readingProtein = false;
                }
            } else if (line.indexOf("obeyed") >= 0) {
                remainingObeyed = Integer.parseInt(line.split(" ")[5]);
            } else if (remainingObeyed > 0) {
                block39: {
                    bits = Utils.SplitLineMergingDelims(line, " ");
                    type = bits[1];
                    num = -1;
                    try {
                        num = Integer.parseInt(bits[2]);
                    }
                    catch (Exception E) {
                        if (bits[1].indexOf(":") < 0) break block39;
                        num = Integer.parseInt(bits[1].substring(bits[1].indexOf(58) + 1));
                    }
                }
                if (type.indexOf(77) >= 0) {
                    peptideObeyed += num;
                } else {
                    otherObeyed += num;
                }
                remainingObeyed -= num;
            } else if (line.indexOf("incompatible") >= 0) {
                remainingDenied = Integer.parseInt(line.split(" ")[4]);
            } else if (remainingDenied > 0) {
                block40: {
                    bits = Utils.SplitLineMergingDelims(line, " ");
                    type = bits[1];
                    num = -1;
                    try {
                        num = Integer.parseInt(bits[2]);
                    }
                    catch (Exception E) {
                        if (bits[1].indexOf(":") < 0) break block40;
                        num = Integer.parseInt(bits[1].substring(bits[1].indexOf(58) + 1));
                    }
                }
                if (type.indexOf(77) >= 0) {
                    peptideDenied += num;
                } else {
                    otherDenied += num;
                }
                remainingDenied -= num;
            }
            if (line.indexOf("end gene") >= 0) {
                if (remainingDenied != 0 || remainingObeyed != 0) {
                    ErrorThrower.ThrowWarningCustom(101, "There are remaining hints no considered!");
                }
                summaryLine = String.valueOf(currGeneName) + "\t" + transNum + "\t" + peptideObeyed + "\t" + peptideDenied + "\t" + otherObeyed + "\t" + otherDenied + "\t" + currProteinSequence;
                if (Debug) {
                    System.out.println(summaryLine);
                    Utils.WaitForEnter();
                }
                lines.add(summaryLine);
            }
            try {
                line = buf.readLine();
            }
            catch (IOException E) {
                ErrorThrower.ThrowError(6, augustusOutput);
            }
        }
        try {
            buf.close();
        }
        catch (IOException E) {
            ErrorThrower.ThrowError(8, augustusOutput);
        }
        return lines;
    }

    private void writeFilesForEachSpan_Old() {
        this.augustusCommands = new String[this.spans.size()];
        int commandIndex = -1;
        this.augustus2Locus = new String[this.augustusCommands.length];
        this.augustusOutputFile = new String[this.augustusCommands.length];
        Enumeration loci = this.spans.keys();
        while (loci.hasMoreElements()) {
            String outputFileName;
            String locusName;
            this.augustusCommands[++commandIndex] = null;
            this.augustus2Locus[commandIndex] = locusName = (String)loci.nextElement();
            int[] coords = (int[])this.spans.get(locusName);
            int actualStart = Math.max(0, coords[0] - this.ntBuffer);
            int actualEnd = coords[1] + this.ntBuffer;
            String seqName = ProteogenomicUtils.getChromosomeName(coords[2], this.species, this.contigNames);
            String FASTAfileName = String.valueOf(this.outputDir) + File.separator + seqName + "_" + actualStart + "-" + actualEnd + ".fasta";
            String HintfileName = String.valueOf(this.outputDir) + File.separator + seqName + "_" + actualStart + "-" + actualEnd + ".gff";
            this.augustusOutputFile[commandIndex] = outputFileName = String.valueOf(this.outputDir) + File.separator + seqName + "_" + actualStart + "-" + actualEnd + ".augustus.gff";
            boolean allFilesExist = Utils.IsFile(FASTAfileName) && Utils.IsFile(HintfileName);
            int seqID = this.seqDB.getProteinIDFromPartial(seqName);
            if (seqID < 0) {
                ErrorThrower.ThrowWarning(4, "Unable to find sequence '" + seqName + "' in FASTA file\n");
                continue;
            }
            String fastaSeq = this.seqDB.GetProteinSubstring(seqID, actualStart, actualEnd);
            if (this.verboseMode) {
                System.out.println("Creating FASTA file '" + FASTAfileName + "'");
            }
            if (!this.SkipFileCreation || !allFilesExist) {
                FileWriter fastaWriter = null;
                try {
                    fastaWriter = new FileWriter(FASTAfileName);
                }
                catch (IOException E) {
                    ErrorThrower.ThrowError(5, FASTAfileName);
                }
                try {
                    fastaWriter.write(">" + seqName + "\n");
                    fastaWriter.write(String.valueOf(fastaSeq) + "\n");
                }
                catch (IOException E) {
                    ErrorThrower.ThrowError(7, FASTAfileName);
                }
                try {
                    fastaWriter.close();
                }
                catch (IOException E) {
                    ErrorThrower.ThrowError(8, FASTAfileName);
                }
            }
            if (this.verboseMode) {
                System.out.println("Creating GFF file '" + HintfileName + "'");
            }
            if (!this.SkipFileCreation || !allFilesExist) {
                int end;
                int start;
                String[] bits;
                String line;
                FileWriter gffWriter = null;
                try {
                    gffWriter = new FileWriter(HintfileName);
                }
                catch (IOException E) {
                    ErrorThrower.ThrowError(5, HintfileName);
                }
                ArrayList lines = (ArrayList)this.eventLocations.get(locusName);
                int i = 0;
                while (i < lines.size()) {
                    line = (String)lines.get(i);
                    bits = line.split("\t");
                    start = Integer.parseInt(bits[GFFFile.GFFColumns.Start]);
                    end = Integer.parseInt(bits[GFFFile.GFFColumns.End]);
                    bits[GFFFile.GFFColumns.Start] = String.valueOf(start -= actualStart);
                    bits[GFFFile.GFFColumns.End] = String.valueOf(end -= actualStart);
                    bits[GFFFile.GFFColumns.SequenceName] = ProteogenomicUtils.getChromosomeName(bits[GFFFile.GFFColumns.SequenceName], this.species);
                    int n = GFFFile.GFFColumns.Attributes;
                    bits[n] = String.valueOf(bits[n]) + ";source=M";
                    if (!bits[GFFFile.GFFColumns.FeatureType].equalsIgnoreCase("mrna")) {
                        try {
                            gffWriter.write(String.valueOf(Utils.JoinStringArray(bits, "\t")) + "\n");
                        }
                        catch (IOException E) {
                            ErrorThrower.ThrowError(7, HintfileName);
                        }
                    }
                    ++i;
                }
                if (this.knownProteinLines != null) {
                    lines = (ArrayList)this.knownProteinLines.get(locusName);
                    i = 0;
                    while (lines != null && i < lines.size()) {
                        line = (String)lines.get(i);
                        bits = line.split("\t");
                        start = Integer.parseInt(bits[GFFFile.GFFColumns.Start]);
                        end = Integer.parseInt(bits[GFFFile.GFFColumns.End]);
                        bits[GFFFile.GFFColumns.Start] = String.valueOf(start -= actualStart);
                        bits[GFFFile.GFFColumns.End] = String.valueOf(end -= actualStart);
                        bits[GFFFile.GFFColumns.SequenceName] = ProteogenomicUtils.getChromosomeName(bits[GFFFile.GFFColumns.SequenceName], this.species);
                        int n = GFFFile.GFFColumns.Attributes;
                        bits[n] = String.valueOf(bits[n]) + ";source=E";
                        if (!bits[GFFFile.GFFColumns.FeatureType].equalsIgnoreCase("mrna")) {
                            try {
                                gffWriter.write(String.valueOf(Utils.JoinStringArray(bits, "\t")) + "\n");
                            }
                            catch (IOException E) {
                                ErrorThrower.ThrowError(7, HintfileName);
                            }
                        }
                        ++i;
                    }
                }
                if (this.evidenceFiles != null) {
                    lines = this.getOverlappingLines(coords[2], actualStart, actualEnd);
                    i = 0;
                    while (lines != null && i < lines.size()) {
                        line = (String)lines.get(i);
                        bits = line.split("\t");
                        start = Integer.parseInt(bits[GFFFile.GFFColumns.Start]);
                        end = Integer.parseInt(bits[GFFFile.GFFColumns.End]);
                        bits[GFFFile.GFFColumns.Start] = String.valueOf(start -= actualStart);
                        bits[GFFFile.GFFColumns.End] = String.valueOf(end -= actualStart);
                        bits[GFFFile.GFFColumns.SequenceName] = ProteogenomicUtils.getChromosomeName(bits[GFFFile.GFFColumns.SequenceName], this.species);
                        int n = GFFFile.GFFColumns.Attributes;
                        bits[n] = String.valueOf(bits[n]) + ";source=E";
                        if (!bits[GFFFile.GFFColumns.FeatureType].equalsIgnoreCase("mrna")) {
                            try {
                                gffWriter.write(String.valueOf(Utils.JoinStringArray(bits, "\t")) + "\n");
                            }
                            catch (IOException E) {
                                ErrorThrower.ThrowError(7, HintfileName);
                            }
                        }
                        ++i;
                    }
                }
                try {
                    gffWriter.close();
                }
                catch (IOException E) {
                    ErrorThrower.ThrowError(8, HintfileName);
                }
            }
            this.augustusCommands[commandIndex] = this.augustusExec;
            int n = commandIndex;
            this.augustusCommands[n] = String.valueOf(this.augustusCommands[n]) + " --strand=both";
            int n2 = commandIndex;
            this.augustusCommands[n2] = String.valueOf(this.augustusCommands[n2]) + " --genemodel=complete";
            int n3 = commandIndex;
            this.augustusCommands[n3] = String.valueOf(this.augustusCommands[n3]) + " --hintsfile=" + HintfileName;
            int n4 = commandIndex;
            this.augustusCommands[n4] = String.valueOf(this.augustusCommands[n4]) + " --AUGUSTUS_CONFIG_PATH=" + this.augustusConfigPath;
            int n5 = commandIndex;
            this.augustusCommands[n5] = String.valueOf(this.augustusCommands[n5]) + " --alternatives-from-evidence=true";
            int n6 = commandIndex;
            this.augustusCommands[n6] = String.valueOf(this.augustusCommands[n6]) + " --outfile=" + outputFileName;
            int n7 = commandIndex;
            this.augustusCommands[n7] = String.valueOf(this.augustusCommands[n7]) + " --singlestrand=true";
            int n8 = commandIndex;
            this.augustusCommands[n8] = String.valueOf(this.augustusCommands[n8]) + " --species=" + this.species;
            int n9 = commandIndex;
            this.augustusCommands[n9] = String.valueOf(this.augustusCommands[n9]) + " " + FASTAfileName;
        }
    }

    private void writeFilesForEachSpan() {
        this.augustusCommands = new String[this.spans.size()];
        int commandIndex = -1;
        this.augustus2Locus = new String[this.augustusCommands.length];
        this.augustusOutputFile = new String[this.augustusCommands.length];
        Enumeration loci = this.spans.keys();
        while (loci.hasMoreElements()) {
            String outputFileName;
            String locusName;
            this.augustusCommands[++commandIndex] = null;
            this.augustus2Locus[commandIndex] = locusName = (String)loci.nextElement();
            int[] coords = (int[])this.spans.get(locusName);
            int proposedStart = Math.max(0, coords[0] - this.ntBuffer);
            int proposedEnd = coords[1] + this.ntBuffer;
            ArrayList supportingLines = this.getOverlappingLines(this.evidenceHash, this.knownProteinLines, proposedStart, proposedEnd, coords[2]);
            int[] newSpan = GFFFile.getLineSpan(supportingLines);
            newSpan[0] = Math.min(newSpan[0], proposedStart);
            newSpan[1] = Math.max(newSpan[1], proposedEnd);
            int actualStart = newSpan[0];
            int actualEnd = newSpan[1];
            String seqName = ProteogenomicUtils.getChromosomeName(coords[2], this.species, this.contigNames);
            String FASTAfileName = String.valueOf(this.outputDir) + File.separator + seqName + "_" + actualStart + "-" + actualEnd + ".fasta";
            String HintfileName = String.valueOf(this.outputDir) + File.separator + seqName + "_" + actualStart + "-" + actualEnd + ".gff";
            this.augustusOutputFile[commandIndex] = outputFileName = String.valueOf(this.outputDir) + File.separator + seqName + "_" + actualStart + "-" + actualEnd + ".augustus.gff";
            boolean allFilesExist = Utils.IsFile(FASTAfileName) && Utils.IsFile(HintfileName);
            int seqID = this.seqDB.getProteinIDFromPartial(seqName);
            if (seqID < 0) {
                ErrorThrower.ThrowWarning(4, "Unable to find sequence '" + seqName + "' in FASTA file\n");
                continue;
            }
            String fastaSeq = this.seqDB.GetProteinSubstring(seqID, actualStart, actualEnd);
            if (this.verboseMode) {
                System.out.println("Creating FASTA file '" + FASTAfileName + "'");
            }
            if (!this.SkipFileCreation || !allFilesExist) {
                FileWriter fastaWriter = null;
                try {
                    fastaWriter = new FileWriter(FASTAfileName);
                }
                catch (IOException E) {
                    ErrorThrower.ThrowError(5, FASTAfileName);
                }
                try {
                    fastaWriter.write(">" + seqName + "\n");
                    fastaWriter.write(String.valueOf(fastaSeq) + "\n");
                }
                catch (IOException E) {
                    ErrorThrower.ThrowError(7, FASTAfileName);
                }
                try {
                    fastaWriter.close();
                }
                catch (IOException E) {
                    ErrorThrower.ThrowError(8, FASTAfileName);
                }
            }
            if (this.verboseMode) {
                System.out.println("Creating GFF file '" + HintfileName + "'");
            }
            if (!this.SkipFileCreation || !allFilesExist) {
                int end;
                int start;
                String[] bits;
                String line;
                FileWriter gffWriter = null;
                try {
                    gffWriter = new FileWriter(HintfileName);
                }
                catch (IOException E) {
                    ErrorThrower.ThrowError(5, HintfileName);
                }
                ArrayList eventLines = (ArrayList)this.eventLocations.get(locusName);
                int i = 0;
                while (i < eventLines.size()) {
                    line = (String)eventLines.get(i);
                    bits = line.split("\t");
                    start = Integer.parseInt(bits[GFFFile.GFFColumns.Start]);
                    end = Integer.parseInt(bits[GFFFile.GFFColumns.End]);
                    bits[GFFFile.GFFColumns.Start] = String.valueOf(start -= actualStart);
                    bits[GFFFile.GFFColumns.End] = String.valueOf(end -= actualStart);
                    bits[GFFFile.GFFColumns.SequenceName] = ProteogenomicUtils.getChromosomeName(bits[GFFFile.GFFColumns.SequenceName], this.species);
                    int n = GFFFile.GFFColumns.Attributes;
                    bits[n] = String.valueOf(bits[n]) + ";source=M";
                    if (!bits[GFFFile.GFFColumns.FeatureType].equalsIgnoreCase("mrna")) {
                        try {
                            gffWriter.write(String.valueOf(Utils.JoinStringArray(bits, "\t")) + "\n");
                        }
                        catch (IOException E) {
                            ErrorThrower.ThrowError(7, HintfileName);
                        }
                    }
                    ++i;
                }
                i = 0;
                while (supportingLines != null && i < supportingLines.size()) {
                    line = (String)supportingLines.get(i);
                    bits = line.split("\t");
                    start = Integer.parseInt(bits[GFFFile.GFFColumns.Start]);
                    end = Integer.parseInt(bits[GFFFile.GFFColumns.End]);
                    bits[GFFFile.GFFColumns.Start] = String.valueOf(start -= actualStart);
                    bits[GFFFile.GFFColumns.End] = String.valueOf(end -= actualStart);
                    bits[GFFFile.GFFColumns.SequenceName] = ProteogenomicUtils.getChromosomeName(bits[GFFFile.GFFColumns.SequenceName], this.species);
                    int n = GFFFile.GFFColumns.Attributes;
                    bits[n] = String.valueOf(bits[n]) + ";source=E";
                    if (!bits[GFFFile.GFFColumns.FeatureType].equalsIgnoreCase("mrna")) {
                        try {
                            gffWriter.write(String.valueOf(Utils.JoinStringArray(bits, "\t")) + "\n");
                        }
                        catch (IOException E) {
                            ErrorThrower.ThrowError(7, HintfileName);
                        }
                    }
                    ++i;
                }
                try {
                    gffWriter.close();
                }
                catch (IOException E) {
                    ErrorThrower.ThrowError(8, HintfileName);
                }
            }
            this.augustusCommands[commandIndex] = this.augustusExec;
            int n = commandIndex;
            this.augustusCommands[n] = String.valueOf(this.augustusCommands[n]) + " --strand=both";
            int n2 = commandIndex;
            this.augustusCommands[n2] = String.valueOf(this.augustusCommands[n2]) + " --genemodel=complete";
            int n3 = commandIndex;
            this.augustusCommands[n3] = String.valueOf(this.augustusCommands[n3]) + " --hintsfile=" + HintfileName;
            int n4 = commandIndex;
            this.augustusCommands[n4] = String.valueOf(this.augustusCommands[n4]) + " --AUGUSTUS_CONFIG_PATH=" + this.augustusConfigPath;
            int n5 = commandIndex;
            this.augustusCommands[n5] = String.valueOf(this.augustusCommands[n5]) + " --alternatives-from-evidence=true";
            int n6 = commandIndex;
            this.augustusCommands[n6] = String.valueOf(this.augustusCommands[n6]) + " --outfile=" + outputFileName;
            int n7 = commandIndex;
            this.augustusCommands[n7] = String.valueOf(this.augustusCommands[n7]) + " --singlestrand=true";
            int n8 = commandIndex;
            this.augustusCommands[n8] = String.valueOf(this.augustusCommands[n8]) + " --species=" + this.species;
            int n9 = commandIndex;
            this.augustusCommands[n9] = String.valueOf(this.augustusCommands[n9]) + " " + FASTAfileName;
        }
    }

    private ArrayList getOverlappingLines(Hashtable evidenceHash2, Hashtable knownProteinLines2, int start, int end, int seqNum) {
        String seqName = ProteogenomicUtils.getChromosomeName(seqNum, this.species, this.contigNames);
        ArrayList ret = new ArrayList();
        if (evidenceHash2 != null && evidenceHash2.containsKey(seqName)) {
            String fileName = (String)evidenceHash2.get(seqName);
            ret.addAll(this.getOverlappingLines(seqNum, start, end, fileName));
        }
        if (knownProteinLines2 != null) {
            ret.addAll(this.getOverlappingKnownProteins(knownProteinLines2, seqNum, start, end));
        }
        return ret;
    }

    private ArrayList getOverlappingKnownProteins(Hashtable knownProteinLines, int seqNum, int start, int end) {
        ArrayList<String> ret = new ArrayList<String>();
        String[] knownLoci = Utils.GetHashtableKeysString(knownProteinLines);
        int i = 0;
        while (i < knownLoci.length) {
            ArrayList lines = (ArrayList)knownProteinLines.get(knownLoci[i]);
            boolean addingThisLocus = false;
            int j = 0;
            while (lines != null && j < lines.size()) {
                String line = (String)lines.get(j);
                String[] bits = line.split("\t");
                if (bits[GFFFile.GFFColumns.FeatureType].equalsIgnoreCase("mrna")) {
                    int locusSeq = ProteogenomicUtils.getChromosomeNum(bits[GFFFile.GFFColumns.SequenceName], this.species, null);
                    int locusStart = Integer.parseInt(bits[GFFFile.GFFColumns.Start]);
                    int locusEnd = Integer.parseInt(bits[GFFFile.GFFColumns.End]);
                    if (locusSeq == seqNum && Utils.HasOverlap(start, end, locusStart, locusEnd)) {
                        addingThisLocus = true;
                        ret.add(line);
                    } else {
                        addingThisLocus = false;
                    }
                } else if (bits[GFFFile.GFFColumns.FeatureType].equalsIgnoreCase("cds") && addingThisLocus) {
                    ret.add(line);
                }
                ++j;
            }
            ++i;
        }
        return ret;
    }

    private ArrayList getOverlappingLines(int seqNum, int start, int end) {
        String seqName = ProteogenomicUtils.getChromosomeName(seqNum, this.species, this.contigNames);
        if (this.evidenceHash.containsKey(seqName)) {
            String fileName = (String)this.evidenceHash.get(seqName);
            return this.getOverlappingLines(seqNum, start, end, fileName);
        }
        ErrorThrower.ThrowWarningCustom(101, "There is no external evidence for sequence '" + seqName + "'");
        return new ArrayList();
    }

    private ArrayList getOverlappingLines(int spanSeqNum, int spanStart, int spanEnd, String fileName) {
        ArrayList<String> ret = new ArrayList<String>();
        BufferedReader buf = null;
        String line = null;
        try {
            buf = new BufferedReader(new FileReader(fileName));
            line = buf.readLine();
        }
        catch (IOException E) {
            ErrorThrower.ThrowError(5, fileName);
        }
        while (line != null) {
            if ((line = line.trim()).length() == 0 || line.charAt(0) == '#') {
                try {
                    line = buf.readLine();
                }
                catch (IOException E) {
                    ErrorThrower.ThrowError(6, fileName);
                }
                continue;
            }
            String[] bits = line.split("\t");
            int chrNum = ProteogenomicUtils.getChromosomeNum(bits[GFFFile.GFFColumns.SequenceName], this.species, this.contigNames);
            if (chrNum == spanSeqNum) {
                int start = Integer.parseInt(bits[GFFFile.GFFColumns.Start]);
                int end = Integer.parseInt(bits[GFFFile.GFFColumns.End]);
                if (start >= spanStart && end <= spanEnd) {
                    ret.add(line);
                }
            }
            try {
                line = buf.readLine();
            }
            catch (IOException E) {
                ErrorThrower.ThrowError(6, fileName);
            }
        }
        try {
            buf.close();
        }
        catch (IOException E) {
            ErrorThrower.ThrowError(8, fileName);
        }
        return ret;
    }

    private void getLocusSpans() {
        Enumeration genes = this.eventLocations.keys();
        this.spans = new Hashtable();
        while (genes.hasMoreElements()) {
            String geneName = (String)genes.nextElement();
            ArrayList lines = (ArrayList)this.eventLocations.get(geneName);
            int start = Integer.MAX_VALUE;
            int end = Integer.MIN_VALUE;
            int seqNum = -1;
            int i = 0;
            while (i < lines.size()) {
                int currEnd;
                String currLine = (String)lines.get(i);
                String[] bits = currLine.split("\t");
                int currStart = Integer.parseInt(bits[GFFFile.GFFColumns.Start]);
                if (currStart < start) {
                    start = currStart;
                }
                if ((currEnd = Integer.parseInt(bits[GFFFile.GFFColumns.End])) > end) {
                    end = currEnd;
                }
                seqNum = ProteogenomicUtils.getChromosomeNum(bits[GFFFile.GFFColumns.SequenceName], this.species, this.contigNames);
                ++i;
            }
            int[] coords = new int[]{start, end, seqNum};
            this.spans.put(geneName, coords);
        }
        System.out.println("Considering " + this.spans.size() + "  loci");
        if (this.knownProteomeGFFFileName != null) {
            genes = this.knownProteinCoords.keys();
            while (genes.hasMoreElements()) {
                String tName;
                String geneName = tName = (String)genes.nextElement();
                if (this.GFFToGeneMap != null && !this.GFFToGeneMap.containsKey(tName)) {
                    if (this.verboseMode) {
                        ErrorThrower.ThrowWarning(13, "No entry for '" + tName + "'! Using key as value");
                    }
                } else if (this.GFFToGeneMap != null) {
                    geneName = (String)this.GFFToGeneMap.get(tName);
                }
                if (!this.spans.containsKey(geneName)) continue;
                int[] coords = (int[])this.spans.get(geneName);
                String[] deets = (String[])this.knownProteinCoords.get(tName);
                int currStart = Integer.parseInt(deets[0]);
                int currEnd = Integer.parseInt(deets[1]);
                if (currStart < coords[0]) {
                    coords[0] = currStart;
                }
                if (currEnd > coords[1]) {
                    coords[1] = currEnd;
                }
                this.spans.put(geneName, coords);
            }
        }
    }

    public static Hashtable loadSequenceSummaryTable(String seqBlastFileName) {
        Hashtable<String, ArrayList> ret = new Hashtable<String, ArrayList>();
        BufferedReader buf = Utils.openBufferedReader(seqBlastFileName);
        String line = Utils.readNextLine(buf, seqBlastFileName);
        while (line != null) {
            if ((line = line.trim()).length() == 0 || line.charAt(0) == '#') {
                line = Utils.readNextLine(buf, seqBlastFileName);
                continue;
            }
            String[] bits = line.split("\t");
            String locusName = bits[0];
            ArrayList trans = null;
            trans = ret.containsKey(locusName) ? (ArrayList)ret.get(locusName) : new ArrayList();
            trans.add(line);
            ret.put(locusName, trans);
            line = Utils.readNextLine(buf, seqBlastFileName);
        }
        return ret;
    }
}

