/*
 * Decompiled with CFR 0.152.
 */
package proteogenomicUtils;

import basicUtils.GFFFile;
import basicUtils.Utils;
import errorUtils.ErrorThrower;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import proteogenomicUtils.EventFinder;
import proteogenomicUtils.GenomicLocator;

public class ClusterRescorer {
    public static final String UsageInfo = "proteogenomicUtils.ClusterRescorer\nCompute the probably of a coding region being correct based on peptide locations.\n[REQUIRED]\n -r [FILE] File containing locations (may be a cluster file) on the same sequence as the gff file\n -g [FILE] GFF file containing genes (coding regions) to predict probability\n -w [FILE] Output file\n[OPTIONAL]\n -d Run in debug mode\n -f [FILE] File containing location frequencies\n -o [FORMAT] 0:old At format, 1: new format (default)\n -t [FORMAT] 0:localFDR, 1:SpecProb (default)\n";
    private String InputFile = null;
    private String GFFFileName = null;
    private String OutputFile = null;
    public boolean Debug = false;
    private String FrequencyFile = null;
    private Hashtable Frequencies = null;
    private Hashtable CodingRegions = null;
    private Hashtable Probs = null;
    private Hashtable Peptides = null;
    private int LocationFormat = 1;
    private int ScoreFormat = 1;

    public ClusterRescorer(String InputFile, String GFFFile2, String OutputFile, String FreqFile) {
        this.InputFile = InputFile;
        this.GFFFileName = GFFFile2;
        this.OutputFile = OutputFile;
        this.FrequencyFile = FreqFile;
    }

    private void LoadPeptideFrequencies() {
        this.Frequencies = new Hashtable();
        if (this.FrequencyFile != null) {
            BufferedReader buf = null;
            String line = null;
            try {
                buf = new BufferedReader(new FileReader(this.FrequencyFile));
                line = buf.readLine();
            }
            catch (IOException E) {
                E.printStackTrace();
                ErrorThrower.ThrowError(5, this.FrequencyFile);
            }
            while (line != null) {
                if ((line = line.trim()).length() == 0 || line.charAt(0) == '#') {
                    try {
                        line = buf.readLine();
                    }
                    catch (IOException E) {
                        E.printStackTrace();
                        ErrorThrower.ThrowError(6, this.FrequencyFile);
                    }
                    continue;
                }
                String[] Bits = line.split("\t");
                if (Bits.length < 2) {
                    System.err.println("ERROR: Incorrectly formatted peptide frequency line '" + line + "'");
                    Utils.WaitForEnter();
                } else if (this.Frequencies.containsKey(Bits[0])) {
                    System.err.println("ERROR: We found two entries for peptide '" + Bits[0] + "'. Keeping only the first one.");
                    Utils.WaitForEnter();
                } else {
                    this.Frequencies.put(Bits[0], new Integer(Integer.parseInt(Bits[1])));
                }
                try {
                    line = buf.readLine();
                }
                catch (IOException E) {
                    E.printStackTrace();
                    ErrorThrower.ThrowError(6, this.FrequencyFile);
                }
            }
            try {
                buf.close();
            }
            catch (IOException E) {
                E.printStackTrace();
                ErrorThrower.ThrowError(8, this.FrequencyFile);
            }
        } else {
            BufferedReader buf = null;
            String line = null;
            try {
                buf = new BufferedReader(new FileReader(this.InputFile));
                line = buf.readLine();
            }
            catch (IOException E) {
                ErrorThrower.ThrowError(5, this.InputFile);
            }
            while (line != null) {
                if ((line = line.trim()).length() == 0 || line.charAt(0) == '#') {
                    try {
                        line = buf.readLine();
                    }
                    catch (IOException E) {
                        ErrorThrower.ThrowError(6, this.InputFile);
                    }
                    continue;
                }
                Object[] Loc = null;
                Loc = this.LocationFormat == 0 ? GenomicLocator.GenomicColumns.LoadFromOldFmtString(line) : GenomicLocator.GenomicColumns.LoadFromString(line);
                String Pep = Utils.GetUnModded((String)Loc[GenomicLocator.GenomicColumns.Peptide]);
                if (this.Frequencies.containsKey(Pep)) {
                    int Count = (Integer)this.Frequencies.get(Pep);
                    this.Frequencies.put(Pep, new Integer(Count + 1));
                } else {
                    this.Frequencies.put(Pep, new Integer(1));
                }
                try {
                    line = buf.readLine();
                }
                catch (IOException E) {
                    ErrorThrower.ThrowError(6, this.InputFile);
                }
            }
            try {
                buf.close();
            }
            catch (IOException E) {
                ErrorThrower.ThrowError(8, this.InputFile);
            }
        }
    }

    private void WriteFrequencyFile() {
        this.FrequencyFile = String.valueOf(Utils.GetFileNameNoExtension(this.OutputFile)) + "_Freq.txt";
        System.out.println("Printing peptide frequencies to " + this.FrequencyFile);
        FileWriter W = null;
        try {
            W = new FileWriter(this.FrequencyFile);
        }
        catch (IOException E) {
            ErrorThrower.ThrowError(5, this.FrequencyFile);
        }
        Enumeration Peptides = this.Frequencies.keys();
        while (Peptides.hasMoreElements()) {
            String Peptide2 = (String)Peptides.nextElement();
            int Count = (Integer)this.Frequencies.get(Peptide2);
            try {
                W.write(String.valueOf(Peptide2) + "\t" + Count + "\n");
            }
            catch (IOException E) {
                ErrorThrower.ThrowError(7, this.FrequencyFile);
            }
        }
        try {
            W.close();
        }
        catch (IOException E) {
            ErrorThrower.ThrowError(8, this.FrequencyFile);
        }
    }

    private void LoadCodingRegions() {
        this.CodingRegions = new Hashtable();
        BufferedReader buf = null;
        String line = null;
        try {
            buf = new BufferedReader(new FileReader(this.GFFFileName));
            line = buf.readLine();
        }
        catch (IOException E) {
            ErrorThrower.ThrowError(5, this.GFFFileName);
        }
        while (line != null) {
            if ((line = line.trim()).length() == 0 || line.charAt(0) == '#') {
                try {
                    line = buf.readLine();
                }
                catch (IOException E) {
                    ErrorThrower.ThrowError(6, this.GFFFileName);
                }
                continue;
            }
            String[] Bits = line.split("\t");
            if (Bits[GFFFile.GFFColumns.FeatureType].compareTo("gene") != 0) {
                try {
                    line = buf.readLine();
                }
                catch (IOException E) {
                    ErrorThrower.ThrowError(6, this.GFFFileName);
                }
                continue;
            }
            if (this.CodingRegions.containsKey(Bits[GFFFile.GFFColumns.Attributes])) {
                System.err.println("ERROR: We found two entries for gene '" + Bits[GFFFile.GFFColumns.Attributes] + "'. Keeping only the first one.");
                Utils.WaitForEnter();
            } else {
                this.CodingRegions.put(Bits[GFFFile.GFFColumns.Attributes], Bits);
            }
            try {
                line = buf.readLine();
            }
            catch (IOException E) {
                ErrorThrower.ThrowError(6, this.GFFFileName);
            }
        }
        try {
            buf.close();
        }
        catch (IOException E) {
            ErrorThrower.ThrowError(8, this.GFFFileName);
        }
    }

    private void LoadPeptideLocations() {
        this.Probs = new Hashtable();
        this.Peptides = new Hashtable();
        BufferedReader buf = null;
        String line = null;
        try {
            buf = new BufferedReader(new FileReader(this.InputFile));
            line = buf.readLine();
        }
        catch (IOException E) {
            ErrorThrower.ThrowError(5, this.InputFile);
        }
        while (line != null) {
            if ((line = line.trim()).length() == 0 || line.charAt(0) == '#') {
                try {
                    line = buf.readLine();
                }
                catch (IOException E) {
                    ErrorThrower.ThrowError(6, this.InputFile);
                }
                continue;
            }
            Object[] Loc = null;
            Loc = this.LocationFormat == 0 ? GenomicLocator.GenomicColumns.LoadFromOldFmtString(line) : GenomicLocator.GenomicColumns.LoadFromString(line);
            String Pep = Utils.GetUnModded((String)Loc[GenomicLocator.GenomicColumns.Peptide]);
            if (Loc[GenomicLocator.GenomicColumns.BestSpecProb] == null && this.ScoreFormat == 1) {
                System.out.println("We are skipping this guy cuz his spec prob is bad!");
                try {
                    line = buf.readLine();
                }
                catch (IOException E) {
                    ErrorThrower.ThrowError(6, this.InputFile);
                }
                continue;
            }
            if (this.Frequencies.containsKey(Pep)) {
                int Count = (Integer)this.Frequencies.get(Pep);
                Loc[GenomicLocator.GenomicColumns.LocationCount] = new Integer(Count);
                Loc[GenomicLocator.GenomicColumns.IsUnique] = Count == 1 ? new Boolean(true) : new Boolean(false);
                double pPSM = 0.0;
                pPSM = this.ScoreFormat == 0 ? 1.0 - (Double)Loc[GenomicLocator.GenomicColumns.BestLocalFDR] : (Double)Loc[GenomicLocator.GenomicColumns.BestSpecProb];
                double pLoc = pPSM / (double)Count;
                String Gene = this.FindOverlappingGene(Loc);
                if (Gene != null) {
                    if (this.Debug) {
                        System.out.println("Peptide overlaps gene!!");
                        System.out.println(GenomicLocator.GenomicColumns.toString(Loc, "\t"));
                        System.out.println(GFFFile.toString((String[])this.CodingRegions.get(Gene), "\t"));
                        Utils.WaitForEnter();
                    }
                    double CurrProb = 1.0;
                    if (this.Probs.containsKey(Gene)) {
                        CurrProb = (Double)this.Probs.get(Gene);
                    }
                    CurrProb = this.ScoreFormat == 0 ? (CurrProb *= 1.0 - pLoc) : (CurrProb *= pLoc);
                    this.Probs.put(Gene, CurrProb);
                    ArrayList Peps = null;
                    Peps = this.Peptides.containsKey(Gene) ? (ArrayList)this.Peptides.get(Gene) : new ArrayList();
                    Peps.add(Pep);
                    this.Peptides.put(Gene, Peps);
                }
            } else {
                System.err.println("ERROR: Unable to find count for peptide '" + (String)Loc[GenomicLocator.GenomicColumns.Peptide] + "'");
            }
            try {
                line = buf.readLine();
            }
            catch (IOException E) {
                ErrorThrower.ThrowError(6, this.InputFile);
            }
        }
        try {
            buf.close();
        }
        catch (IOException E) {
            ErrorThrower.ThrowError(8, this.InputFile);
        }
    }

    private String FindOverlappingGene(Object[] PepLocation) {
        int PepStrand = (Integer)PepLocation[GenomicLocator.GenomicColumns.Strand];
        int PepStart = (Integer)PepLocation[GenomicLocator.GenomicColumns.Start];
        int PepEnd = (Integer)PepLocation[GenomicLocator.GenomicColumns.End];
        Enumeration E = this.CodingRegions.keys();
        while (E.hasMoreElements()) {
            int GeneEnd;
            int GeneStart;
            String GeneName = (String)E.nextElement();
            String[] GFFLine = (String[])this.CodingRegions.get(GeneName);
            int GeneStrand = GFFFile.ParseStrand(GFFLine[GFFFile.GFFColumns.Strand]);
            if (GeneStrand != PepStrand || !Utils.HasOverlap(PepStart, PepEnd, GeneStart = Integer.parseInt(GFFLine[GFFFile.GFFColumns.Start]), GeneEnd = Integer.parseInt(GFFLine[GFFFile.GFFColumns.End]))) continue;
            return GeneName;
        }
        return null;
    }

    private void WriteRegionProbabilities() {
        FileWriter W = null;
        try {
            W = new FileWriter(this.OutputFile);
        }
        catch (IOException E) {
            ErrorThrower.ThrowError(5, this.OutputFile);
        }
        Enumeration E = this.CodingRegions.keys();
        while (E.hasMoreElements()) {
            String GeneName;
            String OutLine = GeneName = (String)E.nextElement();
            if (this.Probs.containsKey(GeneName)) {
                OutLine = String.valueOf(OutLine) + "\t" + (1.0 - (Double)this.Probs.get(GeneName));
            }
            if (this.Peptides.containsKey(GeneName)) {
                OutLine = String.valueOf(OutLine) + "\t";
                ArrayList Peps = (ArrayList)this.Peptides.get(GeneName);
                int i = 0;
                while (i < Peps.size()) {
                    OutLine = String.valueOf(OutLine) + (String)Peps.get(i) + ",";
                    ++i;
                }
                OutLine = String.valueOf(OutLine) + "\t" + Peps.size();
            }
            try {
                W.write(String.valueOf(OutLine) + "\n");
            }
            catch (IOException Err) {
                ErrorThrower.ThrowError(7, this.OutputFile);
            }
        }
        try {
            W.close();
        }
        catch (IOException Err) {
            ErrorThrower.ThrowError(8, this.OutputFile);
        }
    }

    private void Run() {
        this.LoadCodingRegions();
        System.out.println("Loaded " + this.CodingRegions.size() + " coding regions\n");
        this.LoadPeptideLocations();
        this.WriteRegionProbabilities();
        if (this.FrequencyFile == null) {
            this.WriteFrequencyFile();
        }
    }

    public static void main(String[] args) {
        int Val;
        String[] options = new String[]{"-r", "-w", "-g", "-d", "-f", "-o", "-t"};
        boolean[] blArray = new boolean[7];
        blArray[0] = true;
        blArray[1] = true;
        blArray[2] = true;
        blArray[4] = true;
        blArray[5] = true;
        blArray[6] = true;
        boolean[] values = blArray;
        Hashtable CommandLineArgs = Utils.ParseCommandLine(args, options, values);
        if (!(CommandLineArgs.containsKey("-r") && CommandLineArgs.containsKey("-w") && CommandLineArgs.containsKey("-g"))) {
            System.err.println(UsageInfo);
            ErrorThrower.ThrowError(2, "Must specify an input directory, output file, and coordinates file!");
        }
        String InputDir = (String)CommandLineArgs.get("-r");
        String OutputFile = (String)CommandLineArgs.get("-w");
        String CoordFile = (String)CommandLineArgs.get("-g");
        String FreqFile = null;
        if (CommandLineArgs.containsKey("-f")) {
            FreqFile = (String)CommandLineArgs.get("-f");
        }
        ClusterRescorer Runner = new ClusterRescorer(InputDir, CoordFile, OutputFile, FreqFile);
        if (CommandLineArgs.containsKey("-d")) {
            Runner.Debug = true;
        }
        if (CommandLineArgs.containsKey("-o")) {
            Runner.LocationFormat = Val = Integer.parseInt((String)CommandLineArgs.get("-o"));
        }
        if (CommandLineArgs.containsKey("-t")) {
            Runner.ScoreFormat = Val = Integer.parseInt((String)CommandLineArgs.get("-t"));
        }
        Runner.Run();
    }

    public static double GetEventProb(EventFinder.Event E) {
        boolean LocalDebug = false;
        double Ret = 1.0;
        if (LocalDebug) {
            System.out.println("attempting to score event with " + E.getSupportingLocations().size() + " locs");
        }
        int j = 0;
        while (j < E.getSupportingLocations().size()) {
            Object[] Location = (Object[])E.getSupportingLocations().get(j);
            if (Location[GenomicLocator.GenomicColumns.LocationCount] == null || Location[GenomicLocator.GenomicColumns.BestLocalFDR] == null) {
                ErrorThrower.ThrowErrorCustum(100, "Cannot score an event with a location missing a location count and local FDR!!");
            }
            double LocationCount = ((Integer)Location[GenomicLocator.GenomicColumns.LocationCount]).doubleValue();
            double LocalFDR = (Double)Location[GenomicLocator.GenomicColumns.BestLocalFDR];
            if (LocalDebug) {
                System.out.println("Loc " + j + " has " + LocationCount + " locations and " + LocalFDR + " localFDR");
            }
            Ret *= 1.0 - (1.0 - LocalFDR) / LocationCount;
            if (LocalDebug) {
                System.out.println("Updated Ret: " + Ret);
            }
            ++j;
        }
        if (LocalDebug) {
            System.out.println("Final Ret: " + (1.0 - Ret));
            Utils.WaitForEnter();
        }
        return 1.0 - Ret;
    }

    public static double GetEventProbUnique(EventFinder.Event E) {
        boolean LocalDebug = false;
        double Ret = 1.0;
        if (LocalDebug) {
            System.out.println("attempting to score event with " + E.getSupportingLocations().size() + " locs");
        }
        int j = 0;
        while (j < E.getSupportingLocations().size()) {
            Object[] Location = (Object[])E.getSupportingLocations().get(j);
            if (Location[GenomicLocator.GenomicColumns.LocationCount] == null || Location[GenomicLocator.GenomicColumns.BestLocalFDR] == null) {
                ErrorThrower.ThrowErrorCustum(100, "Cannot score an event with a location missing a location count and local FDR!!");
            }
            double LocationCount = ((Integer)Location[GenomicLocator.GenomicColumns.LocationCount]).doubleValue();
            double LocalFDR = (Double)Location[GenomicLocator.GenomicColumns.BestLocalFDR];
            if (LocalDebug) {
                System.out.println("Loc " + j + " has " + LocationCount + " locations and " + LocalFDR + " localFDR");
            }
            if (!(LocationCount > 1.0)) {
                Ret *= 1.0 - (1.0 - LocalFDR) / LocationCount;
                if (LocalDebug) {
                    System.out.println("Updated Ret: " + Ret);
                }
            }
            ++j;
        }
        if (LocalDebug) {
            System.out.println("Final Ret: " + (1.0 - Ret));
            Utils.WaitForEnter();
        }
        return 1.0 - Ret;
    }

    public static double GetEventProbShared(EventFinder.Event E) {
        boolean LocalDebug = false;
        double bestSharedLocationCount = -1.0;
        double bestSharedLocalFDR = Double.MAX_VALUE;
        double Ret = 1.0;
        if (LocalDebug) {
            System.out.println("attempting to score event with " + E.getSupportingLocations().size() + " locs");
        }
        int j = 0;
        while (j < E.getSupportingLocations().size()) {
            Object[] Location = (Object[])E.getSupportingLocations().get(j);
            if (Location[GenomicLocator.GenomicColumns.LocationCount] == null || Location[GenomicLocator.GenomicColumns.BestLocalFDR] == null) {
                ErrorThrower.ThrowErrorCustum(100, "Cannot score an event with a location missing a location count and local FDR!!");
            }
            double LocationCount = ((Integer)Location[GenomicLocator.GenomicColumns.LocationCount]).doubleValue();
            double LocalFDR = (Double)Location[GenomicLocator.GenomicColumns.BestLocalFDR];
            if (LocalDebug) {
                System.out.println("Loc " + j + " has " + LocationCount + " locations and " + LocalFDR + " localFDR");
            }
            if (LocationCount > 1.0) {
                if (LocalFDR < bestSharedLocalFDR) {
                    bestSharedLocalFDR = LocalFDR;
                    bestSharedLocationCount = LocationCount;
                }
            } else {
                Ret *= 1.0 - (1.0 - LocalFDR) / LocationCount;
                if (LocalDebug) {
                    System.out.println("Updated Ret: " + Ret);
                }
            }
            ++j;
        }
        if (LocalDebug) {
            System.out.println("Final Ret: " + (1.0 - Ret));
            Utils.WaitForEnter();
        }
        if (bestSharedLocationCount != -1.0) {
            Ret *= 1.0 - (1.0 - bestSharedLocalFDR) / bestSharedLocationCount;
        }
        return 1.0 - Ret;
    }
}

