/*
 * Decompiled with CFR 0.152.
 */
package proteogenomicUtils;

import basicUtils.InspectAnnotation;
import basicUtils.Utils;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Hashtable;

public class ComputeDeltaKnown {
    public static final String UsageInfo = "proteogenomicUtils.ComputeDeltaKnown, version 2010.08.03\nThis program takes a file of Inspect results and computes the DeltaKnown and DeltaKnownAnn.  Assumes MSGF has been run.\n[REQUIRED]\n -r [FILE] An Inspect results file (pre PValue.java)\n -w [FILE] An output file name for the peptides\n[OPTIONAL]\n -d Run in debug mode\n";
    private String InputFileName = null;
    private String OutputFileName = null;
    public boolean Debug = false;
    private Hashtable BestKnownHash = null;

    public ComputeDeltaKnown(String InputFile, String OutputFile) {
        this.InputFileName = InputFile;
        this.OutputFileName = OutputFile;
        this.BestKnownHash = new Hashtable();
    }

    public void Run() {
        this.PopulateKnownHashAndWriteResults();
    }

    private void PopulateKnownHashAndWriteResults() {
        System.out.println("Loading inspect results...");
        InspectAnnotation[] Anns = InspectAnnotation.LoadInspectResultsFile(this.InputFileName);
        System.out.println("Computing best known for each spectrum...");
        int i = 0;
        while (i < Anns.length) {
            if (!Anns[i].IsNovel) {
                Object[] Best;
                String HashKey = String.valueOf(Utils.GetBaseName(Anns[i].SpectrumFile)) + "_" + Anns[i].ScanNumber;
                if (!this.BestKnownHash.containsKey(HashKey)) {
                    Best = new Object[4];
                    Best[0] = new Double(Anns[i].SpecProb);
                    Best[1] = Anns[i].Annotation;
                    this.BestKnownHash.put(HashKey, Best);
                    if (this.Debug) {
                        System.out.println("First Best for " + HashKey + " : " + Anns[i].Annotation + " == " + Anns[i].SpecProb);
                    }
                } else {
                    Best = (Object[])this.BestKnownHash.get(HashKey);
                    double OldScore = (Double)Best[0];
                    if (OldScore > Anns[i].SpecProb) {
                        Best[2] = Best[0];
                        Best[3] = Best[1];
                        Best[0] = new Double(Anns[i].SpecProb);
                        Best[1] = Anns[i].Annotation;
                        this.BestKnownHash.put(HashKey, Best);
                        if (this.Debug) {
                            System.out.println("New Best for " + HashKey + " : " + Anns[i].Annotation + " == " + Anns[i].SpecProb);
                            System.out.println("Old Best (now second) " + (Double)Best[2] + " == " + (String)Best[3]);
                        }
                    } else if (Best[2] == null) {
                        Best[2] = new Double(Anns[i].SpecProb);
                        Best[3] = Anns[i].Annotation;
                        this.BestKnownHash.put(HashKey, Best);
                        if (this.Debug) {
                            System.out.println("New Second Best for " + HashKey + " : " + Anns[i].Annotation + " == " + Anns[i].SpecProb);
                            System.out.println("Best " + (Double)Best[0] + " == " + (String)Best[1]);
                        }
                    } else {
                        double SecondBest = (Double)Best[2];
                        if (SecondBest > Anns[i].SpecProb) {
                            Best[2] = new Double(Anns[i].SpecProb);
                            Best[3] = Anns[i].Annotation;
                            this.BestKnownHash.put(HashKey, Best);
                            if (this.Debug) {
                                System.out.println("New Second Best for " + HashKey + " : " + Anns[i].Annotation + " == " + Anns[i].SpecProb);
                                System.out.println("Best " + (Double)Best[0] + " == " + (String)Best[1]);
                            }
                        }
                    }
                }
            }
            ++i;
        }
        System.out.println("Writing updated results...");
        FileWriter f = null;
        try {
            f = new FileWriter(this.OutputFileName);
        }
        catch (IOException E) {
            E.printStackTrace();
            System.exit(-1);
        }
        int InfinityCountKnown = 0;
        int InfinityCountNovel = 0;
        int i2 = 0;
        while (i2 < Anns.length) {
            block31: {
                block34: {
                    String BestAnn;
                    double BestScore;
                    String HashKey;
                    block32: {
                        Object[] Best;
                        block33: {
                            block30: {
                                HashKey = String.valueOf(Utils.GetBaseName(Anns[i2].SpectrumFile)) + "_" + Anns[i2].ScanNumber;
                                if (this.BestKnownHash.containsKey(HashKey)) break block30;
                                Anns[i2].DeltaKnown = Double.POSITIVE_INFINITY;
                                Anns[i2].DeltaKnownAnn = null;
                                ++InfinityCountNovel;
                                if (this.Debug) {
                                    System.out.println("No Known Best for " + HashKey + " : " + Anns[i2].Annotation + " == " + Anns[i2].SpecProb);
                                }
                                try {
                                    f.write(String.valueOf(Anns[i2].toString()) + "\n");
                                }
                                catch (IOException E) {
                                    E.printStackTrace();
                                    System.exit(-1);
                                }
                                break block31;
                            }
                            Best = (Object[])this.BestKnownHash.get(HashKey);
                            BestScore = (Double)Best[0];
                            BestAnn = (String)Best[1];
                            if (Anns[i2].IsNovel || Anns[i2].SpecProb != BestScore || Anns[i2].Annotation.compareTo(BestAnn) != 0) break block32;
                            if (Best[2] != null) break block33;
                            if (this.Debug) {
                                System.out.println("Observing Best for " + HashKey + " : " + Anns[i2].Annotation + " == " + Anns[i2].SpecProb);
                                System.out.println("No second best!");
                            }
                            Anns[i2].DeltaKnown = Double.POSITIVE_INFINITY;
                            Anns[i2].DeltaKnownAnn = null;
                            if (Anns[i2].IsNovel) {
                                ++InfinityCountNovel;
                            } else {
                                ++InfinityCountKnown;
                            }
                            try {
                                f.write(String.valueOf(Anns[i2].toString()) + "\n");
                            }
                            catch (IOException E) {
                                E.printStackTrace();
                                System.exit(-1);
                            }
                            break block31;
                        }
                        double SecondBestScore = (Double)Best[2];
                        String SecondBestAnn = (String)Best[3];
                        Anns[i2].DeltaKnown = this.ComputeDeltaKnownValue(SecondBestScore, Anns[i2].SpecProb);
                        Anns[i2].DeltaKnownAnn = SecondBestAnn;
                        if (this.Debug) {
                            System.out.println("Observing Best for " + HashKey + " : " + Anns[i2].Annotation + " == " + Anns[i2].SpecProb);
                            System.out.println("Second best " + SecondBestAnn + " == " + SecondBestScore);
                            System.out.println("DeltaKnown: " + Anns[i2].DeltaKnown);
                        }
                        break block34;
                    }
                    Anns[i2].DeltaKnown = this.ComputeDeltaKnownValue(BestScore, Anns[i2].SpecProb);
                    Anns[i2].DeltaKnownAnn = BestAnn;
                    if (this.Debug) {
                        System.out.println("Observing NOT best for " + HashKey + " : " + Anns[i2].Annotation + " == " + Anns[i2].SpecProb);
                        System.out.println("Bestest " + BestAnn + " == " + BestScore);
                        System.out.println("DeltaKnown: " + Anns[i2].DeltaKnown);
                    }
                }
                try {
                    f.write(String.valueOf(Anns[i2].toString()) + "\n");
                }
                catch (IOException E) {
                    E.printStackTrace();
                    System.exit(-1);
                }
            }
            ++i2;
        }
        try {
            f.close();
        }
        catch (IOException E) {
            E.printStackTrace();
            System.exit(-1);
        }
        System.out.println("Novel Infinity Counts: " + InfinityCountNovel);
        System.out.println("Known Infinity Counts: " + InfinityCountKnown);
    }

    public double ComputeDeltaKnownValue(double BestKnownSpecProb, double CurrSpecProb) {
        return Math.log10(BestKnownSpecProb / CurrSpecProb);
    }

    public static void main(String[] args) {
        String[] options = new String[]{"-r", "-w", "-d", "-h"};
        boolean[] blArray = new boolean[4];
        blArray[0] = true;
        blArray[1] = true;
        blArray[3] = true;
        boolean[] values = blArray;
        Hashtable CommandLineArgs = Utils.ParseCommandLine(args, options, values);
        if (!CommandLineArgs.containsKey("-r") || !CommandLineArgs.containsKey("-w")) {
            System.err.println("ERROR: Missing arguments!");
            System.out.println(UsageInfo);
            System.exit(-1);
        }
        String InputFile = (String)CommandLineArgs.get("-r");
        String OutputFile = (String)CommandLineArgs.get("-w");
        if (!Utils.IsFile(InputFile)) {
            System.err.println("ERROR: Invalid input file name '" + InputFile + "'!");
            System.out.println(UsageInfo);
            System.exit(-1);
        }
        ComputeDeltaKnown c = new ComputeDeltaKnown(InputFile, OutputFile);
        if (CommandLineArgs.containsKey("-d")) {
            c.Debug = true;
        }
        c.Run();
    }
}

