/*
 * Decompiled with CFR 0.152.
 */
package proteogenomicUtils;

import basicUtils.ChooseProteins;
import basicUtils.GFFFile;
import basicUtils.Utils;
import errorUtils.ErrorThrower;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import proteogenomicUtils.ProteogenomicUtils;
import trieUtils.TrieDB;

public class CreatePeptideGFF {
    public static String usageInfo = "proteogenomicUtils.CreatePeptideGFF version 2012.01.12\nAccepts any tab delimited file containing peptides, and creates a GFF file\nusing the locations of known genes\nASSUMPTIONS:\n 1.  The peptides contain only modifications of the form +NUM, or -NUM.  Flanking amino acids\n     are ignored (e.g. only XXXXX is used in A.XXXXX.B)\n 2.  The protein name contains no spaces, and is the first contiguous set of characters in the \n     header (e.g. in '>GRMZM2G005939_P01 This is my protein', only GRMZM2G005939_P01 is the protein name\n 3.  In the GFF file, features of type CDS are considered.  The protein for each CDS is determined from the\n     attributes column (e.g. Parent=GRMZM2G005939_P01).  If no parent is given, then it considers the Name, \n     and finally the ID\nUsage:\n-r [FILE/DIR] File or directory containing tab delimited files of peptides\n or\n-i [FILE] Selected protein file.  In this case we map only peptides from selected genes\n-c [NUM] The number of the column containing the peptide (0 is the first column)\n-p [FILE] FASTA or Trie file containing protein sequences\n-g [FILE] The GFF file containing the coordinates of the proteins\n-o [FILE] The output GFF file to create\n(-t [FILE] A file containing conversions from FASTA file protein names to GFF file protein names)\n(-q [NUM] The column of the FASTA gene name in the conversions file (default is 3)\n(-d [NUM] The column of the GFF gene name in the conversions file (default is 2)\n(-v Run in verbose mode)\n";
    private int FASTANameCol = 3;
    private int GFFNameCol = 2;
    private String gffFileName;
    private Hashtable FASTA2GFFProteinName = null;
    private TrieDB trieFile;
    private String[] peptideFileNames;
    private int column;
    private String outputGFF;
    private String translationFile;
    private boolean debug = false;
    private String chosenProteinFileName;

    public CreatePeptideGFF(String inputDir, int column, String proteaseFile, String gffFile, String outputFile, String translationFile, String chosenProteinFile) {
        if (inputDir == null && chosenProteinFile == null) {
            ErrorThrower.ThrowErrorCustum(100, "Must specify either an input file/dir of peptide ids or a chosen protein file");
        }
        if (inputDir != null && Utils.IsDir(inputDir)) {
            this.peptideFileNames = Utils.ListDir(inputDir);
        } else if (inputDir != null && Utils.IsFile(inputDir)) {
            this.peptideFileNames = new String[1];
            this.peptideFileNames[0] = inputDir;
        } else if (inputDir != null) {
            ErrorThrower.ThrowError(1, inputDir);
        }
        if (chosenProteinFile != null && !Utils.IsFile(chosenProteinFile)) {
            ErrorThrower.ThrowError(1, chosenProteinFile);
        } else if (chosenProteinFile != null) {
            this.chosenProteinFileName = chosenProteinFile;
        }
        if (column < 0) {
            ErrorThrower.ThrowError(4, "Column must be non-negative");
        }
        this.column = column;
        String ext = Utils.GetFileExtension(proteaseFile);
        if (ext.compareTo(".trie") == 0) {
            this.trieFile = new TrieDB(proteaseFile);
        } else if (ext.toLowerCase().compareTo(".fasta") == 0 || ext.toLowerCase().compareTo(".fa") == 0) {
            String trieFileName = String.valueOf(Utils.GetFileNameNoExtension(proteaseFile)) + ".trie";
            TrieDB.prepDB(proteaseFile, trieFileName);
            this.trieFile = new TrieDB(trieFileName);
        } else {
            ErrorThrower.ThrowError(1, proteaseFile);
        }
        if (Utils.IsFile(gffFile)) {
            this.gffFileName = gffFile;
        } else {
            ErrorThrower.ThrowError(1, gffFile);
        }
        this.outputGFF = outputFile;
        if (translationFile != null && !Utils.IsFile(translationFile)) {
            ErrorThrower.ThrowError(1, translationFile);
        }
        this.translationFile = translationFile;
    }

    public Hashtable getPepCoordsOnProtein(String[] peptides) {
        Hashtable<String, String[]> protein2Peptides = new Hashtable<String, String[]>();
        Hashtable allLocations = this.trieFile.GetAllLocations(peptides);
        boolean localDebug = false;
        Enumeration peps = allLocations.keys();
        while (peps.hasMoreElements()) {
            String currPep = (String)peps.nextElement();
            ArrayList locs = (ArrayList)allLocations.get(currPep);
            int i = 0;
            while (i < locs.size()) {
                Object[] currLoc = (Object[])locs.get(i);
                int position = (Integer)currLoc[2];
                String pName = ((String)currLoc[3]).split(" ")[0];
                pName = pName.toLowerCase();
                if (position < 0) {
                    ErrorThrower.ThrowErrorCustum(100, "Invalid start position '" + position + "' of peptide '" + currPep + "' in protein '" + pName);
                }
                String tName = pName;
                if (this.FASTA2GFFProteinName != null && this.FASTA2GFFProteinName.containsKey(pName)) {
                    tName = (String)this.FASTA2GFFProteinName.get(pName);
                }
                if (localDebug) {
                    System.out.println(String.valueOf(pName) + "->" + tName);
                }
                String[] data = null;
                if (protein2Peptides.containsKey(tName)) {
                    data = (String[])protein2Peptides.get(tName);
                } else {
                    data = new String[4];
                    int q = 0;
                    while (q < data.length) {
                        data[q] = "";
                        ++q;
                    }
                }
                if (locs.size() == 1) {
                    data[0] = String.valueOf(data[0]) + currPep + ",";
                    data[1] = String.valueOf(data[1]) + position + "-" + (position + currPep.length()) + ",";
                } else {
                    data[2] = String.valueOf(data[2]) + currPep + ",";
                    data[3] = String.valueOf(data[3]) + position + "-" + (position + currPep.length()) + ",";
                }
                protein2Peptides.put(tName.toLowerCase(), data);
                ++i;
            }
        }
        return protein2Peptides;
    }

    public Hashtable getPeptideGenomicCoords(String[] peptideSeqs) {
        Hashtable protein2Peptides = this.getPepCoordsOnProtein(peptideSeqs);
        if (this.debug) {
            System.out.println("Loaded peptide coords on proteins ...");
        }
        Hashtable h = GFFFile.getPeptideCoords(protein2Peptides, this.gffFileName);
        if (this.debug) {
            System.out.println("Loaded genomic coords...");
        }
        Hashtable GFFProt2SeqAndStrand = GFFFile.getProteinCoords(protein2Peptides.keySet(), this.gffFileName, false);
        if (this.debug) {
            System.out.println("Loaded strand and seq info for protiens ...");
        }
        Hashtable<String, String[]> ret = new Hashtable<String, String[]>();
        String[] tNames = Utils.GetHashtableKeysString(h);
        boolean localDebug = false;
        int i = 0;
        while (i < tNames.length) {
            int aaLength;
            int ntLength;
            int k;
            int pepIndex;
            int suffix;
            int prefix;
            int prevEnd;
            int start;
            String[] s;
            String splices;
            String spliceSeq;
            String[] protInfo = (String[])GFFProt2SeqAndStrand.get(tNames[i]);
            String[] pepInfo = (String[])h.get(tNames[i]);
            String[] peptides = pepInfo[0].split(",");
            String[] pepCoords = pepInfo[1].split(",");
            if (localDebug) {
                System.out.println("looking at " + tNames[i]);
                int j = 0;
                while (j < pepInfo.length) {
                    System.out.println("pepInfo[" + j + "]=" + pepInfo[j]);
                    ++j;
                }
            }
            String[] newPepInfo = new String[10];
            newPepInfo[0] = pepInfo[0];
            int j = 1;
            while (j < newPepInfo.length) {
                newPepInfo[j] = "";
                ++j;
            }
            newPepInfo[8] = protInfo[3];
            newPepInfo[9] = protInfo[2];
            j = 0;
            while (j < peptides.length) {
                if (peptides[j].length() != 0) {
                    if (localDebug) {
                        System.out.println("CurrPep: " + peptides[j]);
                        System.out.println("Coords: " + pepCoords[j]);
                    }
                    spliceSeq = "";
                    splices = "";
                    s = pepCoords[j].split(";");
                    if (s.length == 1) {
                        spliceSeq = peptides[j];
                        splices = "*";
                        if (localDebug) {
                            System.out.println("No splicing!!");
                        }
                    } else {
                        if (localDebug) {
                            System.out.println("There are splices!!");
                        }
                        start = Integer.parseInt(s[0].split("-")[0]);
                        prevEnd = Integer.parseInt(s[0].split("-")[1]);
                        prefix = 0;
                        suffix = 0;
                        pepIndex = (prevEnd - start) / 3;
                        if (localDebug) {
                            System.out.println("This exon claims " + pepIndex + " aas");
                        }
                        if (pepInfo[4].equals("1")) {
                            suffix = (prevEnd - start) % 3;
                            spliceSeq = String.valueOf(spliceSeq) + peptides[j].substring(0, pepIndex);
                            if (suffix == 0) {
                                spliceSeq = String.valueOf(spliceSeq) + ":";
                            } else {
                                spliceSeq = String.valueOf(spliceSeq) + ";" + peptides[j].charAt(pepIndex) + ";";
                                ++pepIndex;
                            }
                        } else {
                            prefix = (prevEnd - start) % 3;
                            pepIndex = peptides[j].length() - pepIndex;
                            if (localDebug) {
                                System.out.println("seq starts at index " + pepIndex);
                            }
                            spliceSeq = peptides[j].substring(pepIndex);
                            --pepIndex;
                            if (prefix == 0) {
                                spliceSeq = ":" + spliceSeq;
                            } else {
                                spliceSeq = ";" + peptides[j].charAt(pepIndex) + ";" + spliceSeq;
                                --pepIndex;
                            }
                        }
                        k = 1;
                        while (k < s.length) {
                            start = Integer.parseInt(s[k].split("-")[0]);
                            if (pepInfo[4].equals("1")) {
                                splices = String.valueOf(splices) + prevEnd + "-" + start + " ";
                                prefix = (3 - suffix) % 3;
                            } else {
                                splices = String.valueOf(splices) + start + "-" + prevEnd + " ";
                                suffix = (3 - prefix) % 3;
                            }
                            prevEnd = Integer.parseInt(s[k].split("-")[1]);
                            ntLength = prevEnd - start;
                            if (pepInfo[4].equals("1")) {
                                suffix = (ntLength - prefix) % 3;
                            } else {
                                prefix = (ntLength - suffix) % 3;
                            }
                            aaLength = (ntLength - suffix - prefix) / 3;
                            while (aaLength > 0) {
                                if (pepInfo[4].equals("1")) {
                                    spliceSeq = String.valueOf(spliceSeq) + peptides[j].charAt(pepIndex);
                                    ++pepIndex;
                                } else {
                                    spliceSeq = String.valueOf(peptides[j].charAt(pepIndex)) + spliceSeq;
                                    --pepIndex;
                                }
                                --aaLength;
                            }
                            ++k;
                        }
                    }
                    if (localDebug) {
                        System.out.println(spliceSeq);
                        System.out.println(pepCoords[j]);
                        System.out.println(splices.trim());
                        Utils.WaitForEnter();
                    }
                    newPepInfo[1] = String.valueOf(newPepInfo[1]) + spliceSeq + ",";
                    newPepInfo[2] = String.valueOf(newPepInfo[2]) + pepCoords[j] + ",";
                    newPepInfo[3] = String.valueOf(newPepInfo[3]) + splices.trim() + ",";
                }
                ++j;
            }
            newPepInfo[1] = newPepInfo[1].substring(0, Math.max(0, newPepInfo[1].length() - 1));
            newPepInfo[2] = newPepInfo[2].substring(0, Math.max(0, newPepInfo[2].length() - 1));
            newPepInfo[3] = newPepInfo[3].substring(0, Math.max(0, newPepInfo[3].length() - 1));
            if (pepInfo[2].length() > 0) {
                peptides = pepInfo[2].split(",");
                pepCoords = pepInfo[3].split(",");
                newPepInfo[4] = pepInfo[2];
                j = 0;
                while (j < peptides.length) {
                    if (localDebug) {
                        System.out.println("CurrPep: " + peptides[j]);
                        System.out.println("Coords: " + pepCoords[j]);
                    }
                    spliceSeq = "";
                    splices = "";
                    s = pepCoords[j].split(";");
                    if (s.length == 1) {
                        spliceSeq = peptides[j];
                        splices = "*";
                    } else {
                        start = Integer.parseInt(s[0].split("-")[0]);
                        prevEnd = Integer.parseInt(s[0].split("-")[1]);
                        prefix = 0;
                        suffix = 0;
                        pepIndex = (prevEnd - start) / 3;
                        if (pepInfo[4].equals("1")) {
                            suffix = (prevEnd - start) % 3;
                            spliceSeq = String.valueOf(spliceSeq) + peptides[j].substring(0, pepIndex);
                            if (suffix == 0) {
                                spliceSeq = String.valueOf(spliceSeq) + ":";
                            } else {
                                spliceSeq = String.valueOf(spliceSeq) + ";" + peptides[j].charAt(pepIndex) + ";";
                                ++pepIndex;
                            }
                        } else {
                            prefix = (prevEnd - start) % 3;
                            pepIndex = peptides[j].length() - pepIndex;
                            spliceSeq = peptides[j].substring(pepIndex);
                            --pepIndex;
                            if (prefix == 0) {
                                spliceSeq = ":" + spliceSeq;
                            } else {
                                spliceSeq = ";" + peptides[j].charAt(pepIndex) + ";" + spliceSeq;
                                --pepIndex;
                            }
                        }
                        k = 1;
                        while (k < s.length) {
                            start = Integer.parseInt(s[k].split("-")[0]);
                            if (pepInfo[4].equals("1")) {
                                splices = String.valueOf(splices) + prevEnd + "-" + start + " ";
                                prefix = (3 - suffix) % 3;
                            } else {
                                splices = String.valueOf(splices) + start + "-" + prevEnd + " ";
                                suffix = (3 - prefix) % 3;
                            }
                            prevEnd = Integer.parseInt(s[k].split("-")[1]);
                            ntLength = prevEnd - start;
                            if (pepInfo[4].equals("1")) {
                                suffix = (ntLength - prefix) % 3;
                            } else {
                                prefix = (ntLength - suffix) % 3;
                            }
                            aaLength = (ntLength - suffix - prefix) / 3;
                            while (aaLength > 0) {
                                if (pepInfo[4].equals("1")) {
                                    spliceSeq = String.valueOf(spliceSeq) + peptides[j].charAt(pepIndex);
                                    ++pepIndex;
                                } else {
                                    spliceSeq = String.valueOf(peptides[j].charAt(pepIndex)) + spliceSeq;
                                    --pepIndex;
                                }
                                --aaLength;
                            }
                            ++k;
                        }
                    }
                    newPepInfo[5] = String.valueOf(newPepInfo[5]) + spliceSeq + ",";
                    newPepInfo[6] = String.valueOf(newPepInfo[6]) + pepCoords[j] + ",";
                    newPepInfo[7] = String.valueOf(newPepInfo[7]) + splices.trim() + ",";
                    ++j;
                }
                newPepInfo[5] = newPepInfo[5].substring(0, Math.max(0, newPepInfo[5].length() - 1));
                newPepInfo[6] = newPepInfo[6].substring(0, Math.max(0, newPepInfo[6].length() - 1));
                newPepInfo[7] = newPepInfo[7].substring(0, Math.max(0, newPepInfo[7].length() - 1));
            }
            ret.put(tNames[i], newPepInfo);
            ++i;
        }
        return ret;
    }

    public void writeGFFFile(Hashtable peptideInfo, String outputGFF) {
        if (this.debug) {
            System.out.println("Writing GFF file ...");
        }
        Enumeration e = peptideInfo.keys();
        FileWriter f = null;
        boolean localDebug = false;
        try {
            f = new FileWriter(outputGFF);
        }
        catch (Exception E) {
            ErrorThrower.ThrowError(5, outputGFF);
        }
        while (e.hasMoreElements()) {
            String tName = (String)e.nextElement();
            String[] pepInfo = (String[])peptideInfo.get(tName);
            String[] uniquePeptides = pepInfo[0].split(",");
            String[] uniqueSplicedSeqs = pepInfo[1].split(",");
            String[] uniquePepCoords = pepInfo[2].split(",");
            String[] uniqueSplices = pepInfo[3].split(",");
            String seqName = pepInfo[8];
            String strand = pepInfo[9];
            String gffLines = "";
            int i = 0;
            while (i < uniquePeptides.length) {
                if (uniquePeptides[i].length() != 0) {
                    String[] translatedRegion = uniquePepCoords[i].split(";");
                    String[] firstRegion = translatedRegion[0].split("-");
                    String[] lastRegion = translatedRegion[translatedRegion.length - 1].split("-");
                    int start = Integer.parseInt(firstRegion[0]) + 1;
                    String end = lastRegion[1];
                    if (uniqueSplices[i].equals("*")) {
                        gffLines = String.valueOf(gffLines) + seqName + "\tCreatePeptideGFF\tPeptide\t" + start + "\t" + end + "\tN/A\t" + strand + "\t0\t" + "ID=" + tName + ".0." + i + ";Parent=" + tName + ";Peptide=" + uniquePeptides[i] + ";Unique=true;FragIndex=1;TotalFrags=1\n";
                    } else {
                        String[] splices = uniqueSplices[i].split(" ");
                        int prevEnd = start;
                        int prevStart = Integer.parseInt(end);
                        int prefix = 0;
                        int suffix = 0;
                        int j = 0;
                        while (j < splices.length) {
                            String sStart = splices[j].split("-")[0];
                            String sEnd = splices[j].split("-")[1];
                            if (GFFFile.ParseStrand(strand) == 1) {
                                suffix = (Integer.parseInt(sStart) - prevEnd + prefix) % 3;
                                gffLines = String.valueOf(gffLines) + seqName + "\tCreatePeptideGFF\tPeptide\t" + prevEnd + "\t" + sStart + "\tN/A\t" + strand + "\t" + prefix + "\t" + "ID=" + tName + ".0." + i + ";Parent=" + tName + ";Peptide=" + uniquePeptides[i] + ";Unique=true;FragIndex=" + (j + 1) + ";TotalFrags=" + (splices.length + 1) + "\n";
                                prefix = (3 - suffix) % 3;
                                prevEnd = Integer.parseInt(sEnd) + 1;
                            } else {
                                prefix = (prevStart - Integer.parseInt(sStart) - suffix) % 3;
                                gffLines = String.valueOf(gffLines) + seqName + "\tCreatePeptideGFF\tPeptide\t" + (Integer.parseInt(sStart) + 1) + "\t" + prevStart + "\tN/A\t" + strand + "\t" + prefix + "\t" + "ID=" + tName + ".0." + i + ";Parent=" + tName + ";Peptide=" + uniquePeptides[i] + ";Unique=true;FragIndex=" + (j + 1) + ";TotalFrags=" + (splices.length + 1) + "\n";
                                suffix = (3 - prefix) % 3;
                                prevStart = Integer.parseInt(sEnd);
                            }
                            ++j;
                        }
                        gffLines = GFFFile.ParseStrand(strand) == 1 ? String.valueOf(gffLines) + seqName + "\tCreatePeptideGFF\tPeptide\t" + prevEnd + "\t" + end + "\tN/A\t" + strand + "\t" + prefix + "\t" + "ID=" + tName + ".0." + i + ";Parent=" + tName + ";Peptide=" + uniquePeptides[i] + ";Unique=true;FragIndex=" + (splices.length + 1) + ";TotalFrags=" + (splices.length + 1) + "\n" : String.valueOf(gffLines) + seqName + "\tCreatePeptideGFF\tPeptide\t" + start + "\t" + prevStart + "\tN/A\t" + strand + "\t" + prefix + "\t" + "ID=" + tName + ".0." + i + ";Parent=" + tName + ";Peptide=" + uniquePeptides[i] + ";Unique=true;FragIndex=" + (splices.length + 1) + ";TotalFrags=" + (splices.length + 1) + "\n";
                    }
                }
                ++i;
            }
            String[] sharedPeptides = pepInfo[4].split(",");
            String[] sharedSplicedSeqs = pepInfo[5].split(",");
            String[] sharedPepCoords = pepInfo[6].split(",");
            String[] sharedSplices = pepInfo[7].split(",");
            int i2 = 0;
            while (i2 < sharedPeptides.length) {
                if (sharedPeptides[i2].length() != 0) {
                    String[] translatedRegion = sharedPepCoords[i2].split(";");
                    String[] firstRegion = translatedRegion[0].split("-");
                    String[] lastRegion = translatedRegion[translatedRegion.length - 1].split("-");
                    int start = Integer.parseInt(firstRegion[0]) + 1;
                    String end = lastRegion[1];
                    if (sharedSplices[i2].equals("*")) {
                        gffLines = String.valueOf(gffLines) + seqName + "\tCreatePeptideGFF\tPeptide\t" + start + "\t" + end + "\tN/A\t" + strand + "\t0\t" + "ID=" + tName + ".1." + i2 + ";Parent=" + tName + ";Peptide=" + sharedPeptides[i2] + ";Unique=false;FragIndex=1;TotalFrags=1\n";
                    } else {
                        String[] splices = sharedSplices[i2].split(" ");
                        int prevEnd = start;
                        int prevStart = Integer.parseInt(end);
                        int prefix = 0;
                        int suffix = 0;
                        int j = 0;
                        while (j < splices.length) {
                            String sStart = splices[j].split("-")[0];
                            String sEnd = splices[j].split("-")[1];
                            if (GFFFile.ParseStrand(strand) == 1) {
                                suffix = (Integer.parseInt(sStart) - prevEnd + prefix) % 3;
                                gffLines = String.valueOf(gffLines) + seqName + "\tCreatePeptideGFF\tPeptide\t" + prevEnd + "\t" + sStart + "\tN/A\t" + strand + "\t" + prefix + "\t" + "ID=" + tName + ".1." + i2 + ";Parent=" + tName + ";Peptide=" + sharedPeptides[i2] + ";Unique=false;FragIndex=" + (j + 1) + ";TotalFrags=" + (splices.length + 1) + "\n";
                                prefix = (3 - suffix) % 3;
                                prevEnd = Integer.parseInt(sEnd) + 1;
                            } else {
                                prefix = (prevStart - Integer.parseInt(sStart) - suffix) % 3;
                                gffLines = String.valueOf(gffLines) + seqName + "\tCreatePeptideGFF\tPeptide\t" + (Integer.parseInt(sStart) + 1) + "\t" + prevStart + "\tN/A\t" + strand + "\t" + prefix + "\t" + "ID=" + tName + ".1." + i2 + ";Parent=" + tName + ";Peptide=" + sharedPeptides[i2] + ";Unique=false;FragIndex=" + (j + 1) + ";TotalFrags=" + (splices.length + 1) + "\n";
                                suffix = (3 - prefix) % 3;
                                prevStart = Integer.parseInt(sEnd);
                            }
                            ++j;
                        }
                        gffLines = GFFFile.ParseStrand(strand) == 1 ? String.valueOf(gffLines) + seqName + "\tCreatePeptideGFF\tPeptide\t" + prevEnd + "\t" + end + "\tN/A\t" + strand + "\t0\t" + "ID=" + tName + ".1." + i2 + ";Parent=" + tName + ";Peptide=" + sharedPeptides[i2] + ";Unique=false;FragIndex=" + (splices.length + 1) + ";TotalFrags=" + (splices.length + 1) + "\n" : String.valueOf(gffLines) + seqName + "\tCreatePeptideGFF\tPeptide\t" + start + "\t" + prevStart + "\tN/A\t" + strand + "\t0\t" + "ID=" + tName + ".1." + i2 + ";Parent=" + tName + ";Peptide=" + sharedPeptides[i2] + ";Unique=false;FragIndex=" + (splices.length + 1) + ";TotalFrags=" + (splices.length + 1) + "\n";
                    }
                }
                ++i2;
            }
            if (localDebug) {
                System.out.println(gffLines);
            }
            try {
                f.write(gffLines);
            }
            catch (IOException E) {
                ErrorThrower.ThrowError(7, outputGFF);
            }
        }
        try {
            f.close();
        }
        catch (IOException E) {
            ErrorThrower.ThrowError(8, outputGFF);
        }
    }

    public static void main(String[] args) {
        int col;
        String[] options = new String[]{"-r", "-c", "-p", "-g", "-t", "-o", "-q", "-d", "-v", "-i"};
        boolean[] blArray = new boolean[10];
        blArray[0] = true;
        blArray[1] = true;
        blArray[2] = true;
        blArray[3] = true;
        blArray[4] = true;
        blArray[5] = true;
        blArray[6] = true;
        blArray[7] = true;
        blArray[9] = true;
        boolean[] values = blArray;
        Hashtable CommandLineArgs = Utils.ParseCommandLine(args, options, values);
        if (!CommandLineArgs.containsKey("-r") && !CommandLineArgs.containsKey("-i")) {
            System.err.println("ERROR: Must specify an input file/directory or a chosen protein table");
            System.err.println(usageInfo);
            System.exit(0);
        }
        if (!(CommandLineArgs.containsKey("-c") && CommandLineArgs.containsKey("-p") && CommandLineArgs.containsKey("-g") && CommandLineArgs.containsKey("-o"))) {
            System.err.println("ERROR: Must specify the peptide column, a proteome file, a proteome GFF file, and an output file!");
            System.err.println(usageInfo);
            System.exit(0);
        }
        String inputDir = null;
        if (CommandLineArgs.containsKey("-r")) {
            inputDir = (String)CommandLineArgs.get("-r");
        }
        String chosenProteinFile = null;
        if (CommandLineArgs.containsKey("-i")) {
            chosenProteinFile = (String)CommandLineArgs.get("-i");
        }
        int column = Integer.parseInt((String)CommandLineArgs.get("-c"));
        String proteaseFile = (String)CommandLineArgs.get("-p");
        String gffFile = (String)CommandLineArgs.get("-g");
        String outputFile = (String)CommandLineArgs.get("-o");
        String translationFile = null;
        if (CommandLineArgs.containsKey("-t")) {
            translationFile = (String)CommandLineArgs.get("-t");
        }
        CreatePeptideGFF c = new CreatePeptideGFF(inputDir, column, proteaseFile, gffFile, outputFile, translationFile, chosenProteinFile);
        if (CommandLineArgs.containsKey("-q")) {
            col = Integer.parseInt((String)CommandLineArgs.get("-q"));
            if (col < 0) {
                ErrorThrower.ThrowError(4, "Column (-q) must be non-negative");
            }
            c.FASTANameCol = col;
        }
        if (CommandLineArgs.containsKey("-d")) {
            col = Integer.parseInt((String)CommandLineArgs.get("-d"));
            if (col < 0) {
                ErrorThrower.ThrowError(4, "Column (-d) must be non-negative");
            }
            c.GFFNameCol = col;
        }
        if (CommandLineArgs.containsKey("-v")) {
            c.debug = true;
        }
        if (c.debug) {
            System.out.println("Initialization complete");
        }
        c.create();
    }

    private void create() {
        if (this.debug) {
            System.out.println("Creating the gff...");
        }
        if (this.translationFile != null) {
            this.FASTA2GFFProteinName = ProteogenomicUtils.loadTranslationFile(this.translationFile, this.FASTANameCol, this.GFFNameCol);
            System.out.println("Loaded FASTA2GFF info for " + this.FASTA2GFFProteinName.size() + " proteins");
        }
        String[] peptides = this.loadPeptides();
        int i = 0;
        while (i < peptides.length) {
            peptides[i] = Utils.RemoveFlankingAAs(peptides[i]);
            ++i;
        }
        System.out.println("Loaded " + peptides.length + " distinct peptides");
        Hashtable peptideInfo = this.getPeptideGenomicCoords(peptides);
        this.writeGFFFile(peptideInfo, this.outputGFF);
    }

    private String[] loadPeptides() {
        if (this.peptideFileNames != null) {
            return Utils.LoadColumnFromFiles(this.peptideFileNames, "\t", this.column);
        }
        return ChooseProteins.loadPeptidesFromChosenFile(this.chosenProteinFileName);
    }
}

